/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ZEP_IO_TYPEDEF_H
#define _ZEP_IO_TYPEDEF_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             zep_io_typedef.h
 * DESCRIPTION:      Header file for zephyr io signals.c
 *
 **********************************************************************/


//Input/output parameter structures
typedef struct {
   uint16 TxTotal;
   uint16 RxTotal;
} Zephyr_Latencies;

typedef struct {

   uint8 uc_FCI_TX_GO;
   uint8   uc_FCI_RX_GO;
   uint8 uc_QT_TX_DONE;
   uint8   uc_ILV_TXDT_BUSY;
   uint8   uc_ILV_RXFC_AVAIL;
   uint8   uc_ILV_RXDT_BUSY0;
   uint8   uc_ILV_RXDT_BUSY1;
   uint8   uc_ILV_ON;
   uint8   uc_ILV_TX_SHALF_CTL0;
   uint8   uc_ILV_TX_SHALF_CTL1;
   uint8   uc_ILV_RX_SHALF_CTL0;
   uint8   uc_ILV_RX_SHALF_CTL1;
   uint16   us_QT_TX_PMD_BYTES0;
   uint16   us_QT_TX_PMD_BYTES1;

}  Zephyr_Input_t;

typedef struct {

   uint8 uc_FCI_TX_DONE;
   uint8 uc_FCI_RX_DONE;

   uint8 uc_FCI_RX_ON;
   uint8 uc_FCI_TX_ON;

   uint8 uc_FC_TX_ILV_LP;
   uint8 uc_FC_RX_ILV_LP;

   uint8   uc_FC_ILV_BUSY;
   uint8   uc_FC_DILV_BUSY;

   uint8   uc_FC_TX_SHALF_ENA;
   uint8   uc_FC_RX_SHALF_ENA;

   uint8 uc_FC_RX_PROC_DONE;

}  Zephyr_Output_t;

// Zephyr IO signals
extern Zephyr_Input_t  gt_ZEP_Input;
extern Zephyr_Output_t gt_ZEP_Output;



#endif //_ZEP_TYPEDEF_H    Do not add anything below this line.


