/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ZEP_MEMMAP_H
#define _ZEP_MEMMAP_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             zep_memmap.h
 * DESCRIPTION:      Memory map definition
 *
 **********************************************************************/

/**********************************************************************
* Sample Memory map for Zephyr RAM  blocks,
**********************************************************************/

// CW buffers are not currently mapped to the DSP memory, the following values are just for illustration
#define ZEP_RAM_RX_CW_ADDR          (0x23400) // dummy value

#define ZEP_RAM_RX_CW_SIZE              (512)

/**********************************************************************
 * Memory map for Global Zephyr registers
 **********************************************************************/

#define     ZEP_REG_BASE                (0xC200)

#define     ZEP_REG_START           (ZEP_REG_BASE)
#define     ZEP_REG_END             (ZEP_REG_ZR_CW_ERR_ADDR)

#define  ZEP_NUM_GREGS              (ZEP_REG_END-ZEP_REG_START+1)

/**********************************************************************
 * Memory map TX and RX PRAM Zephyr registers
 **********************************************************************/

// Definitions for overhead FIFOS
#define  NUM_FIFOS   3

#define BYTES_IN_TX_FIFO0  32
#define BYTES_IN_TX_FIFO1  32
#define BYTES_IN_TX_FIFO2  6

#define BYTES_IN_RX_FIFO0  32
#define BYTES_IN_RX_FIFO1  32
#define BYTES_IN_RX_FIFO2  6



//Tx Parameter RAM addresses



#define ZEP_REG_VERSION_ADDR              (ZEP_REG_START+0)
#define ZEP_REG_ZT_LINE_ADDR              (ZEP_REG_START + 1)
#define ZEP_REG_ZT_LP0_CFG_ADDR              (ZEP_REG_START + 2)
#define ZEP_REG_ZT_LP1_CFG_ADDR              (ZEP_REG_START + 3)
#define ZEP_REG_ZT_VBC0_SIZE_ADDR            (ZEP_REG_START + 4)
#define ZEP_REG_ZT_VBC1_SIZE_ADDR            (ZEP_REG_START + 5)
#define ZEP_REG_ZT_VBC0_IDX_ADDR          (ZEP_REG_START + 6)
#define ZEP_REG_ZT_VBC1_IDX_ADDR          (ZEP_REG_START + 7)
#define ZEP_REG_ZT_FRAME_IDX0_ADDR           (ZEP_REG_START + 8)
#define ZEP_REG_ZT_FRAME_IDX1_ADDR           (ZEP_REG_START + 9)
#define ZEP_REG_ZT_FRM_BYTE_ADDR          (ZEP_REG_START + 0xA)
#define ZEP_REG_ZT_CODEWORD_ADDR          (ZEP_REG_START + 0xB)
#define ZEP_REG_ZT_CW_IDX_ADDR               (ZEP_REG_START + 0xC)
#define ZEP_REG_ZT_LP0_MP_ADDR               (ZEP_REG_START + 0xD)
#define ZEP_REG_ZT_LP1_MP_ADDR               (ZEP_REG_START + 0xE)
#define ZEP_REG_ZT_TP0_ADDR                  (ZEP_REG_START + 0xF)
#define ZEP_REG_ZT_TP1_ADDR                  (ZEP_REG_START + 0x10)
#define ZEP_REG_ZT_SHALF_ADDR             (ZEP_REG_START + 0x11)
#define ZEP_REG_ZT_DZ_MAX_ADDR               (ZEP_REG_START + 0x12)
#define ZEP_REG_ZT_DZ_VAL_ADDR               (ZEP_REG_START + 0x13)
#define ZEP_REG_ZT_DZ_IDX_ADDR               (ZEP_REG_START + 0x14)
#define ZEP_REG_ZT_DRS_VAL_ADDR              (ZEP_REG_START + 0x15)
#define ZEP_REG_ZT_DRS_IDX_ADDR              (ZEP_REG_START + 0x16)
#define ZEP_REG_ZT_LP0_P_ADDR             (ZEP_REG_START + 0x17)
#define ZEP_REG_ZT_LP1_P_ADDR             (ZEP_REG_START + 0x18)
#define ZEP_REG_ZT_LP0_OHRATE_ADDR           (ZEP_REG_START + 0x19)
#define ZEP_REG_ZT_LP1_OHRATE_ADDR           (ZEP_REG_START + 0x1A)
#define ZEP_REG_ZT_EOC_ADDR                  (ZEP_REG_START + 0x1E)
#define ZEP_REG_ZT_VOC_ADDR                  (ZEP_REG_START + 0x1F)
#define ZEP_REG_ZT_AOC_ADDR                  (ZEP_REG_START + 0x20)
#define ZEP_REG_ZT_SYNC_CTRL_ADDR            (ZEP_REG_START + 0x21)
#define ZEP_REG_ZT_FIFO0_CTRL_ADDR           (ZEP_REG_START + 0x22)
#define ZEP_REG_ZT_FIFO0_BYTE_ADDR           (ZEP_REG_START + 0x23)
#define ZEP_REG_ZT_FIFO1_CTRL_ADDR           (ZEP_REG_START + 0x24)
#define ZEP_REG_ZT_FIFO1_BYTE_ADDR           (ZEP_REG_START + 0x25)
#define ZEP_REG_ZT_FIFO2_CTRL_ADDR           (ZEP_REG_START + 0x26)
#define ZEP_REG_ZT_FIFO2_BYTE_ADDR           (ZEP_REG_START + 0x27)
#define ZEP_REG_ZT_NTR_IBITS_ADDR            (ZEP_REG_START + 0x28)
#define ZEP_REG_ZT_SCR_LO0_ADDR              (ZEP_REG_START + 0x29)
#define ZEP_REG_ZT_SCR_LO1_ADDR              (ZEP_REG_START + 0x2A)
#define ZEP_REG_ZT_SCR_HI_ADDR               (ZEP_REG_START + 0x2B)
#define ZEP_REG_ZT_CRC_ADDR                  (ZEP_REG_START + 0x2C)
#define ZEP_REG_ZT_CHECKBYTE_ADDR            (ZEP_REG_START + 0x2D)
#define ZEP_REG_ZT_CBYTE0_0_ADDR          (ZEP_REG_START + 0x2E)
#define ZEP_REG_ZT_CBYTE0_1_ADDR          (ZEP_REG_START + 0x2F)
#define ZEP_REG_ZT_CBYTE0_2_ADDR          (ZEP_REG_START + 0x30)
#define ZEP_REG_ZT_CBYTE0_3_ADDR          (ZEP_REG_START + 0x31)
#define ZEP_REG_ZT_CBYTE0_4_ADDR          (ZEP_REG_START + 0x32)
#define ZEP_REG_ZT_CBYTE0_5_ADDR          (ZEP_REG_START + 0x33)
#define ZEP_REG_ZT_CBYTE0_6_ADDR          (ZEP_REG_START + 0x34)
#define ZEP_REG_ZT_CBYTE0_7_ADDR          (ZEP_REG_START + 0x35)
#define ZEP_REG_ZT_CBYTE1_0_ADDR          (ZEP_REG_START + 0x36)
#define ZEP_REG_ZT_CBYTE1_1_ADDR          (ZEP_REG_START + 0x37)
#define ZEP_REG_ZT_CBYTE1_2_ADDR          (ZEP_REG_START + 0x38)
#define ZEP_REG_ZT_CBYTE1_3_ADDR          (ZEP_REG_START + 0x39)
#define ZEP_REG_ZT_CBYTE1_4_ADDR          (ZEP_REG_START + 0x3A)
#define ZEP_REG_ZT_CBYTE1_5_ADDR          (ZEP_REG_START + 0x3B)
#define ZEP_REG_ZT_CBYTE1_6_ADDR          (ZEP_REG_START + 0x3C)
#define ZEP_REG_ZT_CBYTE1_7_ADDR          (ZEP_REG_START + 0x3D)

#define ZEP_TX_START_ADDRESS                    (ZEP_REG_VERSION_ADDR)
#define ZEP_TX_END_ADDRESS                      (ZEP_REG_ZT_CBYTE1_7_ADDR)

#define ZEP_REG_ZR_LINE_ADDR              (ZEP_REG_START + 0x60)
#define ZEP_REG_ZR_LP0_CFG_ADDR              (ZEP_REG_START + 0x61)
#define ZEP_REG_ZR_LP1_CFG_ADDR              (ZEP_REG_START + 0x62)
#define ZEP_REG_ZR_VBC0_SIZE_ADDR            (ZEP_REG_START + 0x63)
#define ZEP_REG_ZR_VBC1_SIZE_ADDR            (ZEP_REG_START + 0x64)
#define ZEP_REG_ZR_VBC0_IDX_ADDR          (ZEP_REG_START + 0x65)
#define ZEP_REG_ZR_VBC1_IDX_ADDR          (ZEP_REG_START + 0x66)
#define ZEP_REG_ZR_FRAME_IDX0_ADDR           (ZEP_REG_START + 0x67)
#define ZEP_REG_ZR_FRAME_IDX1_ADDR           (ZEP_REG_START + 0x68)
#define ZEP_REG_ZR_FRM_BYTE_ADDR          (ZEP_REG_START + 0x69)
#define ZEP_REG_ZR_CODEWORD_ADDR          (ZEP_REG_START + 0x6A)
// unused
#define ZEP_REG_ZR_LP0_MP_ADDR               (ZEP_REG_START + 0x6C)
#define ZEP_REG_ZR_LP1_MP_ADDR               (ZEP_REG_START + 0x6D)
#define ZEP_REG_ZR_MDF_CNT_ADDR              (ZEP_REG_START + 0x6E)
#define ZEP_REG_ZR_TP0_ADDR                  (ZEP_REG_START + 0x6F)
#define ZEP_REG_ZR_TP1_ADDR                  (ZEP_REG_START + 0x70)
#define ZEP_REG_ZR_DZ_MAX_ADDR               (ZEP_REG_START + 0x71)
#define ZEP_REG_ZR_DZ_VAL_ADDR               (ZEP_REG_START + 0x72)
#define ZEP_REG_ZR_DZ_IDX_ADDR               (ZEP_REG_START + 0x73)
#define ZEP_REG_ZR_DR_VAL_ADDR               (ZEP_REG_START + 0x74)
#define ZEP_REG_ZR_DR_IDX_ADDR               (ZEP_REG_START + 0x75)
#define ZEP_REG_ZR_LP0_OHRATE_ADDR                (ZEP_REG_START + 0x76)
#define ZEP_REG_ZR_LP1_OHRATE_ADDR                (ZEP_REG_START + 0x77)
// unused
#define ZEP_REG_ZR_EOC_ADDR                  (ZEP_REG_START + 0x7E)
#define ZEP_REG_ZR_VOC_ADDR                  (ZEP_REG_START + 0x7F)
#define ZEP_REG_ZR_AOC_ADDR                  (ZEP_REG_START + 0x80)
#define ZEP_REG_ZR_FIFO0_CTRL_ADDR           (ZEP_REG_START + 0x81)
#define ZEP_REG_ZR_FIFO0_BYTE_ADDR           (ZEP_REG_START + 0x82)
#define ZEP_REG_ZR_FIFO1_CTRL_ADDR           (ZEP_REG_START + 0x83)
#define ZEP_REG_ZR_FIFO1_BYTE_ADDR           (ZEP_REG_START + 0x84)
#define ZEP_REG_ZR_FIFO2_CTRL_ADDR           (ZEP_REG_START + 0x85)
#define ZEP_REG_ZR_FIFO2_BYTE_ADDR           (ZEP_REG_START + 0x86)
#define ZEP_REG_ZR_DSCR_LO1_ADDR          (ZEP_REG_START + 0x87)
#define ZEP_REG_ZR_DSCR_LO0_ADDR          (ZEP_REG_START + 0x88)
#define ZEP_REG_ZR_DSCR_HI_ADDR              (ZEP_REG_START + 0x89)
#define ZEP_REG_ZR_CRC_ADDR                  (ZEP_REG_START + 0x8A)
#define ZEP_REG_ZR_CRC_CNT_ADDR              (ZEP_REG_START + 0x8B)
#define ZEP_REG_ZR_CHECKBYTE_ADDR            (ZEP_REG_START + 0x8C)
#define ZEP_REG_ZR_CW_COUNT_ADDR          (ZEP_REG_START + 0x8D)
#define ZEP_REG_ZR_FEC1_CNT_ADDR          (ZEP_REG_START + 0x8E)
#define ZEP_REG_ZR_FEC0_CNT_ADDR          (ZEP_REG_START + 0x8F)
#define ZEP_REG_ZR_DCUR_CWADR_ADDR           (ZEP_REG_START + 0x90)
#define ZEP_REG_ZR_RXIB_ADDR              (ZEP_REG_START + 0x91)
#define ZEP_REG_ZR_DECSTAT0_LP1_ADDR         (ZEP_REG_START + 0x92)
#define ZEP_REG_ZR_DECSTAT1_LP1_ADDR         (ZEP_REG_START + 0x93)
#define ZEP_REG_ZR_DECSTAT0_LP0_ADDR         (ZEP_REG_START + 0x94)
#define ZEP_REG_ZR_DECSTAT1_LP0_ADDR         (ZEP_REG_START + 0x95)
#define ZEP_REG_ZR_CW_ERR_ADDR               (ZEP_REG_START + 0x96)
#define ZEP_REG_ZR_NTRSRCFR_ADDR                (ZEP_REG_START + 0x97)
#define ZEP_REG_ZR_NTRCNT_ADDR                  (ZEP_REG_START + 0x98)
#define ZEP_REG_ZR_NTRSTEP_ADDR                 (ZEP_REG_START + 0x99)

#define ZEP_RX_START_ADDRESS                    (ZEP_REG_ZR_LINE_ADDR)
#define ZEP_RX_END_ADDRESS                      (ZEP_REG_ZR_NTRSTEP_ADDR)

#define ZEP_REG_NUM_TX_WORDS              (ZEP_TX_END_ADDRESS-ZEP_TX_START_ADDRESS+1)

#define ZEP_REG_NUM_RX_WORDS              (ZEP_RX_END_ADDRESS-ZEP_RX_START_ADDRESS+1)


#endif //_ZEP_MEMMAP_H  Do not add anything below this line.


