/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ZEP_PRIVATE_H
#define _ZEP_PRIVATE_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             zep_private.h
 * DESCRIPTION:      Header file declaring Zephyr's internal functions
 *             None of these files are visible in the API
 **********************************************************************/

// Operation mode definitions...
#define TS_MODE         0
#define CASCADE_MODE 1
#define REG_START_MODE  2

// clock.c

void Zep_SetLatencies(Zephyr_Latencies *Zep_Latencies);
void ResetSignals(void);

// crc.c
void CRC_Generate(int16 s_lp);
void CRC_Check(int16 s_lp, uint8 uc_Byte);

// framer.c
void Framer(int16 s_lp);
void Deframer(Zephyr_Output_t *pt_ZEPOutput, int16 s_lp);
void RxEocHandlerInit(void);

// interleave.c
extern void WriteToInterleaveBuffer(int16 s_lp, uint8 uc_Byte);
extern uint8 ReadFromInterleaveBuffer(int16 s_lp);

// register.c
void ResetPortRegisters(t_ZepTxRegisters *Zep_Tx_Registers, t_ZepRxRegisters *Zep_Rx_Registers);
void ResetRegisters(void);

// rs_dec.c
void ReedSolomonDetect(int16 s_lp);
void ReedSolomonCorrect(int16 s_lp);

// rs_enc.c
void ReedSolomonEncode(int16 s_lp);

// rx.c
/* Call to process one Rx Zephyr clock cycle. */
int32 ZEP_Clock_Rx(Zephyr_Input_t t_ZEPInput, Zephyr_Output_t *pt_ZEPOutput);

int32 ZEP_Initialize_Rx();

void ResetRxState(void);

// scramble.c
void ScrambleFrame(int16 s_lp);
void DescrambleFrame(int16 s_lp);
void DescrambleByte(int16 s_lp, uint8 *uc_Byte);
uint8 ProcessRxADSLOverHeadByte(int16 s_lp, uint8 uc_Byte);
void updateBisRxFramingCounters(int16 s_lp);
void updateBisRxTpCounters(int16 s_lp);

void DeFrameBis(int16 s_lp, uint8 uc_Byte);

uint8 FrameBisMuxFrame(int16 s_lp);

uint8 getVDSLOverHeadByte(int16 s_lp);
uint8 getADSLOverHeadByte(int16 s_lp);

uint8 FrameVDSL1(uint16 u_Size, uint16 s_lp);

void crcGenerate(uint8 uc_Byte, uint16 s_lp);

void ScrambleByte(uint8 *puc_Byte, uint16 s_lp);

void ReedSolomonEncode_AccumCheckBytes(uint8 uc_Byte, uint16 s_lp);

void updateBisTxFramingCounters(int16 s_lp);

void DeFrameVDSL1(int16 s_lp, uint8 uc_Byte, uint16);

// tx.c
/* Call to process one Zephyr clock cycle. */
int32 ZEP_Clock_Tx(Zephyr_Input_t t_ZEPInput, Zephyr_Output_t *pt_ZEPOutput);

int32 ZEP_Initialize_Tx();

void ResetTxState(void);

// zephyr.c
int32 ZEP_ClockTxFrame(void);
int32 ZEP_ClockRxFrame(void);

extern  int32 ZEP_ILV_GetByteFromRxDILVB(int16 s_lp, uint8 *puc_byte);

extern  int32 ZEP_ILV_PutByteToTxILVB(int16 s_lp, uint8 uc_byte);

extern uint8 ReadBytesUnframed(int16 s_lp);

extern void WriteBytesUndeframed(int16 s_lp, uint8 uc_Byte);

extern uint8 DSP_GetByteFromFifo(int16 s_FifoNumber);

extern void DSP_PutByteInFifo(int16 s_FifoNumber, uint8 uc_byte);

extern uint8 FrameFastMuxFrame();

extern uint8 FrameInterleaveMuxFrame();

void DeframeFastMuxFrame(int16 s_lp, uint8 uc_Byte);

void DeframeInterleaveMuxFrame(int16 s_lp, uint8 uc_Byte);

void DeframeFastMuxFrame_CPE(int16 s_lp, uint8 uc_Byte);

void DeframeIlvMuxFrame_CPE(int16 s_lp, uint8 uc_Byte);

uint8 Zep_TxAocHandler(void);
void Zep_RxAocHandler(uint8 uc_AOCdata);

#endif // _ZEP_PRIVATE_H
