/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ZEP_TYPEDEF_H
#define _ZEP_TYPEDEF_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             register.h
 * DESCRIPTION:      Header file for register.c
 *
 **********************************************************************/

#include "zep_const.h"
#include "zep_memmap.h"

#ifndef _BASIC_TYPES
#define _BASIC_TYPES

typedef void  (*PtrToFunc)(void);
/* Variable type definitions */
typedef double float64;          /* prefix d in hungarian notation */
typedef long  int32;             /* prefix l */
typedef char  int8;              /* prefix c */
typedef short int16;          /* prefix s */
typedef unsigned char uint8;     /* prefix uc */
typedef unsigned long uint32;    /* prefix ul */
typedef unsigned short uint16;      /* prefix us */
typedef unsigned long Float32;      /* prefix f */
typedef unsigned char FlagT;     /* prefix ft */

#endif // _BASIC_TYPES


typedef struct {

//////////////
// Tx
//////////////

// Version Addr
   uint8   MajorVersion;
   uint8   MinorVersion;

// Tx_LINE
   uint8   Tx_Shalf_Ctl;
   uint8 Tx_LS0IsAS1;
   uint8 Tx_NtrEnable;
   uint8 Tx_IbitsLP;
   uint8   Tx_BC_Enable[NUM_BC];
   uint8 Tx_BC_BufferSelect[NUM_BC];
   uint16  Tx_CO_Mode;
   uint8 Tx_FrameMode;

// ZT_LPn_LPG

   uint8   Tx_Px_Latch_Ena[NUM_LP];
   uint8 Tx_Clear_CRC[NUM_LP];
   uint8 Tx_Bad_CRC[NUM_LP];
   uint8 Tx_CRC_Enable[NUM_LP];
   uint8 Tx_ScramblerEnable[NUM_LP];
   uint8 Tx_SEQpDone[NUM_LP];
   uint8   Tx_LP_Enable[NUM_LP];

// ZT_VBC_SIZE
   uint16  Tx_VBC_Size[NUM_BC];

//ZT_VBC_IDX
   uint16  Tx_VBC_Idx[NUM_BC];

// ZT_FRAME_IDX
   uint16   Tx_MaxFrameIndex[NUM_LP];
   uint16   Tx_NextFrameIndex[NUM_LP];

// ZT_FRM_BYTE
   uint8 Tx_Sync_Byte;
   uint8 Tx_Frm_Byte;

// ZT_CODEWORD
   uint8 Tx_CWSize[NUM_LP];

// ZT_CW_IDX
   uint16   Tx_CurrentCWIndex[NUM_LP];

// ZT_LP_MP
   uint8 Tx_CurSymbolCnt[NUM_LP];
   uint8 Tx_SymbolsPerCW[NUM_LP];

// ZT_TP
   uint16   Tx_Tp[NUM_LP];
   uint16   Tx_TpCount[NUM_LP];

//ZT_SHALF
   uint8   Tx_ZTShalf[NUM_LP];

//ZT_DZ_MAX
   uint8   Tx_Dz_Max[NUM_LP];

//ZT_DZ_VAL
   uint8   Tx_Dz_Val[NUM_LP];

//ZT_DZ_IDX
   uint8   Tx_Dz_Idx[NUM_LP];

//ZT_DRS_VAL
   uint8   Tx_DRVal[NUM_LP];

//ZT_DRS_IDX
   uint8   Tx_DRIdx[NUM_LP];

//ZT_P
   uint16  Tx_P[NUM_LP];

//ZT_U
    uint16  Tx_U[NUM_LP];

//ZT_U_IDX
   uint16  Tx_UIdx[NUM_LP];

//ZT_OHRATE
   uint16  Tx_OHSwitch[NUM_LP];
   uint8   Tx_OH2Rate[NUM_LP];
   uint8   Tx_OH1Rate[NUM_LP];

//ZT_EOC
   uint8   Tx_EOC_Lp;
   uint8   Tx_EOC_Size;
   uint8   Tx_EOC_Idx;

//ZT_VOC
   uint8   Tx_VOC_Size;
   uint8   Tx_VOC_Idx;

//ZT_AOC
   uint8 Tx_AOC_Data;
   uint8 Tx_AOC_Sent;

// TX_SYNC_CTRL
   uint8 Tx_Sync_Data;
   uint8 Tx_Sync_Sent;

//Tx_FIFO_CTRL
   uint8 Tx_IdleByte[NUM_FIFOS];
   uint8 Tx_ValidBytes[NUM_FIFOS];

// TX_FIFO_BYTES
   uint8 Tx_FifoBytes[NUM_FIFOS];

// TX_NTR_BITS
   uint8   Tx_NtrIbits;
   uint8   Tx_LtrFreqSel;

// Tx_SCR_LO
   uint16   Tx_Scrambler_Lo[NUM_LP];

// Tx_SCR_HI
   uint8 Tx_Scrambler_Hi[NUM_LP];

   // Tx_CRC
   uint8 Tx_CRC[NUM_LP];

// Tx_CHECKBYTE
   uint8 Tx_CheckByteSize[NUM_LP];

// Tx_CByte(0-15)
   uint8 Tx_CheckByte[NUM_LP][RS_CHECKBYTES];

} t_ZepTxRegisters;

typedef struct {
//////////////
// Rx
//////////////

// ZR_LINE
   uint8   Rx_LS0IsAS1;
   uint8 Rx_KeepSync;
   uint8 Rx_IbitsLP;
   uint8   Rx_BC_Enable[NUM_BC];
   uint8 Rx_BC_BufferSelect[NUM_BC];
   uint8   Rx_CO_Mode;
   uint8 Rx_FrameMode;
   uint8   Rx_CpeNtrEna;
   uint8   Rx_NtrUpdate;
   uint8   Rx_FifoOV;

// ZR_LPn_LPG
   uint8 Rx_Clear_CRC[NUM_LP];
   uint8 Rx_CRC_Enable[NUM_LP];
   uint8 Rx_ScramblerEnable[NUM_LP];
   uint8 Rx_SEQpDone[NUM_LP];
   uint8   Rx_LP_Enable[NUM_LP];

// ZR_VBC_SIZE
   uint16  Rx_VBC_Size[NUM_BC];

//ZR_VBC_IDX
   uint16  Rx_VBC_Idx[NUM_BC];

// ZR_FRAME_IDXI
   uint16   Rx_MaxFrameIndex[NUM_LP];
   uint16   Rx_NextFrameIndex[NUM_LP];

// ZR_FRM_BYTE
   uint8 Rx_Sync_Byte;
   uint8 Rx_Frm_Byte;

// ZR_CODEWORD
   uint8 Rx_CWSize[NUM_LP];

// ZR_MP
   uint8 Rx_CurSymbolCnt[NUM_LP];
   uint8 Rx_SymbolsPerCW[NUM_LP];

//ZR_MDF_CNT
   uint8   Rx_MdfCnt[NUM_LP];

// ZR_TP
   uint16   Rx_Tp[NUM_LP];
   uint16   Rx_TpCount[NUM_LP];

//ZR_DZ_MAX
   uint8   Rx_Dz_Max[NUM_LP];

//ZR_DZ_VAL
   uint8   Rx_Dz_Val[NUM_LP];

//ZR_DZ_IDX
   uint8   Rx_Dz_Idx[NUM_LP];

//ZR_DRS_VAL
   uint8   Rx_DRVal[NUM_LP];

//ZR_DRS_IDX
   uint8   Rx_DRIdx[NUM_LP];

   //ZR_OHRATE
   uint16  Rx_OHSwitch[NUM_LP];
   uint8   Rx_OH2Rate[NUM_LP];
   uint8   Rx_OH1Rate[NUM_LP];
//ZR_P
   uint16  Rx_P[NUM_LP];

//ZR_EOC
   uint8   Rx_EOC_Lp;
   uint8   Rx_EOC_Size;
   uint8   Rx_EOC_Idx;

//ZR_VOC
   uint8   Rx_VOC_Size;
   uint8   Rx_VOC_Idx;

//ZR_AOC
   uint8 Rx_AOC_Data;
   uint8 Rx_AOC_Valid;

//ZR_FIFO_CTRL
   uint8 Rx_ValidBytes[NUM_FIFOS];
   uint8 Rx_Overflow[NUM_FIFOS];

// ZR_FIFO_BYTES
   uint8 Rx_FifoBytes[NUM_FIFOS];

// ZR_DSCR_ILO
   uint16   Rx_Descrambler_Lo[NUM_LP];

// ZR_DSCR_HI
   uint8 Rx_Descrambler_Hi[NUM_LP];

// ZR_CRC
   uint8 Rx_CRC[NUM_LP];

// ZR_CRC_CNT
   uint8 Rx_CRC_Count[NUM_LP];

// ZR_CHECKBYTE
   uint8 Rx_CheckByteSize[NUM_LP];

// ZR_CW_COUNT
  uint16 Rx_CW_Count[NUM_LP];

// ZR_FEC_CNT
  uint16  Rx_FEC_Corr[NUM_LP];
  uint16  Rx_FEC_UnCorr[NUM_LP];


// ZR_DCUR_CWADR
   uint8 Rx_CurrCWAddr[NUM_LP];

// ZR_RXIB
   uint8 Rx_FarEndBlockErr[NUM_LP];
   uint8 Rx_FarEndCorrCnt[NUM_LP];
   uint16   Rx_RXIB_Unused;

// ZR_DECSTAT
   uint8 Rx_RSDecode_CFRoots[NUM_LP][2];
   uint8 Rx_RSDecode_BMError[NUM_LP][2];
   uint8 Rx_RSDecode_CWStatus[NUM_LP][2];

// ZR_CW_ERR
   uint8 Rx_CW_Corrected[NUM_LP];
   uint8 Rx_CW_Uncorrectable[NUM_LP];
   uint8 Rx_CW_Done[NUM_LP];

//ZR_U
   uint16  Rx_U[NUM_LP];

//ZR_U_IDX
   uint16  Rx_U_Idx[NUM_LP];

    uint32  Rx_NtrSRCFr;

   uint16  rx_NtrCnt;

   uint16  rx_NtrStep;

} t_ZepRxRegisters;




#endif //_ZEP_TYPEDEF_H    Do not add anything below this line.


