/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: bcr_const.h
*
*   This file contains constant definitions for the BCR BM
*
*-------------------------------------------------------------------------------
*/

#ifndef _BCR_CONST_H
#define _BCR_CONST_H

#ifndef TRUE
#define TRUE      (1)
#endif
#ifndef FALSE
#define FALSE     (0)
#endif

#define BCR_TX_LATENCY     (3)
#define BCR_RX_LATENCY     (5)

#define     TXSTATE_WAIT_FOR_START    (0)
#define     PROCESS_EBC               (1)
#define     PROCESS_ABC0         (2)
#define     PROCESS_ABC1         (3)
#define     PROCESS_DONE              (4)

#define     RXSTATE_WAIT_FOR_START    (0)

#define     ABC0                      (0x1)
#define     ABC1                      (0x2)
#define     EBC                       (0x3)

// Byte enable masks
#define BCR_NO_BYTE_EN        (0x0)
#define BCR_BYTE0_EN       (0x1)
#define BCR_BYTE1_EN       (0x2)
#define BCR_BYTE2_EN       (0x4)
#define BCR_BYTE3_EN       (0x8)
#define BCR_LOWER_WORD_EN     (BCR_BYTE1_EN | BCR_BYTE0_EN)
#define BCR_UPPER_WORD_EN     (BCR_BYTE3_EN | BCR_BYTE2_EN)
#define BCR_LONGWORD_EN       (BCR_UPPER_WORD_EN | BCR_LOWER_WORD_EN)

// Byte masks
#define BCR_BYTE0_MASK        (0x000000FF)
#define BCR_BYTE1_MASK        (0x0000FF00)
#define BCR_BYTE2_MASK        (0x00FF0000)
#define BCR_BYTE3_MASK        (0xFF000000)
#define BCR_LOWER_WORD_MASK      (BCR_BYTE1_MASK | BCR_BYTE0_MASK)
#define BCR_UPPER_WORD_MASK      (BCR_BYTE3_MASK | BCR_BYTE2_MASK)
#define BCR_LONGWORD_MASK     (BCR_UPPER_WORD_MASK | BCR_LOWER_WORD_MASK)


#endif //_BCR_CONST_H
