/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: bcr_io_typedef.h
*
*   This file contains type definitions used by different files.
*
*-------------------------------------------------------------------------------
*/


#ifndef _BCR_IO_TYPEDEF_H
#define _BCR_IO_TYPEDEF_H


// Structure used for BCR input signals
typedef struct {

   uint8 uc_FC_TX_VBC1_SEL;
   uint8 uc_FC_TX_BYTE_REQ;
   uint8 uc_AAI_TX_ACK;
   uint8 uc_AAI_TX_DATA;
   uint8 uc_PTM_TX_DATA;
   uint8 uc_PTM_TX_ACK;

   uint8 uc_FC_RX_VBC1_SEL;
   uint8 uc_FC_RX_PUT_BYTE;
   uint8 uc_AAI_RX_ACK;
   uint8 uc_FC_RX_DATA;
   uint8 uc_PTM_RX_ACK;

   uint8 uc_CRI_TX_BCR_GO;
   uint8 uc_CRI_RX_BCR_GO;

} BCR_Input_t;

// Structure used for BCR output signals
typedef struct {
   uint8 uc_BCR_TX_ACK;
   uint8 uc_AAI_TX_BYTE_REQ;
   uint8 uc_PTM_TX_BYTE_REQ;
   uint8 uc_AAI_TX_BC1_SEL;
   uint8 uc_BCR_TX_DATA;

   uint8 uc_BCR_RX_ACK;
   uint8 uc_AAI_RX_BC1_SEL;
   uint8 uc_AAI_RX_DATA;
   uint8 uc_PTM_RX_DATA;
   uint8 uc_AAI_RX_PUT_BYTE;
   uint8 uc_PTM_RX_PUT_BYTE;

   uint8 uc_BCR_TX_DONE_INT;
   uint8 uc_BCR_RX_DONE_INT;

} BCR_Output_t;

// Structure used for BCR latencies
typedef struct {
   uint8 us_TX_BCR;
   uint8 us_RX_BCR;

} BCR_Latencies_t;


// Zephyr IO signals
extern BCR_Input_t  gt_BCR_Input;
extern BCR_Output_t gt_BCR_Output;

#endif // _BCR_IO_TYPEDEF_H
