/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: bcr_memmap.h
*
*   This file contains BCR BM memory map.
*
*-------------------------------------------------------------------------------
*/

#ifndef _BCR_MEMMAP_H
#define _BCR_MEMMAP_H


#define BCR_RAM_TX_FRAMEBUF_SIZE            (416)    // 32 bit words
#define BCR_RAM_RX_FRAMEBUF_SIZE            (416)

#define BCR_MIN_RAM_ID                      (1)
#define BCR_MAX_RAM_ID                      (2)

#define BCR_RAM_TX_FRAMEBUF                 (1)
#define BCR_RAM_RX_FRAMEBUF                 (2)

//==============================================================================
// BCR Memory Map
//==============================================================================

#define BCR_RAM_TX_FRAMEBUF_ADDR        (0x23000)
#define BCR_RAM_RX_FRAMEBUF_ADDR        (0x23200)

//==============================================================================
// BCR Register Map
//==============================================================================
#define  BCR_REG_BASE_ADDR          (0xC180)

#define BCR_TX_REG_BASE_ADDR                (BCR_REG_BASE_ADDR)
// Tx Registers
#define  BCR_BT_CFG_ADDR                  (BCR_REG_BASE_ADDR+0x00)
#define  BCR_BT_VBC_MAP_ADDR              (BCR_REG_BASE_ADDR+0x01)
#define  BCR_BT_ABC0_WR_ADDR              (BCR_REG_BASE_ADDR+0x02)
#define  BCR_BT_ABC1_WR_ADDR              (BCR_REG_BASE_ADDR+0x03)
#define  BCR_BT_VBC_RD_ADDR               (BCR_REG_BASE_ADDR+0x04)

#define BCR_RX_REG_BASE_ADDR                (BCR_REG_BASE_ADDR+0x8)

// Rx Registers
#define  BCR_BR_CFG_ADDR                  (BCR_RX_REG_BASE_ADDR+0x00)
#define  BCR_BR_VBC_MAP_ADDR              (BCR_RX_REG_BASE_ADDR+0x01)
#define  BCR_BR_ABC0_RD_ADDR              (BCR_RX_REG_BASE_ADDR+0x02)
#define  BCR_BR_ABC1_RD_ADDR              (BCR_RX_REG_BASE_ADDR+0x03)
#define  BCR_BR_VBC_WR_ADDR               (BCR_RX_REG_BASE_ADDR+0x04)


#define BCR_TX_NUM_GREGS                     (5)

#define BCR_RX_NUM_GREGS                     (5)

#define BCR_NUM_GREGS                        (10)

#endif // _BCR_MEMMAP_H
