/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: bcr_private.h
*
*   This file contains private functions and variables which are visible
*   by the BCR BM only.
*
*-------------------------------------------------------------------------------
*/

#ifndef _BCR_PRIVATE_H
#define _BCR_PRIVATE_H

#include "bcr_typedef.h"
#include "bcr_const.h"
#include "bcr_memmap.h"

//==============================================================================
// bcr private variables
//==============================================================================


extern BCRTxRegisters_t gt_BCR_Tx_Registers;
extern BCRRxRegisters_t gt_BCR_Rx_Registers;
extern BCR_Latencies_t   gt_BCR_Latencies;

extern uint32  BCR_RAM_Tx_FrameBuffer[BCR_RAM_TX_FRAMEBUF_SIZE];
extern uint32  BCR_RAM_Rx_FrameBuffer[BCR_RAM_RX_FRAMEBUF_SIZE];

extern uint8 *BCR_RAM_VirtualBaseAddr[BCR_MAX_RAM_ID+1];

extern int32 BCR_Clock_Tx(BCR_Input_t *pt_BCRInput, BCR_Output_t *pt_BCROutput);

extern int32 BCR_Clock_Rx(BCR_Input_t *pt_BCRInput, BCR_Output_t *pt_BCROutput);

extern uint8 GetATMByteBC0(uint8 *intr);

extern uint8 GetATMByteBC1(uint8 *intr);

extern void ForceCellDecision(void);

extern uint8 PutATMByteBC0(uint8 uc_byte);

extern uint8 PutATMByteBC1(uint8 uc_byte);

extern void RxForceCellDecision(void);

#endif // _BCR_PRIVATE_H
