/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: bcr_typedef.h
*
*   This file contains type definitions used by different files.
*
*-------------------------------------------------------------------------------
*/

#ifndef _BCR_TYPEDEF_H
#define _BCR_TYPEDEF_H

#ifndef _BASIC_TYPES
#define _BASIC_TYPES
// variable type definitions
typedef double           float64;     //prefix d in hungarian notation
typedef int              int32;       //prefix l
typedef char             int8;        //prefix c
typedef short            int16;       //prefix s
typedef unsigned char    uint8;       //prefix uc
typedef unsigned int     uint32;      //prefix ul
typedef unsigned short   uint16;      //prefix us
typedef unsigned int     Float32;     //prefix f
typedef unsigned char    FlagT;       //prefix ft
typedef unsigned short   bool;        //prefix b
#endif // _BASIC_TYPES

// define 64-bit accumulator type
#ifdef UNIX_PLATFORM
#define acc long long
#else
#ifdef MSVC_ONLY
#define acc __int64
#else
#define acc long
#endif
#endif

// Structure used for BCR registers
typedef struct {

   //BT_CFG
   uint8 Tx_FB_EBC_Enable;   // 1 = frame buffer mode, 0, direct
   uint8 Tx_FB_ABC0_Enable;
   uint8 Tx_FB_ABC1_Enable;
   uint8   Tx_Mode;

   //BT_VBC_MAP
   uint8 Tx_VBC0_Map;
   uint8   Tx_VBC1_Map;

   //BT_ABC0_WR
   uint16   Tx_ABC0_Base;
   uint16  Tx_ABC0_Bytes;

   //BT_ABC1_WR
   uint16   Tx_ABC1_Base;
   uint16   Tx_ABC1_Bytes;

   //BT_VBC_RD
   uint16   Tx_VBC0_Rd;
   uint16   Tx_VBC1_Rd;

} BCRTxRegisters_t;

// Structure used for BCR registers
typedef struct {

   //BR_CFG
   uint8 Rx_FB_EBC_Enable;   // 1 = frame buffer mode, 0, direct
   uint8 Rx_FB_ABC0_Enable;
   uint8 Rx_FB_ABC1_Enable;
   uint8   Rx_Mode;

   //BR_VBC_MAP
   uint8 Rx_VBC0_Map;
   uint8   Rx_VBC1_Map;

   //BR_ABC0_WR
   uint16   Rx_ABC0_Base;
   uint16  Rx_ABC0_Bytes;

   //BR_ABC1_WR
   uint16   Rx_ABC1_Base;
   uint16   Rx_ABC1_Bytes;

   //BR_VBC_RD
   uint16   Rx_VBC0_Wr;
   uint16   Rx_VBC1_Wr;

} BCRRxRegisters_t;


#endif // _BCR_TYPEDEF_H
