/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: cri_io_typedef.h
*
*   This file contains CRI I/O type definitions used by other BMs.
*
*-------------------------------------------------------------------------------
*/

#ifndef _CRI_IO_TYPEDEF_H
#define _CRI_IO_TYPEDEF_H

// Signals to CRI
typedef struct {

   // Clocks and Resets
   uint8 uc_dspRstn;       // Active Low Hard Reset Signal
   uint8   uc_pllClk;           // Master clock to produce all the other clocks in the cores.
   uint8   uc_afeifRegWrClkEna; // AFE interface DSP bus reg write clock enable.
   uint8   uc_aaiRegWrClkEna;   // Alphaeus DSP bus reg write clock enable.
   uint8   uc_ftRegWrClkEna;    // Iridia FT DSP bus reg write clock enable.
   uint8   uc_pmsRegWrClkEna;   // PMS layer DSP bus reg write clock enable.
   uint8   uc_ptmRegWrClkEna;   // Electra PTM DSP bus reg write clock enable.
   uint8   uc_qtRegWrClkEna;    // Iridia QT DSP bus reg write clock enable.
    uint8   uc_vfdfRegWrClkEna;  // Strymon VDSL/ADSL DSP bus reg write clock enable.
    uint8   uc_ltrRegWrClkEna;   // Local timing reference clock enable.

   // uint8 uc_dspClk;        // DSP Clock -- Source clock for all other clocks


   // Control and Peripheral Bus Interface
    uint8   uc_dspCriSel;
    uint8   uc_dspWrite;
   uint8   uc_arcDspClkEna;     // ARC DSP clock enable
   uint8   uc_coreClkEna;       // ARC Core registers write clock enable.

   // Alphaeus Interface
   uint8 uc_aaiTxClav;
   uint8 uc_aaiTxStatus;
   uint8 uc_aaiRxClav;
   uint8 uc_aaiRxStatus;
   uint8   uc_aaiTxClkEna;      // Alphaeus gated TX clock enable
   uint8   uc_aaiRxClkEna;      // Alphaeus gated RX clock enable
   uint8   uc_axtcTxDone;
   uint8   uc_axtcRxDone;

   // Elektra Interface
    uint8   uc_ptmTxClkEna;      // Elektra PTM gated TX clock enable.
    uint8   uc_ptmRxClkEna;      // Elektra PTM gated RX clock enable.

   // Bearer Channel Router Interface
    uint8   uc_bcrTxDone;
    uint8   uc_bcrRxDone;

   // Zephyr Interface
   uint8 uc_fcTxDone;
   uint8 uc_fcRxDone;
   uint8 uc_pmsTxClkEna;
   uint8 uc_pmsRxClkEna;
   uint8   uc_fcNtrInt;

   // Iridia-QT Interface
   uint8 uc_qtTxDone;
   uint8 uc_qtRxDone;
   //uint8  uc_qtTxClkGate;
   //uint8  uc_qtRxClkGate;
   uint8 uc_qtTxBATError;
   uint8 uc_qtRxBATError;
   uint8 uc_qtMfdqClkEna;
   uint8 uc_qtViterbiClkEna;
    uint8   uc_qtTxClkEna;    // Iridia QT Transmit processing clock enable.
   uint8 uc_qtTxHsClkEna;  // Iridia QT Transmit high speed processing clock enable.
    uint8   uc_qtRxClkEna;    // Iridia QT Receive processing clock enable.
   uint8 uc_qtRxHsClkEna;  // Iridia QT Receive high speed processing clock enable.

   // Iridia-FT Interface
   uint8 uc_ftTxFrame;
   uint8 uc_ftIfftDone;
   uint8 uc_ftPreDone;
   uint8   uc_ftParrDone;
   uint8   uc_ftRxFrame;
   uint8   uc_ftFftDone;
   uint8   uc_ftPstDone;
   //uint8  uc_ftTxClkGate;
   //uint8  uc_ftRxClkGate;
   uint8 uc_ftParrClkEna;  // Iridia FT PARR processing clock enable.
    uint8   uc_ftTxClkEna;    // Iridia FT Transmit processing clock enable.
    uint8   uc_ftRxClkEna;    // Iridia FT Receive processing clock enable.

   // Strymon Interface
   uint8 uc_fdfDecDone;
   uint8 uc_fdfAfeBusy;
   //uint8  uc_fdfClkGate;
    //uint8 uc_fdfScClkGate;
    //uint8 uc_vfdfClkGate;
    uint8   uc_fdfClkEna;     // Strymon ADSL CPE processing clock enable.
    uint8   uc_fdfSrcClkEna;  // Strymon ADSL CPE SRC processing clock enable.
    uint8   uc_vfdfAfeDecimClkEna;  // Strymon ADSL CO AFE Decimator processing clock enable.
    uint8   uc_vfdfDecimClkEna;     // Strymon ADSL CO Decimator processing clock enable.
    uint8   uc_vfdfDecTdqClkEna;    // Strymon VDSL/ADSL CO DEC/TDQ processing clock enable.
    uint8   uc_vfdfInterpClkEna;    // Strymon ADSL CO Interpolator processing clock enable.
    uint8   uc_vfdfRxIIRClkEna;     // Strymon VDSL/ADSL CO Rx IIR processing clock enable.
    uint8   uc_vfdfSrcClkEna;       // Strymon VDSL SRC processing clock enable.
    uint8   uc_vfdfTxIIRClkEna;     // Strymon VDSL/ADSL CO Tx IIR processing clock enable.
    uint8   uc_vfdfVarWinClkEna;    // Strymon VDSL/ADSL CO Variable gain/Window processing clock enable.

} CRI_Input_t;

// Signals from CRI
typedef struct {
   // Active Low Reset Signals, 0==>Reset Core
   uint8 uc_ptmSwRst;
   uint8 uc_aaiSwRst;
   uint8 uc_bcrSwRst;
   uint8 uc_fciSwRst;
   uint8 uc_qtSwRst;
   uint8 uc_ftSwRst;
    uint8   uc_vfdfSwRst;
   uint8 uc_fdfSwRst;
   uint8 uc_afeifSwRst;
   uint8 uc_auxSwRst;
   uint8 uc_xmemSwRst;


   // Clocks to Cores
   // uint8 uc_acClk;
   uint8 uc_aaiClk;
   uint8 uc_pmsTxClk;
   uint8 uc_pmsRxClk;
   uint8 uc_qtTxClk;
   uint8 uc_qtRxClk;
   uint8 uc_ftTxClk;
   uint8 uc_ftRxClk;
    uint8   uc_fdfClk;

    uint8   uc_afeifHsClk;
    uint8   uc_afeifRegWrClk;
    uint8   uc_aaiRegWrClk;
    uint8   uc_aaiTxClk;
   uint8   uc_aaiRxClk;
   uint8   uc_arcClk;
   uint8   uc_arcCoreClk;
   uint8   uc_arcSysClk;
   uint8   uc_dspClk;
   uint8   uc_dspHsClk;
   uint8   uc_fdfDspClk;
   uint8   uc_fdfHsClk;
   uint8   uc_fdfSrcClk;
   uint8   uc_ftClk;
   uint8   uc_ftParrClk;
   uint8   uc_ftRegWrClk;
   uint8   uc_ltrClk;
   uint8   uc_pmsClk;
   uint8   uc_pmsHsClk;
   uint8   uc_pmsRegWrClk;
   uint8   uc_ptmClk;
   uint8   uc_ptmRegWrClk;
   uint8   uc_ptmTxClk;
   uint8   uc_ptmRxClk;
   uint8   uc_qtClk;
   uint8   uc_qtHsClk;
   uint8   uc_qtMfdqClk;
   uint8   uc_qtRegWrClk;
   uint8   uc_qtTxHsClk;
   uint8   uc_qtRxHsClk;
   uint8   uc_qtViterbiClk;
   uint8   uc_vfdfAfeDecimClk;
   uint8   uc_vfdfClk;
   uint8   uc_vfdfDecimClk;
   uint8   uc_vfdfDecTdqClk;
   uint8   uc_vfdfInterpClk;
   uint8   uc_vfdfRegWrClk;
   uint8   uc_vfdfRxIIRClk;
   uint8   uc_vfdfSrcClk;
   uint8   uc_vfdfTxIIRClk;
   uint8   uc_vfdfVarWinClk;


   // Control and Peripheral Bus Interface
   uint8   uc_xdsl_int0;  // aggregated Aware Interrupt 0
   uint8   uc_xdsl_int1;  // aggregated Aware Interrupt 1

    // Alphaeus XTC Interface
   uint8   uc_goAxtcTx;
    uint8   uc_goAxtcRx;

   // Bearer Channel Router Interface
    uint8   uc_goBcrTx;
    uint8   uc_goBcrRx;

   // Zephyr Interface
   uint8 uc_goFcTx;
   uint8 uc_goFcRx;

   // Iridia-QT Interface
   uint8 uc_goQtTx;
   uint8 uc_goQtRx;

   // Iridia-FT Interface
   uint8 uc_goParrTx;
   uint8 uc_goIfftTx;
   uint8 uc_goFftRx;

   // Iridia-FT DMT Symbol Sampled Register Update Signals
   uint8 uc_criTxSymUpdate;
   uint8 uc_criRxSymUpdate;

} CRI_Output_t;

extern CRI_Input_t  gt_CRI_Input;
extern CRI_Output_t gt_CRI_Output;

#endif // _CRI_IO_TYPEDEF_H
