/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: cri_memmap.h
;
;  Main header file for CRI behavioral model.
;
*****************************************************************************/
#include "cri_dsp_interface.h"

#ifndef _CRI_MEMMAP_H
#define _CRI_MEMMAP_H
/**********************************************************************
 * Memory map for CRI
 **********************************************************************/
#define     CRI_REGISTERBLOCK_ADDR     (0xC000)

#define CRI_CCR0_ADDR       (CRI_REGISTERBLOCK_ADDR + CRI_CCR0_OFFSET)
#define CRI_CCR1_ADDR       (CRI_REGISTERBLOCK_ADDR + CRI_CCR1_OFFSET)
#define CRI_RST_ADDR        (CRI_REGISTERBLOCK_ADDR + CRI_RST_OFFSET)
#define CRI_MASK0_TX_ADDR   (CRI_REGISTERBLOCK_ADDR + CRI_MASK0_TX_OFFSET)
#define CRI_MASK0_RX_ADDR   (CRI_REGISTERBLOCK_ADDR + CRI_MASK0_RX_OFFSET)
#define CRI_MASK1_TX_ADDR   (CRI_REGISTERBLOCK_ADDR + CRI_MASK1_TX_OFFSET)
#define CRI_MASK1_RX_ADDR   (CRI_REGISTERBLOCK_ADDR + CRI_MASK1_RX_OFFSET)
#define CRI_STATUS0_ADDR    (CRI_REGISTERBLOCK_ADDR + CRI_STATUS0_OFFSET)
#define CRI_STATUS1_ADDR    (CRI_REGISTERBLOCK_ADDR + CRI_STATUS1_OFFSET)
#define CRI_AMASK0_TX_ADDR  (CRI_REGISTERBLOCK_ADDR + CRI_AMASK0_TX_OFFSET)
#define CRI_AMASK0_RX_ADDR  (CRI_REGISTERBLOCK_ADDR + CRI_AMASK0_RX_OFFSET)
#define CRI_AMASK1_TX_ADDR  (CRI_REGISTERBLOCK_ADDR + CRI_AMASK1_TX_OFFSET)
#define CRI_AMASK1_RX_ADDR  (CRI_REGISTERBLOCK_ADDR + CRI_AMASK1_RX_OFFSET)
#define CRI_UPDCTL_ADDR     (CRI_REGISTERBLOCK_ADDR + CRI_UPDCTL_OFFSET)
#define CRI_EVENT_ADDR     (CRI_REGISTERBLOCK_ADDR + CRI_EVENT_OFFSET)
#define CRI_TX_TIMER_ADDR     (CRI_REGISTERBLOCK_ADDR + CRI_TX_TIMER_OFFSET)
#define CRI_TX_TIMER_CTL_ADDR (CRI_REGISTERBLOCK_ADDR + CRI_TX_TIMER_CTL_OFFSET)
#define CRI_RX_TIMER_ADDR     (CRI_REGISTERBLOCK_ADDR + CRI_RX_TIMER_OFFSET)
#define CRI_RX_TIMER_CTL_ADDR (CRI_REGISTERBLOCK_ADDR + CRI_RX_TIMER_CTL_OFFSET)
#define CRI_TX_AXTC_CTL_ADDR  (CRI_REGISTERBLOCK_ADDR + CRI_TX_AXTC_CTL_OFFSET)
#define CRI_TX_BCR_CTL_ADDR   (CRI_REGISTERBLOCK_ADDR + CRI_TX_BCR_CTL_OFFSET)
#define CRI_TX_FC_CTL_ADDR    (CRI_REGISTERBLOCK_ADDR + CRI_TX_FC_CTL_OFFSET)
#define CRI_TX_QT_CTL_ADDR    (CRI_REGISTERBLOCK_ADDR + CRI_TX_QT_CTL_OFFSET)
#define CRI_TX_IFFT_CTL_ADDR  (CRI_REGISTERBLOCK_ADDR + CRI_TX_IFFT_CTL_OFFSET)
#define CRI_TX_PARR_CTL_ADDR  (CRI_REGISTERBLOCK_ADDR + CRI_TX_PARR_CTL_OFFSET)
#define CRI_RX_FFT_CTL_ADDR   (CRI_REGISTERBLOCK_ADDR + CRI_RX_FFT_CTL_OFFSET)
#define CRI_RX_QT_CTL_ADDR    (CRI_REGISTERBLOCK_ADDR + CRI_RX_QT_CTL_OFFSET)
#define CRI_RX_FC_CTL_ADDR    (CRI_REGISTERBLOCK_ADDR + CRI_RX_FC_CTL_OFFSET)
#define CRI_RX_BCR_CTL_ADDR   (CRI_REGISTERBLOCK_ADDR + CRI_RX_BCR_CTL_OFFSET)
#define CRI_RX_AXTC_CTL_ADDR  (CRI_REGISTERBLOCK_ADDR + CRI_RX_AXTC_CTL_OFFSET)
#define CRI_DBGVIS_CFG_ADDR   (CRI_REGISTERBLOCK_ADDR + CRI_DBGVIS_CFG_OFFSET)
#define CRI_DBGVIS_DCTL_ADDR  (CRI_REGISTERBLOCK_ADDR + CRI_DBGVIS_DCTL_OFFSET)

/******************************************************************************/
/* Core Clocks Disable Bit Masks                                              */
/******************************************************************************/
#define CRI_DISABLE_AAI                    (1 << 7)
#define CRI_DISABLE_PTM                    (1 << 6)
#define CRI_DISABLE_PMS                    (1 << 5)
#define CRI_DISABLE_QT                     (1 << 4)
#define CRI_DISABLE_FT                     (1 << 3)
#define CRI_DISABLE_FDF                    (1 << 2)
#define CRI_DISABLE_VFDF                   (1 << 1)
#define CRI_DISABLE_AFEIF                  (1 << 0)

/******************************************************************************/
/* TX interrupt constants                                                     */
/******************************************************************************/
#define CRI_INTRPT_TX_BCR_DONE            (27)
#define CRI_INTRPT_TX_FC_DONE              (26)
#define CRI_INTRPT_TX_QT_DONE              (25)
#define CRI_INTRPT_TX_FT_PREPROC_DONE      (24)
#define CRI_INTRPT_TX_FT_IFFT_DONE         (23)
#define CRI_INTRPT_TX_FT_PARR_DONE         (22)
#define CRI_INTRPT_TX_FT_TXFRAME_DONE      (21)
#define CRI_INTRPT_TX_CRI_TIMER            (20)
#define CRI_INTRPT_TX_AAI_CELL_AVAILABLE   ( 8)
#define CRI_INTRPT_TX_AAI_STATUS           ( 7)
#define CRI_INTRPT_TX_QT_TXBAT_ERROR       ( 3)

/******************************************************************************/
/* TX interrupt mask constants  - common to MASK, STATUS, and EVENT registers */
/******************************************************************************/
#define CRI_MASK_TX_BCR_DONE             (1 << CRI_INTRPT_TX_BCR_DONE)
#define CRI_MASK_TX_FC_DONE              (1 << CRI_INTRPT_TX_FC_DONE)
#define CRI_MASK_TX_QT_DONE              (1 << CRI_INTRPT_TX_QT_DONE)
#define CRI_MASK_TX_FT_PREPROC_DONE      (1 << CRI_INTRPT_TX_FT_PREPROC_DONE)
#define CRI_MASK_TX_FT_IFFT_DONE         (1 << CRI_INTRPT_TX_FT_IFFT_DONE)
#define CRI_MASK_TX_FT_PARR_DONE         (1 << CRI_INTRPT_TX_FT_PARR_DONE)
#define CRI_MASK_TX_FT_TXFRAME_DONE      (1 << CRI_INTRPT_TX_FT_TXFRAME_DONE)
#define CRI_MASK_TX_CRI_TIMER            (1 << CRI_INTRPT_TX_CRI_TIMER)
#define CRI_MASK_TX_AAI_CELL_AVAILABLE   (1 << CRI_INTRPT_TX_AAI_CELL_AVAILABLE)
#define CRI_MASK_TX_AAI_STATUS           (1 << CRI_INTRPT_TX_AAI_STATUS)
#define CRI_MASK_TX_QT_TXBAT_ERROR       (1 << CRI_INTRPT_TX_QT_TXBAT_ERROR)

/******************************************************************************/
/* RX interrupt constants                                                     */
/******************************************************************************/
#define CRI_INTRPT_RX_FT_RXFRAME_DONE      (18)
#define CRI_INTRPT_RX_FT_FFT_DONE          (17)
#define CRI_INTRPT_RX_FT_POSTPROC_DONE     (16)
#define CRI_INTRPT_RX_QT_DONE              (15)
#define CRI_INTRPT_RX_FC_DONE              (14)
#define CRI_INTRPT_RX_BCR_DONE             (13)
#define CRI_INTRPT_RX_CRI_TIMER            (12)
#define CRI_INTRPT_RX_AAI_CELL_AVAILABLE   ( 6)
#define CRI_INTRPT_RX_AAI_STATUS           ( 5)
#define CRI_INTRPT_RX_FC_NTR               ( 4)
#define CRI_INTRPT_RX_QT_RXBAT_ERROR       ( 2)
#define CRI_INTRPT_RX_FDF_DEC_DONE         ( 1)
#define CRI_INTRPT_RX_FDF_AFE_BUSY         ( 0)

/******************************************************************************/
/* RX interrupt mask constants  - common to MASK, STATUS, and EVENT registers */
/******************************************************************************/
#define CRI_MASK_RX_FT_RXFRAME_DONE      (1 << CRI_INTRPT_RX_FT_RXFRAME_DONE)
#define CRI_MASK_RX_FT_FFT_DONE          (1 << CRI_INTRPT_RX_FT_FFT_DONE)
#define CRI_MASK_RX_FT_POSTPROC_DONE     (1 << CRI_INTRPT_RX_FT_POSTPROC_DONE)
#define CRI_MASK_RX_QT_DONE              (1 << CRI_INTRPT_RX_QT_DONE)
#define CRI_MASK_RX_FC_DONE              (1 << CRI_INTRPT_RX_FC_DONE)
#define CRI_MASK_RX_BCR_DONE             (1 << CRI_INTRPT_RX_BCR_DONE)
#define CRI_MASK_RX_CRI_TIMER            (1 << CRI_INTRPT_RX_CRI_TIMER)
#define CRI_MASK_RX_AAI_CELL_AVAILABLE   (1 << CRI_INTRPT_RX_AAI_CELL_AVAILABLE)
#define CRI_MASK_RX_AAI_STATUS           (1 << CRI_INTRPT_RX_AAI_STATUS)
#define CRI_MASK_RX_FC_NTR               (1 << CRI_INTRPT_RX_FC_NTR)
#define CRI_MASK_RX_QT_RXBAT_ERROR       (1 << CRI_INTRPT_RX_QT_RXBAT_ERROR)
#define CRI_MASK_RX_FDF_DEC_DONE         (1 << CRI_INTRPT_RX_FDF_DEC_DONE)
#define CRI_MASK_RX_FDF_AFE_BUSY         (1 << CRI_INTRPT_RX_FDF_AFE_BUSY)


/******************************************************************************/
/* Active mask registers update (at tx/rx frame interrupts) control constants */
/******************************************************************************/
#define AMASK0_TX_CONSTANT_UPDATE_ENABLE   (1 <<  0)
#define AMASK0_TX_PERFRAME_UPDATE_DISABLE  (1 <<  1)
#define AMASK0_RX_CONSTANT_UPDATE_ENABLE   (1 <<  2)
#define AMASK0_RX_PERFRAME_UPDATE_DISABLE  (1 <<  3)

#define AMASK1_TX_CONSTANT_UPDATE_ENABLE   (1 <<  4)
#define AMASK1_TX_PERFRAME_UPDATE_DISABLE  (1 <<  5)
#define AMASK1_RX_CONSTANT_UPDATE_ENABLE   (1 <<  6)
#define AMASK1_RX_PERFRAME_UPDATE_DISABLE  (1 <<  7)


/******************************************************************************/
/* #defines for TX CTL Registers */
/******************************************************************************/
#define REGISTER_START_TX_BCR_START       (0x1 << 23)
#define REGISTER_START_TX_BCR_SEL         (0x1 << 20)
#define TX_TIMER_START_TX_BCR_SEL         (0x2 << 20)
#define TX_BUFFER_SWAP_START_TX_BCR_SEL      (0x3 << 20)
#define TX_FC_DONE_START_TX_BCR_SEL       (0x4 << 20)
#define TX_QT_DONE_START_TX_BCR_SEL       (0x5 << 20)
#define TX_IFFT_DONE_START_TX_BCR_SEL     (0x6 << 20)

#define REGISTER_START_TX_FC_START        (0x1 << 23)
#define REGISTER_START_TX_FC_SEL       (0x1 << 20)
#define TX_TIMER_START_TX_FC_SEL       (0x2 << 20)
#define TX_BUFFER_SWAP_START_TX_FC_SEL    (0x3 << 20)
#define TX_BCR_DONE_START_TX_FC_SEL       (0x4 << 20)
#define TX_FC_DONE_START_TX_FC_SEL        (0x5 << 20)
#define TX_IFFT_DONE_START_TX_FC_SEL      (0x6 << 20)

#define REGISTER_START_TX_QT_START        (0x1 << 23)
#define REGISTER_START_TX_QT_SEL       (0x1 << 20)
#define TX_TIMER_START_TX_QT_SEL       (0x2 << 20)
#define TX_BUFFER_SWAP_START_QT_SEL       (0x3 << 20)
#define TX_BCR_DONE_START_TX_QT_SEL       (0x4 << 20)
#define TX_FC_DONE_START_TX_QT_SEL        (0x5 << 20)
#define TX_IFFT_DONE_START_TX_QT_SEL      (0x6 << 20)

#define REGISTER_START_TX_IFFT_START      (0x1 << 23)
#define REGISTER_START_TX_IFFT_SEL        (0x1 << 20)
#define TX_TIMER_START_TX_IFFT_SEL        (0x2 << 20)
#define TX_BUFFER_SWAP_START_IFFT_SEL     (0x3 << 20)
#define TX_BCR_DONE_START_TX_IFFT_SEL     (0x4 << 20)
#define TX_FC_DONE_START_TX_IFFT_SEL      (0x5 << 20)
#define TX_QT_DONE_START_TX_IFFT_SEL      (0x6 << 20)
#define TX_PARR_DONE_START_TX_IFFT_SEL    (0x7 << 20)

#define REGISTER_START_TX_PARR_START      (0x1 << 23)
#define REGISTER_START_TX_PARR_SEL        (0x1 << 20)
#define TX_TIMER_START_TX_PARR_SEL        (0x2 << 20)
#define TX_BUFFER_SWAP_START_TX_PARR_SEL  (0x3 << 20)
#define TX_BCR_DONE_START_TX_PARR_SEL     (0x4 << 20)
#define TX_FC_DONE_START_TX_PARR_SEL      (0x5 << 20)
//#define TX_IFFT_DONE_START_TX_PARR_SEL     (0x6 << 20)
#define TX_IFFT_DONE_START_TX_PARR_SEL    (0x7 << 20)


/******************************************************************************/
/* #defines for RX CTL Registers */
/******************************************************************************/
#define REGISTER_START_RX_FFT_START       (0x1 << 23)
#define RX_NO_FFT_START_RX_FFT_SEL        (0x0 << 20)
#define REGISTER_START_RX_FFT_SEL         (0x1 << 20)
#define RX_TIMER_START_RX_FFT_SEL         (0x2 << 20)
#define RX_BUFFER_SWAP_START_RX_FFT_SEL      (0x3 << 20)
#define RX_QT_DONE_START_RX_FFT_SEL       (0x4 << 20)
#define RX_FC_DONE_START_RX_FFT_SEL       (0x5 << 20)
#define RX_BCR_DONE_START_RX_FFT_SEL      (0x6 << 20)

#define REGISTER_START_RX_QT_START        (0x1 << 23)
#define REGISTER_START_RX_QT_SEL       (0x1 << 20)
#define RX_TIMER_START_RX_QT_SEL       (0x2 << 20)
#define RX_BUFFER_SWAP_START_RX_QT_SEL    (0x3 << 20)
#define RX_FFT_DONE_START_RX_QT_SEL       (0x4 << 20)
#define RX_FC_DONE_START_RX_QT_SEL        (0x5 << 20)
#define RX_BCR_DONE_START_RX_QT_SEL       (0x6 << 20)

#define REGISTER_START_RX_FC_START        (0x1 << 23)
#define REGISTER_START_RX_FC_SEL       (0x1 << 20)
#define RX_TIMER_START_RX_FC_SEL       (0x2 << 20)
#define RX_BUFFER_SWAP_START_RX_FC_SEL    (0x3 << 20)
#define RX_FFT_DONE_START_RX_FC_SEL       (0x4 << 20)
#define RX_QT_DONE_START_RX_FC_SEL        (0x5 << 20)
#define RX_BCR_DONE_START_RX_FC_SEL       (0x6 << 20)

#define REGISTER_START_RX_BCR_START       (0x1 << 23)
#define REGISTER_START_RX_BCR_SEL         (0x1 << 20)
#define RX_TIMER_START_RX_BCR_SEL         (0x2 << 20)
#define RX_BUFFER_SWAP_START_RX_BCR_SEL      (0x3 << 20)
#define RX_FFT_DONE_START_RX_BCR_SEL      (0x4 << 20)
#define RX_QT_DONE_START_RX_BCR_SEL       (0x5 << 20)
#define RX_FC_DONE_START_RX_BCR_SEL       (0x6 << 20)


#endif //_CRI_MEMMAP_H
