/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: zep_ilv_cocomo_interface.h
*
*   This file Specifies the Cocomo to ILV interface.  This interface
*  includes the register read/write functions, core reset functions, BM
*  intialization functions, and any other cocomo/BM only functions/variables
*  that are required to run a HW Engine simulation.  These functions are NOT
*  required by, and unavailable for, actual HW.
*
*-------------------------------------------------------------------------------
*/

#ifndef _ZEP_ILV_COCOMO_INTERFACE_H
#define _ZEP_ILV_COCOMO_INTERFACE_H

#ifdef __cplusplus
extern "C" {
#endif

//==============================================================================
// ZEP_ILV BM clocking functions
//==============================================================================
int32 ZEP_ILV_Clock(void);

//==============================================================================
// ZEP_ILV initialization functions
//==============================================================================
void ZEP_ILV_InitializeBM(void);

//==============================================================================
// ZEP_ILV reset functions
//==============================================================================
void ZEP_ILV_Reset(void);

//==============================================================================
// ZEP_ILV functions for reading/writing RAM blocks and registers
//==============================================================================
int32 ZEP_ILV_WriteWord(uint32 addr, uint32 ul_data, uint8 uc_ByteEnable);
int32 ZEP_ILV_ReadWord(uint32 addr, uint32 *pul_data, uint8 uc_ByteEnable);

//==============================================================================
// ZEP_ILV interface functions used by Zephyr-FC block
//==============================================================================
int32 ZEP_ILV_PutByteToTxILVB(int16 s_lp, uint8 uc_byte);
int32 ZEP_ILV_GetByteFromRxDILVB(int16 s_lp, uint8 *puc_byte);

//==============================================================================
// ZEP_ILV interface functions used by Iridia-QT block
//==============================================================================
int32 ZEP_ILV_PutWordToRxDTB(int16 s_lp, uint32 ul_word);
int32 ZEP_ILV_GetWordFromTxDTB(int16 s_lp, uint32 *pul_word);

// temporary interface function
void ZEP_ILV_ClearTxDtbRdAddr(void);
void ZEP_ILV_ClearRxDtbWrAddr(void);

//==============================================================================
// ZEP_ILV functions for obtaining TxIFM/RxDFM addresses
//==============================================================================
void ZEP_ILV_GetTxIFMFifoBaseAddr(uint16 **pus_FifoBaseAddr);
void ZEP_ILV_GetTxIFMFifoWrPtrAddr(uint32 **pul_FifoWrPtrAddr);
void ZEP_ILV_GetTxIFMFifoRdPtrAddr(uint32 **pul_FifoRdPtrAddr);
void ZEP_ILV_GetRxDFMFifoBaseAddr(uint16 **pus_FifoBaseAddr);
void ZEP_ILV_GetRxDFMFifoWrPtrAddr(uint32 **pul_FifoWrPtrAddr);
void ZEP_ILV_GetRxDFMFifoRdPtrAddr(uint32 **pul_FifoRdPtrAddr);

#ifdef __cplusplus
}
#endif

#endif // _ZEP_ILV_COCOMO_INTERFACE_H
