/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: zep_ilv_io_typedef.h
*
*   This file contains type definitions used by different files.
*
*-------------------------------------------------------------------------------
*/

#ifndef _ZEP_ILV_IO_TYPEDEF_H
#define _ZEP_ILV_IO_TYPEDEF_H

// structure used for ZEP_ILV input signals
typedef struct {

   // from Zephyr-FC TX block
   uint8 uc_FC_TX_INT_GO;
   uint8 uc_FC_TX_ILV_LP;
   uint8 uc_FC_ILV_BUSY;
   uint8 uc_FC_TX_SHALF_ENA;
   // from Zephyr-FC RX block
   uint8 uc_FC_RX_INT_GO;
   uint8 uc_FC_RX_DILV_LP;
   uint8 uc_FC_DILV_BUSY;
   uint8 uc_FC_RX_SHALF_ENA;
   uint8 uc_FC_RX_PROC_DONE;

   // from Iridia-QT TX block
   uint8 uc_QT_TX_INT_GO;
   uint8 uc_QT_TX_DONE;
   uint16 us_QT_TX_PMD_BYTES0;
   uint16 us_QT_TX_PMD_BYTES1;
   // from Iridia-QT RX block
   uint8 uc_QT_RX_INT_GO;
   uint8 uc_QT_RX_DONE;
   uint16 us_QT_RX_PMD_BYTES0;
   uint16 us_QT_RX_PMD_BYTES1;

} ZEP_ILV_Input_t;

// structure used for ILV output signals
typedef struct {

   // to Zephyr-FC TX block
   uint8 uc_ILV_TXDT_BUSY;
   uint8 uc_ILV_TX_SHALF_CTL;
   // to Zephyr-FC RX block
   uint8 uc_ILV_RXFC_AVAIL;
   uint8 uc_ILV_RXDT_BUSY0;
   uint8 uc_ILV_RXDT_BUSY1;
   uint8 uc_ILV_RX_SHALF_CTL;

} ZEP_ILV_Output_t;

// Zephyr-ILV IO signals
extern ZEP_ILV_Input_t gt_ZEP_ILV_Input;
extern ZEP_ILV_Output_t gt_ZEP_ILV_Output;

#endif // _ZEP_ILV_IO_TYPEDEF_H
