/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: zep_ilv_memmap.h
*
*   This file contains ZEP_ILV BM memory map.
*
*-------------------------------------------------------------------------------
*/

#ifndef _ZEP_ILV_MEMMAP_H
#define _ZEP_ILV_MEMMAP_H

// Zephyr-ILV RAM
#define ZEP_ILV_RAM_ILVB_ADDR          (uint32)(0x24000) // TX Interleave/Fast Buffer (byte access)
#define ZEP_ILV_RAM_DILVB_ADDR            (uint32)(0x28000) // RX Deinterleave/Fast Buffer (byte access)
#define ZEP_ILV_RAM_TXDTB_ADDR            (uint32)(0x2C000) // TX Data Transfer Buffer (byte access)
#define ZEP_ILV_RAM_RXDTB_ADDR            (uint32)(0x2C800) // RX Data Transfer Buffer (byte access)
#define ZEP_ILV_RAM_IFB_ADDR           (uint32)(0x2D000) // TX Interleave FIFO Base Buffer (byte access)
#define ZEP_ILV_RAM_IFWP_ADDR          (uint32)(0x2D200) // TX Interleave FIFO Write Pointer Buffer (32-bit word access)
#define ZEP_ILV_RAM_IFRP_ADDR          (uint32)(0x2D400) // TX Interleave FIFO Read Pointer Buffer (32-bit word access)
#define ZEP_ILV_RAM_DFB_ADDR           (uint32)(0x2D600) // RX Deinterleave FIFO Base Buffer (byte access)
#define ZEP_ILV_RAM_DFWP_ADDR          (uint32)(0x2D800) // RX Deinterleave FIFO Write Pointer Buffer (32-bit word access)
#define ZEP_ILV_RAM_DFRP_ADDR          (uint32)(0x2DA00) // RX Deinterleave FIFO Read Pointer Buffer (32-bit word access)
#define ZEP_ILV_NUM_RAM_BLOCKS            (10)

// sizes are in 32-bit word
#define ZEP_ILV_RAM_ILVB_SIZE          (8512) // 34,048 bytes, 33,015 bytes required
#define ZEP_ILV_RAM_DILVB_SIZE            (8512) // 34,048 bytes, 33,015 bytes required
#define ZEP_ILV_RAM_TXDTB_SIZE            (1216) // 4,864 bytes, 4,802 bytes required
#define ZEP_ILV_RAM_RXDTB_SIZE            (1216) // 4,864 bytes, 4,804 bytes required
#define ZEP_ILV_RAM_IFB_SIZE           (256)
#define ZEP_ILV_RAM_IFWP_SIZE          (512)
#define ZEP_ILV_RAM_IFRP_SIZE          (512)
#define ZEP_ILV_RAM_DFB_SIZE           (256)
#define ZEP_ILV_RAM_DFWP_SIZE          (512)
#define ZEP_ILV_RAM_DFRP_SIZE          (512)

// Zephyr-ILV Registers
#define ZEP_ILV_REG_BASE_ADDR          (uint32)(0xC1C0)

// Zephyr-ILV TX registers
#define ZIT_CONFIG_ADDR                (uint32)(ZEP_ILV_REG_BASE_ADDR+0x00)
#define ZIT_CW_SIZE_ADDR               (uint32)(ZEP_ILV_REG_BASE_ADDR+0x01)
#define ZIT_RD_STEP_ADDR               (uint32)(ZEP_ILV_REG_BASE_ADDR+0x02)
#define ZIT_ILVB_LEVEL_ADDR               (uint32)(ZEP_ILV_REG_BASE_ADDR+0x03)
#define ZIT_LEVEL_OFFSET_ADDR          (uint32)(ZEP_ILV_REG_BASE_ADDR+0x04)
#define ZIT_CUR_WADR_ADDR              (uint32)(ZEP_ILV_REG_BASE_ADDR+0x05)
#define ZIT_CUR_RADR_ADDR              (uint32)(ZEP_ILV_REG_BASE_ADDR+0x06)
#define ZIT_CUR_FWR_IDX_ADDR           (uint32)(ZEP_ILV_REG_BASE_ADDR+0x07)
#define ZIT_CUR_FRD_IDX_ADDR           (uint32)(ZEP_ILV_REG_BASE_ADDR+0x08)
#define ZIT_ILV_WR_BYTES_ADDR          (uint32)(ZEP_ILV_REG_BASE_ADDR+0x09)
#define ZIT_DT_BYTES_ADDR              (uint32)(ZEP_ILV_REG_BASE_ADDR+0x0A)
#define ZIT_DT_SIZE_ADDR               (uint32)(ZEP_ILV_REG_BASE_ADDR+0x0B)
#define ZIT_DTB_WR_START_ADDR          (uint32)(ZEP_ILV_REG_BASE_ADDR+0x0C)
#define ZIT_DTB_RD_START_ADDR          (uint32)(ZEP_ILV_REG_BASE_ADDR+0x0D)
#define ZIT_DTB_RD_LWORDS_ADDR            (uint32)(ZEP_ILV_REG_BASE_ADDR+0x0E)

// Zephyr-ILV RX registers
#define ZIR_CONFIG_ADDR                (uint32)(ZEP_ILV_REG_BASE_ADDR+0x20)
#define ZIR_CW_SIZE_ADDR               (uint32)(ZEP_ILV_REG_BASE_ADDR+0x21)
#define ZIR_WR_STEP_ADDR               (uint32)(ZEP_ILV_REG_BASE_ADDR+0x22)
#define ZIR_DILVB_LEVEL_ADDR           (uint32)(ZEP_ILV_REG_BASE_ADDR+0x23)
#define ZIR_LEVEL_OFFSET_ADDR          (uint32)(ZEP_ILV_REG_BASE_ADDR+0x24)
#define ZIR_DILVB_AVAIL_ADDR           (uint32)(ZEP_ILV_REG_BASE_ADDR+0x25)
#define ZIR_CUR_WADR_ADDR              (uint32)(ZEP_ILV_REG_BASE_ADDR+0x26)
#define ZIR_CUR_RADR_ADDR              (uint32)(ZEP_ILV_REG_BASE_ADDR+0x27)
#define ZIR_CUR_FWR_IDX_ADDR           (uint32)(ZEP_ILV_REG_BASE_ADDR+0x28)
#define ZIR_CUR_FRD_IDX_ADDR           (uint32)(ZEP_ILV_REG_BASE_ADDR+0x29)
#define ZIR_DILV_RD_BYTES_ADDR            (uint32)(ZEP_ILV_REG_BASE_ADDR+0x2A)
#define ZIR_DT_BYTES_ADDR              (uint32)(ZEP_ILV_REG_BASE_ADDR+0x2B)
#define ZIR_DT_SIZE_ADDR               (uint32)(ZEP_ILV_REG_BASE_ADDR+0x2C)
#define ZIR_DTB_WR_START_ADDR          (uint32)(ZEP_ILV_REG_BASE_ADDR+0x2D)
#define ZIR_DTB_RD_START_ADDR          (uint32)(ZEP_ILV_REG_BASE_ADDR+0x2E)
#define ZIR_DTB_WR_LWORDS_ADDR            (uint32)(ZEP_ILV_REG_BASE_ADDR+0x2F)

#define ZEP_ILV_TX_REG_BASE_ADDR       (ZIT_CONFIG_ADDR)
#define ZEP_ILV_RX_REG_BASE_ADDR       (ZIR_CONFIG_ADDR)
#define ZEP_ILV_NUM_TX_REGS               (ZIT_DTB_RD_LWORDS_ADDR-ZIT_CONFIG_ADDR+1)
#define ZEP_ILV_NUM_RX_REGS               (ZIR_DTB_WR_LWORDS_ADDR-ZIR_CONFIG_ADDR+1)

// constants and masks
#define ZEP_ILV_ADSL_MODE        (0x00)
#define ZEP_ILV_VDSL1_MODE       (0x01)
#define ZEP_ILV_VDSL2_MODE       (0x02)

#define ZEP_ILV_QT_LAT_ENB0         (0x10)
#define ZEP_ILV_QT_LAT_ENB1         (0x20)

#endif // _ZEP_ILV_MEMMAP_H
