/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: zep_ilv_private.h
*
*   This file contains private functions and variables which are visible
*   by the ZEP_ILV BM only.
*
*-------------------------------------------------------------------------------
*/

#ifndef _ZEP_ILV_PRIVATE_H
#define _ZEP_ILV_PRIVATE_H

// zep_ilv_io.c
void WriteToByteBuffer(uint8 *puc_addr, uint16 us_offset, uint32 ul_data, uint8 uc_ByteEnable);
void ReadFromByteBuffer(uint8 *puc_addr, uint16 us_offset, uint32 *pul_data);
void WriteToWordBuffer(uint16 *pus_addr, uint16 us_offset, uint32 ul_data, uint8 uc_ByteEnable);
void ReadFromWordBuffer(uint16 *pus_addr, uint16 us_offset, uint32 *pul_data);

// zep_ilv_tx.c
void ZEP_ILV_Clock_Tx(ZEP_ILV_Input_t *pt_ILVInput, ZEP_ILV_Output_t *pt_ILVOutput);
int32 ZEP_ILV_TxDataTransfer(int16 s_lp);
int32 WriteByteToTxILVB(int16 s_lp, uint8 uc_byte);
int32 ReadByteFromTxILVB(int16 s_lp, uint8 *puc_byte);
void UpdateTxFifoWriteIdx(int16 s_lp);
void UpdateTxFifoReadIdx(int16 s_lp);

// zep_ilv_rx.c
void ZEP_ILV_Clock_Rx(ZEP_ILV_Input_t *pt_ILVInput, ZEP_ILV_Output_t *pt_ILVOutput);
int32 ZEP_ILV_RxDataTransfer(int16 s_lp);
int32 WriteByteToRxDILVB(int16 s_lp, uint8 uc_byte);
int32 ReadByteFromRxDILVB(int16 s_lp, uint8 *puc_byte);
void UpdateRxFifoWriteIdx(int16 s_lp);
void UpdateRxFifoReadIdx(int16 s_lp);

// zep_ilv_init.c
void ZEP_ILV_ResetRegisters(void);
void ZEP_ILV_ResetGlobals(void);

// zep_ilv_io.c
void UpdateTxBMVars(void);
void UpdateRxBMVars(void);

#endif // _ZEP_ILV_PRIVATE_H
