/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   AllocateBiGi_desiredLp_Bis.c
*   Allocate the required Bi / gi based on final Lp computed
*   Takes care of change in TCM overhead by calling fine gain allocation
*   again and again till enough fine gain is allocated, ensures RMS fine Gain is -ve;
*   and also in the end makes even1  bit tones
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "dsp_op.h"
#include "dsp_op2.h"
#include "gdata_bis.h"
#include "bitload2.h"
#include "cmv.h"
#include "changebat.h"
#include "bitload_support.h"
#include "decimalgain.h"

C_SCOPE FlagT  AllocateBiGi_desiredLp_Bis(int16 s_GainsEnabled, uint8 *psa_RxBat, int16 s_MaxBits, int32 l_SumFineGaindB, int32 *pl_SumFGainLinSq,  int32 *pl_SumGiSqTssiSq, int16 *psa_RxFineGains, int16 *ps_RxExtraBits, uint16 *pus_ncloaded,  int16 s_delta_Lp, int16 s_path)
{

   int16  s_min_fine_gain;
   int16 s_ActualDeltaSumLp;
   int16 s_Tcm_Oh_before, s_Tcm_Oh_after;
   int16 s_InitialSumBi;
   FlagT ft_BitloadOK=0;
   int16 s_ExtraBits = 0;
   int16 s_delta_for_fixedrate = 3;
   int32 l_SumFGainLinSq = 0;

   if (s_GainsEnabled)
      s_min_fine_gain = gs_min_fine_gain;
   else
      s_min_fine_gain = 0;


   GetBatStats(psa_RxBat, gs_RxNumTones, gft_TcmFlag_bis_DS, &gus_ncloaded, (int16 *)(void *)&gus_Rx_Tcm_Num1bits, &s_Tcm_Oh_before, &s_InitialSumBi, s_path);

   if (s_delta_Lp < 0)
   {

   /* find four tones and give them positive fine gain; so that they will have excess margin without
      changing the BAT */
      if(s_GainsEnabled)
         s_ExtraBits = ChooseFineGains_BIS(psa_RxBat, psa_RxFineGains, &l_SumFineGaindB, pl_SumGiSqTssiSq, s_delta_for_fixedrate , 1, 0);

      // we need to trim bits to get the desired Lp
      ft_BitloadOK = !ChangeLpKeepMaxMargin(psa_RxBat, psa_RxFineGains, s_delta_Lp  , gsa_MedleySnrBuf, gs_RxDesiredMargin, p_MEDLEYset_DS, guca_RxBitswapTones, &s_ActualDeltaSumLp, FALSE, 0, 0);

      return(ft_BitloadOK);

   }
   else
   {
      // use fine gains to allocate just enough number of bits this currently has support for BIS only
      if (s_GainsEnabled == TRUE)
      *ps_RxExtraBits = ChooseFineGains_BIS(psa_RxBat, psa_RxFineGains,  pl_SumFGainLinSq, pl_SumGiSqTssiSq, s_delta_Lp,0, 0);

      if (*ps_RxExtraBits == s_delta_Lp) ft_BitloadOK =1;

      // check if TCM overhead changed; adjust for that too.
      while (s_delta_Lp !=0)
      {
         /* Compute no. of channels having bits, and channels having one bit if tcm is enabled. */

         GetBatStats(psa_RxBat, gs_RxNumTones, gft_TcmFlag_bis_DS, &gus_ncloaded, (int16*)(void *)&gus_Rx_Tcm_Num1bits, &s_Tcm_Oh_after, &s_InitialSumBi, s_path);

         s_delta_Lp = s_Tcm_Oh_after - s_Tcm_Oh_before;

         s_Tcm_Oh_before = s_Tcm_Oh_after;

         if (s_delta_Lp > 0)
         {
            // use fine gains to add extra bits
            if (s_GainsEnabled == TRUE)
            s_ExtraBits = ChooseFineGains_BIS(psa_RxBat, psa_RxFineGains,  pl_SumFGainLinSq, pl_SumGiSqTssiSq, s_delta_Lp, 0, 0);

            if (s_ExtraBits == s_delta_Lp)
            {
               *ps_RxExtraBits +=s_ExtraBits;
               ft_BitloadOK =1;
            }
            else // Can't use fine gains to add more bits
            {
               // fail
               ft_BitloadOK = 0;
               break;
            }
         }

      }  // s_delta_Lp != 0

      if (ft_BitloadOK ==1)
      {
      /* find four tones and give them positive fine gain; so that they will have excess margin without
         changing the BAT */
         if (s_GainsEnabled == TRUE)
         s_ExtraBits = ChooseFineGains_BIS(psa_RxBat, psa_RxFineGains,pl_SumFGainLinSq, pl_SumGiSqTssiSq, s_delta_for_fixedrate , 1, 0);

      }
      if (ft_BitloadOK ==1)
      {
         // Force even number of 1 bit tones
         ft_BitloadOK = ForceEvenNum1BitTonesInBAT(psa_RxBat, psa_RxFineGains, gsa_RxShowtimeSnrBuf, gs_RxDesiredMargin, p_MEDLEYset_DS, guca_RxBitswapTones);

      }
   }  // use fine gains to add more bits
   return(ft_BitloadOK);

}


