/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ApplyBlackoutBits.c
*
*  Applied blackout to tones in psa_ToneBuf.
*
*-------------------------------------------------------------------------
*/
#include "common.h"
#include "const_bis.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "bitload_const.h"
#include "typedef.h"

/*^^^
*------------------------------------------------------------------------
*
*  Name : ApplyBlackoutBits
*
*   Prototype:
*       void ApplyBlackoutBits(int16 *psa_ToneBuf)
*
*   Abstract:
*     Applied blackout to tones in psa_ToneBuf.
*
*   Input Parameters:
*     *psa_ToneBuf            (I/O) Pointer to tone buffer
*-----------------------------------------------------------------------------
^^^*/
C_SCOPE void ApplyBlackoutBits(int16 *psa_TxToneBuf)
{
   int32 i;
   int32 *pl_Tone = (int32 *)(void *)psa_TxToneBuf;   // Use a 32-bit pointer so we can clear both real and complex with one write.

   for (i=0 ; i<gs_TxNumTones ; i++, pl_Tone++)
   {
      if (IS_TONEFLAGSET(gp_BlackoutBits_US, i))
         *pl_Tone = 0;
   }
}

C_SCOPE void ClearTonesNotInUsMedleySet(int16 *psa_TxToneBuf)
{
   int16 i;
   int32 *pl_Tone = (int32 *)(void *)psa_TxToneBuf;   // Use a 32-bit pointer so we can clear both real and complex with one write.

   for (i=0 ; i<gs_TxNumTones ; i++, pl_Tone++)
   {
      if (!IS_TONEFLAGSET(gp_MEDLEYset_US, i))
         *pl_Tone = 0;
   }

}

