/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ApplyFineGains.c
*
*  Apply fine gains to tones in psa_ToneBuf
*
*-------------------------------------------------------------------------
*/
#include "common.h"
#include "const_bis.h"
#include "tx_ops2.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "typedef.h"
#include "crc16.h"
#include "dsp_op.h"
#include "decimalgain.h"
#include "mul.h"
/*^^^
*------------------------------------------------------------------------
*
*  Name : ApplyFineGains
*
*   Prototype:
*       void ApplyFineGains(int16 *psa_ToneBuf, int16 s_FirstChan,
*                    int16 s_LastChan, uint16 *psa_FineGains, FlagT ft_FineGainsAreLinear)
*
*   Abstract:
*     Apply fine gains to tones in psa_ToneBuf
*
*   Input Parameters:
*     *psa_ToneBuf            (I/O) Pointer to tone buffer
*     s_FirstChan          First used channel
*     s_LastChan           Last used channel
*     *psa_FineGains       pointer to the memory address where fine gains are stored in 3.13 linear format
*
*-----------------------------------------------------------------------------
^^^*/
C_SCOPE void ApplyFineGains(int16 *psa_ToneBuf, int16 s_FirstChan, int16 s_LastChan, uint16 *psa_FineGains)
{
   int i;
   int16 s_FineGain;
   int32 l_temp;

   for (i = s_FirstChan; i <= s_LastChan; i++)
   {
      s_FineGain = psa_FineGains[i];
      MULS16(l_temp, psa_ToneBuf[2*i], s_FineGain);
      psa_ToneBuf[2*i] = (int16)(l_temp >>13);
      MULS16(l_temp, psa_ToneBuf[2*i+1], s_FineGain);
      psa_ToneBuf[2*i+1] = (int16)(l_temp >>13);
   }
}

