/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   BgDetectMultiTones.c
 *
 *-------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_tones.h"
#include "dsp_op.h"
#include "dsp_op2.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "ec_data.h"
#include "ghs.h"
#include "cmv.h"
#include "vecpwr.h"
#include "detect.h"
#include "memsetbf.h"

extern int16 gs_ChanDiscDetectMin;

 /*
 *------------------------------------------------------------------------
 *
 *  Name : BgDetectMultiTones
 *
 *  Description: Background task that calls DetectMultiTones().
 * Detection result is returned in gft_DetectMultTonesResult.
 *
  *------------------------------------------------------------------------
 */

void BgDetectMultiTones_Comb(void)
{
   int i;
   int16 s_Saved_MinDetect, s_detectedtones;


    if(gs_RxState == R_C_QUIET1_RX_BIS)
   {
   /*  Average the accumulated signal */
   for (i = (2*gs_avg_first_channel); i <= (2*gs_avg_last_channel+1); i++)
      gpsa_RxToneBuf_sav2[i] = (int16)(((int32 *)gla_RxAccumBuf)[i]>>gs_LOG_R_C_COMB1_AC_LEN_BIS);

   }

   s_Saved_MinDetect = gs_DetectMin;
   gs_DetectMin = gs_ChanDiscDetectMin;      // Min noise power level to consider for DetectTone().  Use a much higher value.

   // Input for this background function must be in gpsa_RxToneBuf_sav2.
        s_detectedtones = 0;
   for(i=0; i<gs_NumCombSubcarriersInspected; i++)
   {
          if(DetectMultiTones(gpsa_RxToneBuf_sav2, &gsa_Inspected_COMB_Subcarriers[i], 1, 1, (int16)(gs_ToneDetectScale*256)))
   {
      s_detectedtones++;
      gsa_CombToneDetCnt[i]++;
   }
   }

   if(s_detectedtones >= gs_NumCombSubcarriersRequired)
          gft_BgDetectMultiTonesResult = TRUE;
   else
          gft_BgDetectMultiTonesResult = FALSE;

   gs_DetectMin = s_Saved_MinDetect;
   guc_BkgdTaskState = TRAINING_DONE;

    if(gs_RxState == R_C_QUIET1_RX_BIS)
      MemSetBuffer((int16 *)(void *)gla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*2*gs_RxNumTones));
}



