/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   BinarySearch.c
*
*
*
*-------------------------------------------------------------------------
*/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "typedef.h"
#include "const.h"
#include "mul.h"

C_SCOPE int16 BinarySearch(FlagT ft_FindMax, uint32 ul_Cnstrnt1, uint32 ul_Cnstrnt2, int16 s_check1, int16 s_check2,
               int16 s_start, int16 s_end, int16 s_default)
{
   int s_delta, s_value, s_result;
   int32 l_temp;

   if (ul_Cnstrnt2 == 0)
      return (s_default);
   else
   {

      while (s_start < s_end) {
         s_delta = (s_end - s_start) >> 1;
         s_value = s_start + s_delta;
         MULS32x16(l_temp, ul_Cnstrnt2, s_value);
         if(ul_Cnstrnt1 < (uint32)l_temp)
         {
            s_end = s_value-1;
         }
         else if (ul_Cnstrnt1 > (uint32)l_temp)
         {
            s_start = s_value+1;
         }
         else //(int32)ul_Cnstrnt1[i] == l_temp
         {
            return (s_value);
         }
      }


      MULS32x16(l_temp, ul_Cnstrnt2, s_end);
      if ((ft_FindMax == TRUE) && (ul_Cnstrnt1 < (uint32)l_temp))
         s_result = s_end-1;
      else if ((ft_FindMax == FALSE) && (ul_Cnstrnt1 > (uint32)l_temp))
         s_result = s_end+1;
      else
         s_result = s_end;

      return (s_result);
   }
}
