/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   CalcACTATPDiag.c
*
*   functions to compute Compute the far-end Actual Aggregate Transmit Power
*   (ACTATP) test-parameter specific for G.bis Diagnositics.
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gpersistent.h"
#include "cmv.h"
#include "gdata_bis.h"
#include "diagparam_bis.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Prototype:
 *    int16 CalcACTATP(int16 s_nomatp, int16 s_refvalue)
 *
 *  Description:  Compute the far-end Actual Aggregate  Transmit Power (ACTATP)
 *    It is simply the NOMATPds minus PCBds
 *
 *
 *  Input Arguments:
 *      int16 s_nomatp     relative Nominal Aggregate  Transmit Power
 *    int16 s_refvalue  s_nomatp is relative to this reference value
 *                   such than NOMATP = s_nomatp+s_refvalue
 *
 *  Output Arguments:
 *      none
 *
 *  Return:
 *    Average upstream signal attenuation Q9.1 in int16 in guca_RMSG1_LD[]
 *
 * Global Variables:
 *    gsa_RxFineGains[] -- (O) actual fine gains (non-dB value in Q3.13 format)
 *    gt_CMsgPcbBis.uc_Min_US_PowerCutBack
 *    gt_CMsgPcbBis.uc_Min_US_PowerCutBack
 *    gt_TxPMDControl.s_NOMPSD_DS
 *    guca_RMSG1_LD[]
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE int16 CalcACTATP(int16 s_nomatp, int16 s_refvalue)
{
   int16 s_actatp;

   if (TESTArray[TEST_InitState] == TEST_GhsInitState) {

      // Use PCBds (in 0.1 dB step size) as DEFAULT_MAXNOMATP_DS in
      // CalcNOMATP() input to obtain ACTATPfarend = NOMATP - PCBds
      s_nomatp += s_refvalue;
      s_actatp = s_nomatp - gt_TxPMDControl.us_pwr_cutback_DS*10;

      //if s_actatp (in 0.1 dB step size) is outside the range  [-51.1, 51.2]
      //then ACTATP cannot be represented in BIS Diagnostic Mode
      if((s_actatp < -511) || (s_actatp > 512))
         s_actatp = (int32)OUT_OF_RANGE_ACTATP;
   }
   else
      s_actatp = (int32)OUT_OF_RANGE_ACTATP;

   return (s_actatp);
}

