/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   CalcAttndrDiag.c
 *
 *   functions to calc attndr for DiagMode and showtime for
 * G.bis Diagnositics.
 *
 *-------------------------------------------------------------------------
 */
// ******************************************************************************************
// CalcAttndrDiag.c
//
// History
//
//
//  23/05/2013 Anantha Ramu: Did modifications to set proper ATTNDR values in ReTx mode.
//                           Grep for: XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr
// *****************************************************************************************
#include "gdata.h"
#include "diagparam_bis.h"
#include "dsp_op.h"
#include "bitload_const.h"
#include "bitload2.h"
#include "mul.h"



C_SCOPE uint32 CalcATTNDR(
   int16 * psa_SnrBuf,
   int16 s_DesiredMargin,
   int16 s_CodingGain)
{


   int16 s_ExcessSNR, s_ExcessSNR_for_BIMAX, s_BitsPerFrame;
   int i;
   uint32 ul_TotalDataRate = 0;
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr Begin
   uint16 us_Q;
   uint16 us_Np;
   uint16 us_Rp = 4;
   uint16 us_V;
   uint16 us_alpha;
   uint32 ul_ndr;
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr End

   s_ExcessSNR_for_BIMAX =
      gsa_ConstellationSNR[guc_MaxAllocBitsPerTone] - ATTNDR_SNRGAP;

   for (i = 0; i < gs_RxNumTones; i++)
   {
      if (IS_TONEFLAGSET(p_MEDLEYset_DS, i))
      {
         s_ExcessSNR = psa_SnrBuf[i] - s_DesiredMargin + s_CodingGain - ATTNDR_SNRGAP; // Q8.8
         if (s_ExcessSNR < 0)
            s_ExcessSNR = 0;
         if (s_ExcessSNR > s_ExcessSNR_for_BIMAX)
            s_ExcessSNR = s_ExcessSNR_for_BIMAX;

         ul_TotalDataRate += s_ExcessSNR;
      }
   }


   s_BitsPerFrame = QuickAverage(ul_TotalDataRate, (int16) (3 << 8));
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr Begin
   if(gt_ReTxConfigInfo.ft_ReTxOn == 0)
   {
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr End
      // Multiply by 4000 to get bits/second.
      MULS16(ul_TotalDataRate, s_BitsPerFrame, (int16) 4000);
      return (ul_TotalDataRate);
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr Begin
//In case of ReTx ATTNDRds = 4*L1attainable*(1-(2+V+Q*R1)/(Q*N1))
   }
   else
   {
      us_Q = gt_ReTxConfigInfo.us_Q;
      us_Np = us_Rp + gt_ReTxConfigInfo.us_H;;
      us_V = gt_ReTxConfigInfo.us_V;
      us_alpha = us_Q*(us_Np-us_Rp)-2-us_V; // 16.0

      if(us_Q==1)
      {
         ul_ndr  = 2000;
         ul_ndr  = ul_ndr * s_BitsPerFrame*us_alpha;
         // divide by Np and shift left
         if( (us_Np>>1) == ((us_Np+1)>>1) ) { // multiple of 2
            ul_ndr = (ul_ndr + ((us_Np+2)>>2)) / (us_Np>>1);
         }
         else
         {
            ul_ndr = ((ul_ndr + (us_Np>>1))/us_Np) << 1;
         }
      }
      else if (us_Q==2)
      {
         ul_ndr  = 1000;
         ul_ndr  = ul_ndr * s_BitsPerFrame*us_alpha;
         // divide by Np and shift left
         if( (us_Np>>1) == ((us_Np+1)>>1) ) { // multiple of 2
            ul_ndr = (ul_ndr + ((us_Np+2)>>2)) / (us_Np>>1);
         }
         else {
            ul_ndr = ( (ul_ndr + (us_Np>>1))/us_Np) << 1;
         }
      }
      else if(us_Q==3)
      {
         ul_ndr  = 500;
         ul_ndr  = ul_ndr * s_BitsPerFrame*us_alpha;
            // divide by Np and shift left

         if( (us_Np>>3) == ((us_Np+7)>>3) ) { // multiple of 8
            ul_ndr = (ul_ndr + ((us_Np+8)>>4)) / (us_Np>>3);
         }
         else if( (us_Np>>2) == ((us_Np+3)>>2) ) { // multiple of 4
            ul_ndr = ((ul_ndr + ((us_Np+4)>>3)) / (us_Np>>2)) << 1;
         }
         else if( (us_Np>>1) == ((us_Np+1)>>1) ) { // multiple of 2
            ul_ndr = ((ul_ndr + ((us_Np+2)>>2)) / (us_Np>>1)) << 2;
         }
         else
         {
            ul_ndr = ((ul_ndr + (us_Np>>1))/us_Np) << 3;
         }
         // divide by Q
         ul_ndr = (ul_ndr +1 )/3;
      }
      else if(us_Q==4)
      {
         ul_ndr  = 500;
         ul_ndr  = ul_ndr * s_BitsPerFrame*us_alpha;
         // divide by Np and shift left
         if( (us_Np>>1) == ((us_Np+1)>>1) ) {// multiple of 2
            ul_ndr = (ul_ndr + ((us_Np+2)>>2)) / (us_Np>>1);
         }
         else {
            ul_ndr = ( (ul_ndr + (us_Np>>1))/us_Np) << 1;
         }
      }
      else
      { //  Q=5
         ul_ndr  = 500;
         ul_ndr *= (s_BitsPerFrame*us_alpha);
            // divide by Np and shift left
         if( (us_Np>>3) == ((us_Np+7)>>3) ) { // multiple of 8
            ul_ndr = (ul_ndr + ((us_Np+8)>>4)) / (us_Np>>3);
         }
         else if( (us_Np>>2) == ((us_Np+3)>>2) ) { // multiple of 4
            ul_ndr = ((ul_ndr + ((us_Np+4)>>3)) / (us_Np>>2)) << 1;
         }
         else if( (us_Np>>1) == ((us_Np+1)>>1) ) { // multiple of 2
            ul_ndr = ((ul_ndr + ((us_Np+2)>>2)) / (us_Np>>1)) << 2;
         }
         else {
            ul_ndr = ((ul_ndr + (us_Np>>1))/us_Np) << 3;
         }
         // divide by Q
         ul_ndr = (ul_ndr + 2)/5;
      }

      return(ul_ndr);
   }
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr End
}


