/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   CalcCRC16_Byte.c
*
*  calculates the CRC of a message byte on a bit by bit basis.
*
*-------------------------------------------------------------------------
*/
#include "common.h"
#include "const_bis.h"
#include "tx_ops2.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "typedef.h"
#include "crc16.h"
#include "dsp_op.h"

/*^^^
*-----------------------------------------------------------------------------
*
*  The following function calculates the CRC of a message byte on a bit by bit basis,
*  starting from the LSB.

*  Prototype: void CalcCRC16_Byte(int16 *pus_C_CRC, uint8 uc_infoByte);
*
*  Input arguments:  uc_infoByte -  byte on which to calculate CRC.
*                 pus_C_CRC   -  (I/O) pointer to 16-bit CRC before and after uc_infoByte
*-----------------------------------------------------------------------------
^^^*/

C_SCOPE void CalcCRC16_Byte(uint16 *pus_C_CRC, uint8 uc_infoByte) {
   int16 j, us_infobit;

    for (j = 0; j < 8; j++) {
        us_infobit = (uint16) (uc_infoByte >> j);
        us_infobit &= 0x0001;
        CalcCRC16(pus_C_CRC, us_infobit);
    }
}


