/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   CalcHlinDiag.c
*
*   functions to build Hlin and LoopAttenuation test-parameters specific for
*  G.bis Diagnositics.
*
*-------------------------------------------------------------------------
*/
//-------------------------------------------------------------------------//
// CalcHlinDiag.c
//
// History :
//
// 30/08/2011 Sriram Shastry :  QLN/HLOG calibration for Annex-A DMT, ADSL2/2+. Calibration is done with respect to the
// line simulator generated refernce data.
//             Grep for "XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration"
//
// 21/11/2011 Hanyu: Ported MFD to VRx. Set NLNF IB bit6 to indicate loop length
//            data ready for NLNF decision.
//            Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo
//
// 05/12/2011 Balabath/Sabrina: Use LATN to estimate loop length. Conversion values needs to be
//            empirically determined against GMX EVM, E67, D57 and BRCM DSLAMs.
//            They were verified against other chipsets including CTLM, STM in
//            different modes and loop conditions (straight loops and bridgedtaps).
//            Grep for SMS01544218 FEATURE_ALL_DS_ALL_LoopEstimate
//
// 12/12/2011 Balabath: Use gs_hsk_tone_pwr_dB to estimate loop length.
//            Grep for XDSLRTFW-366 FEATURE_ALL_DS_ALL_LoopEstimate_HSK_POWER
//
// 19/01/2012 Balabath: Add DS Attenuation bias in ADSL2p to meet Telefonica requirements
//           Grep for XDSLRTFW-387 IOP_DS_ADSL2Plus_All_DSATNBias
//
//-------------------------------------------------------------------------//

#include "common.h"

#include "gdata.h"
#include "xgdata.h"
#include "rx_ops.h"
#include "pwr_ctbk.h"
#include "stdio.h"
#include "ghs.h"

#include "cmv.h"
#include "vecpwr.h"
#include "gdata_bis.h"
#include "hndshk_Data.h"
#include "snr.h"
#include "dsp_op.h"
#include "gdata_bis_diag.h"
#include "diagparam_bis.h"
#include <string.h>                    //for memset
#include "noiseacc.h"
#include "bitload_const.h"
#include "exchdata.h"
#include "T1413.h"
//#include "states.h"
#include "mul.h"
#include "DebugBuffer.h"

/* This is non-data dependent (constant) component of Reverb Reference magnitude */
#if 0
/* 37*10log10(2)in Q8.8 for DEC_QPSK_GAIN=0x2000 (Q3.13) and Inverse TSSI in (Q11.5) ==> 0x0020 */
#define REVERB_REF_MAGNITUDE_DB (14257)
#else
/* 20log10(sqrt(2))in Q9.7 for |2^k+j*(2^k)|=(2^k)*sqrt(2) */
#define REVERB_REF_MAGNITUDE_DB (C_10LOG10_2>>1)

#endif

#ifdef AMAZON_AFE
extern int16 gs_Adjust_LATN;
#endif

extern int16 gs_bis_Adjust_LATN;
extern int16 gs_plus_Adjust_LATN;
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ComputeHlin()
 *
 *  Description:  Computes the channel transfer function in linear scale and outputs
 *          data in format ready for loop diagnostics message.
 *          Also computes LoopAttenuation
 *
 *  Prototype:
 *    void ComputeHlin(int16 *psa_inbuf, uint8 *puca_msg_ld, int16 s_first_channel,
 *                   int16 s_last_channel)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Return:
 *
 *
 *  Global Variables Used:
 *    gpsa_RxHlin          --(I/O) (I) pointer to uncompensated channel transfer function Hlinprelim(f)
 *                            (O) pointer to array of scaled real & imag. components (a(f) & b(f)) of
 *                               Hlin(f) ([a(0)lsb, a(0)msb, b(0)lsb, b(0)msb,a(1)lsb,a(1)msb,etc.])
 *                               in Bis diagnostic message output format  such that
 *                               Hlin(f) = (gus_Hlin_scale/2^15)*(a(f)+j*b(f))/2^15
 *    gs_RxFirstChannel    --(I) first channel in the Hlin(f) calculation
 *    gs_RxLastChannel     --(I) last channel in the Hlin(f) calculation
 *    gs_PGA_set           --(I) current PGA setting, in dB (Q8.8)
 *    gus_Hlin_scale       --(I/O) (I) right shifts performed on uncompensated gpsa_RxHlin input
 *                            (O) scale factor for Hlin(f)
 *
 *    gt_CMsgPcbBis.uc_Min_US_PowerCutBack            --(I)
 *    gt_CMsgPcbBis.uc_Min_US_PowerCutBack            --(I)
 *    gt_TxPMDControl.s_NOMPSD_DS   --(I)
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

C_SCOPE void ComputeHlin(void)
{
    int16 *psa_inbuf, s_first_channel, s_last_channel, s_rightshiftComp;
   int16 s_firstcomp_channel, s_lastcomp_channel, s_channel;
   int16 i2, s_max, s_temp, s_right_shift, s_left_shift, *psa_temp;
   int16 s_HchanCompensate, s_maxHlinMantissa_allowed, s_pga, s_index;
    int32   l_Acc0;
   int16 s_refpsdDS, s_HchanComp_exp, s_Hlin_exp, s_HchanCompensate_Max;
   int16    s_first_index, s_last_index, s_ToneStepSize;
   uint16   us_scale;
   uint8 *puca_msg_ld;
   int i;

#ifdef DEBUG_TESTPARM
   FILE *fp;
   fp=fopen("testparam_debug10.txt","w");
   fprintf(fp,"gus_Hlin_scale=%d\n",gus_Hlin_scale);
      fprintf(fp, "\ngsa_RxHlin_in:\n");
   for(i=0; i<2*256; i++)
      fprintf(fp, "%d\n", gpsa_RxHlin[i]);
#endif

   // setup   input
   psa_inbuf = gpsa_RxHlin;
   puca_msg_ld = (uint8 *)(void *)gpsa_RxHlin;
   // Assume TSSI always applied
   // XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (Start_End)
   #ifdef ISDN
    // XDSLRTFW-775 PERF_DS_ALL_ALL_AnnexB_LATN_Calibration (Start_End)
   // Compensation from first Rx channel for LATN
      s_first_channel = gs_RxFirstChannel;
   #else
      s_first_channel = 1;
      // s_first_channel = gs_RxFirstChannel;   // Sriram : Start compensation from Channel 1 onwards
   #endif

   s_last_channel = gs_RxLastChannel;
   s_Hlin_exp = -(int16)gus_Hlin_scale; //account for data-dependent right-shifts performed on gpsa_RxHlin in EstimateChannel()

   if(( gl_SelectedMode & (MODE_G992_5)  ))
   {
      s_firstcomp_channel = (int16)RX_FILTERCOMP_FIRST_CHAN_PLUS;
      s_lastcomp_channel = (int16)RX_FILTERCOMP_LAST_CHAN_PLUS;
   }
   else
   {
      s_firstcomp_channel = (int16)RX_FILTERCOMP_FIRST_CHAN_BIS;
      s_lastcomp_channel = (int16)RX_FILTERCOMP_LAST_CHAN_BIS;
   }

   //check channel range
   if(s_first_channel < s_firstcomp_channel)
      s_first_channel = s_firstcomp_channel;
   if(s_last_channel > s_lastcomp_channel)
      s_last_channel = s_lastcomp_channel;
   if(s_last_channel < s_first_channel)
      return;

   // Find corresponding first and last index into input vector
   if(( gl_SelectedMode & (MODE_G992_5)  ))
   {
      s_first_index = s_first_channel >> 1;
      s_last_index = (s_last_channel-1) >> 1;
      s_first_channel = (s_first_index<<1) + 1;
      s_ToneStepSize = 2;
   }
   else
   {
      s_first_index = s_first_channel;
      s_last_index = s_last_channel;
      s_ToneStepSize = 1;
   }


   // Set up memory for temporary int16 array used before final output conversion.
   psa_temp = (int16 *)(void *)puca_msg_ld;

   // Keep everything in Q9.7 to expand dynamic range for input to log2lin()
   // which is needed by some of the input numbers in practice.  This way we
   // input y=log2lin(x/2) with x expected in Q8.8 and we compensate by
   // squaring the result y

   //get RefPsdUS in Q9.7
   gt_TxPMDControl.s_REFPSD_DS = gt_TxPMDControl.s_NOMPSD_DS - gt_TxPMDControl.us_pwr_cutback_DS*10;

   // convert to Q9.7 multiply by 128 and divide 10 (to take care of 0.1 dB steps)

   MULS16(l_Acc0, gt_TxPMDControl.s_REFPSD_DS, 26214);
   l_Acc0=l_Acc0>>11;

   s_refpsdDS=(int16) l_Acc0;

   s_refpsdDS += (int16)DEFAULT_NOMPSD_DS<<7;

   if ((gl_SelectedMode & MODE_ADSL2) == 0)
   {
      // set tone flag, currently all tones are set to 1, this is important mainly in BIS
      for (i=0 ; i<gs_RxNumTones ; i++)
      {
         SETTONEFLAG(p_MEDLEYset_DS, i);
      }
   }

   s_pga = gs_PGA_set_In_HLOG>>1;   //Q9.7 //XDSLRTFW_3753, gs_PGA_Set value used for HLOG measurement

#if 1
   // Use this code since desired magnitude in EstimateChannel() may change
    // First, find max(|psa_inbuf[]|)
    s_max = 0;
    for (i = 2*s_first_index; i <= 2*s_last_index+1; i++) {
      if((s_temp=psa_inbuf[i]) < 0)
         s_temp = -s_temp;

        if(s_temp > s_max)
        {
            s_max = s_temp;
        }
    }
   s_right_shift = 32 - norm_l((int32)s_max);  // <= (32 - 16)
#else
   // Because of data depended scaling used to achieve 0x0800 (desired magnitude) in EstimateChannel(),
   // s_right_shift will always equal 12
   s_right_shift = 12;
#endif


   // Compensation is done in log domain and converted to linear domain s_HchanComp*2^-s_HchanComp_exp
   // First, determine s_HchanComp_exp for all final compensation values by first considering
   // max(gsa_Rxfilter_comp_dB[s_chan]) and all other inputs used to determine final compensation value.
   // Use channel < 0 to indicate find channel with maximum compensation value.
   s_HchanCompensate_Max=RxFilterCompensate(0,s_pga,(int16)POWER_TO_DBM_PER_HERTZ, -1);

   //subtract off REFPSD
   s_HchanCompensate_Max -= s_refpsdDS;

   s_HchanCompensate_Max -= REVERB_REF_MAGNITUDE_DB;

   // Get s_HchanComp_exp and linear s_HchanCompensate
   logtolin(&s_HchanCompensate_Max,&s_HchanComp_exp,1);

   //Have to square result to get true answer
   l_Acc0 = (int32)s_HchanCompensate_Max*s_HchanCompensate_Max;
   s_rightshiftComp=16-norm_l(l_Acc0);
   if(s_rightshiftComp > 0)
      s_HchanCompensate_Max=(int16)round(l_Acc0,s_rightshiftComp);
   else
   {
      s_HchanCompensate_Max = sature16(l_Acc0);
      s_rightshiftComp=0;
   }


#ifdef DEBUG_TESTPARM
   fprintf(fp, "\n\ns_HchanComp_lin_exp=%d",s_HchanComp_exp);
   fprintf(fp, "\n[HchanCompensate_log\tsa_HchanCompensate_lin]:\n");
#endif

    for (i=s_first_index, s_channel=s_first_channel; i <= s_last_index; i++, s_channel+=s_ToneStepSize)
   {


      //get compensated input frequency samples in scaled dB Q9.7
      s_HchanCompensate = RxFilterCompensate(0,s_pga,(int16)POWER_TO_DBM_PER_HERTZ,s_channel);

      //subtract off REFPSD
      s_HchanCompensate -= s_refpsdDS;

      s_HchanCompensate -= REVERB_REF_MAGNITUDE_DB;

#ifdef DANUBE_AFE
#ifndef ISDN
if (( gl_SelectedMode & (MODE_G992_5)  ))
   s_HchanCompensate += gs_plus_Adjust_LATN;
else
   s_HchanCompensate += gs_bis_Adjust_LATN;
#endif
#endif

#ifdef DEBUG_TESTPARM
      fprintf(fp, "%d\t", s_HchanCompensate);
#endif
      //convert hlog to linear scale in s_matissa*2^s_exp
      logtolin(&s_HchanCompensate,&s_HchanComp_exp,0);

      //Have to square result to get true answer
      l_Acc0 = (int32)s_HchanCompensate*s_HchanCompensate;

      if(s_rightshiftComp > 0)
         s_HchanCompensate=(int16)round(l_Acc0,s_rightshiftComp);
      else
         s_HchanCompensate = sature16(l_Acc0);


#ifdef DEBUG_TESTPARM
      fprintf(fp, ",\t%d\n", s_HchanCompensate);
#endif


      // Compensate  Hlin_in().  Want to right_shift to get most dynamic range without
      // overflow assuming worst case: max(|psa_inbuf[]|)*max(|sa_HchanCompensate[]|).
        // real part
        l_Acc0 = (long)s_HchanCompensate * psa_inbuf[2*i];
        l_Acc0 = round(l_Acc0,s_right_shift);
        psa_temp[2*i] = sature16(l_Acc0);

        // imaginary part
        l_Acc0 = (long)s_HchanCompensate * psa_inbuf[2*i + 1];
        l_Acc0 = round(l_Acc0,s_right_shift);
        psa_temp[2*i + 1] = sature16(l_Acc0);
   }

   //update exp for this intermediate version Hlin.
   //First update compensation coeffiecient from squaring
   s_HchanComp_exp = 2*s_HchanComp_exp - s_rightshiftComp;
   s_Hlin_exp += (s_HchanComp_exp - s_right_shift);


#ifdef DEBUG_TESTPARM
   fprintf(fp, "\n\ns_Hlin_exp=%d",s_Hlin_exp);
   fprintf(fp, "\ngsa_RxHlin:\n");
   for(i=0; i<2*256; i++)
      fprintf(fp, "%d\n", psa_temp[i]);
#endif

   //compute loop attenuation from magnitude
   LoopAttenu_BIS(psa_temp,s_Hlin_exp,s_first_channel,s_last_channel,s_ToneStepSize);

   // Convert to final representation
   s_index = 0;
   //Lower subchannels
   for (i=0; i<s_first_index; i++)
   {
      puca_msg_ld[s_index++] = OUT_OF_RANGE_HLIN & 0xFF;
      puca_msg_ld[s_index++] = (OUT_OF_RANGE_HLIN>>8) & 0xFF;  //real
      puca_msg_ld[s_index++] = OUT_OF_RANGE_HLIN & 0xFF;
      puca_msg_ld[s_index++] = (OUT_OF_RANGE_HLIN>>8) & 0xFF;  //imag.
   }


   // Highest absolute value of a component that can be represented is 1.9999
   // (2^15-1)*2^-s_Hlin_exp < 2 ==>  s_Hlin_exp > 14 for MAX_16 to be allowed
   if(s_Hlin_exp < 14)
      s_maxHlinMantissa_allowed = (2<<s_Hlin_exp)-1; //<2
   else
      s_maxHlinMantissa_allowed = (int16) MAX_16;  // No limit. All int16 values will be less than 1.

   //find maximum representable Hlin to get scale factor
   s_max = 0;
   for (i = 2*s_first_index; i <= 2*s_last_index+1; i++)
   {

      s_temp = psa_temp[i];
      if (s_temp < 0)
         s_temp = -s_temp;

      if((s_temp > s_max)  && (s_temp <= s_maxHlinMantissa_allowed))
         s_max = s_temp;
   }


   //Find normalize shift count for s_max.  This is not strictly standard
   //compliant since we just left shift to normlize as opposed to scaling to
   //make s_max exactly equal to 0x7fff, but this should be acceptable.
   if(s_max==0)
   {
      //All Data points are out of range
      s_left_shift = MAX_16;  // This will trigger OUT_OF_RANGE setting below.

   }
   else
   {
      s_left_shift = norm_l((int32)s_max);
      s_left_shift -= 16;      // >= 14 - s_Hlin_exp since s_max <= s_maxHlinMantissa_allowed
   }

   //Data already scaled by (2^s_Hlin_exp)
   if(s_left_shift > 30 - s_Hlin_exp)
   {
      // Can not find suitable scale. Data too small to be represented;
      us_scale = 0;

      for (i = s_first_index; i <= s_last_index; i++)
      {
         puca_msg_ld[s_index++] = OUT_OF_RANGE_HLIN & 0xFF;
         puca_msg_ld[s_index++] = (OUT_OF_RANGE_HLIN>>8) & 0xFF;  //real
         puca_msg_ld[s_index++] = OUT_OF_RANGE_HLIN & 0xFF;
         puca_msg_ld[s_index++] = (OUT_OF_RANGE_HLIN>>8) & 0xFF;  //imag.
      }
   }
   else
   {
      if(s_left_shift == (14 - s_Hlin_exp)) {
         // This corresponds to scale = 2 in Q1.15 which can not be represented
         // as a power of 2 but only as 0xffff which we set here.
         us_scale = (uint16)0xffff;
      }
      else
         us_scale = (uint16)(0x1<<(30 - s_Hlin_exp - s_left_shift));

      for (i = s_first_index; i <= s_last_index; i++)
      {
         i2=2*i;

         s_temp = psa_temp[i2];
         if((s_temp < -s_maxHlinMantissa_allowed) || (s_temp > s_maxHlinMantissa_allowed))
         {
            puca_msg_ld[s_index++] = OUT_OF_RANGE_HLIN & 0xFF;
            puca_msg_ld[s_index++] = (OUT_OF_RANGE_HLIN>>8) & 0xFF;  //real
         }
         else
         {
            //store real part of output signal
            s_temp = (psa_temp[i2]<<s_left_shift);
            puca_msg_ld[s_index++] = s_temp & 0xFF;
            puca_msg_ld[s_index++] = (s_temp>>8) & 0xFF;
         }

         s_temp = psa_temp[i2+1];
         if((s_temp < -s_maxHlinMantissa_allowed) || (s_temp > s_maxHlinMantissa_allowed))
         {
            puca_msg_ld[s_index++] = OUT_OF_RANGE_HLIN & 0xFF;
            puca_msg_ld[s_index++] = (OUT_OF_RANGE_HLIN>>8) & 0xFF;  //imag
         }
         else
         {
            //store imag part of output signal
            s_temp = (psa_temp[i2+1]<<s_left_shift);
            puca_msg_ld[s_index++] = s_temp & 0xFF;
            puca_msg_ld[s_index++] = (s_temp>>8) & 0xFF;
         }
      }
   }


   //For upper subchannels
   //upto Annex defined # of tones
   //The following will fill upto the end of 256 element vector used
   for (i = (s_last_index+1); i<256; i++)
   {
      puca_msg_ld[s_index++] = OUT_OF_RANGE_HLIN & 0xFF;
      puca_msg_ld[s_index++] = (OUT_OF_RANGE_HLIN>>8) & 0xFF;  //real
      puca_msg_ld[s_index++] = OUT_OF_RANGE_HLIN & 0xFF;
      puca_msg_ld[s_index++] = (OUT_OF_RANGE_HLIN>>8) & 0xFF;  //imag.
   }

   gus_Hlin_scale = us_scale;

   gt_DS_LDParam.s_Hlin_scale = gus_Hlin_scale;  // This is populated here for read through CMVs

   //XDSLRTFW-4022 Hlog REPORTING calibration in ADSL
   if(gt_DS_LDParam.s_HLogReportDelta != 0)
   {
      gs_HLogReportDelta += gt_DS_LDParam.s_HLogReportDelta;
   }

   //convert Hlin to Hlog representation needed for both Data mode and Diag mode
   ComputeHlog(puca_msg_ld,gpuca_RMSG6_LD,(uint8*)(void *)&gus_Hlin_scale,0,255);

#ifdef DEBUG_STREAMING
   DSH_SendStream(DSH_HLOG,sizeof(int16)*255,&gsa_RxHlogDS[0]);
#endif

   //Do explicit memcopy here for data that will eventually be moved off-chip
   //memcpy((int8*)gsa_RxMargin,puca_msg_ld,4*gs_RxNumTones);


#ifdef DEBUG_TESTPARM
   fprintf(fp, "\nHlin:\n");
   for(i=0; i<2*gs_RxNumTones; i++)
   {
      if(s_ToneStepSize==1)
         fprintf(fp, "%d\n", psa_temp[i]);
      else
      {
         i2=i>>1;
         s_temp = (i-1)>>1;
         if(((i2+1) & 1) == 0)
            fprintf(fp, "%d\n", psa_temp[s_temp]);
         else
         {
            // interpolate subsampled Hlin
            if((psa_temp[s_temp-1] != OUT_OF_RANGE_HLIN) && (psa_temp[s_temp+1] != OUT_OF_RANGE_HLIN))
               fprintf(fp, "%d\n", (int16)(((int32)psa_temp[s_temp-1] + psa_temp[s_temp+1] + 1) >> 1));
            else
               fprintf(fp, "%d\n", OUT_OF_RANGE_HLIN);
         }
      }
   }
   /*print out gus_Hlin_scale */
   fprintf(fp, "\ngus_Hlin_scale:\n");
   fprintf(fp, "%d\n", gus_Hlin_scale);

   /*print out LoopAttenuation */
   fprintf(fp, "\nLoopAttenuation:\n");
   fprintf(fp, "%d\n", ((int16)guc_LoopAtten_MSB<<8) + guc_LoopAtten_LSB);
   fprintf(fp,"\ngt_RMsgPcb_bis.us_R_MIN_PCB_DS=%d\n",(int16)gt_RMsgPcb_bis.us_R_MIN_PCB_DS);
   fprintf(fp,"\ngt_RCMsgPcb_bis.us_C_MIN_PCB_DS=%d\n",(int16)gt_RCMsgPcb_bis.us_C_MIN_PCB_DS);
   fprintf(fp,"\nnompsd=%d\n",gt_TxPMDControl.s_NOMPSD_DS);
   fprintf(fp,"\npga=%d\n",gs_PGA_set);
   fprintf(fp,"\ns_ToneStepSize=%d\n",s_ToneStepSize);

   fclose(fp);
#endif

   guc_BkgdTaskState = TRAINING_DONE;
   return;

}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Prototype:
 *    void LoopAttenu_BIS(int16 *psa_Hlin_mantissa, int16 s_Hlin_exp,
 *                   int16 s_first_channel, int16 s_last_channel, int16 s_ToneStepSize)
 *
 *  Description:  Compute the average upstream loop attenuation
 *
 *
 *  Input Arguments:
 *      int16 *psa_Hlin_mantissa - Pointer to channel transfer function mantissa
 *                         in linear scale (real[0],imag[0],real[1],etc.
 *    int16 s_Hlin_exp     - Hlin exponent such that Hlin=psa_Hlin_mantissa[f]*2^-s_Hlin_exp
 *    int16  s_first_channel  - first channel in passband
 *    int16  s_last_channel   - last channel in passband
 *    int16 s_ToneStepSize    - step-size between sampled Hlin(f)
 *
 *  Output Arguments:
 *      none
 *
 *  Return:
 *    Average upstream loop attenuation in guca_RMSG1_LD
 *
 *  Global Variables Used:
 *    guca_RMSG1_LD[]
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
#define CORRECT6 60
C_SCOPE void LoopAttenu_BIS(int16 *psa_Hlin_mantissa, int16 s_Hlin_exp, int16 s_first_channel, int16 s_last_channel, int16 s_ToneStepSize)
{
   int32 l_Acc, l_rx_power;

#ifndef ISDN
   int32 l_Threshold;  //Fix_LATN_MAX_VALUE (Start_End)
#endif

   int16 s_pwr_db, s_numtones;
   uint16 us_bitmask;
   int16 s_X, s_tone, s_offset, s_shift, s_index;
   int s_i;
   //SMS01544218 FEATURE_ALL_DS_ALL_LoopEstimate (START_END)
   uint32 ul_awg24;
#if 1
   int16 s_HStone_pwr[81] = {22469, 22200, 21920, 21661, 21389, 21120, 20826, 20561, 20110, 19843, 19574, 19341, 19072,
                           18613, 18338, 17966, 17695, 17210, 16925, 16654, 16102, 15836, 15560, 15287, 15013, 14771,
                           14506, 14220, 13993, 13720, 13448, 13190, 13043, 12784, 12513, 12224, 11967, 11689, 11409,
                           11142, 10892, 10598, 10317, 10066, 9789, 9520, 9252, 9005, 8726, 8699, 8422, 8157, 8015,
                           7736, 7616, 7353, 7083, 6807, 6540, 6261, 6018, 5742, 5473, 5200, 4930, 4657, 4374, 4106,
                           3845, 3564, 3308, 3043, 2789,2148,1920,1698,1465,1214,962,710,458 };
   int16 s_looplength;
#endif
   //Compute the average power over band [gs_RxFirstChannel, gs_RxLastChannel]
   //Can not use VectorPower for now since data must be in XY memory
   //Also need to be able to exlude individual tones in the blackout set
   //l_Acc = VectorPower(psa_Hlin_mantissa, (int16) (2*s_first_channel), (int16)(2*(s_last_channel-s_first_channel+1)), RXPWR_GUARD_BITS);

   // s_ToneStepSize is either 1 or 2 for Bis or Plus respectively
   if(s_ToneStepSize==2)
   {
      s_offset = 1;
      s_shift = 1;
      us_bitmask=0x1;
   }
   else
   {
      s_offset = 0;
      s_shift = 0;
      us_bitmask = 0;
   }

   l_Acc=0;
   s_numtones = 0;
   for(s_i=2*s_first_channel; s_i<=2*s_last_channel+1; s_i++)
   {
      s_tone = s_i >> 1;
      if(IS_TONEFLAGSET(p_MEDLEYset_DS, s_tone))
      {
         s_index = (s_i-s_offset)>>s_shift;
         if(((s_tone+1) & us_bitmask) == 0)
            s_X=psa_Hlin_mantissa[s_index];
         else
         {
            // Interpolate subsampled Hlin by copying the previous nearest neighbor.
            // Do not use linear interpolation on Hlin data since it can produce large
            // oscillations in magnitude on short loops due to the liner phase in Hlin.
            s_X = psa_Hlin_mantissa[s_index-1];
         }
         l_rx_power=(int32)s_X * s_X;
         l_rx_power = round(l_rx_power, RXPWR_GUARD_BITS);

         l_Acc = l_add(l_Acc, l_rx_power);
         s_numtones++;
      }
   }

   //Acount for the fact that s_numtones counted real and imaginary components
   s_numtones >>=1;

   //divide by NSC
   //also need to exclude values that are out-of-range;
   l_Acc /=s_numtones;

   //Compute the average received power per frame in dB =
   //10*log10(gl_Rx_Total_Power) in Q8.8 format
   s_pwr_db = ConvertToDB(l_Acc);

    /* l_ipower = x_in*2^2*s_Hlin_exp, therefore s_pwr_db = 10log10(x_in) + 20*s_Hlin_exp*log10(2) */
    /* However, RxPower() already  right-shifted the results by RXPWR_GUARD_BITS bits */
    /* Therefore, compensate by setting psa_out[i] = s_temp - 10*(2*s_Hlin_exp-RXPWR_GUARD_BITS)*log10(2).  */
    l_Acc = (int32) -C_10LOG10_2 * (2*s_Hlin_exp - RXPWR_GUARD_BITS);
    l_Acc = l_add ((int32)s_pwr_db, l_Acc);
    s_pwr_db = sature16(l_Acc);

   // The standard defines this as a gain but only allows for attenuation > 0 to be represented
   // which is not realistic.  Transmit -s_pwr_db in diagnostic mode.
    s_pwr_db = -s_pwr_db;

#ifdef AMAZON_AFE
   // Adjust loop attenuation to compensate for the HPF and equalizer gain
   s_pwr_db -= gs_Adjust_LATN;
#endif


   //if s_pow_dBm in Q8.8 is outside the range  [0, 102.2]
   //then LATN cannot be represented in BIS Diagnostic Mode
   if(s_pwr_db < 0)
      l_Acc=0;  //Allow for some error in channel estimate
   // only for Bis/Plsu max allowed value 102.2
   //XDSLRTFW-387 IOP_DS_ADSL2Plus_All_DSATNBias(Start_End)
   else if ((s_pwr_db > MAX_ALLOWED_LATN) && ((gl_SelectedMode & MODE_ADSL2) != 0))
   {
      l_Acc = OUT_OF_RANGE_LOOPATTENU;
   }
   else
   {
      // Multiply by 10, discard fractionary part
      l_Acc = s_pwr_db * 10;
      l_Acc = (l_Acc + (int32)(1<<7)) >> 8;

            //if in DMT, we should report the value in 0.5dB step size
      if ((gl_SelectedMode & MODE_ADSL2) == 0)
      {
         int32 l_Acc_dmt;

         l_Acc_dmt = s_pwr_db << 1;
         l_Acc_dmt = (l_Acc_dmt + (int32)(1<<7)) >> 8;
         //XDSLRTFW-387 IOP_DS_ADSL2Plus_All_DSATNBias (start)
         //SMS00911694 SMS00907672 IOP_DS_T1413_All_DSATNBias (START)
         //Add DS Attenuation bias in T1413 to meet Telefonica requirements.
         if ( (STATArray[STAT_Mode] & STAT_ConfigMode_T1413) && (gt_INFX_CMV.us_OperatorSpBits2 & CMV_TO_ENABLE_T1413_DSATN_Bias) )
         {
#if 0  //TODO: need to compensate seperately!
            //IOP_DS_T1413_All_TelefonicaOnSite_DSATNBias_VeryShortLoops (Start)
            if (l_Acc_dmt > DSATN_T1413VERYSHORTLOOPS_THRESHOLD)
            {
               l_Acc_dmt += DSATNBIAS_T1413;
            }
            //IOP_DS_T1413_All_TelefonicaOnSite_DSATNBias_VeryShortLoops (End)
#ifndef ISDN
               //Since in DMT/T1413 LATN is in  0.5 dB steps and API expects it to be in steps of 0.1 dB
               //thats why factor of 5 used(already is multiplied by 2
               l_Acc = (l_Acc_dmt * 5); //SMS00954054 SMS00936038 SMS00907672 IOP_DS_T1413_All_DSATNBias (START_END)
#endif // only for Annex A
#endif //#if 0
         }
         //SMS00911694 SMS00907672 IOP_DS_T1413_All_DSATNBias (END)

        //Fix_LATN_MAX_VALUE (Start)
        if (l_Acc_dmt > OUT_OF_RANGE_ATTEN_DMT_T1413_FORMAT1)
           l_Acc_dmt = OUT_OF_RANGE_ATTEN_DMT_T1413_FORMAT1;
        //Fix_LATN_MAX_VALUE (End)
        //XDSLRTFW-387 IOP_DS_ADSL2Plus_All_DSATNBias (end)
         /* Save the loop attenuation in the R_MSGS2 and R_MSG_RA structures */
         gt_RMsg2.us_AvLoopAttenu = (uint16)l_Acc_dmt;
         gt_RMsgRA.us_AvLoopAttenu = (uint16)l_Acc_dmt;
      }
      //XDSLRTFW-387 IOP_DS_ADSL2Plus_All_DSATNBias(start)
      // SMS00910167 PERF_A_DS_PLUS_ALL_LATN_BIAS (START)
#ifndef ISDN
      // Calibrate LATN for ADSL2+ Annex A&M mode
      else if (((gl_SelectedMode & (MODE_ADSL2))) != 0)     /* XDSLRTFW-2390 */
      {
         if (((gl_SelectedMode & (ANNEX_M))) != 0)
         {
#if 0  //TODO: need to compensate seperately!
            l_Acc -= (G9925_ANNEXM_DS_LATN_BIAS); // -8dB
           //ADSLRTFW-1343 PERF_A_DS_PLUS_ALL_ATN_BenchmarkAR7 (START)
           //Fine tune the bias to in ADSL2+ AnnexM mode to meet
           //AR7 6.2.0.123 reference curve
           if (l_Acc < 0)
             l_Acc = 0;
           if (gt_INFX_CMV.us_OperatorSpBits3 & CMV_TO_ENABLE_ADSL2PLUS_ATN_BenchmarkAR7)
           {
             if (l_Acc < 50)
               l_Acc += 40;
             else if (l_Acc < 90)
               l_Acc += 35;
             else if (l_Acc < 420)
               l_Acc += 27;
             else if (l_Acc < 560)
               l_Acc += 20;
             else if (l_Acc < 650)
               l_Acc += 15;
             else
               l_Acc += 10;
           }
           //ADSLRTFW-1343 PERF_A_DS_PLUS_ALL_ATN_BenchmarkAR7 (END)
#endif //#if 0
         }
         else
         {

           //ADSLRTFW-1343 PERF_A_DS_PLUS_ALL_ATN_BenchmarkAR7 (START)
           if (gt_INFX_CMV.us_OperatorSpBits3 & CMV_TO_ENABLE_ADSL2PLUS_ATN_BenchmarkAR7)
           {

               //1degree less =>s_LATN_PLUS_A  =>  31 (31.0294) (31/32)*2^14 =>15872;
               //2degree less =>s_LATN_PLUS_A  =>  30 (29.9609) (30/32)*2^14 =>15360;
               //3degree less =>s_LATN_PLUS_A  =>  29 (28.9268) (29/32)*2^14 =>14848;
               //4degree less =>s_LATN_PLUS_A  =>  28 (27.9249) (28/32)*2^14 =>14336;
               //gt_INFX_CMV.s_FreeLocation2 = l_Acc; //TODO: Debug Only Remove
               l_Acc = (gt_INFX_CMV.s_LATN_PLUS_A*l_Acc) >>14;
           }
           //ADSLRTFW-1343 PERF_A_DS_PLUS_ALL_ATN_BenchmarkAR7 (END)
         }

      }
      else
      {
         // Calibrate LATN for ADSL2 Annex M mode
         if (((gl_SelectedMode & (ANNEX_M))) != 0)
         {
#if 0  //TODO: need to compensate seperately!
          //l_Acc += (G9923_ANNEXM_DS_LATN_BIAS); // +3dB
#endif
         }
      }

      //Fix_LATN_MAX_VALUE (Start)
      //Max allowed LATN = 102.2 dB in ADSL2/2+ modes
      // if the value is greater than this report 1023 in latn
      //Max allowed ATN = 63.5 dB in DMT/T1.413 modes
      l_Threshold = OUT_OF_RANGE_LOOPATTENU;
      if ((gl_SelectedMode & MODE_ADSL2) == 0)
          l_Threshold = OUT_OF_RANGE_ATTEN_DMT_T1413_FORMAT2; //Valid for DMT & T1.413 modes

      //ADSLRTFW-1343 PERF_A_DS_PLUS_ALL_ATN_BenchmarkAR7 (START)
      if (l_Acc > l_Threshold)
          l_Acc = l_Threshold;
      //ADSLRTFW-1343 PERF_A_DS_PLUS_ALL_ATN_BenchmarkAR7 (END)
      //Fix_LATN_MAX_VALUE (End)

#endif
   // SMS00910167 PERF_A_DS_PLUS_ALL_LATN_BIAS (END)
   //XDSLRTFW-387 IOP_DS_ADSL2Plus_All_DSATNBias(start)
   }

   gt_NearEndParam.us_LoopAttenuation = (uint16)l_Acc ;

#ifdef ISDN
    // Temprary workaround for LATN correction so that the LATN is as close
    // to Danube
   if (gl_SelectedMode & MODE_G992_1)
   {
   // Ensure that reported value is not negative
      if (gt_NearEndParam.us_LoopAttenuation > CORRECT6)
         gt_NearEndParam.us_LoopAttenuation -= CORRECT6;
      else
         gt_NearEndParam.us_LoopAttenuation = 0;

   }

#endif
   //XDSLRTFW-366 FEATURE_ALL_DS_ALL_LoopEstimate_HSK_POWER (START)

   if(gt_INFX_CMV.us_OperatorSpBits5 & CMV_TO_ENABLE_HSK_BASED_LOOPLENGTH )
   {
      for(s_i = 0; s_i< 81;s_i++)
      {
         if( gs_hsk_tone_power_dB > s_HStone_pwr[s_i])
            break;
      }
      s_looplength = s_i * 250;

      //gt_LoopLength_ft.us_loop24awg = s_looplength; //use only for debug
      gt_LoopLength_ft.us_loop26awg = s_looplength;
   }
   else //XDSLRTFW-366 FEATURE_ALL_DS_ALL_LoopEstimate_HSK_POWER (END)
   {
      //SMS01544218 FEATURE_ALL_DS_ALL_LoopEstimate (START)
      //LSFS+ D57 has different conversion parameters in ADSL2+ mode.
      //All paramenters were determined by experiemnts.
      if ((gs_CurrentCoChipset == GSI_CO_CHIPSET) &&
          (gs_CurrentCoVendorID == 0x0b) &&
          (gl_SelectedMode & (MODE_G992_5)))
      {
        if (gt_NearEndParam.us_LoopAttenuation < 100)
          gt_LoopLength_ft.us_loop26awg = gt_NearEndParam.us_LoopAttenuation * 20;
        else if (gt_NearEndParam.us_LoopAttenuation < 510)
          gt_LoopLength_ft.us_loop26awg = gt_NearEndParam.us_LoopAttenuation * 18 - 400;
        else if (gt_NearEndParam.us_LoopAttenuation < 600)
          gt_LoopLength_ft.us_loop26awg = (gt_NearEndParam.us_LoopAttenuation-10) * 19;
        else
          gt_LoopLength_ft.us_loop26awg = gt_NearEndParam.us_LoopAttenuation * 26 - 2500;

      }
      else
      {
        //if (gt_NearEndParam.us_LoopAttenuation < 100)
        //  gt_LoopLength_ft.us_loop26awg = gt_NearEndParam.us_LoopAttenuation * 20;
        //else if (gt_NearEndParam.us_LoopAttenuation < 420)
        //  gt_LoopLength_ft.us_loop26awg = (gt_NearEndParam.us_LoopAttenuation-10) * 20;
        //else if (gt_NearEndParam.us_LoopAttenuation < 600)
        //  gt_LoopLength_ft.us_loop26awg = gt_NearEndParam.us_LoopAttenuation * 21;
        //else
        //  gt_LoopLength_ft.us_loop26awg = gt_NearEndParam.us_LoopAttenuation * 25 - 2200;
        if (gt_NearEndParam.us_LoopAttenuation < 100)
          gt_LoopLength_ft.us_loop26awg = gt_NearEndParam.us_LoopAttenuation * 18;
        else if (gt_NearEndParam.us_LoopAttenuation < 350)
           gt_LoopLength_ft.us_loop26awg = (gt_NearEndParam.us_LoopAttenuation-10) * 18;
        else if (gt_NearEndParam.us_LoopAttenuation < 450)
          gt_LoopLength_ft.us_loop26awg = (gt_NearEndParam.us_LoopAttenuation-10) * 19;
        else if (gt_NearEndParam.us_LoopAttenuation < 600)
          gt_LoopLength_ft.us_loop26awg = gt_NearEndParam.us_LoopAttenuation * 21;
        else
          gt_LoopLength_ft.us_loop26awg = gt_NearEndParam.us_LoopAttenuation * 25 - 2200;

      }
   }//SMS01544218 FEATURE_ALL_DS_ALL_LoopEstimate_HSK_POWER ( START_END)
   //gus_LoopLength_ft_24AWG = gus_LoopLength_ft*4/3
   //T1.417 defines equivalent working loop length for a combination of line gauges.
   //equivalent working length (EWL): EWL = L26 + (0.75) * L24 + (0.60) * L22
   //+ (0.40) x L19 , where L26, L24, L22, and L19 are the lengths of 26-, 24-, 22-,
   //and 19-AWG cable in the subscriber loop.
   //4/3 is written as 1365/1024 to make the calculation more efficient.

   ul_awg24 = gt_LoopLength_ft.us_loop26awg * 1365;
   gt_LoopLength_ft.us_loop24awg = ul_awg24 >> 10;

   //SMS01544218 FEATURE_ALL_DS_ALL_LoopEstimate (END)
// XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
   //Bit6=1 indicates Loop length data ready for NLNF decision.
   gt_nlnf_metrics_ibs.us_NlnfIbs |= 0x40;
#endif
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
// XDSLRTFW-364: Feature_DS_All_All_NLNF_TrainingInfo (END)

}
