/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   CalcHlogDiag.c
*
*   functions to convert Hlin to Hlog test-parameter specific for
*  G.bis Diagnositics.
*
*-------------------------------------------------------------------------
*/

#include "common.h"

#include "gdata.h"
#include "xgdata.h"
#include "rx_ops.h"
#include "pwr_ctbk.h"
#include "stdio.h"
#include "ghs.h"

#include "cmv.h"
#include "vecpwr.h"
#include "gdata_bis.h"
#include "hndshk_Data.h"
#include "snr.h"
#include "dsp_op.h"
#include "gdata_bis_diag.h"
#include "diagparam_bis.h"
#include <string.h>                    //for memset
#include "noiseacc.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ComputeHlog()
 *
 *  Description:  Computes the channel transfer function magnitude in dB and outputs
 *          data in format ready for loop diagnostics message.
 *
 *  Prototype:
 *    ComputeHlog(int16 *puca_hlin, uint8 *puca_msg_ld, uint8 *puca_scale, int16 s_first_channel,
 *                   int16 s_last_channel)
 *
 *  Input Arguments:
 *      uint8 *puca_hlin - pointer to array of Hlin(f) in diagnostic format
 *    uint8 *puca_scale - char array storing Hlin scale factor in diag mode format (2 bytes)
 *    int16  s_first_channel  - first channel in the Hlog(f) calculation
 *    int16  s_last_channel   - last channel in the Hlog(f) calculation
 *
 *  Output Arguments:
 *      uint8 *puca_msg_ld - pointer to array to store Hlog(f) in Bis output format byte array
 *                   (except sequence number and reserved bits).
 *
 *  Return:
 *    none
 *
 *  Global Variables Used:
 *
 *  Notes: This function is used during R_MSG_LDx state to convert stored Hlin[] to Hlog[]
 *
 *------------------------------------------------------------------------
 *^^^
 */

C_SCOPE void ComputeHlog(uint8 *puca_hlin, uint8 *puca_msg_ld, uint8 *puca_scale, int16 s_first_channel, int16 s_last_channel) {

    int16    i;
    int32   l_ipower;
    int32   l_Acc0, l_Acc1;
    int16   s_X, s_Y, s_temp, s_index, s_exp;
   uint16 us_scale;

#ifdef DEBUG_TESTPARM
   FILE *fp;
   fp=fopen("testparam_debug.txt","w");
   fprintf(fp,"us_scale=%d\n",((uint16)puca_scale[1]<<8)+puca_scale[0]);
   fprintf(fp, "\nsa_Hlin:\n");
   for(i=0; i<2*256; i++)
      fprintf(fp, "%d\n", ((int16)puca_hlin[2*i+1]<<8)+puca_hlin[2*i]);
   fprintf(fp, "\nHlog:\n");
#endif

   // In this code the scale factor for Hlin is always a power of two (2^s_exp)
   // Compute s_exp = log2(us_scale)
   us_scale = ((uint16)puca_scale[1]<<8)+puca_scale[0];
   if(us_scale != (uint16)0xffff)
   {
      s_exp=0;
      while(us_scale>1)
      {
         us_scale>>=1;
         s_exp++;
      }
   }
   else
      s_exp = 16;

   //convert linear input to magnitude power in dB
   s_index = 0;
   for(i=s_first_channel; i<=s_last_channel; i++)
   {
      s_X = ((int16)puca_hlin[4*i+1]<<8)+puca_hlin[4*i];
      s_Y = ((int16)puca_hlin[4*i+3]<<8)+puca_hlin[4*i+2];

      if((s_X == OUT_OF_RANGE_HLIN) || (s_Y == OUT_OF_RANGE_HLIN))
      {
         puca_msg_ld[s_index++] = OUT_OF_RANGE_HLOG & 0xFF;
         puca_msg_ld[s_index++] = (OUT_OF_RANGE_HLOG>>8) & 0x3;
      }
      else
      {
         l_Acc0 = (int32)s_X * s_X;
         l_Acc1 = (int32)s_Y * s_Y;
         l_ipower = l_add(l_Acc0, l_Acc1);

         s_temp = ConvertToDB(l_ipower); // expects input in Q32.0, output in Q8.8

         /* l_ipower = x_in*2^2*(30-s_exp), therefore s_temp = 10log10(x_in) + 20*(30-s_exp)*log10(2) */
         /* Therefore, compensate by setting psa_out[i] = s_temp - 20*(30-s_exp)*log10(2).   */
         l_Acc0 = (int32) -C_20LOG10_2 * (30-s_exp);
         l_Acc0 = l_add ((int32)s_temp, l_Acc0);
         s_temp = sature16(l_Acc0);

#ifdef DEBUG_TESTPARM
         /*test print out*/
         fprintf(fp, "%f\n", (double)s_temp/256.0);
#endif
         // Convert Hlog to final representation (10 bits)
         // Hlog is in Q8.8 and range for representation is [-96dB, 6dB]
         if((s_temp > (6*256)) || (s_temp < (-96*256)))
         {
            puca_msg_ld[s_index++] = OUT_OF_RANGE_HLOG & 0xFF;
            puca_msg_ld[s_index++] = (OUT_OF_RANGE_HLOG>>8) & 0x3;
         }
         else
         {

            s_X = s_temp >> 3 ;  //preshift by 3 bits to avoid overflow
            s_X = (int16)(10*((6*32) - s_X) + (0x1<<4));
            s_X >>= 5 ;
            puca_msg_ld[s_index++] = s_X & 0xFF;
            puca_msg_ld[s_index++] = (s_X>>8) & 0x3;

         }
      }

   }

#ifdef DEBUG_TESTPARM
   fprintf(fp, "\nHlog_rep:\n");
   for(i=0; i<256; i++)
   {
      s_temp=((int16)puca_msg_ld[2*i+1]<<8)+puca_msg_ld[2*i];
      fprintf(fp, "%d\n",s_temp);
   }
   fclose(fp);
#endif
}
