/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *-------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   CalcNOMATP.c
 *
 *   Functions for computing nomatp
 *
 *-------------------------------------------------------------------------
 */
// ******************************************************************
// CalcNOMATP.c
//
// History
// 20/03/2013 ChihWen: Bug fix to correctly report PSD and ACATP in DELT mode.
//            Grep for XDSLRTFW-917 / ADSLRTFW-1645 BugFix_All_DELT_All_PSD_ACATP

// ******************************************************************
#include "common.h"
#include "bitload_const.h"
#include "rt_tones.h"
#include "dsp_op.h"
#include "snr.h"
#include "cmv.h"
#include "gdata_bis.h"
#include "decimalgain.h"
#include "gdata.h"
#include "mul.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Prototype:
 *    int16 CalcNOMATP( int16 s_RelativeNompsd, int16 s_DefaultNompsd, int16 s_DefaultMaxNomatp,
 *                int16 *psa_FineGains, int16 s_ExcessMarFGReduction, uint16 *pusa_Tssi_Value,
 *                RxToneFlags p_MEDLEYset, int16 s_numtones)
 *
 *  Description:  Compute nominal Aggregate  Transmit Power (NOMATP)
 *
 *
 *  Input Arguments:
 *      int16 s_RelativeNompsd      - relative   nompsd*10 (in 0.1dB step-size)
 *    int16 s_DefaultNompsd      - default absolute nompsd
 *    int16 s_DefaultMaxNomatp   - default absolute maxnomatp*10 (in 0.1dB step-size)
 *      int16 *psa_FineGains     - FineGains (linear) Q3.13
 *    int16 s_ExcessMarFGReduction
 *    uint16 *pusa_Tssi_Value    - Array of TSSI (or Inverse TSSI) values Q6.10 (Q11.5)
 *    FlagT ft_TSSI_inverse      - is True if ft_TSSI_values are inverted
 *      RxToneFlags p_MEDLEYset
 *      int16 s_numtones
 *
 *  Output Arguments:
 *      none
 *
 *  Return:
 *    nominal Aggregate  Transmit Power (NOMATP)
 *
 * Global Variables:
 *    gsa_MedleySnrBuf
 *    gsa_ConstellationSNR
 *    gs_RxMinBitsPerTone_BIS_TCM      - All needed during Diagnostics Mode only to set gain to 0 or 1
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
#define TEN_LOG_DELTA_F (9305)         /* 36.35 = 10*log10(4312.5) in Q8.8 */
#define C_10LOG10_2 (771)              /* 10log10(2) in Q8.8 */

C_SCOPE int16 CalcNOMATP(
   int16 s_RelativeNompsd,
   int16 s_DefaultNompsd,
   int16 s_DefaultMaxNomatp,
   int16 * psa_FineGains,
   int16 s_ExcessMarFGReduction,
   uint16 * pusa_Tssi_Value,
   RxToneFlags p_MEDLEYset,
   int16 s_numtones,
   int16 * s_NOMPSD_dBmHz)
{
   int16 i, s_nomatp, s_TotalGainPower_dB, s_X, s_Y, s_nompsd;
   int32 l_Acc0, l_ipower, l_temp;

   // Compute the total gain power over MedleySet
    l_ipower = 0;
   for (i = 0; i < s_numtones; i++)
   {
      if (IS_TONEFLAGSET(p_MEDLEYset, i))
      {
      // In Diag mode, gains are only 0 or 1 depending on if bits can be loaded on tone or not.
      // This function is only called on the Rx side during DiagMode.
         if(STATArray[STAT_MacroState] == STAT_LoopDiagMode)
         // Use SNR to determine whether the tone can support a bit or not
            //XDSLRTFW-917 / ADSLRTFW-1645 BugFix_All_DELT_All_PSD_ACATP (START)
            //if (gsa_MedleySnrBuf[i] <
            //    gsa_ConstellationSNR[gs_RxMinBitsPerTone_BIS_TCM])
            //   continue;   // gain=0 (no power on tone);
            //else
            //XDSLRTFW-917 / ADSLRTFW-1645 BugFix_All_DELT_All_PSD_ACATP (END)
               s_X = (int16)0x200;     //1 in Q3.9
         else
         {
            /* Change fine gains by excess margin reduction value */
            /* (s_ExcessMarFGReduction = 0x2000, if computing NOMATPus). */
            s_X = (int16)(((int32)psa_FineGains[i] * s_ExcessMarFGReduction) >> 17); // 3.9 (we can round numbers if need be)
                                                                  // Finegain is in 3.13, what is actually transmitted and used is 3.9
         }

         s_Y = (int16)pusa_Tssi_Value[i];  // TSSI is in .10 format

         l_Acc0 = (int32)s_X * s_Y;    //Q3.19


         l_Acc0 = round(l_Acc0, 6); // keep 16 bits
         s_X = sature16(l_Acc0);

         l_Acc0 = (int32)s_X * s_X;
         l_Acc0 = round(l_Acc0, RXPWR_GUARD_BITS);

         l_ipower = l_add(l_Acc0, l_ipower);
      }
   }
   s_TotalGainPower_dB = ConvertToDB(l_ipower) - (2*(19 - 6) - RXPWR_GUARD_BITS) * C_10LOG10_2;

   // Compute NomPSD in dBm/Hz *10
   MULS16(l_temp, s_DefaultNompsd, 10);
   *s_NOMPSD_dBmHz = s_RelativeNompsd + (int16)l_temp;

   // Convert s_RelativeNompsd from relative (.1 dB step size) to absolute Q8.8
   s_nompsd = (s_RelativeNompsd<<8)/10 + (s_DefaultNompsd<<8);

   s_nomatp = (int16)TEN_LOG_DELTA_F + s_nompsd + s_TotalGainPower_dB;  //Q8.8

   // Convert to 0.1 dB step size
   // Multiply by 10, discard fractionary part
   l_Acc0 = (int32)s_nomatp * 10;
   // round it up
   s_nomatp = (int16)((l_Acc0 +(1<<8) -1)>>8);

   // Return value relative to s_DefaultMaxNomatp
   s_nomatp -= s_DefaultMaxNomatp;

   return(s_nomatp);
}

