/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   CalcQlnDiag.c
*
*   functions to build QLN test-parameters specific for G.bis Diagnositics.
*
*-------------------------------------------------------------------------
*/
// ******************************************************************
// CalcQlnDiag.c
//
// History
//
// 16/04/2010 Nihar: Increase DS performance against Vinax in DTAG lab
//                    DTAG-lab shows higher WhiteNoise level => use -130dBm/Hz instead of
//                    -140dBm/Hz for White Noise detection
//                    Grep for IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz
//
// 22/04/2010 Nihar: Add FB noise detection in Annex-B
//                    To have a similar algorithm like in Annex-A two FB noise flags were added
//                    - STAT_FBNoise
//                    - STAT_FBNoiseLowThreshold
//                    Nevertheless in Annex-B FB noise shows a noise level > -105dBm/Hz approx. up to tone 100
//                    So only the lower threshold STAT_FBNoiseLowThreshold will be set - STAT_FBNoise will not
//                    be used at all
//                    1. Count how many tones are stronger than -105dBm/Hz
//                    2. If more tha 30 tones are stronger than -105dBm/Hz => set FBNoise-flag
//         Remark:    I think the whole noise detection algorithm has to be fine-tuned for Annex-B and Annex-M
//                    - the tone index starts at tone 36 (doesn't make sense for B/M but might corrupt the analysis)
//                    - thresholds for -130/-140dBm White noise are never met in presence of ISDN noise
//                    - Strong Noise calculation useless in Annex-B
//
// 14/05/2010 Nihar: QLN/HLOG calibration for Annex-B DMT, ADSL2/2+
//             Grep for Feature_DS_BisPlus_ALL_VR9QLNCalib
//
// 22/07/2010 Nihar: Detect FB noise and populate the CMV
//                  Grep for PERF_DS_BisPlus_CNXT_LimitDSPCB
//
// 26/07/2010 Nihar: Logic to add extra DS PCB to boost the DS data rate
//                   for short loops in Plus mode. All hashdefines/constants
//                   used as part of this logic are derived from experimentation results.
//                   By default its disabled. To enable it cw INFO 103 1 0x0040
//                   Grep for PERF_DS_PLUS_ALL_GeneralizedPcb
//
// 04/08/2010 Nihar: Turning on noise margin separation when WN on
//            tone 32 ~ 200 are below -135 dBm/Hz and tone 200 ~ 255 are
//            between -130 and -135 dBm/Hz
//            Grep for PERF_DS_ALL_ALL_M130M140WN_TO_ENABLE_NMS
//
// 30/08/2011 Sriram Shastry :  QLN/HLOG calibration for Annex-A DMT, ADSL2/2+. Calibration is done with respect to the
// line simulator generated refernce data.
//             Grep for "XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration"
//
// 23/02/2012 Sriram Shastry : Disable PLL bandwidth to reduce DS CRC for 24DSL noise CPE margin verification test.It was observed that if
//      RxAvgmargin drops from 3.5 dB to 2.5 dB , we see Burst of DS CRC's  as a result Sync is Lost.
//      Grep for : Enhc_DS_ALL_ALL_ByPassPLLBWIncrease
//
// 09/06/2010 Abu/Palaksha: Fix for "Fixed AM RFI disturber filtering issue" using  adaptive filter algorithm.
// The fix is under bit#1(0x0002) of CMV DSL 2 0 and by default Enabled.The code changes includes
// 1.Detect AM Radio RFI disturber from the QLN based on their power and width.
// 2. depending on the loop length and power of the detected RFI disturber FW determines
//       the most disturbing frequency which need to be notched.
//    --> getRfiDetection2(): this function use two more function
//       -->getWidening :  determines the widening effect of RFI noise from the QLN
//       -->LoopLengthFromGhsPower : determines loop length from the Ghs power ( in feet of meter)
// 3. getRfiDetection2() gives the frequency which need to be notched and based on that information we calculate
//    the filter coefficient on the fly.
//    -->calcNotchFilterBis(): This function also use two more function
//    -->cordic: calculates the sin and cosine value of an angle
//    -->div_uint32_by_uint16 :  used for unsigned 32 bit by unsigned 16 bit division
// Grep for PERF_DS_PLUS_ANNEXA_FIXED_RFI_DISTURBER_SINGLE_NOTCH SMS01364242
//
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
// 17/05/2013 Ram: Reduced White noise detection threshold for CNXT chipset (Lucent Stinger), to improve DS rates in BT loops.
//                 This was done as the flag gft_M140WhiteNoise was not getting SET in BT Loops.
//                 Grep for: XDSLRTFW-682: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops
//
// 28/05/2013 Ram: Extended the "Low threshold" scheme (135 tones) for detecting white noise to Bis/BisPlus modes as well, to improve
//                 DS rates in BT loops
//                 Grep for: XDSLRTFW-681: BugFix_DS_DMT_CNXT_No_Connect_in_19Kft_and_above_AnxL_Loops
//
//  29/06/2013 Palaksha: Fix for "XDSLRTFW-1011 : TR100BI2: B.5.4.c / B.5.4.d: DS Rates less than Baseline by up-to 1763 kbps"
//             Also seen DS CRC's on these loops and Fix Involves
//             (i)  In ADSL2+ QLN size is  512 and using s_IndexShift=1 when accessing guca_QLN in ADSL2+ will
//                lead to some False Noise flag detection
//             (ii) Dont use More DS PCB when gft_NotchPresent is NOT zero (DS PCB code under CMV_INFX_DFE_IOP_FIX_DS_PCB_ENABLE)
//          Grep for XDSLRTFW-1011 Bug_fix_Plus_DPBOdsRateissue
//
//30/09/2013 Balabath:It has been observed that during  loops 2500m ,3250m L3
// simple request was issued from DSLAM side after around 30s. and have a stable
// connection in the second session.This shows as a sync loss in the automation
// tests. This is CO generic problem. And more details can be found in
// jira XDSLRTFW-1214 attachments.
// Solution : To prove this TX clipping issue,some experiments were
// carried such as reduce fine gain RMS, I.e. set RMS to -2.5dB, By adjusting
// 'gt_TxPMDControl.s_MAXNOMATP_DS' through  CMV OPTN 23 and allow min fine
// gain range [RMSGi-2.5]dB and  max fine gain range of [RMSGi+2.5dB].
// This is This is added under CMV control of INFO 103 28 bit#14(mask #0x4000),
// And by default this is disabled.
// For testing we need to enable this bit from outside through 'dmms 6743 1C 1 4000 4000'
// Grep pattern  " XDSLRTFW-1214 IOP_DS_Plus_IKNS_ST_Stable "
//
//12/12/2013 Varun : QLN is common for all modes.No need to shift needed for ADSL2+ as QLN is 512 tones.
//                   Please refer jira for QLN capture information.
//                    Grep for XDSLRTFW-1250
//
// 13/03/2014 Sriram Shastry : Increase US data rate against  BRCM CO for A.1.4.3 24 HDSL NEXT impairment_testprofile AU_RA_L_30000K
//          Grep for XDSLRTFW-1464 : Perf_US_Plus_AnxA_BRCM_USPerf24HDSLNoise
//
// 19/12/2017 Chih-Wen: BER failed in TR100A 12ADSL2p DS FEXT MV test against Lucent Stinger.
//            In this test, new NMS was not kicked in. BER failed with 0.5dB more margin(optn 20 = 0xFF80).
//            BER passed with 1dB more margin(optn 20 = 0xFF00).
//
//            To kick in the fix of adding 1dB margin, the following conditions must be met.
//            1. ADSL2+ AnnexA.
//            2. CNXT CO.
//            3. FB noise is detected where STAT[STAT_Performance] sets "STAT_FBNoise" and "STAT_FBNoiseLowThreshold".
//               This is the case for TR100A 12ADSL2p DS FEXT MV test, TR100E FB RA 250m, 750m, 1250m.
//            4. STAT[STAT_Performance] does not set STAT_M90M100Noise. This is the case for TR100A 12ADSL2p DS FEXT MV test.
//
//            Grep for XDSLRTFW_3663_TR100A_MV_12ADSL2Plus_AddMargin
//
// 24/07/2019 Stefan: XDSLRTFW-4203  CTL, ADSL2p: DetectXtalk calculation does not work
//                cleanup
//                correct White-noise counters (they are called twice)
//
// 24/07/2019 Stefan: XDSLRTFW-4206  CTL, ADSL2p: Downstream low perf on 5-7kft Xtalk loop - NMS algo disabled
//                NMS gain is now turned on by default for all loops / noises (gft_AddNMS is always "TRUE" in Medley and Showtime)
//                correct Noise detection (false detection of line-noise was diabling NMS on multiple loops)
// ******************************************************************


#include "common.h"

#include "gdata.h"
#include "xgdata.h"
#include "rx_ops.h"
#include "pwr_ctbk.h"
#include "stdio.h"
#include "ghs.h"

#include "cmv.h"
#include "vecpwr.h"
#include "gdata_bis.h"
#include "hndshk_Data.h"
#include "snr.h"
#include "dsp_op.h"
#include "gdata_bis_diag.h"
#include "diagparam_bis.h"
#include <string.h>                    //for memset
#include "noiseacc.h"
#include "norm_acc48.h"
#include "gpersistent.h"
#include "STR_Filt.h"
#include "dec_adap_Data.h" //Enhance_DS_Bis_plus_DEC_Adapt_SlowDown(start_end)
#include "T1413.h"
#include "DebugBuffer.h"


// PERF_DS_ALL_ALL_M130M140WN_TO_ENABLE_NMS (Start)
#define M125WHITE_NOISE_THRESHOLD   (204)  //ADSLRTFW-1549 IOP_US_ADSL1_ADI_IncreaseTxMedleyNoise(Start_End)
#define M130WHITE_NOISE_THRESHOLD   (214)
// PERF_DS_ALL_ALL_M130M140WN_TO_ENABLE_NMS (End)


//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End): Increase QLN points to 512
//extern uint8 guca_QLN[RX_NUM_TONES>>1];
extern uint8 guca_QLN[RX_NUM_TONES];
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start)
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start)
//#ifndef ISDN // PERF_DS_PLUS_ANNEXA_FIXED_RFI_DISTURBER_SINGLE_NOTCH SMS01364242 (Start)

#define MIN_ABS_POWER_INC_AM    12    /* dB/2 */
#define MIN_MEAN_POWER_INC_AM   12 /* dB/2 */
#define SURROUNDING_TONES       5
#define MAX_LENGTH_QLN        512  //ADSLRTFW-1381 PERF_DS_PLUS_ANNEXA_512ToneQLN (Start_End)
#define MAX_NUM_DISTURBER       8

// filter implementation

#define PI_OVER_FN      1527744     // 2.30 unsigned  //(pi/2208)*2^30  for PLUS mode
#define PI_2_30         3373259426  // 2.30 unsigned  //(pi)*2^30
#define MUL             1073741824  // 2^30

#define FN_2            1104        // 2208/2 for PLUS mode

//Constants
#define cordic_1K 0x26DD3B6A
#define CORDIC_NTAB 24

#define FEET 0
#define METER 1

#define ANNEXB_POWER_THRESHOLD_FOR_RFI_NOTCH (-115)
//ADSLRTFW-1454 :PERF_DS_ALL_ANNEXAB_RFI (start)
#define POWER_THRESHOLD_FOR_RFI_NOTCH  (-115)
#define ANNEXA_RFINOTCH_START_FREQ  150
#define ANNEXB_RFINOTCH_START_FREQ  280
#define RFI_NOTCH_END_FREQ_512BINQLN   2208
#define RFI_NOTCH_END_FREQ_256BINQLN   1110
//STRONG_RFI_LEVEL_THRESHOLD is avg of -76.5 dBm/Hz( FT_RFI_level) -92dBm/Hz (AM_RFI_LEVEL)
#define STRONG_RFI_LEVEL_THRESHOLD   -85
#define RFI_LEVEL_M100DBMPHz   -100
#define RFI_LEVEL_M110DBMPHz   -110
#define RFI_LEVEL_M80DBMPHz    -80
//ADSLRTFW-1454 :PERF_DS_ALL_ANNEXAB_RFI (end)



/*^^^
*------------------------------------------------------------------------
*
*  Name : cordic
*
*   Prototype:
*       C_SCOPE void cordic(int32 l_theta, int32 *l_s, int32 *l_c, int16 n)
*
*   Abstract:
*        Cordic in 32 bit signed fixed point math which gives cos and sin of f0 (theta)
*     Function is valid for arguments in range -pi/2 -- pi/2
*     for values pi/2--pi: value = half_pi-(theta-half_pi) and similarly for values -pi---pi/2
*
*   Input Parameters:
*
*   Returns:
*
*   Global Variables:
*        cordic_ctab[]
*
*   Constants
*
*     1.0 = 1073741824.0
*     1/k = 0.6072529350088812561694
*     #define cordic_1K 0x26DD3B6A
*     #define CORDIC_NTAB 24
*
*-----------------------------------------------------------------------------
^^^*/

C_SCOPE void cordic(int32 l_theta, int32 *l_s, int32 *l_c, int16 n)
{
    int16 k;
    int32 l_tx, l_ty, l_tz, l_d;
    int32 l_x=cordic_1K,l_y=0,l_z=l_theta;

    n = (n>CORDIC_NTAB) ? CORDIC_NTAB : n;

    for (k=0; k<n; ++k)
    {

       l_d = l_z>=0 ? 0 : -1;
      // x^-1 -> (-x)
       l_tx = l_x - (((l_y>>k) ^ l_d) - l_d); // x - (1-(y*2^-k))
      l_ty = l_y + (((l_x>>k) ^ l_d) - l_d);
       l_tz = l_z - ((cordic_ctab[k] ^ l_d) - l_d);

       l_x = l_tx;
       l_y = l_ty;
       l_z = l_tz;
     }
    *l_c = l_x; *l_s = l_y;
}


/*^^^
*------------------------------------------------------------------------
*
*  Name : div_uint32_by_uint16
*
*   Prototype:
*       C_SCOPE uint16 div_uint32_by_uint16(uint32 l_num, uint16 s_denum)
*
*   Abstract:
*     Divide a 32 bit unsigned variable by a 16 bit unsigned variable
*     The result is 16bit unsigned. It is not checked whether the denumerator is 0.
*
*   Input Parameters:
*
*   Returns:
*
*   Global Variables:
*
*
*   Constants
*
*
*-----------------------------------------------------------------------------
^^^*/

C_SCOPE uint16 div_uint32_by_uint16(uint32 l_num, uint16 s_denum)
{
   int16 I=16;
    uint16 s_q = 0;
    uint32 l_rem, l_ovl = 0;

    while (I>=0)
    {
      l_rem = (l_num>>16) + l_ovl;
      if(l_rem >= s_denum)
      {
         s_q += (1<<I);
         l_num -= (s_denum<<16);
      }
      if(l_num > (1<<31)) {
         l_ovl += (1<<16);
         l_num -= (1<<31);
      }
      else
      {
         l_ovl = 0;
      }
      l_num = (l_num<<1);
      I--;
    }
    return s_q;
}

/*^^^
*------------------------------------------------------------------------
*
*  Name : calcNotchFilterBis
*
*   Prototype:
*       C_SCOPE void calcNotchFilterBis(int16 alpha, int16 beta, int16 f)
*
*   Abstract:
*     This functin calculates 7 Rx filter Coefficients for the Strymon Filter
*     which are:
*     inscale
*     b0  : for biquad 1
*     b1  : for biquad 1
*     b2  : for biquad 1
*     a0  : for biquad 2
*     a1  : for biquad 2
*     a2  : for biquad 2
*     b0_stage2 : for biquad 2
*
*
*     Note: The b coefficients have to be implemented in the 1st stage.
*        The a coefficients and b0_stage2 have to be implemented in the 2nd stage.
*        The remaining coefficients have to be set to 0.
*        a0 is by defualt set to 4096.
*
*
*
*   Input Parameters:
*
*     alpha, beta:  These variables define the radius of the pole/zero. Format
*                    alpha_ = 1-2^(15+alpha); beta_ = 1-2^-(15+beta)
*     f:            Centre frequency of the notch in kHz.
*
*
*   Returns:
*
*   Global Variables:
*
*
*   Constants
*
*
*-----------------------------------------------------------------------------
^^^*/
C_SCOPE void calcNotchFilterBis(int16 alpha, int16 beta, int16 f)
{

   int16    b0,b1,b2,a0,a1,a2,inscale,s, b0_stage2;
   int32      l_b1, l_b2, l_a1, l_a2, l_inscale, l_c, l_s;
   uint32 ul_f0, ul_a_gain, ul_b_gain, ul_b_max, ul_b_max2;
   uint16 u_b_gain, u_b_max;
   int32 l_temp;
   // int16 retVal = 0;

   /* get normalized frequency
         if f <= 1104 kHz we calculate pi*f/fN,
      otherwise f=pi(1-f/fN), where fN=2208kHz.
      We calculate f0 in 2.30 format. */

   ul_f0 = f*PI_OVER_FN; // 2.30 unsigned

   if(f>FN_2)
      ul_f0 = PI_2_30 - ul_f0;

   /* get cos and sin of f0 (we only need the cos) */
   cordic((int32)(ul_f0),&l_s,&l_c,24);

   if(f>FN_2)  //#define FN_2 1104
      l_c=-l_c;

   /*  b0 = 1
      b1 = -2*(1-beta)*cos(f0)
      b2 = (1-beta)^2
      a0 = 1
      a1 = -2*(1-alpha)*cos(f0)
      a2 = (1-alpha)^2 */

   l_b1 = (l_c + (1<<(14-beta)))  >> (15-beta);
   l_b1 = (-l_c+l_b1)<<1;
   l_b2 = MUL - (1<<(16+beta))  + (1<<(beta<<1));
   l_a1 = (l_c + (1<<(14-alpha))) >> (15-alpha);
   l_a1 = (-l_c+l_a1)<<1;
   l_a2 = MUL - (1<<(16+alpha)) + (1<<(alpha<<1));

   /* get the filter gains of b(z) and b(z)/a(z)
      We know that the max. gain of both functions is either at f=0 or at f=fN;
      Therefore the calculation of these gains is very simple */

   if(l_a1<0)
      ul_a_gain = MUL + (uint32)(-l_a1+l_a2);
   else
      ul_a_gain = MUL + (uint32)(l_a1+l_a2);
   if(l_b1<0) {
      ul_b_gain = MUL + (uint32)(-l_b1+l_b2);
      ul_b_max  = (uint32)(-l_b1)>(uint32)(l_b2) ? (uint32)(-l_b1) : (uint32)(l_b2);
   }
   else {
      ul_b_gain = MUL + (uint32)(l_b1+l_b2);
      ul_b_max  = (uint32)(l_b1) > (uint32)(l_b2) ? (uint32)(l_b1) : (uint32)(l_b2);
   }
   ul_b_max  = (MUL>ul_b_max) ? MUL : ul_b_max;

    /* calculate the sign (required to set the coefficient with maximum absolute value to -8192) */
   if((int32)(ul_b_max) == -(l_b1))
      s =  1;
   else
      s =- 1;

   /* scale and convert the output to 3.13 format
   convert b_gain to 2.14 format */
   ul_b_gain  = (ul_b_gain+(1<<15))>>16;
   u_b_gain   = (uint16)ul_b_gain;
   l_inscale  = (ul_b_max+8)>>4;
   l_inscale += (ul_b_gain>>1);

    inscale = div_uint32_by_uint16((uint32)l_inscale,u_b_gain);

   /* convert bmax to 1.15 */
   ul_b_max  = (ul_b_max+(1<<14))>>15;
   ul_b_max2 = (ul_b_max+1)>>1;
   u_b_max   = (uint16)ul_b_max;


   b0 = div_uint32_by_uint16( (1<<28)+ul_b_max2 , u_b_max);
   // b0 = s*(int32)(b0);
   MULS32x16(l_temp, (int32)(b0), s);
   b0 = l_temp;

   l_b1 = (l_b1+2)>>2;
   l_b2 = (l_b2+2)>>2;

   if(l_b1>0)
   {
      b1 = div_uint32_by_uint16((uint32)(l_b1+ul_b_max2),u_b_max);
      //b1 = s*(int32)(b1);
      MULS32x16(l_temp, (int32)(b1), s);
      b1 = l_temp;

   }
   else
   {   b1 = div_uint32_by_uint16((uint32)(-l_b1+ul_b_max2),u_b_max);
      //b1 = (-s)*(int32)(b1);
      MULS32x16(l_temp, (int32)(b1), -s);
      b1 = l_temp;
   }

   b2 = div_uint32_by_uint16((uint32)(l_b2 + ul_b_max2) ,u_b_max);
   //b2 = s*(int32)(b2);
      MULS32x16(l_temp, (int32)(b2), s);
   b2 = l_temp;


   a0 = 4096;
   if(l_a1>0)
      a1 =  (l_a1  + (1<<17))>>18;
   else
      a1 = -((-l_a1 + (1<<17))>>18);
   a2 = (l_a2 + (1<<17))>>18;

   /* The first b coefficient of the 2nd stage is used for output scaling */
   //b0_stage2 = s*((ul_a_gain + (1<<18))>>19);
   MULS32x16(l_temp, (int32)(((ul_a_gain + (1<<18))>>19)), s);
   b0_stage2 = l_temp;

#ifdef DANUBE_ONLY
   gpsa_DataLogBuffer[gus_DataBufferCnt++] = (int16)f;
   gpsa_DataLogBuffer[gus_DataBufferCnt++] = (int16)inscale;
   gpsa_DataLogBuffer[gus_DataBufferCnt++] =  (int16)b0;
   gpsa_DataLogBuffer[gus_DataBufferCnt++] =  (int16)b1;
   gpsa_DataLogBuffer[gus_DataBufferCnt++] =  (int16)b2;
   gpsa_DataLogBuffer[gus_DataBufferCnt++] =  (int16)a0;
   gpsa_DataLogBuffer[gus_DataBufferCnt++] =  (int16)a1;
   gpsa_DataLogBuffer[gus_DataBufferCnt++] =  (int16)a2;
   gpsa_DataLogBuffer[gus_DataBufferCnt++] =  (int16)b0_stage2;
#endif
// ADSLRTFW-1382 PERF_DS_ALL_ANNEXA_FIXED_RFI_DISTURBER_ALLmodes (Start)
#if 0
         p_QLNInfo->gsa_StrymonIir_Filter_DecimHpf_2_with_Notch[2]  =   (int16)inscale;
         p_QLNInfo->gsa_StrymonIir_Filter_DecimHpf_2_with_Notch[5]  =   (int16)b0;
         p_QLNInfo->gsa_StrymonIir_Filter_DecimHpf_2_with_Notch[6]  =   (int16)b1;
         p_QLNInfo->gsa_StrymonIir_Filter_DecimHpf_2_with_Notch[7]  =   (int16)b2;
         p_QLNInfo->gsa_StrymonIir_Filter_DecimHpf_2_with_Notch[8]  =   -(int16)a2;
         p_QLNInfo->gsa_StrymonIir_Filter_DecimHpf_2_with_Notch[9]  =   -(int16)a1;
         p_QLNInfo->gsa_StrymonIir_Filter_DecimHpf_2_with_Notch[12] =   (int16)b0_stage2;
#endif
         p_QLNInfo->gs_inscale   = inscale;
         p_QLNInfo->gs_b0     = b0;
         p_QLNInfo->gs_b1     = b1;
         p_QLNInfo->gs_b2     = b2;
         p_QLNInfo->gs_a2     = a2;
         p_QLNInfo->gs_a1     = a1;
         p_QLNInfo->gs_b0_stage2= b0_stage2;
// ADSLRTFW-1382 PERF_DS_ALL_ANNEXA_FIXED_RFI_DISTURBER_ALLmodes (End)

}


/*^^^
*------------------------------------------------------------------------
*
*  Name : LoopLengthFromGhsPower
*
*   Prototype:
*       C_SCOPE int16 LoopLengthFromGhsPower(FlagT ft_MeterFeet)
*
*   Abstract:
*     Gives the loop length in Feet or Meter from the Ghs Rx tone power and the
*     PGA required in Ghs information. all the offsets used in the funcion are
*     derived from the Munich Lab setup.
*
*     Due to the Ghs Tone power calculation bug at -Ve or 0 PGA cases we saw
*     step function in the Ghs tone power vs loop length curve. This is the reason
*     why we used  s_offset_low and s_offset_high.
*
*
*   Input Parameters:
*     FEET or METER
*   Returns:
*     loop length in FEET or Meter
*
*   Global Variables:
*        gs_hsk_tone_power_dB
*     gs_PGA_required_In_GHS
*     gs_CurrentCoChipset
*
*   Constants
*
*
*-----------------------------------------------------------------------------
^^^*/

C_SCOPE int16 LoopLengthFromGhsPower(FlagT ft_MeterFeet)
{
   int32 l_looplength = 0;
   int16 s_offset_low, s_offset_high, s_offset;

#if 0
    if(gs_CurrentCoChipset == BDCM_CO_CHIPSET)
   {
      s_offset_low = 22300;
      s_offset_high = 21000;
   }
   else if(gs_CurrentCoChipset == GSI_CO_CHIPSET)
   {
      s_offset_low = 21880;
      s_offset_high = 20600;
   }
   else if(gs_CurrentCoChipset == CTLM_CO_CHIPSET)
   {
      s_offset_low = 22980;
      s_offset_high = 21650;
   }
   else // default including Geminax
#endif
   {
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start): calibration for VR9: add 1 dB to the higher threshold
// and substract 0.5dB from the lower threshold
//       s_offset_low = 22500;
//       s_offset_high = 21375;
      s_offset_low = 22500 - 128;
      s_offset_high = 21375 + 256;
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (End)

   }


   if((gs_hsk_tone_power_dB >= s_offset_low) &&(gs_PGA_required_In_GHS <= 0))
         return 0;

   if (gs_PGA_required_In_GHS <= 0)
      s_offset = s_offset_low;
   else
      s_offset = s_offset_high;

   // loop length in ft
   switch (ft_MeterFeet)
   {
      case FEET : // loop length in ft
         MULS32x16(l_looplength, (int32)(s_offset-gs_hsk_tone_power_dB), 60000);
            break;

         case METER :   // loop length in m
         MULS32x16(l_looplength, (int32)(s_offset-gs_hsk_tone_power_dB), 18288);
            break;

    }
   return (int16)(l_looplength>>16);

}


/*^^^
*------------------------------------------------------------------------
*
*  Name : GetFreqForRxFilter
*
*   Prototype:
*       C_SCOPE void GetFreqForRxFilter(void)
*
*   Abstract:
*        Based on the detected RFI Frequency, RFI power and the loop length this function
*        gives the frequency which need to be notched out
*
*        Currently this function gives only one final frequency to be notchd out but it stores
*        all the frequency which could be notched in future in p_QLNInfo->gusa_fNotchedDisturber[] and
*     p_QLNInfo->gsa_pNotchedDisturber[] variables
*
*     The decision metric was derived based on the LAB experiment.
*
*   Input Parameters:
*
*   Returns:
*     gs_activefilterfreq
*
*   Global Variables:
*        p_QLNInfo->gusa_fDisturber[] :  power level in dBm/Hz
*     p_QLNInfo->gsa_pDisturber[] : center frequency in kHz - Assumption: f is a multiple of 9 kHz
*     p_QLNInfo->gusa_fNotchedDisturber[] : center frequency in kHz which could be notched out
*     p_QLNInfo->gsa_pNotchedDisturber[] :   corresponding power level which could be notched out
*
*
*   Funcion used:
*     LoopLengthFromGhsPower2
*
*-----------------------------------------------------------------------------
^^^*/



C_SCOPE void GetFreqForRxFilter(void)
{
   int16 d0,d1,d2,d3; // decision variable
   int16 s_ActiveRfiPWR;
   int16 s_end_freq,s_start_freq;
   int16 i;

   gs_EstimatedLoopLength = LoopLengthFromGhsPower(FEET);
// gs_EstimatedLoopLength = 7500;
   guc_numNotchedDisturber = 0;

   for (i = 0; i < guc_numDisturber; i++)
   {
      // decison 1: d0
      if ( p_QLNInfo->gusa_fDisturber[i]> 0)
         d0 = TRUE;
      else
         d0 = FALSE;

      // decision 2: d1
      // power high enough ?
#ifdef ISDN
      s_start_freq = ANNEXB_RFINOTCH_START_FREQ; //280kHz
#else
      s_start_freq = ANNEXA_RFINOTCH_START_FREQ; //150kHz
#endif

#ifdef ISDN  // For Annex B
      //Enhance_DS_Bis_plus_RFI_Notch_apply (start_end)
      if (p_QLNInfo->gsa_pDisturber[i]> ANNEXB_POWER_THRESHOLD_FOR_RFI_NOTCH) //-115
      {
         d1 = TRUE;
      }
      else
         d1 = FALSE;
      // ADSLRTFW-1395  PERF_DS_PLUS_ANNEXB_FIXED_RFI_DISTURBER (Start)
      // decison 3: d2
      // f too high ?
      //Enhance_DS_Bis_plus_RFI_Notch_apply(start_end)
      //   Enhance_DS_Bis_RFI_Notch_OOB (Start_End)
      //Enhance_DS_ADSL1_ANNEXAB_512Tone_QLN (Start_End)
      //512 Bin QLN in all modes based on CMV setting.Enbled bydefault in RCQuiet1RxF_bis.c
      //and RCQuiet2RxF.c
      if (STATArray[STAT_QLN_Performance] & STAT_512Bin_QLN_ON)
         s_end_freq = RFI_NOTCH_END_FREQ_512BINQLN; //2208
      else
         s_end_freq = RFI_NOTCH_END_FREQ_256BINQLN; //1110


      if(p_QLNInfo->gusa_fDisturber[i] < s_end_freq) //;1500 =>2208
         d2 = TRUE;
      else
         d2 = FALSE;

      // decision 4: d3
      // f too low ?
      //s_start_freq = 280; //declared above
      if(p_QLNInfo->gusa_fDisturber[i] > s_start_freq)
           d3 = TRUE;
      else
           d3 = FALSE;

      // ADSLRTFW-1395  PERF_DS_PLUS_ANNEXB_FIXED_RFI_DISTURBER (End)
#else // For Annex A
      // Apply Notch filter only if power is >-115 dBm/Hz
      if (p_QLNInfo->gsa_pDisturber[i]> POWER_THRESHOLD_FOR_RFI_NOTCH)
      {
         //ADSLRTFW-1454 :PERF_DS_ALL_ANNEXAB_RFI(start)
         if(p_QLNInfo->gsa_pDisturber[i] > gs_active_Power)
         {
            gs_active_Power = p_QLNInfo->gsa_pDisturber[i];
         }
         //ADSLRTFW-1454 :PERF_DS_ALL_ANNEXAB_RFI(end)
         // if power is <-100 don't apply Notchfilter upto 5500ft
         if((gs_EstimatedLoopLength < 5500) &&(p_QLNInfo->gsa_pDisturber[i]<= RFI_LEVEL_M100DBMPHz))
            d1 = FALSE;
         // if power is <-110 don't apply Notchfilter upto 6500ft
         else if((gs_EstimatedLoopLength < 6500) &&(p_QLNInfo->gsa_pDisturber[i]<= RFI_LEVEL_M110DBMPHz))
            d1 = FALSE;
         else
            d1 = TRUE;
      }
      else
         d1 = FALSE;

// ADSLRTFW-1382 PERF_DS_ALL_ANNEXA_FIXED_RFI_DISTURBER_ALLmodes (Start)
   if ((gl_SelectedMode & (MODE_G992_5)))
   {
      // Decision d2 and d3 are modified
      //ADSLRTFW-1454 :PERF_DS_ALL_ANNEXAB_RFI (start)
      // decision 2 is to disable the notch filter at higher loop lengths since there won't
      // be any bitloading at higher bins as the loop length increases.
      // But this logic is removed as there is no degradation of data rate when notch filter
      // is enabled/disable and improved number of CRC's and SNRM when Notch filter is applied
      // Now d2 is used to check the higher frequency (redundant !)

      // decision 3 logic is enhanced to improve data rate considering on the RFI power level also.
      // Observed that Data rate degration depends on the RFI frequency,looplength &RFI power level as well.

#if 0
      // decison 3: d2
      // f too high ?
      if ( (p_QLNInfo->gusa_fDisturber[i] < 700) || (gs_EstimatedLoopLength < 12500)
         && (p_QLNInfo->gusa_fDisturber[i] < 900) || (gs_EstimatedLoopLength < 10500)
         && (p_QLNInfo->gusa_fDisturber[i] < 1250) || (gs_EstimatedLoopLength < 8500)
         && (p_QLNInfo->gusa_fDisturber[i] < 1500) || (gs_EstimatedLoopLength < 6500))

         d2 = 1;
      else
         d2 = 0;

      // decision 4: d3
      // f too low ?
      if ( (p_QLNInfo->gusa_fDisturber[i] > 150) && (gs_EstimatedLoopLength > 11500)
         || (p_QLNInfo->gusa_fDisturber[i] > 250) && (gs_EstimatedLoopLength > 8500)
         || (p_QLNInfo->gusa_fDisturber[i] > 350) && (gs_EstimatedLoopLength > 7500)
         || (p_QLNInfo->gusa_fDisturber[i] > 450) && (gs_EstimatedLoopLength > 5500)
         || (p_QLNInfo->gusa_fDisturber[i] > 1100) && (gs_EstimatedLoopLength > 4500))

         d3 = 1;
      else
         d3 = 0;
#else
      //512 Bin QLN in all modes based on CMV setting.Enbled bydefault in RCQuiet1RxF_bis.c
      //and RCQuiet2RxF.c
      if (STATArray[STAT_QLN_Performance] & STAT_512Bin_QLN_ON)
         s_end_freq = RFI_NOTCH_END_FREQ_512BINQLN; //2208;
      else
         s_end_freq = RFI_NOTCH_END_FREQ_256BINQLN;//1110;

      // decision 2 (d2) is to check whether the RFI frequency is within limits of
      // start and end frequencies.
      if((p_QLNInfo->gusa_fDisturber[i] > s_start_freq) && (p_QLNInfo->gusa_fDisturber[i] < s_end_freq ) )
         d2 = TRUE;
      else
         d2 = FALSE;

      d3 = TRUE; // deafult
      //Disable in the following cases if the power is greater than -85dBm/Hz
      if(p_QLNInfo->gsa_pDisturber[i] > STRONG_RFI_LEVEL_THRESHOLD) // -85.
      {
         if (  ((gs_EstimatedLoopLength < 6500) && (p_QLNInfo->gusa_fDisturber[i] < 250))
            ||((gs_EstimatedLoopLength < 6200) && (p_QLNInfo->gusa_fDisturber[i] < 350))
             ||((gs_EstimatedLoopLength < 4800) && (p_QLNInfo->gusa_fDisturber[i] < 450))
            )
               d3 = FALSE;

      }
      //Disable in the following cases if the power is less than -85dBm/Hz
      else //(gsa_pDisturber[i] <= STRONG_RFI_LEVEL_THRESHOLD) // avg of -77dBm/Hz and -92dBm/Hz
      {
         if ( (gs_EstimatedLoopLength < 2000)
            ||    ((gs_EstimatedLoopLength < 2800) && (p_QLNInfo->gusa_fDisturber[i] < 1700))
            || ((gs_EstimatedLoopLength < 3500) && (p_QLNInfo->gusa_fDisturber[i] < 1600))
            ||  ((gs_EstimatedLoopLength < 4500) && (p_QLNInfo->gusa_fDisturber[i] < 1200))
            ||  ((gs_EstimatedLoopLength < 5500) && (p_QLNInfo->gusa_fDisturber[i] < 1000))
            ||  ((gs_EstimatedLoopLength < 6000) && (p_QLNInfo->gusa_fDisturber[i] < 450))
            ||  ((gs_EstimatedLoopLength < 7500) && (p_QLNInfo->gusa_fDisturber[i] < 350))
            ||  ((gs_EstimatedLoopLength < 10500) && (p_QLNInfo->gusa_fDisturber[i] < 250))
         )
            d3 = FALSE;

      }
#endif
      // ADSLRTFW-1454 :PERF_DS_ALL_ANNEXAB_RFI(end)
   }
   else
   {
      d3 = TRUE;
      d2 = TRUE;
   }
// ADSLRTFW-1382 PERF_DS_ALL_ANNEXA_FIXED_RFI_DISTURBER_ALLmodes (End)
#endif  //#ifdef ISDN

      if (d0&d1&d2&d3 == TRUE)
      {
         p_QLNInfo->gusa_fNotchedDisturber[guc_numNotchedDisturber] = p_QLNInfo->gusa_fDisturber[i];
         p_QLNInfo->gsa_pNotchedDisturber[guc_numNotchedDisturber] =  p_QLNInfo->gsa_pDisturber[i];
         guc_numNotchedDisturber++;
      }


   }  // end  (i = 0; i < guc_numDisturber; i++)
//ADSLRTFW-1407 PERF_DS_BisPLUS_ANNEXB_512ToneQln_DualNotch(start_end)
#if 0 //def ISDN  // For Annex B
// ADSLRTFW-1395  PERF_DS_PLUS_ANNEXB_FIXED_RFI_DISTURBER (Start)
// single notch filter frequency
   if ( guc_numNotchedDisturber > 1)
   {
      s_ActiveRfiPWR = p_QLNInfo->gsa_pNotchedDisturber[0];
      gs_activefilterfreq = (int16)p_QLNInfo->gusa_fNotchedDisturber[0];

      for ( i = 1; i<=guc_numNotchedDisturber-1; i++)
      {
         if (  s_ActiveRfiPWR <= p_QLNInfo->gsa_pNotchedDisturber[i])
         {

            s_ActiveRfiPWR = p_QLNInfo->gsa_pNotchedDisturber[i];

            gs_activefilterfreq = (int16)p_QLNInfo->gusa_fNotchedDisturber[i];
         }
      } // end for ( i = 1; i<=guc_numNotchedDisturber-1; i++)
   }
   else if( guc_numNotchedDisturber == 1)
      gs_activefilterfreq = (int16)p_QLNInfo->gusa_fNotchedDisturber[0];
   else
      gs_activefilterfreq = 0;
// ADSLRTFW-1395  PERF_DS_PLUS_ANNEXB_FIXED_RFI_DISTURBER (End)
#else          // Annex A

// ADSLRTFW-1382 PERF_DS_ALL_ANNEXA_FIXED_RFI_DISTURBER_ALLmodes (Start)
//ADSLRTFW-1383 PERF_DS_BIS_ANNEXA_FIXED_RFI_DISTURBER_DualNotchFilter (Start)
   if ( guc_numNotchedDisturber > 1)
   {
      int16 s_MaxPower1=-2000, s_MaxPower2 = 0, s_maxindex=-1, index1 = 0, index2 = 0;

      for ( i = 0; i<guc_numNotchedDisturber; i++)
      {
         s_ActiveRfiPWR = p_QLNInfo->gsa_pNotchedDisturber[i];


         if (s_ActiveRfiPWR > s_MaxPower1)
         {
            s_MaxPower2 = s_MaxPower1;
            index2  = s_maxindex;

            s_MaxPower1 = s_ActiveRfiPWR;
            index1 = i;
         }
         else if (s_ActiveRfiPWR > s_MaxPower2)
         {
            s_MaxPower2 = s_ActiveRfiPWR;
            index2  = i;
         }

      } // end for ( i = 1; i<=guc_numNotchedDisturber-1; i++)

      gs_activefilterfreq  = (int16)p_QLNInfo->gusa_fNotchedDisturber[index1];
      gs_active_Power = s_MaxPower1;
      gs_activefilterfreq2  = (int16)p_QLNInfo->gusa_fNotchedDisturber[index2];

   }
   else if( guc_numNotchedDisturber == 1)
    {
      gs_activefilterfreq = (int16)p_QLNInfo->gusa_fNotchedDisturber[0];
      gs_active_Power = p_QLNInfo->gsa_pNotchedDisturber[0];
    }
   else
      gs_activefilterfreq = 0;
#endif  //#ifdef ISDN
//ADSLRTFW-1383 PERF_DS_BIS_ANNEXA_FIXED_RFI_DISTURBER_DualNotchFilter (Start)
// ADSLRTFW-1382 PERF_DS_ALL_ANNEXA_FIXED_RFI_DISTURBER_ALLmodes (End)

   //PALAK_DBG_FTRFI
   if( gs_FORCEactivefilterfreq != 0)
   {
      gs_activefilterfreq = gs_FORCEactivefilterfreq;
   }

//#ifndef ISDN  // For Annex A
   if( gs_FORCEactivefilterfreq2 != 0)
   {
      gs_activefilterfreq2 = gs_FORCEactivefilterfreq2;
   }
//#endif
 }



/*^^^
*------------------------------------------------------------------------
*
*  Name : getWidening
*
*   Prototype:
*       C_SCOPE int16 getWidening(uint16 i_low, uint16 i_high, int16 *lr)
*
*   Abstract:
*      Check if the found RFI disturber has an influence on the surrounding tones,
*     i.e. if it shows a widening effect:
*
*
*   Input Parameters:
*     i_low    lowest tone index of the RFI disturber (tone spacing = 8625kHz)
*     i_high   highest tone index of the RFI disturber (tone spacing = 8625kHz)
*
*   Returns:
*        *lr : if <0, disturber should be located at the left, if >0 it should be located on the right
*        w :
*   Global Variables:
*
*
*   Constants
*
*
*-----------------------------------------------------------------------------
^^^*/



C_SCOPE int16 getWidening(uint16 i_low, uint16 i_high, int16 *lr)
{
   uint16 w = 1;
   /* check left side */
   *lr = 16*guca_QLN[i_low];
   if(i_low>1) {
      if((guca_QLN[i_low-1]-6)<guca_QLN[i_low])
         w=0;
      else
         *lr += 2*guca_QLN[i_low-1];
   }
   if(i_low>2) {
      if((guca_QLN[i_low-2]-4)<guca_QLN[i_low-1])
         w=0;
      else
         *lr += guca_QLN[i_low-2];
   }
   if(i_low>3) {
      if((guca_QLN[i_low-3]-2)<guca_QLN[i_low-2])
         w=0;
      else
         *lr += guca_QLN[i_low-2];
   }

   /* check right side */
   *lr -=16*guca_QLN[i_high];
   //ADSLRTFW-1382 PERF_DS_ALL_ANNEXA_FIXED_RFI_DISTURBER_ALLmodes (Start_End)
   if(i_high<(p_QLNInfo->gs_len_qln-2)) {
      if((guca_QLN[i_high+1]-6)<guca_QLN[i_high])
         w=0;
      else
         *lr -=2*guca_QLN[i_high+1];
   }
   //ADSLRTFW-1382 PERF_DS_ALL_ANNEXA_FIXED_RFI_DISTURBER_ALLmodes (Start_End)
   if(i_high<(p_QLNInfo->gs_len_qln-3)) {
      if((guca_QLN[i_high+2]-4)<guca_QLN[i_high+1])
         w=0;
      else
         *lr -=guca_QLN[i_high+2];
   }
   //ADSLRTFW-1382 PERF_DS_ALL_ANNEXA_FIXED_RFI_DISTURBER_ALLmodes (Start_End)
   if(i_high<(p_QLNInfo->gs_len_qln-4)) {
      if((guca_QLN[i_high+3]-2)<guca_QLN[i_high+2])
         w=0;
      else
         *lr -=guca_QLN[i_high+3];
   }
   return w;
}


/*^^^
*------------------------------------------------------------------------
*
*  Name : getRfiDetection
*
*   Prototype:
*       C_SCOPE void getRfiDetection(void)
*
*   Abstract:
*        This function identifies the affected RFI frequencies and power which might affect the
*     DS performence form the measured QLN.
*
*     This funcion designed only for ADSL2p mode. In this mode the resulation of QLN is 8.625 KHz.
*     To determine the RFI affected frequency, it assumes that the RFI Disturbers come form European
*     Radio channel ( i.e 9 kHz spacing)
*
*
*   Input Parameters:
*
*   Returns:
*
*   Global Variables:
*
*     guca_QLN[] : input: QLN
*     p_QLNInfo->gusa_fDisturber[] : output:  power level in dBm/Hz
*     p_QLNInfo->gsa_pDisturber[] : output: center frequency in kHz - Assumption: f is a multiple of 9 kHz
*
*
*   Funcion used:
*     getWidening
*     GetFreqForRxFilter : final decision for single notch filter frequency
*
*
*-----------------------------------------------------------------------------
^^^*/


C_SCOPE void getRfiDetection(void)
{
   uint16 identified_rfi_tones[MAX_LENGTH_QLN],i, j, k, i_low, i_high, tones, pmax, markBand, idx;
   uint16 p_inside, p_mean;
   int16      lr;    /* defines if the RFI disturber is located more on the left or right */

//ADSLRTFW-1407 PERF_DS_BisPLUS_ANNEXB_512ToneQln_DualNotch(start_end)
#if 1//ndef ISDN PERF_DS_PLUS_ANNEXB_512Tone (Start_End)
   for(i=0;i<MAX_LENGTH_QLN;i++)
#else
   for(i=0;i<(MAX_LENGTH_QLN >> 1);i++) // ADSLRTFW-1395  PERF_DS_PLUS_ANNEXB_FIXED_RFI_DISTURBER (Start_End)
#endif
   {
      identified_rfi_tones[i]=0;
      CLEARTONEFLAG(p_QLNInfo->guca_RFINotchInQLN,i);
   }

   guc_numDisturber = 0;

   /* Loop over all qln values -- RFI bands that are located only on the 1st / last tonepair are excluded. */
   //ADSLRTFW-1382 PERF_DS_ALL_ANNEXA_FIXED_RFI_DISTURBER_ALLmodes (Start_End)
   for (i=1;i<p_QLNInfo->gs_len_qln-2;i++)
 //for (i=1;i<gs_RxNumTones-2;i++)
   {
        /* Loop over all possible AM bands: width is either 1 or 2 tones */
      for (j=0;j<=1;j++)
      {
         /* Check if the QLN has at least a jump of minAbsPowerInc_AM */
            if ((guca_QLN[i]<(guca_QLN[i-1]-MIN_ABS_POWER_INC_AM))&& (guca_QLN[i+j]<(guca_QLN[i+j+1]-MIN_ABS_POWER_INC_AM)))
         {
            /* Case of noisy measurement: make sure that power level
               is higher than some average.
               Compare the power of the possible AM band (tones i:i+j-1)
               with the power of the surrounding tones.
               If the power of the band is greater than the power of the
               surrounding tones + some threshold then an RFI band is found.
            */

            /* p_inside = mean (QLN(i:i+j-1)); */
            if(j==0)
               p_inside = guca_QLN[i];
            else
               p_inside = (guca_QLN[i]+guca_QLN[i+1])>>1;

            if(i<SURROUNDING_TONES)
               i_low = 0;
            else
               i_low = i-SURROUNDING_TONES;

            //ADSLRTFW-1382 PERF_DS_ALL_ANNEXA_FIXED_RFI_DISTURBER_ALLmodes (Start_End)

            if((i+j)>(p_QLNInfo->gs_len_qln-SURROUNDING_TONES))
//          if((i+j)>(gs_RxNumTones-SURROUNDING_TONES))
               i_high = p_QLNInfo->gs_len_qln;
            else
               i_high = i+j+SURROUNDING_TONES;

               /* p_mean = mean([QLN(i_low:i-1);QLN(i+j:i_high)]); */
            p_mean = 0;
            tones  = 0;

            for(k=i_low; k<i; k++)
            {
               p_mean += guca_QLN[k];
               tones++;
            }

            for(k=i+j+1; k<= i_high; k++) {
               p_mean += guca_QLN[k];
               tones++;
            }

            p_mean /= tones;

            if(p_inside < (p_mean-MIN_MEAN_POWER_INC_AM))
            {

                    /* Only mark the center RFI tones (reduce_rfi_tones()) */

               if(j==0)
               {
                  tones  = 1;
                  i_low  = i;
                  i_high = i;
               }
               else
               {
                  pmax = (guca_QLN[i] < guca_QLN[i+1]) ? guca_QLN[i] : guca_QLN[i+1];
                  pmax += MIN_ABS_POWER_INC_AM;

                  if(guca_QLN[i] > pmax)
                  {
                     tones  = 1;
                     i_low  = i+1;
                     i_high = i+1;
                  }
                  else if(guca_QLN[i+1] > pmax)
                  {
                     tones  = 1;
                     i_low  = i;
                     i_high = i;
                  }
                  else
                  {
                     tones  = 2;
                     i_low  = i;
                     i_high = i+1;
                  }
               }

               /* Check if we already detected this disturber */
               if( (identified_rfi_tones[i_low] == 0) && (identified_rfi_tones[i_high] == 0))
               {
                  /* RFI has not yet been detected
                     Check if the QLN around the disturber is also affected by the tone (widening effect)
                  */
                  markBand = getWidening(i_low,i_high, &lr);
                  if(markBand == 1)
                  {
                     if(guc_numDisturber < MAX_NUM_DISTURBER)
                     {
                           identified_rfi_tones[i_low] = 1;
                           SETTONEFLAG(p_QLNInfo->guca_RFINotchInQLN,i_low);

                  //ADSLRTFW-1382 PERF_DS_ALL_ANNEXA_FIXED_RFI_DISTURBER_ALLmodes (Start)
                           if(tones==1)
                           {
                              p_QLNInfo->gsa_pDisturber[guc_numDisturber] = -((int16)guca_QLN[i_low]>>1) - 23;
                           //ADSLRTFW-1407 PERF_DS_BisPLUS_ANNEXB_512ToneQln_DualNotch (start_end)
                           #if 0 //def ISDN  // ADSLRTFW-1395  PERF_DS_PLUS_ANNEXB_FIXED_RFI_DISTURBER (Start_End)
                              /* idx is 8*toneIdx+some fraction that takes care of lr */
                                 idx = 8*i_low;
                              if(lr<-15)
                                 idx -=2;
                              if(lr>15)
                                 idx += 2;
                           #else
                              /* idx is 4*toneIdx+some fraction that takes care of lr */
                              idx = 4*i_low;
                              if(lr<-15)
                                 idx -=1;
                              if(lr>15)
                                 idx += 1;
                           #endif

                           }
                           else
                           {

                              p_QLNInfo->gsa_pDisturber[guc_numDisturber] = (guca_QLN[i_low] < guca_QLN[i_high]) ?
                                 -(int16)guca_QLN[i_low]/2-20 : -(int16)guca_QLN[i_high]/2-20;

                              identified_rfi_tones[i_high] = 1;
                              SETTONEFLAG(p_QLNInfo->guca_RFINotchInQLN,i_high);
                           //ADSLRTFW-1407 PERF_DS_BisPLUS_ANNEXB_512ToneQln_DualNotch (start_end)
                           #if 0 //def ISDN     // ADSLRTFW-1395  PERF_DS_PLUS_ANNEXB_FIXED_RFI_DISTURBER (Start_End)
                              if(lr<-15)
                                 idx = 6*i_low + 2*i_high;
                              else if(lr>15)
                                 idx = 2*i_low + 6*i_high;
                              else
                                 idx = 4*i_low + 4*i_high;
                           #else
                              if(lr<-15)
                                 idx = 3*i_low + i_high;
                              else if(lr>15)
                                 idx = i_low + 3*i_high;
                              else
                                 idx = 2*i_low + 2*i_high;
                           #endif
                           }
                        //ADSLRTFW-1407 PERF_DS_BisPLUS_ANNEXB_512ToneQln_DualNotch (start_end)
                        #if 0 //def ISDN
                           idx+=4; // ADSLRTFW-1395  PERF_DS_PLUS_ANNEXB_FIXED_RFI_DISTURBER (Start_End)
                        #else
                           idx+=2;
                        #endif
                  //ADSLRTFW-1382 PERF_DS_ALL_ANNEXA_FIXED_RFI_DISTURBER_ALLmodes (End)

                           /* round the disturber frequency
                              p_QLNInfo->gusa_fDisturber is given in kHz
                              if f<500kHz we round to k*1kHz else
                              we round to k*9kHz (valid not for US!) */
                           if(k<58)
                              p_QLNInfo->gusa_fDisturber[guc_numDisturber] = (idx * 69 + 32) / 64;
                           else
                              p_QLNInfo->gusa_fDisturber[guc_numDisturber] = 9*((idx * 23 +96) / 192);

                           guc_numDisturber++;
                     }
                  }
               }
            }      /* if(p_inside ... ) */
         }      /* if(guca_QLN[i] ...) */
      }      /* for (j...) */
   }      /* for (i...) */

   // final decision for the notch frequency
   GetFreqForRxFilter();
} // end of function

//#endif //PERF_DS_PLUS_ANNEXA_FIXED_RFI_DISTURBER_SINGLE_NOTCH SMS01364242 (End)
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (End)



/*^^^
 *------------------------------------------------------------------------
 *
 *  Prototype:    void DetectXtalk(void)
 *
 *  Description:  Detects 5T1, 24HDSL, and -140dBm/Hz white noise impairments.
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Return:
 *
 *  Global Variables Used:
 *    gft_5T1Noise (O):       Flag indicating 5T1 noise
 *    gft_useRxWin (O):       Flag used to enable hardware RX windowing
 *    gft_24HDSLNoise (O):    Flag indicating 24HDSL noise
 *    gft_M140WhiteNoise (O):    Flag indicating -140dBm/Hz white noise
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

//XDSLRTFW-682: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops (Start)
//extern int16 gs_XtalkMatch, gs_XtalkMatch2, gs_XtalkMatch_LowN, gs_XtalkMatch_VLowN, gs_XtalkMatch1;
//extern int16 gs_XtalkMatch_FB, gs_XtalkMatch_M130M140WN;
//XDSLRTFW-682: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops (End)

#ifdef ISDN
// XDSLRTFW-2510 : PCB_and_QLN_optimization_oISDN (Start)
C_SCOPE void DetectXtalk(void)
{
   int16 s_ch, s_MinNumOfTonesLowerThan_m130dBmHz,s_MinNumOfTonesLowerThan_m115dBmHz;
   int16 x_XtalkLowerThan_m115dBmHz, x_XtalkLowerThan_m125dBmHz,  x_XtalkLowerThan_m134dBmHz,  x_XtalkLowerThan_m141dBmHz, x_XtalkLowerThan_m145dBmHz;
   int16 x_XtalkHigherThan_m105dBmHz, x_XtalkHigherThan_m110dBmHz, x_XtalkHigherThan_m115dBmHz;
   int16 s_XtalkMatch_ISDN;  /* ISDN Disturber noise detector. */
   uint8 uc_temp;
   int16 s_ch_start, s_ch_end, s_ch_step;

   x_XtalkHigherThan_m105dBmHz = x_XtalkHigherThan_m110dBmHz = x_XtalkHigherThan_m115dBmHz = 0 ;
   x_XtalkLowerThan_m115dBmHz  = x_XtalkLowerThan_m125dBmHz  = x_XtalkLowerThan_m134dBmHz  = 0;
   x_XtalkLowerThan_m141dBmHz  = x_XtalkLowerThan_m145dBmHz  = 0;
   s_XtalkMatch_ISDN = 0;

   //---------------------------------------------------------------------
   // ISDN Disturber noise detector
   //       17 out of 28 tones (idx: 4-31) higher than tbd (set guc_ISDN_DISTURB_NOISE_THRESHOLD to -90dBm/Hz)
   //---------------------------------------------------------------------
   for (s_ch = 4; s_ch < 32; s_ch++)
   {
      if (guca_QLN[s_ch] < guc_ISDN_DISTURB_NOISE_THRESHOLD)         // (134) => -90dBm/Hz
      {
         s_XtalkMatch_ISDN++;
      }
   }
   if (s_XtalkMatch_ISDN > 16)
      gft_ISDN_DISTURBER_Noise = TRUE;
   //---------------------------------------------------------------------

   //---------------------------------------------------------------------
   // FB Noise on short loops (up to 1000m)
   //
   //
   //             |              Noise is higher than -105/-115dBm/Hz
   //             |
   // - 105dBm/Hz +     -------------------------+
   //             |                             |
   //             |                             |
   //             |                             |
   // - 115dBm/Hz +                             +---------------------------
   //             |
   //             |
   //             +------+------------------------+---------------------------+----
   //                 Tone 64                Tone 256                   Tone 512
   //
   //---------------------------------------------------------------------
   // Output:     set bit STAT_OISDN_FB_NOISE of cmv STATArray[STAT_Performance] (STAT 19)
   //---------------------------------------------------------------------

   if ((gl_SelectedMode & MODE_G992_5) != 0)    // ADSL2+ mode
   {
      for (s_ch = 64; s_ch < 256; s_ch=s_ch+2)
      {
         uc_temp = guca_QLN[s_ch];
         if (uc_temp <= 164)   // Count if less than -105 dBm/Hz
         {
            x_XtalkHigherThan_m105dBmHz++;
         }
      }
      for (s_ch = 256; s_ch < 464; s_ch=s_ch+2)
      {
         uc_temp = guca_QLN[s_ch];
         if (uc_temp <= 184)   // Count if less than -105 dBm/Hz
         {
            x_XtalkHigherThan_m115dBmHz++;
         }
      }
      if ((x_XtalkHigherThan_m105dBmHz > 85) && (x_XtalkHigherThan_m115dBmHz > 80))
      {
         STATArray[STAT_Performance] |= STAT_OISDN_FB_NOISE;
      }
      x_XtalkHigherThan_m105dBmHz = 0;
      x_XtalkHigherThan_m115dBmHz = 0;
   }
   //---------------------------------------------------------------------
   // -120dBm/Hz White Noise Detection
   //          ADSL2+:     181 out of 201 tones (idx: 64:2:464) must be lower than -115dBm/Hz
   //          DMT/ADSL2:  151 out of 175 tones (idx: 64:1:238) must be lower than -115dBm/Hz
   //---------------------------------------------------------------------
   // -130dBm/Hz White Noise Detection
   //          ADSL2+:     181 out of 201 tones (idx: 64:2:464) must be lower than -125dBm/Hz
   //          DMT/ADSL2:  151 out of 175 tones (idx: 64:1:238) must be lower than -125dBm/Hz
   //---------------------------------------------------------------------
   // -140dBm/Hz White Noise Detection
   //          ADSL2+:     181 out of 201 tones (idx: 64:2:464) must be lower than -135dBm/Hz
   //          DMT/ADSL2:  151 out of 175 tones (idx: 64:1:238) must be lower than -135dBm/Hz
   //---------------------------------------------------------------------
   // IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz (Start)
   //---------------------------------------------------------------------
   s_ch_start = 64; // gs_RxFirstChannel;
   if ((gl_SelectedMode & MODE_G992_5) != 0)    // ADSL2+ mode
   {
      s_ch_end   = 500; //Changed to 464->500 for Vrx518 as there are spikes in QLN (XDSLRTFW-3108)
      s_ch_step  = 2;
      s_MinNumOfTonesLowerThan_m130dBmHz = 180;
      s_MinNumOfTonesLowerThan_m115dBmHz = 190; // used for AWGN-120 detection.
   }
   else                                         // DMT / ADSL2 modes: tones 64 : 238
   {
      s_ch_end   = 238;
      s_ch_step  = 1;
      s_MinNumOfTonesLowerThan_m130dBmHz = 150;
      s_MinNumOfTonesLowerThan_m115dBmHz = 150; //Todo for ADSL2 modes
   }

   for (s_ch = s_ch_start; s_ch < s_ch_end; s_ch=s_ch+s_ch_step)
   {
      uc_temp = guca_QLN[s_ch];
      if (uc_temp >= guc_M140WHITE_NOISE_THRESHOLD)   // Count if less than -134dBm/Hz (222)
         x_XtalkLowerThan_m134dBmHz++;
      if (uc_temp >= guc_M130WHITE_NOISE_THRESHOLD)   // Count if less than -125dBm/Hz (204).  IOP_DS_ALL_VINAX_SetWhiteNoiseLevelToM130dBmHz (StartEnd)
         x_XtalkLowerThan_m125dBmHz++;
      if (uc_temp >= 184)                             // Count if less than -115dBm/Hz (184)
         x_XtalkLowerThan_m115dBmHz++;
   }
   if (x_XtalkLowerThan_m134dBmHz > s_MinNumOfTonesLowerThan_m130dBmHz)
   {
      gft_M140WhiteNoise = TRUE;             // oISDN
      /* Populate STAT CMV and the flag. */
      STATArray[STAT_Performance] |= STAT_M140WhiteNoise;
   }
   if (x_XtalkLowerThan_m125dBmHz > s_MinNumOfTonesLowerThan_m130dBmHz)
   {
      /* Populate STAT CMV and the flag. */
      gft_M130WhiteNoise = TRUE;             // oISDN
      STATArray[STAT_Performance] |= STAT_M130WhiteNoise;
   }
   if (x_XtalkLowerThan_m115dBmHz > s_MinNumOfTonesLowerThan_m115dBmHz)
   {
      STATArray[STAT_Performance] |= STAT_M120WhiteNoise;
   }
   //---------------------------------------------------------------------

   s_ch_end   = 238;
   s_ch_step  =   1;
   for (s_ch = s_ch_start; s_ch < s_ch_end; s_ch += s_ch_step)      // 64 to 238 => 175 tones
   {
      uc_temp = guca_QLN[s_ch] ;

      // HIGH noise detectors
      if (uc_temp < 165)      /* Count if higher than -105.5dBm/Hz. (224)*/
         x_XtalkHigherThan_m105dBmHz++;
      if (uc_temp < 175)      /* Count how many tones with QLN[i] indicates noise level stronger than -110dBm/Hz. */
         x_XtalkHigherThan_m110dBmHz++;

      // LOW noise detectors
      if (uc_temp > 236)      /* Count if less/equal than -141dBm/Hz. */
         x_XtalkLowerThan_m141dBmHz++;
      if (uc_temp > 244  )    /* Count if less than -145dBm/Hz. */
         x_XtalkLowerThan_m145dBmHz++;
   }

   //---------------------------------------------------------------------
   // Low Noise / Very low Noise Detection (use detection only if -140dBm/Hz WN)
   //          Low Noise:       41 out of 175 tones (idx: 64-238) must be lower than -141dBm/Hz
   //          Very Low Noise:  41 out of 175 tones (idx: 64-238) must be lower than -145dBm/Hz
   //---------------------------------------------------------------------
   if (STATArray[STAT_Performance] & STAT_M140WhiteNoise)      // 155 out of 175 tones
   {
      if (x_XtalkLowerThan_m145dBmHz>40)                    // 41 out of 175 tones < -145dBm/Hz
         STATArray[STAT_Performance] |= STAT_VLowNoise;
      else if (x_XtalkLowerThan_m141dBmHz>40)               // 41 out of 175 tones < -145dBm/Hz
         STATArray[STAT_Performance] |= STAT_LowNoise;
   }


   //---------------------------------------------------------------------
   // Strong Noise Detectors:
   //          gft_StrongNoisePresent:                101 out of 175 tones (idx: 64-238) higher than -110dBm/Hz
   //          gft_StrongNoiseForDsPcb:               101 out of 175 tones (idx: 64-238) higher than -110dBm/Hz OR
   //                                                  51 out of 175 tones (idx: 64-238) higher than -105dBm/Hz
   //          gft_FBnoise / STAT_FBNoiseLowThreshold: 31 out of 175 tones (idx: 64-238) higher than -105dBm/Hz
   //          gft_FBnoise / STAT_FBNoise:             76 out of 175 tones (idx: 64-238) higher than -105dBm/Hz
   //---------------------------------------------------------------------
   // logic used to detect any type strong noise. If detected, extra DS PCB is not applied for short loops.
   if (x_XtalkHigherThan_m110dBmHz > 100)
   {
      gft_StrongNoisePresent  = TRUE;
      gft_StrongNoiseForDsPcb = TRUE;           // oISDN: 100/175 > -110dBm/Hz
   }

   if (x_XtalkHigherThan_m105dBmHz > 30)
   {
      gft_FBnoise = TRUE;
      STATArray[STAT_Performance] |= STAT_FBNoiseLowThreshold;
   }

   if (x_XtalkHigherThan_m105dBmHz > 75)
   {
      gft_FBnoise = TRUE;
      STATArray[STAT_Performance] |= (STAT_FBNoise | STAT_FBNoiseLowThreshold);
      gft_StrongNoiseForDsPcb = TRUE;           // oISDN:  75/175 > -105dBm/Hz
   }
   else if (x_XtalkHigherThan_m105dBmHz > 50)
   {
      gft_FBnoise = TRUE;
      STATArray[STAT_Performance] |= STAT_FBNoiseLowThreshold;
      gft_StrongNoiseForDsPcb = TRUE;           // oISDN:  50/175 > -105dBm/Hz
   }

   //---------------------------------------------------------------------
   // Reduce margin by 1.5dB - 2.25dB for "no noise" loops (internal noise only)
   //---------------------------------------------------------------------
   if (OPTNArray[OPTN_AlgControl2]&OPTN_Detect_LowNoise)
   {
      if (STATArray[STAT_Performance] & STAT_VLowNoise)
         OPTNArray[OPTN_MarginDelta] -= 0x240 ;
      else if (STATArray[STAT_Performance] & STAT_LowNoise)
         OPTNArray[OPTN_MarginDelta] -= 0x180 ;
   }
}
// XDSLRTFW-2510 : PCB_and_QLN_optimization_oISDN (End)

#else // end of #ifdef ISDN -> oPOTS starts here

// XDSLRTFW-4206  CTL, ADSL2p: Downstream low perf on 5-7kft Xtalk loop - NMS algo disabled
//                NMS gain is now turned on by default for all loops / noises (gft_AddNMS is always "TRUE" in Medley and Showtime)
//                correct Noise detection (false detection of line-noise was diabling NMS on multiple loops)
// XDSLRTFW-4203  CTL, ADSL2p: DetectXtalk calculation does not work
//                cleanup
//                correct White-noise counters (they are called twice)

C_SCOPE void DetectXtalk(void)
{
   int16 s_ch;
   uint8 uc_temp ;
   int16 s_ch_start, s_ch_end, s_ch_step;
   //int16 s_firstcomp_channel;
   //int16 s_first_channel;
   int16 s_DiffAcc,s_DiffAcc_BT;
   // Counters: Number of tones lower/higher than x dBm/Hz
   int16 s_XtalkMatch                                 = 0;
   int16 s_XtalkMatch1                                = 0;
   int16 s_XtalkMatch_5T1_2                           = 0;

   int16 s_ADSL2_XtalkHigherThan_m105dBmHz            = 0;
   int16 s_XtalkHigherThan_m129dBmHz                  = 0;
   int16 s_XtalkHigherThan_m115dBmHz_Tones_150_to_181 = 0;
   int16 s_XtalkHigherThan_m115dBmHz_Tones_215_to_246 = 0;
   int16 s_XtalkHigherThan_m110dBmHz                  = 0;
   int16 s_XtalkHigherThan_m098dBmHz                  = 0;  // XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(Start_End)

   int16 s_XtalkLowerThan_m145dBmHz                   = 0;  //Enhc_DS_ALL_ALL_ByPassPLLBWIncrease (Start_End)
   int16 s_XtalkLowerThan_m141dBmHz                   = 0;
   int16 s_XtalkLowerThan_m134dBmHz                   = 0;
   int16 s_XtalkLowerThan_m130dBmHz                   = 0;
   int16 s_XtalkLowerThan_m125dBmHz                   = 0;  //ADSLRTFW-1549 IOP_US_ADSL1_ADI_IncreaseTxMedleyNoise(Start_End)
   int16 s_XtalkLowerThan_m115dBmHz                   = 0;
   int16 s_MinNumOfTonesLowerThan_m130dBmHz           = 0;
   int16 s_MinNumOfTonesLowerThan_m115dBmHz           = 0;
   int16 s_XtalkBetween_m90dBmHz_and_m100dBmHz        = 0;



   //XDSLRTFW-1250(START_END)
   // s_IndexShift = 0;//Since 2+ has 512 QLN no need of s_IndexShift=1 for guca_QLN in 2+

   //XDSLRTFW-760 BugFix_DS_ALL_ALL_NoiseFlags (START)

   //------------------------------------------------------------------------------------
   //                            5T1 noise detector.
   //------------------------------------------------------------------------------------
   /* We wish to detect quiet line noise profiles that, like 5T1, */
   /* have relatively high power (-115dBm/Hz) at higher inband frequencies, and have */
   /* less power at lower frequencies. */
   s_DiffAcc = 0;
   s_DiffAcc_BT = 0;
   for (s_ch = 0; s_ch < 32; s_ch++)
   {
      s_DiffAcc += (int16)guca_QLN[(gs_RxFirstChannel + s_ch)]
                 - (int16)guca_QLN[(150 + s_ch)]
                 - (int16)guc_5T1_NOISE_THRESHOLD1;         // 7dB
      /* Count if greater than (-23 - guc_5T1_NOISE_THRESHOLD2/2) = -115dBm/Hz. */
      if (guca_QLN[(150 + s_ch)] < guc_5T1_NOISE_THRESHOLD2)
      {
         s_XtalkHigherThan_m115dBmHz_Tones_150_to_181++;
      }
      //for BT 5000 +200 5T1 cases.
      s_DiffAcc_BT += (int16)guca_QLN[(gs_RxFirstChannel + s_ch)]
                    - (int16)guca_QLN[(215 + s_ch)]
                    - (int16)guc_5T1_NOISE_THRESHOLD1;         // 7dB
      if (guca_QLN[(215 + s_ch)] < guc_5T1_NOISE_THRESHOLD2)
      {
         s_XtalkHigherThan_m115dBmHz_Tones_215_to_246++;
      }
   }
   /* Second condition below is equivalent to checking that mean noise power over */
   /* lower freq tones [gs_RxFirstChannel, gs_RxFirstChannel+32) is more than */
   /* guc_5T1_NOISE_THRESHOLD1/2 = 5dB (currently 14->7dB)lower than mean noise power over higher */
   /* freq tones [150, 182). */
   /* considering "s_DiffAcc_BT" as 10 dB higher (s_DiffAcc ~7dB) =>   192(~190) =>3*2*32
     */
   if (   ((s_XtalkHigherThan_m115dBmHz_Tones_150_to_181 > 30) && (s_DiffAcc    > 0))        // 30 out of 32 tones, RxNoise of tons 150-182 is  7dB higher than noise on tones 33-64
        ||((s_XtalkHigherThan_m115dBmHz_Tones_215_to_246 > 30) && (s_DiffAcc_BT > 190))      // 30 out of 32 tones, RxNoise of tons 215-246 is 10dB higher than noise on tones 33-64
       )
   {
      /* Populate STAT CMV and the flag. */
      STATArray[STAT_Performance] |= STAT_5T1Noise;
      gft_5T1Noise = TRUE;
      /* In the case of T1-like noise use RX windowing. */
      gft_useRxWin = TRUE;
   }

   //------------------------------------------------------------------------------------
   //                            24HDSL noise detector.
   //------------------------------------------------------------------------------------
   // Algorithm:
   //    1. >10 out of 14 tones between ToneIdx 33 and 46 show more than -103.0 dBm/Hz noise
   //------------------------------------------------------------------------------------
   s_XtalkMatch = 0;
   for (s_ch = 33; s_ch < 47; s_ch++)
   {
      // guc_24HDSL_NOISE_THRESHOLD                = 160; //   -103.0 dBm/Hz
      if (guca_QLN[s_ch] < guc_24HDSL_NOISE_THRESHOLD)
         s_XtalkMatch++;
   }
   if ((s_XtalkMatch > 10))
   {
      /* Populate STAT CMV and the flag. */
      STATArray[STAT_Performance] |= STAT_24HDSLNoise;
      gft_24HDSLNoise = TRUE;
   }

   //------------------------------------------------------------------------------------
   //                            24DSL noise detector.
   //------------------------------------------------------------------------------------
   // Algorithm:
   //    1.     >2 out of  8 tones in US(!)-band between ToneIdx 25 and 32 show more than -113.0 dBm/Hz noise
   //        or >2 out of  6 tones in US(!)-band between ToneIdx 10 and 15 show more than -108.0 dBm/Hz noise
   //    2.     >4 out of 15 tones between ToneIdx 33 and 46 show LESS than -103.0 dBm/Hz noise (gft_24HDSLNoise!=TRUE)
   //------------------------------------------------------------------------------------
   // Enhc_DS_ALL_ALL_ByPassPLLBWIncrease(Start)
   // Detect hump1
   s_XtalkMatch = 0;
   for (s_ch = 25; s_ch < 33; s_ch++)
   {
      // guc_24DSL_NOISE_THRESHOLD                 = 180; //   -113.0 dBm/Hz
      if ((guca_QLN[s_ch] < guc_24DSL_NOISE_THRESHOLD))
         s_XtalkMatch++;
   }
   // Detect hump2
   s_XtalkMatch1 = 0;
   for (s_ch = 10; s_ch < 16; s_ch++)
   {
      // guc_24DSL_NOISE_THRESHOLD1                = 170; //   -108.0 dBm/Hz
      if ((guca_QLN[s_ch] < guc_24DSL_NOISE_THRESHOLD1))
         s_XtalkMatch1++;
   }
   //Noise level of 24HDSL is quite higher than 24DSL
   if (((s_XtalkMatch > 2) || (s_XtalkMatch1 > 2)) && (gft_24HDSLNoise!=TRUE))
   {
      STATArray[STAT_Performance] |= STAT_24DSLNoise;
   }
//XDSLRTFW-760 BugFix_DS_ALL_ALL_NoiseFlags (END)

   // Enhc_DS_ALL_ALL_ByPassPLLBWIncrease(End)
   /* -140dBm/Hz white noise and 'LowNoise/VeryLowNoise' detector. */

   // --------------------------------------------------------------------
   //                      Used Noise Thresholds
   // --------------------------------------------------------------------
   // Noise Thresholds: e.g. -23-(212)/2 = -129 dBm/Hz
   // --------------------------------------------------------------------
   //                                             134; //    -90.0 dBm/Hz
   // guc_FSNB_NOISE_THRESHOLDS_shortLoop       = 150; //    -98.0 dBm/Hz
   //                                             154; //   -100.0 dBm/Hz
   // guc_24HDSL_NOISE_THRESHOLD                = 160; //   -103.0 dBm/Hz
   //                                             165; //   -105.5 dBm/Hz
   // guc_24DSL_NOISE_THRESHOLD1                = 170; //   -108.0 dBm/Hz
   //                                             175; //   -110.0 dBm/Hz
   // guc_24DSL_NOISE_THRESHOLD                 = 180; //   -113.0 dBm/Hz
   //                                             184; //   -115.0 dBm/Hz
   // guc_5T1_NOISE_THRESHOLD2                    184; //   -115.0 dBm/Hz
   // guc_M130WHITE_NOISE_THRESHOLD             = 204; //   -125.0 dBm/Hz
   // M125WHITE_NOISE_THRESHOLD                 = 204; //   -125.0 dBm/Hz
   // guc_M140WHITE_NOISE_THRESHOLDS_shortLoop  = 212; //   -129.5 dBm/Hz
   // M130WHITE_NOISE_THRESHOLD                 = 214; //   -130.0 dBm/Hz
   // guc_M140WHITE_NOISE_THRESHOLD             = 222; //   -134.0 dBm/Hz
   // guc_NOISE_THRESHOLD_138                   = 230; //   -138.0 dBm/Hz
   //                                             236; //   -141.0 dBm/Hz
   //                                             244; //   -145.0 dBm/Hz

   if ((gl_SelectedMode & MODE_G992_5) != 0)    // ADSL2+ mode
   {
//      // NOT USED - START
//      s_firstcomp_channel = (int16) RX_FILTERCOMP_FIRST_CHAN_PLUS;
//      if (s_first_channel < s_firstcomp_channel)
//         s_first_channel = s_firstcomp_channel;
//      // NOT USED - END

      s_ch_start = gs_RxFirstChannel;
      s_ch_end   = 464;  //Changed to 464->500 for Vrx518 as there are spikes in QLN (XDSLRTFW-3108)
      s_ch_step  = 2;

      //                                      | ADSL2+    |
      //                                      |   A |   M |
      // -------------------------------------+-----+-----+
      // Total Number of investigated Tones   | 216 | 200 |
      // -------------------------------------+-----+-----+
      // First tone index                     |  33 |  65 |
      // Last  tone index                     | 464 | 464 |
      for (s_ch = s_ch_start; s_ch < s_ch_end; s_ch=s_ch+s_ch_step)
      {
         uc_temp = guca_QLN[s_ch];

         // HIGH noise detectors             (number of tones with tone power higher than ...)
         if (uc_temp < guc_M140WHITE_NOISE_THRESHOLDS_shortLoop)  // Count if more than -129.5 dBm/Hz (212)
            s_XtalkHigherThan_m129dBmHz++;

         if (uc_temp < guc_FSNB_NOISE_THRESHOLDS_shortLoop)       // Count if more than  -98.0 dBm/Hz (150)
            s_XtalkHigherThan_m098dBmHz++;

         // BUG - START - called 2x
         //         // LOW  noise detectors             (number of tones with tone power lower  than ...)
         //         if (uc_temp >= guc_M130WHITE_NOISE_THRESHOLD)            // Count if less than -125.0 dBm/Hz (204)
         //            s_XtalkLowerThan_m125dBmHz++;
         //
         //         if (uc_temp >= 184)                                      // Count if less than -115.0 dBm/Hz (184)
         //            s_XtalkLowerThan_m115dBmHz++;
         // BUG - END
      }

      s_ch_start = gs_RxFirstChannel;
      s_ch_end   = 100;
      s_ch_step  = 2;
      //                                      | ADSL2+    |
      //                                      |   A |   M |
      // -------------------------------------+-----+-----+
      // Total Number of investigated Tones   |  34 |  18 |
      // -------------------------------------+-----+-----+
      // First tone index                     |  33 |  65 |
      // Last  tone index                     | 100 | 100 |
      for (s_ch = s_ch_start; s_ch <= s_ch_end; s_ch=s_ch+s_ch_step)
      {
         uc_temp = guca_QLN[s_ch];
         if ((uc_temp <= 154) && (uc_temp >= 134)) // Count tones between -90 and -100 dBm/Hz
            s_XtalkBetween_m90dBmHz_and_m100dBmHz++;
      }
   }
   else                                         // DMT / ADSL2 modes: tones 64 : 238
   {
//      // NOT USED - START
//      s_ch_end   = 238;
//      s_ch_step  = 1;
//      s_firstcomp_channel = (int16) RX_FILTERCOMP_FIRST_CHAN_BIS;
//      if (s_first_channel < s_firstcomp_channel)
//         s_first_channel = s_firstcomp_channel;
//      // NOT USED - END
   }

   s_ch_start = gs_RxFirstChannel;
   s_ch_end   = 238;
   s_ch_step  = 1;
   //                                      | ADSL2     | ADSL2+    |
   //                                      | A/L |   M |   A |   M |
   // -------------------------------------+-----+-----+-----+-----+
   // Total Number of investigated Tones   | 205 | 173 | 205 | 173 |
   // -------------------------------------+-----+-----+-----+-----+
   // First tone index                     |  33 |  65 |  33 |  65 |
   // Last  tone index                     | 238 | 238 | 238 | 238 |
   for (s_ch = s_ch_start; s_ch < s_ch_end; s_ch=s_ch+s_ch_step)
   {
      uc_temp = guca_QLN[s_ch];
      if (uc_temp < 165)                              // Count if more than -105.5 dBm/Hz (165)
         s_ADSL2_XtalkHigherThan_m105dBmHz++;
   }


   //                                      | ADSL2     | ADSL2+    |
   //                                      | A/L |   M |   A |   M |
   // -------------------------------------+-----+-----+-----+-----+
   // Total Number of investigated Tones   | 205 | 173 | 234 | 218 |
   // -------------------------------------+-----+-----+-----+-----+
   // First tone index                     |  33 |  65 |  33 |  65 |
   // Last  tone index                     | 238 | 238 | 500 | 500 |
   if ((gl_SelectedMode & MODE_G992_5) != 0)    // ADSL2+ mode
   {
      s_ch_start = gs_RxFirstChannel;
      s_ch_end   = 500; //Changed to 464->500 for Vrx518 as there are spikes in QLN (XDSLRTFW-3108)
      s_ch_step  = 2;
   }
   else                                         // DMT / ADSL2 modes: tones 64 : 238
   {
      s_ch_start = gs_RxFirstChannel;
      s_ch_end   = 238;
      s_ch_step  = 1;
   }

   gus_XtalkLowerThan_m138dBmHz = 0; //XDSLRTFW-3603 (start_end)
   for (s_ch = s_ch_start; s_ch < s_ch_end; s_ch += s_ch_step)
   {
      uc_temp = guca_QLN[s_ch] ;

      // HIGH noise detectors             (number of tones with tone power higher than ...)
      if (uc_temp > guc_M140WHITE_NOISE_THRESHOLD)    // Count if less than -134.0 dBm/Hz (222)
         s_XtalkLowerThan_m134dBmHz++;

      if (uc_temp > M130WHITE_NOISE_THRESHOLD)        // Count if less than -130.0 dBm/Hz (214)
         s_XtalkLowerThan_m130dBmHz++;

      if (uc_temp >= 236)                             // Count if less than -141.0 dBm/Hz (236)
         s_XtalkLowerThan_m141dBmHz++;

      if (uc_temp >  244)                             // Count if less than -145.0 dBm/Hz (244)
         s_XtalkLowerThan_m145dBmHz++;

      if (uc_temp < 175)                              // Count if more than -110.0 dBm/Hz (175)
         s_XtalkHigherThan_m110dBmHz++;

      if (uc_temp >= guc_M130WHITE_NOISE_THRESHOLD)   // Count if less than -125.0 dBm/Hz (204).
         s_XtalkLowerThan_m125dBmHz++;                // ADSLRTFW-1549 IOP_US_ADSL1_ADI_IncreaseTxMedleyNoise

      if (uc_temp >= 184)                             // Count if less than -115.0 dBm/Hz (184)
         s_XtalkLowerThan_m115dBmHz++;

      if (uc_temp > guc_NOISE_THRESHOLD_138)          // Count if less than -138.0 dBm/Hz (230)
         gus_XtalkLowerThan_m138dBmHz++;              //XDSLRTFW-3603
   }
   //XDSLRTFW-1214 IOP_DS_Plus_IKNS_ST_Stable (end)
   if (guc_NoTones_Qln_Force)
      guc_NoTones_Qln = guc_NoTones_Qln_Force;
   //XDSLRTFW-3602  (start)
#if 0 //gft_M140WhiteNoise getting set for all 24HDSL/24DSL also, not able to use "gft_M140WhiteNoise" effectively
   int32 l_fe_VendorID_Check;
   //XDSLRTFW-682: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops (Start)
   // Extract the provider  code (Vendor ID, 4 octets), Workaround for TI  AC7/CNXT vendor ID
   l_fe_VendorID_Check = (guca_fe_G9941_VendorID[2] << 24) | (guca_fe_G9941_VendorID[3] << 16) |
                         (guca_fe_G9941_VendorID[4] << 8) | (guca_fe_G9941_VendorID[5]);

   /* White noise flag not getting SET in BT loops. Reduce White noise
      detection threshold from 160 to 135. This helps to improve DS data rates*/
   if ((gs_fe_T1413_VendorID == T1413_GSI_ID)  ||
       ((gl_SelectedMode & MODE_ADSL1) && (l_fe_VendorID_Check  == GHS_GSI_ID)) ||
       //XDSLRTFW-681: BugFix_DS_DMT_CNXT_No_Connect_in_19Kft_and_above_AnxL_Loops (Start_End)
       //Extending the scheme to ADSL2/ADSL2+ to improve DS data rates in BT loops
       ((gl_SelectedMode & MODE_ADSL2) && (l_fe_VendorID_Check  == GHS_GSI_ID))) {
      guc_NoTones_Qln = 135;
   }
#endif
   //XDSLRTFW-3602  (end)
   //gs_XtalkMatch=            s_XtalkLowerThan_m134dBmHz;
   //gs_XtalkMatch2=           s_XtalkHigherThan_m110dBmHz;
   //gs_XtalkMatch_LowN=       s_XtalkLowerThan_m141dBmHz;
   //gs_XtalkMatch_VLowN=      s_XtalkLowerThan_m145dBmHz;
   //gs_XtalkMatch1=           s_XtalkMatch1;
   //gs_XtalkMatch_FB=         s_ADSL2_XtalkHigherThan_m105dBmHz;
   //gs_XtalkMatch_M130M140WN= s_XtalkLowerThan_m130dBmHz;
   //XDSLRTFW-682: BugFix_DS_DMT_CNXT_Improve_DS_Performance_In_BTLoops (End)

   //XDSLRTFW_3663_TR100A_MV_12ADSL2Plus_AddMargin / PERF_DS_BisPlus_CNXT_LimitDSPCB / PERF_DS_BisPlus_CNXT_LimitDSPCB (Start)
   //XDSLRTFW-1464 : Perf_US_Plus_AnxA_BRCM_USPerf24HDSLNoise / PERF_DS_ALL_ALL_M130M140WN_TO_ENABLE_NMS (Start)
   //ADSLRTFW-1549 IOP_US_ADSL1_ADI_IncreaseTxMedleyNoise / XDSLRTFW-3602 (Start)

   //---------------------------------------------------------------------
   // Low Noise / Very low Noise Detection (use detection only if -140dBm/Hz WN)
   //          Low Noise:       41 out of (205/173/234/218) tones must be lower than -141dBm/Hz
   //          Very Low Noise:  41 out of (205/173/234/218) tones must be lower than -145dBm/Hz
   //---------------------------------------------------------------------
   if      (s_XtalkLowerThan_m145dBmHz > 40)
   {
      STATArray[STAT_Performance] |= STAT_VLowNoise;
   }
   else if (s_XtalkLowerThan_m141dBmHz > 40)
   {
         STATArray[STAT_Performance] |= STAT_LowNoise;
   }
   if (OPTNArray[OPTN_AlgControl2] & OPTN_Detect_LowNoise)       // OFF by default
   {
      if (STATArray[STAT_Performance] & STAT_VLowNoise)
         OPTNArray[OPTN_MarginDelta] -= 0x240 ;
      else if (STATArray[STAT_Performance] & STAT_LowNoise)
         OPTNArray[OPTN_MarginDelta] -= 0x180 ;
   }

   //------------------------------------------------------------------------------------
   //                            WHITE noise detector.
   //------------------------------------------------------------------------------------
   // Algorithm:           set only one noise WN flat (the lowest possible one)
   //---------------------------------------------------------------------
   // -140dBm/Hz White Noise Detection
   //          ADSL2+:     Annex-A:    181 out of 234 tones (idx: 33:2:500) must be lower than -135dBm/Hz
   //                           OR:     41 out of 234 tones (idx: 33:2:500) must be lower than -135dBm/Hz
   //                              and 181 out of 234 tones (idx: 33:2:500) must be lower than -130dBm/Hz
   //          ADSL2+:     Annex-M:    181 out of 218 tones (idx: 65:2:500) must be lower than -135dBm/Hz
   //          DMT/ADSL2:  Annex-A/L:  181 out of 205 tones (idx: 33:1:238) must be lower than -135dBm/Hz
   //          ADSL2:      Annex-M:    does not work
   //---------------------------------------------------------------------
   // -130dBm/Hz White Noise Detection
   //          ADSL2+:     Annex-A:    181 out of 234 tones (idx: 33:2:500) must be lower than -125dBm/Hz
   //          ADSL2+:     Annex-M:    181 out of 218 tones (idx: 65:2:500) must be lower than -125dBm/Hz
   //          DMT/ADSL2:  Annex-A/L:  181 out of 205 tones (idx: 33:1:238) must be lower than -125dBm/Hz
   //                           OR:    151 out of 205 tones (idx: 33:1:238) must be lower than -125dBm/Hz
   //                             and  (gft_24HDSLNoise == FALSE)
   //          ADSL2:      Annex-M:    151 out of 173 tones (idx: 65:1:238) must be lower than -125dBm/Hz
   //                             and  (gft_24HDSLNoise == FALSE)
   //---------------------------------------------------------------------
   // -120dBm/Hz White Noise Detection
   //          ADSL2+:     Annex-A:    191 out of 234 tones (idx: 33:2:500) must be lower than -115dBm/Hz
   //                             and  (gft_24HDSLNoise == FALSE)
   //          ADSL2+:     Annex-M:    191 out of 218 tones (idx: 65:2:500) must be lower than -115dBm/Hz
   //                             and  (gft_24HDSLNoise == FALSE)
   //          DMT/ADSL2:  Annex-A/L:  151 out of 205 tones (idx: 33:1:238) must be lower than -115dBm/Hz
   //                             and  (gft_24HDSLNoise == FALSE)
   //          ADSL2:      Annex-M:    151 out of 173 tones (idx: 65:1:238) must be lower than -115dBm/Hz
   //                             and  (gft_24HDSLNoise == FALSE)
   //---------------------------------------------------------------------
   /*
   WARNING: Kindly check the Noise flag setting under different noise condition for AnxA and AnxB code
   +NoiseFloor|   AnxA    |  AnxB     |+
    ----------|-----------|-----------|
              |WN140|WN130|WN140|WN130|
    ----------|-----|-----|-----|-----|
   125dBm/Hz  |  0  |  1  |  1  | 1   |
    ----------|-----|-----|-----|-----|
   130dBm/Hz  |  1  |  0  |  1  | 0   |
     ---------|-----|-----|-----|-----|
   140dBm/Hz  |  0  |  1  |  1  |  1  |
     ---------|-----|-----|-----|-----|
   */

   // White noise detection shall be independet of "Very low noise"-detection (remove "else if")
   if    (s_XtalkLowerThan_m134dBmHz > guc_NoTones_Qln)      // Noise of 180 out of (205/173/234/218) tones is lower than -134dBm/HZ
   {
      STATArray[STAT_Performance] |= STAT_M140WhiteNoise;
      gft_M140WhiteNoise = TRUE;
    }
   else if   ((s_XtalkLowerThan_m130dBmHz > guc_NoTones_Qln)      // Noise of 180 out of (205/173/234/218) tones is lower than -130dBm/HZ
           && (s_XtalkLowerThan_m134dBmHz > 40)                   // Noise of  40 out of (205/173/234/218) tones is lower than -134dBm/HZ
   )                                                              // For stress test AWGN-130 noise we have only "s_XtalkLowerThan_m130dBmHz"
   {
      /* Populate STAT CMV and the flag. */
      STATArray[STAT_Performance] |= STAT_M140WhiteNoise;
      STATArray[STAT_Performance] |= STAT_M130M140WhiteNoise;
      gft_M140WhiteNoise = TRUE;
    }
   else if (s_XtalkLowerThan_m125dBmHz > 180)                     // Noise of 180 out of (205/173/234/218) tones is lower than -125dBm/HZ
   {
      /* Populate STAT CMV and the flag. */
      STATArray[STAT_Performance] |= STAT_M130WhiteNoise;
   }

   //------------------------------------------------------------------------------------
   //                            STRONG noise detector.
   //------------------------------------------------------------------------------------
   if ((s_XtalkHigherThan_m110dBmHz > 100) || gft_5T1Noise || gft_24HDSLNoise)
      gft_StrongNoisePresent = TRUE;

   // Avoid Setting 24HDSL Noise Settings when FB Noise is present.
   if (s_ADSL2_XtalkHigherThan_m105dBmHz > 50)
   {
      gft_FBnoise = TRUE;
      STATArray[STAT_Performance] |= STAT_FBNoiseLowThreshold;
      STATArray[STAT_Performance] &= ~(STAT_24HDSLNoise);
      gft_24HDSLNoise = FALSE;
   }

   if (s_ADSL2_XtalkHigherThan_m105dBmHz > 100)
       STATArray[STAT_Performance] |= STAT_FBNoise;

   if (s_XtalkBetween_m90dBmHz_and_m100dBmHz > 10)
      STATArray[STAT_Performance] |= STAT_M90M100Noise;


   // PERF_DS_PLUS_ALL_GeneralizedPcb (Start/End)
   // logic used to detect any type strong noise. If detected, extra DS PCB is not applied for short loops.
   if (gft_StrongNoisePresent || gft_FBnoise)
      gft_StrongNoiseForDsPcb = TRUE;

   //XDSLRTFW_3663_TR100A_MV_12ADSL2Plus_AddMargin / PERF_DS_BisPlus_CNXT_LimitDSPCB / PERF_DS_BisPlus_CNXT_LimitDSPCB (END)
   //XDSLRTFW-1464 : Perf_US_Plus_AnxA_BRCM_USPerf24HDSLNoise / PERF_DS_ALL_ALL_M130M140WN_TO_ENABLE_NMS (END)
   //ADSLRTFW-1549 IOP_US_ADSL1_ADI_IncreaseTxMedleyNoise / XDSLRTFW-3602 (END)


   // XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(Start)
   // ADSL2+ only (s_XtalkHigherThan_m098dBmHz and s_XtalkHigherThan_m129dBmHz are "0" in DMT and BIS modes)
   if (s_XtalkHigherThan_m098dBmHz > 200)
      gft_FBnoise_ShortLoop = TRUE;
   else if (s_XtalkHigherThan_m129dBmHz > 200)
      gft_M140WhiteNoise_ShortLoop = TRUE;

   // XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(End)


   //---------------------------------------------------------------------
   // -130dBm/Hz White Noise Detection (part 2)
   // -120dBm/Hz White Noise Detection
   //---------------------------------------------------------------------
   if ((gl_SelectedMode & MODE_G992_5) != 0)    // ADSL2+ mode
   {
      s_MinNumOfTonesLowerThan_m130dBmHz = 180;
      s_MinNumOfTonesLowerThan_m115dBmHz = 190; // used for AWGN-120 detection.
   }
   else                                         // DMT / ADSL2 modes: tones 64 : 238
   {
      s_MinNumOfTonesLowerThan_m130dBmHz = 150;
      s_MinNumOfTonesLowerThan_m115dBmHz = 150; //Todo for ADSL2 modes
   }

   if ((gft_M140WhiteNoise == FALSE) && (gft_24HDSLNoise == FALSE))
   {
      if (s_XtalkLowerThan_m125dBmHz > s_MinNumOfTonesLowerThan_m130dBmHz)
      {
         STATArray[STAT_Performance] |= STAT_M130WhiteNoise;
      }
      else if (s_XtalkLowerThan_m115dBmHz > s_MinNumOfTonesLowerThan_m115dBmHz)
      {
         STATArray[STAT_Performance] |= STAT_M120WhiteNoise;
      }
   }
}
#endif

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : QuietLineNoisePSD()
 *
 *  Description:  Computes the Quiet Line Noise PSD for C-MSG4-LD
 *
 *  Prototype:
 *    void QuietLineNoisePSD(int32 *pla_inbuf, uint8 *puca_msg_ld, int16 s_first_channel,
 *                   int16 s_last_channel)
 *
 *  Input Arguments:
 *      int32  *pla_inbuf - pointer to power in frequency
 *    int16  s_first_channel  - first channel in the Hlog(f) calculation
 *    int16  s_last_channel   - last channel in the Hlog(f) calculation
 *
 *  Output Arguments:
 *      uint8 *puca_msg_ld - pointer to array to store QLN(f) in Bis output format byte array
 *                   (except sequence number and reserved bits).
 *
 *  Return:
 *    int16 psa_out[] --Quiet Line Noise PSD represented in final BIS format
 *                   n(f)=2*(QLN(f)-23)
 *
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE void QuietLineNoisePSD()
{

    int i, s_first_channel, s_last_channel, s_pwr_db;
   int16 s_firstcomp_channel, s_lastcomp_channel;
   int16 s_pow_dbmperHz, s_pga, s_RightShift, s_icn_scale_avg_dB;
    int32 l_ipower, *pla_inbuf, *pla_NoisePower, l_tempL, l_tempH;
   uint8 *puca_msg_ld;
   int16    s_first_index, s_last_index, s_ToneStepSize, s_channel;
   int16 s_OutofRangeValue;

//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start)
  // #ifndef ISDN //PERF_DS_PLUS_ANNEXA_FIXED_RFI_DISTURBER_SINGLE_NOTCH SMS01364242 (Start)
   int16 alpha, beta;
   //ADSLRTFW-1407 PERF_DS_BisPLUS_ANNEXB_512ToneQln_DualNotch(start_end)
   // ADSLRTFW-1408 Enhance_DS_Bis_ANNEXAL_512Tone_QLN (start_end)
   //Enhance_DS_ADSL1_ANNEXAB_512Tone_QLN (Start_End)
   int16 s_LOG2_R_C_QUIET1_QLN_LEN;
 //  #endif //PERF_DS_PLUS_ANNEXA_FIXED_RFI_DISTURBER_SINGLE_NOTCH SMS01364242 (End)

#ifndef ISDN
   uint32 *pula_DecimCoefsSrc, *pula_DecimCoefsDst;
#endif

//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End): Initializing the p_QLN. Have to find a better way to initialize
 p_QLNInfo = (QLNInfo_t *)(void *)(guca_RxBat) ;

#ifdef DEBUG_TESTPARM
   FILE *fp;
   fp=fopen("testquiet_debug.txt","w");
   fprintf(fp, "\npla_inbuf:\n");
   for(i=0; i<2*gs_RxNumTones; i++) //48 bits
      fprintf(fp, "%d\n", gla_RxAccumBuf[i]);
#endif

   // setup   input
   pla_inbuf = gla_RxAccumBuf;
   pla_NoisePower = gla_RxAccumBuf;  // Overwrite input buffer with 32-bit output.
   puca_msg_ld = (uint8 *)gpuca_RMSG8_LD;

    if(gft_NMSTxSilence == TRUE)
    {
       puca_msg_ld = (uint8 *)(void *)gpsa_Medley_Vector;
    }
   // s_first_channel = gs_RxFirstChannel;
   // Sriram : Changed the first channel to 1, since energy is available from Tone 1 onwards.
   // XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration (Start_End)
   s_first_channel = 1;

//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start): Commented out old code and replace with new code
// s_last_channel = gs_RxLastChannel;

   if(STATArray[STAT_QLN_Performance] & STAT_512Bin_QLN_ON)
   {
      s_last_channel = RX_NUM_TONES-1;
   }
   else
      s_last_channel = gs_RxLastChannel;

//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start): Commented out old code and replace with new code

//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start): Commented out old code
// if(( gl_SelectedMode & (MODE_G992_5)  ))
// {
//    s_firstcomp_channel = (int16)RX_FILTERCOMP_FIRST_CHAN_PLUS;
//    s_lastcomp_channel = (int16)RX_FILTERCOMP_LAST_CHAN_PLUS;
// }
// else
// {
//    s_firstcomp_channel = (int16)RX_FILTERCOMP_FIRST_CHAN_BIS;
//    s_lastcomp_channel = (int16)RX_FILTERCOMP_LAST_CHAN_BIS;
// }
//
// //check channel range
// if(s_first_channel < s_firstcomp_channel)
//    s_first_channel = s_firstcomp_channel;
// if(s_last_channel > s_lastcomp_channel)
//    s_last_channel = s_lastcomp_channel;
// if(s_last_channel < s_first_channel)
//    return;
   //ADSLRTFW-1408 Enhance_DS_Bis_ANNEXAL_512Tone_QLN(start)
   //ADSLRTFW-1407 PERF_DS_BisPLUS_ANNEXB_512ToneQln_DualNotch (start)
   //Enhance_DS_ADSL1_ANNEXAB_512Tone_QLN (Start_End)
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (End): Commented out old code

//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start): Replaced with new code
   if (STATArray[STAT_QLN_Performance] & STAT_512Bin_QLN_ON)
   {
      s_firstcomp_channel = (int16) RX_FILTERCOMP_FIRST_CHAN_PLUS;
      s_lastcomp_channel = (int16) RX_FILTERCOMP_LAST_CHAN_PLUS;
   }
   else
   {
      s_firstcomp_channel = (int16) RX_FILTERCOMP_FIRST_CHAN_BIS;
      s_lastcomp_channel = (int16) RX_FILTERCOMP_LAST_CHAN_BIS;
   }
   //ADSLRTFW-1408 Enhance_DS_Bis_ANNEXAL_512Tone_QLN(start)
   //ADSLRTFW-1407 PERF_DS_BisPLUS_ANNEXB_512ToneQln_DualNotch (start)


//ADSLRTFW-1381 PERF_DS_PLUS_ANNEXA_512ToneQLN (Start_End)
//Bugfix_DS_Bis_ANNEXA_RFI_COMB1_Timeout (start)
   if(STATArray[STAT_QLN_Performance] & STAT_512Bin_QLN_ON)
   {
      p_QLNInfo->gs_len_qln = RX_NUM_TONES;
   }
   else
      p_QLNInfo->gs_len_qln = gs_RxNumTones;
//Bugfix_DS_Bis_ANNEXA_RFI_COMB1_Timeout (End)
   // check channel range
   if (s_first_channel < s_firstcomp_channel)
      s_first_channel = s_firstcomp_channel;
   if (s_last_channel > s_lastcomp_channel)
      s_last_channel = s_lastcomp_channel;
   if (s_last_channel < s_first_channel)
      return;

//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (End): Replaced with new code

//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start): Comment out old code

   // Find corresponding first and last index into input vector
// if(( gl_SelectedMode & (MODE_G992_5)  ))
// {
//    // Feature_DS_BisPlus_ALL_VR9QLNCalib (Start)
//#ifdef ISDN
//      s_first_channel = 8;
//#else
//      //AnxA
//      s_first_channel = 1;
//#endif
//    // Feature_DS_BisPlus_ALL_VR9QLNCalib (End)
//    s_first_index = s_first_channel >> 1;
//    s_last_index = (s_last_channel-1) >> 1;
//    s_first_channel = (s_first_index<<1) + 1;
// //XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End): changed from 2 to 1
//    s_ToneStepSize = 2;
// }
// else
// {
//    // Feature_DS_BisPlus_ALL_VR9QLNCalib (Start)
//#ifdef ISDN
//      s_first_channel = 4;
//#else
//      //AnxA
//      s_first_channel = 1;
//#endif
//    // Feature_DS_BisPlus_ALL_VR9QLNCalib (End)
//    s_first_index = s_first_channel;
//    s_last_index = s_last_channel;
//    s_ToneStepSize = 1;
// }
//
   //get compensated input frequency samples in dB Q8.8
   //Use current pga if computed during R_C_QUIET1_RX_BIS
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (End): Comment out old code

//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start): Replaced with new code
   // Find corresponding first and last index into input vector
   //ADSLRTFW-1407 PERF_DS_BisPLUS_ANNEXB_512ToneQln_DualNotch(start)
   //ADSLRTFW-1408 Enhance_DS_Bis_ANNEXAL_512Tone_QLN (start_end)
   // 512 points/bins QLN for Bis/plus modes
   //Enhance_DS_ADSL1_ANNEXAB_512Tone_QLN (Start_End) extended to DMT also


   if (STATArray[STAT_QLN_Performance] & STAT_512Bin_QLN_ON)
   {

   //ADSLRTFW-1381 PERF_DS_PLUS_ANNEXA_512ToneQLN (START)
      s_first_channel = 1;
      s_first_index = s_first_channel;
      s_last_index = s_last_channel;
      s_ToneStepSize = 1;
   //ADSLRTFW-1381 PERF_DS_PLUS_ANNEXA_512ToneQLN (END)
   }
   else
   {
      s_first_channel = 1;  //ADSLRTFW-1380 PERF_ALL_ALL_ANNEXA_QLN_Calibration (START_END)
      s_first_index = s_first_channel;
      s_last_index = s_last_channel;
      s_ToneStepSize = 1;
   }
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (End): Replaced with new code

   s_pga = (gs_PGA_set+1)>>1; //Q9.7

#ifdef TARGET_HW
   /* Find the shift corresponding to the largest 64 bit accumulated value to maximize */
   /* dynamic range for final 32-bit buffer. Note that the NoiseAcc routine implements */
   /* 64 bit accumulator using two concatinated 32-bit words (i.e., output has 32-bit */
   /* MSW and LSW). Note also that we are ignoring the DC value as we do not care if */
   /* it clips for QLN calculation. */
   /* Want to be able to use RoundNoiseAccum() below, so do not subsample PLUS until after then. */
   s_RightShift = 0;
   for (i = 2; i < 2*(p_QLNInfo->gs_len_qln); i+=2)
   {
      l_tempL = pla_inbuf[i];
      l_tempH = pla_inbuf[i+1];
      /* Find the number of shifts needed to convert 64-bit number to 1.31 positive */
      /* number (0x7FFFFFFF is the maximum RoundNoiseAcc routine can handle). */
      if (l_tempH != 0)
      {
         l_tempH = 32 - norm_l(l_tempH);
      }
      else if (l_tempL < 0)
      {
         l_tempH = 1;
      }

      if (l_tempH > (int32)s_RightShift)
         s_RightShift = (int16)l_tempH;
   }
#else
   // Find largest 16-bit MSW of 48-bit buffer to maximize dynamic range for final 32-bit buffer
   // Want to be able to use RoundNoiseAccum() below, so do not subsample PLUS until after then
   {
      int32 l_MaxMag;
   l_MaxMag = 0;
   for (i = 0; i < 2*gs_RxNumTones; i+=2)
   {
      /* find absolute value of int48 */
      l_tempL = pla_inbuf[i];
      l_tempH = pla_inbuf[i+1];
      norm_acc48(&l_tempH, &l_tempL);

      if (l_tempH > l_MaxMag)    // power always positive
         l_MaxMag = l_tempH;
   }
   // Find power of 2 scale factor that will scale for large dynamic range.
   if(l_MaxMag < (int32)0x00004000)
      s_RightShift = 0; //16-bit MSW unused
   else
      s_RightShift = 32 - (norm_l(l_MaxMag) + 16);  // <= (32 - 16)
   }
#endif
   //convert from 48-bit to 32-bit buffer
   RoundNoiseAccum(pla_inbuf, pla_NoisePower,  0, (int16)(p_QLNInfo->gs_len_qln-1), s_RightShift);


   /* -2 Offsets factor 1/4 in calling NoiseAcc(...) */
   if(STATArray[STAT_MacroState] == STAT_LoopDiagMode)
      s_icn_scale_avg_dB = (LOG2_R_C_QUIET1_QLN_LEN_DIAG-s_RightShift-2)*C_10LOG10_2;
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start): Comment out and replace with merged code
// else
//    s_icn_scale_avg_dB = (LOG2_R_C_QUIET1_QLN_LEN-s_RightShift-2)*C_10LOG10_2;

   else
   //SMS00842179 SMS00842445  SMS00842446 SMS00842449  Perf_DS_Plus_All_DPBO (START)
   //SMS00842180 IOP_DS_BisPlus_AlcatelBRCM_ReduceQLNperiod -- Start
   #ifdef ISDN
      {
         //Enhance_DS_ADSL1_ANNEXAB_512Tone_QLN (Start)
         s_LOG2_R_C_QUIET1_QLN_LEN = LOG2_R_C_QUIET1_QLN_LEN;
         if(gt_DS_MeasurementPeriod.us_QLN_measurement_period == 64)
            s_LOG2_R_C_QUIET1_QLN_LEN = 6;
            s_icn_scale_avg_dB = (s_LOG2_R_C_QUIET1_QLN_LEN - s_RightShift - 2) * C_10LOG10_2;//DPBO_Verify
      }
   #else
      {  //Enhance_DS_ADSL1_ANNEXAB_512Tone_QLN (Start)

         s_LOG2_R_C_QUIET1_QLN_LEN = LOG2_R_C_QUIET1_QLN_LEN;
         if(gt_DS_MeasurementPeriod.us_QLN_measurement_period == 64)
            s_LOG2_R_C_QUIET1_QLN_LEN = 6;

         s_icn_scale_avg_dB = (s_LOG2_R_C_QUIET1_QLN_LEN - s_RightShift - 2) * C_10LOG10_2;
      }  //Enhance_DS_ADSL1_ANNEXAB_512Tone_QLN (End)
   #endif
      //SMS00842180 IOP_DS_BisPlus_AlcatelBRCM_ReduceQLNperiod -- End
   //SMS00842179 SMS00842445  SMS00842446 SMS00842449  Perf_DS_Plus_All_DPBO (END)
   //XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (End)

   //convert to Q9.7
   s_icn_scale_avg_dB++;
   s_icn_scale_avg_dB>>=1;


#ifdef DEBUG_TESTPARM
   fprintf(fp, "\npla_inbuf_compensated:\n");
#endif
   //clear upto first channel
   //set Lower subchannels to unused special value
   for (i=0; i<s_first_index; i++)
   {
      puca_msg_ld[i]= (uint8)OUT_OF_RANGE_QUIETLINE_PSD;
   }

   //convert linear power to dB
    for (i=s_first_index, s_channel=s_first_channel; i <= s_last_index; i++, s_channel+=s_ToneStepSize) {

      l_ipower = pla_NoisePower[s_channel];

      //Compute the received power in dB =
      //10*log10(l_ipower) l_ipower in Q32.0 format
      if(l_ipower == 0)    //check for 0 which could result from scaling
      {
         puca_msg_ld[i] = (uint8)OUT_OF_RANGE_QUIETLINE_PSD;
         continue;
      }
      else
         s_pwr_db = ConvertToDB(l_ipower);

      //convert to Q9.7
      s_pwr_db++;
      s_pwr_db >>= 1;


      s_pwr_db = RxFilterCompensate((int16)s_pwr_db,s_pga,(int16)POWER_TO_DBM_PER_HERTZ, s_channel);


      if(s_pwr_db > (int16)MIN_16 + (int16)s_icn_scale_avg_dB)
      {
         // apply scaling for averaging in Q9.7
         s_pow_dbmperHz = (int16)s_pwr_db - (int16)s_icn_scale_avg_dB;
      }
      else
         s_pow_dbmperHz = (int16)MIN_16;

#ifdef DEBUG_TESTPARM
      fprintf(fp, "%f\n", (double)s_pow_dbmperHz/128.0); /*Q9.7*/
#endif

      //store result in output message format
      //if s_pow_dBmperHz in Q9.7 is outside the range  [-150, -23]
      //then QLN(i) cannot be represented in BIS
      if((s_pow_dbmperHz < (-150*128)) || (s_pow_dbmperHz > (-23*128))) {
         puca_msg_ld[i]= (uint8)OUT_OF_RANGE_QUIETLINE_PSD;
      }
      else
         //n(i)=round[2*(-23-QLN(i))]
         puca_msg_ld[i]= (uint8)round((-(23<<7))-s_pow_dbmperHz,6);

   }

   //For upper subchannels
   //upto Annex defined # of tones
   //The following will fill upto the end of 256 element vector used
   for (i = (s_last_index+1); i<(p_QLNInfo->gs_len_qln); i++)
   {
      puca_msg_ld[i]= (uint8)OUT_OF_RANGE_QUIETLINE_PSD;
   }

   s_OutofRangeValue = OUT_OF_RANGE_QUIETLINE_PSD;

   // calculate average noise PSD
   CalcAvgNoisePSD(puca_msg_ld, s_OutofRangeValue);
   if(gft_NMSTxSilence == TRUE)
   {
      guc_SnrCalcState = TRAINING_DONE;
      return;
   }
   //Do explicit memcopy here for data that will eventually be moved off-chip
   //memcpy(guca_QLN,  puca_msg_ld,  sizeof(int8)*(gs_RxNumTones));

#ifdef DEBUG_STREAMING
   DSH_SendStream(DSH_QLN,  sizeof(int8)*(gs_RxNumTones), &puca_msg_ld[0]);
#endif

#ifdef DEBUG_TESTPARM
   fprintf(fp, "\npla_out:\n");
   for(i=0; i<256; i++)
      fprintf(fp, "%d\n", (int16)puca_msg_ld[i]);

   fprintf(fp,"pga=%d\n",gs_PGA_set);
   fprintf(fp,"\ns_ToneStepSize=%d\n",s_ToneStepSize);
   fclose(fp);
#endif

   /* Detect type of crosstalk present on the line. */
   DetectXtalk();

//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start)
  // #ifndef ISDN // PERF_DS_PLUS_ANNEXA_FIXED_RFI_DISTURBER_SINGLE_NOTCH SMS01364242 (Start)

//   if ((gs_RixedRfiNotchFilterCMVControl == 1) && ((gl_SelectedMode & MODE_G992_5) != 0))
   if (!(gt_INFX_CMV.us_OperatorSpBits6 & CMV_TO_DISABLE_RFI_NOTCH)) //ADSLRTFW-1382 PERF_DS_ALL_ANNEXA_FIXED_RFI_DISTURBER_ALLmodes (Start_end)
   {
         getRfiDetection();

      if (gs_activefilterfreq != 0)
         gs_NotchFilterEnable = 1;
      else
         gs_NotchFilterEnable = 0;


      if (gs_NotchFilterEnable == 1)
        {
      /* input parameters for Rx filter */
      alpha = 9;     // 1.15 alpha_ = (1-2^-(15-alpha))
      beta  = 4;     // 1.15 beta_  = (1-2^-(15-beta))
      if ((gl_SelectedMode & MODE_G992_5) != 0)
         calcNotchFilterBis(alpha, beta, gs_activefilterfreq );
      else calcNotchFilterBis(alpha, beta, 2*gs_activefilterfreq );
            guc_NoOfNotchFilters++; //Enhance_DS_Bis_plus_DEC_Adapt_SlowDown (start_end)

   #ifndef ISDN
   /* Update Decim2/HPF coefficients. */
      //Enhance_DS_Bis_plus_DecimCode_Cleanup (start)
      pula_DecimCoefsDst = p_QLNInfo->gula_StrymonIir_Filter_DecimHpf_2_with_Notch;
      if ((gl_SelectedMode & MODE_G992_5) != 0)
      {
         pula_DecimCoefsSrc =  gula_Strymon_RxIir_Pots_Plus;
      }
      else
      {
         pula_DecimCoefsSrc =  gula_Strymon_RxIir_Pots_Bis;
      }
      for (i = 0; i < 34; i++)
      {
         pula_DecimCoefsDst[i] = pula_DecimCoefsSrc[i];   // Copy the filter to Notch filter
      }
      //Enhance_DS_Bis_plus_DecimCode_Cleanup (end)
//    if ((gl_SelectedMode & MODE_G992_5) != 0)
//    {
         p_QLNInfo->gula_StrymonIir_Filter_DecimHpf_2_with_Notch[3]  =     (p_QLNInfo->gs_inscale)<<4;
         p_QLNInfo->gula_StrymonIir_Filter_DecimHpf_2_with_Notch[6]  =     (p_QLNInfo->gs_b0)<<4;
         p_QLNInfo->gula_StrymonIir_Filter_DecimHpf_2_with_Notch[7]  =     (p_QLNInfo->gs_b1)<<4;
         p_QLNInfo->gula_StrymonIir_Filter_DecimHpf_2_with_Notch[8]  =     (p_QLNInfo->gs_b2)<<4;
         p_QLNInfo->gula_StrymonIir_Filter_DecimHpf_2_with_Notch[10]  =    -(p_QLNInfo->gs_a2)<<4;
         p_QLNInfo->gula_StrymonIir_Filter_DecimHpf_2_with_Notch[9]  =  -(p_QLNInfo->gs_a1)<<4;
         p_QLNInfo->gula_StrymonIir_Filter_DecimHpf_2_with_Notch[11] =     (p_QLNInfo->gs_b0_stage2)<<4;

//    }
//    gs_v1 = p_QLNInfo->gs_inscale;
//    gs_v2 = p_QLNInfo->gs_b0;
//    gs_v3 = p_QLNInfo->gs_b1;
//    gs_v4 = p_QLNInfo->gs_b2;
//    gs_v5 = p_QLNInfo->gs_a1;
//    gs_v6 = p_QLNInfo->gs_a2;
//    gs_v7 = p_QLNInfo->gs_b0_stage2;
   #endif
      }//if (gs_NotchFilterEnable == 1)
   }
   else
   {
      gs_NotchFilterEnable = 0;
   }//if (!(gt_INFX_CMV.us_OperatorSpBits6 & CMV_TO_DISABLE_RFI_NOTCH))

 // PERF_DS_PLUS_ANNEXA_FIXED_RFI_DISTURBER_SINGLE_NOTCH SMS01364242 (End)
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (End)


   guc_SnrCalcState = TRAINING_DONE;
   return;
}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : CalcAvgNoisePSD()
 *
 *  Description:  Computes the Average Noise PSD in dBm per Hz, from the computed Qln values.
 *          First largest value is searched and converted to linear in mantissa and exponent form.
 *          Using this exponent value, all the other values are converted to linear; and average value computed in linear
 *          and reconverted back to dBmperHz.
 *
 *  Prototype:
 *    void void CalcAvgNoisePSD(uint8 *puca_msg_ld, int16 s_OutofRangeValue)
 *
 *  Input Arguments:
 *      uint8  *puca_msg_ld - pointer to computed Qln array (containing values in 9.7 format)
 *    int16 s_OutofRangeValue - Out of Range values, which are either not computed or beyond the range and
 *                      are not to be used in computation of average
 *
 *  Output Arguments:
 *      int16  gs_RxAvNoisePSD - Average Noise PSD (in dBm per hz)
 *
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

C_SCOPE void CalcAvgNoisePSD(uint8 *puca_msg_ld, int16 s_OutofRangeValue)
{
   int16 s_temp,s_temp1, s_temp_exp, s_ToneStepSize, s_countNumTones, s_dBAdjustExp;
   int i;
   int32 l_temp=0, l_temp1;


   if(( gl_SelectedMode & (MODE_G992_5)  ))
      // As the Array is of size 256, look for half the number of tones in PLUS
      s_ToneStepSize = 1;
   else
      s_ToneStepSize = 0;



   s_temp = (int16) 0x8000; // initialize to smallest value

   // Determine the largest value
   for (i= gs_RxFirstChannel; i <= (gs_RxLastChannel>>s_ToneStepSize); i++)
   {
      // skip over the out of range values
      if (puca_msg_ld[i] == s_OutofRangeValue) continue;

      // convert back to dbm per Hz value
      s_temp1 = -23 - (puca_msg_ld[i] >> 1) ;

      // pick the largest value
      if (s_temp1 > s_temp) s_temp = s_temp1;

   }


   // convert the largest value to linear (note input is in dbm, we can't represent numbers in 8.8)

   logtolin(&s_temp, &s_temp_exp,1);

   // convert all the values to linear with exponent corresponding to the maximum

   s_countNumTones=0;
   for (i= gs_RxFirstChannel; i < (gs_RxLastChannel>>s_ToneStepSize); i++)
   {
      if (puca_msg_ld[i] == s_OutofRangeValue) continue;

      // Qln contains the values in the range -23 to -150, obtained from n(i)

      s_temp = (-23 - (puca_msg_ld[i] >>1));

      // convert to linear value with the same exponent
      logtolin(&s_temp, &s_temp_exp,0);

      s_countNumTones++;

      // accumulate linear values
      l_temp += s_temp ;

   }

   // average over the number of tones
   if (s_countNumTones>0)
   {
      l_temp = (l_temp + (s_countNumTones>>1))/ s_countNumTones;

      // account for dB adjutment based on exponential
      if (s_temp_exp >0)
      {
         l_temp1 =  (1<<s_temp_exp);
         s_dBAdjustExp =  - 2*ConvertToDB(l_temp1);
      }
      else
      {
         l_temp1 =  (1<<~s_temp_exp);
         s_dBAdjustExp = 2*ConvertToDB(l_temp1);

      }

      // convert to dB
      gs_RxAvNoisePSD = 2*ConvertToDB(l_temp) + s_dBAdjustExp;
   }
   else
      // Undefined PSD.  Since QLN values cover the range -150 to -23 dBm/Hz, we assume
      // here that an out-of-range value is more likely to be > -23 than < -150.  Set value
      // to zero, which gets treated as very strong noise.
      gs_RxAvNoisePSD = 0;

   return;
}
