/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   CalcRate_BIS.c
*
*   Calculate net data rate (bits/sec) and ovhd rate (*250 bits/sec) in BIS.
*-------------------------------------------------------------------------
*/
// ************************************************************************
// CalcRate_BIS.c
//
// History
//
// 29/01/2013 ChihWen:
//          1. Modify reported ETR from 16-bit kbps format to 32-bit bps format.
//          2. Fix DS rate calculation when ReTx is on and Tp[1]=-1.
//          Grep for XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr
//
// ************************************************************************

#include "common.h"
#include "gdata.h"
#include "dsp_op.h"
#include "dsp_op2.h"
#include "data_alloc.h"
#include "mul.h"


/*
 *------------------------------------------------------------------------------
 *
 *  Name :  void CalcRate_BitsPerSecond(Config_t* t_config, int32* pla_DataRate, int16* psa_OHRate )
 *
 *  Description: Calculate net data rate (bits/sec) and ovhd rate (*125 bits/sec) in BIS.
 * Note that an ovhd rate return value of 0 will be increased to 1 to avoid division by
 * zero errors elsewhere in the code.
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE void CalcRate_BitsPerSecond(Config_t* t_config, int32* pla_DataRate, int16* psa_OHRate )
{
   int16 result, s_Num_exp, s_Denom_exp, s_Denom, s_Quo, s_Quo_exp, s_Kp[2];
   int i;
   int32 l_Num,  l_temp, l_temp1;
   //XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr (START_END)
   int16 s_Tp_save = 0;


   for (i = 0; i < t_config->s_Nlp; i++)
   {
      //XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr (START)
      if ((gt_ReTxConfigInfo.ft_ReTxOn == 1) && (t_config->s_Tp[i] == -1))
      {
         s_Tp_save = -1;
         t_config->s_Tp[i] = 1;
      }
      //XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr (END)

      s_Kp[i] = t_config->sa_Bpn[i][0]+t_config->sa_Bpn[i][1]+1;

        s_Quo = 0;

      // Calculate bits/frame = (Mp*Lp) / (Tp*(Kp*Mp+Rp))

      // l_Temp = Mp*Lp
      MULS16(l_temp , t_config->s_Mp[i] , t_config->s_Lp[i]);

      // s_Denom = Tp*(Kp*Mp+Rp)
      MULS16(l_temp1,s_Kp[i], t_config->s_Mp[i]);

      MULS16(s_Denom,l_temp1 + t_config->s_Rp[i], t_config->s_Tp[i]);


      s_Denom_exp = norm_16bit(s_Denom);

      //Calculte ovhd rate = (Mp*Lp) / (Tp*(Kp*Mp+Rp))*125 bits/frame

      s_Num_exp = norm_l(l_temp);

      result = Divide_32by16bit(l_temp<<s_Num_exp, (int16)(-s_Num_exp),
         (int16)(s_Denom<<s_Denom_exp), (int16)(-s_Denom_exp),
         &s_Quo, &s_Quo_exp);

      // Truncate by right shifting to round down. value*125 bit/frame (keep the precision)
      psa_OHRate[i] = (int16)(s_Quo >> (-s_Quo_exp-5));

      if (psa_OHRate[i] == 0)
         psa_OHRate[i] = 1;

      // net rate
      MULS16(l_temp1, t_config->s_Tp[i] , s_Kp[i]);


      // l_Num = MpLp *(Tp*Kp-1)
      MULS32x16(l_Num, l_temp, (int16)(l_temp1  - 1) );

      l_Num = (l_Num << 2);  // multiply by 4, as the max value can go to 2^29

      s_Num_exp = norm_l(l_Num);
      result = Divide_32by16bit(l_Num<<s_Num_exp, (int16)(-s_Num_exp),
         (int16)(s_Denom<<s_Denom_exp), (int16)(-s_Denom_exp),
         &s_Quo, &s_Quo_exp);

      l_temp1=(s_Quo >> (-s_Quo_exp));
            // Scale to get bits per second.
      MULS32x16(pla_DataRate[i],l_temp1, 1000);

      //XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr (START)
      if ((gt_ReTxConfigInfo.ft_ReTxOn == 1) && (s_Tp_save == -1))
         t_config->s_Tp[i] = -1;
      //XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr (END)

   }
}



