/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   CalcSigAttnDiag.c
*
*   functions to compute the Signal Attenuation (SATN)
*   test-parameter specific for G.bis Diagnositics.
*
*-------------------------------------------------------------------------
*/

#include "gdata.h"
#include "stdio.h"
#include "cmv.h"
#include "gdata_bis.h"
#include "snr.h"
#include "dsp_op.h"
#include "gdata_bis_diag.h"
#include "diagparam_bis.h"
#include "bitload_const.h"
#include "decimalgain.h"
#include "rinfotbl.h"

#ifdef AMAZON_AFE
extern int16 gs_Adjust_LATN;
#endif

/*^^^
 *------------------------------------------------------------------------
 *
 *  Prototype:
 *    uint16 SignalAttenu_BIS(int16 *psa_RxHlog,int16 *psa_snr,
 *                      int16 *psa_RxFineGains,int16 s_nomatp)
 *
 *  Description:  Compute the average downstream signal attenuation (SATN)
 *
 *
 *  Input Arguments:
 *      int16 *psa_RxHlog     pointer to Measured Rx Hlog in Diagmode format,
 *                   therfore Hlog(f) = 6 - psa_RxHlog[f]/10.
 *    uint8 *puca_fdqexp
 *    int16 *psa_snr       Medley SNR
 *    int16 *psa_RxFineGains  FineGains (can be set to NULL during DiagMode)
 *    int16 s_nomatp       NOMATP (in 0.1 dB step size) = NOMATAP*10
 *    int16 s_RxNumTones
 *
 *  Output Arguments:
 *      none
 *
 *  Return:
 *    Average upstream signal attenuation
 *
 * Global Variables:
 *    guca_RMSG1_LD[]
 *    gusa_DS_Inverse_Tssi_Value
 *    gt_FineGainInfo.s_ExcessMarRedDB
 *
 *  Notes:  Here, the received Reverb signal (from Hlog(f)) not the Medley Signal
 *       is used to compute the Signal Attenuation.
 *       Also use NOMATP as opposed to ACTATP so you do not have
 *       to account for PCB in the Tranmsit nor receive power.
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE uint16 SignalAttenu_BIS(int16 *psa_RxHlog, int16 *psa_snr, int16 *psa_RxFineGains, int16 s_nomatp)
{
   int32 l_tmp0, l_AccPower;
   int16 s_pwr_dbm, s_X, s_Y, i, s_gain_dB, s_pwr_db, s_RightShift;
   int16 s_nompsd;
   int16 s_tmp_exp, s_AccPower_exp, s_tmp_exp_delta, s_first_channel, s_last_channel;
   uint16 us_bitmask;
   int16 s_offset, s_shift, s_index, s_Hlog_in;

#ifdef DEBUG_TESTPARM
   FILE *fp;
   fp=fopen("testmedlysig_debug.txt","w");
   fprintf(fp, "\npsa_RxHlog:\n");
   for(i=0; i<gs_RxNumTones; i++)
      fprintf(fp, "%d\n", psa_RxHlog[i]);
   fprintf(fp,"s_nomatp=%d\n\n",s_nomatp);
#endif

   // Convert s_RelativeNompsd from relative (.1 dB step size) to absolute Q8.8 and add 10log10(4312.5)
   s_nompsd = ((int16)gt_TxPMDControl.s_NOMPSD_DS<<8)/10 + (int16)(DEFAULT_NOMPSD_DS<<8);
   s_nompsd += (int16)TEN_LOG_DELTA_F;

   // Initialize channel range to calibrated filter compensation tone range
   // and find corresponding first and last index into input vector
   if(( gl_SelectedMode & (MODE_G992_5)  ))
   {
      s_first_channel = (int16)RX_FILTERCOMP_FIRST_CHAN_PLUS;
      s_last_channel = (int16)RX_FILTERCOMP_LAST_CHAN_PLUS;
      s_offset = 1;
      s_shift = 1;
      us_bitmask=0x1;
   }
   else
   {
      s_first_channel = (int16)RX_FILTERCOMP_FIRST_CHAN_BIS;
      s_last_channel = (int16)RX_FILTERCOMP_LAST_CHAN_BIS;
      s_offset = 0;
      s_shift = 0;
      us_bitmask = 0;
   }

   // Compute recieved Signal power and convert to dBm
    l_AccPower = 0;
   s_AccPower_exp = 0;
    for (i = s_first_channel; i <= s_last_channel; i++) {

      s_index = (i-s_offset)>>s_shift;
      if (IS_TONEFLAGSET(p_MEDLEYset_DS, i) && (psa_RxHlog[s_index] != OUT_OF_RANGE_HLOG))
      {
         if(((i+1) & us_bitmask) == 0)
            s_Hlog_in = psa_RxHlog[s_index];
         else
         {
            // interpolate subsampled Hlog
            // Since we expect it to be smooth in dB domain linearly interpolate dB values
            if(psa_RxHlog[s_index+1] != OUT_OF_RANGE_HLOG)
               s_Hlog_in = (int16)(((int32)psa_RxHlog[s_index] + psa_RxHlog[s_index+1] + 1) >> 1);
            else
               continue;
         }

         //  1. Convert from Diagmode Hlog format to Q8.8.  (6 >= Hlog >= -96)
         s_X = (60-s_Hlog_in)<<5;   //Preshift by only 5 bits to avoid overflow
         s_X /= 10;                 //convert from .1dB gain
         s_X <<= 3;

         //  2. Add FineGains in dB Q8.8
         // In Diag mode, gains are only -inf or 0 (dB) depending on if bits can be loaded on tone or not.
         if(STATArray[STAT_MacroState] == STAT_LoopDiagMode)
         {
            // Use SNR to determine whether the tone can support a bit or not
            if (psa_snr[i] < gsa_ConstellationSNR[gs_RxMinBitsPerTone_BIS_TCM])
               continue;               //s_gain_dB= -inf (no power on tone);
         }
         else
         {
            // Not in Diag mode so apply computed gain
            s_gain_dB = psa_RxFineGains[i];
            if(s_gain_dB == NEG_INFINITY_DB)
               continue;
            else
            {
               s_gain_dB -= gt_FineGainInfo.s_ExcessMarRedDB;
               s_X += s_gain_dB;
            }
         }

         // 3. logtolin
         logtolin(&s_X,&s_tmp_exp,1);

         //  4. s_X multiply by tssi
         if (gl_SelectedMode & MODE_ADSL2)
         {
            s_Y = (int16)gusa_DS_Tssi_Value[i];
         }
         else
            s_Y = 1024;

         s_RightShift = 32 - norm_l((int32)s_Y);

         l_tmp0 = (int32)s_X * s_Y;
         l_tmp0 = round(l_tmp0, s_RightShift);
         s_X = sature16(l_tmp0);

         // 5. square
         l_tmp0 = (int32)s_X * s_X;
         //May have to increase guard bits to 9 for Plus to avoid the possiblity of overflow
         l_tmp0 = round(l_tmp0, RXPWR_GUARD_BITS);

         //update exponent due to squaring (excluding data independent RXPWR_GUARD_BITS and 10 from Q6.10 TSSI)
         s_tmp_exp = (s_tmp_exp - s_RightShift) << 1;

#ifdef DEBUG_TESTPARM
   fprintf(fp,"%d\t%d\n",s_RightShift,s_tmp_exp);
#endif
         //  6. accumulate
         // =====================================================================================
         // Renormalize l_tmp0 to make sure that accumulation buffer
         // and l_tmp0 share the same exponent.
         // =====================================================================================

         // Common exponent value is stored in s_AccPower_exp.
         // If either mantissa is zero, don't do any renormalizing.

         if (l_tmp0 == 0)
            s_tmp_exp = s_AccPower_exp;   // Do this to avoid normalizing either component.

         else if (l_AccPower == 0)
            s_AccPower_exp = s_tmp_exp;   // Do this to avoid normalizing either component.

         s_tmp_exp_delta = s_tmp_exp - s_AccPower_exp;

         if (s_tmp_exp_delta >= 0){
            // Adjust new l_tmp0 component (or do nothing if s_tmp_exp_delta == 0).
            l_tmp0 = round(l_tmp0, s_tmp_exp_delta);
         }
         else {
            // Adjust Acc buffer component, with rounding up
            s_tmp_exp_delta = -s_tmp_exp_delta;
            l_AccPower = round(l_AccPower, s_tmp_exp_delta);
            s_AccPower_exp = s_tmp_exp;
         }

         l_AccPower = l_add(l_tmp0, l_AccPower);
      }
   }

   if(l_AccPower == 0)
      return((uint16)OUT_OF_RANGE_SIGNALATTENU);

   //Compute the average received power per frame in dB =
   //10*log10(l_AccPower) in Q8.8 format
   s_pwr_dbm = ConvertToDB(l_AccPower);

    /* l_AccPower = x_in*2^s_AccPower_exp, therefore s_pwr_db = 10log10(x_in) + 10*s_AccPower_exp*log10(2) */
    /* However, already  right-shifted the results by RXPWR_GUARD_BITS-2*10 bits during accumulation */
    /* Therefore, compensate by setting s_pwr_dbm -= 10*(s_AccPower_exp-RXPWR_GUARD_BITS+20)*log10(2).   */
    l_tmp0 = (int32) -C_10LOG10_2 * (s_AccPower_exp - RXPWR_GUARD_BITS + 20);
   /*  Add in 36.35 + NOMPSD */
   l_tmp0 = l_add((int32)s_nompsd, l_tmp0);
    l_tmp0 = l_add ((int32)s_pwr_dbm, l_tmp0);
    s_pwr_dbm = sature16(l_tmp0);


#ifdef DEBUG_TESTPARM
   fprintf(fp,"\ns_rcvpwr_dbm=%d\n",(s_pwr_dbm*10)>>8);
#endif

   // subtract from (NOMATAP)
   // Note: The Standard defines this backwards since the valid attenuation values >= 0
   l_tmp0 = (int32)(s_nomatp<<8)/10;
    l_tmp0 = l_add (l_tmp0,(int32)-s_pwr_dbm);
    s_pwr_db = sature16(l_tmp0);

#ifdef AMAZON_AFE
   // Adjust signal attenuation to compensate for the HPF and equalizer gain
   s_pwr_db -= gs_Adjust_LATN;
#endif

   //if s_pow_dB in Q8.8 is outside the range  [0, 102.2]
   //then LATN cannot be represented in BIS Diagnostic Mode
   if(s_pwr_db < 0)
      l_tmp0=0;  //Allow for some error in channel estimate
   else if(s_pwr_db > MAX_ALLOWED_SATN) {
      l_tmp0 = (int32)OUT_OF_RANGE_SIGNALATTENU;
   }
   else {
      // Multiply by 10, discard fractionary part
      l_tmp0 = s_pwr_db * 10;
      l_tmp0 = (l_tmp0 + (int32)(1<<7)) >> 8;
   }

#ifdef DEBUG_TESTPARM
   fprintf(fp,"\nSATN [dB*10]=%u\n",(uint16)l_tmp0);
   fclose(fp);
#endif

   return((uint16)l_tmp0);
}
