/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ChooseFineGains_Bis.c
*
*   Source code for FienGain Allocation G.992.3/ G.992.5
*
*-------------------------------------------------------------------------
*/
//****************************************************************************
//ChooseFineGains_Bis.c
//
// History
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 05/07/2012 Ram: Merged "ReTx" Segmented Bitswap Request code from ARX ADSL code base.
//   To cope with sweeping and fixed RFI, the following changes are done.
//   1. Below changes #2,#4,#5,#6 are under cmv control INFO 103 23 bitmask(0x0040). This bit is one (enabled) by default.
//   2. Modify the maximum number of bits for bitswap (gs_REDUCE_LP_DELTA_BITSWAP) from 20 to 120.
//   3. Increase Tx HDLC buffer size (MAX_TX_HDLC_MSG_SIZE, MAX_TX_HDLC_BUFFER_SIZE) from 700 to 1000.
//   4. Increase the maximum tone number (gs_MaxTonePerOvhdMsg) in one HDLC segment from 160 to 240.
//   5. Enable segmented bitswap request.
//   6. Change gs_DD_RxChannelsPerSymbol from 16 to 32 to improve SNR updating frequency.
//   7. Once marign on tones were ever dropped to below -6 dB, then bitswap is triggered when minimum margin is below 0 dB.
//      The threshold (-6dB by default) can be changed with cmv INFO 119 0.
//   8. Do not move bits to the tones whose margin were ever dropped to below -6 dB since these tones were very likely
//      to be affected by RFI before, and will be affected by RFI again. This mechanism is under cmv control
//      INFO 103 23 bitmask(0x0080). This bit is one (enabled) by default.
//   9. If bitswap is failed, checking of #7 condition will be ignored. Then bitswap will be tried again.
//   10. Include fix SMS01320806 IOP_A_BisPlus_CNXT_ImprovedBitSwap.
//   Grep for "XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest"
// 08/11/2012 Anantha:  Disabling marking of bitswap tones as it is used for marking tones which have margin
//                              between min margin and min margin + delta. Marking of tones with bit swap is moved to the end of bitswap scheme
// Grep for XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap
// 20/02/2013 Mahesh:  Removed Ananta's bitswap enhancement changes for L2 & SRA
//
// 15/01/2018 Chih-Wen: XDSLRTFW-3475
//            BER failed in TR100A 5T1 MV test against Lucent Stinger.
//            After 5dB noise boost, BER failed even with new NMS disabled. Some bits were swapped to lower tones (33~48)
//            because of higher margin, which caused lots of CRC.
//            The workaround was to disable NMS and avoid bits being swapped to tone 33~48.
//
//            To kick in the workaround, the following conditions must be met.
//            1. ADSL2+ AnnexA.
//            2. CNXT CO.
//            3. STAT[STAT_Performance] set "STAT_5T1Noise".
//            4. Loop lengths are between 4K and 6K feet.
//
//            Grep for XDSLRTFW_3475_TR100A_MV_5T1_AvoidBitswapAddBitsOnLower16Tones
//
//*****************************************************************************************

#include "common.h"
#include "dsp_op.h"
#include "dsp_op2.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "bitload.h"
#include "bitload2.h"
#include "bitload_bis.h"
#include "mp.h"
#include "cmv.h"
#include "exchdata.h"
#include "tone_ord.h"
#include "const_bis.h"
#include "states.h"
#include <stdlib.h>
#include "changebat.h"
#include "decimalgain.h"
#include "diagparam_bis.h"
#include "snr.h"
#include "bitload_support.h"
#include "ComputeRMSFineGain.h"
#include "bitload_const.h"
#include "mul.h"
#include "pll.h"

//XDSLRTFW_3475_TR100A_MV_5T1_AvoidBitswapAddBitsOnLower16Tones (START)
extern FlagT gft_BitswapNotAddingBitsToTones;
extern RxToneFlags gp_BitswapNotAddingBitsToTones;
//XDSLRTFW_3475_TR100A_MV_5T1_AvoidBitswapAddBitsOnLower16Tones (END)

/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       int16 ChooseFineGains_BIS(void);
*
*   Description:
*       Find the channels where we can apply the fine gains.
*               Perform extra bit allocation.
*               It also (optionally) check that the TX spectral
*       mask is not violated.
*
*
*   Returns:
*       number of extra bits allocate by applying the fine gain
*
*       Global variables:
*               gs_RxBitLoadFirstChannel-- (I) RX first channel
*               gs_RxBitLoadLastChannel -- (I) RX last channel
*               gpsa_MeasuredSnrBuf             -- (I) pointer to computed channel SNR per tone
*               gsa_SNRRequired[]               -- (I) required SNR per constellation
*               guc_MaxAllocBitsPerTone -- (I) maximum number of bits per tone
*
*               gsa_RxBat[]                             -- (I/O) Bit Allocation Table after adding bits due to fine gain
*               gsa_RxFineGainPlusBitChannel[] -- channel index where fine gain is applied
*
*-----------------------------------------------------------------------------
^^^*/

C_SCOPE int16 ChooseFineGains_BIS(uint8 *psa_RxBat, int16 *psa_RxFineGains, int32 *pl_SumFGainLinSq , int32 *pl_SumGiSqTssiSq, int16 s_maxLp , int16 s_Flag_NoBatCh, int16 s_path)
{

   int s_ch;             /*  channel index */
   uint32 s_qc;             /*  QAM constellation size */
   int16 s_StepUp=0;
   int s_SNR;
   int s_ExtraBits = 0, s_AdditionalSNRNeeded, s_ToneToAddTo;
   int16 s_MinBitsPerTone = (int16) gs_RxMinBitsPerTone_BIS_TCM;

   int16  s_FineGainToConsider;
   int32  l_SumFGainLinSq = 0, l_SumFGainLinSq_toconsider,l_temp;
   uint16  s_ncloaded;
   int16  s_flag_rms_increase =0, s_reqdbitsreached =0;
   int32 l_MaxSumFGainLinSq;
   int16 s_threshold;
   int16 s_Dummy1ReturnValue, s_Dummy2ReturnValue, s_Dummy3ReturnValue;
   int32 l_SumGiSqTssiSqToConsider;

   // get ncloaded

   GetBatStats(psa_RxBat, gs_RxNumTones, gft_TcmFlag_bis_DS, &s_ncloaded, &s_Dummy1ReturnValue, &s_Dummy2ReturnValue, &s_Dummy3ReturnValue, s_path);

   l_SumFGainLinSq_toconsider = *pl_SumFGainLinSq;

   l_SumGiSqTssiSqToConsider =  *pl_SumGiSqTssiSq;

   // start with a threshold small enough and go upto 5dB, to add bits using fine gain
   // increase the threshold in every iteration
   // every iteration add just enough bits which require fine gain to be less than the threshold
   s_threshold = 25;

   while (s_threshold < 5*256)
   {
        s_AdditionalSNRNeeded = 0x7fff ;                // BIG number
        // Find tone that requires the smallest increase in SNR in order to increase the bitloading.
        for(s_ch = gs_RxBitLoadLastChannel ; s_ch >= gs_RxBitLoadFirstChannel; s_ch--)
        {
            //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
            //UReTx_Merge_Extra_modifications Begin
            //Feature_Common_Bitloading_functions_for_training_and_showtime Begin
            //FEATURE_DS_BisPlus_ALL_FrameWorkInBitLoadForBitSwap Start_End
            if(!(gt_ReTxConfigInfo.ft_ReTxOn == 1))
            //Feature_Common_Bitloading_functions_for_training_and_showtime End
            {
                //UReTx_Merge_Extra_modifications End
                //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
                /* only if we have dual latency support and we are working for LP0 path, assume that LP1
                    is already set and skip over the LP1 tones */
                if (((STATArray[STAT_Mode] & STAT_ConfigMode_ADSL2_ALL) != 0) &&
                     (gt_rx_config.s_Nlp == 2) && (s_path == LP0_DATA_PATH) &&
                     (IS_TONEFLAGSET(p_TonesAllocatedtoLP1_DS, (int16) s_ch)))
                        continue;
                //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
                //UReTx_Merge_Extra_modifications Begin
            }
            //UReTx_Merge_Extra_modifications End
            //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)

            /* Skip for the DD pilot tone */
            if (s_ch == gs_AuxPilotToneIdx || s_ch == gs_CPilotTone)
               continue;
            if (IS_TONEFLAGSET(p_FINEGAINSKIPset,s_ch) )
                continue;

            s_qc = psa_RxBat[s_ch];

            if (s_qc == guc_MaxAllocBitsPerTone)
               continue;

            if ((s_Flag_NoBatCh == 1) && (s_qc < 2))
               continue;

            if (psa_RxFineGains[s_ch] == NEG_INFINITY_DB)
               continue;

            //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
            //Do not move bits to the tones whose margin were ever dropped to below -6 dB
            //since these tones were very likely to be affected by RFI before, and will be
            //affected by RFI again.
            //guca_TimeVaryNoise_Ind_sav is the array to indicate the tones whose margin
            //were ever dropped to below -6 dB.

            if ((gl_SelectedMode & (MODE_ADSL2)) &&
                (STATArray[STAT_OLRStatus_DS] == STAT_OLR_BITSWAP) &&
                //XDSLRTFW_3475_TR100A_MV_5T1_AvoidBitswapAddBitsOnLower16Tones (START)
                ( (gs_RxState == R_C_SHOWTIME_RX) && ((IS_TONEFLAGSET(guca_TimeVaryNoise_Ind_sav,s_ch)) || (IS_TONEFLAGSET(gp_BitswapNotAddingBitsToTones,s_ch))) )
                )
                //XDSLRTFW_3475_TR100A_MV_5T1_AvoidBitswapAddBitsOnLower16Tones (END)
                continue;
            //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)

            // s_SNR adjusted with fine gain
            s_SNR = gpsa_MeasuredSnrBuf[s_ch] + psa_RxFineGains[s_ch];

            if (gs_RxState == R_C_SHOWTIME_RX)  // using it with showtime, add coding gain
            {
                s_SNR += gsa_TotalCodingGain[LP0_DATA_PATH]; // assuming Single Latency path
                //gft_EnableNomATP = 0; // to ensure that we don't worry about NomATP constraint in showtime
            }

            if(s_qc == 0)
            {
               s_StepUp = s_MinBitsPerTone;
               // If we load this tone we will start with min fine gain.
               s_SNR += gs_min_fine_gain;
            }
            else
               s_StepUp = 1;

            s_AdditionalSNRNeeded = gsa_SNRRequired[s_qc+s_StepUp] - s_SNR;
            if (s_qc == 0)
            {
               if (s_AdditionalSNRNeeded > (gs_max_fine_gain - gs_min_fine_gain))
                 continue;
            }
            else if (s_AdditionalSNRNeeded > (gs_max_fine_gain - psa_RxFineGains[s_ch]))
                continue;
            s_ToneToAddTo = s_ch;
#if 0   // debug code to check extra bits through FG allocation
            if (s_qc == 0)
            {
               //since s_qc has been updated in each iteration
               if (s_AdditionalSNRNeeded > s_threshold)
                  continue;
            }
            else
            {
               //The above code is incorrect
               if ((s_AdditionalSNRNeeded + psa_RxFineGains[s_ch] - gs_min_fine_gain) > s_threshold)
                  continue;
            }
#else
            if (s_AdditionalSNRNeeded > s_threshold)
               continue;
#endif
            if (s_ExtraBits == s_maxLp)
            {
                s_reqdbitsreached =1;
                gft_Flag_limitCause =3;
                break;
            }

            /* compute linear gain and add to running sum of squares
            Here we add the sum square as the fine gain which it would be if added and subtract the
            previous entry from fine gain sum
            */

            // for the tones which would get loaded for the first time
            if (psa_RxBat[s_ToneToAddTo] == 0)
                s_FineGainToConsider = gs_min_fine_gain;
            else
                s_FineGainToConsider = psa_RxFineGains[s_ToneToAddTo];

            if (psa_RxBat[s_ToneToAddTo] == 0)
            {
                UpdateFineGainLinSumSq(psa_RxFineGains[s_ToneToAddTo], (int16)(s_FineGainToConsider + s_AdditionalSNRNeeded), gusa_DS_Tssi_Value[s_ToneToAddTo], &l_SumFGainLinSq_toconsider, &l_SumGiSqTssiSqToConsider, 2);
                s_ncloaded++;
            }
            else
                UpdateFineGainLinSumSq(s_FineGainToConsider, (int16)(s_FineGainToConsider + s_AdditionalSNRNeeded), gusa_DS_Tssi_Value[s_ToneToAddTo], &l_SumFGainLinSq_toconsider, &l_SumGiSqTssiSqToConsider, 0);

            // l_sumFgainLinSq is in 6.18;
            // Check that Sum (gi ^2) < ncloaded; if so add  fine gain to thetone; else don't
            // add the fine gain ( rms fine gain should be < 0 )
            s_FineGainToConsider = DecimalGain((int16)(2*gs_fgain_adjust));

            MULS16(l_MaxSumFGainLinSq , s_FineGainToConsider ,(s_ncloaded + gus_ncloaded_LP1));
            l_MaxSumFGainLinSq = l_MaxSumFGainLinSq<< 5;

            if( ( (gft_EnableNomATP) && (l_SumFGainLinSq_toconsider < l_MaxSumFGainLinSq) &&
                ( l_SumGiSqTssiSqToConsider < gl_MaxSumGiSqTssiSqLin)) ||
                ((!gft_EnableNomATP) && (l_SumFGainLinSq_toconsider < l_MaxSumFGainLinSq)) )
            {

                // Increase fine gain and bitloading
                if (!s_Flag_NoBatCh)
                  psa_RxBat[s_ToneToAddTo] += s_StepUp;
                s_ExtraBits += s_StepUp ;

                // If we're loading this tone for the first time, initially set fine gain to min.
                if (psa_RxBat[s_ToneToAddTo] == s_StepUp)
                {
                  psa_RxFineGains[s_ToneToAddTo] = gs_min_fine_gain;
                }

                psa_RxFineGains[s_ToneToAddTo] +=  s_AdditionalSNRNeeded;

                // if Trellis is on, be conservative here, assuming that in the end we may land with
                // odd 1 bit tones; and the fine gain on that tone may be -2.5dB
                // adjust that by taking care of Sum(gi^2); by adding gi_min ^2;

                if ((gft_TcmFlag_bis_DS) )
                {
                   s_FineGainToConsider = (DecimalGain(gs_min_fine_gain) + (int16)(1<<3)) >> 4;
                   MULS16(l_temp,s_FineGainToConsider, s_FineGainToConsider);

                   if (((l_SumFGainLinSq_toconsider + l_temp )< l_MaxSumFGainLinSq ) && (!gft_extrafinegainallocated))
                   {
                     l_SumFGainLinSq_toconsider += l_temp;
                     // set the flag to indicate that extra fine gain has been added
                     gft_extrafinegainallocated = 1;
                   }
                }

                // update gl_sumFgainLinSq
                *pl_SumFGainLinSq = l_SumFGainLinSq_toconsider;
                *pl_SumGiSqTssiSq = l_SumGiSqTssiSqToConsider;

                //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
                //Disabling marking of bitswap tones as it is used for marking tones which have margin
                //between min margin and min margin + delta
                //Marking of tones with bit swap is moved to the end of bitswap scheme
                if (TESTArray[Test_DisableBitSwapImprvmnt] || !((STATArray[STAT_MacroState] == STAT_ShowTimeState) ||
                   (STATArray[STAT_MacroState] == STAT_ShowTimeTCSyncState)) ||
                   ((gs_OlrReq == L2_REQ) || (gs_OlrReq == SRA_REQ)))
                {
                   SETTONEFLAG(guca_RxBitswapTones, s_ToneToAddTo);
                }

             }
             else
             {
                s_flag_rms_increase =1;

                if (l_SumFGainLinSq_toconsider > (l_MaxSumFGainLinSq) )
                  gft_Flag_limitCause =1;
                if (l_SumGiSqTssiSqToConsider > gl_MaxSumGiSqTssiSqLin)
                  gft_Flag_limitCause =2;
                  // rms fine gain would be greater than 0
                  break;
             }
        } //for(s_ch

        if ((s_flag_rms_increase ==1) || ( s_reqdbitsreached== 1))
           break;

        s_threshold = s_threshold + 20;
   }//while (s_threshold

   return((int16)s_ExtraBits);
}
