/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   CombSnrCalc_bis.c
*
*-------------------------------------------------------------------------
*/
//*******************************************************************
// CombSnrCalc_bis.c
//
// History
//
// 16/04/10 Nihar: VINAX-CO uses tones for the PAR reduction which are a multiple of 16
//                  If the CPE by accident chooses a pilot tone which is used in showtime
//                  for PAR reduction the PLL drifts aways and the CPE looses sync.
//                  To avoid this situation some of the potential pilot tone indexes are
//                  taken out of the supported set
//                  DMT-mode:       tone: 224
//                  BIS-/PLUS-mode: tone: 224, 368
//                  Grep for IOP_DS_ALL_IFTN_VINAX_NO_PILOT_ON_PAR_TONE
//
//*****************************************************************************

#include "common.h"
#include "const_bis.h"
#include "tx_ops2.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "typedef.h"
#include "snr.h"
#include "BGChooseRevSegBin.h"
#include "dsp_op.h"
#include "noiseacc.h"
#include "pll.h"
#include "ghs.h"
#include "bitload_const.h"
#include "cmv.h"
#include "pll.h"
#include "hndshk_Data.h"

int16 SnrCalcPSDBased(int32 *pla_NoisePower, int16 *psa_Signal, int16 s_ToneIdxNoise, int16 s_ToneIdxSignal)
{
   int32 l_Acc, l_Acc1, l_temp, l_temp_r, l_temp_i;


   /* If pla_NoisePower[s_ToneIdxNoise] == 0, set pla_NoisePower[s_ToneIdxNoise]=1  to avoid overestimated snr*/
   if(pla_NoisePower[s_ToneIdxNoise] == 0)
   {
      pla_NoisePower[s_ToneIdxNoise] =1;
   }

   {

      /* ================================================================================ */
      /* compute 10*log10(pla_NoisePower[i]), in Q24.8 format */
      /* ================================================================================ */
      l_Acc = (int32)ConvertToDB(pla_NoisePower[s_ToneIdxNoise]);

      /* ================================================================================ */
      /* Load signal_dB = 10*log10(sig^2) */
      /* and represent it in Q24.8 format */
      /* ================================================================================ */
      l_temp_r = (int32)psa_Signal[2*s_ToneIdxSignal];
      l_temp_r >>=1;
      l_temp_r = l_temp_r*l_temp_r;

      l_temp_i = (int32)psa_Signal[2*s_ToneIdxSignal+1];
      l_temp_i >>=1;
      l_temp_i = l_temp_i*l_temp_i;

      l_temp = l_temp_r + l_temp_i;

      l_Acc1 = (int32)ConvertToDB(l_temp);

      /* ================================================================================ */
      /* Compute SNR = signal_dB - noise_dB in Q24.8 format */
      /* ================================================================================ */
      l_Acc = l_Acc1 - l_Acc ;
   }

   /* Saturate the result and represent SNR in Q8.8 format */
   return(sature16(l_Acc));
}

void BGComb2SnrCalc_bis(void)
{
   int32 *pla_NoisePower;
   int i, j, s_tone_index;
   //int16 idx[4]={47, 64, 83, 95}; //nearest neighbor tones of the pilot candidates
   //int16 pilot[4]={48, 64, 80, 96}; //candidates

    int16 s_temp;
   int16 s_snrbuf[NUM_OF_BINS_FOR_COMB_DETECTION];
   int16 s_thr_comb;

   /* convert 48 bits accumulated value to 32 bits; */
   /* shift is 2 extra to match NoiseAcc() */
#ifdef NOISEACC_COMB2
   pla_NoisePower = gla_AccumBufComb; // Overwrite input buffer with 32-bit output.
   // Note that a special version of RoundNoiseAccum2() is used.  Probably the need for this could be eliminated.
   RoundNoiseAccum2(gla_AccumBufComb, pla_NoisePower, 0, (int16)(C_COMB_INDEX_CNT_G992_5+20-1), (int16) (LOG2_NUM_SNR_TRAINING_SYMBOLS_TEST));
#else

   pla_NoisePower = gla_RxAccumBuf; // Overwrite input buffer with 32-bit output.
   // Note that a special version of RoundNoiseAccum2() is used.  Probably the need for this could be eliminated.
   RoundNoiseAccum2(gla_RxAccumBuf, pla_NoisePower, 0, (int16)(gs_RxNumTones-1), (int16) (LOG2_NUM_SNR_TRAINING_SYMBOLS_TEST));

#endif // NOISEACC_COMB2

    /* Clear these two arrays */
   for(i=0; i<NUM_OF_BINS_FOR_COMB_DETECTION; i++)
   {
      s_snrbuf[i] = 0;
   gsa_COMB_ICOMB_DetectionBins[i] = gsa_C_COMB_index[gs_C_COMB_FIRSTCHAN_IDX + NUM_OF_BINS_FOR_COMB_DETECTION -1 - i];
   }

    /* Compute Comb snrs at tones 35, 47, 59, 64, 71, 83, 95, 107 and 119 */
   /* The top NUM_OF_BINS_FOR_COMB_DETECTION(5) tones will be used to */
       /* detect COMB/ICOMB signal */

   for(i = gs_C_COMB_FIRSTCHAN_IDX; i <= gs_C_COMB_LASTCHAN_IDX; i++)
   {
       s_tone_index = gsa_C_COMB_index[i];

#ifdef NOISEACC_COMB2
      gsa_ReverbSnrBuf[s_tone_index] = SnrCalcPSDBased(pla_NoisePower, gsa_Comb2SignalBuf, i, (int16)s_tone_index);
#else
      gsa_ReverbSnrBuf[s_tone_index] = SnrCalcPSDBased(pla_NoisePower, gsa_Comb2SignalBuf, (int16)s_tone_index, (int16)s_tone_index);
#endif // NOISEACC_COMB2

      if(gsa_ReverbSnrBuf[s_tone_index] > s_snrbuf[0])
      {
           s_snrbuf[0] = gsa_ReverbSnrBuf[s_tone_index];
           gsa_COMB_ICOMB_DetectionBins[0] = s_tone_index;

         /* Sort the s_snrbuf[] in ascending order and adjust gsa_COMB_ICOMB_DetectionBins[] accordingly  */
      for(j=0; j<(NUM_OF_BINS_FOR_COMB_DETECTION-1); j++)
      {
         if(s_snrbuf[j]>s_snrbuf[j+1])
         {
                s_temp = s_snrbuf[j];
            s_snrbuf[j] = s_snrbuf[j+1];
            s_snrbuf[j+1] = s_temp;

                s_temp = (int16)gsa_COMB_ICOMB_DetectionBins[j];
            gsa_COMB_ICOMB_DetectionBins[j] = gsa_COMB_ICOMB_DetectionBins[j+1];
            gsa_COMB_ICOMB_DetectionBins[j+1] = s_temp;
         }
      }

      }  /* End of if(gsa_ReverbSnrBuf[s_tone_index] > s_snrbuf[0])  */

   }  /* End of for(i = gs_C_COMB_FIRSTCHAN_IDX; i <= gs_C_COMB_LASTCHAN_IDX; i++) */

    /* Get the number of qualified tones whose COMB SNRs are higher than the threshold */
      for(j=0; j<(NUM_OF_BINS_FOR_COMB_DETECTION); j++)
      {
         gsa_COMB_ICOMB_DetectionBins_BTLL[j] = gsa_COMB_ICOMB_DetectionBins[j];
      }
      s_thr_comb = THRESHOLD_FOR_QUALIFIED_COMBTONES;

#ifndef ISDN
      if((gt_INFX_CMV.us_OperatorSpBits7 & CMV_COMBDETECT_Bins_Fix)
         ||(gft_CNXT_A_LongLoops == TRUE)
         )
      {
         s_thr_comb = 0x0600;
      }
#endif

   guc_NUM_OF_BINS_FOR_COMB_DETECTION_BTLL = 0;
   guc_NUM_OF_BINS_FOR_COMB_DETECTION=0;
   for(i =0; i <NUM_OF_BINS_FOR_COMB_DETECTION; i++)
   {
      if(gsa_ReverbSnrBuf[gsa_COMB_ICOMB_DetectionBins[i]] >  THRESHOLD_FOR_QUALIFIED_COMBTONES)
         gsa_COMB_ICOMB_DetectionBins[guc_NUM_OF_BINS_FOR_COMB_DETECTION++] = gsa_COMB_ICOMB_DetectionBins[i];

      if(gsa_ReverbSnrBuf[gsa_COMB_ICOMB_DetectionBins_BTLL[i]] >  s_thr_comb)
         gsa_COMB_ICOMB_DetectionBins_BTLL[guc_NUM_OF_BINS_FOR_COMB_DETECTION_BTLL++] = gsa_COMB_ICOMB_DetectionBins_BTLL[i];
   }  /* End of for(i =0; i <NUM_OF_BINS_FOR_COMB_DETECTION; i++) */

#ifndef ISDN
         if((gt_INFX_CMV.us_OperatorSpBits7 & CMV_COMBDETECT_Bins_Fix)
            ||(gft_CNXT_A_LongLoops == TRUE)
            )
         {
            if(guc_NUM_OF_BINS_FOR_COMB_DETECTION == 3 )
               guc_NUM_OF_BINS_FOR_COMB_DETECTION = 2;
         }
#endif
   if(guc_NUM_OF_BINS_FOR_COMB_DETECTION ==0)
   {
      guc_NUM_OF_BINS_FOR_COMB_DETECTION++;
   gsa_COMB_ICOMB_DetectionBins[0] = gsa_COMB_ICOMB_DetectionBins[NUM_OF_BINS_FOR_COMB_DETECTION-1];
   }
   if(guc_NUM_OF_BINS_FOR_COMB_DETECTION_BTLL ==0)
   {
      guc_NUM_OF_BINS_FOR_COMB_DETECTION_BTLL++;
      gsa_COMB_ICOMB_DetectionBins_BTLL[0] = gsa_COMB_ICOMB_DetectionBins_BTLL[NUM_OF_BINS_FOR_COMB_DETECTION-1];
   }
   //XDSLRTFW-2033 (end)
   guc_SnrCalcState = TRAINING_DONE;
}

/******************************************************************************
The following function selects the best tone for pilot use. The criteria
metric is 20*log10(k) + SNR(k), where k is the tone index. The candidate
tones are 48, 64, 80, and 96 which are all multiples of 16. However, since
the COMB2 signal does not have all of these four tones, we approximate the
SNRs for these tones as the same as the nearest neighbor tone that included
in COMB2, which are 47, 64, 83 and 95 respectively.
******************************************************************************/
extern int16 gs_tssi_threshold;  /* value 30*512=0x3C00 corresponds to a log_tssi of 30 dB in Q7.9 format */

void BGChoosePilot(void)
{
   int32 *pla_NoisePower;
   int i, s_tone_index,s_tone_index_signal;
   int32 l_metric, l_max_metric;
   int16 s_numOf_tref1_candidates;
#ifdef NOISEACC_COMB2
   int16  s_tone_index_noise;
#endif
   /* populated manually by looking @ the closest physical Comb tone */
   /* to each of the tref candidates in gsa_tref1_candidates array      */
   int sa_NearestCombTone[20] = {
      47,   64,  83,  95,  107, 143, 179, 203, 227, 251,
      275, 299, 323, 347, 371, 395, 419, 443, 467, 491
   };

   ////////////////////
   // Pick  pilot tones
   ////////////////////
#ifdef NOISEACC_COMB2
   pla_NoisePower = gla_AccumBufComb;
#else
   pla_NoisePower = gla_RxAccumBuf;
#endif //NOISEACC_COMB2
   l_max_metric = -100*256;

   /* Compute Comb snrs at tones s_comb_test */
   gs_ChosenPilot_CD = sa_NearestCombTone[0];  //tone 47

   gs_CPilotTone    = gsa_tref1_candidates[0]; //tone 48
   s_numOf_tref1_candidates = 20;
   //XDSLRTFW-2033 (start)
#ifndef ISDN
   if((gt_INFX_CMV.us_OperatorSpBits7 & CMV_COMB2_PILOT_Fix)
      ||(gft_CNXT_A_LongLoops == TRUE)
      )
   {
      s_numOf_tref1_candidates = 2;
   }
#endif
   //XDSLRTFW-2033 (end)
   for(i = 0; i < s_numOf_tref1_candidates; i++)
   {
      s_tone_index = gsa_tref1_candidates[i];
      s_tone_index_signal = sa_NearestCombTone[i];
      // IOP_DS_ALL_IFTN_VINAX_NO_PILOT_ON_PAR_TONE (START)
      if (gs_MaxAuxPilotToneIdx == 208)
      {
         if ((s_tone_index==224) || (s_tone_index==368))
            continue;
      }
      // IOP_DS_ALL_IFTN_VINAX_NO_PILOT_ON_PAR_TONE (END)

#ifdef NOISEACC_COMB2
      s_tone_index_noise = i + C_COMB_INDEX_CNT_G992_5  ; // tone index for which gla_AccumBufComb computed
#endif //NOISEACC_COMB2

      /* Consider only tones in the medley set */
      if (!IS_TONEFLAGSET(p_MEDLEYset_DS, s_tone_index))
         continue;

      /* We cannot interop against Geminax with pilot tone index 256; while we do   */
      /* interop with Alcatel/BRCM with 256 as pilot tone index. Until we know more*/
      /* on this problem, patch code to avoid choosing 256 as pilot tone         */
      /* */
      /* In Alcatel/BRCM ham band profile, it seems that CO doesn't apply DS Tssi on*/
      /* C_COMB tones as it specified in the hamd band. Therefore, it is likely that*/
      /* the pilot tone is chosen in the band and causes problem. The workaround is */
      /* to check Tssi value during our pilot tone selection.*/
      if ((s_tone_index == 256) || (gusa_DS_Tssi_Value[s_tone_index] > gs_tssi_threshold))
         continue;

      /* Extra 8 tones while comparing for gs_RxFirstChannel is to avoid a pilot buried in echo */
      /* For ex: When we run in AnnexB, AnnexM modes we have US signal in the band of tones 32-63     */
      /* This causes tone 64 to be buried in echo during dec training when we send  training sequence.   */
      if (s_tone_index <= (gs_RxFirstChannel + 8) || s_tone_index > gs_RxLastChannel)
         continue;

#ifdef NOISEACC_COMB2

      gsa_ReverbSnrBuf[s_tone_index] = SnrCalcPSDBased(pla_NoisePower, gsa_Comb2SignalBuf, (int16)s_tone_index_noise, (int16)s_tone_index_signal);
#else
      gsa_ReverbSnrBuf[s_tone_index] = SnrCalcPSDBased(pla_NoisePower, gsa_Comb2SignalBuf, (int16)s_tone_index, (int16)s_tone_index_signal);
#endif //NOISEACC_COMB2

      /* Compute metric 20log10(k) + snr(k) */
      /* Compute 20*log10(k) */
      l_metric = ((int32) ConvertToDB((int32)(s_tone_index))) << 1;
      /* Add in snr(k) */
      l_metric += (int32)(gsa_ReverbSnrBuf[s_tone_index]);

      if (l_metric > l_max_metric)
      {
         l_max_metric = l_metric;
         gs_ChosenPilot_CD = s_tone_index_signal;
         gs_CPilotTone    = s_tone_index;
      }
   } // end of for(i = 0; i < 20; i++)


   if (gs_dbgChoosePilotCD != -1)
   {
      gs_ChosenPilot_CD = gs_dbgChoosePilotCD;
   }

   if (gs_dbgChoosePilot != -1)
   {
      gs_CPilotTone = gs_dbgChoosePilot;
   }


   // To lessen clutter in code, we populate both gs_CPilotTone and gs_AuxPilotToneIdx
   gs_AuxPilotToneIdx = gs_CPilotTone;
   if (gft_AuxPilot == AUX_PILOT_ENABLE)
   {
      gft_AuxPilot = AUX_PILOT_ACTIVE;
   }

   /* Calculate the scaling value for Ki and Kp */
   PllScalingCalc(gs_ChosenPilot_CD, &gs_PllScaling_bis_CD);
   PllScalingCalc(gs_CPilotTone, &gs_PllScaling);

    guc_AccumState = TRAINING_DONE ;
}
