/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   CompFramingConstraints.c
*
*-------------------------------------------------------------------------
*/

// ************************************************************************
// CompFramingConstraints.c
// History
//
// 07/02/2012 Shakil: Erasaure decoding feature was turned off by default which introduced CRCs in
//          the REIN test from Telefonica Spain in ADSL 2plus profile. As a sollution we enabled
//          erasure decoding feature and also make some small modification in the logic to easily
//          understand the code.
//          Grep for XDSLRTFW-399 ENH_DS_BisPlus_All_Enable_ErasureDecoding
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Modified enable/disable of Erasuredecoder logic as per VRx Msg Spec through "CMV DSL 1 0"
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 08/04/2013 ChihWen /Balabath:
//            Optimize the code for SRA, which are mainly as below.
//            1. Modify gs_MaxRateLp/gs_MinRateLp to be the max/min Lp complying to all framing constraints(including max/min net rate) when framing check is enabled(INFO 103 26 bitmask(0x400)),
//               gs_MaxRateLp/gs_MinRateLp will be the Lp with max/min net rate when framing check is not enabled.
//                2. Combine the framing check in "isValidFramingConfiguration" and "RShowtimeRxF_BIS". The combined framing check will refer to gs_MaxRateLp/gs_MinRateLp.
//                3. Optimize the CMV setting related to SRA.
//                4. Add two CMV to enable/disable the checking for min INP, and max delay when searching delta Lp in training.
//            Grep for XDSLRTFW-721 Enhance_DS_BisPlus_ALL_OptimizedSRACode
// 06/11/2013 Balabath :XDSLRTFW-1313 XDSLRTFW-1208In TR105E testsuite SRA functional tests were failing.
// The problems are
// 1) Expected Result SRA_reported_margin_downshift_ds >= RA-DSNRM is not meeting
// Description: This is due to the Min message based overhead data rate requirement.
// As per the profile configured, MinDSOverheadRate is 6kbps, after framing params
// Message based Ovhd rate is 6.3 kbps only. This restricts Downshift SRA.
// Solution: Modift framing params calculation to come up with more DSOverheadRate
// for SRA profiles.
// 2) Upshift SRA triggered before reaching RA-USNRM.
// Description: These are because of the fixes added to reach target margin after
// downshift or upshift. But there are multiple bugs with this portion of code.
// 2.a)Upshift SRA triggered before reaching RA-USNRM
// 2.b)Not honouring RA-DTIMEus.
// 2.c)Not honouring RA-DTIMEds etc..
// 2.d) SRA triggers when BER test is undergoing.
// Solutions:Total algorithm needs to be modified. Changes include
// 2.a)Fix for Upshift SRA triggered before reaching RA-USNRM.
// 2.b)Consider parameter RA-DTIMEus.
// 2.c)Consider parameter RA-DTIMEds.
// 2.d)Reaching Target Margin moved under CMV control.
// CMV INFO 103 28 1(bitmask 0x1). By default this is disabled.
// (This will be enabled based on the customer requirement.)
// And if multiple SRAs are required to reach target margin,
// They will be issued within settling time (30s) and the process will be stopped
// after settling time. Otherwise SRA triggers are going to happen when BER process starts.
// 3) Other changes include introduction of new CMV bits.
// 3.a) CMV control for enable/disable framing constraint minoverhead rate conveyed in GHS.
// CMV INFO 103 28 2(bitmask # 0x0002 [CMV_SRA_TO_ENABLE_MINOVERHEAD_GHS_CHECK]).
// By default this is enabled.
// 3.b) CMV control for enable/disable framing constraint Maxdelay conveyed in GHS.
// CMV INFO 103 28 4(bitmask # 0x0004 [CMV_TO_ENABLE_SRA_MAXLATENCY_CHECK]).
// By default this is enabled.
// Note: For CNXT DSLAM this CMV will disabled internally in the code. With
// CNXT DSLAMs, OneOverS is limited to 3. This will have impact on delay constraint and NDR.
// Tests show that voilation of delay constraint works fine with CNXT based DSLAMs.
// To find code changes grep for
// XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges
// Downshift process and Upshift process introduced to reach close to target_margin +- 0.5dB
// There were some problems with FLEXIT2 TR-105 SRA cases
// FLEXIT stops if DnShift+UpShift is triggered during "gft_SRADnShift_process"
// So make sure only DnShifts will be allowed here during Downshift process.
// Grep for XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges to see code changes
//
//
// ****************************************************************************************************************************************

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "typedef.h"
#include "gdata_bis.h"
#include "bitload_bis.h"
#include "gdata.h"
#include "bitload2.h"
#include "bitload.h"
#include "bitload_const.h"
#include "compiler.h"
#include "cmv.h"
#include "cmv_data.h"
#include "const.h"
#include "statein1.h"
#include "states.h"
#include "changebat.h"
#include "pll.h"
#include "mul.h"

extern int16 BinarySearch(FlagT ft_FindMax, uint32 ul_Cnstrnt1, uint32 ul_Cnstrnt2, int16 s_check1, int16 s_check2,
               int16 s_start, int16 s_end, int16 s_default);


/****************************************************************************
 *  void ComputeFramingConstraints(int16 s_latency, FlagT ft_isDownstream)
 *
 *  Function Description:
 *        Assume Bpn is unchanged, compute the Lmax and Lmin for OLR/PM
 *
 *1a. ADSL2: 1/2 <= Sp <= 64  (bound on number of FEC codewords per symbol)
 *           Mp/2<= Sp <= 32*Mp
 *   ADSL2+: 1/3 <= Sp <= 64
 *           Mp/3<= Sp <= 32*Mp
 *
 *1b. Extended Framing: 1/16 <= 1/s_OneOverSminADSL2 <= Sp <= MIN(64, 32*Mp)
 *
 *2. Nominal one way maximum transport delay
 *    Latency = Sp * Dp /4  ms
 *
 *3. Overhead Rate = Mp * Lp *4 / (Tp * CWSize) = 32*Mp/(Tp*Sp) kb/s
 *          0.8kbps <= OH_Rate <= 64kbps
 *
 *4. Period of the overhead channel
 *    PERp = Tp Sp SEQp / (4 Mp)
 *       15ms <= PERp <= 20ms
 *
 *5. Impulse Noise Protection
 *     INP = (1/2) (Sp Dp) (Rp /CWSize) = 4*Rp*Dp/Lp  ==> Lpmin>=4*Rp*Dp/INP
 *
 *6. Number of PMD bits over which FEC data spans
 *    Sp = 8  CWSize / Lp
 *
 ******************************************************************************/
extern int16 gs_OneOverSminADSL2; // Saves 1/S value being used for bitloading
extern int16 gs_INP;  // defined as 2 * MinINP
C_SCOPE void ComputeFramingConstraints(int16 s_latency, FlagT ft_isDownstream, Config_t* t_config, int16 s_MaxNumTones, uint8* puca_BCnToLPp, int16 s_SEQp, DerivedFramePropLatencyPath_t* t_DerivedFrameProperties)
{

   int16 s_L, s_L_L2, s_L_SRA, s_Limit, s_bc;
   //int16 s_temp;
   FlagT ft_LatencyLimit = TRUE;
   int16 s_Kp, s_latency_path, sa_Bpn, s_codewordsize, s_Mp, s_log2Mp, s_Tp, s_Rp, s_Dp;
   uint16 us_max_latency;
   int16 *psa_MaxLatencyBC = NULL, s_minOverheadRate, s_minINP, s_OneOverSminADSL2;
   int16 s_LmaxBpn, s_BpMax, s_BpMin;
   uint32 ul_BpmaxCnstrnt1, ul_BpmaxCnstrnt2, ul_BpminCnstrnt1;
   uint32 ul_KpmaxCnstrnt1, l_temp;
   uint32 ul_TpCWSize;
   int16 s_MaxNetDataRateBC, s_MinNetDataRateBC, s_MaxDataRateLP;  //assume only one bearer channel will map to one latency path
   int16 s_L_orig, s_index_Lmax, s_index_Lmin;
#define MAX_NUM_LP_CONSTRAINTS 7
   int16 sa_Lmin[MAX_NUM_LP_CONSTRAINTS];
   int16 sa_Lmax[MAX_NUM_LP_CONSTRAINTS];
   uint32 ula_LCnstrnt1[MAX_NUM_LP_CONSTRAINTS];
   uint32 ula_LCnstrnt2[MAX_NUM_LP_CONSTRAINTS];
#undef MAX_NUM_LP_CONSTRAINTS
   int32 i, l_save;

   // since this function checks both US and DS, we should seperately set variables for the two scenario
   if(ft_isDownstream)
   {
      psa_MaxLatencyBC = gt_HandshakeBis.sa_DS_MaxLatencyBC;
      s_minOverheadRate = gt_HandshakeBis.s_MinMSGDSOverheadRate;
      s_OneOverSminADSL2 = gs_OneOverSminADSL2;
      s_minINP = gs_INP;
      if(gft_ErasureGainForRate == TRUE)
      {
         s_minINP = gs_INP_erasure;// here INP is considered in 0.1 steps,so take proper conversion for constraints.
      }

      s_MaxDataRateLP = gt_HandshakeBis.sa_DS_MaxDataRateLP[s_latency];
      s_index_Lmax = 3;
      s_index_Lmin = 7;

   }
   else
   {
      // DS only for now -- handshake does not provide this information for upstream yet
      //psa_DS_MaxLatencyBC = gt_HandshakeBis.sa_US_MaxLatencyBC;
      //psa_MaxLatencyBC = 0xFFFF;
      s_minOverheadRate = 0;
      if (STATArray[STAT_Mode] & STAT_ConfigMode_G992_3_ALL)
         s_OneOverSminADSL2 = 2;
      else
         s_OneOverSminADSL2 = 3;
      s_minINP = 0;
      s_MaxDataRateLP = 0;
      s_index_Lmax = 2;
      s_index_Lmin = 2;
   }

   //get the latency of the latency path from the bearer channels that mapped to that latency path
   us_max_latency = 0xFFFF;
   s_MaxNetDataRateBC = 0;
   s_MinNetDataRateBC = 0;
   sa_Bpn = 0;
   for(s_bc = 0; s_bc < t_config->s_Nbc; s_bc++)
   {
      s_latency_path = puca_BCnToLPp[s_bc];
      if (s_latency_path == s_latency)
      {
         // DS only for now -- handshake does not provide this information for upstream yet
         if (ft_isDownstream)
         {
            s_MaxNetDataRateBC = gt_HandshakeBis.sa_DS_MaxNetDataRateBC[s_bc];
            s_MinNetDataRateBC = gt_HandshakeBis.sa_DS_MinNetDataRateBC[s_bc];

            if (us_max_latency > psa_MaxLatencyBC[s_bc])
               us_max_latency = psa_MaxLatencyBC[s_bc];
         }
         sa_Bpn += t_config->sa_Bpn[s_latency_path][s_bc];  /* Bpn */

      }
   }

   s_Kp = sa_Bpn + 1;
   s_Mp = t_config->s_Mp[s_latency];
   s_Tp = t_config->s_Tp[s_latency];
   s_Rp = t_config->s_Rp[s_latency];
   s_Dp = t_config->s_Dp[s_latency];

   //codeword size
   //s_codewordsize = (s_Kp+1) * t_config->s_Mp[s_latency] + t_config->s_Rp[s_latency];
   MULU16(l_temp, s_Kp, s_Mp);
   s_codewordsize = (int16)l_temp + s_Rp;

   //ul_TpCWSize = (t_config->s_Tp[s_latency] * s_codewordsize)
   MULU16(ul_TpCWSize, s_Tp, s_codewordsize);

   // determine log Mp
   s_log2Mp = 0;
   l_temp = s_Mp >> 1;
   while (l_temp >0)
   {
      s_log2Mp++;
      l_temp = l_temp >> 1;
   }

   /******************************************************************************************************
   *LmaxConstraints: (For No Bpn Change)
   *1:  Sp = 8*CWSize/Lp >= (Mp/S_OneOverSminADSL2) ==>                         8*CWSize*S_OneOverSminADSL2 >= Mp*Lp
   *2:  OvhdRate = 32*Mp/(Tp*Sp) <= 64kbps ==> Sp = 8*CWSize/Lp >= Mp/(2*Tp) ==>16*CWSize*Tp >= Mp*Lp
   *3. Bearer Channel Net Data Rate: BC (or lowest index)
   *   (Tp(Bp+1)-1)MpLp/(Tp CWSize) <= max_BC_datarate     ==>Tp CWSize max_BC_datarate >= (Tp(Bp+1)-1)MpLp
   *4. Latency Path Net Data Rate: Lp0
   *   (TpKp-1)MpLp/(TpCWSize) <= max_latency_path_datarate  ==>Tp CWSize max_latency_path_datarate >= (TpKp-1)MpLp
    *5:  PERp = Tp*Sp*SEQp/(4*Mp) >= 15/8ms(1.875ms) ==>Sp = 8*CWSize/Lp >= 60*Mp/(Tp*SEQp) ==>
   *                                                                            16*CWSize*Tp*SEQp >= 15*Mp*Lp
   *6. INPp = 4*Rp*Dp/Lp >= INPmin  ==>                                         4*Rp*Dp >= INPmin*Lp
   *
   *Therefore: the idea is to dry run the equation to find out the maximum Lp that can still hold
   *LmaxCnstrnt1[n] >= LmaxCnstrnt2[n] * Lp, n=0, 1, 2, 3. And find out the minimum value of the several Lp max.
     *
   *LmaxCnstrnt1[0] = 8*CWSize*S_OneOverSminADSL2;
   *LmaxCnstrnt1[1] = 16*CWSize*Tp;
   *LmaxCnstrnt1[2] = Tp CWSize max_BC0_datarate
   *LmaxCnstrnt1[3] = Tp CWSize max_latency_path_datarate
   *LmaxCnstrnt1[4] = 16*CWSize*Tp*SEQp;
   *LmaxCnstrnt1[5] = 4*Rp*Dp;
   *
   *LmaxCnstrnt2[0] = LmaxCnstrnt2[1] = Mp
   *LmaxCnstrnt2[2] = (Tp(Bp+1)-1)Mp;
   *LmaxCnstrnt2[3] = (TpKp-1)Mp;
   *LmaxCnstrnt2[4] = 15*Mp
   *LmaxCnstrnt2[5] = INPmin
   ******************************************************************************************************/
   MULU16(ula_LCnstrnt1[0], s_OneOverSminADSL2 << 3, s_codewordsize);
   ula_LCnstrnt1[1] = ul_TpCWSize <<4;
   MULS32x16(ula_LCnstrnt1[2], ul_TpCWSize, s_MaxNetDataRateBC);
   MULS32x16(ula_LCnstrnt1[3], ul_TpCWSize, s_MaxDataRateLP);
   MULS32x16(ula_LCnstrnt1[4], ula_LCnstrnt1[1], s_SEQp);

   if(gft_ErasureGainForRate == TRUE)
   {
      MULU16(s_Rp, s_Rp, 5); // INP in 0.1 steps,
   }
// XDSLRTFW-399 ENH_DS_BisPlus_All_Enable_ErasureDecoding (Start)
#if 0//def VR9_ERASURE
 //Bit0 mask to enable erasure and Bit1 mask to enable INP boost over DataRate
   //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)

   if ( (gt_ErasureDecoding_Reprt.ft_Report_ED == TRUE) &&
         (gt_ErasureDecoding_Reprt.ft_INP_no_erasure_not_reqd == TRUE) &&
         ((gs_DSL_EDcontrol & ERASURE_MAX_INP) == 0) &&
         (gs_DSL_EDcontrol & ERASURE_DECODING_ENABLE == ERASURE_DECODING_ENABLE)
        )
    {
        MULU16(ula_LCnstrnt1[5], s_Rp<<4, s_Dp);
    }
    else
#endif //#ifdef VR9_ERASURE
// XDSLRTFW-399 ENH_DS_BisPlus_All_Enable_ErasureDecoding (End)
    {
        MULU16(ula_LCnstrnt1[5], s_Rp<<3, s_Dp);
    }

   ula_LCnstrnt2[0] = ula_LCnstrnt2[1] = s_Mp;
   MULU16(ula_LCnstrnt2[2], s_Tp, (sa_Bpn+1));
   ula_LCnstrnt2[2] = (ula_LCnstrnt2[2]-1) << s_log2Mp;
   MULU16(ula_LCnstrnt2[3], s_Tp, s_Kp);
   ula_LCnstrnt2[3] = (ula_LCnstrnt2[3] - 1) << s_log2Mp;
   MULU16(ula_LCnstrnt2[4], 15, s_Mp);
   ula_LCnstrnt2[5] = s_minINP;

   l_save = ula_LCnstrnt2[2];

    //find out the exact Lmax value for each Constraint
   s_Limit = 15 * (s_MaxNumTones -1);
   s_L = s_Limit;
   s_L_orig = t_config->s_Lp[s_latency];

   for (i = 0; i < s_index_Lmax; i++)
   {
      //do binary search for the max Lp that still holds LmaxCnstrnt1[n] >= LmaxCnstrnt2[n] * Lp
      sa_Lmax[i] = BinarySearch(TRUE, ula_LCnstrnt1[i], ula_LCnstrnt2[i], s_L_orig, s_Limit, s_L_orig, s_Limit, s_Limit);

      //find the minimum of all the Lmax
      if (s_L > sa_Lmax[i])
      {
         s_L = sa_Lmax[i];
         t_DerivedFrameProperties->s_OLR_LMaxNoBpn_Cnstrnt = i+1;
      }
   }
    //XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges (start_end)
   // take inp requirement into account when calculating maximum Lp
    if ((ft_isDownstream)&&(gt_INFX_CMV.us_SRA_IOP_Bits & CMV_SRA_INP_FRAMING_CHECK))
    {
        sa_Lmax[5] = BinarySearch(TRUE, ula_LCnstrnt1[5], ula_LCnstrnt2[5], s_L_orig, s_Limit, s_L_orig, s_Limit, s_Limit);

        if (s_L > sa_Lmax[5])
        {
         s_L = sa_Lmax[5];
         t_DerivedFrameProperties->s_OLR_LMaxNoBpn_Cnstrnt = 6;
         }
      }
   t_DerivedFrameProperties->s_OLR_LMaxNoBpn = s_L;
   t_DerivedFrameProperties->s_L2_LMax = s_L;
   t_DerivedFrameProperties->s_OLR_LMaxBpn = 255<<3; //should consider INP, i.e, MIN(s_Limit, sa_Lmax[5])
   t_DerivedFrameProperties->s_OLR_LMaxBpn_Cnstrnt = 1;
   t_DerivedFrameProperties->s_OLR_LMinBpn = 8;
   t_DerivedFrameProperties->s_OLR_LMinBpn_Cnstrnt = 1;

   /******************************************************************************************************
   *Lmin constraints: (For No Bpn Change)
   *
   * 0: Sp=8*CWSize/Lp <= 64 <===>                    CWSize <= 8*Lp
   * 1: Sp=8*CWSize/Lp <= 32*Mp <===>                 CWSize <= 4*Mp*Lp
   * 2. OvhdRate = 4*Mp*Lp/(Tp*CWSize) >= 0.1kbps ==> Tp*CWSize <= 40*Mp*Lp
   * 3: OvhdRate*MSGc/SEQp >= MinMSGOvhd(GHS) ==>     4*Mp*Lp*MSGc/(Tp*CWSize*SEQp) >= MinMSGOvhd(GHS)
     *    ===>                                         Tp*CWSize*SEQp*MinMSGOvhd(GHS) <= 4*Mp*Lp*MSGc
   * 4. Bearer Channel Net Data Rate: BC0 (or lowest index)
   *   (Tp(Bpn+1)-1)MpLp/(Tp CWSize) >= min_BC_datarate     ==>Tp CWSize min_BC_datarate <= (Tp(Bpn+1)-1)MpLp
   *
   * 5: MaxLatency = Sp*Dp/4 <==>                     2*CWSize*Dp<= MaxLatency*Lp
   * 6: OvhdRate*MSGc/SEQp >= MinMSGOvhd(0.1kbps) ==>     40*Mp*Lp*MSGc/(Tp*CWSize*SEQp) >= 1kbps
     *    ===>                                         Tp*CWSize*SEQp <= 40*Mp*Lp*MSGc
   * 7 . PERp = Tp*Sp*SEQp/(4*Mp) <= 160ms ==>          Tp*SEQp*CWSize <= 80*Mp*Lp
   *
   * Notes:
   * 1) Since SEQp>=2, any Lp value that violates 3 will definitely violate 7, so we can drop constraint 7.
   * 2) Constraint 6 is our own threshold to ensure a sufficient MSG overhead rate in L2 so that short messages
   * such as L2 trims do not time out.
   *
   * The idea is to dry run the equation to find out the minimum Lp that can still hold
   * LminCnstrnt1[n] <= LminCnstrnt2[n] * newLp, n=0, 1,..6. And find out the maximum value of the
   * several Lp min.
   *
   *LminCnstrnt1[0] = CWSize
   *LminCnstrnt1[1] = CWSize
   *LminCnstrnt1[2] = Tp*SEQp*CWSize*MinMSGOvhd(GHS)
   *LminCnstrnt1[3] = Tp*CWSize*min_BC0_datarate
   *LminCnstrnt1[4] = Tp*CWSize
   *LminCnstrnt1[5] = 2*CWSize*Dp
   *LminCnstrnt1[6] = Tp*SEQp*CWSize
   *
   *LminCnstrnt2[0] = 8;
   *LminCnstrnt2[1] = 4*Mp;
   *LminCnstrnt2[2] = 4*Mp*MSGc
   *LminCnstrnt2[3] = (Tp(Bp+1)-1)Mp;
   *LminCnstrnt2[4] = 40*Mp;
   *LminCnstrnt2[5] = maxLatency
   *LminCnstrnt2[6] = 40*Mp*MSGc
   ******************************************************************************************************/
   ula_LCnstrnt1[0] = ula_LCnstrnt1[1] = s_codewordsize;

   MULS32x16(ula_LCnstrnt1[6], ul_TpCWSize, s_SEQp);
   MULS32x16(ula_LCnstrnt1[2], ula_LCnstrnt1[6], s_minOverheadRate);

   MULU16(ula_LCnstrnt1[3], ul_TpCWSize, s_MinNetDataRateBC);

   ula_LCnstrnt1[4] = ul_TpCWSize;

   MULU16(ula_LCnstrnt1[5], (s_Dp << 1), s_codewordsize);

   ula_LCnstrnt2[0] = 8;
   ula_LCnstrnt2[1] = s_Mp << 2;
   MULS32x16(ula_LCnstrnt2[2], ula_LCnstrnt2[1], t_config->s_MSGc);
   ula_LCnstrnt2[3] = l_save;
   MULS32x16(ula_LCnstrnt2[4], 40, s_Mp);
   ula_LCnstrnt2[5] = us_max_latency;

   MULS32x16(ula_LCnstrnt2[6], ula_LCnstrnt2[2], 10);

    //do the dry run to find out the exact Lmin value for each Constraint that still holds
   //LminCnstrnt1[n] <= LminCnstrnt2[n] * newLp
   s_L_SRA = 8;
   s_L_L2 = 8;

   for (i = 0; i < s_index_Lmin; i++)
   {

      //binary search for the biggest newLp for LminCnstrnt1[n] >= LminCnstrnt2[n] * newLp
      sa_Lmin[i] = BinarySearch(FALSE, ula_LCnstrnt1[i], ula_LCnstrnt2[i], s_L_orig, 8, 8, s_L_orig, 8);

      //find the maximum of all the Lmin[i]
      if ((i<=1) || (i==6))
      {
         // For L2 request only check constraints on: 1)Sp, 2)Mp/Sp, 3)MSGovhd >= 0.1kbps.
         if (s_L_L2 < sa_Lmin[i])
            s_L_L2 = sa_Lmin[i];
      }
      //XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges (start)
      if ( //(i != 3) &&  // MinLp check for minimum BC Net Data Rate
           ((i != 2) ||(gs_CurrentCoChipset == BDCM_CO_CHIPSET)
            ||(gt_INFX_CMV.us_SRA_IOP_Bits & CMV_SRA_TO_ENABLE_MINOVERHEAD_GHS_CHECK))&& //MinMSGOvhd check
         ((i != 5) ||(gs_CurrentCoChipset == BDCM_CO_CHIPSET) // for BDCM Delay constraint is mandatory
            // CMV control for delay constraint Check.
            ||(gt_INFX_CMV.us_SRA_IOP_Bits & CMV_TO_ENABLE_SRA_MAXLATENCY_CHECK)
         )
         )
      //XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges (end)
      {
         // For SRA check all constraints except latency.
         if (s_L_SRA <= sa_Lmin[i])
         {
            s_L_SRA = sa_Lmin[i];
            t_DerivedFrameProperties->s_OLR_LMinNoBpn_Cnstrnt = i+1;
         }
      }
   }

   t_DerivedFrameProperties->s_OLR_LMinNoBpn = s_L_SRA;
   t_DerivedFrameProperties->s_L2_LMin = s_L_L2;


   //With Bpn Change
   if(ft_isDownstream)
   {
   /******************************************************************************************************
   *BpnmaxCnstrnt (Assume Sp = 1, Dp = 1, Rp = 0)
   *
   *1. Bearer Channel Net Data Rate: BC0 (or lowest index)
   *   (Tp(Bp0+1)-1)MpLp/(Tp CWSize) <= max_BC0_datarate     ==>Tp*max_BC0_datarate >= 8(Tp(Bp0+1)-1)Mp
   *        ==> Tp*max_BC0_data_rate - 8*(Tp-1)*Mp >= 8*Tp*Mp*Bpn
   *
   *2. (skipped) Bearer Channel Net Data Rate: BC1
   *Therefore: the idea is to dry run the equation to find out the maximum Bpn that can still hold
   *BpmaxCnstrnt1[n] >= BpmaxCnstrnt2[n] * Bp. And find out the minimum value of the several Bp max.
   *
      ******************************************************************************************************/
      MULU16(ul_BpmaxCnstrnt1, s_Tp, s_MaxNetDataRateBC);
      ul_BpmaxCnstrnt1 -= ((s_Tp - 1) << (3+s_log2Mp));
      ul_BpmaxCnstrnt2 = s_Tp << (3+s_log2Mp);

      /******************************************************************************************************
      *KpmaxCnstrnt (Assume Sp = 1, Dp = 1, Rp = 0, Mp = 1)
      *
      *1. Latency Path Net Data Rate: Lp0
      *   (TpKp-1)MpLp/(TpCWSize) <= max_latency_path_datarate  ==>Tp CWSize max_latency_path_datarate >= (TpKp-1)MpLp
      *   ==>Tp*max_latency_path_datarate - 8*(Tp-1)*Mp >= 8*Tp*Mp*Kp
      *    if only one bearer channel mapped to this latency path, Kp = Bpn + 1
      *   ==>Tp*max_latency_path_datarate - 8*(2*Tp-1)*Mp >= 8*Tp*Mp*Bpn
      ******************************************************************************************************/
      MULU16(ul_KpmaxCnstrnt1, s_Tp, s_MaxDataRateLP);
      ul_KpmaxCnstrnt1 -= ((s_Tp<<1 - 1) << (3+s_log2Mp));

      ul_BpmaxCnstrnt1 = (ul_BpmaxCnstrnt1 > ul_KpmaxCnstrnt1)?ul_KpmaxCnstrnt1: ul_BpmaxCnstrnt1;

      //do binary search for the max Lp that still holds LmaxCnstrnt1[n] >= LmaxCnstrnt2[n] * Lp
      s_BpMax = BinarySearch(TRUE, ul_BpmaxCnstrnt1, ul_BpmaxCnstrnt2, 0, 254, 0, 254, 254);

      s_LmaxBpn = (s_BpMax + 1) << 3;

      if (t_DerivedFrameProperties->s_OLR_LMaxBpn > s_LmaxBpn)
      {
         t_DerivedFrameProperties->s_OLR_LMaxBpn = s_LmaxBpn;
         t_DerivedFrameProperties->s_OLR_LMaxBpn_Cnstrnt = 2;
      }

      /******************************************************************************************************
      *BpnminCnstrnt
      *1. Bearer Channel Net Data Rate: BC0 (or lowest index)
      *   (Tp(Bp0+1)-1)MpLp/(Tp CWSize) >= min_BC0_datarate     ==>Tp*min_BC0_datarate <= 8(Tp(Bp0+1)-1)Mp
      *        ==> Tp*min_BC0_data_rate - 8*(Tp-1)*Mp <= 8*Tp*Mp*Bpn
      *
      *Therefore: the idea is to dry run the equation to find out the minimum Bp that can still hold
      *BpminCnstrnt1[n] <= BpminCnstrnt2[n] * newBp. And find out the maximum value of the several Bp min.
      ******************************************************************************************************/
      MULU16(ul_BpminCnstrnt1, s_Tp, s_MinNetDataRateBC);
      ul_BpminCnstrnt1 -= ((s_Tp - 1) << (s_log2Mp + 3));

      //do binary search
      s_BpMin = BinarySearch(FALSE, ul_BpminCnstrnt1, ul_BpmaxCnstrnt2, 254, 0, 0, 254, 0);

      t_DerivedFrameProperties->s_OLR_LMinBpn = (s_BpMin + 1) << 3;
      t_DerivedFrameProperties->s_OLR_LMinBpn_Cnstrnt = 2;
   }
}


