/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   ComputeDsPcb.c
*
*   Compute downstream cutback for ADSL2
*
*-------------------------------------------------------------------------
*/
// ******************************************************************
// ComputeDsPcb.c
//
// History
//
//
// 22/07/2010 Nihar: Limit DS PCB to 6 dB for short loops in presence
//                   of strong noise. Grep for PERF_DS_BisPlus_CNXT_LimitDSPCB
//
// 26/07/2010 Nihar: Logic to add extra DS PCB to boost the DS data rate
//                   for short loops in Plus mode. All hashdefines/constants
//                   used as part of this logic are derived from experimentation results.
//                   By default its disabled. To enable it cw INFO 103 1 0x0040
//                   Grep for PERF_DS_PLUS_ALL_GeneralizedPcb
//
//07/03/2013 Palaksha: Improving DS PCB calculation on VRx Annex B.//
//             At present on VRx platform we see rate degradation due to
//             incorrect DS PCB calculation. With respect to this following changes are done
//             (d) Increase the DS PCB based on loop length around 5000Feet incase gft_StrongNoiseForDsPcbnoise=0
//       Grep for ADSLRTFW-1580 Perf_DS_BisPlus_ALL_ImpDsPcb
//
// 14/06/2013 Naveen: Re-adjusted the DS PCB calcualtion for VRx Annex B/J
//                    The CMV CMV_INFX_DFE_IOP_FIX_DS_PCB_ENABLE is enabled
//                    We increase the DS PCB  based on loop length upto 1000m incase gft_StrongNoiseForDsPcbnoise=0
//            Grep for XDSLRTFW-754 Perf_DS_Plus_ALL_AdjDsPcb
//
//  29/06/2013 Palaksha: Fix for "XDSLRTFW-1011 : TR100BI2: B.5.4.c / B.5.4.d: DS Rates less than Baseline by up-to 1763 kbps"
//             Also seen DS CRC's on these loops and Fix Involves
//             (i)  In ADSL2+ QLN size is  512 and using s_IndexShift=1 when accessing guca_QLN in ADSL2+ will
//                lead to some False Noise flag detection
//             (ii) Dont use More DS PCB when gft_NotchPresent is NOT zero (DS PCB code under CMV_INFX_DFE_IOP_FIX_DS_PCB_ENABLE)
//          Grep for XDSLRTFW-1011 Bug_fix_Plus_DPBOdsRateissue
//
// 23/07/2013 Naveen: Diasbled the DS PCB correction for VRx Annex B/J for virtual noise cases.
//                    Grep for XDSLRTFW-1119 BugFix_DS_Plus_ALL_VirtNoise
//
// 14/11/2013 : Sriram Shastry : BroadCom CO goes to indefinite stuck state against VR9 based Arcadyan board.
// It has been observed that Arcardyan board perform the splitter switch during first
// training to configure the splitter during first training.
// CPE is not computing the downstream power cut back based on the C-Comb2 siganl due to internal computaion error.
// The solution is : Apply 3dB DSPCB against Broadcom CO upto 2000M . After 2Km apply 1dB of DSPCB against
// Broadcom CO in Annex-J mode only ( Applicable for 3J and 5J mode)
//       Grep for XDSLRTFW-732 Feature_DS_B43_GHsTones_for_oISDN
//
// 15/11/2013 :Sriram Shastry :XDSLRTFW-1214 Sastry:DS CRCs are observed in the short Loops @250M against  NVLT-C DSLAM.
// The issue is  resolved by applying  6dB additional
// DS PCB in short loops. As a results the DS margin is lowered but DS Data rates
// remains the same. Added  -140dBm/Hz white noise detection for short loops.
//
// 09/11/2015 Stefan: Clean-up BgComputeDsPCB function for oISDN
//                    - Remove Anx-J specific logic
//                    - Correct default algorithm (was always returning "0dB" in previous code
//                    - calibrate GHs power dependent logic
//          Grep for XDSLRTFW-2510 : PCB_and_QLN_optimization_oISDN
//
// 07/24/2019 Stefan: XDSLRTFW-4200    CTL, ADSL2p: Downstream low perf on 500ft Xtalk loops (DS-PCB algo)
//            Concept:
//            The DS-PCB algorithm shall reduce the DS performance only on loops with excess margin on CPE side.
//            The DS performance shall not go down because of a too high DS-PCB request
//            Issue:
//            CPE requests on short loops with very high xtalk noise for approx 6dB Power-Cutback.
//            Solution:
//            1. Detect short loops which may be limited due to external noise
//               The "theoretical SNR" can be calculated: SNR = (DS-PSD + HLOG) - QLN
//               As we don't have a looplength estimation available when calculating PCB we assume that HLOG is 0dB ("worst case").
//               With a nominal DS PSD on CO side of -40dBm/Hz we may start seeing DS-performance loss if the QLN is higher than -100dBm/Hz
//               For this purpose we can use the flag "STAT_FBNoise"
//               (As 5T1 noise is set if the noise level of a certain frequency range is higher than -115dBm/Hz it should also be set)
//            2. Reduce the max PCB to 3dB for these loops
//               To prevent overflow on CO side we still allow a small DS-PCB (3dB).
//
// 07/24/2019 Stefan: XDSLRTFW-4201 CTL, ADSL2p: Downstream low perf on 5-7kft Xtalk loops - DS PCB algo
//          Force GHs power based algorithm on short "white noise" loops
//          As CO transmitter noise is higher than the "white noise" level we use following logic to find out whether we can use the
//          stronger DS-PCB algorithm
//               |  Noise level
// Looplength    | -120dBm/Hz | -130dBm/Hz | -140 dBm/Hz
//---------------+------------+------------+-------------
//      < 3.0kft |   GHsPOW   |   GHsPOW   |   GHsPOW   |
// 3.0kft-4.8kft |   COMB     |   GHsPOW   |   GHsPOW   |
// 4.8kft-7.5kft |   COMB     |   COMB     |   GHsPOW   |
//      > 7.5kft |   COMB     |   COMB     |   COMB     |
// ******************************************************************
#include "common.h"
#include "const_bis.h"
#include "bitload_const.h"
#include "cmv.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "typedef.h"
#include "vecpwr.h"
#include "pga_set.h"
#include "vecmult.h"
#include "hndshk_Data.h"   //XDSLRTFW-732 Feature_DS_B43_GHsTones_for_oISDN(Start_End)


//ADSLRTFW-1580 Perf_DS_BisPlus_ALL_ImpDsPcb (Start)

#define  VRx_HSK_TONE_POWER_MAX  (0x55)  // Measured value of gs_hsk_ForDsPCB >>8 at Short loop(say <50m)
#define  VRx_MAX_DS_PCB_16dB        (0x10)   //16dB
#define  VRx_MAX_DS_PCB_15dB        (0xF)   //15dB
#define  VRx_MAX_DS_PCB_14dB        (0xE)   //14dB
#define  VRx_MAX_DS_PCB_13dB        (0xD)   //13dB
#define  VRx_MAX_DS_PCB_12dB        (0xC)   //12dB

//#ifdef ISDN
#define VINAX_FW_VERSION_10_6_BYTE6 (0x90)
#define VINAX_FW_VERSION_10_6_BYTE7 (0x51)
//#endif

int16 gs_HSKtonepowerMAX = VRx_HSK_TONE_POWER_MAX;
int16 gs_DsPcbMax = VRx_MAX_DS_PCB_12dB;
int16 gs_hsk_ForDsPCB;
int16 gs_ForceVR9LowestMinPCB = 0;

//ADSLRTFW-1580 Perf_DS_BisPlus_ALL_ImpDsPcb (End)
int16 compute_ds_pcb(void)
{
    int32 l_temp, l_pwr;
    int s_cutback;

    // Compute average recieved power
    l_pwr = VectorPower(gsa_FDQ_coef_best, 0, (int16) (2*gs_RxNumTones),(int16)(gs_RxLog2NumTones+1));

    gla_DSPCB_DBG_pwr[gsa_DSPCB_DBG_idx] = l_pwr;
    /* In C-COMB signal only 16 tones are used. If there is no noise,   */
    /* rightshifting by (15-5) will result in 1.15 format value because */
    /* gs_RxSamplesPerFrame/16 = 32 = 2^5. Note that PGA value is equal */
    /* to 0dB here, so with noise, s_pwr is still 1.15 format           */
    /* Adjust the shift based on gs_pre_tdq_h_exp */
    l_temp = 10 + 2*(14 - gs_pre_tdq_h_exp);
    l_pwr >>= l_temp;
    gla_DSPCB_DBG_pwr[gsa_DSPCB_DBG_idx+10] = l_pwr;
    gsa_DSPCB_DBG_calcPCB[19] = gs_pre_tdq_h_exp;

    s_cutback = 0;
    while(l_pwr > gs_COMB2_REFERENCE_POWER)     // Fixed threshold (obtained empirically so that we do choose min pga on 0 to 2kft loops during training)
    {
        /* Reduce the power(16-bit value) by 1dB */
        l_temp = (int32)l_pwr*(gus_TxGainCutBackFactor>>2); // Scale down gus_TxGainCutBackFactor before multiplying to avoid overflow.
        l_pwr = (l_temp >>13);
        s_cutback++;
    }

    gsa_DSPCB_DBG_calcPCB[gsa_DSPCB_DBG_idx] = s_cutback;
    /* Account for additional 3 dB of power while using 1024 pt FFT due to an additional butterfly pass */
    /* We compare energies in frequency domain so threshold will be a function of fft length/scaling */
    if (gs_RxSamplesPerFrame == 1024)
    {
        s_cutback = (s_cutback > 3)? (s_cutback - 3): 0;
    }
    gsa_DSPCB_DBG_calcPCB[gsa_DSPCB_DBG_idx+10] = s_cutback;

    return((int16)s_cutback);
}

/*^^^
*------------------------------------------------------------------------
*
*  Name : BgComputeDsPCB
*
*  Description:    Compute downstream power cutback based on the captured
*  frequency domain C-COMB2 signal.
*
*  Prototype:  void BgComputeDsPCB(void);
*
*  Input Arguments: none
*  Output Arguments: none
*  Return: none
*------------------------------------------------------------------------
*^^^
*/
// XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(START)
#define MINIMUM_GHS_TONE_PWR_DB_0M      (0x5900)
#define MINIMUM_GHS_TONE_PWR_DB_500M   (0x5200)
// XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(END)


// XDSLRTFW-2510 : PCB_and_QLN_optimization_oISDN (Start)
#ifdef ISDN   // Only for Anx-B

void BgComputeDsPCB(void)
{
    int16 s_majorVer, s_minorVer;
    int32 i;
    int16 *psa_TssiScalingShift;    // Shift to be applied after tssi scaling
    int16 *psa_DsLogTssi;        // Log tssi per tone.   8.8 format for (dB*2); 7.9 format for dB.
    int16 *psa_Comb2ScaledFrame; // Comb2 Frame scaled by tssi and pcb
    int16 s_DsLogTssi, s_ToneCutback;
    int16 s_minPCB, s_maxPCB, s_currPCB, s_cutback;
    int16 sa_ScaleMantissa[21] = // 1.15 format of N dB (20log10(x)), for N=0 to 20. below table x = 1:20;round(32767*(power(10,-x/20)) ;32767 for 0dB cutback
    {
        32767,29205,26029,23198,20675,18427,16423,14637,13045,11627,10362,
        9235,8231,7336,6538,5827,5193,4628,4125,3677,3277
    }; // 21 entries
    FlagT ft_tssiCeilDisable;

   int16 s_loopDsPCB, s_loopDsPCB_relative;
   int16 s_ForceCutBack,s_hsk_tone_power_dB_PCB;   // XDSLRTFW-732 Feature_DS_B43_GHsTones_for_oISDN(Start_End)
   uint16 us_CurrentCoVendorID;

   gsa_DSPCB_DBG_idx = 0;
   //------------------------------------------------------------------------
   //                         COMB-signal based PCB algorithm
   //------------------------------------------------------------------------
   //    => output: gs_DSPCB_COMB_ALGO
   //------------------------------------------------------------------------

    if ((gs_CurrentCoChipset == AWRE_CO_CHIPSET) || (OPTNArray[OPTN_StateMachineCtrl] & OPTN_TssiCeil_Disable))
    {
        ft_tssiCeilDisable = TRUE;
    }
    else
    {
        ft_tssiCeilDisable = FALSE;
    }

    // Tssi is represent here in Q1.15 format. We initialize all elements of this
    // array with a shift value of 15 so as to re-use VectorMultiply() assembly function
    psa_TssiScalingShift = (int16 *)gsa_RxRepFrameAlignBuf + 2*(RX_NUM_TONES);
    for (i = 0; i < 2*(RX_NUM_TONES); i++)
       *psa_TssiScalingShift++ = 15;
    psa_TssiScalingShift = (int16 *)gsa_RxRepFrameAlignBuf + 2*(RX_NUM_TONES);

    // Do a binary search over cutback values of (0,20) dB to find exact cutback value
    s_minPCB = 0; s_maxPCB = 20;

    while(s_minPCB != s_maxPCB)
    {
        /* get pcb for current iteration*/
        s_currPCB = s_minPCB + ((s_maxPCB - s_minPCB) >> 1);
        gsa_DSPCB_DBG_currPCB[gsa_DSPCB_DBG_idx] = s_currPCB;

        /* get scaling factor for given pcb and tssi */
        psa_Comb2ScaledFrame = gsa_FDQ_coef_best;
        psa_DsLogTssi = (int16 *)(void *) gusa_DS_Tssi_Value;  // At this point, gusa_DS_Tssi_Value contains log(tssi) values
        for (i = 0; i < (int32)gs_RxNumTones; i++)
        {
            // Per tone cutback in dB format
            s_ToneCutback = s_currPCB;
            s_DsLogTssi = *psa_DsLogTssi++;
            if (ft_tssiCeilDisable == FALSE && /* Disabled for CO's which havent implemented ceiled tssi */
                    IS_TONEFLAGSET(p_SUPPORTEDset_DS, i))
            {
                s_ToneCutback -= (int16)(s_DsLogTssi>>9);   // rounded to lowest dB
            }
            // Per tone cutback in linear format
            if (s_ToneCutback < 0)  s_ToneCutback = sa_ScaleMantissa[0];
            else                    s_ToneCutback = sa_ScaleMantissa[s_ToneCutback];
            *psa_Comb2ScaledFrame++ = s_ToneCutback;
            *psa_Comb2ScaledFrame++ = s_ToneCutback;
        }

        /* apply scaling to representative comb frame */
        VectorMultiply(gsa_FDQ_coef_best, gsa_RxRepFrameAlignBuf, gsa_FDQ_coef_best,
        psa_TssiScalingShift, (int16) (2*gs_RxNumTones));

        /* compute additional ds pcb required and progress binary */
        /* search depending on ds pcb required for given curr pcb */
        s_cutback = compute_ds_pcb();
        if (s_cutback <= 0)
           s_maxPCB = s_currPCB;
        else if(s_minPCB != s_currPCB) // s_cutback > 0
           s_minPCB = s_currPCB;
        else   /* avoid infinite loop when min=x, max=x+1 and s_cutback>0 */
           s_minPCB = s_maxPCB;
        gsa_DSPCB_DBG_idx = gsa_DSPCB_DBG_idx + 1;
    }

    s_minPCB += (gs_PcbDsDeltaForNotch);

    gs_DSPCB_COMB_ALGO = s_minPCB;




   //------------------------------------------------------------------------
   //                         GHs-Power based PCB algorithm
   //------------------------------------------------------------------------
   //    => output: gs_DSPCB_GHsPOW_ALGO
   //------------------------------------------------------------------------



   // ADSLRTFW-1580 Perf_DS_BisPlus_ALL_ImpDsPcb (Start)
   // XDSLRTFW-754 Perf_DS_Plus_ALL_AdjDsPcb (Start)

   //--------------------------------------------------------------------------------------------------//
   // ALGORITHM
   //                       (gs_hsk_ForDsPCB_max-gs_hsk_ForDsPCB)
   //       DS-PCB = 12dB - -------------------------------------
   //                                        2
   //--------------------------------------------------------------------------------------------------//
   //      gs_hsk_ForDsPCB
   //--------------------------------------------------------------------------------------------------//
   //      WN --> -140dBm/Hz white noise
   //      hsk_tone_power_dB
   //
   //      loop(m)      | WN_Splitter,BRCM MUC                   |   WN_no_Splitter,gmx MUC     |
   //      ---------------|--------------------------------------|------------------------------------------|
   //                     | gs_hsk_tone_power_dB | PCB [dB]      |   gs_hsk_tone_power_dB | PCB [dB] |
   //-------------------//--------------------------------------//-----------------------------------------//
   //                   |     this section is our reference      | this section is NOT reproducible |
   //      0  ----------|-------------- 0x54------  11-----------|----- 0x56------ 12-----------|
   //      100 ---------|-------------- 0x52------  10-----------|----- 0x54------ 11-----------|
   //      200  --------|-------------- 0x51------  10-----------|----- 0x53------ 11-----------|
   //      300  --------|-------------- 0x50------   9-----------|----- 0x52------ 10-----------|
   //      400  --------|-------------- 0x4D------   8-----------|----- 0x4E------  8-----------|
   //      500  --------|-------------- 0x4C------   7-----------|----- 0x46------  4-----------|
   //      600 ---------|-------------- 0x4A------   6-----------|----- 0x42------  2-----------|
   //      700 ---------|-------------- 0x49------   6-----------|----- 0x3D------  0-----------|
   //      800 ---------|-------------- 0x47------   5-----------|----- 0x39------  0-----------|
   //      900 ---------|-------------- 0x45------   4-----------|----- 0x35------  0-----------|
   //      1000 -------|--------------- 0x44------   3-----------|----- 0x32------  0-----------|
   //      1100 -------|--------------- 0x42------   2-----------|----- 0x2E------  0-----------|
   //      1200 -------|--------------- 0x41------   2-----------|----- 0x2A------  0-----------|
   //      1300 -------|--------------- 0x3F------   1-----------|----- 0x26------  0-----------|
   //      1400 -------|--------------- 0x3D------   0-----------|----- 0x22------  0-----------|
   //      1500 -------|--------------- 0x3C------   0-----------|----- 0x1E------  0-----------|
   //      1600 -------|--------------- 0x3A------   0-----------|----- 0x1E------  0-----------|
   //      1700 -------|--------------- 0x39------   0-----------|----- 0x16------  0-----------|
   //      1800 -------|--------------- 0x37------   0-----------|----- 0x13------  0-----------|
   //      1900 -------|--------------- 0x36------   0-----------|----- 0x13------  0-----------|
   //      2000 -------|--------------- 0x34------   0-----------|----- 0x13------  0-----------|   0x32
   //      2100 -------|--------------- 0x33------   0-----------|----- 0x13------  0-----------|   0x30
   //      2200 -------|--------------- 0x31------   0-----------|----- 0x13------  0-----------|   0x2e
   //      2300 -------|--------------- 0x2F------   0-----------|----- 0x13------  0-----------|   0x2d
   //      2400 -------|--------------- 0x2E------   0-----------|----- 0x13------  0-----------|   0x2b
   //      2500 -------|--------------- 0x2C------   0-----------|----- 0x13------  0-----------|   0x2a
   //      2600 -------|--------------- 0x2A------   0-----------|----- 0x13------  0-----------|
   //      2700 -------|--------------- 0x29------   0-----------|----- 0x13------  0-----------|
   //      2800 -------|--------------- 0x28------   0-----------|----- 0x13------  0-----------|
   //      2900 -------|--------------- 0x26------   0-----------|----- 0x13------  0-----------|
   //      3000 -------|--------------- 0x24------   0-----------|----- 0x13------  0-----------|
   //      3100 -------|--------------- 0x23------   0-----------|----- 0x13------  0-----------|
   //      3200 -------|--------------- 0x21------   0-----------|----- 0x13------  0-----------|
   //      ---------------------------------------------------------------------------------------------
   //

    // XDSLRTFW-3511 (Start): VRX518 ADSL(2/2+) C-Comb based Loop Length Estimation with considering PCB for ISDN
    // Loop length estimation test were done against NVLT-M DSLAM with different DPBO shaped signal and
    // different back ground noise.
    // gs_hsk_tone_power_dB_PCB value without Splitter (B43 CTones)
    // loop(m) --|--No DPBO -140 dBmWN--|--No DPBO -120dBM WN--|--ESLE 70 -140dBm WN--|-- ESLE 70 -120dBm WN--|
    //---0-------|--0x5562--------------|--0x5568--------------|--0x549C--------------|--0x550D---------------|
    //---100-----|--0x53C3--------------|--0x53D4--------------|--0x536F--------------|--0x5372---------------|
    //---200-----|--0x5234--------------|--0x5234--------------|--0x517C--------------|--0x51CF---------------|
    //---300-----|--0x50A8--------------|--0x50A6--------------|--0x5010--------------|--0x5011---------------|
    //---400-----|--0x4F0F--------------|--0x4F0F--------------|--0x4E50--------------|--0x4E47---------------|
    //---500-----|--0x4D81--------------|--0x4D80--------------|--0x4CB3--------------|--0x4CB8---------------|
    //---600-----|--0x4C0F--------------|--0x4C0D--------------|--0x4B42--------------|--0x4B47---------------|
    //---700-----|--0x4A72--------------|--0x4A72--------------|--0x49BA--------------|--0x49B1---------------|
    //---800-----|--0x48D3--------------|--0x48D3--------------|--0x480B--------------|--0x480C---------------|
    //---900-----|--0x473C--------------|--0x473B--------------|--0x4671--------------|--0x4667---------------|
    //--1000-----|--0x45AE--------------|--0x45AE--------------|--0x44DF--------------|--0x44EE---------------|
    //
    // More results can be found in Jira XDSLRTFW-3511
    // XDSLRTFW-3511 (End)

   gs_hsk_ForDsPCB = (gs_hsk_tone_power_dB +(gs_hsk_power_dB_VendorComp>>1) + 0x80) >> 8;    // rounding
   s_loopDsPCB = gs_HSKtonepowerMAX - gs_hsk_ForDsPCB;      // 0x55 - gs_hsk_ForDsPCB
   //Make sure >=0
   if (s_loopDsPCB < 0)
      s_loopDsPCB = 0;

   s_loopDsPCB_relative = (s_loopDsPCB >> 1);                     // divide by 2
   gs_DSPCB_GHsPOW_ALGO = gs_DsPcbMax - s_loopDsPCB_relative;     // 12dB - (gs_hsk_ForDsPCB_max-gs_hsk_ForDsPCB)/2


   //------------------------------------------------------------------------
   //                         Selection of the PCB-algorithm
   //------------------------------------------------------------------------
   //    => input:   gs_DSPCB_COMB_ALGO
   //                gs_DSPCB_GHsPOW_ALGO
   //    => output:  s_minPCB
   //                gs_DSPCB_Selected_ALGO     0x1: COMB-algo, 0x2: GHsPOW-algo
   //------------------------------------------------------------------------

   // Annex B and Annex J
   // for virtual noise cases, ignore this
   if (   (gt_INFX_CMV.s_DFE_Options & CMV_INFX_DFE_IOP_FIX_DS_PCB_ENABLE)
       && (     ((STATArray[STAT_Performance] & STAT_M120WhiteNoise) && (gs_hsk_tone_power_dB > MINIMUM_GHS_TONE_PWR_AT_600M))         // looplength  <  600m
             || ((STATArray[STAT_Performance] & STAT_M130WhiteNoise) && (gs_hsk_tone_power_dB > MINIMUM_GHS_TONE_PWR_AT_1200M))        // looplength  < 1000m
             || ((STATArray[STAT_Performance] & STAT_M140WhiteNoise) && (gs_hsk_tone_power_dB > MINIMUM_GHS_TONE_PWR_AT_2000M)))        //looplength  < 2000m
       && (gft_NotchPresent == 0)                                       //XDSLRTFW-1011 Bug_fix_Plus_DPBOdsRateissue
       && (gl_SelectedMode & MODE_G992_5)          // Stefan: Why is this approach not used for BIS?
       && (gus_NumbDsVnBrkPoints == 0)             // Disable code for Virtual noise - XDSLRTFW-1119 BugFix_DS_Plus_ALL_VirtNoise
       && (gs_firstSupportedTone < 261))           // Disable code for Cabinets
   {
      s_minPCB = gs_DSPCB_GHsPOW_ALGO;
      gs_DSPCB_Selected_ALGO = 0x2;          // GHsPOW_ALGO
   }
   else
   {
      s_minPCB = gs_DSPCB_COMB_ALGO;
      gs_DSPCB_Selected_ALGO = 0x1;          // COMB_ALGO
   }

   //------------------------------------------------------------------------
   //                         CALCULATE gs_LowestMinPCB
   //------------------------------------------------------------------------
   //    => output:     gs_LowestMinPCB
   //------------------------------------------------------------------------

   // For all Geminax FWs, in 2+ mode require 3 dB DS power cutback upto 1 km loop to enhance the
   // DS performence (by disabling the PAR tones) and at least 1dB DS Power cutback at all the other loops
   // for Geminax 7.11 & 7.12 FW  to enhance the US performence (by reducing echo).
   // except if it is a cabinet mode application where tones start above 255.
   //ADSLRTFW-1580 Perf_DS_BisPlus_ALL_ImpDsPcb (Start_End) // This was using 1900m
   // XDSLRTFW-754 Perf_DS_Plus_ALL_AdjDsPcb (Start_End) // Changed to 2100m
   // XDSLRTFW-2xxx (Start)
   if (gs_LowestMinPCB == 0)
   {

      if ((gs_CurrentCoChipset == IFTN_CO_CHIPSET) && (gs_firstSupportedTone < 255))
      {
         s_majorVer = ((gs_CurrentCoVendorID>>12)&0xf);
         s_minorVer = ((gs_CurrentCoVendorID>>4)&0xff);

         // minimum PCB is limited only for LQ-CO and non-cabinet configurations
         //
         //                               | gs_LowestMinPCB
         //    Looplength   |  Noise      |  Gmx CO 7.11/7.12  | Vinax 0x9051  | all other LQ COs   |
         //  ---------------|-------------|--------------------|---------------|--------------------|
         //          0 m    | -140/-130WN |           3 dB     |      3 dB     |          3 dB      |
         //       2000 m    | -140/-130WN |           3 dB     |      3 dB     |          3 dB      |
         //       2200 m    | -140/-130WN |           1 dB     |      2 dB     |          0 dB      |
         //       4000 m    | -140/-130WN |           1 dB     |      2 dB     |          0 dB      |
         //  ---------------|-------------|--------------------|---------------|--------------------|
         //          0 m    | strong noise|           1 dB     |      0 dB     |          0 dB      |
         //       2000 m    | strong noise|           1 dB     |      0 dB     |          0 dB      |
         //       2200 m    | strong noise|           1 dB     |      0 dB     |          0 dB      |
         //       4000 m    | strong noise|           1 dB     |      0 dB     |          0 dB      |
         //  ---------------|-------------|--------------------|---------------|--------------------|

         if ( (s_majorVer == 0x7) && (s_minorVer == 0x11) || (s_minorVer == 0x12) )
            gs_LowestMinPCB = 1 ;      /* only for Gmx CO 7.11 & 7.12 FWs */

         if (    (STATArray[STAT_Performance] & STAT_M140WhiteNoise)
              || (STATArray[STAT_Performance] & STAT_M130WhiteNoise))
         {
            if (gs_hsk_tone_power_dB > MINIMUM_GHS_TONE_PWR_AT_1900M) // Less than 1900m
               gs_LowestMinPCB = 3 ;         /* for all versions of Gmx CO FWs */
            else if (    (guca_fe_G9941_VendorID[6] ==  VINAX_FW_VERSION_10_6_BYTE6)
                      && (guca_fe_G9941_VendorID[7] ==  VINAX_FW_VERSION_10_6_BYTE7)
                    )
            {
               // On long white-noise loops the US performance is too low because of echo effects
               // reduce the echo and increase the US performance by applying 2dB DS-PCB
               // With Annex BJ hybrid ran some loop reach and with different noise scenarios and captured the following
               //LoopLength   gs_hsk_tone_power_dB
               //2000m        3216
               //2100m        3075
               //2200m        2ef9
               //2300m        2d58
               //2400m        2bd8
               //2500m        2a4b
               gs_LowestMinPCB = 2 ;      /* 2dB PCB on long White noise loop to increase US performance against Vinax */
            }
         }
      }
   }
   // XDSLRTFW-2xxx (End)




   // XDSLRTFW-732 Feature_DS_B43_GHsTones_for_oISDN(Start)
   // BroadCom CO goes to indefinite stuck state against VR9 based Arcadyan board.
   // It has been observed that Arcardyan board perform the splitter switch during first
   // training to configure the splitter during first training.
   // CPE is not computing the downstream power cut back based on the C-Comb2 siganl due to internal computaion error.
   // The solution is : Apply 3dB DSPCB against Broadcom CO upto 2000M . After 2Km apply 1dB of DSPCB against
   // Broadcom CO in Annex-J mode only ( Applicable for 3J and 5J mode)
   //XDSLRTFW-3204
   //NVLT-M CO always fails with "Exceptioncode 0x65" drops at the end of Showtime @500M
   //chip version: NVLT-M BRCM Anx B
   //firmware version: R4.3.02
   //FW release status: not supported
   //FW application version: L6GPAA43.447 M3AMAA41.410
   //If CPE sends DS PCB of 3dB then CPE reaches show time.
   //After this if we load the original firmware (FW 5A1212) also reaches show time.
   //Appears like there is some unknown / un-initialised variable which get initialised with DS PCB request of 3dB,on CO side.
   //And then if we use any firmware , modem reaches showtime.
   //So conclusion to get around this CO issue we need to apply 3dB DS cutback

   s_ForceCutBack = 3;
   if(DebugCutBack.s_DSPCBForce != 0)
      s_ForceCutBack =   DebugCutBack.s_DSPCBForce;
      // ATTENTION_IOP! : BRCM CO NEEDS DS-PCB of 3dB up to 1000M
    s_hsk_tone_power_dB_PCB = MINIMUM_GHS_TONE_PWR_AT_1100M;
    if(DebugCutBack.s_LooplengthForce != 0)
      s_hsk_tone_power_dB_PCB =   DebugCutBack.s_LooplengthForce;
   us_CurrentCoVendorID = (uint16)gs_CurrentCoVendorID;
   if(    (s_minPCB == 0)
       && (gs_CurrentCoChipset == BDCM_CO_CHIPSET)
       && (gl_SelectedMode & (ANNEX_J))
   //&& (us_CurrentCoVendorID == (0xA3D3))  // made it general like VR9 Not restricted thi fix to NVLT-M
   )
   {
      if(gs_hsk_tone_power_dB_PCB > s_hsk_tone_power_dB_PCB)
         s_minPCB  = s_ForceCutBack;   // Apply 3dB power
      //else if(gs_hsk_tone_power_dB_PCB > MINIMUM_GHS_TONE_PWR_AT_4000M)  // PCB may not be required after  2Km
      // s_minPCB  = 1;          // Apply 1dB power
   }
   // XDSLRTFW-732 Feature_DS_B43_GHsTones_for_oISDN(End)

   s_minPCB += (gs_PCB_DS_Delta_bis )  ;

   if(s_minPCB >= gs_HighestMinPCB)
      s_minPCB = gs_HighestMinPCB;
   if(s_minPCB < gs_LowestMinPCB)
      s_minPCB = gs_LowestMinPCB;
   // XDSLRTFW-754 Perf_DS_Plus_ALL_AdjDsPcb (End)
   //ADSLRTFW-1580 Perf_DS_BisPlus_ALL_ImpDsPcb (End)
   //Cap maximum DSPCB to 12dB always
   //   if (s_minPCB > 12)
   //   {
   //       s_minPCB = 12; // cap the DS PCB to 12 dB;
   //   }

    gt_RMsgPcb_bis.us_R_MIN_PCB_DS = s_minPCB ;

    guc_BkgdTaskState = TRAINING_DONE;
}

// XDSLRTFW-2510 : PCB_and_QLN_optimization_oISDN (End)

#else // oISDN ends - oPOTS starts here

void BgComputeDsPCB(void)
{
    int32 i;
    int16 *psa_TssiScalingShift;    // Shift to be applied after tssi scaling
    int16 *psa_DsLogTssi;        // Log tssi per tone.   8.8 format for (dB*2); 7.9 format for dB.
    int16 *psa_Comb2ScaledFrame; // Comb2 Frame scaled by tssi and pcb
    int16 s_DsLogTssi, s_ToneCutback;
    int16 s_minPCB, s_maxPCB, s_currPCB, s_cutback;
    int16 sa_ScaleMantissa[21] = // 1.15 format of N dB (20log10(x)), for N=0 to 20.
    {
        32767,29205,26029,23198,20675,18427,16423,14637,13045,11627,10362,
        9235,8231,7336,6538,5827,5193,4628,4125,3677,3277
    }; // 21 entries
    FlagT ft_tssiCeilDisable;
    int16 s_loopDsPCB, s_loopDsPCB_relative;
    int16 s_hsk_PCB_thrshold_24HDSL;
    gsa_DSPCB_DBG_idx = 0;


    if ((gs_CurrentCoChipset == AWRE_CO_CHIPSET) ||
            (OPTNArray[OPTN_StateMachineCtrl] & OPTN_TssiCeil_Disable))
    {
        ft_tssiCeilDisable = TRUE;
    }
    else
    {
        ft_tssiCeilDisable = FALSE;
    }

    // Tssi is represent here in Q1.15 format. We initialize all elements of this
    // array with a shift value of 15 so as to re-use VectorMultiply() assembly function
    psa_TssiScalingShift = (int16 *)gsa_RxRepFrameAlignBuf + 2*(RX_NUM_TONES);
    for (i = 0; i < 2*(RX_NUM_TONES); i++)
    *psa_TssiScalingShift++ = 15;
    psa_TssiScalingShift = (int16 *)gsa_RxRepFrameAlignBuf + 2*(RX_NUM_TONES);

    // Do a binary search over cutback values of (0,20) dB to find exact cutback value
    s_minPCB = 0; s_maxPCB = 20;

    // PERF_DS_BisPlus_CNXT_LimitDSPCB (Start)
    // For better purformance on the short loops, limit the DS PCB (in cases when the CO doesn't send DS PCB)
    // This is a temporary fix till the generalized PCB algorithm is developed. Also, this takes into effect
    // only in the presence of strong noise, like FB Noise etc.
    if (STATArray[STAT_Performance] & STAT_FBNoise)
    {
      if((gl_SelectedMode & (MODE_ADSL2)) &&  (gs_CurrentCoChipset == GSI_CO_CHIPSET))
         s_maxPCB = 6;
       //PERF_DS_BisPlus_TIAC7_LimitDSPCB (Start)
       else if((gl_SelectedMode & (MODE_G992_3)) && ((gs_CurrentCoChipset == TI_CO_CHIPSET) || (gs_CurrentCoChipset == BDCM_CO_CHIPSET))) //XDSLRTFW-2423 (Start_End)
         s_maxPCB = 6;
       //PERF_DS_BisPlus_TIAC7_LimitDSPCB (End)
    }
    // PERF_DS_BisPlus_CNXT_LimitDSPCB (End)
    // Strong Noise cases(ETSI)  like FB noise cap max PCB to 6dB for ADSL2p/ADSL2 modes
    if ((STATArray[STAT_Performance] & STAT_FBNoise)&&(gft_NotchPresent == FALSE))
      s_maxPCB = 6;

    while(s_minPCB != s_maxPCB)
    {
        /* get pcb for current iteration*/
        s_currPCB = s_minPCB + ((s_maxPCB - s_minPCB) >> 1);
        gsa_DSPCB_DBG_currPCB[gsa_DSPCB_DBG_idx] = s_currPCB;

        /* get scaling factor for given pcb and tssi */
        psa_Comb2ScaledFrame = gsa_FDQ_coef_best;
        psa_DsLogTssi = (int16 *)(void *)gusa_DS_Tssi_Value;   // At this point, gusa_DS_Tssi_Value contains log(tssi) values
        for (i = 0; i < (int32)gs_RxNumTones; i++)
        {
            // Per tone cutback in dB format
            s_ToneCutback = s_currPCB;
            s_DsLogTssi = *psa_DsLogTssi++;
            if (ft_tssiCeilDisable == FALSE && /* Disabled for CO's which havent implemented ceiled tssi */
                    IS_TONEFLAGSET(p_SUPPORTEDset_DS, i))
            {
                s_ToneCutback -= (int16)(s_DsLogTssi>>9);   // rounded to lowest dB
            }
            // Per tone cutback in linear format
            if (s_ToneCutback < 0) s_ToneCutback = sa_ScaleMantissa[0];
            else s_ToneCutback = sa_ScaleMantissa[s_ToneCutback];
            *psa_Comb2ScaledFrame++ = s_ToneCutback;
            *psa_Comb2ScaledFrame++ = s_ToneCutback;
        }

        /* apply scaling to representative comb frame */
        VectorMultiply(gsa_FDQ_coef_best, gsa_RxRepFrameAlignBuf, gsa_FDQ_coef_best,
        psa_TssiScalingShift, (int16) (2*gs_RxNumTones));

        /* compute additional ds pcb required and progress binary */
        /* search depending on ds pcb required for given curr pcb */
        s_cutback = compute_ds_pcb();
        if (s_cutback <= 0)
           s_maxPCB = s_currPCB;
        else if(s_minPCB != s_currPCB) // s_cutback > 0
           s_minPCB = s_currPCB;
        else   /* avoid infinite loop when min=x, max=x+1 and s_cutback>0 */
           s_minPCB = s_maxPCB;
        gsa_DSPCB_DBG_idx = gsa_DSPCB_DBG_idx + 1;
    }

    // XDSLRTFW-4200    CTL, ADSL2p: Downstream low perf on 500ft Xtalk loops (DS-PCB algo)
    // Concept:
    // The DS-PCB algorithm shall reduce the DS performance only on loops with excess margin on CPE side.
    // The DS performance shall not go down because of a too high DS-PCB request
    // Issue:
    // CPE requests on short loops with very high xtalk noise for approx 6dB Power-Cutback.
    // Solution:
    // 1. Detect short loops which may be limited due to external noise
    //    The "theoretical SNR" can be calculated: SNR = (DS-PSD + HLOG) - QLN
    //    As we don't have a looplength estimation available when calculating PCB we assume that HLOG is 0dB ("worst case").
    //    With a nominal DS PSD on CO side of -40dBm/Hz we may start seeing DS-performance loss if the QLN is higher than -100dBm/Hz
    //    For this purpose we can use the flag "STAT_FBNoise"
    //    (As 5T1 noise is set if the noise level of a certain frequency range is higher than -115dBm/Hz it should also be set)
    // 2. Reduce the max PCB to 3dB for these loops
    //    To prevent overflow on CO side we still allow a small DS-PCB (3dB).
    if (    (STATArray[STAT_Performance] & STAT_5T1Noise)
         && (STATArray[STAT_Performance] & STAT_FBNoise)
         && (gl_SelectedMode & MODE_G992_5)          // Stefan: Why is this approach not used for BIS?
         && (gus_NumbDsVnBrkPoints == 0)             // Disable code for Virtual noise - XDSLRTFW-1119 BugFix_DS_Plus_ALL_VirtNoise
         && (gs_firstSupportedTone < 261))           // Disable code for Cabinets
    {
       if (s_minPCB > 3)
          s_minPCB = 3;
    }

    gs_DSPCB_COMB_ALGO = s_minPCB;

    //------------------------------------------------------------------------
    //                         GHs-Power based PCB algorithm
    //------------------------------------------------------------------------
    //    => output: gs_DSPCB_GHsPOW_ALGO
    //------------------------------------------------------------------------
    //--------------------------------------------------------------------------------------------------//
    // ALGORITHM
    //                       (gs_hsk_ForDsPCB_max-gs_hsk_ForDsPCB)
    //       DS-PCB = 12dB - -------------------------------------
    //                                        2
    //--------------------------------------------------------------------------------------------------//
    //      gs_hsk_ForDsPCB
    //--------------------------------------------------------------------------------------------------//
    //      WN --> -140dBm/Hz white noise
    //      hsk_tone_power_dB
    //
    //      loop(m)    |   WN_no_Splitter,NDLT-G,BLR    |
    //      -----------|------------------------------------------|
    //                 |   gs_hsk_tone_power_dB | PCB [dB] |
    //-----------------+-----------------------------------------//
    //   Loop          |   gs_hsk_tone_power_dB    (inhex)
    //-----------------+-----------------------------------------//
    //    0                91.8              0x5B
    //  500                84.0              0x53
    // 1000                76.1              0x4C
    // 1500                68.3              0x44
    // 2000                60.3              0x3C
    // 2500                52.8              0x34
    // 3000                45.0              0x2D
    // 3500                36.9              0x24
    // 4000                29.6              0x1D
    // 4500                22.5              0x16
    // 5000                15.3              0x0F
     // --------------------------------------------------
     //
    gs_hsk_ForDsPCB = (gs_hsk_tone_power_dB +(gs_hsk_power_dB_VendorComp>>1) + 0x80) >> 8;    // rounding
    s_loopDsPCB = gs_HSKtonepowerMAX - gs_hsk_ForDsPCB;      // 0x55 - gs_hsk_ForDsPCB
    //Make sure >=0
    if (s_loopDsPCB < 0)
       s_loopDsPCB = 0;

    s_loopDsPCB_relative = (s_loopDsPCB >> 1);                     // divide by 2
    gs_DSPCB_GHsPOW_ALGO = gs_DsPcbMax - s_loopDsPCB_relative;     // 12dB - (gs_hsk_ForDsPCB_max-gs_hsk_ForDsPCB)/2
    if(gs_DSPCB_GHsPOW_ALGO < 0)
      gs_DSPCB_GHsPOW_ALGO = 0;

   //------------------------------------------------------------------------
   //                         Selection of the PCB-algorithm
   //------------------------------------------------------------------------
   //    => input:   gs_DSPCB_COMB_ALGO
   //                gs_DSPCB_GHsPOW_ALGO
   //    => output:  s_minPCB
   //                gs_DSPCB_Selected_ALGO     0x1: COMB-algo, 0x2: GHsPOW-algo
   //------------------------------------------------------------------------

   if(gs_CurrentCoChipset == IFTN_CO_CHIPSET)
     s_hsk_PCB_thrshold_24HDSL = MINIMUM_GHS_TONE_PWR_AT_5250F;   //upto 5kft (including)       (15836, 0x3ddc,  61.86 dB)
   else
     s_hsk_PCB_thrshold_24HDSL = MINIMUM_GHS_TONE_PWR_AT_4750F;   //upto 5kft (excluding)       (16654, 0x410e,  65.05 dB)

   // XDSLRTFW-4201 CTL, ADSL2p: Downstream low perf on 5-7kft Xtalk loops - DS PCB algo
   // Force GHs power based algorithm on short "white noise" loops
   // As CO transmitter noise is higher than the "white noise" level we use following logic to find out whether we can use the
   // stronger DS-PCB algorithm
   //               |  Noise level
   // Looplength    | -120dBm/Hz | -130dBm/Hz | -140 dBm/Hz
   //---------------+------------+------------+-------------
   //      < 3.0kft |   GHsPOW   |   GHsPOW   |   GHsPOW   |
   // 3.0kft-4.8kft |   COMB     |   GHsPOW   |   GHsPOW   |
   // 4.8kft-7.5kft |   COMB     |   COMB     |   GHsPOW   |
   //      > 7.5kft |   COMB     |   COMB     |   COMB     |

   // Annex A and Annex M
   // for virtual noise cases, ignore this
   if (   (gt_INFX_CMV.s_DFE_Options & CMV_INFX_DFE_IOP_FIX_DS_PCB_ENABLE)
       && (     ((STATArray[STAT_Performance] & STAT_M120WhiteNoise) && (gs_hsk_tone_power_dB > MINIMUM_GHS_TONE_PWR_AT_3000F))        // looplength  < 3000ft (19072, 0x4a80,  74.50 dB)
             || ((STATArray[STAT_Performance] & STAT_M130WhiteNoise) && (gs_hsk_tone_power_dB > MINIMUM_GHS_TONE_PWR_AT_4750F))        // looplength  < 4750ft (16654, 0x410e,  65.05 dB)
             || ((STATArray[STAT_Performance] & STAT_M140WhiteNoise) && (gs_hsk_tone_power_dB > MINIMUM_GHS_TONE_PWR_AT_7500F))        // looplength  < 7500ft (13448, 0x3488,  52.53 dB)
             || ((STATArray[STAT_Performance] & STAT_24HDSLNoise)    && (gs_hsk_tone_power_dB > s_hsk_PCB_thrshold_24HDSL)))           //~looplength  < 5000ft (16102, 0x3ee6,  62.90 dB)
       &&(!(STATArray[STAT_Performance] & STAT_5T1Noise))
       //&& (gft_NotchPresent == 0)                                       //XDSLRTFW-1011 Bug_fix_Plus_DPBOdsRateissue
       && (gl_SelectedMode & MODE_G992_5)          // Stefan: Why is this approach not used for BIS?
       && (gus_NumbDsVnBrkPoints == 0)             // Disable code for Virtual noise - XDSLRTFW-1119 BugFix_DS_Plus_ALL_VirtNoise
       && (gs_firstSupportedTone < 261))           // Disable code for Cabinets
   {
      s_minPCB = gs_DSPCB_GHsPOW_ALGO;
      gs_DSPCB_Selected_ALGO = 0x2;          // GHsPOW_ALGO
   }
   else
   {
      s_minPCB = gs_DSPCB_COMB_ALGO;
      gs_DSPCB_Selected_ALGO = 0x1;          // COMB_ALGO
   }
    //------------------------------------------------------------------------
    //                         CALCULATE gs_LowestMinPCB
    //------------------------------------------------------------------------
    //    => output:     gs_LowestMinPCB
    //------------------------------------------------------------------------

    // For all Geminax FWs, in 2+ mode require 3 dB DS power cutback upto 1 km loop to enhance the
    // DS performence (by disabling the PAR tones) and at least 1dB DS Power cutback at all the other loops
    // for Geminax 7.11 & 7.12 FW  to enhance the US performence (by reducing echo).
    // except if it is a cabinet mode application where tones start above 255.
    //ADSLRTFW-1580 Perf_DS_BisPlus_ALL_ImpDsPcb (Start_End) // This was using 1900m
    // XDSLRTFW-754 Perf_DS_Plus_ALL_AdjDsPcb (Start_End) // Changed to 2100m
    // XDSLRTFW-2xxx (Start)
    // Revisit for VRx518 basd on testing
#if 0
    int16 s_majorVer, s_minorVer;
    if (gs_LowestMinPCB == 0)
    {

       if ((gs_CurrentCoChipset == IFTN_CO_CHIPSET) && (gs_firstSupportedTone < 255))
       {
          s_majorVer = ((gs_CurrentCoVendorID>>12)&0xf);
          s_minorVer = ((gs_CurrentCoVendorID>>4)&0xff);

          // minimum PCB is limited only for LQ-CO and non-cabinet configurations
          //
          //                               | gs_LowestMinPCB
          //    Looplength   |  Noise      |  Gmx CO 7.11/7.12  | Vinax 0x9051  | all other LQ COs   |
          //  ---------------|-------------|--------------------|---------------|--------------------|
          //          0 m    | -140/-130WN |           3 dB     |      3 dB     |          3 dB      |
          //       2000 m    | -140/-130WN |           3 dB     |      3 dB     |          3 dB      |
          //       2200 m    | -140/-130WN |           1 dB     |      2 dB     |          0 dB      |
          //       4000 m    | -140/-130WN |           1 dB     |      2 dB     |          0 dB      |
          //  ---------------|-------------|--------------------|---------------|--------------------|
          //          0 m    | strong noise|           1 dB     |      0 dB     |          0 dB      |
          //       2000 m    | strong noise|           1 dB     |      0 dB     |          0 dB      |
          //       2200 m    | strong noise|           1 dB     |      0 dB     |          0 dB      |
          //       4000 m    | strong noise|           1 dB     |      0 dB     |          0 dB      |
          //  ---------------|-------------|--------------------|---------------|--------------------|

          if ( (s_majorVer == 0x7) && (s_minorVer == 0x11) || (s_minorVer == 0x12) )
             gs_LowestMinPCB = 1 ;      /* only for Gmx CO 7.11 & 7.12 FWs */

          if (    (STATArray[STAT_Performance] & STAT_M140WhiteNoise)
               || (STATArray[STAT_Performance] & STAT_M130WhiteNoise))
          {
             if (gs_hsk_tone_power_dB > MINIMUM_GHS_TONE_PWR_AT_1900M) // Less than 1900m
                gs_LowestMinPCB = 3 ;          /* for all versions of Gmx CO FWs */

             else if ((guca_fe_G9941_VendorID[6] ==  VINAX_FW_VERSION_10_6_BYTE6)
                       && (guca_fe_G9941_VendorID[7] ==  VINAX_FW_VERSION_10_6_BYTE7)
                     )
             {
                // On long white-noise loops the US performance is too low because of echo effects
                // reduce the echo and increase the US performance by applying 2dB DS-PCB
                // With Annex BJ hybrid ran some loop reach and with different noise scenarios and captured the following
                //LoopLength   gs_hsk_tone_power_dB
                //2000m        3216
                //2100m        3075
                //2200m        2ef9
                //2300m        2d58
                //2400m        2bd8
                //2500m        2a4b
                gs_LowestMinPCB = 2 ;      /* 2dB PCB on long White noise loop to increase US performance against Vinax */
             }
          }
       }
    }
    // XDSLRTFW-2xxx (End)
#endif

    // XDSLRTFW-2065_XDSLRTFW-2068(Start)
    // Sriram: To improve DS Data rate in ReTx mode, don't apply DS-PCB. We don't see DS CRC under FB-noise case.
    if((gt_ReTxConfigInfo.ft_ReTxOn == 1) && (s_minPCB > 0) && (gft_StrongNoiseForDsPcb == TRUE))
    {
       s_minPCB = 0;   // Don't Apply DS-PCB in ReTx Mode
    }
    // XDSLRTFW-2065_XDSLRTFW-2068(End)

    s_minPCB += (gs_PCB_DS_Delta_bis + gs_PcbDsDeltaForNotch)  ;

    // PERF_DS_PLUS_ALL_GeneralizedPcb (End)
   // XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(Start)
   if ((gs_CurrentCoChipset == IKNS_CO_CHIPSET)                                                          // ChipSet
         &&(gt_HandshakeBis.sa_DS_MaxLatencyBC[LP0_DATA_PATH] == 1)                                                  // Fast Path
         &&(gl_SelectedMode == (MODE_G992_5 | ANNEX_A))                                                     // Adsl2+ mode
         && ((gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_DB_0M)&&( gs_hsk_tone_power_dB > MINIMUM_GHS_TONE_PWR_DB_500M ))    // Loop Length
         && (gft_M140WhiteNoise_ShortLoop == TRUE)
         && (s_minPCB!=0))                                                       // 140dBm White Noise

   {
      s_minPCB += gs_Add_minPCB_NVLT ;
   }
   // XDSLRTFW-1214:IOP_DS_Plus_IKNS_ShortLoopDSCRC(end)
   //Cap maximum DSPCB to 12dB always
   if(s_minPCB > gs_HighestMinPCB)
      s_minPCB = gs_HighestMinPCB;
   if(s_minPCB < gs_LowestMinPCB)
      s_minPCB = gs_LowestMinPCB;

    gt_RMsgPcb_bis.us_R_MIN_PCB_DS = s_minPCB ;
    guc_BkgdTaskState = TRAINING_DONE;
}
#endif //   oPOTS ends here
