/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             DetectComb.c
 * DESCRIPTION:      Functions for detecting the C-COMB symbols.
 *
 **********************************************************************/

#include "common.h"
#include "const_bis.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "mul.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: DetectComb
 *
 *  Description: Detects whether the input signal is a C-COMB symbol or not.
 *
 *  Prototype: int16 DetectComb(int16 *psa_Comb_Ref, int16 s_offset);
 *
 *  Input Arguments:
 *      int16 *psa_Comb_Ref      - pointer to the C-COMB reference signal
 *                                 accumulated during C-COMB2.
 *      int16 s_offset           - offset of the beginning of the reference in psa_Comb_Ref
 *
 *  Output Arguments:
 *
 *  Return value:
 *          C_COMB_DETECTED        if C-COMB is detected
 *          C_ICOMB_DETECTED       if C-ICOMB is detected
 *
 *  Global Variables Used:
 *      gsa_RxToneBuf[]          - (I) output of FDQ, compare with PN sequence
 *
 *------------------------------------------------------------------------
 *^^^
 */

C_SCOPE int16 DetectComb(int16 *psa_Comb_Ref, int16 s_offset)
{
    int s_C_COMB_Matches;
    int s_count;
   int16 s_index;
   int32 l_innerproduct, l_temp;
    uint8 uc_C_COMB_DETECTION_THRESHOLD;

   psa_Comb_Ref += s_offset;
   s_C_COMB_Matches = 0;
    uc_C_COMB_DETECTION_THRESHOLD = guc_NUM_OF_BINS_FOR_COMB_DETECTION>>1;

    /* ============================================================= */
    /*  Compare the received signal with the C-COMB reference.       */
    /*  Increment s_C_COMB_Matches when a bin matches the reference. */
    /* ============================================================= */

   for (s_count = 0; s_count < guc_NUM_OF_BINS_FOR_COMB_DETECTION; s_count++)
   {
      s_index = 2 * gsa_COMB_ICOMB_DetectionBins[s_count];

      MULS16(l_innerproduct,  gsa_RxToneBuf[s_index] , psa_Comb_Ref[s_index++]); // Product of real components
      MULS16(l_temp,gsa_RxToneBuf[s_index], psa_Comb_Ref[s_index]);
      l_innerproduct += l_temp ; // Add product of imag components

      // Check if this freq bin matches C-COMB
      if (l_innerproduct > 0)
         s_C_COMB_Matches++;                    // This bin matches C-COMB
   }

    /* Determine which signal is detected */

    if (s_C_COMB_Matches > uc_C_COMB_DETECTION_THRESHOLD)
      return C_COMB_DETECTED;
   else
      return C_ICOMB_DETECTED;
}
