/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   FormRParams_bis.c
*
*-------------------------------------------------------------------------
*/
// =======================================================================================================
//  FormRParams_bis.c
//
// History
//
//
// 05/08/2010 Nihar : In the R PARAMS message octet 8 if MSB bit set to One if erasure decoding is
//             not used on the downstream latency paths.If MSB bit is set Zero, then R-Params
//             report support for erasure decoding
//                Grep for Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting
//
//15/03/2012 Kannan: 09/04/2009 Bhadra: Added code for uinversal ReTx R-PARAMS related changes
//                     Grep for SMS01436582:FEATURE_ALL_BisPlus_ALL_Univ_Retx_PARAMs_mod to see changes.
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Modified enable/disable of Erasuredecoder logic as per VRx Msg Spec through "CMV DSL 1 0"
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
// =======================================================================================================
#include "common.h"
#include "const_bis.h"
#include "tx_ops2.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "typedef.h"
#include "Scramble_bis.h"
#include "tone_ord.h"
#include "tx_ops_bis.h"
#include "dsp_op.h"
#include "bitload.h"
#include "cmv.h"
#ifdef DEBUG_STREAMING
#include "DebugBuffer.h"
#endif

/*^^^
*------------------------------------------------------------------------
*
*  Name : BgFormRParams
*
*  Description: This routine packs message R_PARAMS into array guca_R_PARAMS_bis[]
*
*  Prototype:
*        void BgFormRParams();
*
*  Input Arguments:
*        -
*  Output Arguments:
*
*  Return:
*
*
*  Global Variables Used:
*  guca_R_PARAMS_bis[]  -  (I) Structure containing packed data
*  gsa_RxFineGains[] -  (I) Fine gain table
*  guca_RxBat[]      -  (I) Rx bit allocation table
*  gsa_RxToneOrder[] -  (I) Rx tone ordering table
*
*------------------------------------------------------------------------
*^^^
*/
void BgFormRParams(void)
{
    uint8 uc_temp, uc_Log2Dp, uc_tempR;
    int16 j, idx, s_NumPaddingZeros, temp;
    uint16 us_CRC;
    uint32 ul_scramble_state, ul_ATTDDR;

    int16 s_LEN_R_PARAMS_MESSAGE_BYTES;
    int16 s_LEN_R_PARAMS_BITS;
    int8  ft_prevent_from_crashing = 0;

    if (( gl_SelectedMode & (MODE_G992_5)  )) // if plus mode
    {
        s_LEN_R_PARAMS_MESSAGE_BYTES = (13 + 3 + 2*(gs_RxNumTones-1) + 2*(gs_RxNumTones-1)) + LEN_R_PARAMS_PMS
        + LEN_R_PARAMS_CRC;
    }
    else
    {
        s_LEN_R_PARAMS_MESSAGE_BYTES = (13 + 2 + 2*(gs_RxNumTones-1) + (gs_RxNumTones-1)) + LEN_R_PARAMS_PMS
        + LEN_R_PARAMS_CRC;
    }

    s_LEN_R_PARAMS_BITS = s_LEN_R_PARAMS_MESSAGE_BYTES * 8;

    temp = s_LEN_R_PARAMS_BITS;
    gs_R_Params_Frame_Len = temp/(2*gs_NSC_RParams);
    if((gs_R_Params_Frame_Len*2*gs_NSC_RParams) < s_LEN_R_PARAMS_BITS)
    gs_R_Params_Frame_Len++;

    // At the end of tone-ordering, performed above, we have the gsa_RxToneOrder[] table
    // to be G.DMT compatible, i.e., all tones with zero bits come first, followed by
    // tones with one (if TCM is on) or two bits next, followed by tones with three, four,
    // etc,. upto 15 bits, in that order.

    // Create R_Params message
    /* PMD parameters */

    // loop attenuation
    guca_R_PARAMS_bis[0] = guc_LoopAtten_LSB;
    guca_R_PARAMS_bis[1] = guc_LoopAtten_MSB;

    // signal attenuation
    guc_SigAtten_LSB = (uint8)(gt_NearEndParam.us_SignalAttenuation & 0xFF);
    guc_SigAtten_MSB = (uint8)((gt_NearEndParam.us_SignalAttenuation >> 8) & 0x3);
    guca_R_PARAMS_bis[2] = guc_SigAtten_LSB;
    guca_R_PARAMS_bis[3] = guc_SigAtten_MSB;

    // Octets 4,5 (representing DS SNR margin with 0.1dB granularity)
    temp = FormSNRM(gs_RxAvMargin);

    guca_R_PARAMS_bis[4] = (uint8)(temp & 0xFF);
    guca_R_PARAMS_bis[5] = (uint8)((temp >> 8) & 0xFF);

    // Octets 6-9(Attainable net data rate)
    ul_ATTDDR = (uint32) gl_ATTNDRds_Initial;
    guca_R_PARAMS_bis[6] = (uint8)(ul_ATTDDR & 0xFF);
    guca_R_PARAMS_bis[7] = (uint8)((ul_ATTDDR>>8) & 0xFF);
    guca_R_PARAMS_bis[8] = (uint8)((ul_ATTDDR>>16) & 0xFF);
    guca_R_PARAMS_bis[9] = (uint8)((ul_ATTDDR>>24) & 0xFF);

    // Actual aggregate transmit power
    guc_ACTATP_LSB = (uint8)(gt_NearEndParam.s_ActualAggregateXmtPwr & 0xFF);
    guc_ACTATP_MSB = (uint8)((gt_NearEndParam.s_ActualAggregateXmtPwr >> 8) & 0xFF);  //include sign bit extention
    guca_R_PARAMS_bis[10] = guc_ACTATP_LSB;
    guca_R_PARAMS_bis[11] = guc_ACTATP_MSB;

    for (j=0; j< 12; j++) {
        guca_R_PARAMS_bis_sav[j] = guca_R_PARAMS_bis[j]; // Save above messages before they are scambled.
    }


    guca_R_PARAMS_bis[12] = gft_TcmFlag_bis_DS; // ds tcm support

    if (gft_TcmFlag_bis_DS){
        STATArray[STAT_Misc] |= STAT_TCM_DS;
    }

    guca_R_PARAMS_bis[13] = 0; // reserved byte.

    idx =14;

    // Because the computation takes so long, fine gains are computed and stored
    // into guca_R_PARAMS_bis[] during Rx showtime initialization (Medley).
    idx += 2*(gs_RxNumTones-1);

    guca_R_PARAMS_bis[idx++] = 0x00; // reserved byte

    if (( gl_SelectedMode & (MODE_G992_5)  ))
    guca_R_PARAMS_bis[idx++] = 0x00; // reserved byte

    // Put tone ordering table...
    for(j=1; j< gs_RxNumTones; j++) { // start from tone 1 to 255

        if (( gl_SelectedMode & (MODE_G992_5)  ))
        {
            guca_R_PARAMS_bis[idx++] = (uint8)(gsa_RxToneOrder[j] & 0xFF);
            guca_R_PARAMS_bis[idx++] = (uint8)(gsa_RxToneOrder[j] >> 8);
        }
        else
        guca_R_PARAMS_bis[idx++] = (uint8)gsa_RxToneOrder[j];
    }

    /* PMS parameters */
    // workaround to prevent old Geminax FW (07.0F.03) from Crashing
    // (1). In Geminax FW (07.0F.03),  Function FormCParams cannot take a gt_rx_config with zero values.
    // The function hangs if gt_rx_config_s_Dp = 0  since it tries to compute log(D).
    // Here Danube FW sets some PMS parameters (expecially Dp !=0) to prevent this catastrophe.
    // (2). Geminax cannot handle the case if CPE failed bitloading,
    // (a). Its state machine goes into showtime  without configuring showtime variables.
    // (b)  Its state machine tries to configure Iridia with junk values on C_SEGUE4 and it still enables
    // Iridia before showtime.
    // The workaround is to set illegal parameters (Lp = 7) and lets geminax fail in PMS parameter check.
    //  Set some PMS parameters  even though we won't do showtime, for compatibility with legacy dslam.
    if (gus_BitloadExceptionCode !=0 && gs_CurrentCoChipset ==  IFTN_CO_CHIPSET)
    {
        ft_prevent_from_crashing =1;
        gt_rx_config.s_Mp[LP0_DATA_PATH] = 1;
        gt_rx_config.s_Dp[LP0_DATA_PATH] = 1;
        gt_rx_config.s_Tp[LP0_DATA_PATH] = 1;
        gt_rx_config.s_Lp[LP0_DATA_PATH] = 7;
        gt_rx_config.sa_Bpn[LP0_DATA_PATH][0] =1;
    }

    if(gs_InitFailCauseNearEnd ==0 || ft_prevent_from_crashing)
    {
        guca_R_PARAMS_bis[idx]   = (gs_InitFailCauseNearEnd & 0xF)<<4;   /* Near end initialization sucess/failure code */
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
      //SMS01436582:FEATURE_ALL_BisPlus_ALL_Univ_Retx_PARAMs_mod Start
      //FEATURE_DS_BisPlus_ALL_FrameWorkForReTxDisableOption (Start_End)
      if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
      {

         idx++;
         guca_R_PARAMS_bis[idx++] = (uint8) (0x1F); //octet 1 (reserved value:0x1F )
         guca_R_PARAMS_bis[idx++] = (uint8) (0xFF); //octet 2 (reserved value:0xFF)
      }
      else
      {
         guca_R_PARAMS_bis[idx++] |= (uint8) ((gt_rx_config.s_MSGlp) & 0x3); //Octet 0
         guca_R_PARAMS_bis[idx++] =
         ((guca_rxBCnToLPp[0] & 0xF) << 4) | (guca_rxBCnToLPp[1] & 0xF); //Octet 1
         guca_R_PARAMS_bis[idx++] =
         (uint8)(((BC2_TO_LATENCYPATH_DS & 0xF) << 4) | (BC3_TO_LATENCYPATH_DS & 0xF)); //octet 2

      }
      //SMS01436582:FEATURE_ALL_BisPlus_ALL_Univ_Retx_PARAMs_mod End
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

        guca_R_PARAMS_bis[idx++] = (uint8)(gt_rx_config.s_MSGc);
        guca_R_PARAMS_bis[idx++] = (guca_rxBCnToLPp[0] != 0xF)? (uint8)(gt_rx_config.sa_Bpn[guca_rxBCnToLPp[0]][0]): 0;
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
      //SMS01436582:FEATURE_ALL_BisPlus_ALL_Univ_Retx_PARAMs_mod Start
      if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
      {
      guca_R_PARAMS_bis[idx++] = 0; //octet 5 reserved
      }
      else
      //SMS01436582:FEATURE_ALL_BisPlus_ALL_Univ_Retx_PARAMs_mod End
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END
        guca_R_PARAMS_bis[idx++] = (guca_rxBCnToLPp[1] != 0xF)? (uint8)(gt_rx_config.sa_Bpn[guca_rxBCnToLPp[1]][1]): 0;
        guca_R_PARAMS_bis[idx++] =  0;          // Bpn for n=2
        guca_R_PARAMS_bis[idx++] =  0;          // Bpn for n=3

        for (j = 0; j < 2; j++)
        {
         //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
         //SMS01436582:FEATURE_ALL_BisPlus_ALL_Univ_Retx_PARAMs_mod (Start)
         if((j == 1) && (gt_ReTxConfigInfo.ft_ReTxOn == 1))
         {
            guca_R_PARAMS_bis[idx++] = 1;//Mp =1 for latency path# 1 of DTU framing type 1
            guca_R_PARAMS_bis[idx++] = 0;//Tp =0 for latency path# 1 of DTU framing type 1
         }
         else
         {
            // SMS00847294:Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting (Start)
            //XDSLRTFW-1502 (start_end)
            if (gt_ErasureDecoding_Reprt.ft_Report_ED == TRUE)
            {
               //SMS00855449 CR_DS_ALL_ALL_MoveErasureDecoderControlsToDSLgroup (Start_End)
               //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
               if ((gs_DSL_EDcontrol & ERASURE_DECODING_ENABLE) == 0)
                {
                  /*ONE: erasure decoding is not used*/
                  guca_R_PARAMS_bis[idx++] = ((uint8) gt_rx_config.s_Mp[j] | 0x80);
               }
               else
               {
                  /*ZERO: erasure decoding is used*/
                  guca_R_PARAMS_bis[idx++] = (uint8) (gt_rx_config.s_Mp[j] & ( 0x7F)); // Look for the 7th bit
               }
            }
            else
            {
               guca_R_PARAMS_bis[idx++] = (uint8) gt_rx_config.s_Mp[j];
            }
            // SMS00847294:Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting (End)
               guca_R_PARAMS_bis[idx++] = (uint8) gt_rx_config.s_Tp[j];
         }//if(j==1 && ReTx ON)
         //SMS01436582:FEATURE_ALL_BisPlus_ALL_Univ_Retx_PARAMs_mod (End)
         //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END
            uc_temp = (uint8)(gt_rx_config.s_Dp[j]);

            if (gt_rx_config.s_Dp[j] <= 64)  //if D <= 64
            {
                uc_temp = (uint8)(gt_rx_config.s_Dp[j]);
                uc_Log2Dp = 0;
                while (uc_temp > 1)
                {
                    uc_temp >>= 1;
                    uc_Log2Dp++;
                }

                guca_R_PARAMS_bis[idx++] = (uint8)((gt_rx_config.s_Rp[j]<<3)|(uc_Log2Dp));// Rp and Dp
            }
            else if ((gt_rx_config.s_Dp[j] > 64) && (gt_rx_config.s_Dp[j] <=480))   // D > 64 and < 511
            {
                uc_Log2Dp = (gt_rx_config.s_Dp[j] >> 5) - 3;
                uc_tempR = (gt_rx_config.s_Rp[j] >> 1) - 1;
                guca_R_PARAMS_bis[idx++] = (uint8)((uc_Log2Dp<<4)|(uc_tempR) | (1<<3));// Rp and Dp
            }
            else if (gt_rx_config.s_Dp[j] == 511)  // D=511
            {
                uc_Log2Dp = 13;  // D = 511
                uc_tempR = (gt_rx_config.s_Rp[j] >> 1) - 1;
                guca_R_PARAMS_bis[idx++] = (uint8)((uc_Log2Dp<<4)|(uc_tempR) | (1<<3));// Rp and Dp

            }

            guca_R_PARAMS_bis[idx++] = (uint8)(gt_rx_config.s_Lp[j] & 0xFF);
            guca_R_PARAMS_bis[idx++] = (uint8)((gt_rx_config.s_Lp[j]>>8)&0xFF);  // msb of Lp
        } //for

      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
      //SMS01436582:FEATURE_ALL_BisPlus_ALL_Univ_Retx_PARAMs_mod (Start)
      if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
      {

         //FT: 00(without CRC) for the present
         guca_R_PARAMS_bis[idx++] = 0x00; // Octet18
         //Reed-Solomon codeword per DTU. 1 <= Q <= 16.
         guca_R_PARAMS_bis[idx++] = (uint8)((gt_ReTxConfigInfo.us_Q) & 0x7F);//Octet19
         //The number of padding octets per DTU. 0<=V<=15.
         guca_R_PARAMS_bis[idx++] = (gt_ReTxConfigInfo.us_V & 0xF); // Octet20
         //Delay in DTU between two consecutive transmissions of a
         //DTU used by the receiver in the reference state machine.
         // 1 <=Qtx<=63.
         if(gt_ReTxConfigInfo.us_Qtx != 0)
            guca_R_PARAMS_bis[idx++] = (uint8)(gt_ReTxConfigInfo.us_Qtx & 0xFF); // Octet21
         else{
            gt_ReTxConfigInfo.us_Qtx = 63;
            guca_R_PARAMS_bis[idx++] = (uint8)(gt_ReTxConfigInfo.us_Qtx & 0xFF); // Octet21
         }
         //The value of the look back value (lb) of the RRC channel.

         if(gt_ReTxConfigInfo.us_Lb_val == 0)
            gt_ReTxConfigInfo.us_Lb_val = 31;

         if(gt_ReTxConfigInfo.us_Qtx < gt_ReTxConfigInfo.us_Lb_val)
            gt_ReTxConfigInfo.us_Lb_val = gt_ReTxConfigInfo.us_Qtx;

         guca_R_PARAMS_bis[idx++] = gt_ReTxConfigInfo.us_Lb_val; // Octet22
         guca_R_PARAMS_bis[idx++] = 0; //Octet23 reserved
         guca_R_PARAMS_bis[idx++] = 0; //Octet24 reserved
         guca_R_PARAMS_bis[idx++] = 0; //Octet25 reserved
         guca_R_PARAMS_bis[idx++] = 0; //Octet26 reserved
         guca_R_PARAMS_bis[idx++] = 0; //Octet27 reserved

      }//gt_ReTxConfigInfo.ft_ReTxOn == 1
      else
      {
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
         guca_R_PARAMS_bis[idx++] = 0; //Octet23 reserved
         guca_R_PARAMS_bis[idx++] = 0; //Octet24 reserved
         guca_R_PARAMS_bis[idx++] = 0; //Octet25 reserved
         guca_R_PARAMS_bis[idx++] = 0; //Octet26 reserved
         guca_R_PARAMS_bis[idx++] = 0; //Octet27 reserved

         //SMS01436582:FEATURE_ALL_BisPlus_ALL_Univ_Retx_PARAMs_mod (End)
         guca_R_PARAMS_bis[idx++] = 0;          // Mp for p=3
         guca_R_PARAMS_bis[idx++] = 0;          // Tp for p=3
         guca_R_PARAMS_bis[idx++] = 0;          // Rp and Dp for p=3
         guca_R_PARAMS_bis[idx++] = 0;          // lsb of Lp for p=3
         guca_R_PARAMS_bis[idx++] = 0;          // msb of Lp for p=3
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
      } //SMS01436582:FEATURE_ALL_BisPlus_ALL_Univ_Retx_PARAMs_mod (Start End)
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)


   }
    else /* if(gs_InitFailCauseNearEnd !=0) */
    {
        guca_R_PARAMS_bis[idx++] = (gs_InitFailCauseNearEnd & 0xF)<<4;   /* Near end initialization sucess/failure code */

        for(j=0; j<(LEN_R_PARAMS_PMS -1); j++)
        guca_R_PARAMS_bis[idx++] =0;  /* Send out 0 for other PMS-TC bytes */

    }

#ifdef DEBUG_STREAMING
   memcpy(&guca_DSH_R_PARAMS_debug[0],&guca_R_PARAMS_bis[0], s_LEN_R_PARAMS_MESSAGE_BYTES-2);
   DSH_SendStream(DSH_R_PARAMS,s_LEN_R_PARAMS_MESSAGE_BYTES-2,&guca_DSH_R_PARAMS_debug[0]);
#endif

    /* Calculate CRC */
    us_CRC =0;

    for(j=0; j<(s_LEN_R_PARAMS_MESSAGE_BYTES-2); j++)
    CalcCRC16_Byte(&us_CRC, guca_R_PARAMS_bis[j]);

    guca_R_PARAMS_bis[idx++] = (uint8)(us_CRC & 0xFF); //LSB's of CRC
    guca_R_PARAMS_bis[idx++] = (uint8)(us_CRC >> 8);

    s_NumPaddingZeros = (2 * gs_NSC_RParams * gs_R_Params_Frame_Len - s_LEN_R_PARAMS_BITS) >> 3;
    for (j=0;j < s_NumPaddingZeros; j++)
    guca_R_PARAMS_bis[idx++] = 0;   // pad with zeros

    // Scramble message
    ul_scramble_state = 0xFFFFFFFF;
    Scramble_BIS(guca_R_PARAMS_bis, (int16)(s_LEN_R_PARAMS_MESSAGE_BYTES+s_NumPaddingZeros), &ul_scramble_state);

    guc_FormRParamsState = TRAINING_DONE;
}

