/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*
*   Gen_PNMedley_14thorder.c
*
*
*
*-------------------------------------------------------------------------
*/
#include "common.h"
#include "const_bis.h"
#include "tx_ops2.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "typedef.h"
#include "crc16.h"
#include "dsp_op.h"


/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*  Description:
*  Generate 14th order Medley PN sequence of length s_Length (in bytes),
*  stored in puca_Buffer
*  Medley PN Sequence is defined as d[n] = d[n-5] (xor) d[n-11] (xor) d[n-12] (xor) d[n-14]
*  Return:
*     none
*
*
*-----------------------------------------------------------------------------
^^^*/
C_SCOPE void Gen_PNMedley_14thOrder(uint8 *puca_Buffer, int16 s_Length, uint32 *pul_State, FlagT ft_skip_flag) {

   uint32 ul_mm0, ul_mm2, ul_mm3, ul_mm4;
   int16 i, s_skip_count = 0;

   ul_mm0 = *pul_State;       /* ul_mm0 has bits y(-32) to y(-1) */
   for(; (s_Length>0); s_Length--)
   {
      if (ft_skip_flag == FALSE)
         *puca_Buffer = 0;

      for(i=0; i<8; i++)            /* perform one bit at a time */
      {
         if (ft_skip_flag == TRUE)
         {
            s_skip_count++;
            if(s_skip_count == 14)  /* first 14 bits are initialized to 1, hence skip them */
               ft_skip_flag = FALSE;

         }
         else
         {
            /* generate from 15th bit onwards */
            ul_mm2 = ul_mm0 >> 4;      /* ul_mm2 has bit y(-5) in the lsb */
            ul_mm3 = ul_mm0 >> 10;     /* ul_mm3 has bit y(-11) in the lsb */
            ul_mm3 ^= ul_mm2;       /* y(n-5) (xor) y(n-11) */

            ul_mm2 = ul_mm0 >> 11;     /* ul_mm2 has bit y(-12) in the lsb */
            ul_mm4 = ul_mm0 >> 13;     /* ul_mm4 has bit y(-14) in the lsb */
            ul_mm4 ^= ul_mm2;       /* y(n-12) (xor) y(n-14) */

            ul_mm3 ^= ul_mm4;       /* y(n-5) (xor) y(n-11) (xor) y(n-12) (xor) y(n-14) */

            ul_mm0 = ul_mm0 << 1;      /* make room for the new state */
            ul_mm3 &= 0x1;          /* select only one bit */
            ul_mm0 |= ul_mm3;

            *puca_Buffer |= (uint8) (ul_mm3 << i);
         }
      }
      puca_Buffer++;
   }

   *pul_State = ul_mm0;
}











