/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             GenerateComb.c
 * DESCRIPTION:      Functions for generating the R-COMB signal in G.dmt.bis.
 *
 **********************************************************************/

#include "common.h"
#include "const_bis.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "pn_tab.h"
#include "memsetbf.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: GenerateComb
 *
 *  Description: Generates the R-COMB signal.
 *
 *  Prototype: void GenerateComb(int16 s_FirstChannel, int16 s_LastChannel, int16 s_Gain);
 *
 *  Input Arguments:
 *      int16 s_FirstChannel     - First channel to send R-COMB.
 *      int16 s_LastChannel      - Last channel to send R-COMB.
 *      int16 s_Gain             - Amplitude of the signal. Can be chosen to be
 *                                 negative to generate the R-ICOMB signal.
 *
 *  Global Variables Used:
 *      gsa_TxToneBuf[]          - (O) Tx Tone Buffer.
 *
 *------------------------------------------------------------------------
 *^^^
 */

C_SCOPE void GenerateComb(int16 s_FirstChannel, int16 s_LastChannel, int16 s_Gain)
{
    int16 s_ToneIndex, s_WordIndex, s_BitIndex, s_GainWithTssi;
   uint16 us_datum;

   /* Clear TX tone buffer first */
   MemSetBuffer(gsa_TxToneBuf, 0, 0, (int16)(sizeof(int16)*(2*gs_TxNumTones)));

   // Find the first channel which is a multiple of 6 and is not less than
   // s_FirstChannel.
   if((s_FirstChannel % 6) != 0)
      s_ToneIndex = s_FirstChannel + 6 - (s_FirstChannel % 6);
   else
      s_ToneIndex = s_FirstChannel;

   while(s_ToneIndex <= s_LastChannel)
   {
      // Scale s_Gain by t_ssi value, which has format 6.10. Round to nearest LSB.
      s_GainWithTssi = (int16)(((int32)s_Gain * gusa_US_Tssi_Value[s_ToneIndex] + (1<<9)) >> 10);

      s_WordIndex = s_ToneIndex >> 3;     // 2 bits are used for each channel
      s_BitIndex = (2*s_ToneIndex) & 0x0F;

      // Extract the 2 bits for the s_ToneIndex-th channel
      us_datum = (gusa_PN_US_Tab[s_WordIndex] >> s_BitIndex) & 0x03;

      if(us_datum == 0) {
         gsa_TxToneBuf[2*s_ToneIndex] = s_GainWithTssi;
         gsa_TxToneBuf[2*s_ToneIndex + 1] = s_GainWithTssi;
      }
      else if(us_datum == 2) {
         gsa_TxToneBuf[2*s_ToneIndex] = s_GainWithTssi;
         gsa_TxToneBuf[2*s_ToneIndex + 1] = -s_GainWithTssi;
      }
      else if(us_datum == 3) {
         gsa_TxToneBuf[2*s_ToneIndex] = -s_GainWithTssi;
         gsa_TxToneBuf[2*s_ToneIndex + 1] = -s_GainWithTssi;
      }
      else {
         gsa_TxToneBuf[2*s_ToneIndex] = -s_GainWithTssi;
         gsa_TxToneBuf[2*s_ToneIndex + 1] = s_GainWithTssi;
      }

      s_ToneIndex += 6;
   }
}
