/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   InterpolateLDInfo.c
*
*   Code that interpolates subsampled loop diagnostics data.
*
*-------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata_bis_diag.h"
#include "cmv.h"
#include "gpersistent.h"

/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void InterpolateLDInfo(int16 s_ToneCnt, uint8* puca_MsgIn, uint8* puca_MsgOut, int16 s_DataPointSize, int16 s_OutOfRange)
*
*   Abstract:
*
*   Input Parameters:
*
*  Output Parameter: none
*
*-----------------------------------------------------------------------------
^^^*/
C_SCOPE void InterpolateLDInfo(int16 s_ToneCnt, uint8* puca_MsgIn, uint8* puca_MsgOut, int16 s_DataPointSize, int16 s_OutOfRange)
{
   int16 i;
   int16 s_InOffset;
   int16 s_Real1;
   int16 s_Imag1;
   int16 s_Real2;
   int16 s_Imag2;

   /* Get the offset in the input array for the current data point. */
   s_InOffset = s_ToneCnt;
   if (( gl_SelectedMode & (MODE_G992_5)  ))
   {
      s_InOffset >>= 1;
   }
   s_InOffset *= s_DataPointSize;

   if ((!(( gl_SelectedMode & (MODE_G992_5)  ))) || ((s_ToneCnt & 0x1) != 0))
   {
      for (i = 0; i < s_DataPointSize; i++)
      {
         puca_MsgOut[i] = puca_MsgIn[s_InOffset + i];
      }
   }
   else
   {
      if (s_ToneCnt == 0)
      {
         s_Real1 = s_OutOfRange;
         s_Imag1 = s_OutOfRange;
      }
      else
      {
         s_Real1 = (int16)puca_MsgIn[s_InOffset];
         s_Real2 = (int16)puca_MsgIn[s_InOffset-s_DataPointSize];
         s_Imag1 = 0;
         s_Imag2 = 0;

         if (s_DataPointSize > 1)
         {
            s_Real1 |= ((int16)puca_MsgIn[s_InOffset+1] << 8);
            s_Real2 |= ((int16)puca_MsgIn[s_InOffset-s_DataPointSize+1] << 8);

            if (s_DataPointSize > 2)
            {
               s_Imag1 = (int16)puca_MsgIn[s_InOffset+2];
               s_Imag1 |= ((int16)puca_MsgIn[s_InOffset+3] << 8);
               s_Imag2 = (int16)puca_MsgIn[s_InOffset-s_DataPointSize+2];
               s_Imag2 |= ((int16)puca_MsgIn[s_InOffset-s_DataPointSize+3] << 8);
            }
         }

         if ((s_Real1 == s_OutOfRange) || (s_Real2 == s_OutOfRange))
         {
            s_Real1 = s_OutOfRange;
         }
         else
         {
            /* Average in 32 bit precision to avoid overflows. */
            s_Real1 = (int16)(((int32)s_Real1 + (int32)s_Real2 + 0x1) >> 1);
         }
         if ((s_Imag1 == s_OutOfRange) || (s_Imag2 == s_OutOfRange))
         {
            s_Imag1 = s_OutOfRange;
         }
         else
         {
            /* Average in 32 bit precision to avoid overflows. */
            s_Imag1 = (int16)(((int32)s_Imag1 + (int32)s_Imag2 + 0x1) >> 1);
         }
      }

      puca_MsgOut[0] = (uint8)(s_Real1 & 0xFF);
      if (s_DataPointSize > 1)
      {
         puca_MsgOut[1] = (uint8)((s_Real1 >> 8) & 0xFF);
         if (s_DataPointSize > 2)
         {
            puca_MsgOut[2] = (uint8)(s_Imag1 & 0xFF);
            puca_MsgOut[3] = (uint8)((s_Imag1 >> 8) & 0xFF);
         }
      }
   }
}
