/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*
*   ParamsSig_bis.c
*
*
*
*-------------------------------------------------------------------------
*/
#include "common.h"
#include "const_bis.h"
#include "tx_ops2.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "typedef.h"
#include "DeScramble_bis.h"
#include "tone_ord.h"
#include "tx_ops_bis.h"
#include "dsp_op.h"
#include "bitload.h"
#include "cmv.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RxParamsSig
 *
 *  Description: Decodes a DMT symbol of R_C_PARAMS.
 *
 *
 *  Prototype:
 *       void RxParamsSig(int16 *psa_ToneBuf, int16 s_SymbolCount,
 *             uint16 *us_CRC_computed);
 *
 *  Input Arguments:
 *    *psa_ToneBuf            - (I) Tone buffer with received DMT symbol
 *    *s_SymbolCount          - (I) Symbol count
 *    *us_CRC_computed        - (I/O) Computed Message CRC
 *
 *  Output Arguments:
 *
 *  Return:
 *    TRUE if R_C_PARAMS has been received and CRC computed
 *    FALSE if we're not done yet
 *
 *  Global Variables Used:
 *    gs_NSC_CRParams[]       - (I) Number of carriers chosen
 *    gusa_Tones_RMsg2[]      - (I)  Indexes of tones for transmitting C-PARAMS messages.
 *    guca_R_C_Params_bis[] - (O) Decoded and unscrambled message
 *  Notes:
 *    IMPORTANT: ROUTINE ASSUMES THAT gs_NSC_CRParams IS A MULTIPLE OF 4!
 *    OTHERWISE, INCORRECT RESULTS MAY ARISE!!
 *
 *------------------------------------------------------------------------
 *^^^
 */

void RxParamsSig(int16 *psa_ToneBuf, int16 s_SymbolCount,
               uint16 *pus_CRC_computed)
{
   int16 i, s_bitnum, s_arrbitpos, s_bytenum,
      s_bytenuminit,s_numDecodedBytes;
   uint16 us_infobit;

   /* Extract bits from (s_Symbolcount * NSC_C_PARAMS * 2) to
      (s_Symbolcount * NSC_C_PARAMS * 2) + NSC_C_PARAMS * 2 -1
   */
   s_bitnum = ((s_SymbolCount * NSC_C_PARAMS)<<1);
   s_bytenum = (s_bitnum >> 3);
   s_bytenuminit = s_bytenum; // keep for later processing
   s_arrbitpos = (s_bitnum & 0x07); // position in decoded array
   s_numDecodedBytes = (NSC_C_PARAMS >> 2); // number of bytes in symbol

   // Above check is redundant: since NSC_C_PARAMS is multiple of 4, we'll always have
   // that s_arrbitpos = 0 and we extract an integer number of bytes from tone buffer


    for(i=0; i < NSC_C_PARAMS; i++)
   {
      // Decode QPSK symbol
      us_infobit = (uint16)(psa_ToneBuf[gusa_Tones_RMsg2[i]<<1] < 0); // a received signal zero is encoded as a +(0)
      s_bytenum = (s_bitnum >> 3);
      s_arrbitpos = (s_bitnum & 0x07); // position in decoded array
      guca_R_C_PARAMS_bis[s_bytenum] |= (uint8)(us_infobit << s_arrbitpos);
      // decode second bit
      s_arrbitpos++;
      us_infobit = (uint16)(psa_ToneBuf[(gusa_Tones_RMsg2[i]<<1)+1] < 0); // a received signal zero is encoded as a +(0)
      guca_R_C_PARAMS_bis[s_bytenum] |= (uint8)(us_infobit << s_arrbitpos);
      s_bitnum+=2;
   }

}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : BgCrcComp()
 *
 * Description: This background routine first descramble the received
 *          C_PARAMS message, then compute the CRC.
 *
 *  Prototype:
 *       void BgCrcComp();
 *
 *  Input Arguments:
 *       -
 *  Output Arguments:
 *
 *  Return:
 *
 *
 *  Global Variables Used:
 * guca_R_C_PARAMS_bis[]  -   (I) Structure containing packed data
 * gus_RC_CRC_computed      - (I) Computedd CRC
 * gus_RC_CRC_received      - (I) Received CRC
 *
 *------------------------------------------------------------------------
 *^^^
 */


void BgCrcComp(void)
{
   int16 i, s_LEN_C_PARAMS_MESSAGE_BYTES;

    /* Descramble received the bytes */
   DeScramble_BIS(guca_R_C_PARAMS_bis, (int16)((gs_C_Params_Frame_Len*2*NSC_C_PARAMS)>>3), (uint32 *)(void *)&gul_RxDescrambleState);

   if (( gl_SelectedMode & (MODE_G992_5)  ))
      s_LEN_C_PARAMS_MESSAGE_BYTES = ((LEN_C_PARAMS_PMD_HEADER + 2 + 2*(gs_TxNumTones-1) + 2*(gs_TxNumTones-1)) + LEN_C_PARAMS_PMS + LEN_C_PARAMS_CRC);
   else
      s_LEN_C_PARAMS_MESSAGE_BYTES = ((LEN_C_PARAMS_PMD_HEADER + 1 + 2*(gs_TxNumTones-1) + (gs_TxNumTones-1)) + LEN_C_PARAMS_PMS + LEN_C_PARAMS_CRC);


   // calculate CRC only in bytes
   for (i= 0; i < (s_LEN_C_PARAMS_MESSAGE_BYTES-2); i++)
   CalcCRC16_Byte(&gus_RC_CRC_computed,guca_R_C_PARAMS_bis[i]);

   // Compute received CRC
   gus_RC_CRC_received = (int16)(guca_R_C_PARAMS_bis[s_LEN_C_PARAMS_MESSAGE_BYTES-2]);
   gus_RC_CRC_received |= (int16)(guca_R_C_PARAMS_bis[s_LEN_C_PARAMS_MESSAGE_BYTES-1] << 8);

   guc_CrcCalcState = TRAINING_DONE;
}


