/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RxfilterComp.c
*
*   function to compensate Rxfilter for test-parameters specific for
*  G.bis Diagnositics.
*
*-------------------------------------------------------------------------
*/

#include "gdata.h"
#include "stdio.h"
#include "cmv.h"
#include "gdata_bis_diag.h"
#include "diagparam_bis.h"
#include <string.h>                    //for memset

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RxFilterCompensate()
 *
 *  Description:  Compensates the Rx Filter effects from the received signal in dB Q9.7
 *          (This includes the PGA, Rxsystem Gain, and Rxfilter) and convert
 *                 to dBm/Hz or dBm.
 *
 *  Prototype:
 *    int16 RxFilterCompensate(int16 s_value_in, int16 s_pga, int16 s_dBmCompValue, int16 s_chan)
 *
 *  Input Arguments:
 *      int16  s_value_in     - input value at frequency sample to be compensated (dB) in Q9.7
 *    int16  s_pga         - PGA value to be compensated (dB) in Q9.7
 *    int16  s_dBmCompValue   - value to to be compensated to convert to dBm or dBm/Hz in (dB) Q9.7
 *    int16  s_chan        - tone number to be compensated
 *
 *  Output Arguments:
 *
 *  Return:
 *      int16 *s_pwr_db - result after compensation
 *
 *  Global Variables Used:
 *    gsa_Rxfilter_comp_dB    -- (I) Rx filter compensation in dB
 *
 *  Notes: dB operations performed in Q9.7 to handle lowest possible realistic values for QLN
 *
 *------------------------------------------------------------------------
 *^^^
 */

C_SCOPE int16 RxFilterCompensate(int16 s_value_in, int16 s_pga, int16 s_dBmCompValue, int16 s_chan)
{
   int16 s_pwr_db;

     // Rx system gain combined with gsa_Rxfilter_comp_dB compensate the system Rx filter
    s_pwr_db = s_value_in - (RxInvFiltCoef(s_chan) + TESTArray[TEST_OffsetRxCalibration]);

     //Estimate the US loop attenuation
     s_pwr_db -= s_pga;

     //convert to dBm/Hz
     s_pwr_db -= s_dBmCompValue;

    return(s_pwr_db);

}




