/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  Scramble_bis.c
;
;  This file contains the subroutine for doing scrambling.
;
;***************************************************************************/

#include "typedef.h"

/*****************************************************************************
;  Subroutine Name: Scramble_BIS
;
;  Description:
;     This subroutine scrambles the input data buffer according to
;     the following equation:
;
;     d'[n] = d[n] + d'[n-18] + d'[n-23]
;
;     where d[n] is input bit n, and d'[n] is output bit n.
;
;     This subroutine performs scramble byte by byte.
;
;  Prototype:
;     void Scramble_BIS(uint8 *puca_Buffer, int16 s_Length, uint32 *pul_State);
;
;  Input Arguments:
;     Buffer -- pointer to input data buffer
;     Length -- no. of bytes in input buffer
;     State -- pointer to the scramble state containing
;           bits d'(-32) to d(-1)
;
;  Output Arguments:
;     Buffer -- pointer to scrambled data buffer
;
;  Global Variables Used:
;     none
;
;****************************************************************************/
void Scramble_BIS(uint8 *puca_Buffer, int16 s_Length, uint32 *pul_State)
{
   uint32 ul_mm0,ul_mm1,ul_mm2,ul_mm3;

   ul_mm0 = *pul_State;
   for(; s_Length; s_Length--, puca_Buffer++)
   {
        /*  LSB_FIRST */
      /*  ul_mm0 has bits y(-1) to y(-32) */
      ul_mm1 = (uint32) *puca_Buffer;
      ul_mm2 = ul_mm0 >> 14;  /* ul_mm2 has bits y(-11) to y(-18) in the lsb */
      ul_mm3 = ul_mm0 >> 9;      /* ul_mm3 has bits y(-16) to y(-23) in the lsb */
      ul_mm0 = ul_mm0 >> 8;      /* make room for the new state */
      ul_mm3 ^= ul_mm2;
      ul_mm3 ^= ul_mm1;
      ul_mm3 &= 0xff;
      *puca_Buffer = (uint8) ul_mm3;
      ul_mm3 <<= 24;
      ul_mm0 |= ul_mm3;
   }
   *pul_State = ul_mm0;
}

