/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   bgdiagparam_bis.c
*
*   functions to calc or copy diag param test-parameters specific data for
*  G.bis Diagnositics.
*
*-------------------------------------------------------------------------
*/
//*******************************************************************
// bgdiagparam_bis.c
//
// History
//
//
// 20/03/2013 ChihWen: Bug fix to correctly report PSD and ACATP in DELT mode.
//            Grep for XDSLRTFW-917 / ADSLRTFW-1645 BugFix_All_DELT_All_PSD_ACATP
//
// 20/06/2013 Prashant: Bug fix to correctly report SATN in DELT mode.
//            Grep for XDSLRTFW-890 BugFix_DS_DELT_All_SATN
//
//*******************************************************************
#include "common.h"

#include "gdata.h"
#include "gdata_bis_diag.h"
#include "diagparam_bis.h"
#include <string.h>                    //for memset
#include "dsp_op.h"
#include "gdata_bis.h"
#include "showinit.h"
#include "CalcSigAttnDiag.h"

//extern uint8 guca_QLN[RX_NUM_TONES>>1];

void BgCalcDiagModeData(void)
{
   int16 s_nomatp_ds, s_actatp;
   uint16 us_sigattn;
   //XDSLRTFW-917 / ADSLRTFW-1645 BugFix_All_DELT_All_PSD_ACATP (START_END)
   int16 s_DEFAULT_MAXNOMATP_DS, s_DEFAULT_MAXNOMATP_US, s_nomatp_us;

   // Attainable net Data rate (ATTNDR)
   // Uses TARSNRM=6 with no coding gain for Diagmode
   gl_ATTNDRds_Initial =
      CalcATTNDR(gt_StateMachCntrl.psa_RXSNRBuf, LOOPDIAG_SNRM << 8, 0);

   //XDSLRTFW-917 / ADSLRTFW-1645 BugFix_All_DELT_All_PSD_ACATP (START)
   if (gl_SelectedMode & ANNEX_B)
      s_DEFAULT_MAXNOMATP_DS = DEFAULT_MAXNOMATP_DS_199;
   else
      s_DEFAULT_MAXNOMATP_DS = DEFAULT_MAXNOMATP_DS_204;

   // Compute Far-end Actual Aggregate Transmit Power (ACTATP) for R-PARAMS
   // no fine gains used in diagmode computation
   //s_nomatp_ds =
   //   CalcNOMATP(gt_TxPMDControl.s_NOMPSD_DS, (int16) DEFAULT_NOMPSD_DS, 0,
   //              NULL, 0x2000, gusa_DS_Tssi_Value, p_MEDLEYset_DS,
   //              gs_RxNumTones, &(gt_TxPMDControl.s_NOMPSD_DS_dBmHz));
   s_nomatp_ds =
      CalcNOMATP(gt_TxPMDControl.s_NOMPSD_DS, (int16) DEFAULT_NOMPSD_DS, s_DEFAULT_MAXNOMATP_DS,
                 NULL, 0x2000, gusa_DS_Tssi_Value, p_MEDLEYset_DS,
                 gs_RxNumTones, &(gt_TxPMDControl.s_NOMPSD_DS_dBmHz));

   //s_actatp = CalcACTATP(s_nomatp_ds, 0);
   s_actatp = s_nomatp_ds + s_DEFAULT_MAXNOMATP_DS - gt_TxPMDControl.us_pwr_cutback_DS * 10;
   if ((s_actatp < -511) || (s_actatp > 512))
         s_actatp = (int32) OUT_OF_RANGE_ACTATP;

   guc_ACTATP_LSB = (uint8)(s_actatp & 0xFF);
   guc_ACTATP_MSB = (uint8)((s_actatp>> 8) & 0xFF);  //include sign bit extention
   gt_NearEndParam.s_ActualAggregateXmtPwr = s_actatp;
   gt_TxPMDControl.s_NOMATP_DS = s_nomatp_ds;

      if (gl_SelectedMode & (ANNEX_B | ANNEX_I))
         s_DEFAULT_MAXNOMATP_US = DEFAULT_MAXNOMATP_US_133; /* absolute default DS MAXNOMATP*10 (0.1
                                                               dB step-size) */
      else if (gl_SelectedMode & ANNEX_J)
         s_DEFAULT_MAXNOMATP_US = DEFAULT_MAXNOMATP_US_134; /* absolute default DS MAXNOMATP*10 (0.1
                                                               dB step-size) */
      else
         s_DEFAULT_MAXNOMATP_US = DEFAULT_MAXNOMATP_US_125; /* absolute default DS MAXNOMATP*10 (0.1
                                                               dB step-size) */

      s_nomatp_us =
            CalcNOMATP(gt_TxPMDControl.s_NOMPSD_US, (int16) DEFAULT_NOMPSD_US, s_DEFAULT_MAXNOMATP_US,
                              NULL, 0x2000, gusa_US_Tssi_Value, gp_MEDLEYset_US,
                     gs_TxNumTones, &(gt_TxPMDControl.s_NOMPSD_US_dBmHz));

      s_actatp = s_nomatp_us + s_DEFAULT_MAXNOMATP_US - gt_TxPMDControl.us_pwr_cutback_US * 10;
    if ((s_actatp < -511) || (s_actatp > 512))
         s_actatp = (int32) OUT_OF_RANGE_ACTATP;
      gt_FarEndParam.s_ActualAggregateXmtPwr = s_actatp;
      gt_TxPMDControl.s_NOMATP_US = s_nomatp_us;
      //XDSLRTFW-917 / ADSLRTFW-1645 BugFix_All_DELT_All_PSD_ACATP (END)

   // Compute Signal Attenuation (SATN) (must compute after s_actatp)
   // no fine gains used in diagmode computation
   // XDSLRTFW-890 BugFix_DS_DELT_All_SATN (Start)
    us_sigattn =
      SignalAttenu_BIS(gsa_RxHlogDS, gt_StateMachCntrl.psa_RXSNRBuf, NULL,
                       s_nomatp_ds + s_DEFAULT_MAXNOMATP_DS);
   // XDSLRTFW-890 BugFix_DS_DELT_All_SATN (End)

   guc_SigAtten_LSB = (uint8)(us_sigattn & 0xFF);
   guc_SigAtten_MSB = (uint8)((us_sigattn >> 8) & 0x3);
   gt_NearEndParam.us_SignalAttenuation = us_sigattn;

   //No Need to memcpy anymore since message pointers were set equal to allocated arrays
   //Hlin
   //Do explicit memcopy here for data that will eventually be moved off-chip
   // Assumes consecutive memory storage for gpuca_RMSG2_LD through gpuca_RMSG5_LD
   //memcpy(gpuca_RMSG2_LD, (int8*)&gsa_RxMargin[0], 1024); //256*4 bytes

   //Qln
   //Do explicit memcopy here for data that will eventually be moved off-chip
   //memcpy(gpuca_RMSG8_LD, guca_QLN, gs_RxNumTones);

   guc_RxDataPumpState = TRAINING_DONE;
}
