/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   bitload_bis.c
*
*   Source code for PMS Parameter selection
*
*-------------------------------------------------------------------------
*/
// ************************************************************************
// bitload_bis.c
//
// History
//
// 22/07/2010 Bhadra/Vinjam Srinivas/Palaksha: Code changes to maximise the  DS SNRM instead of INP protection
//             (Min INP will be anyways will be met).
//             The changes includes changing Dp and Rp loops run from Min value to Max value instead of
//             Max to min values for Fixed and Limited rate cases.
//             Allotted a new CMV "INFO 103 20 0x40" to favour DS Margin over DS INP.
//             This change takes into effect only if Bit #6 in cmv INFO 103 20 is Set to 1
//             Grep for XDSLRTFW-139:SMS00839860 PERF_DS_BisPlus_DSmarginIncrease
//                or code pointer "CMV_INFX_DFE_FAVOR_MARGIN_OVER_INP_ENABLE"
//
// 23/07/2010 Nihar: In fast path, fixed data rate case, choose R=0 when interleaving
//                 is disabled (D=1). since the amount of coding gain we put for
//                 R != 0 with D=1 is much more than it can correct when a
//                 particular DMT symbol get corrupted with D=1.Hence choose R=0;
//                 This is applicable only when ReTx is disabled.
//                 Grep for IOP_DS_BisPlus_ALL_Fast_FixedRate_RSBytes_Zero
//
// 26/08/2010 Nihar: Workaround for AC7 h/w register bug
//                   Grep for IOP_DS_BisPlus_TIAC7_RegisterBug
//
// 22/08/2011 Vinjam: Report DS margin as 6 when it is 5.8 or 5.9
//              Grep for XDSLRTFW-275: SMS00842168 REPORT_DS_ALL_ALL_CeilDSmarginTo6dB
//
// 09/11/2011 Shakil/Bhadra: Downshift SRA was not performed due to Max Delay constraints. In certain interleaved
//             profiles LQ CPE trains with maximum Delay. When Downshift SRA is triggered line rate (Lp)
//             cannot decrease anymore as it will violate the max delay according to the following equations.
//             Sp = 8*NFEC/Lp
//             Delay = Sp*Dp/4 ms
//             proposed solution is to detect such cases after the first framing calculation and recalculate
//             the framing to incorporate the Downshift SRA into account so that we do not violate the delay
//             constraints after SRA completes. This algorithm is trigerred only if SRA is enabled and
//             max_delay > 1 ms (interleaved profile)
//             Grep for ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved
//
// 09/11/2011 ChihWen/Bhadra: The fix for "ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved":
//       1. The orginal code will start the searching (for max delta_Lp) from 2880, which will take very long time
//          to find the max delta_Lp and fail the training. The maximum allowed starting point (for max delta_Lp)
//          is set to 2000, which will take about 15384 symbols (from 12642 to 28026).
//       2. Considering the max_Lp (Lp + max_delta_Lp) and min_Lp (Lp - min_delta_Lp) before requesting SRA.
//       3. The searching for SRA will be enabled when it is BDCM CO or INFO 103 26 bitmask(0x0400) being one (it is zero by default).
//       Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
//
// 09/11/2011 ChihWen/Bhadra:a)Enabling one-step SRA against CNXT causing causing segmented SRA message.
//       For this message CNXT CO didn't respond. Limit sra_step of 0x7fff(Segmented message of One step SRA )
//       to BRCM only. And thus don't sent segmented SRA message to others.
//       Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
//
// 21/02/2012 Balabath:Too low DS Rate and too high DS SNRM in the SingTel
//            SRA Profile / ADSL2+ Mode / Huawei MA5600 / H568ADGG / BDCM Line card.
//            The reason for this is this DSLAM doesn't support extended interleaverdepths and 1/S0min is received
//            as 3. with SRA profiles and sraoffset set to 14 dB, and gs_deltaLp_max = 2400 as input
//            the framing parameters computed results very low Lp becasue of delay(1/S0min) constraints.
//             Similar behaviour is observed with other DSLAMs also in SRA profiles with cmv info 26 bit10(0x400)
//             and 1/S0min as 3 The solution is to force 1/S0min to 4 which results much higher Lp while entering showtime
//            And the meets 1/S0min constraints also.For results check the JIRA XDSLRTFW-422
//             Risk: CRC's may be observed becasue of 1/S0min voilations if HW support is not there in DSLAMs.
//           For code changes grep for XDSLRTFW-422 ENH_DS_BisPlus_All_SRAInterleaved_OneOverS0min
//
//  22/12/2011 AdeelJ/Balabath: Fix for "DS CRCs in Sparnex Long Loops at Telefonica"
//          DS CRCs observed in loop reach tests at long loops
//          In this file we check the looplength and increase the margin correction
//            in order to compensate for the loss of Data Rate incurred by increasing the
//            DS INP.
//              DS INP was increased to 1 in these cases as it was observed that the noise
//            causing CRCs has impulse like behavior.
//            This Change is protected by mode (ADSL2+) Annex (A), loop >= 2300m
//            and cmv (INFO 26 0 :0x0020)
//            In future check should be added for Sparnex Simulator
//          Grep for ADSLRTFW-1362 IOP_A_DS_Plus_ALL_TelefonicaSparnexDSCRCs
//
//  22/12/2011 Shakil/Balabath: Fix for a bug introduced with ADSLRTFW-1362 for Telefonica Spain
//          where we forced non-zero INP independant of fast or interleaved profile if
//          the selected mode was ADSL2p and loop lenghth >= 2.5km. As a result we saw link
//            holes in ADSL2p, fast path if the loop length >= 2.5km against all DSLAMs, since
//       in fast path R = 0, L = 8*R*D/INP = 0 giving Bitloading Exception. As a solution
//            we restricted the fix "ADSLRTFW-1362 IOP_A_DS_Plus_ALL_TelefonicaSparnexDSCRCs"
//            to interleaved profile only
//          Grep for XDSLRTFW-372 PERF_A_DS_Plus_ALL_LinkHoles_Fast_Long_Loop
//
// 07/02/2012 Shakil: Erasaure decoding feature was turned off by default which introduced CRCs in
//          the REIN test from Telefonica Spain in ADSL 2plus profile. As a sollution we enabled
//          erasure decoding feature and also make some small modification in the logic to easily
//          understand the code.
//          Grep for XDSLRTFW-399 ENH_DS_BisPlus_All_Enable_ErasureDecoding
//
//15/03/2012 Kannan: 16/04/2009 Bhadra: Added code for bitload related changes in Universal Retransmission (G.INP)
//                     Grep for SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad to see changes.
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// 04/06/2012 Shakil: New feature implemented where we detect REIN noise at training and change framing
//          accordingly taking erasure decoding into account to increase stability in presence of REIN
//          even if the minINP exchanged during GSK was not enough to sustain the REIN. The background
//          of this feature was a test requirement from FT EMC lab at Laneon where the minINP and maxdelay
//          configured was 2 and 16ms respectively whereas REIN in the line was 4-5 DMT symbol duration.
//          In the regular condition considering erasure we may protect maximum 3 DMT symbol REIN therefore
//          resulting huge DS CRCs and link drop. With the new feature we could dynamically detect REIN at
//          CSilent1 state during handshake and increase the INP taking erasure into account while cap the
//          delay maximum to 8 ms and achieved CRC free stable link without sacrifising too much data rate
//          since we also ignore REIN affected symbols before bitloading and medley SNR calculation.There are
//          two parts of the implmentation
//          1. Detect REIN during GSK and adapt framing  prior to bitloading at Medley. It is controlled by
//                INFO 103 28 bitmask 0x200 and disabled by default (bitmask 0x200-> 0 disabled, 1 enabled)
//          2. Ignore REIN affected symbols for bitloading: No CMV controlled. Enabled by default
//          Grep for XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING
//
// 25/04/2012 Kannan:
//          1. Moved ReTx Queue computation variable to datapumpsetup_rx.c
//             to compute ReTx Queue size dynamically based on the available
//             interleaver memory.
//
// 14/12/2012 Hanyu/Vinjam: Integrated "XDSLRTFW_523" changes to R5.2 mainline
//          Fixed low ATTANDRds issue when SRA is enabled in capped/fixed rate cases.
//          Replaced gs_RxDesiredMargin with gs_RxDesiredMargin_original from bitloading
//          since gs_RxDesiredMargin could be overwritten by gs_RxAvMargin in SRA,
//          which would cause lower ATTANDRds when gs_RxAvMargin is much higher than target margin in capped/fixed rate cases.
//              Grep for XDSLRTFW-632 XDSLRTFW_523 BugFix_DS_BisPlus_AB_All_UpdateATTNDRds_SRA
//
// 29/01/2013 ChihWen:
//          1. Modify reported ETR from 16-bit kbps format to 32-bit bps format.
//          2. Fix DS rate calculation when ReTx is on and Tp[1]=-1.
//          Grep for XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Modified enable/disable of Erasuredecoder logic as per VRx Msg Spec through "CMV DSL 1 0"
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 22/03/2013 Ram: Forcing L0 state Lp value to multiple of 8. See comments below for more details.
//                 Grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
//
// 28/03/2013 Ram: Merged fix for JIRA 625. Refer JIRA for more details
//                 Bug fix for the inaccurate computation of net data rate due to division.
//                 Grep for XDSLRTFW-625 BugFix_DS_ALL_AccurateDsRateComparison
//
//  23/05/2013 Anantha Ramu: Did modifications to set proper ATTNDR values in ReTx mode.
//                           Grep for: XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr
//
// 07/05/2013 Hanyu: Ported ChihWen: To avoid the lower DS sync-up rate against BDCM CO (in some SRA test cases), the searching for maximum gs_deltaLp_max
//                is modified to make DS rate not too much less than the original DS rate (when gs_deltaLp_max = 0).
//                The exact DS rate degradation can be controlled by OPTN 33 0, it is 5 by default, which means at most 5 percent rate degradation.
//            Grep for XDSLRTFW-930 ADSLRTFW-1517 ENH_DS_BisPlus_BDCM_SRA_EnhanceDsSyncUpRate

// 22/05/2013 Hanyu: Fixed low ATTNDRds issue against BRCM DSLAMs in ADSL2/2+ Annex A/M with SRA/capped rate/INP0.5/Delay10ms.
//            Grep for XDSLRTFW-930 IOP_DS_BisPlus_BDCM_SRA_lowATTNDRds
//
// 11/06/2013 Ram: Removed 'forcing L0 state Lp value to multiple of 8'. This was done as link drop was
//                 seen with BRCM in SRA enabled, Capped rate profile. See JIRA 986 for more details
//                 Grep for "XDSLRTFW-986: BugFix_ALL_BisPLus_ALL_BRCM_LinkDrop_SRAEnabled_CappedRate_Profile"
//
// 08/04/2013 ChihWen /Balabath:
//            Optimize the code for SRA, which are mainly as below.
//            1. Modify gs_MaxRateLp/gs_MinRateLp to be the max/min Lp complying to all framing constraints(including max/min net rate) when framing check is enabled(INFO 103 26 bitmask(0x400)),
//               gs_MaxRateLp/gs_MinRateLp will be the Lp with max/min net rate when framing check is not enabled.
//                2. Combine the framing check in "isValidFramingConfiguration" and "RShowtimeRxF_BIS". The combined framing check will refer to gs_MaxRateLp/gs_MinRateLp.
//                3. Optimize the CMV setting related to SRA.
//                4. Add two CMV to enable/disable the checking for min INP, and max delay when searching delta Lp in training.
//            Grep for XDSLRTFW-721 Enhance_DS_BisPlus_ALL_OptimizedSRACode
//
//  12/02/2013 Balabath:
//  LinkDrop after reaching showtime with lot of CRCs with VRX288 /DTAG W921 against Geminax. This is real line around 1200m .
//  Where as DTAG qualified versions 534A16_536412,534E16_536512 & 535416_536512 doesn't exhibit this behavior.
//  Remote debug session shows that this is very noisy line and R3.5 versions use R=16, which corrects the errors, and we have
//  only FEC and no CRCs whereas merge of ARx (ie.,ADSLRTFW-1011-Reed Solomon enabled in ADSL2/2+ Fast Path/Fixed rate configuration)
//  are causing R to be chosen as zero. In this line, chosing R non zero value was correcting errors. In this line there are
//  only dribbling CRCs ( RS encoder good enough) not burst of CRCs(interleaver must help here).
//  Solution: Restricting the fix to ANNEXA only for now(originally raised for AnnexA, My suggestion would be,we can remove this fix completely)
//  And for AnnexB, R3.5 is qualified without this fix.
//  For Changes grep for XDSLRTFW-1421.
//
// 04/02/2014 Balabath:XDSLRTFW-1489 -Low performance in Periodic noises immunity tests at Orange.
// We are using extra INP for LOW REIN cases, where REIN noise not effect the sysmbols. And also
// multiple bugs are corrected in Estimateimpulse, Estimateimpulse2 functions. and also consider
// the full value of "guc_impulse_noise_present " while considering the extra INP protection.
// guc_impulse_noise_present gives information about coarse impluse present are not, is it valid
// pps and Impulse power. for code changes grep for " XDSLRTFW-1489 "
//
// 11/02/2014 Balabath:XDSLRTFW-1561 - Improve performance in High level REIN cases at Orange FT
// Delay restriction to 8ms in REIN profile(along with CMV bit) is the reason for lower performance.
// But if we completely remove the delay restriction, Data rate is above 3Mbps and see lot of CRCs and linkdrop.
// Solution: Add an extra vaiable "gft_HighREIN_NOISE" during REIN analyis.
// This will be set to '1' if REIN power is above 50dB. Based on this variable add extra INP protection
// and also enable fractional INP frame work ( which is avaialable in R6 Maint or R7 brought up during SRA developemnt).
// for code changes grep for " XDSLRTFW-1561 "
//
// 04/01/2015 Anantha Ramu/TV Ram: Added fix for uncorrected DTUs due to Q full condition.
//            Grep for XDSLRTFW-1223
//
// 10/06/2015 Balabath: PPPoE connection cannot be established.
//       Min overhead data rate communicated as 6kbps. And CPE converges with 9 kbps as
//       ovserhead data rate. It seems there is some problem with NALT-J when ovhd data rate < 10kbps.
//
// 07/07/2015 Vinay: Initialized the value of ATTNDRds_Initial to the ATTNDR value computed from the
//            Medley SNR instead of NDR based calculation.
//            Grep for XDSLRTFW-2405
//
// 10/06/2015 Balabath: PPPoE connection cannot be established.
//       Data traffic is not established when DS data rate is capped to 2048.
//       Min overhead data rate communicated as 6kbps. And CPE converges with 9 kbps as
//       ovserhead data rate. It seems there is some problem with NALT-J when ovhd data rate < 10kbps.
//       So limit the min ovhd data rate as 32 kbps.
//    For code changes grep for XDSLRTFW-2376 /XDSLRTFW-2441
// *****************************************************************************************************************************************

#include "common.h"
#include "dsp_op.h"
#include "dsp_op2.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "bitload.h"
#include "bitload2.h"
#include "bitload_bis.h"
#include "mp.h"
#include "cmv.h"
#include "exchdata.h"
#include "tone_ord.h"
#include "const_bis.h"
#include "states.h"
#include <stdlib.h>
#include "changebat.h"
#include "decimalgain.h"
#include "diagparam_bis.h"
#include "snr.h"
#include "bitload_support.h"
#include "ComputeRMSFineGain.h"
#include "bitload_const.h"
#include "states.h"
#include "statein1.h"
#include "mul.h"
#include "hndshk_Data.h"

extern uint32 gula_rxILVBaseAddr[2] ;

int16 gs_CWSize, gs_CodingGain;
int16  gs_maxdatarate=0, gs_minnetdatarate=8;
uint16 gus_BitLoadParameters[NUM_DS_LATENCY_PATHS] = {0};
int16 gs_iter_conv=0, gs_found_valid_config=0, gs_flag_fixedrate=0, gs_flag_limitedrate = 0;
int16 gs_MaxSumLpSupported_zeroCG =0;
int16 gs_seq_final, gs_MSGc_final, gs_per_final;
int32 gl_debug_bitloadend=0, gl_debug_bitloadstart=0;

int16  gs_nbitswidth_limitedrate=32; // width of region to be used for searching limited rate configuration:
// 32 bits = 32 * 4 k=128kbps
int16 gs_OneOverSminADSL2; // Saves 1/S value being used for bitloading
int16 gs_INP=0 ;  // defined as 2 * MinINP

int16 gs_NumIter_ClockCntHigh=0; // Number of times 1/S is decreased
int16 gs_Max_NumRetrains=1; // Max number of times 1/S decrease is allower

//XDSLRTFW-930 ADSLRTFW-1517 ENH_DS_BisPlus_BDCM_SRA_EnhanceDsSyncUpRate (START)
int16 gs_initial_datarate = 0;
//XDSLRTFW-930 ADSLRTFW-1517 ENH_DS_BisPlus_BDCM_SRA_EnhanceDsSyncUpRate (END)

//XDSLRTFW-3684 (Start)
DATA_BULK_DATA2_BEGIN
//HQV tables for ATM mode of operation i.e ((Q*H)-V-2) is an integral multiple of ATM Cell size(53 bytes)
//Following framings are the result of simulations for DTU sizes Q*H<=1024
const uint8 guca_v_H_ATM[19] = { 55, 108, 161, 214, 134, 160, 187, 213, 240, 178, 195, 213, 231, 248, 200, 213, 226, 239, 202};
const uint8 guca_v_Q_ATM[19] = {  1,   1,   1,   1,   2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   4,   4,   4,   4,   5};
const uint8 guca_v_V_ATM[19] = {  0,   0,   0,   0,   1,   0,   1,   0,   1,   2,   0,   1,   2,   0,   3,   2,   1,   0,   1};

//HQV tables for EFM/PTM mode of operation i.e ((Q*H)-V-2) is an integral multiple of EFM/PTM Cell size(65 bytes)
//Following HQV values taken from VDSL FW and keeping the array size same as above(i.e. for ATM)
const uint8 guca_v_H_EFM[19] = { 67, 132, 197, 131, 164, 196, 229, 174, 196, 218, 239, 196, 212, 228, 245, 209, 222, 235, 248};
const uint8 guca_v_Q_EFM[19] = {  1,   1,   1,   2,   2,   2,   2,   3,   3,   3,   3,   4,   4,   4,   4,   5,   5,   5,   5};
const uint8 guca_v_V_EFM[19] = {  0,   0,   0,   0,   1,   0,   1,   0,   1,   2,   0,   2,   1,   0,   3,   3,   3,   3,   3};
DATA_MAP_END //DATA_BULKO1
//XDSLRTFW-3684 (End)


/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void DecideForRParams_OneLatency(void);
*
*   Description:
*  This function is called following the MEDLEY based SNR
*   calculation.  It will pick the DS PMS parameters at this time
*   based on its channel analysis result. This function is applicable to
*  'one latency one bearer channel' case.
*
*  Input Arguments:
*
*  Output Arguments:
*
*   Returns:
*
*  Global Variables:
*     gft_FineGainOn    -- (I) indicator if fine gain is used (1) or not (0)
*     gsa_MedleySnrBuf  -- (I) SNR buffer computed during Medley
*     gs_RxDesiredMargin   -- (I) desired SNR margin
*     gft_RS_Support    -- (I) maximum no. of RS check bytes agreed by two modem
*
*     gpsa_MeasuredSnrBuf -- (O) pointer to measured SNR buffer
*     gs_BitLoadingOK      -- (O) set to SUCCEED if bit loading succeeds, else set to FAIL
*     gsa_SNRRequired[] -- (O) required SNR per constellation for given SNR margin
*
*     gs_RxAvMargin --  (O) average SNR margin in Q8.8
gus_ncloaded  --  (O) number of tones being bit-allocated
***********************************************************************************/
void DecideForRParams_OneLatency(int16 s_path)
{

    int i;
    int16 s_R , s_D_Array;
    int16 s_R_temp;  //XDSLRTFW-139:SMS00839860 PERF_DS_BisPlus_DSmarginIncrease (START END)
    int16 s_RSCodingGain, s_M, s_T, sa_Bpn[2], s_SEQp_LP1;
    int16 s_Lp_Max=0, s_Lp_Min=0, s_Lp_Allocated, s_Kp_MDF,  s_D = 0,  s_R1;
    int16 s_delta_Lp=0;
    int16 s_flag_Lptruncate=0, s_max_latency = 0;
    int16 s_granularity_rate;
    int32 l_temp_diff_datarate,  l_maxdatarate,    l_mindatarate,  l_datarate;
    int16 s_datarate, s_best_datarate = 0 ;
    int16  s_DesiredINP, s_SelectedINP = 0;
    int32 l_seq_low, l_seq_high;
    int16 s_per_low , s_per_high ;
    int16 s_final_Lp, s_final_Tp, s_final_Mp, s_final_Rp, s_final_Dp,  s_final_CW ;
    uint8 s_RbyTwo,  s_BorderSpCase;
    int16 s_SaveCalcMaxBits[9] ;
    int16 s_numDOptions=21;
    int32 s_LpMaxINP;
    int16 s_MaxTotalRate_low, s_MaxTotalRate_high, s_LpMaxCH, s_LpMax,  s_CWMax, s_CWMin;
    int16 s_minnetdatarate_start = 0, s_minnetdatarate_end, s_MaxTotalRate_high_end, s_minnetdatarate, s_numloop_limitedrate;
    int16 s_KpMax, s_alpha_numer[6], s_alpha_denom[6];
    int16 s_alphaplus_numerator, s_alphaplus_denominator, s_alphaminus_numerator, s_alphaminus_denominator;
    int32  l_temp1, l_temp2,  l_temp3;
    int16 s_LpMin, s_CWTemp,  s_CWSize,s_TpMax,  s_Kp = 0,  s_Lp1, s_Lp2, s_Lptemp;
    int32  l_MaxTotalRateMCWSize, l_TotalRateNumerator;
    int16  s_Tp = 0, s_TpKp,  s_TpMin;
    //The following is log2(K), K = 1, 2, 4, 8, 16 (ignore other terms)
    int16 sa_log2Tbl[17] = {0, 0, 1, 0, 2, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 4};
    int16 s_leeway=0;
    int16 s_MaxOHRate=64;
    int s_Lp = 0;
    int16 s_temp1;
    int16 s_TotalBitsSupported_temp1, s_TotalBitsSupported_temp2, s_Tcm_Oh=0, s_RxExtraBits, s_RxAvFineGain ;
    FlagT ft_TCMflagSave=0;
    int16 s_RxDesiredMargin;
    s_per_low = MIN_PERP;
    s_per_high = MAX_PERP;

    /*   Min Overheadrate required needs to increase to satisfy the requirement that MSGc based overhead
    has to be greater than MSGmin and satisfy PER requirements*/

    if (gt_rx_config.s_Nlp == 2)
      // we can add fixed 3 kbps because SEQp = MSGc + 2; additional 2 bytes is equal to (2 * 8 bits /byte )/ PERp_avg
      // = 16/17.5 ~=1kbps
      gs_MinDSOverheadRate = gt_HandshakeBis.s_MinMSGDSOverheadRate + 1;
    else
    //XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges (start)
   {
      // we can add fixed 3 kbps because SEQp = MSGc + 6; additional 6 bytes is equal to (6 * 8
      // bits /byte )/ PERp_avg
      // = 48/17.5 ~=3kbps
      gs_MinDSOverheadRate = gt_HandshakeBis.s_MinMSGDSOverheadRate + 3;

      //In TR-105 SRA cases, after Downshift SRA the below condition is not passing
      // SRA_reported_margin_downshift_ds >= RA-DSNRM.
      //We are limited by the s_MinMSGDSOverheadRate
      if((gft_AutoSRA_ErrorCondition == FALSE)
          &&((gt_INFX_CMV.us_SRA_IOP_Bits & CMV_SRA_TO_ENABLE_MINOVERHEAD_GHS_CHECK))
         )
      {
         gs_MinDSOverheadRate = (gt_HandshakeBis.s_MinMSGDSOverheadRate << 1) + 3;

      }

      //XDSLRTFW-2376 /XDSLRTFW-2441 (start)
      // Force min Ovhd Data rate to 32 kbps
      if((gt_Dsl_Operator_Select.us_Operator_Select == TELMEX)
         &&(gs_CurrentCoChipset == BDCM_CO_CHIPSET)
        )
      {
         gs_MinDSOverheadRate = (gs_MinDSOverheadRate >= 32)? gs_MinDSOverheadRate:32;
      }
      //XDSLRTFW-2376 /XDSLRTFW-2441(end)

      gs_MinDSOverheadRate = (gs_MinDSOverheadRate <= 64)? gs_MinDSOverheadRate:64;

    }
   //XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges (end)
    // granularity for rate limit for limited rate
    s_granularity_rate = gs_OneOverSminADSL2 << 3;  // coresponding to 1/min S * 8 bits

    // save Max SUM{Lp} in a global variable for OLR DEBUG PURPOSES
    gft_BitloadOK = InitBitloading(s_path);

    /* Compute SNR plus coding gain */
    gpsa_MeasuredSnrBuf = &gsa_RxShowtimeSnrBuf[0];

    s_RxDesiredMargin = gs_RxDesiredMargin - OPTNArray[OPTN_MarginDelta];

    if (!gft_flag_explicitrate)
    {

        s_max_latency = (int16) 0x7FFF;


        if (gt_rx_config.s_Nlp == 1)
        {
            // single latency path, assign latency as higher of the two paths.
            for (i = 0; i < NUM_DS_BEARER_CHANNELS_SUPPORTED; i++)
            {
                if ((gt_HandshakeBis.sa_DS_BCActive[i] == 1) && (s_max_latency > gt_HandshakeBis.sa_DS_MaxLatencyBC[i]))
                s_max_latency = gt_HandshakeBis.sa_DS_MaxLatencyBC[i];
            }
            //XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges (start)
            // For SRA profiles we are limited by Maxlatency check for doing the SRA Dn Shift.
            // Restrcit Maxlatency while computing the framing params
            if((gft_AutoSRA_ErrorCondition == FALSE)
                &&(gt_INFX_CMV.us_SRA_IOP_Bits & CMV_TO_ENABLE_SRA_MAXLATENCY_CHECK_DELTA_LP)
                &&(s_max_latency > 1)
               )
               s_max_latency = s_max_latency>>1;
            //XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges (end)
//XDSLRTFW-1489 / XDSLRTFW-1561 (Start)
#if 0       // Delay constraint require for High REIN (now added extra INP protection through "gft_HighREIN_NOISE"
            //XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING (Start): Implement this feature only to single latency path

            if ((gt_INFX_CMV.us_OperatorSpBits6 & CMV_TO_ENABLE_REIN_DETECTION_TRAINING_AND_CHANGE_FRAMING)
               &&((guc_impulse_noise_present & REIN_IMPULSE_NOISE_VALID)== REIN_IMPULSE_NOISE_VALID)
               )
            {
               if (s_max_latency > 8) s_max_latency = 8;
            }
            //XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING (End)
#endif
//XDSLRTFW-1489 / XDSLRTFW-1561 (end)
        }
        else if (gt_rx_config.s_Nlp == 2)
        {
            // for dual latency, assign max latency corresponding to BC which is assigned to LP0
            // we only support two Bearer channels, one for each path
            // framer design is called for LP0, LP1 is already configured as fast path

            if (guca_rxBCnToLPp[0] == LP0_DATA_PATH) s_max_latency = gt_HandshakeBis.sa_DS_MaxLatencyBC[0];

            else if (guca_rxBCnToLPp[1] == LP0_DATA_PATH) s_max_latency = gt_HandshakeBis.sa_DS_MaxLatencyBC[1];

        }


    }

    // decide whether to have Trellis ON or OFF
    // This is tested only if we have INP =0, latency = 1ms, and no rate cap, Annex A, single Latency Path
    // check if Trellis is on, save the flag, as this global flag is required in other bitloading functions
    if (gft_TcmFlag_bis_DS == TRUE) ft_TCMflagSave = gft_TcmFlag_bis_DS;
    if  ((TESTArray[TEST_Control2] & TEST_TrellisOnOff) && (gl_SelectedMode & ANNEX_A) && (ft_TCMflagSave==TRUE) && (gt_HandshakeBis.sa_DS_MinINPBC[LP0_DATA_PATH] ==0) &&  (gt_HandshakeBis.sa_DS_MaxLatencyBC[LP0_DATA_PATH]==1) && (gs_maxdatarate > ((gs_RxBitLoadLastChannel - gs_RxBitLoadFirstChannel) *15) )  && (gt_rx_config.s_Nlp == 1))
    {
        // evaluate Lp if Trellis is Off
        gft_TcmFlag_bis_DS=0;
        /* Initialize BAT table and FineGains to zero. */
        gft_BitloadOK = InitBitloading(s_path);
        /* Compute Required SNR (= constellation SNR + margin) for each constellation */
        /* We will need to consider different BER here */
        OffsetSNRRequired(s_RxDesiredMargin , gsa_SNRRequired);
        /* Add coding gain to SNRs */
        AddCodingGainToSnr(gsa_MedleySnrBuf, 0, gpsa_MeasuredSnrBuf, s_path);

        // reset the flag to add extra fine gain for forceeven1bit
        gft_extrafinegainallocated =0;

        /* Calculate the max bits per symbol that the channel can support */
        /* and perform initial bit allocation and fine gain marking */
        s_TotalBitsSupported_temp1 = CalcMaxBits(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxExtraBits, &gus_ncloaded, &s_RxAvFineGain, 0x7FFF, s_path);
        // check Trellis on
        gft_BitloadOK = InitBitloading(s_path);
        AdjustTcmCodingGains(0); // R=0
        gft_TcmFlag_bis_DS=TRUE;
        s_RSCodingGain =  GetCodingGain_BIS(0, 1);
        /* Add coding gain to SNRs */
        AddCodingGainToSnr(gsa_MedleySnrBuf, s_RSCodingGain, gpsa_MeasuredSnrBuf, s_path);
        // reset the flag to add extra fine gain for forceeven1bit (so as not to have any differences due to extra gi allocation)
        gft_extrafinegainallocated =0;
        s_TotalBitsSupported_temp2 = CalcMaxBits(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxExtraBits, &gus_ncloaded, &s_RxAvFineGain, 0x7FFF, s_path);
        s_Tcm_Oh = (((int16) gus_ncloaded - (gus_Rx_Tcm_Num1bits >> 1) + 1) >> 1) + 4;
        s_TotalBitsSupported_temp2 -= s_Tcm_Oh;
        if (s_TotalBitsSupported_temp1 > s_TotalBitsSupported_temp2)
        {
            // turn Trellis off
            gft_TcmFlag_bis_DS =FALSE;
            s_Tcm_Oh =0;
        }

    }

    for (s_R = gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH]; s_R>= 0; s_R=s_R-2)
    {

        // Adjust Constellation SNR if Trellis is on
        if (gft_TcmFlag_bis_DS == TRUE)
        AdjustTcmCodingGains(s_R);

        /* iterate PMS parameter computation over all values of Dp, starting with maximum value to minimum chosen by the code*/

        /* Initialize BAT table and FineGains to zero. */
        gft_BitloadOK = InitBitloading(s_path);

        if(!gft_flag_explicitrate)
        {
            //CodingGain for R & D

            s_RSCodingGain =  GetCodingGain_BIS(s_R, 1);


            //Use RS and TCM coding gains (in Q8.8 format) in computing channel capacity

            /*Store coding gain in Q8.8 format*/
            gsa_TotalCodingGain[LP0_DATA_PATH] = (int16)(s_RSCodingGain);

            /* Compute Required SNR (= constellation SNR + margin) for each constellation */
            /* We will need to consider different BER here */
            OffsetSNRRequired(s_RxDesiredMargin , gsa_SNRRequired);


        }
        else
        {
            /* Use the maximum coding gain (in Q15.1 format) in computing channel capacity   */
            gsa_TotalCodingGain[LP0_DATA_PATH] = GetCodingGain_BIS(gt_rx_config.s_Rp[LP0_DATA_PATH], gt_rx_config.s_Dp[LP0_DATA_PATH]);
            gsa_TotalCodingGain[LP1_DATA_PATH] = GetCodingGain_BIS(gt_rx_config.s_Rp[LP1_DATA_PATH],gt_rx_config.s_Dp[LP1_DATA_PATH]);

            if ( gsa_TotalCodingGain[LP0_DATA_PATH] < gsa_TotalCodingGain[LP1_DATA_PATH] )
            {
                s_RSCodingGain = gsa_TotalCodingGain[LP1_DATA_PATH];
                s_R1 = gt_rx_config.s_Rp[LP1_DATA_PATH];
            }
            else
            {
                s_RSCodingGain = gsa_TotalCodingGain[LP0_DATA_PATH];
                s_R1 = gt_rx_config.s_Rp[LP0_DATA_PATH];
            }

            // Adjust Constellation SNR if Trellis is on
            if (gft_TcmFlag_bis_DS == TRUE)
            AdjustTcmCodingGains(s_R1);
            OffsetSNRRequired(s_RxDesiredMargin , gsa_SNRRequired);
        }


        /* Add coding gain to SNRs */
        AddCodingGainToSnr(gsa_MedleySnrBuf, s_RSCodingGain, gpsa_MeasuredSnrBuf, s_path);

        // reset the flag to add extra fine gain for forceeven1bit
        gft_extrafinegainallocated =0;

        /* Calculate the max bits per symbol that the channel can support */
        /* and perform initial bit allocation and fine gain marking */

        gs_TotalBitsSupported = CalcMaxBits(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &s_RxExtraBits, &gus_ncloaded, &s_RxAvFineGain, 0x7FFF, s_path);

        /* Compute the TCM overhead if it is used */
        if(gft_TcmFlag_bis_DS == TRUE)
        {
            s_Tcm_Oh = (((int16) gus_ncloaded - (gus_Rx_Tcm_Num1bits >> 1) + 1) >> 1) + 4;
        }

        // save the calcMax Bits output
        s_RbyTwo = s_R>>1;

        s_SaveCalcMaxBits[s_RbyTwo] = gs_TotalBitsSupported - s_Tcm_Oh;

    }  // R



    if (OPTNArray[OPTN_AlgControl2] & OPTN_FavorINPOverRate)
      s_DesiredINP = (4*gus_Scale_FractINP);    // Desire to have INP >= 2 so long as it doesn't limit Lp according
    // to Lp <= 4*R*D/INP constraint.
    else
      s_DesiredINP = 0;

    if (gs_INP > s_DesiredINP)
      s_DesiredINP = gs_INP;

    while (!gs_found_valid_config)
    {

        for (s_R = gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH]; s_R>= 0; s_R=s_R-2)
        {
            /* iterate PMS parameter computation over all values of Dp, starting with maximum value to minimum chosen by the code*/

            for (s_D_Array=0; s_D_Array < s_numDOptions; s_D_Array++)
            {
                s_D = gs_supportedDvalues[s_D_Array];

                if (s_D==0) continue;

                // Avoid these configurations since the coding gain we assign them in GetCodingGain is an overestimate.
                // Because of the expected bursty nature of QAM errors with trellis enabled, and with insufficient
                // interleaving (D<=2), the additional coding gain realized by adding checkbytes is much smaller than
                // is expected by GetCodingGain().
                if ((gft_TcmFlag_bis_DS == TRUE) && (s_D <=2) && (s_R != 0))
                continue;

                s_RbyTwo = s_R>>1;

                if   (!gft_flag_explicitrate)
                {

                    s_Lp_Allocated = s_SaveCalcMaxBits[s_RbyTwo];
                    MULS16(s_Lp,gs_max_CWSize, gs_OneOverSminADSL2);
                    s_Lp=s_Lp <<3;


                    if (s_Lp_Allocated > s_Lp)
                    {
                        s_Lp_Allocated = s_Lp;
                    }


                    if ((s_Lp_Allocated < gs_minnetdatarate)  &&
                    //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START_END)
                            (gs_found_valid_config ==0)&&(gs_deltaLp_max == 0))
                    {
                        if (s_DesiredINP == gs_INP)
                        {  // Can't reduce INP any further and we don't expect to find any configurations at smaller R,D,
                            // so fail here.
                            gft_BitloadOK = FAIL;
                            /* set the exception code insufficient bits */
                            gus_ExceptionCode   = E_CODE_BIT_LOADING_FAILURE;
                            gus_BitloadExceptionCode = E_CODE_BITLOAD_INSUFFICIENT_BITS;
                            gs_InitFailCauseNearEnd = 2;
                            return;
                        }
                        else goto ReduceINP;
                    }
                    gft_BitloadOK = SUCCEED;



                    if(s_DesiredINP != 0)
                    {

#if 0//def VR9_ERASURE
                     //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
                     //XDSLRTFW-1502 (start)
                     // Use erasure to boost the DataRate
                     // For IOP issues checking both the conditions.
                     //observed with E67_CNXT only "ft_INP_no_erasure_not_reqd" received, that too in MS.
                        if ( (gt_ErasureDecoding_Reprt.ft_Report_ED == TRUE) &&
                           (gt_ErasureDecoding_Reprt.ft_INP_no_erasure_not_reqd == TRUE) &&
                             ((gs_DSL_EDcontrol & ERASURE_MAX_INP) == 0)&&
                           (gs_DSL_EDcontrol & ERASURE_DECODING_ENABLE == ERASURE_DECODING_ENABLE)
                            )
                        //XDSLRTFW-1502 (end)
                        {
                        /************************************************************************************************************
                                       Impulse Noise protection with Erasure INP = ((Sp * Dp) * Rp/ CWSize)
                                                                                                =  8* Rp * Dp / Lp, which puts a limit on max Lp

                                       In this case as gs_INP=1, implies half frame protection; 2 implies 1 frame protection etc. ,
                                       further  divide by 2
                                       ************************************************************************************************************/
                            if ((s_Lp_Allocated + gs_deltaLp_max )> ( ((s_D << 4) * (s_R)*(gus_Scale_FractINP))/s_DesiredINP))
                            {
                              //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START)
                              //if (s_DesiredINP > gs_INP)
                              if ( (s_DesiredINP > gs_INP) && (gs_deltaLp_max == 0) )
                              //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (END)
                                goto ReduceINP;
                                else
                                s_Lp_Allocated = ((s_D << 4)* s_R * gus_Scale_FractINP/s_DesiredINP)- gs_deltaLp_max;
                            }
                        }
                        else
#endif  //#ifdef VR9_ERASURE
                        {
                            /************************************************************************************************************
                                             Impulse Noise protection INP = (1/2) (Sp * Dp) * (Rp/ CWSize)
                                             =  4* Rp * Dp / Lp, which puts a limit on max Lp
                                             In this case as gs_INP=1, implies half frame protection; 2 implies 1 frame protection etc. ,
                                             further  divide by 2
                                             ************************************************************************************************************/
                            //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start)
                            if ((s_Lp_Allocated + gs_deltaLp_max) > ( ((s_D << 3) * s_R * gus_Scale_FractINP)/s_DesiredINP))
                            {
                                if ((s_DesiredINP > gs_INP)&& (gs_deltaLp_max == 0))
                                 goto ReduceINP;
                                else
                                 s_Lp_Allocated = (((s_D << 3)* s_R* gus_Scale_FractINP)/s_DesiredINP )- gs_deltaLp_max;
                            }
                            // ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (End)
                        }
                    }

                    // check for border Sp case, even in adaptive rate cases, there may be no configuration possible if
                    // Sp is not ensured as possible, in cases where different requirements force Sp=fixed value
                    if ( s_max_latency *  gs_OneOverSminADSL2 * 4 == s_D ) s_BorderSpCase = 1;
                    else
                    s_BorderSpCase = 0;

                    if (s_BorderSpCase)
                    // ensure that Lp is a multiple of CWSize, trim it down if the need be
                    s_Lp_Allocated = (s_Lp_Allocated / s_granularity_rate) * s_granularity_rate;
#ifdef DANUBE_WB
                    // Danube Erasure ensure that Lp is a multiple 8 to avoid the bitfifo problem
                    if ( (gs_DSL_EDcontrol & ERASURE_DECODING_ENABLE) == ERASURE_DECODING_ENABLE)
                    s_Lp_Allocated  = (s_Lp_Allocated/8)*8;

#endif   //#ifdef DANUBE_WB
                    // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start End)
                    // Forcing Lp (in L0 state) to be a multiple of 8, to avoid CRC errors
                    // (if any, due to wrong handling of residual bits) during L0 to L2 transition. As of
                    // now there is no concrete proof of 'wrong handling'. This speculation has to be
                    // verified and this forcing has to be removed if residual bits are found to be handled
                    // correctly in hardware.
                    // XDSLRTFW-986: BugFix_ALL_BisPLus_ALL_BRCM_LinkDrop_SRAEnabled_CappedRate_Profile (Start_End)
                    // Commenting out this restriction as a Link drop was seen with BRCM in SRA Enabled, Capped Rate profile
                    //s_Lp_Allocated   = (s_Lp_Allocated/8)*8;

                  //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start)
                  if (s_Lp_Allocated < gs_deltaLp_max)
                     gft_BitloadOK = FAIL;
                  else
                    /* Decide the best configuration parameter based on the maximum bits supported */
                    gft_BitloadOK = Choose_PMS_Params(&s_Lp_Allocated, (int16) s_D, s_R, &s_M, &s_T, &sa_Bpn[0], s_max_latency,
                                                      LP0_DATA_PATH,gs_deltaLp_max);
                  //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (End)

                    if (gft_BitloadOK ==SUCCEED)
                    {
                        //XDSLRTFW-625 BugFix_DS_ALL_AccurateDsRateComparison: (START)
                        //Use comply to compare data rate instead of division.
                        int32 l_temp1, l_temp2;

                        s_Kp_MDF = sa_Bpn[0] + sa_Bpn[1] + 1;
                        MULS16(l_temp1,s_Kp_MDF , s_M);
                        s_temp1=(int16)l_temp1 + s_R;

                        l_temp1 = (s_T*s_Kp_MDF-1)*s_M*((int32)(s_Lp_Allocated));
                        l_temp2 = s_T*s_temp1;

                        //s_datarate = (int16)((s_T*s_Kp_MDF-1)*s_M*((int32)(s_Lp_Allocated))/(s_T*s_temp1));
                        s_datarate = (int16)(l_temp1/l_temp2);

                        /* new set of parameters are outputted only if the coding gain achieved is at least
                        as much as assumed in the input & net data rate computed is more than best achieved so far
                        (in case of fixed rate we don't check this)*/

                        //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START)
                        //if ((s_datarate > s_best_datarate) && (s_datarate >= gs_minnetdatarate))
                        if (
                            //((gft_FrameCheckForSRA == FALSE) && (s_datarate > s_best_datarate) && (s_datarate >= gs_minnetdatarate)) ||
                            //((gft_FrameCheckForSRA == TRUE) && ((s_datarate > s_best_datarate) && (s_datarate >= gs_minnetdatarate) && (s_datarate <= gs_maxdatarate) && (gs_deltaLp_max > 0))) ||
                            //((gft_FrameCheckForSRA == TRUE) && (s_datarate > s_best_datarate) && (s_datarate >= gs_minnetdatarate) && (gs_deltaLp_max == 0) )
                            ((gft_FrameCheckForSRA == FALSE) && (s_datarate > s_best_datarate) && (l_temp1 >= gs_minnetdatarate*l_temp2)) ||
                            ((gft_FrameCheckForSRA == TRUE) && ((s_datarate > s_best_datarate) && (l_temp1 >= gs_minnetdatarate*l_temp2) &&
#ifndef ISDN
                           //XDSLRTFW-930 ADSLRTFW-1517 ENH_DS_BisPlus_BDCM_SRA_EnhanceDsSyncUpRate (START)
                            (l_temp1 <= gs_maxdatarate*l_temp2) && (gs_deltaLp_max > 0) &&
                           (s_datarate*100 >= gs_initial_datarate*(100-OPTNArray[OPTN_SRA_RATE_DEGRADATION])) )) ||
                            //XDSLRTFW-930 ADSLRTFW-1517 ENH_DS_BisPlus_BDCM_SRA_EnhanceDsSyncUpRate (END)
#else
                           (l_temp1 <= gs_maxdatarate*l_temp2) && (gs_deltaLp_max > 0))) ||
#endif

                            ((gft_FrameCheckForSRA == TRUE) && (s_datarate > s_best_datarate) && (l_temp1 >= gs_minnetdatarate*l_temp2) && (gs_deltaLp_max == 0) )
                        //XDSLRTFW-625 BugFix_DS_ALL_AccurateDsRateComparison: (END)
                           )
                        //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (END)

                        {
                            gs_found_valid_config = 1;

                            Save_ValidPMS(s_D, s_M, s_R,  s_T,  s_Lp_Allocated, &sa_Bpn[0], LP0_DATA_PATH, &gt_PMSParams);

                            s_best_datarate = s_datarate;
                            s_SelectedINP = s_DesiredINP;

                            gft_BitloadOK = SUCCEED;
                        }
                    } // gft_BitloadOK==SUCCEED

                } // !Explicit rate
            } // D
        } // R
ReduceINP:
        //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START_END)
        //if (!gs_found_valid_config)
        if ((!gs_found_valid_config) && (gs_deltaLp_max == 0))
        {
            //if(s_DesiredINP == 4)
            if ((s_DesiredINP == 4) && ((OPTNArray[OPTN_AlgControl3] & CMV_TO_ENABLE_FRACTIONAL_INP_FRAMEWORK) == 0))
               s_DesiredINP=2;  // go from 2 frames to 1 frame
            else
               s_DesiredINP--;
            if (s_DesiredINP < gs_INP)
               break;
        }
         //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START)
         if ((!gs_found_valid_config) && (gs_deltaLp_max > 0))
         {
            gs_deltaLp_max -= 5;
            s_best_datarate = 0;
         }
         if (gs_deltaLp_max < 0)
            gs_deltaLp_max = 0;
         //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (END)
    } // while (!gs_found_valid_config)



    if (gs_found_valid_config == 1)
    {

        gft_Flag_limitCause = 0;
        // allocate correct number of bits to bat table
        s_R = gt_PMSParams.s_Rp[LP0_DATA_PATH];

        s_D = gt_PMSParams.s_Dp[LP0_DATA_PATH];

        // Adjust Constellation SNR if Trellis is on
        if (gft_TcmFlag_bis_DS == TRUE)
        AdjustTcmCodingGains(s_R);

        //Use RS and TCM coding gains (in Q8.8 format) in computing channel capacity
        s_RSCodingGain =  GetCodingGain_BIS(s_R, s_D);


        // Save coding gain for best rate.  Used to estimate ATTNDR.
        gs_CodingGainForATTNDR = s_RSCodingGain;   // 8.8 format

#ifndef ISDN
       //XDSLRTFW-930 IOP_DS_BisPlus_BDCM_SRA_lowATTNDRds  (START)
       if (!gs_initial_datarate)
       {
       //XDSLRTFW-930 IOP_DS_BisPlus_BDCM_SRA_lowATTNDRds  (END)
#endif

        // Save the Attainable Net Data Rate (bits/second)
        MULS16(gl_ATTNDRds_Initial, s_best_datarate , 4000);
        gl_ATTNDRds_Estimate_Updated = gl_ATTNDRds_Initial;

        // set the default value of "external" copy of ATTNDRds
        gt_NearEndParam.ul_AttainableDataRate = gl_ATTNDRds_Initial;
        // Save the MedleySNR-based estimated Total Data Rate.  This is used during showtime to estimate the Attainable Net Data Rate.
        gl_ATTNDRds_Estimate_Initial = (int32) CalcATTNDR(gsa_MedleySnrBuf, s_RxDesiredMargin , gs_CodingGainForATTNDR);
//    Pause(0xBA00);

        //XDSLRTFW-632 XDSLRTFW_523 BugFix_DS_BisPlus_AB_All_UpdateATTNDRds_SRA (SATRT_END)
        gs_RxDesiredMargin_original = s_RxDesiredMargin;
#ifndef ISDN
       //XDSLRTFW-930 IOP_DS_BisPlus_BDCM_SRA_lowATTNDRds  (START)
       }
       //XDSLRTFW-930 IOP_DS_BisPlus_BDCM_SRA_lowATTNDRds  (END)
#endif

        gft_BitloadOK = InitBitloading(s_path);

        /*Store coding gain in Q8.8 format*/
        gsa_TotalCodingGain[LP0_DATA_PATH] = s_RSCodingGain;

        /* Compute Required SNR (= constellation SNR + margin) for each constellation */
        /* We will need to consider different BER here */
        OffsetSNRRequired(s_RxDesiredMargin , gsa_SNRRequired);

        /* Compute SNR plus coding gain */
        gpsa_MeasuredSnrBuf = &gsa_RxShowtimeSnrBuf[0];

        /* Add coding gain to SNRs */
        AddCodingGainToSnr(gsa_MedleySnrBuf, s_RSCodingGain, gpsa_MeasuredSnrBuf, s_path);
        // reset the flag to add extra fine gain for forceeven1bit
        gft_extrafinegainallocated =0;

        /* Calculate the max bits per symbol that the channel can support */
        /* and perform initial bit allocation and fine gain marking */

        gs_TotalBitsSupported = CalcMaxBits(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxExtraBits, &gus_ncloaded, &gs_RxAvFineGain, 0x7FFF, s_path);

        /* Compute the TCM overhead if it is used */
        if(gft_TcmFlag_bis_DS == TRUE)
        {
            gs_Tcm_Oh = (((int16) gus_ncloaded - (gus_Rx_Tcm_Num1bits >> 1) + 1) >> 1) + 4;
        }
        else
        gs_Tcm_Oh = 0;

        s_Lp_Allocated = gs_TotalBitsSupported - gs_Tcm_Oh;

        // Check if Lp needs to be trunacted due to INP requirement
        if (gt_PMSParams.s_Lp[LP0_DATA_PATH] < s_Lp_Allocated)
        s_flag_Lptruncate = 1;

        gft_BitloadOK = SUCCEED; // reset this flag here to say at least some configuration for adaptive rate is found
    }

    if(!gft_flag_explicitrate)
    {
        // In case no valid configuration is obtained, it is a bitload failure, we can exit at this point
        if (gs_found_valid_config == 0)
        {
            gft_BitloadOK = FAIL;
            /* set the exception code No valid config for adaptive mode*/
            gus_ExceptionCode = E_CODE_BIT_LOADING_FAILURE;
            gus_BitloadExceptionCode = E_CODE_BITLOAD_NOVALID_CONFIG_ADAPTIVERATE;
            gs_InitFailCauseNearEnd = 2;
            return;
        }

        // Check if the max rate desired is smaller than what best rate is achieved, enter fixed rate
        if (gs_maxdatarate < s_best_datarate )
        {
            gs_found_valid_config=0;

            /* Increase min rate to close to max, as the code treats  these cases as
            fixed rate case; and we may get out by any rate lying between min and max,
            This would ensure that we are close to max, Currently put it as max -5 bits,
            may need to relax it for some stringent constraints; and also would need a
            change for dual latency configurations.*/

            if (gs_maxdatarate - 1  > gs_minnetdatarate )
            {
                // Set flag to indicate that these are limited rate cases, where min
                // rate is increased to hit close to max
                gs_flag_limitedrate = 1;


            }
            else
            {
                // fixed rate
                gs_flag_fixedrate = 1;
            }

        }


        //Dual Latency, we currently don't support fixed rate in case of dual latency
        if ((gt_rx_config.s_Nlp == 2) && ((gs_flag_fixedrate==1) | (gs_flag_limitedrate==1)))
        {
            // set exceptioncode
            gft_BitloadOK = FAIL;
            /* set the exception code No valid config for adaptive mode*/
            gus_ExceptionCode = E_CODE_BIT_LOADING_FAILURE;
            gus_BitloadExceptionCode = E_CODE_BITLOAD_NOSUPPORTLIMTEDRATELP0_DUAlLATENCY;
            gs_InitFailCauseNearEnd = 2;
            return;

        }


        if (OPTNArray[OPTN_AlgControl2] & OPTN_FavorINPOverRate)

        /* Check if it is fixed rate case and if the chosen configuration corresponds to a border SP case,
        do not increase INP in that case, else work with higher INP compared to handshake limit */
        {
            MULS16(l_temp1, s_max_latency,gs_OneOverSminADSL2 );
            s_temp1 = ((int16)l_temp1) <<2;
            if ( ( gs_flag_fixedrate && (s_temp1 != s_D) )  || (gs_flag_limitedrate) ) // border Sp case, don't increase INP

            // increase INP required
            if (s_SelectedINP > gs_INP) gs_INP = s_SelectedINP;

        }


        // for limited rate, increase min rate
        if ((gs_flag_limitedrate==1)  && ((gs_maxdatarate - 2 ) >= gs_minnetdatarate))
        {

            s_minnetdatarate_start = gs_maxdatarate -2;
            s_leeway =0;

        }
        if (gs_flag_fixedrate ==1)
        {
            s_minnetdatarate_start = gs_minnetdatarate;
            s_leeway =2;
        }
        s_minnetdatarate_end= gs_minnetdatarate;

        s_MaxTotalRate_high_end = ((gs_maxdatarate + s_leeway) << 2) + s_MaxOHRate ; // kbps


        if ((gs_flag_fixedrate == 1) || (gs_flag_limitedrate == 1))
        {
            // consider lower and upper limit of total rate
            /* lower limit = Min Required Rate + Min Overhead rate*/

            s_numloop_limitedrate=0;
            for (s_minnetdatarate = s_minnetdatarate_start; s_minnetdatarate >= s_minnetdatarate_end; s_minnetdatarate-=gs_nbitswidth_limitedrate)
            {
                if (s_numloop_limitedrate==2) s_minnetdatarate =s_minnetdatarate_end;
                // loop thru all values of min rate in steps of 128kbps to find a possible configuration
                // hope is that we will be able to find a configuration in a finite number of steps.

                s_MaxTotalRate_low = (s_minnetdatarate<<2) + gs_MinDSOverheadRate; // kbps

                s_MaxTotalRate_high = s_MaxTotalRate_high_end;
                s_LpMin = s_minnetdatarate + (gs_MinDSOverheadRate>>2); // bits

                // loop thru all Dp
                for (s_D_Array=0; s_D_Array < s_numDOptions; s_D_Array++)
                {
                    //XDSLRTFW-139:SMS00839860:PERF_DS_BisPlus_DSmarginIncrease (START)
                    if (gt_INFX_CMV.us_OperatorSpBits2 & CMV_INFX_DFE_FAVOR_MARGIN_OVER_INP_ENABLE)
                    {
                        s_D = gs_supportedDvalues[s_numDOptions-1-s_D_Array];
                    }
                    else
                    {
                        s_D = gs_supportedDvalues[s_D_Array];
                    }
                    //XDSLRTFW-139:SMS00839860:PERF_DS_BisPlus_DSmarginIncrease (END)

                    if (s_D == 0) continue;

                    if ((s_max_latency  == 1 ) && (s_D !=1)) continue; // fast path , D=1

                    // loop thru Rp
                    //XDSLRTFW-139:SMS00839860:PERF_DS_BisPlus_DSmarginIncrease (START)
                    for(s_R_temp = gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH];
                    s_R_temp >= 0; s_R_temp = s_R_temp - 2)
                    {

                        if (gt_INFX_CMV.us_OperatorSpBits2 & CMV_INFX_DFE_FAVOR_MARGIN_OVER_INP_ENABLE)
                        {
                            s_R = gt_HandshakeBis.sa_DS_MaxCheckbytesLP[LP0_DATA_PATH] - s_R_temp;
                        }
                        else
                        {
                            s_R = s_R_temp;
                        }
                        //XDSLRTFW-139:SMS00839860:PERF_DS_BisPlus_DSmarginIncrease (END)
                        // IOP_DS_BisPlus_ALL_Fast_FixedRate_RSBytes_Zero - Start
                        //In fast path, fixed data rate case, choose R=0, since the amount of coding gain
                        //we put for R != 0 with D=1 is much more than it can correct when a particular DMT
                        //symbol get corrupted with interleaving is disabled. RS coding gain is meaningfull when
                        //interleaving is enabled. High coding gain with D=1 resulted into lower margin
                        //when a particular DMT symbol got corrupted.
                        //Hence choose R=0 when interleaving is disabled. This is applicable only
                        //when ReTx is disabled.
#ifndef ISDN   //XDSLRTFW-1421      (start)
               // We can remove these lines completely, usage of R will correct (R/2)dribbling CRCs atleast!
                        if ((s_max_latency == 1) && (s_D == 1) && (s_R != 0))
                        continue;   // In fast path(D=1), choose R=0 if ReTx is disabled
#endif         //XDSLRTFW-1421   (end)

                        // IOP_DS_BisPlus_ALL_Fast_FixedRate_RSBytes_Zero - End
                        s_RbyTwo = s_R>>1;

                        s_LpMaxCH = s_SaveCalcMaxBits[s_RbyTwo];

                        s_LpMax = s_LpMaxCH;

                        /*********************************************************************
                    check for INP Protection
                    *********************************************************************/
                        if (gs_INP != 0)
                        {
                        // XDSLRTFW-399 ENH_DS_BisPlus_All_Enable_ErasureDecoding (Start)
#if 0//def VR9_ERASURE
                        //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
                        //XDSLRTFW-1502 (start)
                        if ( (gt_ErasureDecoding_Reprt.ft_Report_ED == TRUE) &&
                              (gt_ErasureDecoding_Reprt.ft_INP_no_erasure_not_reqd == TRUE) &&
                               ((gs_DSL_EDcontrol & ERASURE_MAX_INP) == 0) &&
                              (gs_DSL_EDcontrol & ERASURE_DECODING_ENABLE == ERASURE_DECODING_ENABLE)
                              )
                           // XDSLRTFW-1502 (end)
                            {
                                // Note: gs_INP=2*minINP
                                // s_LpMaxINP = 8*Dp*Rp/minINP = 16*Dp*Rp/gs_INP
                                MULS16(s_LpMaxINP,   s_R<<4, s_D);
                            }
                            else
#endif //#ifdef VR9_ERASURE
                           {
                                //s_LpMaxINP = 4*Dp*Rp/minINP = 8*Dp*Rp/gs_INP
                                MULS16(s_LpMaxINP,   (s_R <<3), s_D);
                            }
                            s_LpMaxINP = (gus_Scale_FractINP * s_LpMaxINP)/gs_INP;

                            // Lp Max is taken as the lower of the two
                            if (s_LpMaxCH > s_LpMaxINP)
                            s_LpMax = (int16) s_LpMaxINP;

                        }
                        if ((s_R ==0) && (s_D !=1)) continue;

                        // Loop thru all values of Mp
                        for (s_M = 1; s_M <= 16; s_M <<= 1)
                        {
                            // start with largest codeword
                            s_CWMax = gs_max_CWSize;

                            // Don't consider M>1 for R=0 (required by standard)
                            if ((s_R == 0) && (s_M > 1))
                            break;  // break out from the Mp-loop and search for next Dp and Rp

                            // Find CWMin assuming Kp=1
                            s_CWMin = s_M + s_R;

                            // CWSize = K*M + R
                            s_KpMax = (s_CWMax - s_R) >> sa_log2Tbl[s_M];

                            // Compute Max CW Size based on KpMax
                            s_CWMax = s_KpMax*s_M + s_R;

                            //  CWMax has to be greater than CWMin
                            if (s_CWMax < s_CWMin)
                            continue;


                            // Compute feasible region
                            // To keep the precision, we store the numerator and the denominator separately for computation
                            //
                            // Thresholds for bounds in form CWSize <= alpha(i)*Lp:
                            // (1) Limit due to Min Overhead Rate: CWSize <= (Lp*Mp*4)/(Tp*MinOHRate)
                            //s_alpha[0] = ((4*s_M))/gs_MinDSOverheadRate;
                            s_alpha_numer[0] = s_M<<2;
                            s_alpha_denom[0] = gs_MinDSOverheadRate;

                            // (2) Limit due to Max Delay: CWSize <= (Lp * MaxLatency)/(2*Dp)
                            s_alpha_numer[1] = s_max_latency;
                            s_alpha_denom[1] = s_D<<1;

                            // (3) Limit due to Sp <= 64: CWSize <= 8*Lp
                            s_alpha_numer[2] = 8;
                            s_alpha_denom[2] = 1;


                            // Thresholds for bounds in form CWSize >= alpha(i)*Lp:
                            // (4) Limit due to Sp >= Mp/16: CWSize >= Lp*Mp/128

                            //   Mp/16 > Mp/(16*MaxOHRate).
                            s_alpha_numer[3] = s_M;
                            s_alpha_denom[3] = gs_OneOverSminADSL2<<3;

                            // (5) Limit Sp >= 1/16; or 1/2 or 1/3 for single latency.

                            s_alpha_numer[4] = 1;
                            s_alpha_denom[4] = gs_OneOverSminADSL2<<3;


                            // (6) Limit due to Max Overhead rate
                            s_alpha_numer[5] = s_M;
                            s_alpha_denom[5] = s_MaxOHRate<<4;


                            // Find alphaplus = min(alpha[0], alpha[1], alpha[2])
                            //s_alphaplus = s_alpha[0];

                            s_alphaplus_numerator = s_alpha_numer[0];
                            s_alphaplus_denominator = s_alpha_denom[0];

                            CompareFractions( 1, s_alpha_numer[1], s_alpha_denom[1], &s_alphaplus_numerator, &s_alphaplus_denominator);


                            CompareFractions( 1, s_alpha_numer[2], s_alpha_denom[2], &s_alphaplus_numerator, &s_alphaplus_denominator);

                            // Find alphaminus = max(alpha[3], alpha[4], alpha[5])
                            // s_alphaminus = s_alpha[3];
                            s_alphaminus_numerator = s_alpha_numer[3];
                            s_alphaminus_denominator = s_alpha_denom[3];
                            CompareFractions( 0, s_alpha_numer[4], s_alpha_denom[4], &s_alphaminus_numerator, &s_alphaminus_denominator);

                            CompareFractions( 0, s_alpha_numer[5], s_alpha_denom[5], &s_alphaminus_numerator, &s_alphaminus_denominator);



                            // Note: we also avoid degenerate condition when alphaminus > alphaplus
                            //    if (s_alphaminus>= s_alphaplus)
                            MULS16(l_temp1, s_alphaminus_numerator,s_alphaplus_denominator);
                            MULS16(l_temp2, s_alphaplus_numerator, s_alphaminus_denominator);
                            if (l_temp1 > l_temp2)
                            continue;        // check next Mp value

                            // Further sanity check: verify that there's at least one valid
                            // point inside the feasible region.

                            // 1st Check: recall CWSize >= alphaminus*Lp, so using LpMin, we find the min CWSize required and
                            // we need to reject the current config if it requires min CW Size greater than CWMax
                            MULS16(l_temp1, s_alphaminus_numerator, s_LpMin);


                            s_CWTemp = (uint16)(l_temp1 /s_alphaminus_denominator);

                            if ((s_CWTemp * s_alphaminus_denominator) < (l_temp1)) s_CWTemp++;


                            if (s_CWTemp > s_CWMax)
                            continue;

                            // 2nd Check: recall CWSize <= alphaplus*Lp, so using LpMax, we find the max CWSize allowed
                            // and we need to reject the current config if CWMin is greater than the max CWSize allowed

                            MULS16(l_temp1, s_alphaplus_numerator,s_LpMax);
                            s_CWTemp = (uint16) (l_temp1/s_alphaplus_denominator);
                            s_Kp_MDF = (s_CWTemp-s_R) >> sa_log2Tbl[s_M]; // floor ((CW1-Rp)/Mp)
                            MULS16(l_temp1, s_Kp_MDF, s_M);
                            s_CWTemp = (int16)l_temp1 + s_R;
                            if (s_CWTemp < s_CWMin)
                            continue;

                            // Compute optimal corner point of the feasible region
                            if (s_CWTemp > s_CWMax)
                            {
                                // This is the case when the line CWSize=CWMax & the line CWSize = alphaminus*Lp intersect
                                // So we limit the final CWSize

                                s_CWSize = s_CWMax;

                                // Recompute Kp based on the new CWSize: floor ((CWSize-Rp)/Mp)
                                s_Kp = (s_CWSize-s_R) >> sa_log2Tbl[s_M];

                                // We need to compute the new Lp based on s_CWSize: floor (CWMax/alphaminus)
                                s_Lp = (s_CWMax*s_alphaminus_denominator)/s_alphaminus_numerator;

                                if (s_Lp > s_LpMax)
                                // This is the case when optimal corner point intersect
                                // the line "CWSize=CWMax" and the line "Lp=LpMax"
                                s_Lp = s_LpMax;
                            }
                            else
                            {
                                // In this case, we are sure s_CWMin <= s_CWTemp <= s_CWMax
                                // And it's when optimal corner point intersect
                                // the line "CWSize = alphaplus*Lp" and the line "Lp=LpMax"
                                s_Lp = s_LpMax;

                                // Re-compute s_CWSize based on s_LpMax

                                MULS16(l_temp1, s_alphaplus_numerator, s_LpMax);

                                s_CWTemp = (uint16)(l_temp1 /s_alphaplus_denominator);


                                s_Kp = (s_CWTemp-s_R) >> sa_log2Tbl[s_M]; // floor ((CW1-Rp)/Mp)
                                MULS16(l_temp1, s_Kp, s_M);
                                s_CWSize = (int16)(l_temp1) + s_R;
                                s_CWMax = s_CWSize;


                            } // end if (s_CWTemp > s_CWMax)...


                            // ensure that this codeword is co_prime with the Dp
                            while ((!CheckCoPrime(s_D, s_CWSize))  && (s_D > 64) && (s_CWSize > 1))
                            s_CWSize--;


                            if (s_CWSize < s_CWMin) continue;

                            // ensure that this CW lies in the feasible region
                            if ((s_CWSize * s_alphaplus_denominator > s_LpMax * s_alphaplus_numerator) || (s_CWSize * s_alphaminus_denominator < s_LpMin * s_alphaminus_numerator)) continue;


                            // At this point, we have found the optimal s_Lp and s_Kp given the current set of {s_R,s_D,s_M}
                            // We are also sure that s_Lp and s_Kp lie in the feasible region
                            // The question is now whether this optimal s_Lp and s_Kp meet the max rate requirement.
                            // If not we have to adjust s_Lp and s_Kp accordingly such that it would yield the
                            // final data rate that meets the min and max rate requirement and still be in the feasible region


                            // Check if (TotalRate > MaxTotalRate) (check lower rate)
                            // TotalRate = 4*Lp*(Kp*Mp)/CWSize (unit in kbps)

                            // To avoid division, we check if (4*Lp*(Kp*Mp) > MaxTotalRate*CWSize)

                            l_TotalRateNumerator = (int32)s_Kp*s_M*s_Lp*4;
                            MULS16(l_MaxTotalRateMCWSize ,s_MaxTotalRate_low,s_CWSize);

                            // need to add the code to compare rates and save the max rate

                            if (l_TotalRateNumerator < l_MaxTotalRateMCWSize)
                            // indicate we are in adaptive rate
                            continue;




                            for (s_CWTemp = s_CWMax; s_CWTemp >= s_CWMin; s_CWTemp--)
                            {
                                s_Kp = (s_CWTemp -s_R) >> sa_log2Tbl[s_M];
                                if (s_Kp <1) continue;

                                MULS16(l_temp1, s_Kp, s_M);
                                s_CWSize = (int16) l_temp1 + s_R;

                                // check that it is co_prime with D
                                if ( (s_D > 64) && (!CheckCoPrime(s_D, s_CWSize))) continue;

                                // max interleaver memory restriction
                                //SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory(Start)
#ifdef ADSL_62
                                if ((s_CWSize-1)*(s_D-1) > gl_DS_Intlv_buf_size ) continue;
#else
                                if ((s_CWSize-1)*(s_D-1) > 16002 ) continue;
#endif
                                //SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory (End)
                                // at this time we do a search over the complete CW range and Lp ranging from Min to Max
                                // to obtain a configuration.

                                //Determine Lp1 and Lp2
                                MULS32x16(l_temp1, s_MaxTotalRate_low, s_CWSize);

                                // round it to next higher value
                                s_Lp1 = (int16)  (l_temp1 /(s_CWSize - s_R) ) >>2;
                                MULS16(l_temp2, s_Lp1, (s_CWSize - s_R));

                                if ((((int16)l_temp2 << 2)) < l_temp1) s_Lp1 ++;

                                // compute Lp corresponding to alphaplus line

                                MULS16(l_temp1, s_CWSize, s_alphaplus_denominator);

                                s_Lptemp = (int16) (l_temp1 / s_alphaplus_numerator);

                                if (s_Lptemp * s_alphaplus_numerator < s_CWSize * s_alphaplus_denominator) s_Lptemp ++; // round to next higher value

                                if (s_Lp1 < s_Lptemp) s_Lp1 = s_Lptemp;

                                if (s_Lp1 < s_LpMin) s_Lp1 = s_LpMin;


                                // compute s_Lp2

                                MULS32x16(l_temp1, s_MaxTotalRate_high, s_CWSize);

                                // truncate it
                                l_temp1 = l_temp1 /((s_CWSize - s_R)<<2) ;

                                s_Lp2 = (int16) (l_temp1);

                                // compute Lp corresponding to alphaminus line

                                MULS16(l_temp1, s_CWSize, s_alphaminus_denominator);

                                s_Lptemp = (int16) (l_temp1 / s_alphaminus_numerator);

                                if (s_Lp2 > s_Lptemp) s_Lp2 = s_Lptemp;

                                if (s_Lp2 > s_LpMax) s_Lp2 = s_LpMax;


                                for (s_Lp = s_Lp2; s_Lp >= s_Lp1; s_Lp--)
                                {
#ifdef DANUBE_WB
                           //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
                                    // Danube Erasure ensure that Lp is a multiple 8 to avoid the bitfifo problem
                                    if ((gs_DSL_EDcontrol & ERASURE_DECODING_ENABLE) == ERASURE_DECODING_ENABLE)
                                    s_Lp = (s_Lp/8)*8;
#endif //#ifdef DANUBE_WB
                                    // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start End)
                                    // Forcing Lp (in L0 state) to be a multiple of 8, to avoid CRC errors
                                    // (if any, due to wrong handling of residual bits) during L0 to L2 transition. As of
                                    // now there is no concrete proof of 'wrong handling'. This speculation has to be
                                    // verified and this forcing has to be removed if residual bits are found to be handled
                                    // correctly in hardware.
                                    // XDSLRTFW-986: BugFix_ALL_BisPLus_ALL_BRCM_LinkDrop_SRAEnabled_CappedRate_Profile (Start_End)
                                    // Commenting out this restriction as a Link drop was seen with BRCM in SRA Enabled, Capped Rate profile
                                    //s_Lp = (s_Lp/8)*8;

                                    //Determine TpMax to meet overhead rate
                                    MULS32x16(l_temp1, s_CWSize, gs_MinDSOverheadRate);
                                    MULS16(l_temp2, (s_M<<2), s_Lp);
                                    s_TpMax = (uint16) (l_temp2 / l_temp1);
                                    if (s_TpMax > 64) s_TpMax=64;

                                    s_TpMin = (uint16) (l_temp2 /(s_CWSize * s_MaxOHRate));

                                    if (s_TpMin <1) s_TpMin = 1;

                                    // possible due to truncating TpMin
                                    MULS16(l_temp1, s_CWSize, (s_MaxOHRate * s_TpMin));
                                    if (l_temp2 > l_temp1 ) s_TpMin++;


                                    for (s_Tp = s_TpMax; s_Tp >= s_TpMin; s_Tp--)
                                    {
                                        // determine net data rate
                                        // check that it is an acceptable solution in the range of interest
                                        MULS16(l_temp1, ( s_minnetdatarate<<2), s_CWSize);
                                        l_temp1 = l_temp1 * s_Tp;
                                        MULS16(l_temp2, ((gs_maxdatarate + s_leeway)<<2), s_CWSize);
                                        l_temp2 = l_temp2 *s_Tp;
                                        s_TpKp = s_Tp * s_Kp;
                                        MULS16(l_temp3, s_M , s_Lp);

                                        l_temp3=l_temp3 * 4 * (s_TpKp - 1);
                                        if ((l_temp1 <= l_temp3) && (l_temp3 <= l_temp2))
                                        {
                                            gs_iter_conv = 1;
                                            break;
                                        }



                                    } // s_Tp

                                    if (gs_iter_conv ==1)
                                    break;

                                } //Lp
                                if (gs_iter_conv ==1)
                                break;

                            } // cw

                            if (gs_iter_conv == 1)
                            break;



                        } //s_M
                        if (gs_iter_conv == 1)
                        break;

                    } // s_R
                    if (gs_iter_conv == 1)
                    break;

                }// s_D_Array
                if (gs_iter_conv == 1)
                break;

                s_MaxTotalRate_high_end = s_MaxTotalRate_low; // reset to lower end
                s_numloop_limitedrate++;

            } // minrate


            if (gs_iter_conv==1)
            {
                sa_Bpn[0]= (s_Kp - 1);
                Save_ValidPMS(s_D, s_M,  s_R,  s_Tp, (int16) s_Lp, &sa_Bpn[0], (int16)LP0_DATA_PATH, &gt_PMSParams);
                gs_found_valid_config = 1;
            }
            else
            gs_found_valid_config=0;

            if (gs_found_valid_config == 1)
            gft_BitloadOK = SUCCEED;
            else
            {
                gft_BitloadOK = FAIL;
                /* No Valid Configuration found */
                gus_BitloadExceptionCode = E_CODE_BITLOAD_NOVALID_CONFIG;
                gus_ExceptionCode      = E_CODE_BIT_LOADING_FAILURE;
                gs_InitFailCauseNearEnd   = 2;
                return;
            }
        } // if fixed rate
    }  // if (!gft_flagexplicitrate)
    if ((((gs_flag_limitedrate==1)||(gs_flag_fixedrate==1) ||  (s_flag_Lptruncate == 1)) && (gs_found_valid_config == 1)) ||(gft_flag_explicitrate))
    {
        // compute the bat table
        if (!gft_flag_explicitrate)
        {
            s_final_Lp = gt_PMSParams.s_Lp[LP0_DATA_PATH] ;
            s_R = gt_PMSParams.s_Rp[LP0_DATA_PATH];
            s_D = gt_PMSParams.s_Dp[LP0_DATA_PATH];
            //Use RS and TCM coding gains (in Q15.1 format) in computing channel capacity
            s_RSCodingGain =  GetCodingGain_BIS(s_R, s_D);

            /*Store coding gain in Q8.8 format*/
            gsa_TotalCodingGain[LP0_DATA_PATH] = (int16)(s_RSCodingGain);

        }
        else
        {
            s_final_Lp = gt_rx_config.s_Lp[LP0_DATA_PATH] + gt_rx_config.s_Lp[LP1_DATA_PATH];
            /* Use the maximum coding gain (in Q15.1 format) in computing channel capacity   */
            gsa_TotalCodingGain[LP0_DATA_PATH] = GetCodingGain_BIS(gt_rx_config.s_Rp[LP0_DATA_PATH], gt_rx_config.s_Dp[LP0_DATA_PATH] );
            gsa_TotalCodingGain[LP1_DATA_PATH] = GetCodingGain_BIS(gt_rx_config.s_Rp[LP1_DATA_PATH], gt_rx_config.s_Dp[LP1_DATA_PATH]);

            if (gt_rx_config.s_Rp[LP0_DATA_PATH] < gt_rx_config.s_Rp[LP1_DATA_PATH])
            {
                s_RSCodingGain = gsa_TotalCodingGain[LP1_DATA_PATH];
                s_R = gt_rx_config.s_Rp[LP1_DATA_PATH];
            }
            else
            {
                s_RSCodingGain = gsa_TotalCodingGain[LP0_DATA_PATH];
                s_R = gt_rx_config.s_Rp[LP0_DATA_PATH] ;
            }

        }
        gft_BitloadOK = InitBitloading(s_path);

        // Adjust Constellation SNR if Trellis is on
        if (gft_TcmFlag_bis_DS == TRUE)
        AdjustTcmCodingGains(s_R);

        OffsetSNRRequired(s_RxDesiredMargin , gsa_SNRRequired);

        /* Add coding gain to SNRs */
        AddCodingGainToSnr(gsa_MedleySnrBuf, s_RSCodingGain, gpsa_MeasuredSnrBuf, s_path);

        // reset the flag to add extra fine gain for forceeven1bit
        gft_extrafinegainallocated =0;

        // Redo bi / gi computation ensuring RMS fine gain is -ve

        // reset the flag to add extra fine gain for forceeven1bit
        gft_extrafinegainallocated =0;

        /*  Allocate s_finalLp_computed bits using bi / gi as much as necessary*/
        gft_BitloadOK = (FlagT)CalcMaxBits(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxExtraBits, &gus_ncloaded, &gs_RxAvFineGain, s_final_Lp, s_path);


        if ((gft_BitloadOK ==FAIL)&& (!gft_flag_explicitrate))
        {
            if (gs_forceeven1bit_notonefound ==1)
            {
                // try for fixed rate as well as explicit rate case with Lp reduced by 1 bit
                // we may need to find a different configuration but will add that later if needed

                gt_PMSParams.s_Lp[LP0_DATA_PATH] -= 1;
                s_final_Lp = gt_PMSParams.s_Lp[LP0_DATA_PATH] ;
                sa_Bpn[0]= gt_PMSParams.sa_Bpn[LP0_DATA_PATH][0];
                s_final_Rp = gt_PMSParams.s_Rp[LP0_DATA_PATH];
                s_final_Mp = gt_PMSParams.s_Mp[LP0_DATA_PATH];
                s_final_Tp = gt_PMSParams.s_Tp[LP0_DATA_PATH];
                s_final_Dp = gt_PMSParams.s_Dp[LP0_DATA_PATH];


                // Check for all the constraints with modified L
                gft_BitloadOK = Check_PMSConstr(s_final_Dp,s_final_Rp, s_final_Mp, s_final_Tp, &sa_Bpn[0], s_final_Lp, s_max_latency);

                if (gft_BitloadOK ==FAIL)
                //Choose best PMS params
                gft_BitloadOK = Choose_PMS_Params_Ph2(&s_final_Lp, s_final_Dp, s_final_Rp, &s_M, &s_T, &sa_Bpn[0], &gs_CWSize, s_max_latency, (int16) LP0_DATA_PATH);

                if (gft_BitloadOK ==FAIL)
                {
                    /* Set exception code */
                    gus_BitloadExceptionCode = E_CODE_BITLOAD_LPMINUS1_NOTSATISFYCONSTR;
                    gus_ExceptionCode = E_CODE_BIT_LOADING_FAILURE;
                    gs_InitFailCauseNearEnd = 2;
                }
                else
                {
                    // Save the new configuration (both limited/ fixed rate cases
                    Save_ValidPMS(s_D, s_M,  s_R,  s_T,  s_final_Lp, &sa_Bpn[0], (int16)LP0_DATA_PATH, &gt_PMSParams);

                    // fixed rate cases, check the achieved data rate
                    if (gs_flag_fixedrate ==1)
                    {
                        CompRate(&sa_Bpn[0], s_T, s_final_Lp,gs_minnetdatarate, s_M, s_R, &l_datarate, &l_temp_diff_datarate, &s_delta_Lp, &l_mindatarate, &l_maxdatarate);

                        if( (l_datarate >= l_mindatarate)&&(l_datarate <=l_maxdatarate) )
                        {
                            gft_BitloadOK = SUCCEED;
                        }
                        else
                        {
                            // rate constraint not met
                            gft_BitloadOK = FAIL;

                            /* Set exception code */
                            gus_BitloadExceptionCode = E_CODE_BITLOAD_LPMINUS1_RATEFAIL;
                            gus_ExceptionCode = E_CODE_BIT_LOADING_FAILURE;
                            gs_InitFailCauseNearEnd = 2;
                            return;

                        }
                    }
                }
            }
            else
            {
                /* Set exception code */
                gus_BitloadExceptionCode = E_CODE_BITLOAD_ALLOCFIXED_RATE_FAIL;
                gus_ExceptionCode = E_CODE_BIT_LOADING_FAILURE;
                gs_InitFailCauseNearEnd = 2;
                return;
            }

        }

    }

    // computed for Adaptive rate as well as fixed rate, as well as explicit rate
    if(gft_BitloadOK == SUCCEED)
    {
        if(!gft_flag_explicitrate)
        {
            // calculate limits on PER and range of SEQ which the resultant parameters can support.
            // Assumption that we ahve only single latency path

            sa_Bpn[0]= gt_PMSParams.sa_Bpn[LP0_DATA_PATH][0];

            s_final_Rp = gt_PMSParams.s_Rp[LP0_DATA_PATH];
            s_final_Lp = gt_PMSParams.s_Lp[LP0_DATA_PATH];
            s_final_Mp = gt_PMSParams.s_Mp[LP0_DATA_PATH];
            // IOP_DS_BisPlus_TIAC7_RegisterBug (Start)
#ifndef ISDN   // Only for Anx-A
            // The AC7 CRC period register is only 8 bits wide so that
            // the largest CRC period can be no greater than 255.
            // Therefore, in G.bis modes if the selected framing parameters
            // are such that (Tp*SEQp) > 255, AC7 cannot support those
            // framing parameters and will not train up.
            // AC7 interop -- adjust Tp, MSGc for AC7 di_oh_period restriction:
            // Tp*SEQp = Tp*(MSGc+6) <= 255; max Tp for MSGc=1 would be 36,
            // but cap Tp at 30 to allow min MSGc of 7.
            // NOTE: must allow min PERp down to 10 msec
            if ((gs_CurrentCoChipset == TI_CO_CHIPSET) &&
                    (gl_SelectedMode & (MODE_ADSL2)))
            {
                if (gt_PMSParams.s_Tp[LP0_DATA_PATH] > 30)
                gt_PMSParams.s_Tp[LP0_DATA_PATH] = 30;
            }
#endif // ifndef ISDN
            // IOP_DS_BisPlus_TIAC7_RegisterBug (End)
            s_final_Tp = gt_PMSParams.s_Tp[LP0_DATA_PATH];
            MULS16(l_temp1, (sa_Bpn[0]  + 1), s_final_Mp);
            s_final_CW =  (int16)l_temp1 + s_final_Rp;
            s_final_Dp = gt_PMSParams.s_Dp[LP0_DATA_PATH];


            l_seq_low  = (int32)(s_per_low * (int32)s_final_Lp * s_final_Mp / (s_final_Tp * s_final_CW)) ;
            l_seq_high = (int32)(s_per_high * (int32)s_final_Lp * s_final_Mp / (s_final_Tp * s_final_CW)) ;

            // take SEQ as average of value corresponding to 15ms and 20ms PER (round thevalue)
            // divid by 4; as gs_seq_low and high are in 15.1 format

            gs_seq_final = (int16)(l_seq_low + l_seq_high + 2 ) >> 2;

            // Assuming single latency path; SEQp = MSGC + 6; for the case if we hit SEQ to be less t
            // than 7, MSGc = 0; and for higher values it is SEQp - 6


            if (gs_seq_final < 7)
            gs_MSGc_final = 0;

            else if (gt_rx_config.s_Nlp == 1)
            gs_MSGc_final = gs_seq_final - 6;

            else if (gt_rx_config.s_Nlp == 2)
            {
                // assume BC0 is mapped to Lp0, check which path is lower latency, assign IBITS to that path

                MULS16(l_temp1 , (s_final_CW <<1), s_final_Dp) ;  // don't divide by Lp to avoid loss of accuracy, instead multiply by LP with Latency for LP1

                if (l_temp1 <=  s_final_Lp) // Latency for LP1 (S*D) = 4 , as LP1 is configured as fast path with S=1, D=1
                {
                    gs_MSGc_final = gs_seq_final - 6;
                    s_SEQp_LP1=  2;
                }
                else
                {
                    gs_MSGc_final = gs_seq_final - 2;
                    s_SEQp_LP1 =  6; // if Lp1 is lower latency, then it carries indicator bits
                }
                // decide Tp for Lp1
                gt_PMSParams.s_Tp[LP1_DATA_PATH] = ((s_per_low + s_per_high)<<1)/s_SEQp_LP1;

            }
            // compute final value of PERp in 8.8 format
            gs_per_final = (gs_seq_final * s_final_Tp * s_final_CW * 512) / (s_final_Mp * s_final_Lp ) ;
            gt_PMSParams.s_MSGc = gs_MSGc_final;

        }
        // IOP_DS_BisPlus_TIAC7_RegisterBug (Start)
#ifndef ISDN   // Only for Anx-A
        // The AC7 CRC period register is only 8 bits wide so that
        // the largest CRC period can be no greater than 255.
        // Therefore, in G.bis modes if the selected framing parameters
        // are such that (Tp*SEQp) > 255, AC7 cannot support those
        // framing parameters and will not train up.
        // AC7 interop -- adjust Tp, MSGc for AC7 di_oh_period restriction:
        // Tp*SEQp = Tp*(MSGc+6) <= 255; max Tp for MSGc=1 would be 36,
        // but cap Tp at 30 to allow min MSGc of 7.
        // NOTE: must allow min PERp down to 10 msec
        if ((gs_CurrentCoChipset == TI_CO_CHIPSET) &&
                (gl_SelectedMode & (MODE_ADSL2)))
        {
            if (gt_PMSParams.s_Tp[LP0_DATA_PATH] > 30)
            gt_PMSParams.s_Tp[LP0_DATA_PATH] = 30;
            if (gt_PMSParams.s_Tp[LP0_DATA_PATH] * (gt_PMSParams.s_MSGc + 6) > 255)
            gt_PMSParams.s_MSGc =
            ((int16) (255 / gt_PMSParams.s_Tp[LP0_DATA_PATH])) - 6;
        }
#endif // ifndef ISDN
        // IOP_DS_BisPlus_TIAC7_RegisterBug (End)
        gs_RxMinMargin = 0x7FFF; /* Initialise to a large number */
        //Calulate actual fine gain and margin
        CalcMarginsAndGains(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxAvMargin, &gs_RxAvFineGain, &gs_RxMinMargin);
        //XDSLRTFW-1564 / XDSLRTFW-1665 (start)
        if((gt_INFX_CMV.us_SRA_IOP_Bits & CMV_FOR_MARGIN_ON_15BITS_TONES)
           )
        {
            // "gs_RxAvMargin " is margin without ceil on 15 bit tones "
            gs_init_AvMargin = MIN(gs_RxDesiredMargin,gs_RxAvMargin);
            gs_RxAvMargin = MAX(gs_init_AvMargin,gs_RxAvMarginWithCap);
         }
        //XDSLRTFW-1564 / XDSLRTFW-1665 (end)
        // save the average and min margin at the end of initializations
        gs_init_AvMargin = gs_RxAvMargin;
        gs_init_MinMargin = gs_RxMinMargin;

        /* compute RMS fine gain value */
        l_temp1 = (int32) ComputeRMSFineGain(guca_RxBat, gsa_RxFineGains, gs_RxNumTones, gs_CurrentCoChipset, 0, 0);

        gt_TxPMDControl.us_RMSGI_DS = 2* (ConvertToDB(l_temp1)  -  ConvertToDB(8192));

        gs_RequestedRxMaxMargin = (int16) (((int32)gt_RCMsgs1_bis.us_MAXSNRMds * 26214 ) >> 10 );  // 26214/1024 ~ 256/10


        if ((!(OPTNArray[OPTN_PwrManControl] & OPTN_ExMarginRedDisable )) && (gft_FineGainOn ==TRUE))
        {
            /* Calculate excess margin reduction in dB (EMR = min{(Average - Requested), (Minimum - Desired)}. */
            gt_FineGainInfo.s_ExcessMarRedDB = gs_RxAvMargin - gs_RequestedRxMaxMargin;
            if (gt_FineGainInfo.s_ExcessMarRedDB > gs_RxMinMargin - gs_RxDesiredMargin)
            gt_FineGainInfo.s_ExcessMarRedDB = gs_RxMinMargin - gs_RxDesiredMargin;
            /* Limit the margin reduction to 14.5dB + min_fine_gain (= 12dB, currently) from above. */
            if (gt_FineGainInfo.s_ExcessMarRedDB > 0x0E80 + gs_min_fine_gain)
            gt_FineGainInfo.s_ExcessMarRedDB = 0x0E80 + gs_min_fine_gain;
            /* Limit the margin reduction to 0dB from below. */
            if (gt_FineGainInfo.s_ExcessMarRedDB < 0)
            gt_FineGainInfo.s_ExcessMarRedDB = 0;

            /* Calculate fine gain reduction and FDQ boost. */
            gt_FineGainInfo.s_ExcessMarFGReduction = DecimalGain((int16)(-gt_FineGainInfo.s_ExcessMarRedDB));
            gs_ExcessMarFDQBoost = (int16)(0x4000000L/gt_FineGainInfo.s_ExcessMarFGReduction);
            // Modify the RMS fine gain value
            gt_TxPMDControl.us_RMSGI_DS  -= gt_FineGainInfo.s_ExcessMarRedDB;

            // Modify the average fine gain value
            gs_RxAvFineGain -= gt_FineGainInfo.s_ExcessMarRedDB;

            // Update margins based on Excess Margin Reduction
            gs_RxAvMargin -= gt_FineGainInfo.s_ExcessMarRedDB;
            gs_RxMinMargin -= gt_FineGainInfo.s_ExcessMarRedDB;
            gs_init_AvMargin -= gt_FineGainInfo.s_ExcessMarRedDB;
            gs_init_MinMargin -= gt_FineGainInfo.s_ExcessMarRedDB;
        }

        //TODO Monitored tones should have Gi range upto RMSGi ( If b i  = 0, then g i  shall be equal to 0 (linear) or in the [14.5 to RMSGI] (dB) range; )
        // Also consider after bitswap etc.,

#if 1
           if (((OPTNArray[OPTN_PwrManControl] & OPTN_MonitorToneGain )) && (gft_FineGainOn ==TRUE))
           {

                 int16 s_ch,s_SNR;
                 int16 s_MinBitsPerTone = (int16) RX_MIN_BITS_PER_TONE;
                 int16 s_SNR_Thresh = (int16) SNR_THRESH_LOAD_MIN_BITS;
                 for(s_ch = gs_RxBitLoadFirstChannel; s_ch <= gs_RxBitLoadLastChannel; s_ch++)
                 {
                    if ((guca_RxBat[s_ch] == 0)&& (gsa_RxFineGains[s_ch]!= NEG_INFINITY_DB))
                    {
                        /* Skip for the DD pilot tone */
                        if (s_ch == gs_AuxPilotToneIdx || s_ch == gs_CPilotTone)
                        continue;
                        s_SNR =  *(gpsa_MeasuredSnrBuf + s_ch);
                        if (s_SNR < gsa_SNRRequired[s_MinBitsPerTone] - s_SNR_Thresh)
                           continue;
                        else
                           gsa_RxFineGains[s_ch] = gt_TxPMDControl.us_RMSGI_DS;
                    }
                 }
            }
#endif

        // Report DS margin as 6 when it is 5.8 or 5.9
        // XDSLRTFW-275: SMS00842168 REPORT_DS_ALL_ALL_CeilDSmarginTo6dB (Start)
        if ((gs_RxAvMargin > 0x05CC) && (gs_RxAvMargin < 0x0600))   // 0x05CC is 5.79dB in 6.6 format
           gs_RxAvMargin = 0x0600; // 0x0600 is 6dB in 8.8. format
        // XDSLRTFW-275: SMS00842168 REPORT_DS_ALL_ALL_CeilDSmarginTo6dB (End)

        // for BIS ovhd update test parameter usage
        // set the default value of "external" copy of SNRM
        gs_RxSNRM_ovhd = gs_RxAvMargin ;

    } // if (gft_BitloadOK = SUCCEED)
}

/*^^^
 *-----------------------------------------------------------------------------
 *
 *   Prototype:
 *       FlagT get_framingRT(uint16 us_s_COCPE, uint16 us_d_COCPE, uint16 us_LpAvailable,
                    uint16 us_ETR_min, uint16 us_ETR_max, uint16 us_net_max,
 *                uint16 us_SpMinInvers, uint16 us_QSmin, uint16 us_QSmax, uint16 us_RTmemMax,
 *                  uint16 us_delay_max, uint16 us_INP_min, uint16 us_INP_min_rein, uint16 ft_ia_rein_flag,
 *             uint16 us_SHINEratio, uint16 us_CIP)
 *
 *   Description:
 *   This function calculates Framing Parameters for Universal Retransmission.
 *   This function is called following the MEDLEY based SNR calculation and the
 *   calculation of LpAvailable. Note that the assumed ReTx Coding Gain has to be applied
 *   for the calculation of Lp. This function is called when ReTx is enabled.
 *   It calculates Framing Parameters for Latency Path 0 and 1.
 *
 * Input Arguments:
 *      us_s_COCPE        sum of s_CO and c_CPE in symbols
 *      us_d_COCPE        sum of d_CO and d_CPE in DTUs
 *       us_LpAvailable    calculated max Lp
 *       us_ETR_min        minimum required ETR (here called NDR_eff) in kbit/s
 *       us_SpMinInvers    1/SpMin for latency path 1 connected with bearer channel 0
 *      us_QSmin          minimum allowed DTU size in x.2 format (assumption: fits into x.2 format)
 *       us_QSmax          maximum allowed DTU size in x.2 format (should not be greater than 4)
 *       us_RTmemMax       maximum available memory for RT in bytes
 *      us_delay_max      maximum delay in ms (valid values are 1..63)
 *      us_INP_min        min INP against SHINE in symbols
 *      us_INP_min_rein  min INP against REIN in symbols
 *       ft_ia_rein_flag   0: 100 Hz REIN; 1: 120 Hz REIN
 *       us_SHINEratio     average loss ratio due to SHINE in multiple of 0.1 %; range: 0..255
 *      us_net_max        maximum allowed NDR in kbit/s
 *       us_MSGmin         MSGmin
 *      us_CIP            Channel optimization policy
 *
 * Output Arguments:
 *      us_bitload_ok             0: Framing Parameter Generation failed; 1: Valid Framing Parameters found
 *   Returns:
 *
 * Global Variables:
***********************************************************************************/

FlagT get_framingRT(uint16 us_s_COCPE, uint16 us_d_COCPE, uint16 us_LpAvailable,
                    uint16 us_ETR_min, uint16 us_ETR_max, uint16 us_net_max,
                    uint16 us_SpMinInvers, uint16 us_QSmin, uint16 us_QSmax, uint16 us_RTmemMax,
                    uint16 us_delay_max, uint16 us_INP_min, uint16 us_INP_min_rein, uint16 ft_ia_rein_flag,
                    uint16 us_SHINEratio, uint16 us_CIP)
{
   FlagT ft_bitload_ok;
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links Begin
   FlagT ft_INP_met = 0;
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links End
   uint16 us_Mp     = 1;                 // not a variable anymore
   // us_SpMin      = 256/SpMinInvers;   // for Mp=1 -> x.2
   uint16 us_SpMax  = 128;               // for Mp=1 32 -> x.2
   uint16 us_Rp     = 4;                 // not a variable anymore
   //Change_lower_limit_Lp_Rolands_suggestion Begin
   // LpLimitVector = 250:LpAvailable;
   // LpLimitVector = 118:LpAvailable;
   //Change_lower_limit_Lp_Rolands_suggestion End

   uint16 us_ndr_effActual = us_ETR_min;
   //XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr (START_END)
   uint32 ul_ndr_effActual = us_ETR_min * 1000;
   uint16 us_ndrActual     = 0;
   uint16 us_etrActual     = 0;
   //XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr (START_END)
   uint32 ul_etrActual     = 0;
   uint16 us_NpActual      = 0;
   uint16 us_LpActual      = 0;
   uint16 us_RpActual      = 0; // currently fixed
   uint16 us_QActual       = 0;
   uint16 us_VActual       = 0;
   uint16 us_HActual       = 0; // maybe we don't have to calculate this here
   uint16 us_BpActual      = 0; // maybe we don't have to calculate this here
   uint16 us_MpActual      = 0; // Fixed to 1
   uint16 us_DpActual      = 0; // currently fixed to 1
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links Begin
//Roland_mod_27July
   uint16 us_QtxActual      = 0; // RZ--change v13
//Roland_mod_27July
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links End

   uint16 us_TpActual = 0;    //FEATURE_DS_BisPlus_ALL_ForceExplicitFramingForURETX (Start_End)
   // Calculate Starting Value of Lp
   // LpMinimal=ceil((H_Q_V(1,1)+Rp)*8/QSmax); --> ceil((55+Rp)*8/QSmax) --> QSmax is in x.2 format
   uint16 us_Lp            = (((55+us_Rp)<<5)+us_QSmax-1)/us_QSmax;
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_search_range_Lp1 Begin
   // change v11: LpMax = min(LpAvailable,8*255*SpMinInverse)
   // change v12: take also care of netMax -> us_LpNetMax = ceil(net_max*1.12/4) = ceil(net_max*7/25);
   uint16 us_LpMax         = (255*us_SpMinInvers)<<3; // 8*255*SpMinInverse
   uint16 us_LpNetMax      = (unsigned short)( ((unsigned long)(us_net_max)*7+24)/25 );
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_search_range_Lp1 End


   RTParam_t p;
   //FEATURE_ALL_BisPlus_ALL_TS_Modification_for_S_greater_than_1 Begin
   uint32 l_temp;
   //FEATURE_ALL_BisPlus_ALL_TS_Modification_for_S_greater_than_1 End

   // loop over all allowed Lp values
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_search_range_Lp1 Begin


   us_LpMax = (us_LpMax < us_LpNetMax) ? us_LpMax : us_LpNetMax;

   // change v8: search range is now Lp_available-1000:1:LpAvailable
   //            Fallback solution if calculation time turns out to be too high:
   //                                Lp_available-1000:10:Lp_available-100
   //                            and Lp_available-100 :1 :Lp_available

   if(us_LpAvailable<us_LpMax)
   {
      us_LpMax = us_LpAvailable;
   }

   if( (us_Lp+1000) < us_LpMax)
   {
      us_Lp = us_LpMax - 1000;
   }
   // change v8 end
    // loop over all allowed Lp values
   while (us_Lp <= us_LpMax)
   {
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_search_range_Lp1 End
      p = get_framingparamsRT(us_Lp,us_Rp,us_SpMinInvers,us_SpMax,us_QSmin,us_QSmax,
      us_s_COCPE,us_d_COCPE,us_RTmemMax,us_delay_max,
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc Begin
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links Begin
            us_INP_min,us_INP_min_rein,ft_ia_rein_flag,us_SHINEratio, us_net_max,
            &ft_INP_met);
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links End
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc End

      if((us_CIP==0) || (p.us_ndr_eff<=us_ETR_max))
      { // if CIP==1 we have to check whether NDR_eff<=NDR_eff_max
         if(p.us_ndr_eff>=us_ndr_effActual)
         {
            if(p.us_ndr <= us_net_max)
            {  // Found valid configuration with best NDR_eff
               us_ndr_effActual = p.us_ndr_eff;
               //XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr (START_END)
               ul_ndr_effActual = p.ul_ndr_eff;
               us_ndrActual     = p.us_ndr;
               us_LpActual      = us_Lp;
               us_NpActual      = p.us_Np;
               us_QActual       = p.us_Q;
               us_VActual       = p.us_V;
               us_RpActual      = us_Rp;
               us_QtxActual     = p.us_Qtx;
            }
         }
      }
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_search_range_Lp1 Begin

      // Fallback solution if the Standard solution (us_Lp++1) turns out to be too slow
      /*
      if( (us_Lp + 100)<us_LpMax) {
         us_Lp += 10;
      }
      else {
            us_Lp++;
      }
      // Fallback solution end
      */
      // Standard solution
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_search_range_Lp1 End
      us_Lp ++;
   } // while

//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links Begin
   if (us_NpActual==0)
   { // No solution found
        ft_bitload_ok=0;
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links End
   }
   else
   {
      ft_bitload_ok=1;
      us_HActual  = us_NpActual-us_RpActual;
      us_MpActual = us_Mp;
      us_BpActual = us_HActual/*/us_MpActual*/-1;
      us_DpActual = 1;
      if(us_ndr_effActual > us_ETR_max)
      { // ToDo ???
         us_etrActual = us_ETR_max;
         //XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr (START_END)
         //ul_etrActual = us_ETR_max * 1000; //Commenting out as FW has to report in Kbps
         ul_etrActual = us_ETR_max;
      }
      else
      {
         us_etrActual = us_ndr_effActual;
         //XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr (START_END)
         //ul_etrActual = ul_ndr_effActual; //Commenting out as FW has to report in Kbps
         ul_etrActual = (uint32)us_ndr_effActual;
      }
   }


   //FEATURE_DS_BisPlus_ALL_ForceExplicitFramingForURETX (Start)
//   if(gs_Force_ReTx_Framing)
   if(gt_ReTxConfigInfo.us_Force_Explicit_Framing)
   {

      if(gt_rx_config.s_Lp[1]<= us_LpActual)
      {
         us_DpActual = gt_rx_config.s_Dp[1];
         us_MpActual = gt_rx_config.s_Mp[1];
         us_RpActual = gt_rx_config.s_Rp[1];
         us_LpActual = gt_rx_config.s_Lp[1];
         us_BpActual = gt_rx_config.sa_Bpn[1][0];
         us_TpActual = gt_rx_config.s_Tp[1];

         us_QActual  = gt_ReTxConfigInfo.us_Q;
         us_VActual  = gt_ReTxConfigInfo.us_V;
         us_HActual  = (us_BpActual+1) - us_RpActual;
         us_ndrActual = gt_ReTxConfigInfo.us_ndr;
         us_ndr_effActual = gt_ReTxConfigInfo.us_ndr_eff;
         us_etrActual = gt_ReTxConfigInfo.us_etr;
         us_QtxActual = gt_ReTxConfigInfo.us_Qtx;

         //XDSLRTFW-1634 (Start_End)
         us_NpActual  = us_HActual+us_RpActual;
      }
      else ft_bitload_ok= 0;
   }

   //FEATURE_DS_BisPlus_ALL_ForceExplicitFramingForURETX (End)

   // Store Framing Parameters for LP0
   gt_PMSParams.s_Dp[1]      = us_DpActual;
   gt_PMSParams.s_Mp[1]      = us_MpActual;
   gt_PMSParams.s_Rp[1]      = us_RpActual;
   //Modification_R_det_only Begin
   gt_ReTxConfigInfo.us_RDetOnly = us_RpActual;
   //Modification_R_det_only End
   gt_PMSParams.s_Tp[1]      = -1; // TODO: infinity
   gt_PMSParams.s_Lp[1]      = us_LpActual;
   gt_PMSParams.sa_Bpn[1][0] = us_BpActual;
   gt_PMSParams.sa_Bpn[1][1] = 0;
   // ReTx Output Parameters
   gt_ReTxConfigInfo.us_Q           = us_QActual;
   gt_ReTxConfigInfo.us_V           = us_VActual;
   gt_ReTxConfigInfo.us_H           = us_HActual;     // not really required: H = N1-R1
   gt_ReTxConfigInfo.us_LpAvailable = us_LpAvailable; // Debug
   gt_ReTxConfigInfo.us_ndr         = us_ndrActual;
   gt_ReTxConfigInfo.us_ndr_eff     = us_ndr_effActual;
   gt_ReTxConfigInfo.us_etr         = us_etrActual;
   //XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr (START_END)
   gt_ReTxConfigInfo.ul_etr         = ul_etrActual;
   gt_ReTxConfigInfo.us_Qtx         = us_QtxActual;

   //FEATURE_ALL_BisPlus_ALL_TS_Modification_for_S_greater_than_1 Begin
   l_temp = us_NpActual << 16;
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links Begin
//Roland_mod_27July
   if(us_LpActual>0)
     gus_S = l_temp /us_LpActual;//3.13 format
   else
     gus_S=0;
//Roland_mod_27July
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links End
   //FEATURE_ALL_BisPlus_ALL_TS_Modification_for_S_greater_than_1 End
//FEATURE_DS_BisPlus_ALL_ReTx_Modified_HEC_Error_Count Begin
   gus_A = ((gt_ReTxConfigInfo.us_Q)*(gt_ReTxConfigInfo.us_H) - gt_ReTxConfigInfo.us_V - 2)/53;
//FEATURE_DS_BisPlus_ALL_ReTx_Modified_HEC_Error_Count End

   //XDSLRTFW-1410: BugFix_DS_ADSL_ALL_ReTX_Delay (Start)
   //delay_act_RTX = round(Tdtu*Tdmt)
   //Tdtu = Q*8*NFEC/LSYMB,
   uint16 DtuSize = ((us_QActual * us_NpActual) << 11)/us_LpAvailable; //Q8.8
   //Tdmt = 0.25 if VDSL2 profile 8/12/17, Tdmt = 0.125 if VDSL2 profile 30, Tdmt = 0.25*68/69 if ADSL2( + )
   //Delay in ms
   gt_ReTXStats.us_ReTX_ReceiverActualDelay = (((DtuSize/4)+(1 << 7)) >> 8); //0.5 in Q8.8 => (1 << 7)
   //Report Delay in 0.01 milli seconds granularity to the near-end
   gt_ReTXStats.us_ReTX_ReceiverActualDelay *= 100;
   //XDSLRTFW-1410: BugFix_DS_ADSL_ALL_ReTX_Delay (End)

   //XDSLRTFW-1634 (Start)
   {
      uint32 ul_temp1, ul_temp2;
      uint16 us_tmp1, us_tmp2;

      //NRET = floor((delay_max * fs)/(Qtx*Q*S)) => Sec 8.6.4 in G.998.4
      //S = (Q*N*8)/Lp
      //NRET = floor((delay_max * fs * Lp)/(Qtx*Q*N*8))

      // in v8 we calculate MinDataSymbolsDelaymax = floor(delay_max/Tdmt) - ceil(delay_max/Tsync);
      // we don't have to multiply the result by 17 anymore
      us_tmp1 = (69*us_delay_max)/17; // MinDataSymbolsDelaymax; 1<=delaymax<=63
      us_tmp1 -= (us_delay_max+16)/17;
      ul_temp1 = us_tmp1 * us_LpActual; //(delay_max*fs*Lp)

      us_tmp2 =  (us_QActual*us_NpActual)<<3; //(Q*N*8)
      ul_temp2 = us_QtxActual * us_tmp2; //(Qtx*Q*N*8)

      guc_NRET = (uint8)(ul_temp1/ul_temp2);

      gus_DTUSizeInSymbolsDS = DtuSize; //Q8.8
   }
   //XDSLRTFW-1634 (End)

   // These are the calculated Framing Parameters that have to be stored
     /*
     if(ft_bitload_ok == 1) {
//      printf("Latency Path 0: Overhead Channel\n");
//      printf("L0           = %i bits per symbol\n",us_L0);
//      printf("D0           = %i \n",us_D0);
//      printf("B0           = %i \n",us_B0);
//      printf("T0           = %i \n",us_T0);
//      printf("R0           = %i \n",us_R0);
//      printf("M0           = %i \n",us_M0);
//      printf("SEQ          = %i \n",us_SEQ);
//      printf("MSGc         = %i \n",us_MSGc);

      printf("\nLatency Path 1: Data Channel\n");
      printf("L1           = %i bits per symbol\n",us_LpActual);
      printf("Q            = %i FEC frames per DTU\n",us_QActual);
      printf("V            = %i padding bytes per DTU\n",us_VActual);
      printf("H            = %i bytes per FEC frame reduced by RS bytes\n",us_HActual);
      printf("R1           = %i RS bytes per FEC frame\n",us_RpActual);
      printf("M1           = %i mux data frames per FEC frame\n",us_MpActual);
      printf("B1           = %i bytes per mux data frame\n",us_BpActual);
      printf("D1           = %i\n",us_DpActual);
      printf("T1           = infinity\n");
      printf("TDRavailable = %i kbit/s\n",us_LpAvailable<<2);
      printf("TDR          = %i kbit/s\n",us_LpActual<<2);
      printf("NDR          = %i kbit/s\n",us_ndrActual);
      printf("NDReff       = %i kbit/s\n",us_ndr_effActual);
      printf("ETR          = %i kbit/s\n",us_etrActual);
     }
     */


   return ft_bitload_ok;
}


/*^^^
 *-----------------------------------------------------------------------------
 *
 *   Prototype:
 *       RTParam_t get_framingparamsRT(uint16 us_Lp,uint16 us_Rp, uint16 us_SpMinInvers,
 *                            uint16 us_SpMax, uint16 us_QSmin, uint16 us_QSmax,
 *                            uint16 us_s_COCPE, uint16 us_d_COCPE, uint16 us_RTmemMax,
 *                            uint16 us_delay_max, uint16 us_INP_min, uint16 us_INP_min_rein,
 *                            uint16 ft_ia_rein_flag, uint16 us_SHINEratio, uint16 us_net_max,
 *                            FlagT *pft_INP_met)
 *
 *   Description:
 *   This function calculates Framing Parameters Latency Path 1 for Universal Retransmission for a given Lp.
 *   This function is called by get_framingRT.
 *
 * Input Arguments:
 *       us_Lp                Lp
 *      us_Rp                Rp (usually 4)
 *       us_SpMinInvers       1/SpMin for latency path 1 connected with bearer channel 0
 *      us_SpMax             max Sp value for latency path 1 in x.2 format
 *      us_QSmin             minimum allowed DTU size in x.2 format (assumption: fits into x.2 format)
 *       us_QSmax             maximum allowed DTU size in x.2 format (should not be greater than 4)
 *      us_s_COCPE           sum of s_CO and c_CPE in symbols
 *      us_d_COCPE           sum of d_CO and d_CPE in DTUs
 *      us_RTmemMax          max available memory for RT in byte
 *      us_delay_max         max delay in ms (valid values are 1..63)
 *      us_INP_min           min INP against SHINE
 *      us_INP_min_rein      min INP against REIN in symbols
 *       ft_ia_rein_flag      0: 100 Hz REIN; 1: 120 Hz REIN
 *       us_SHINEratio        average loss ratio due to SHINE in multiple of 0.1 %; range: 0..255
 *      us_net_max           maximum allowed NDR in kbit/s
 *
 * Output Arguments:
 *      RTParam_t p           Structure that contains the calculated framing parameters:
 *             p.us_ndr_eff  NDR_eff in kbit/s
 *              p.us_ndr      NDR     in kbit/s
 *              p.us_Np       Np
 *              p.us_Q        Q
 *              p.us_V        V
 *
 *   Returns:
 *
 * Global Variables:
***********************************************************************************/

RTParam_t get_framingparamsRT(uint16 us_Lp, uint16 us_Rp, uint16 us_SpMinInvers,
               uint16 us_SpMax, uint16 us_QSmin, uint16 us_QSmax,
               uint16 us_s_COCPE, uint16 us_d_COCPE, uint16 us_RTmemMax,
               uint16 us_delay_max, uint16 us_INP_min, uint16 us_INP_min_rein,
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc Begin
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links Begin
               uint16 ft_ia_rein_flag, uint16 us_SHINEratio, uint16 us_net_max,
                 FlagT *pft_INP_met)
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links End
{

//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc End


   RTParam_t p;

//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc Begin

   // change v8: us_beta -> ul_beta
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc End

   uint16 us_H, us_Np, us_Q, us_V, us_LpMin, us_LpMax, us_i, us_Nrtx = 0,
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc Begin

   us_DTUs, us_Qtx, us_Qtxmax, us_alpha, us_NretQtxFound, us_INP,
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc End

   us_tmp1, us_tmp2;
   uint32 ul_tmp, ul_tmp1, ul_tmp2, ul_ndr_1, ul_ndr_eff_1, ul_ndr, ul_ndr_eff,
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc Begin

   ul_ndr_max, ul_A, ul_k_min, ul_k_max, ul_NRET, ul_NRETmax,
//SMS01527668:FIX_DS_BisPlus_ALL_ReTx_REIN_OH_not_OK Begin
   ul_REINloss, ul_SHINEloss, ul_TRELLISloss, ul_beta,
   ul_num1, ul_den, ul_delta;
//SMS01527668:FIX_DS_BisPlus_ALL_ReTx_REIN_OH_not_OK End
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc End


   ul_ndr      = 0;
   ul_ndr_eff  = 0;
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc Begin

   ul_ndr_max  = 1000 * (unsigned long)(us_net_max);
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc End
   p.us_ndr_eff = 0;
   p.us_ndr     = 0;
   p.us_Np      = 0;
   p.us_Q       = 0;
   p.us_V       = 0;

   for (us_i=0;us_i<19;us_i++)
   {
      //XDSLRTFW-3684 (Start)
      if (gus_Required_TC_Info == ATM_TC)
      {
         us_H  = guca_v_H_ATM[us_i];
         us_Q  = guca_v_Q_ATM[us_i];
         us_V  = guca_v_V_ATM[us_i];
      }
      else
      {
         us_H  = guca_v_H_EFM[us_i];
         us_Q  = guca_v_Q_EFM[us_i];
         us_V  = guca_v_V_EFM[us_i];
      }
      us_Np = us_Rp+us_H;
      //XDSLRTFW-3684 (End)

      //FEATURE_DS_BisPlus_ALL_Force_Q Begin
      if((gt_ReTxConfigInfo.us_Force_Q == 1) &&(us_i >=4))
      {
         us_H = 214;
         us_Np = us_Rp+us_H;
         us_Q = 1;
         us_V = 0;
      }
      //FEATURE_DS_BisPlus_ALL_Force_Q End

      // Note: SpMax and QSmin/max are in x.2 format; SpMinInvers is in
      // x.0 format
      // LpMin = max(ceil(8*Np/SpMax), ceil(8*Q*Np/QSmax)); % low limit due to SpMax and QSmax
      // LpMax = min(floor(8*Np/SpMin), floor(8*Q*Np/QSmin)); % Lp limited by SpMin and QSmin
      us_tmp1  = us_Np<<5;                           // x.2
      us_LpMin = (us_tmp1+us_SpMax-1)/us_SpMax;      // x.0
      us_LpMax = (us_Np<<3) * us_SpMinInvers;        // x.0

      us_tmp1 = us_tmp1*us_Q;                        // x.2
      us_tmp2 = (us_tmp1+us_QSmax-1)/us_QSmax;       // x.0

      if(us_tmp2>us_LpMin)
      {
         us_LpMin=us_tmp2;
      }

      us_tmp2 = us_tmp1/us_QSmin;                    // x.0

      if(us_tmp2<us_LpMax)
      {
         us_LpMax=us_tmp2;
      }

      if (us_Lp<us_LpMin || us_Lp>us_LpMax)
      {
         continue;
      }

      // Roundtrip4 = s_COCPE+(d_COCPE)*DtuSize; % 4*roundtrip in ms
      // DTUs       = ceil(Roundtrip4/DtuSize);  % RtInDTUs
      // DtuSize    = Q*Sp=8*Q*Np/Lp ->
      // DTUs       = ceil( (s_COCPE*Lp + d_COCPE*8*Q*Np) / (8*Q*Np) )
      //            = ceil(s_COCPE*Lp/(8*Q*Np)) + d_COCPE

      ul_tmp  = (unsigned long)(us_Lp) * (unsigned long) us_s_COCPE;
      us_tmp1 =  (us_Q*us_Np)<<3;  // we keep this value!

      us_DTUs = (unsigned short)((ul_tmp+us_tmp1-1)/us_tmp1) + us_d_COCPE; // explicit type casting to suppress warning

      // Check memory and INP constraints
      us_Qtx = us_DTUs;

      us_Qtxmax = us_RTmemMax / (us_Q*us_H);
      if (us_Qtxmax>63)
      {
         us_Qtxmax=63;
      }

      if(us_INP_min_rein>0)
      {
         // Nrtx=ceil(INP_min_rein/DtuSize)+1;
         // DtuSize   = Q*Sp = 8*Q*Np/Lp;
         ul_tmp  = (unsigned long)us_INP_min_rein*(unsigned long)us_Lp;
         us_Nrtx = (unsigned short)((ul_tmp+us_tmp1-1)/us_tmp1)+1;
         if(ft_ia_rein_flag==0)
         {
            // Qtxmax=min(Qtxmax,floor(39/DtuSize-Nrtx));
            us_tmp2 = (unsigned short)((39*(unsigned long)(us_Lp))/us_tmp1) - us_Nrtx;
         }
         else
         {
            //Qtxmax=min(Qtxmax,floor(32/DtuSize-Nrtx));
            us_tmp2 = (us_Lp<<2)/(us_Q*us_Np) - us_Nrtx;
         }

         if(us_tmp2<us_Qtxmax)
            us_Qtxmax=us_tmp2;
      }

      if(us_Qtx>us_Qtxmax)
      {
         continue;
      }

      if ( (us_INP_min>0) || (us_INP_min_rein>0) )
      { // inp_calc==1
         us_INP=0;

         // MinDataSymbolsDelaymax = (delay_max/Tdmt) - ceil(delay_max/Tsync);
         //                        = 69*delay_max/17 - ceil(delay_max/17);
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc Begin

         /* change v8
         us_tmp2 = 69*us_delay_max; // 17*MinDataSymbolsDelaymax; 1<=delaymax<=63
         us_tmp2 -= 17 * ((us_delay_max+16)/17); // required because of the ceil() function
         */
         // in v8 we calculate MinDataSymbolsDelaymax = floor(delay_max/Tdmt) - ceil(delay_max/Tsync);
         // we don't have to multiply the result by 17 anymore
         us_tmp2 = (69*us_delay_max)/17; // MinDataSymbolsDelaymax; 1<=delaymax<=63
         us_tmp2 -= (us_delay_max+16)/17;
         /* change v8 end */

//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc End
         ul_tmp1 = (unsigned long)(us_tmp2)*(unsigned long)(us_Lp); //  nominator of NRET;

         if (us_INP_min_rein==0)
         { // SHINE only (cc==1)
            while ( (us_Qtx<=us_Qtxmax) && (us_INP<us_INP_min) )
            {
               // NRET = floor(MinDataSymbolsDelaymax/DtuSize/Qtx); % max number of retransmissions
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc Begin

               /* change v8 */
               // multiplication with 17 removed
                    ul_tmp2 = (unsigned long)(us_Qtx); // denominator of NRET =  (8*Q*Np*Qtx)
                    /* change v8 end */
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc End
                    ul_tmp2 *= us_tmp1; // 8*Q*Np
               ul_NRET = ul_tmp1/ul_tmp2;



               // INP  = floor(DtuSize*(NRET*Qtx-1));
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links Begin
//Roland_mod_27July
               // RZ bugfix v13 start
               ul_tmp = ul_NRET*us_Qtx;
               ul_tmp = (ul_tmp==0) ? 0 : (ul_tmp-1);
               ul_tmp *= us_tmp1;
               // Bugfix v13 end
//Roland_mod_27July
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links End
               us_INP = (unsigned short) (ul_tmp/us_Lp);
               if (us_INP<us_INP_min)
               {
                  us_Qtx++;
               }
            }
            if (us_INP<us_INP_min)
            {
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links Begin
//               *pft_INP_met = 0;
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links End
               continue; // no solution for i
            }
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links Begin
            else
            {
               *pft_INP_met = 1;
            }
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links End
         }
         else if (us_INP_min==0)
         { // REIN only (cc==3)
            while ( (us_Qtx<=us_Qtxmax) && (us_INP<us_INP_min_rein) )
            {
               // NRET = floor(MinDataSymbolsDelaymax/DtuSize/Qtx); % max number of retransmissions
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc Begin
               /* change v8 */
               // multiplication with 17 removed
                    ul_tmp2 = (unsigned long)(us_Qtx); // denominator of NRET
               /* change v8 end */
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc Begin
               ul_tmp2 *= us_tmp1;
               ul_NRET = ul_tmp1/ul_tmp2;
               // INP  = floor(DtuSize*(NRET*Qtx-1));
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links Begin
//Roland_mod_27July
               // RZ bugfix v13 start
               // ul_tmp = (ul_NRET*us_Qtx-1)*us_tmp1;
               ul_tmp = ul_NRET*us_Qtx;
               ul_tmp = (ul_tmp==0) ? 0 : (ul_tmp-1);
               ul_tmp *= us_tmp1;
               // bugfix v13 end
//Roland_mod_27July
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links End
               us_INP = (unsigned short)(ul_tmp/us_Lp);
               if (us_INP<us_INP_min_rein)
               {
                  us_Qtx++;
               }
            }
            if (us_INP<us_INP_min_rein)
            {
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links Begin
//               *pft_INP_met = 0;
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links End
               continue;
            }
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links Begin
            else
            {
               *pft_INP_met = 1;
            }
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links End
         }
         else // SHINE and REIN
         {
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc Begin
            // changed in v11
            us_NretQtxFound = 0;
            while ( (us_Qtx<=us_Qtxmax) && (us_NretQtxFound == 0) )
            {
               // NRETmax = floor(MinDataSymbolsDelaymax/DtuSize/Qtx); % max number of retransmissions

               ul_tmp2 = (unsigned long)(us_Qtx); // denominator of NRET

               ul_tmp2 *= us_tmp1;
               ul_NRETmax = ul_tmp1/ul_tmp2;

               // NRETmin = ceil(( ceil( INP_min*Lp/(8*Q*Np) ) +1)/Qtx)+1; -- us_tmp1 = 8*Q*Np
               ul_NRET = (unsigned long)(us_INP_min) * (unsigned long)(us_Lp);
               ul_NRET = (ul_NRET + us_tmp1 - 1) / us_tmp1;
               ul_NRET = (ul_NRET + us_Qtx)/us_Qtx;
//SMS01527668:FIX_DS_BisPlus_ALL_ReTx_REIN_OH_not_OK Begin
               // change v13
               // the +1 was missing
               ul_NRET++;
               // change v13 end
//SMS01527668:FIX_DS_BisPlus_ALL_ReTx_REIN_OH_not_OK End
               while( (ul_NRET<=ul_NRETmax) && (us_NretQtxFound == 0) )
               {
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc Begin
                  // A=ceil((NRET*Qtx+Nrtx)*DtuSize);
                  ul_A = ul_NRET * us_Qtx + us_Nrtx;
                  ul_A *= us_tmp1;
                  ul_A = (ul_A+us_Lp-1)/us_Lp;
                  if(ft_ia_rein_flag==0)
                  {
                     // k_min=ceil(A/40);
                     ul_k_min = (ul_A+39)/40;
                     if (ul_A > (ul_k_min*690)/17 - (ul_k_min*10+16)/17) // A>floor(k_min*690/17)-ceil(k_min*10/17)
                     {
                        ul_k_min++;
                     }
                  }
                  else
                  {
                  // k_min=ceil(3*A/100);
                     ul_k_min = (3*ul_A+99)/100;
                     if (ul_A > (ul_k_min*575)/23 - (ul_k_min*25+50)/51)
                     { // A>floor(k_min*575/23)-ceil(k_min*25/51)
                        ul_k_min++;
                     }
                  }
                  // A=floor((NRET*Qtx-1)*DtuSize)-INP_min_rein;
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links Begin
//Roland_mod_27July
                  // RZ bugfix v13 start
                     //ul_A = ul_NRET * us_Qtx - 1;
                  ul_A = ul_NRET * us_Qtx;
                  ul_A = (ul_A==0)? 0 : (ul_A-1);
                     ul_A *= us_tmp1;
                     //ul_A = ul_A/us_Lp - us_INP_min_rein;
                  ul_A /= us_Lp;
                  if(ul_A > us_INP_min_rein)
                     ul_A -= us_INP_min_rein;
                  else
                     ul_A = 0;
                  // RZ Bugfix v13 end
//Roland_mod_27July
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links End
                  if(ft_ia_rein_flag==0)
                  {
                     // k_max=ceil(A/40)+1;
                     ul_k_max = (ul_A+39)/40+1;
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc Begin
                     /* change v8 */
                     // if (ul_A < ((ul_k_max-1)*690 + 16)/17 -((ul_k_max-1)*10)/17)  // A<ceil((k_max-1)*690/17)-floor((k_max-1)*10/17)
                     // v8: the 2nd term in the floor() term has been added
                     // A<ceil((k_max-1)*690/17)-floor((k_max-1)*10/17+ INP_min_rein/69)
                     //                         -floor( ((k_max-1)*690 + INP_min_rein*17) / (69*17) )
                     if (ul_A < ((ul_k_max-1)*690 + 16)/17 -((ul_k_max-1)*690 + (unsigned long)(us_INP_min_rein)*17)/1173)
                     {
                        /* change v8 end */
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc End
                        ul_k_max--;
                     }
                  }
                  else
                  {
                     // k_max=ceil(A/34)+1;
                     ul_k_max = (ul_A+33)/34+1;
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc Begin
                     /* change v8 */
                     //if (ul_A < ((ul_k_max-1)*575+22)/23 - ((ul_k_max-1)*25)/51)  // A<ceil((k_max-1)*575/23)-floor((k_max-1)*25/51)




                     // v8: the 2nd term in the floor() term has been added
                     // A<ceil((k_max-1)*575/23)-floor((k_max-1)*25/51 + INP_min_rein/69)
                     //                         -floor( ((k_max-1)*25*23 + INP_min_rein*17) / (69*17) )
                     if (ul_A < ((ul_k_max-1)*575+22)/23 - ((ul_k_max-1)*25*23 + (unsigned long)(us_INP_min_rein)*17)/1173)
                     {
                        /* change v8 end */
                     //FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc End
                        ul_k_max--;
                     }
                  }
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc Begin
                  if (ul_k_min<=ul_k_max)
                  {
                     us_NretQtxFound = 1;
                  }


                  ul_NRET++;
               } /* while(NRET<=NRETmax && NretQtxFound==0) */
                  us_Qtx++;
            } /* while(Qtx<=Qtxmax  && NretQtxFound == 0)  */
            if (us_NretQtxFound == 0)
            {
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links Begin
//               *pft_INP_met = 0;
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links End
               continue;
            }
            else
            {
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links Begin
               *pft_INP_met = 1;
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links End
               us_Qtx--;
            }


         } /* SHINE and REIN */
      } /* if ( (us_INP_min>0) || (us_INP_min_rein>0) ) */
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc End
      //FEATURE_DS_BisPlus_ALL_ReTx_MGMTCntrs_TestParams (Start)

      //FEATURE_DS_BisPlus_ALL_ReTx_MGMTCntrs_TestParams (End)

         // ndr_ = 4000*Lp*(1-Rp/Np-(2+V)/(Q*Np)) = 4000*Lp*alpha/(Q*Np)
//SMS01527668:FIX_DS_BisPlus_ALL_ReTx_REIN_OH_not_OK Begin
   // calculate alpha = Q*Np-Q*Rp-2-V = Q*H - 2-V

      // change v13
      // simplified calculation of us_alpha and ul_ndr_1
      us_alpha = us_Q*us_H-2-us_V; // 16.0
      ul_num1 = (unsigned long)(4000)*us_Lp;
      ul_delta  = ul_num1 % (us_Q*us_Np);
      ul_num1  /= us_Q*us_Np;
      ul_ndr_1 = us_alpha * ul_num1 + (ul_delta * us_alpha + (us_Q*us_Np+1)) / (us_Q*us_Np);
      // change v13 end
//SMS01527668:FIX_DS_BisPlus_ALL_ReTx_REIN_OH_not_OK End
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc Begin
      /* change v12: take care of net_max */
      if(ul_ndr_1 <= ul_ndr_max)
      {
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc End
         ul_ndr_eff_1 = ul_ndr_1;

         // TRELLISratio = 1e-4;
         ul_TRELLISloss = (ul_ndr_eff_1+5000)/10000;
         // SHINEratio/1000
         if(us_SHINEratio > 128)
         {
            ul_SHINEloss   = ( ((ul_ndr_eff_1+1)>>1) * (us_SHINEratio)+250)/500;
         }
         else
         {
            ul_SHINEloss   = (ul_ndr_eff_1*us_SHINEratio+500)/1000;
         }

         if (us_INP_min_rein>0)
         {
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc Begin
//SMS01527668:FIX_DS_BisPlus_ALL_ReTx_REIN_OH_not_OK Begin

            // change  v13
            // updated calculation of REINloss
            // REINratio=(INPrein+DtuSize)/floor(Trein/Tdmt) =
            //           (INPrein+DtuSize)/40 -> 100Hz
            //           (INPrein+DtuSize)/33 -> 120Hz
            // DTUSize = 8*Q*Np/Lp
            // REINloss = ndr*REINratio = 4000*Lp*alpha/(Q*Np) * REINratio
            // beta = INPrein*Lp + 8*Q*Np
            // REINloss = 4000*alpha*beta/(40*Q*Np) -> 100Hz
            //            4000*alpha*beta/(33*Q*Np) -> 120Hz

            ul_beta = (unsigned long)(us_Lp);
            ul_beta *= us_INP_min_rein;
            ul_beta += us_tmp1; //  us_tmp1 = 8*Q*Np

            if(ft_ia_rein_flag == 0) // 100 Hz
               ul_den = (unsigned long)(40*us_Q*us_Np);
            else
               ul_den = (unsigned long)(33*us_Q*us_Np);

            ul_num1  = (unsigned long)(4000)*us_alpha;
            ul_delta = ul_num1 % ul_den;
            ul_num1 /= ul_den;

            ul_REINloss = ul_num1 * ul_beta + (ul_delta * ul_beta + ((ul_den+1)/2)) / ul_den;
            // change v13 end
//SMS01527668:FIX_DS_BisPlus_ALL_ReTx_REIN_OH_not_OK End
         }//(us_INP_min_rein>0)
         else
         {
            ul_REINloss = 0;
         }

         ul_ndr_eff_1 -= (ul_TRELLISloss + ul_SHINEloss + ul_REINloss);

         if (ul_ndr_eff_1 > ul_ndr_eff)
         {
            p.us_Np      = us_Np;
            p.us_Q       = us_Q;
            p.us_V       = us_V;
            ul_ndr_eff   = ul_ndr_eff_1;
            ul_ndr       = ul_ndr_1;
            p.us_Qtx     = us_Qtx;
         }
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc Begin
      } // if(ul_ndr1 <= ul_ndr_max)
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_data_rate_calc End
   } // end of i loop

   // output: kbit/s
   // ndr     = floor(ndr/1000);
   // ndr_eff = floor(ndr_eff/1000);
   p.us_ndr     = (unsigned short)(ul_ndr/1000);     // explicit type casting to suppress warning
   p.us_ndr_eff = (unsigned short)(ul_ndr_eff/1000);

   //XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr (START_END)
   p.ul_ndr_eff = ul_ndr_eff;

   return p;

}
//SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad (End)


/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*     Choose_PMS_Params(int16 s_L, int16 *ps_R, int16 *ps_D, int16 *ps_M, int16 *ps_T, int16 *ps_Bpn, int16 s_max_latency,
*                       int16 s_p,int16 s_DeltaLp)
*
*   Description:
*  This function computes all PMS parameters for Rx Path for BIS standard. For now,
*  this function only works when only BC0 and LP0 is used.
*
*  Input Arguments:
*     s_L : number of bits in a PMD frame
*     s_p : latency path number
*
*  Output Arguments:
*     ps_R : number of checkbytes in a CW
*     ps_D : interleave depth
*     ps_M : number of PMS frames in a CW
*     ps_T : number of PMS frames per overhead byte
*     ps_Bpn : number of (nominal) data bytes transferred from a BC to a LP
*
*   Returns:
*     None.
*
*  Global Variables:
*     gft_TcmFlag_bis_DS : DS Trellis code usage flag. If TRUE, DS trellis is used.
*
*-----------------------------------------------------------------------------
^^^*/
FlagT Choose_PMS_Params(int16 *ps_L, int16 s_D, int16  s_R, int16 *ps_M, int16 *ps_T, int16 *ps_Bpn, int16 s_max_latency,
                        int16 s_p,
                        //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start_End)
                        int16 s_DeltaLp
                        )
{

    int16  s_M, s_T, sa_Bpn[2];
    int16 s_CWSize;
    FlagT ft_BitloadOK = SUCCEED;
    //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start_End)
    s_CWSize = Calc_CWSize(ps_L, s_D, s_R, s_max_latency, s_p,s_DeltaLp);
    if (s_CWSize == 0) return(0);
    //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start_End)
    ft_BitloadOK = Choose_Best_Mp(s_CWSize, *ps_L, s_D, &s_M, &s_T, &sa_Bpn[0],  s_R, s_p,s_DeltaLp);


    if (ft_BitloadOK==SUCCEED)
    {
        /* If there is no checkbytes when trellis is on,
        D should be 1 &  M should be 1 */
        if  (s_R == 0)
        {
            if((s_D != 1) || (   s_M != 1)) ft_BitloadOK = FAIL;

        }
    }


    if (ft_BitloadOK==SUCCEED)
    {
        /* Based on latest amendment if latency = 1, S<=1; D =1 */
        if  (s_max_latency <= 1)
        {
            if(s_D != 1)
            ft_BitloadOK = FAIL;

        }
    }

    if (ft_BitloadOK == SUCCEED)
    {
        *ps_M = s_M;
        *ps_T = s_T;
        *ps_Bpn++ = sa_Bpn[0];
        *ps_Bpn = sa_Bpn[1];
    } // if(ft_BitloadOK==SUCCEED)


    return(ft_BitloadOK);
}
/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*   FlagT Choose_PMS_Params_Ph2(int16 *ps_L, int16 s_D, int16 s_R,  int16 *ps_M, int16 *ps_T, int16 *ps_Bpn, int16 *ps_CWSize, int16 s_max_latency, int16 s_p)
*
*   Description:
*  This function computes all PMS parameters for Rx Path for BIS standard. For now,
*  this function only works when only BC0 and LP0 is used.
*
*  Input Arguments:
*     s_L : number of bits in a PMD frame
*     s_p : latency path number
*
*  Output Arguments:
*     ps_R : number of checkbytes in a CW
*     ps_D : interleave depth
*     ps_M : number of PMS frames in a CW
*     ps_T : number of PMS frames per overhead byte
*     ps_Bpn : number of (nominal) data bytes transferred from a BC to a LP
*
*   Returns:
*     None.
*
*  Global Variables:
*     gft_TcmFlag_bis_DS : DS Trellis code usage flag. If TRUE, DS trellis is used.
*
*-----------------------------------------------------------------------------
^^^*/
FlagT Choose_PMS_Params_Ph2(int16 *ps_L, int16 s_D, int16 s_R,  int16 *ps_M, int16 *ps_T, int16 *ps_Bpn, int16 *ps_CWSize, int16 s_max_latency, int16 s_p)
{
    int16   s_M, s_T, sa_Bpn[2];

    int16 ft_CWSizeOK=0;
    int32 l_temp1, l_temp2;
    FlagT ft_BitloadOK = SUCCEED;
    int16 s_temp;

    // check if the previous value of CWSize is OK
    // this is crucial to hitting the exact data rate

    // Sp > = 0.5 or 1/3 for plus
    s_temp = ((*ps_CWSize) << 3);
    MULS16(l_temp1, s_temp,gs_OneOverSminADSL2);
    if ( l_temp1 >= *ps_L )
    {
        // if latency <=1, check Sp <=1 else Sp <=64
        if (((s_max_latency <= 1 ) && ( s_temp <= *ps_L)) || ( (s_max_latency > 1) && ( (*ps_CWSize) <= (*ps_L << 3)) ) )
        {

            l_temp1 = (int32) (*ps_CWSize) * (int32) s_D;
            l_temp2 = (int32) (*ps_L) * (int32) s_max_latency ;
            l_temp2 >>= 1;

            if (l_temp1 <= l_temp2)
            {
                l_temp1 = (int32) gs_MinDSOverheadRate * (int32) (*ps_CWSize);
                l_temp2 = (int32) ((int32) (*ps_L) << 6);

                if (l_temp1 <= l_temp2)
                ft_CWSizeOK = 1;
            }
        }
    }

    //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start)
    if (!ft_CWSizeOK)
    *ps_CWSize = Calc_CWSize(ps_L, s_D, s_R,  s_max_latency, s_p,0);

    if (*ps_CWSize ==0) return(0);

    // Recompute the new coding Gain, output is global variable
    gs_CodingGain = GetCodingGain_BIS(s_R, s_D);


    ft_BitloadOK = Choose_Best_Mp(*ps_CWSize, *ps_L, s_D, &s_M, &s_T, &sa_Bpn[0],  s_R, s_p,0);
    //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (End)

    if (ft_BitloadOK==SUCCEED)
    {
        /* If there is no checkbytes when trellis is on,
        D should be 1 &  M  should be 1  */
        if  (s_R == 0)
        {
            if((s_D != 1) || (   s_M != 1)) ft_BitloadOK = FAIL;

        }
    }

    if (ft_BitloadOK==SUCCEED)
    {
        /* Based on latest amendment if latency = 1, S<=1; D =1 */
        if  (s_max_latency <= 1)
        {
            if(s_D != 1) ft_BitloadOK = FAIL;

        }
    }


    if (ft_BitloadOK==SUCCEED)
    {
        *ps_M = s_M;
        *ps_T = s_T;
        *ps_Bpn++ = sa_Bpn[0];
        *ps_Bpn = sa_Bpn[1];

    } // if(ft_BitloadOK==SUCCEED)

    return(ft_BitloadOK);
}

/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*  FlagT CheckClockCycle(PMSBitload_t* t_PMSParams )
*
*   Description:
*  This function computes the total clock cycles required for a particular framing design
*  and compares with threshold, if clock count exceeds, code returns a fail
*
*  Input Arguments:
*
*     gt_PMSParams (Lp, Mp, Rp, Bpn, Tp)
*
*  Output Arguments:
*
*
*   Returns:
*     PASS / FAIL
*
*  Global Variables:
*
*
*-----------------------------------------------------------------------------
^^^*/
FlagT CheckClockCycle(PMSBitload_t* t_PMSParams )
{
    int i;
    int16 s_dspratio = 43 ; // DSP_ratio= (94/140) * 64 (10.6)
    int16 s_az_runs[2] = {0, 0};
    int16 s_minazruns, s_maxazruns;
    int16 s_aai_pld = 0;
    int16 s_fci_pld = 0;
    int16 s_fci_cb = 0;
    int16 s_fci_ldst = 129;
    int16 s_aai_ldst, s_aai_oh;
    int16 s_fci_oh;
    int16 s_Kp, s_CW, s_Mp, s_Rp, s_Tp, s_Bp, s_Lp;
    int16 s_ld;
    int32 l_temp1, l_pmstc;
    int32 l_temp2 = 0;
    int16 s_totalclocks;
    FlagT ft_BitloadOK = SUCCEED;
    #define CYCLE_COUNT_THRESHOLD   2830
    // For both single and dual-latency modes
    for (i=0; i < NUM_DATA_PATHS; i++)
    {
        s_Bp = t_PMSParams->sa_Bpn[i][0];
        s_Mp = t_PMSParams->s_Mp[i];
        s_Rp = t_PMSParams->s_Rp[i];
        s_Tp = t_PMSParams->s_Tp[i];
        s_Lp = t_PMSParams->s_Lp[i];
        // if in single latency mode, set the following params for LP1_DATA_PATH only
        if ((i == 1) && (s_Bp <= 0))
        {
            s_Tp = s_Mp = 1;
            s_Bp = s_Rp = s_Lp = 0;
        }
        // cwsize = mp * (1+bpn) + rp;
        s_Kp = s_Bp + 1;
        MULS16(s_CW, s_Kp, s_Mp);
        s_CW += s_Rp;
        // make sure cwsize not zero
        s_CW = (s_CW == 0) ? 1 : s_CW;
        // az_runs = ceil((mp * lp) / (8*cwsize));
        MULS16(l_temp1, s_Mp, s_Lp);
        s_az_runs[i] = (l_temp1 + 8 * s_CW - 1) / (8 * s_CW);
        // set az_runs1 to 0 in single latency mode
        if (t_PMSParams->sa_Bpn[1][0] <= 0)
        {
            s_az_runs[1] = 0;
        }
        // aai_pld  = az_runs0 * bpn0 + az_runs1 * bpn1;
        s_aai_pld += s_az_runs[i] * s_Bp;
        // t = ceil(az_runs / tp);
        if (s_Tp) l_temp2 = (s_az_runs[i] + (s_Tp - 1)) / s_Tp;
        s_aai_pld += (s_Tp > 1) ? l_temp2 : 0;
        // fci_pld  = kp0 * az_runs0 + kp1 * az_runs1;
        s_fci_pld += s_Kp * s_az_runs[i];
        // fci_cb = ceil(az_runs0/mp0)*cbsize0 + ceil(az_runs1/mp1)*cbsize1;
        // cbsize = Rp
        s_Mp = (s_Mp == 0) ? 1 : s_Mp;
        s_fci_cb += ((s_az_runs[i] + (s_Mp - 1))/s_Mp ) * s_Rp;
    }
    // find min/max az_runs
    s_maxazruns = (s_az_runs[0] > s_az_runs[1] ? s_az_runs[0]:s_az_runs[1]);
    s_minazruns = (s_az_runs[0] > s_az_runs[1] ? s_az_runs[1]:s_az_runs[0]);
    // ld = min(azruns)*2;
    // aai_ldst = 40 * (min(az_runs0, az_runs1) +((az_runs0 != az_runs1) ? 1 : 0));
    s_ld = s_minazruns * 2 + (s_az_runs[0] != s_az_runs[1] ? 1 :0);
    MULS16(s_aai_ldst, 40, s_ld);

    // aai_oh = 3*min(azruns);
    s_aai_oh = 3 * s_minazruns;
    // pmstc = (32 + 26 * max_azruns + ((az_runs1) ? 15 : 0)) * DSP_RATIO;
    MULS16(l_temp1, 26 , s_maxazruns);
    MULS32x16(l_pmstc, (32 + l_temp1 + ((s_az_runs[1]) ? 15 : 0)), s_dspratio);

    // adjust for 10.6 DSP Ratio format
    l_pmstc = l_pmstc >> 6;

    //fci_oh  = 15*(az_runs0 + az_runs1);
    MULS16(s_fci_oh, 15, (s_az_runs[0] + s_az_runs[1]));
    // fci_startup   = (5 + 5*DSP_RATIO)*max_azruns;
    // fci_shutdown  = (3 + 5*DSP_RATIO)*max_azruns;
    // aai_startup   = (9 + 3*DSP_RATIO)*max_azruns;
    // aai_shutdown  = (1 + 5*DSP_RATIO)*max_azruns;
    // combine all four terms above
    MULS32x16(l_temp1, 18, s_dspratio);
    // adjust for 10.6 DSP Ratio format
    l_temp1 = l_temp1 >> 6;
    MULS16(s_totalclocks, (l_temp1 + 18), s_maxazruns);

    // finally sum up all terms
    s_totalclocks += s_aai_pld + s_aai_ldst + s_fci_pld + s_fci_cb + s_fci_ldst + l_pmstc + s_fci_oh + s_aai_oh;

    if (s_totalclocks > CYCLE_COUNT_THRESHOLD)
    {
        ft_BitloadOK = FAIL;
    }

    return(ft_BitloadOK);
}
//#endif
/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*     Calc_CWSize( int16 s_L, int16 s_D, int16 s_R,  int16 s_max_latency,int16 s_p, int16 s_DeltaLp)
*
*   Description:
*  This function computes and returns the value of CWSize
*  for Rx Path for BIS standard.
*
*  Input Arguments:
*     s_L      : number of bits in a PMD frame
*     s_D      : interleave depth
*     s_p      : Latency path nyumber
*
*
*  Output Arguments:
*
*   Returns:
*     Code Word Size
*
*  Global Variables:
*
*-----------------------------------------------------------------------------
^^^*/
int16 Calc_CWSize( int16 *ps_L, int16 s_D, int16 s_R, int16 s_max_latency,
                  int16 s_p,
                  //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start_End)
                  int16 s_DeltaLp
                  )
{
    int16  s_log2Mp;
    int16 s_CWSize;
    int32 l_temp1, l_temp2;
    int16 s_temp1, s_temp2;
    int16 s_iterCW=0;

    /*****************************************************************************************
    Decide the largest Code Word Size
    1) CWSize <= 255    (specifies max codeword size)
    2) CWSize <= 8 * Lp       (limits Sp <= 64)
    3) CWSize <= (4 * Lp * Latency_max) /(8* Dp)
    (ensures latency requirement is met)
    4) Mp * Lp * 4/ (Tp * CWSize) >= Min_Ovhd_rate

    4a) CWSize <= 64 * Lp /  Min_ovhd_rate   (equiv to (4) with Mp=16, Tp=1)

        MaxCWSize = floor( min{  255, 8*Lp, (Lp * Latency_max) / (2*Dp), 4 * Mp * Lp /  Min_ovhd_rate } )
    *******************************************************************************************/

    s_CWSize = gs_max_CWSize;          // Initialize
    //SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory (Start)
#ifdef ADSL_62
    while((s_CWSize-1)*(s_D-1) > gl_DS_Intlv_buf_size)
    s_CWSize--;
#else
    while((s_CWSize-1)*(s_D-1) > 16002)
    s_CWSize--;
#endif
    //SMS01438029 Perf_DS_ALL_24Kb_Ilv_Memory(End)

    while(s_iterCW <2)
    {
        /* Based on latest amendment if latency = 1, S<=1*/
        //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start_End)
        if  (s_max_latency <= 1)
        {
            while (s_CWSize > ((*ps_L - s_DeltaLp)>>3))
            s_CWSize--;
        }
        else
        {
            /* To ensure S = (s_CWSize * 8)/s_L <= 64  */
            //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start_End)
            while (s_CWSize > ((*ps_L - s_DeltaLp)<<3))
            s_CWSize--;
        }

        /* Latency requirement S * D <= s_max_latency * 4*/

        MULS16(l_temp1,s_CWSize, s_D);
        //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start_End)
        MULS16(l_temp2, (*ps_L-s_DeltaLp),(s_max_latency<<2));
        l_temp1 <<= 3;
        while (l_temp1 > l_temp2)
        {
            s_CWSize--;
            l_temp1 -= (int32) (s_D << 3);
        }


        /*  The following condition on s_CWSize is to ensure that the Sp value chosen is
        small enough to accomodate the given minimum Overhead Rate Requirement. */

        MULS16(l_temp1, gs_MinDSOverheadRate, s_CWSize);
        //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start_End)
        l_temp2 = (int32) ((int32) (*ps_L-s_DeltaLp) << 6);

        while (l_temp1 > l_temp2)
        {
            s_CWSize--;
            // check that Sp requirement is satisfied
            //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START_END)
            if (((s_CWSize <<3) * gs_OneOverSminADSL2 <  (*ps_L+s_DeltaLp) ) || (s_CWSize < s_R + 1))
            {
                gft_BitloadOK = FAIL;
                return(0);
            }

            l_temp1 -= (int32) gs_MinDSOverheadRate;

        }

        /* above set assumes that Mp=16, check for validity of Mp, and ensure that overhead
        requirement is satisfied.*/

        s_log2Mp = 4;

        MULS16(l_temp1, (s_CWSize << 3), gs_OneOverSminADSL2);
        //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start_End)
        l_temp2 = (int32) ((int32) (*ps_L+s_DeltaLp) << s_log2Mp);

        while ((1) && (s_log2Mp !=0))
        {
            // Ensure that Mp/2 or Mp/3 (ADSl plus) < Sp
            // detrmine largest Mp for which this is true
            while ((l_temp1 < l_temp2) && (s_log2Mp > 0))
            {
                s_log2Mp--;
                l_temp2 >>= 1;
            }


            MULS16(l_temp1, gs_MinDSOverheadRate, s_CWSize);
            //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start_End)
            l_temp2 = (int32) ((int32) (*ps_L-s_DeltaLp) << (s_log2Mp+2));

            while (l_temp1 > l_temp2)
            {
                s_CWSize--;
                //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start_End)
                if ( gs_OneOverSminADSL2 * s_CWSize <  ((*ps_L+s_DeltaLp)>>3))
                {
                    gft_BitloadOK = FAIL;
                    return(0);
                }

                MULS16(l_temp1, gs_MinDSOverheadRate, s_CWSize);

            }

            MULS16(l_temp1, (s_CWSize << 3), gs_OneOverSminADSL2);
            //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start_End)
            l_temp2 = (int32) ((int32) (*ps_L-s_DeltaLp) << s_log2Mp);

            if(l_temp1 >= l_temp2)
            break;

        } /* while (1) */

        // check that if D > 64, CW should be co-prime with
        s_temp1 = s_D;

#ifdef DANUBE_WB
        // Partially handle the bug in byte tracking of erasure decoding by choose odd cwsize
        // with D<=64, For D>=64, the coprime criterion forces the CWSIZE=odd
        if ( (gs_DSL_EDcontrol & ERASURE_DECODING_ENABLE) == ERASURE_DECODING_ENABLE)
        {
            if ((s_D <=64) && (s_CWSize % 2 == 0))
            s_CWSize --;
        }
#endif
        // For D=511, though we can have even codewords, our firmware plus hardware would add extra dummy byte for even codeword,
        // ensure that for D=511 we work with odd codewords for the time being

        if ((s_D == 511) && (s_CWSize % 2 == 0))
        s_CWSize--;

        s_temp2 = s_CWSize;

        while ( (s_CWSize > 0)  && (s_D >64))
        {
            s_temp1 = CheckCoPrime(s_D, s_temp2);

            // s_temp1 is gcd, if gcd is not one decrease cw size
            if (s_temp1==1)  break;
            else
            {
                s_CWSize--;
                s_temp2 = s_CWSize;

                // For D=511, though we can have even codewords, our firmware plus hardware would add extra dummy byte for even codeword,
                // ensure that for D=511 we work with odd codewords for the time being

                if ((s_D == 511) && (s_CWSize % 2 == 0))
                s_CWSize--;
            }

        }

        if(s_CWSize < s_R + 1)
        {
            gft_BitloadOK = FAIL;
            return(0);
        }
        //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start)
        //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START)
        if (((gs_OneOverSminADSL2 * s_CWSize) <  ((*ps_L+s_DeltaLp)>>3)) && (s_iterCW ==0))

        *ps_L = (gs_OneOverSminADSL2 << 3) * s_CWSize - s_DeltaLp;
        //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (End)

        if (*ps_L <= 0)
        {
            gft_BitloadOK = FAIL;
            return (0);
        }
        //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (END)

        s_iterCW++;

    }
    // check that Sp> 1/3 for ADSLPlus or 1/2 for ADSL
    if ((gs_OneOverSminADSL2 * s_CWSize) <  (*ps_L>>3))
    {
        s_CWSize = 0;
        gft_BitloadOK = FAIL;
    }
    return(s_CWSize);
}
/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*     Choose_Rp(int16 s_CWSize, int16 s_L, int16 s_D, int16 s_p)
*
*   Description:
*  This function computes and returns the value Rp (number of checkbytes per CW)
*  for Rx Path for BIS standard.
*
*  Input Arguments:
*     s_CWSize : CW size
*     s_L      : number of bits in a PMD frame
*     s_D      : interleave depth
*     s_p      : Latency path nyumber
*
*
*  Output Arguments:
*
*   Returns:
*     number of checkbytes in a CW.
*
*  Global Variables:
*
*-----------------------------------------------------------------------------
^^^*/
#ifndef TARGET_HW
int16 Choose_Rp(int16 s_CWSize, int16 s_L, int16 s_D, int16 s_p)
{
    int16 s_R;
    int16 s_ncloaded_per_cw = 0;
    uint32 ul_temp1, ul_temp2;

    /* The number of checkbytes in a codeword is a function of active subchannels   */
    /* per codeword. We will separate two cases, where no interleaving is used      */
    /* and some interleaving is used.                                   */
    /* This is a direct implementation of Arnon Friedmann's study.               */

    /* Compute the number of active subchannel per codeword.   */
    /* s_ncloaded_per_cw = (s_CWSize * 8) * gus_ncloaded / s_Lp */

    ul_temp1 = (uint32) ((uint16) gus_ncloaded * (uint16) s_CWSize);
    ul_temp2 = (uint32) ((uint16) s_ncloaded_per_cw * (uint16) s_L);

    while (ul_temp2 < ul_temp1) {
        s_ncloaded_per_cw++;
        ul_temp2 += (uint32) s_L;
    }

    s_ncloaded_per_cw = (s_ncloaded_per_cw << 3);  // convert the number of tones per code word to tones per bit per code word.

    switch(gft_TcmFlag_bis_DS) {

    case TRUE:

        if (s_D < 4)
        s_R = 0;

        else if (s_D == 4) {
            if (s_ncloaded_per_cw < 120)
            s_R = 0;
            else if (s_ncloaded_per_cw < 320)
            s_R = 8;
            else
            s_R = 16;
        }

        else if (s_D == 8) {
            if (s_ncloaded_per_cw < 60)
            s_R = 0;
            else if (s_ncloaded_per_cw < 120)
            s_R = 4;
            else if (s_ncloaded_per_cw < 320)
            s_R = 8;
            else
            s_R = 16;
        }

        else if (s_D == 16) {
            if (s_ncloaded_per_cw < 67)
            s_R = 0;
            else if (s_ncloaded_per_cw < 120)
            s_R = 4;
            else if (s_ncloaded_per_cw < 320)
            s_R = 8;
            else
            s_R = 16;
        }
        else if (s_D >= 32) {
            if (s_ncloaded_per_cw < 54)
            s_R = 0;
            else if (s_ncloaded_per_cw < 60)
            s_R = 2;
            else if (s_ncloaded_per_cw < 120)
            s_R = 4;
            else if (s_ncloaded_per_cw < 320)
            s_R = 8;
            else
            s_R = 16;
        }
        break;

    case FALSE:

        if (s_D == 1)
        {
            /* No interleaving */
            if (s_ncloaded_per_cw < 48)
            s_R = 0;
            else if (s_ncloaded_per_cw < 60)
            s_R = 4;
            else if (s_ncloaded_per_cw < 120)
            s_R = 8;
            else
            s_R = 16;
        }

        else
        {
            /* Some interleaving */
            if (s_ncloaded_per_cw < 26)
            s_R = 0;
            else if (s_ncloaded_per_cw < 48)
            s_R = 2;
            else if (s_ncloaded_per_cw < 120)
            s_R = 4;
            else if (s_ncloaded_per_cw < 240)
            s_R = 12;
            else
            s_R = 16;
        }
        break;
    }

    if (s_R > gt_HandshakeBis.sa_DS_MaxCheckbytesLP[s_p])
    s_R = gt_HandshakeBis.sa_DS_MaxCheckbytesLP[s_p];

    return(s_R);
}
#endif
/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*     Choose_Best_Mp(int16 s_CWSize, int16 s_L, int16 *ps_M, int16 *ps_T, int16 *ps_Bpn, int16 s_R,
*                    int16 s_p,int16 s_DeltaLp)
*
*   Description:
*  This function computes the back-end PMS parameters for Rx Path for BIS standard.
*
*  Input Arguments:
*     s_CWSize : CW size
*     s_L      : number of bits in a PMD frame
*     s_R      : number of checkbytes in a CW
*     s_p      : Latency path nyumber
*
*  Output Arguments:
*     ps_M  : number of PMS frames in a CW
*     ps_T  : number of PMS frames per overhead byte
*     ps_Bpn   : number of (nominal) data bytes transferred from a BC to a LP
*
*   Returns:
*     None.
*
*  Global Variables:
*
*-----------------------------------------------------------------------------
^^^*/
/*************************************************************************************************
Algorithm:
Find range of Mp that satisfies
        Mp <= (16 * CWSize) / Lp (# of mux frames per PMD frame <= 2.0)

        Mp >= CWSize / (4 * Lp)     (# of mux frames per PMD frame >= 1/32)

            MinMp = min Mp in {1,2,4,8,16} such that Mp >= MaxCWSize / (4 * Lp)
            MaxMp = max Mp in {1,2,4,8,16} such that Mp <= (16 * MaxCWSize) / Lp

            // ValidMp is the set containing all Mp which lie between MinMp and MaxMp.

                ValidMp = { MinMp <= Mp < = MaxMp}

                If validMp is a null set;
                return   // No valid configuration for this Dp.



                        Find best {Mp,Tp} pair that minimizes the excess overhead rate.

                        Min_Ovhd_excess = MAX_INT;

                            For each Mp in {ValidMp}:
                            {
                            For each Tp in {1, 2, 4, 8, 16, 32, 34, 64}
                            {
                            Ovhd_actual = (4 * Mp * Lp) / (Tp * MaxCWSize)
                            Ovhd_excess = Ovhd_actual - Ovhd_min
                            If (Ovhd_excess < 0) continue;  // Violates constraint 7)
                            If (Ovhd_excess < Min_Ovhd_excess)
                            { // Save Mp, Tp that minimize excess ovhd.
                            Min_Ovhd_excess = Ovhd_excess;
                            BestM = Mp
                            BestT = Tp
                            }
                            } // For each Tp
                            } // For each Mp


                                If (Min_Ovhd_excess == MAX_INT) continue. // No valid config for this Dp.
                                *********************************************************************************************/
FlagT Choose_Best_Mp(int16 s_CWSize, int16 s_L, int16 s_D, int16 *ps_M, int16 *ps_T, int16 *ps_Bpn, int16 s_R,
                     int16 s_p,
                     //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start_End)
                     int16 s_DeltaLp
                     )
{
    int s_Log2_M = 0, i;
    int16 ft_FlagMp, ft_FlagTp;
    int16 s_BytesForBC0, s_BytesForBC1, s_Kp_MDF ;
    uint32 ul_overhd_excess,  ul_best_min_ovhd_excess, ul_temp1, ul_temp2;
    int32 l_temp1, l_temp2;
    int16 s_ValidMpValues[5] = {0};
    int16 s_Tp_max=64, s_T = 1;
    int16 s_opt_Mp=1, s_opt_Tp=1, s_BytesForBC0_opt = 0, s_BytesForBC1_opt = 0;
    FlagT ft_BitloadOK = SUCCEED;

    /*  The valid values for Mp are, Mp = {1, 2, 4, 8, 16};
                                    Also, the value of Mp has to be such that it satisfies the following requirement,
                                    (Mp/2) <= Sp <= (32 * Mp), where
                                    Sp = N_{fec}/Lp */

    ft_FlagMp = 0;

    // We find all the valid values of Mp which will satisfy the conditions and store them
    // in an array, s_ValidMpValues.  ft_FlagMp gives us the number of such valid values of Mp.

    for (s_Log2_M = 0; s_Log2_M < 5; s_Log2_M++)
    {
        //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start)
        ul_temp1 = (uint32) ((uint32) (s_L+s_DeltaLp) << s_Log2_M);
        ul_temp2 = (uint32) ((uint32) (s_L-s_DeltaLp) << (s_Log2_M + 5));
        //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (End)

        if ((ul_temp1 <= (uint32) (gs_OneOverSminADSL2*(s_CWSize << 3))) && (ul_temp2 >= (uint32) (s_CWSize << 3)))
        {
            s_ValidMpValues[ft_FlagMp] = s_Log2_M;
            ft_FlagMp += 1;
        }
    } // for (s_Log2_M = 0; ....)


    if(ft_FlagMp !=0)
    {
        if (s_R==0)
        {
            ft_FlagMp=0;
            s_ValidMpValues[ft_FlagMp]=0;  // Mp ==1
            ft_FlagMp +=1;

            // compute cw size

            l_temp1 = (int32) (gs_MinDSOverheadRate) * (int32) s_CWSize;
            //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start_End)
            l_temp2 = (int32) ((int32) (s_L-s_DeltaLp) << (2));

            while (l_temp1 > l_temp2)
            {
                s_CWSize--;

                MULS16(l_temp1, gs_MinDSOverheadRate, s_CWSize);

            }
            //min and max Sp requirement
            //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start_End)
            if( (s_CWSize <= ((s_L+s_DeltaLp)<<3)) &&
               ((( gs_OneOverSminADSL2 * s_CWSize)<<3)  >= (s_L-s_DeltaLp))  == 0 )
            return(0);
        }
    }


    ft_FlagTp = 0;
    ul_best_min_ovhd_excess=192000;  // corresponds to 4 Mp Lp = 4 * 16 * 3000
    if (ft_FlagMp != 0)
    { // We have at least one valid value of Mp.
        /*  We will use all the valid values of Mp stored in s_ValidMpValues array to compute the overhead
                                        parameter, Tp.  */
        for (i = 0; i < ft_FlagMp; i++)
        {
            s_Log2_M = s_ValidMpValues[i];

            /*  This value of Mp is a valid value satisfying the Sp constraint.  We will first use
                                            this value to compute the number of bits to be allocated to each BC, and the new
                                            codeword length.  */

            /*  Check to see how many BCs are active in the DS, and allocate the bits in Lp to these
                                            BCs in such a way that the bit allocation satisfies the minimum and the maximum rate
                                            requirements. */

            /*  In case only one BC is active, (i.e., BC0 is active), then allocate all the bits in Lp
                                            to BC0.  In case more than one BC is active (since we have a maximum BC per LP to be 2),
                                            the data needs to be distributed between BC0 and BC1.  */
            //                               if (gt_rx_config.s_Nlp == 1)
            //                               {
            //                               if (gt_rx_config.s_Nbc == 1)
            s_BytesForBC0 = (((s_CWSize - s_R) >> s_Log2_M) - 1);

            /*                               else if (gt_rx_config.s_Nbc == 2)
                                            s_BytesForBC0 = ((((s_CWSize - s_R) >> s_Log2_M) - 1) >> 1);
                                    */
            if (s_BytesForBC0 < 0)
            s_BytesForBC0 = 0;

            /*       if (s_BytesForBC0 > (int16) MAX_NET_DATARATE_ATM_BC0_DS)
                                                s_BytesForBC0 = (int16) MAX_NET_DATARATE_ATM_BC0_DS;

                                                s_BytesForBC1 = (((s_CWSize - s_R) >> s_Log2_M) - 1) - s_BytesForBC0;

                                                    if (s_BytesForBC1 < 0)
                                                    s_BytesForBC1 = 0;
                                                    if (s_BytesForBC1 > (int16) MAX_NET_DATARATE_ATM_BC1_DS)
                                                    s_BytesForBC1 = (int16) MAX_NET_DATARATE_ATM_BC1_DS;

                                                    // Re-compute the CW size based on the number of bits allocated to BC0 and BC1.
                                                    s_Kp_MDF=s_BytesForBC0 + s_BytesForBC1 + 1;
                                            s_CWSize = ((s_Kp_MDF << s_Log2_M) + s_R);*/
            //                               }
            //                               else if (gt_rx_config.s_Nlp == 2)
            //                               {
            // compute Bpn Assume BC0 to go to LP0
            //
            //                                  s_BytesForBC0 = (((s_CWSize - s_R) >> s_Log2_M) - 1);
            s_Kp_MDF=s_BytesForBC0 + 1;
            s_CWSize = ((s_Kp_MDF << s_Log2_M) + s_R);
            s_BytesForBC1 =0;

            //                               }

            /*  With the values of Lp, Sp, Mp and Bpn that we have, we proceed to compute the value for Tp
                                            which satisfies the overhead rate requirements. */

            ft_FlagTp = 0;
            //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start_End)
            ul_temp1 = (uint32) ((s_L-s_DeltaLp) << (s_Log2_M + 2));

            s_Tp_max=64;
            MULU16(ul_temp2, s_CWSize, s_Tp_max);


            ul_temp2 *= (uint32) (gs_MinDSOverheadRate );

            while ((ul_temp1 < ul_temp2) && (s_Tp_max >1))
            {
                s_Tp_max--; // least value 1

                ul_temp2 = ul_temp2 - (uint32) s_CWSize * (gs_MinDSOverheadRate );

            }


            if (ul_temp1 >= ul_temp2)
            {
                ul_overhd_excess=ul_temp1-ul_temp2;
                ft_FlagTp = s_Tp_max;

                //choose the set of parameters for which excess overhead rate is least

                if(ul_overhd_excess <= ul_best_min_ovhd_excess)
                {
                    s_opt_Tp     = s_Tp_max;
                    s_opt_Mp     = (1<<s_Log2_M);
                    s_BytesForBC0_opt = s_BytesForBC0;
                    s_BytesForBC1_opt = s_BytesForBC1;
                    ul_best_min_ovhd_excess = ul_overhd_excess;
                }
            }



            if (ft_FlagTp != 0)
            {
                *ps_M   = s_opt_Mp;
                *ps_T   = s_opt_Tp;
                *ps_Bpn++ = s_BytesForBC0_opt;
                *ps_Bpn = s_BytesForBC1_opt;
                ft_BitloadOK = SUCCEED;
                break;

            } // if (ft_FlagTp != 0)
        } // for (i = 0; i < ft_FlagMp; i++)
    } // if (ft_FlagMp != 0)

    if ((ft_FlagMp == 0) || (ft_FlagTp == 0))
    {
        // We have failed to generate correct framing and overhead parameters for bit loading.
        // Therefore, we declare a failure and set some of these parameters to zero.
        *ps_M     = 0;
        *ps_T     = 0;
        *ps_Bpn++ = 0;
        *ps_Bpn      = 0;
        ft_BitloadOK = FAIL;
    }
    return(ft_BitloadOK);
}
/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*     Save_ValidPMS(int16 s_L, int16 s_D, int16 s_R, int16 s_T, int16 *psa_Bpn, int16 s_p)
*
*   Description:
*  This function saves the valid PMS configuration
*  Input Arguments:
*     s_L      : number of bits in a PMD frame
*     s_D      : interleave depth
*     s_p      : Latency path nyumber
*
*
*  Output Arguments:
*
*   Returns:
*     Code Word Size
*
*  Global Variables: gt_PMSParams
*
*-----------------------------------------------------------------------------
^^^*/
void Save_ValidPMS( int16 s_D,int16 s_M, int16 s_R, int16 s_T, int16 s_L, int16 *psa_Bpn, int16 s_p,  PMSBitload_t *pt_save)
{
    pt_save->s_Dp[s_p] = s_D;
    pt_save->s_Mp[s_p] = s_M;
    pt_save->s_Rp[s_p] = s_R;
    pt_save->s_Tp[s_p] = s_T;
    pt_save->s_Lp[s_p] = s_L ;
    pt_save->s_IBITSlp = 0;
    pt_save->s_MSGlp = 0;
    pt_save->s_MSGc = 8;   //Initialized to 8 for now to let adaptive rate olr pass
    pt_save->sa_Bpn[s_p][0] = *psa_Bpn++;
    pt_save->sa_Bpn[s_p][1] = *psa_Bpn;

}
/*^^^
*------------------------------------------------------------------------
*
*  Prototype: void VerifyBitLoadingParameters(void)
*
*  Description: Verifies the framing, overhead and other parameters that the
*           Bit loading routine computes.  Declares an error if any of these
*           parameters do not meet specifications.
*
*  Arguments: none
*
*  Return: none
*
*  Global Variables Used:  gt_HandshakeBis: Structure containing all the handshake values.
*                    gt_PMSParams:  Structure containing all the PMS parameters generated
*                                during bit loading.
*                    gus_BitLoadParameters:  Flag to indicate an error or not.
*
*------------------------------------------------------------------------
*^^^
*/
#ifndef TARGET_HW
void VerifyBitLoadingParameters(void)
{
    int16 s_Kp, s_CWSize;
    int16 i, s_Lp, s_NLPs;
    int8 ft_ErrorFlag;
    int32 l_temp1, l_temp2, s_max_latency;

    /*   We need to verify the PMS parameters generated by the bit loading routine.
    This includes the Mp, Tp, Dp, Rp, Lp, Kp and CWSize parameters.  */

    for (i = 0; i < (int16) NUM_DS_LATENCY_PATHS; i++)
    gus_BitLoadParameters[i] = (uint16) 0;

    //for (s_NLPs = 0; s_NLPs < gt_HandshakeBis.s_NumDSLatencyPaths; s_NLPs++) {
    // Since our bit-loading algorithm works only with LP0_DATA_PATH for the time being, we
    // check the bit loading parameters only for this path.  As soon as the bit loading algorithm
    // becomes complete, the check will be done over all latency paths.
    //   for (s_NLPs = 0; s_NLPs < gt_HandshakeBis.s_NumDSLatencyPaths; s_NLPs++) {
    for (s_NLPs = 0; s_NLPs < 1; s_NLPs++) {

        if (s_NLPs == 0)
        s_Lp = (int16) LP0_DATA_PATH;
        else if (s_NLPs == 1)
        s_Lp = (int16) LP1_DATA_PATH;

        // Check to see if the total number of bits allocated, i.e., Lp is >= 8.
        ft_ErrorFlag = 1;
        if (gt_PMSParams.s_Lp[s_Lp] >= 8)
        ft_ErrorFlag = 0;
        if (ft_ErrorFlag != 0)
        gus_BitLoadParameters[s_Lp] |= (uint16) (1 << 0);

        // Check to see if the Mp value falls within allowable range.
        ft_ErrorFlag = 1;
        for (i = 0; i < 5; i++) {
            if (gt_PMSParams.s_Mp[s_Lp] == (int16) (1 << i)) {
                ft_ErrorFlag = 0;
                break;
            }
        }
        if (ft_ErrorFlag != 0)
        gus_BitLoadParameters[s_Lp] |= (uint16) (1 << 1);

        // for Tp continum
        // Check to see if the Tp value falls within allowable range.
        ft_ErrorFlag = 1;
        if ((gt_PMSParams.s_Tp[s_Lp] >= 1) && (gt_PMSParams.s_Tp[s_Lp] <= 64))
        ft_ErrorFlag = 0;

        if (ft_ErrorFlag != 0)
        gus_BitLoadParameters[s_Lp] |= (uint16) (1 << 2);


        // Check to see if the number of frame bearers is non-zero.
        i = gt_HandshakeBis.sa_DS_BCActive[0] + gt_HandshakeBis.sa_DS_BCActive[1];
        if (i == 0)
        gus_BitLoadParameters[s_Lp] |= (uint16) (1 << 3);

        // Check to see if the codeword size falls within allowable range.
        if (i == 1) {
            s_Kp = (gt_PMSParams.sa_Bpn[s_Lp][0] + 1);
            s_CWSize = (s_Kp * gt_PMSParams.s_Mp[s_Lp]) + gt_PMSParams.s_Rp[s_Lp];
            if ((s_CWSize > gs_max_CWSize) || (s_CWSize < 0))
            gus_BitLoadParameters[s_Lp] |= (uint16) (1 << 4);
        }
        if (i == 2) {
            s_Kp = (gt_PMSParams.sa_Bpn[s_Lp][0] + gt_PMSParams.sa_Bpn[s_Lp][1] + 1);
            s_CWSize = (s_Kp * gt_PMSParams.s_Mp[s_Lp]) + gt_PMSParams.s_Rp[s_Lp];
            if ((s_CWSize > gs_max_CWSize) || (s_CWSize < 0))
            gus_BitLoadParameters[s_Lp] |= (uint16) (1 << 4);
        }

        // Check to see if the Sp value falls within the allowable range.
        ft_ErrorFlag = 1;
        if ((gt_PMSParams.s_Lp[s_Lp] <= (gs_OneOverSminADSL2 *(s_CWSize << 3))) && ((gt_PMSParams.s_Lp[s_Lp] << 3) >= s_CWSize))
        ft_ErrorFlag = 0;
        else
        gus_BitLoadParameters[s_Lp] |= (uint16) (1 << 5);


        // Check to see if the Rp value falls within the allowable range.
        ft_ErrorFlag = 1;
        if ((gt_PMSParams.s_Rp[s_Lp] >= 0) && (gt_PMSParams.s_Rp[s_Lp] <= gt_HandshakeBis.sa_DS_MaxCheckbytesLP[s_Lp]))
        ft_ErrorFlag = 0;
        else
        gus_BitLoadParameters[s_Lp] |= (uint16) (1 << 7);


        // Check to see if the framing and overhead parameters satisfy the overhead rate requirement.
        ft_ErrorFlag = 1;

        if ((gt_PMSParams.s_Mp[s_Lp] * gt_PMSParams.s_Lp[s_Lp] * 4) >=
                (gt_PMSParams.s_Tp[s_Lp] * s_CWSize * gs_MinDSOverheadRate))

        ft_ErrorFlag = 0;
        else
        gus_BitLoadParameters[s_Lp] |= (uint16) (1 << 8);

        // Check to see if the framing parameters satisfy Latency requirements
        ft_ErrorFlag = 1;

        s_max_latency = (int16) 0x7FFF;
        if (gt_rx_config.s_Nlp == 1)
        {
            // single latency path, assign latency as higher of the two paths.
            for (i = 0; i < NUM_DS_BEARER_CHANNELS_SUPPORTED; i++)
            {
                if ((gt_HandshakeBis.sa_DS_BCActive[i] == 1) && (s_max_latency > gt_HandshakeBis.sa_DS_MaxLatencyBC[i]))
                s_max_latency = gt_HandshakeBis.sa_DS_MaxLatencyBC[i];
            }
        }
        else if (gt_rx_config.s_Nlp == 2)
        {
            // for dual latency, assign max latency corresponding to BC which is assigned to LP0
            // we only support two Bearer channels, one for each path
            // framer design is called for LP0, LP1 is already configured as fast path
            if (guca_rxBCnToLPp[0] == s_Lp) s_max_latency = gt_HandshakeBis.sa_DS_MaxLatencyBC[0];

            else if (guca_rxBCnToLPp[1] == s_Lp) s_max_latency = gt_HandshakeBis.sa_DS_MaxLatencyBC[1];
        }
        /* latency is defined as S*D/4 (ms). Here we will multiply      */
        /* the latency by 4 so that the latency is defined in unit of S*D. */

        s_max_latency <<= 2;

        l_temp1 = (int32) (s_CWSize) * (int32) (gt_PMSParams.s_Dp[s_Lp]);
        l_temp2 = (int32)gt_PMSParams.s_Lp[s_Lp] * (int32) s_max_latency;
        l_temp2 >>= 3;

        if (l_temp1 <= l_temp2)
        ft_ErrorFlag = 0;
        else
        gus_BitLoadParameters[s_Lp] |= (uint16) (1 << 9);

    } // for (s_NLPs = 0; s_NLPs < gt_HandshakeBis.s_NumDSLatencyPaths; s_NLPs++)

    if (gus_BitLoadParameters[0] | gus_BitLoadParameters[1])
    {
        gft_BitloadOK = FAIL;
        /* Set exception handler variable */
        gus_BitloadExceptionCode = E_CODE_BITLOAD_VERIFY_PMS_FAIL;
        gus_ExceptionCode = E_CODE_BIT_LOADING_FAILURE;
        gs_InitFailCauseNearEnd = 2;
    }
    else
    gft_BitloadOK = SUCCEED;
}
#endif
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
/*^^^
 *-----------------------------------------------------------------------------
 *
 *   Prototype:
 *       FlagT Check_max_bits_to_reduce(uint16 *pus_LpAvailable, int16 s_MinToneLp0, uint16 *pus_nc1bit, uint16 *pus_nc2bit, uint16 *pus_nc3bit, uint16  *pus_maxbitstoreduce)
 *
 *   Description:
 *
 *    This function checks possibility of removing bits in the following ways.
 *    1. Removing bits by removing pairs of 1 bit tones
 *    2. Removing bits from tones loaded with 3 or more bits keeping min bits to 2
 *    3. Removing bits by removing tones
 *    It also calculates number of tones with 1 bit loaded, 2 loaded, 3 or more
 *    bits loaded and max bits that can be reduced without removing tones
 *    (excluding 1 bit tones)
 * Input Arguments:
 *                *pus_LpAvailable => Total Available Max bits.
 *                s_MinToneLp0 => Minimum tone number loaded with Lp0 bits
 * Output Arguments:
 *                *pus_nc1bit => number of tones with 1 bit loaded
 *
 *                *pus_nc2bit => number of tones with 2 bits loaded
 *
 *                *pus_nc3bit => number of tones with 3 bits loaded
 *                *pus_maxbitstoreduce => max bits that can be reduced without removing tones
 *
 *   Returns:
 *                   => TRUE if bits can be reduced without changing the
 *                      available for Lp1
 *                   => FALSE if bits can not be reduced. Lp1 available
 *                      needs to be changed
 ***********************************************************************************/
 FlagT Check_max_bits_to_reduce(uint16 *pus_LpAvailable, int16 s_MinToneLp0,
                                 uint16 *pus_nc1bit, uint16 *pus_nc2bit,
                                 uint16 *pus_nc3bit,
                                 uint16  *pus_maxbitstoreduce)
 {
      uint16 us_actualbitsLp1,us_LpAvailable,us_remainbitstoreduce,us_tmp;
      uint16 us_nc1bit,us_nc2bit,us_nc3bit,us_maxbitstoreduce;
      int16 s_bitstoreduce;
      uint16 us_i;
      FlagT ft_done;

      us_LpAvailable = *pus_LpAvailable;


   // (6) do bitloading on lower tones for LP1 (+Trellis Overhead)
           /* The number of bits (w/o Trellis overhead) that have to be loaded in LP1
            to get the desired NDR is gt_PMSParams.s_Lp[1].
         Currently us_LpAvailable bits have been loaded.
         */
      us_actualbitsLp1 = gt_PMSParams.s_Lp[1];
      s_bitstoreduce   = us_LpAvailable - us_actualbitsLp1;
      // gs_saveBitstoreduce = s_bitstoreduce;
      //  reduce these from the tones allocated to LP1 path
      us_maxbitstoreduce = 0;
      us_nc1bit = 0;
      us_nc2bit = 0;
      us_nc3bit = 0;

      // we need to trim bits to get the desired Lp

      if(s_bitstoreduce > 0)
      {
         /* Find out how many 1-bit and 2-bit carriers have been loaded
            and how many bits can be reduced w/o switching off tones. */

         for (us_i=gs_RxBitLoadFirstChannel; us_i <s_MinToneLp0; us_i++)
         {

            if (guca_RxBat[us_i] == 1)
            {
               us_nc1bit ++;
            }
            else if(guca_RxBat[us_i] == 2)
            {
               us_nc2bit ++;
            }
            else if(guca_RxBat[us_i]>2)
            {
               us_nc3bit ++;
               us_maxbitstoreduce += guca_RxBat[us_i]-2;
            }
         }

         us_remainbitstoreduce = s_bitstoreduce;
         /* check if we can remove enough bits.
         First try to remove the 1-Bit carriers. If we remove 4 1-bit carriers we remove effectively 3 bits. */

         us_tmp = us_nc1bit/4;
         while( (us_tmp>0) && (us_remainbitstoreduce>3) )
         {
            us_remainbitstoreduce-=3;
            us_tmp--;
         }

         us_tmp = (us_nc2bit + us_nc3bit)/2; // number of tonepairs
         while( (us_remainbitstoreduce > us_maxbitstoreduce) && (us_remainbitstoreduce > 3) && (us_tmp>1) )
         {
            // If this is the case we have to remove tones
            // If we remove two tones we effectly remove 3 bits.
            us_remainbitstoreduce-=3;
            us_tmp--;
         }

         if(us_remainbitstoreduce > us_maxbitstoreduce)
         {
            // We can't remove enough bits. We have to reduve LpBitsAvailable and redo the framing parameter generation.
            // This is a very unlike case that only can occur if there are (almost) only 1 and 2 bit carriers.
            us_LpAvailable = us_actualbitsLp1 - us_remainbitstoreduce;
            // We might also force this Lp now, but probably this part of the code will never be executed.
            ft_done = FALSE;

         }
         else
         {
            ft_done = TRUE;
         }
      }      // if(s_bitstoreduce > 0)
      else
      {
         ft_done = TRUE;
      }
      *pus_nc1bit = us_nc1bit;
      *pus_nc2bit = us_nc2bit;
      *pus_nc3bit = us_nc3bit;
      *pus_maxbitstoreduce = us_maxbitstoreduce;
      *pus_LpAvailable = us_LpAvailable;
      return(ft_done);
 }
//SMS01436600:FEATURE_DS_BisPlus_ALL_BitSwapReTx (Start)

/*^^^
 *-----------------------------------------------------------------------------
 *
 *   Prototype:
 *       FlagT ReTx_PreBitSwapProcessing(void)
 *
 *   Description:
 *    This function will be called from rx_olr_decision to check whether Bitswap is
 *    possible or not.This function internally will call the maximum bits that are available
 *    and Allocation of these bits to LP0 and LP1 including Trellis overhead.
 *
 * Input Arguments:
 *                *psa_InSTsnr => Showtime SNR buffer.
 * Output Arguments:
 *                *psa_OutSTsnr => Outpur buffer after adding Coding Gain.
 *                                           for LP0 convergence.
 *                *guca_RxBat       => Available Bits for LP1 after removing LP0, and
 *                                          corresponding Trellis overhead.
 *                *ps_MinToneLp0         => LastTone (excluding this tone)
 *                                           that can be used for LP1 loading
 *   Returns:
 *                ft_result   => SUCCEED if LP0 bits are successfully allocated.
 *                            => FAIL
 *
 * Global Variables:
 *    guca_RxBat --      (O) RX BAT table
 *    gft_FineGainOn  -- (I) Indicates Fine Gains can be used.
 *    gsa_RxFineGains  -- (I)Rx Fine Gain changes
 *    gs_RxExtraBits  -- (O) Bits availabe through Fine Gain changes
 *    gus_ncloaded    -- (I) Number of Tones that are loaded.
 ***********************************************************************************/

FlagT ReTx_PreBitSwapProcessing(int16 s_target_margin)
{
   FlagT ft_BitloadOK;
   int16 s_TotalBitsSupported,s_MinToneLp0;
   uint16 us_Lp1Available;
   int16 s_RxDesiredMargin;
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_Remove_xs_bits_Lp1 Begin
   uint16 us_nc1bit,us_nc2bit,us_nc3bit,us_maxbitstoreduce;
   FlagT ft_done;
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_Remove_xs_bits_Lp1 End

  //Take a copy of "guca_RxBat" and gsa_RxFineGains  some thing like below
  //      memcpy(gsa_TempRxFineGains, gsa_RxFineGains,sizeof(int16) * gs_RxNumTones);

   // clearing of Bits and gains done inside "CalcMaxBits"
   //gft_BitloadOK_BS = InitBitloading(LP1_DATA_PATH);

   s_RxDesiredMargin = s_target_margin - OPTNArray[OPTN_MarginDelta]; // ?????
   OffsetSNRRequired(s_RxDesiredMargin, gsa_SNRRequired);
   // Add coding gain to SNRs inside CalcMaxBits
   //AddCodingGainToSnr(psa_InSTsnr,  gsa_TotalCodingGain[LP1_DATA_PATH], psa_OutSTsnr, LP1_DATA_PATH);
   // don't change minbits!!
   s_TotalBitsSupported = CalcMaxBits(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxExtraBits_ReTx, &gus_ncloaded_ReTx, &gs_RxAvFineGain_ReTx, 0x7FFF, LP1_DATA_PATH);
   gs_TotalBitsSupported_ReTx = s_TotalBitsSupported;
   ft_BitloadOK = Assign_Bits_For_LP0 (&s_TotalBitsSupported,&us_Lp1Available,&s_MinToneLp0);
   if( ft_BitloadOK == FAIL)
   {
      return (ft_BitloadOK);
   }
   if(us_Lp1Available < gt_rx_config.s_Lp[1])
   {
      gus_Lp1Available_ReTx1 =us_Lp1Available;
      return (FAIL);
   }
   Check_LP1_Available(&us_Lp1Available,(s_MinToneLp0-1));

   if(us_Lp1Available < gt_rx_config.s_Lp[1])
   {
      gus_Lp1Available_ReTx2 = us_Lp1Available;
      return (FAIL);
   }
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_Remove_xs_bits_Lp1 Begin
   ft_done = Check_max_bits_to_reduce(&us_Lp1Available, s_MinToneLp0,
                  &us_nc1bit, &us_nc2bit, &us_nc3bit, &us_maxbitstoreduce);
   if(!ft_done)
   {
      return (FAIL);
   }
//   ft_BitloadOK =  Assign_Bits_For_LP1(us_Lp1Available, s_MinToneLp0);
   ft_BitloadOK =Assign_Bits_For_LP1(&us_Lp1Available, s_MinToneLp0, &us_nc1bit,
                                       &us_nc2bit, &us_nc3bit,
                                       &us_maxbitstoreduce);
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_Remove_xs_bits_Lp1 End
   if(ft_BitloadOK == SUCCEED)
            CalcMarginsAndGains(gft_FineGainOn, guca_RxBat, gsa_RxFineGains,
                          &gs_RxAvMargin, &gs_RxAvFineGain, &gs_RxMinMargin);

   return (ft_BitloadOK);
}
//SMS01436600:FEATURE_DS_BisPlus_ALL_BitSwapReTx (End)
/*^^^
 *-----------------------------------------------------------------------------
 *
 *   Prototype:
 *       FlagT Assign_Bits_For_LP0(int16 *ps_TotalBitsSupported,uint16 *pus_LpAvailable, int16 *ps_MinToneLp0)
 *
 *   Description:
 *    This function is called after calculation of Max Available bits.
 *    This function will allocate the bits LP0 path in ReTransmission.
 *    Bits are allocated from LastChannel -> FirstChannel.
 *    It will pick the DS PMS parameters LP0 from gt_PMSParams.s_Lp[0].
 *
 * Input Arguments:
 *                *ps_TotalBitsSupported => Total Available Max bits.
 * Output Arguments:
 *                *ps_TotalBitsSupported => Available Max bits after removing some bits
 *                                           for LP0 convergence.
 *                *pus_LpAvailable       => Available Bits for LP1 after removing LP0, and
 *                                          corresponding Trellis overhead.
 *                *ps_MinToneLp0         => LastTone (excluding this tone)
 *                                           that can be used for LP1 loading
 *   Returns:
 *                ft_result   => SUCCEED if LP0 bits are successfully allocated.
 *                            => FAIL
 *
 * Global Variables:
 *    gt_PMSParams.s_Lp[0] -- (I) LP0 bits available
 *    gft_Bitswap_UreTX  -- (I) Indicates 1 -> called After Showtime.
 *    gs_RxBitLoadFirstChannel  -- (I) FirstChannel for BitLoad
 *    gs_RxBitLoadLastChannel  -- (I) LastChannel for BitLoad
 *    gs_RxNumTones            -- (I) Number of Tones depending on mode
 *    p_TonesAllocatedtoLP1_DS -- (O) LP1 Tone Set.
 *    gpsa_MeasuredSnrBuf -- (O) pointer to measured SNR buffer
 *    gs_BitLoadingOK      -- (O) set to SUCCEED if bit loading succeeds, else set to FAIL
 *
 ***********************************************************************************/

FlagT Assign_Bits_For_LP0(int16 *ps_TotalBitsSupported,uint16 *pus_LpAvailable, int16 *ps_MinToneLp0)
{
   FlagT ft_result,ft_result_Tr = FALSE;
   FlagT ft_done;
   int16 s_TotalBitsSupported;
   uint16 us_sumBi, us_rm1bit = 0;
   uint16 us_ncloaded, us_nc1bit, us_nc2bit, us_nc3bit;
   uint16 us_done_reduce,us_i, us_j;
   int16 s_Tcm_Oh = 0, s_bitstoreduce, s_actualbitsLp0, s_MinToneLp0 = 0;
   uint16 us_L0;
   // If the Function is called in showtime back up Training bitload Status.
   if(gft_Bitswap_UreTX == 1)
      ft_result_Tr = gft_BitloadOK;

   ////////////////////////////////////////////////////////////////////////////////////////////////
   // (3) do bitloading on upper tones for LP0 (+Trellis Overhead)

   // decide how many tones are used
   // go in physical order from left to right and keep tones till sum(bi) = Lp0
   // also take care of Trellis overhead

   us_L0 = gt_PMSParams.s_Lp[0];
   s_TotalBitsSupported = *ps_TotalBitsSupported;

   if (us_L0 > s_TotalBitsSupported)
   {
      // Fail to do LP0 min rate  allocation
      gft_BitloadOK = FAIL;
      ft_result = FAIL;
      if(gft_Bitswap_UreTX == 1)
         gft_BitloadOK = ft_result_Tr;
      gus_BitloadExceptionCode = E_CODE_BITLOAD_LP0_INSUFFICIENTCAPACITY;
      return(ft_result);
   }


   // First we assign all tones to LP1
   // In the 2nd step we clear the toneflags of the tones assigned to LP0
   for (us_i=gs_RxBitLoadFirstChannel; us_i <= gs_RxNumTones ; us_i++)
   {
      if (guca_RxBat[us_i] > 0)  {
         SETTONEFLAG(p_TonesAllocatedtoLP1_DS, us_i);
      }
      else
         CLEARTONEFLAG(p_TonesAllocatedtoLP1_DS, us_i);
   }
   s_actualbitsLp0 = 0;
   us_sumBi = 0;
   us_ncloaded = 0;
   us_nc1bit   = 0;
   //mod_bitload_if_Lp0_has_tones_with_bi_1_&_2 Begin
   us_nc2bit   = 0;
   us_nc3bit   = 0; // this counter counts the number of tones with bat>2
   ft_done     = FALSE;

   us_i = gs_RxNumTones-1; // ToneIndex

   while ( (ft_done == FALSE) && (us_i > gs_RxBitLoadFirstChannel) )
   {

      if (guca_RxBat[us_i] > 0)
      {
         CLEARTONEFLAG(p_TonesAllocatedtoLP1_DS, us_i); // tone will be assigned to LP0
         us_sumBi += guca_RxBat[us_i];
         us_ncloaded ++;
         if (guca_RxBat[us_i] == 1) {
                us_nc1bit ++;
         }
         else if(guca_RxBat[us_i] == 2) {
                us_nc2bit ++;
         }
         else {
            us_nc3bit ++;
         }
      }
      // In Latency Path 0 we allow that number of loaded carriers is odd
      if((us_nc1bit & 0x1)==0) //Even or odd check
      {
         us_rm1bit = 0;
      }
      else
      {
         us_rm1bit = 1;
      }
      // determine TCM overhead: 4 Trellis bits are assigned to LP0
      s_Tcm_Oh = 4 + ((1+(us_ncloaded-us_rm1bit)-((us_nc1bit-us_rm1bit)>>1)) >> 1);
      //If Trellis is disabled
      if(gft_TcmFlag_bis_DS == FALSE)
         s_Tcm_Oh = 0;
      //If Trellis is disabled
      s_actualbitsLp0 = (us_sumBi-us_rm1bit) - s_Tcm_Oh;
      if (s_actualbitsLp0 >= us_L0)
      {
         s_MinToneLp0 = us_i;
         s_bitstoreduce = s_actualbitsLp0 - us_L0;
         // we need to trim bits to get the desired Lp0
         if(s_bitstoreduce == 0)
         {
            ft_done = TRUE;
            //Dbg_FW_for_Roland Begin
            gft_change_lp0 = TRUE;
            //Dbg_FW_for_Roland End
         }
         else
         {
            //Dbg_FW_for_Roland Begin
            gft_change_lp0 = FALSE;
            //Dbg_FW_for_Roland End
            while(s_bitstoreduce > 0)
            {
               if(us_nc3bit > 0)
               {
                  // unload one bit in bat>2
                  us_done_reduce = 0;
                  us_j = gs_RxNumTones-1; // ToneIndex
                  while(us_done_reduce == 0)
                  {
                     if(guca_RxBat[us_j] > 2)
                     {
                        guca_RxBat[us_j]--;
                        s_actualbitsLp0--;
                        us_sumBi--;
                        s_TotalBitsSupported--;
                        if(guca_RxBat[us_j]== 2)
                        {
                           us_nc3bit--;
                           us_nc2bit++;
                        }
                        s_bitstoreduce--;
                        us_done_reduce = 1;
                     }
                     us_j--;
                  }
               }
               else if( (us_rm1bit == 1) && (us_nc2bit > 0) )
               {
                  // change one 2-bit to 1-bit
                  us_done_reduce = 0;
                  us_j = gs_RxNumTones-1;
                  while(us_done_reduce == 0)
                  {
                     if(guca_RxBat[us_j]== 2)
                     {
                        guca_RxBat[us_j]=1;
                        us_sumBi--;
                        s_TotalBitsSupported--;
                        us_nc2bit--;
                        us_nc1bit++;
                        us_rm1bit = 0;
                        s_Tcm_Oh = 4 + ((1+us_ncloaded-(us_nc1bit>>1)) >> 1);
                        if(gft_TcmFlag_bis_DS == FALSE)
                           s_Tcm_Oh = 0;
                        s_actualbitsLp0 = us_sumBi - s_Tcm_Oh;
                        s_bitstoreduce = s_actualbitsLp0 - us_L0;
                        us_done_reduce = 1;
                     }
                     us_j--;
                  }
               }
               else if(us_nc1bit > 3)
               {
                  // unload four 1 bit carriers -- we have to remove 4 carriers, as otherwise it's very likely that we still don't find a solution
                  us_done_reduce = 0;
                  us_j = gs_RxNumTones-1;
                  while(us_done_reduce < 4)
                  {
                     if(guca_RxBat[us_j]==1)
                     {
                        guca_RxBat[us_j]=0;
                       //Parikshartha Begin
#ifdef SET_NEG_INF
                        gsa_RxFineGains[us_j] = NEG_INFINITY_DB;
#endif
                       //PariksharthaEnd
                        us_nc1bit--;
                        us_sumBi--;
                        s_TotalBitsSupported--;
                        us_ncloaded--;
                        us_done_reduce++;
                        if(us_done_reduce==2)
                        {
                        s_Tcm_Oh = 4 + ((1+(us_ncloaded-us_rm1bit)-((us_nc1bit-us_rm1bit)>>1)) >> 1);
                        if(gft_TcmFlag_bis_DS == FALSE)
                           s_Tcm_Oh = 0;
                        s_actualbitsLp0 = (us_sumBi-us_rm1bit)-s_Tcm_Oh;
                        s_bitstoreduce  = s_actualbitsLp0-us_L0;
                        }
                     }
                  us_j--;
                  }
               }
               else if(us_nc2bit > 1)
               {
                  // change two 2-bit to 1-bit
                  us_done_reduce = 0;
                  us_j = gs_RxNumTones-1;
                  while(us_done_reduce < 2)
                  {
                     if(guca_RxBat[us_j]==2)
                     {
                        guca_RxBat[us_j]= 1;
                        us_nc2bit--;
                        us_nc1bit++;
                        us_sumBi--;
                        s_TotalBitsSupported--;
                        us_done_reduce++;
                        if(us_done_reduce==2) {
                        s_Tcm_Oh = 4 + ((1+(us_ncloaded-us_rm1bit)-((us_nc1bit-us_rm1bit)>>1)) >> 1);
                        if(gft_TcmFlag_bis_DS == FALSE)
                           s_Tcm_Oh = 0;

                        s_actualbitsLp0 = (us_sumBi-us_rm1bit) - s_Tcm_Oh;
                        s_bitstoreduce  = s_actualbitsLp0 - us_L0;
                     }
                     }
                     us_j--;
                  }
               }
               else
               {
                  /* In general this should not happen */
                  gft_BitloadOK = FAIL;
                  ft_result = FAIL;
                  if(gft_Bitswap_UreTX == 1)
                     gft_BitloadOK = ft_result_Tr;
                  gus_BitloadExceptionCode = E_CODE_BITLOAD_LP0_BITS_NOT_AVAILABLE;
                  return(ft_result);
               }
            }
            if(s_bitstoreduce == 0)
            {
            ft_done = TRUE;
            }
         }
      }      // if (s_actualbitsLp0 >= us_L0)
      us_i--;
   }      // while ( (us_done == 0) && (us_i = gs_RxNumTones-1> gs_RxBitLoadFirstChannel) )

   if(us_rm1bit == 1)
   {
    // unload the highest 1bit carrier
      ft_done = FALSE;
      us_j = gs_RxNumTones-1;
      while(ft_done == FALSE)
      {
         if(guca_RxBat[us_j] == 1 )
         {
            guca_RxBat[us_j] = 0;
            //Parikshartha Begin
#ifdef SET_NEG_INF
            gsa_RxFineGains[us_j] = NEG_INFINITY_DB;
#endif
           //Parikshartha End
            us_nc1bit--;
            us_ncloaded--;
            s_TotalBitsSupported--;
            ft_done = TRUE;
         }
         us_j --;
      }
   }


   if (ft_done == FALSE)
   {
      //mod_bitload_if_Lp0_has_tones_with_bi_1_&_2 End
      // can't meet the rate on LP0, fail
      gft_BitloadOK = FAIL;
      ft_result = FAIL;
      if(gft_Bitswap_UreTX == 1)
         gft_BitloadOK = ft_result_Tr;
      gus_BitloadExceptionCode   = E_CODE_BITLOAD_LP0FAIL;
      return(ft_result);
   }

   if(gft_Bitswap_UreTX == 1)
   {
      gs_MaxToneForFast_ReTx_ST = s_MinToneLp0-1 ;
      gs_TCM_ovhd_Lp0_ReTx = s_Tcm_Oh;
      gs_bits_Lp0_ReTx = s_actualbitsLp0;
      gs_ncloaded_Lp0_ReTx = us_ncloaded;
   }
   else
   {
      gs_MaxToneForFast = s_MinToneLp0-1 ;
      gs_TCM_ovhd_Lp0 = s_Tcm_Oh;
      gs_bits_Lp0 = s_actualbitsLp0;
      gs_ncloaded_Lp0 = us_ncloaded;
   }
   *ps_TotalBitsSupported = s_TotalBitsSupported;

   // (4) calculate Lp Available for LP1 = LpAvail-Lp0-Trellis Overhead (take care for 1 bit carriers)
   *pus_LpAvailable = s_TotalBitsSupported-s_actualbitsLp0-s_Tcm_Oh;
   *ps_MinToneLp0 = s_MinToneLp0;
   ft_result = SUCCEED;
   return(ft_result);
}
/*^^^
 *-----------------------------------------------------------------------------
 *
 *   Prototype:
 *    void Check_LP1_Available(uint16 *pus_LpAvailable,int16 s_MaxToneForFast)
 *
 *   Description:
 *    This function is called after calculation of Max Available bits,
 *    And allocateion of bits LP0 is completed.
 *    This function will verify bits avaialbale for LP1 after considering
 *    no one bit tones and no of tones to be even.
 *    Bits are allocated from FirstChannel -> LastChannel.
 *    It will pick the DS PMS parameters LP0 from gt_PMSParams.s_Lp[0].
 *
 * Input Arguments:
 *                *pus_LpAvailable       => Available Bits for LP1.
 *                s_MaxToneForFast       => Last Tone for LP1 bit loading
 * Output Arguments:
 *                *ps_TotalBitsSupported => Available Max bits after removing some bits
 *                                           for LP0 convergence.
 *                *pus_LpAvailable       => Available Bits for LP1 after removing
 *                                          Trellis overhead.
 *   Returns:
 *
 * Global Variables:
 *
 ***********************************************************************************/

void Check_LP1_Available(uint16 *pus_LpAvailable,int16 s_MaxToneForFast)
{
   uint16 us_LpAvailable,us_ncloaded,us_minbat,us_i,us_tmp = 0;
   int16  s_Tcm_Oh;
   us_LpAvailable = *pus_LpAvailable;

   // decide how many tones are used
   // go in physical order from left to right
   // for the time being we don't allow for 1 bit carriers in LP1
   // and number of carriers assigned to LP1 has to be even

   us_ncloaded =  0;
   us_minbat   = 20;

   for (us_i = gs_RxBitLoadFirstChannel; us_i <= s_MaxToneForFast; us_i++)
   {
      if (guca_RxBat[us_i] > 0)
      {
         SETTONEFLAG(p_TonesAllocatedtoLP1_DS, us_i); // Tone allocated to LP1
         us_ncloaded ++;
         if(guca_RxBat[us_i] == 1)
         {
            guca_RxBat[us_i] = 0;
            //Parikshartha Begin
#ifdef SET_NEG_INF
            gsa_RxFineGains[us_i] = NEG_INFINITY_DB;
#endif
            //Parikshartha End
            CLEARTONEFLAG(p_TonesAllocatedtoLP1_DS, us_i); // Tone not allocated to LP1
            us_LpAvailable--;
            us_ncloaded--;
         }
         else
         {
            if(guca_RxBat[us_i] < us_minbat)
            {
               us_minbat = guca_RxBat[us_i];
               us_tmp = us_i;
            }
         }
      }
   }

   if((us_ncloaded & 0x1) == 1) //Even or odd check
   {
      us_LpAvailable -= us_minbat;
      us_ncloaded--;
      guca_RxBat[us_tmp] = 0; // TODO 2nd bitload
      //Parikshartha Begin
#ifdef SET_NEG_INF
      gsa_RxFineGains[us_tmp] = NEG_INFINITY_DB;
#endif
      //Parikshartha End
      CLEARTONEFLAG(p_TonesAllocatedtoLP1_DS, us_tmp); // Tone not allocated to LP1
   }

   // Trellis Overhead LP1 only
   s_Tcm_Oh = us_ncloaded >> 1;
   //If Trellis is disabled overhead should be zero.
   if(gft_TcmFlag_bis_DS == FALSE)
         s_Tcm_Oh = 0;
   //Do_not_allow_1_bit_tone_in_Lp1
   us_LpAvailable -= s_Tcm_Oh;
   // save the TCM overhead for LP1 path and number of loaded carriers

   if(gft_Bitswap_UreTX == 1)
   {
      gs_TCM_ovhd_Lp1_ReTx = s_Tcm_Oh;
      gus_ncloaded_Lp1_ReTx = us_ncloaded;
   }
   else
   {
      gs_Tcm_Oh_LP1    = s_Tcm_Oh ;
      gus_ncloaded_LP1 = us_ncloaded;
   }
   *pus_LpAvailable = us_LpAvailable;
}


/*^^^
 *-----------------------------------------------------------------------------
 *
 *   Prototype:
 *       FlagT Assign_Bits_For_LP1(uint16 us_LpAvailable, int16 s_MinToneLp0)
 *
 *   Description:
 *    This function is called after calculation of Max Available bits,and LP0 bits were also
 *    allocated.This function will allocate the bits LP1 path in ReTransmission.
 *    Bits are allocated from FirstChannel -> LastChannel.
 *    It will pick the DS PMS parameters LP0 from gt_PMSParams.s_Lp[0].
 *
 * Input Arguments:
 *                us_LpAvailable => Total Available bits for LP1 path
 *                s_MinToneLp0   => Last Tone for LP1 bit load
 * Output Arguments:
 *
 *   Returns:
 *                ft_result   => SUCCEED if LP1 bits are successfully allocated.
 *                            => FAIL
 *
 * Global Variables:
 *    gt_PMSParams.s_Lp[1] -- (I) LP1 bits from Framing parameter calculation.
 *    gft_Bitswap_UreTX  -- (I) Indicates 1 -> called After Showtime.
 *    gs_RxBitLoadFirstChannel  -- (I) FirstChannel for BitLoad
 *    gs_RxNumTones            -- (I) Number of Tones depending on mode
 *    p_TonesAllocatedtoLP1_DS -- (O) LP1 Tone Set.
 *    gpsa_MeasuredSnrBuf -- (O) pointer to measured SNR buffer
 *    gs_BitLoadingOK      -- (O) set to SUCCEED if bit loading succeeds, else set to FAIL
 *
 ***********************************************************************************/

// (6) do bitloading on lower tones for LP1 (+Trellis Overhead)
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_Remove_xs_bits_Lp1 Begin
FlagT Assign_Bits_For_LP1(uint16 *pus_LpAvailable, int16 s_MinToneLp0,
                           uint16 *pus_nc1bit, uint16 *pus_nc2bit,
                           uint16 *pus_nc3bit,uint16 *pus_maxbitstoreduce)
{

   uint16 us_actualbitsLp1,us_i;
   int16 s_bitstoreduce;
//FEATURE_DS_BisPlus_ALL_UReTx_net_max_modifications Begin
   FlagT ft_result_Tr = FALSE;
   uint16 us_tmp;
   uint16 us_j,us_LpAvailable,us_nc1bit,us_nc2bit,us_nc3bit,us_maxbitstoreduce;
//FEATURE_DS_BisPlus_ALL_UReTx_net_max_modifications End

      us_LpAvailable = *pus_LpAvailable;
      us_nc1bit = *pus_nc1bit;
      us_nc2bit = *pus_nc2bit;
      us_nc3bit = *pus_nc3bit;
      us_maxbitstoreduce = *pus_maxbitstoreduce;

   if(gft_Bitswap_UreTX == 1)
      ft_result_Tr = gft_BitloadOK;

   us_actualbitsLp1 = gt_PMSParams.s_Lp[1];
   s_bitstoreduce   = us_LpAvailable - us_actualbitsLp1;

   //  reduce these from the tones allocated to LP1 path
   // we need to trim bits to get the desired Lp

   if(s_bitstoreduce > 0)
   {
      /* Remove bits. At this point we know that we can meet the requirement.
         First remove 1-Bit carriers and then check how many tone pairs have to be removed.
         We only remove sets of 4 1-bit carriers. */

      us_i = s_MinToneLp0-1; // max tone that can be switched off
      us_tmp = us_nc1bit/4;
      while( (us_tmp>0) && (s_bitstoreduce>3) )
      {
         // remove four 1-Bit carriers
         us_j = 4;
         while(us_j>0)
         {
            if(guca_RxBat[us_i]==1)
            {
               guca_RxBat[us_i] = 0;
               us_j--;

   #ifdef SET_NEG_INF
               gsa_RxFineGains[us_i] = NEG_INFINITY_DB;
   #endif
            }
            us_i--;
         }//while(us_j>0)
         s_bitstoreduce  -= 3;
         us_tmp--;
//       us_ncloaded     -= 4;
         gs_Tcm_Oh_LP1--;
         gus_ncloaded_LP1 -= 4;
      }//while( (us_tmp>0) && (s_bitstoreduce>3) )


      // 2nd step: Remove bits from tones with bi>2
      // Take care that there has to remain a multiple of 3 bits to reduce
      // if we can't meet the requirements here.
      while( (s_bitstoreduce !=0 ) && (us_nc3bit>1) )
      {

         for(us_i=gs_RxBitLoadFirstChannel; us_i <s_MinToneLp0; us_i++)
         {
            if(guca_RxBat[us_i] > 2)
            {
               guca_RxBat[us_i]--;
               s_bitstoreduce--;
               us_maxbitstoreduce--;
               us_actualbitsLp1--;
               if(guca_RxBat[us_i] == 2)
               {
                  us_nc3bit--;
               }//if(uca_RxBat[us_i] == 2)
            }//if(uca_RxBat[us_i] > 2)

            if( (s_bitstoreduce==0) || ( ((s_bitstoreduce%3)==0) && (us_maxbitstoreduce<3) ) )
               break;
         }//for(us_i=gs_RxBitLoadFirstChannel; us_i <s_MinToneLp0; us_i++)
         if( ((s_bitstoreduce%3)==0) && (us_maxbitstoreduce<3) )
            break;
      }//while( (s_bitstoreduce !=0 ) && (us_nc3bit>1) )

      // 3. step: Remove tone pairs. At this point we can be sure that we only have to remove
      // 2-bit carriers.
      while( (s_bitstoreduce > 0) )
      {
         // we have to switch off tones
         // remove tone pairs us_i and us_j
         us_i = s_MinToneLp0-1;
         us_tmp = 2;

         while(us_tmp > 0)
         {
            if(guca_RxBat[us_i]==2 )
            {
               us_tmp--;
               guca_RxBat[us_i] = 0;
   #ifdef SET_NEG_INF
               gsa_RxFineGains[us_i] = NEG_INFINITY_DB;
   #endif
            }//if(guca_RxBat[us_i]==2 )
            us_i--;
         }//while(us_tmp > 0)
         s_bitstoreduce   -= 3;
//       us_ncloaded      -= 2;
         gs_Tcm_Oh_LP1--;
         gus_ncloaded_LP1 -= 2;
      }//while( (s_bitstoreduce > 0) )
      if (s_bitstoreduce!= 0)
      {
         // can't meet the rate on LP0, fail
         gft_BitloadOK = FAIL;
         if(gft_Bitswap_UreTX == 1)
            gft_BitloadOK = ft_result_Tr;
         gus_BitloadExceptionCode   = E_CODE_BITLOAD_LP1FAIL;
         return(FAIL);
      }
      else
      {
         gft_BitloadOK = 1;

      }
      return(SUCCEED);
   }// if(s_bitstoremove > 0)
   else if(s_bitstoreduce == 0)
   {
      return(SUCCEED);
   }
   else
   {
      gft_BitloadOK = FAIL;
      if(gft_Bitswap_UreTX == 1)
      gft_BitloadOK = ft_result_Tr;
      gus_BitloadExceptionCode   = E_CODE_BITLOAD_LP1FAIL;
      return(FAIL);
   }
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_Remove_xs_bits_Lp1 End
}


/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*   void DecideForRTParams(void)
*
*   Description:
*  This function computes Framing Parameters if Retransmission is enabled.
*
*  Input Arguments:
*
*  Output Arguments:
*
*   Returns:
*     None.
*
*  Global Variables:
*     many...
*
*-----------------------------------------------------------------------------
^^^*/
void DecideForRTParams(void)
{

   uint16 us_RTmemMax       = 0;
   //mod_bitload_if_Lp0_has_tones_with_bi_1_&_2 Begin
   // uint16 us_s_COCPE, us_d_COCPE, us_i;
   uint16 us_s_COCPE, us_d_COCPE;
   //mod_bitload_if_Lp0_has_tones_with_bi_1_&_2 End
   FlagT ft_bitload_ok;

    // Latency Path 0
   uint16 us_L0             = 0;
   uint16 us_D0             = 0;
   uint16 us_SEQ            = 0;
   uint16 us_MSGc           = 0;
   uint16 us_R0             = 0;
   uint16 us_M0             = 0;
   uint16 us_B0             = 0;
   uint16 us_T0             = 0;


   int16 s_CodingGain_in,s_RxDesiredMargin,s_TotalBitsSupported,s_MaxToneForFast;
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_Remove_xs_bits_Lp1 Begin
   int16 s_MinToneLp0, us_maxbitstoreduce;

   //mod_bitload_if_Lp0_has_tones_with_bi_1_&_2 Begin
    uint16 us_LpAvailable, us_nc1bit, us_nc2bit, us_nc3bit;
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_Remove_xs_bits_Lp1 End
   FlagT ft_done;
   //mod_bitload_if_Lp0_has_tones_with_bi_1_&_2 End
   //Preset_DS_Fine_gain_For_tones_below_34 Begin
   int32 l_temp1;
   //Preset_DS_Fine_gain_For_tones_below_34 End
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_Remove_xs_bits_Lp1 End
   us_nc1bit = 0;
   us_nc2bit = 0;
   us_nc3bit = 0;
   us_maxbitstoreduce = 0;
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_Remove_xs_bits_Lp1 End
   // As a first step we calculate LpAvailable
   // Coding Gain = Trellis + ReTx Coding Gain
   // RS Coding Gain is set to 0 (theoretically we'd have some RS coding gain in LP0)
   //
   // Currently in Dual Latency:
   // Bitswap Disabled ()
   // Fast -> LP1
   // LP1: No 1 Bit Carrier
   // Fill low tones until min bits for LP1 are loaded -> reduce BAT until exactly min bits for LP1 are loaded
   // Then do bitloading for LP0 on upper tones
   //
   // Now: LP0 rate is fixed
   // 1st implementation:
   // (0) Check if Trellis is on (TODO): the current code assumes that Trellis is on
   // (1) determine max bits available LP0+LP1 (take LP1 coding gain): Line Rate
   // (2) determine required LP0
   // (3) do bitloading on upper tones for LP0 (+Trellis Overhead)
   //     we should also determine the fine gains
   // (4) calculate Lp Available for LP1 = LpAvail-Lp0-Trellis Overhead (take care for 1 bit carriers)
   // (5) determine optimum Lp for LP1
   // (6) do bitloading on lower tones for LP1 (+Trellis Overhead)
   //     we should also determine the fine gains

   // We set Number of latency paths = 2
   gt_rx_config.s_Nlp = 2;

   /////////////////////////////////////////////////////////////////////////////////////////////////////
   // (1) determine max bits available LP0+LP1 (take LP1 coding gain)
   // do LP1 bitloading and mark tones used for LP1
   gft_BitloadOK = InitBitloading(LP1_DATA_PATH);
   //FEATURE_DS_BisPlus_ALL_BitSwapReTx_PAR Start
      // clear p_PARRTONEset
   memset(p_PARRTONEset, 0,
                   (sizeof(uint8)) * ((int16) (RX_NUM_TONES >> 3)));
   //FEATURE_DS_BisPlus_ALL_BitSwapReTx_PAR End
   /// Compute SNR plus coding gain ///
   gpsa_MeasuredSnrBuf = &gsa_RxShowtimeSnrBuf[0];

   // Adjust Constellation SNR if Trellis is on
   if ((gft_TcmFlag_bis_DS == TRUE) && (guc_Iridia_Revision_Number != IRIDIA_31))
      AdjustTcmCodingGains(0);
   s_RxDesiredMargin = gs_RxDesiredMargin - OPTNArray[OPTN_MarginDelta]; // ?????
   //SMS01436600:FEATURE_DS_BisPlus_ALL_BitSwapReTx (Start)
   // Initialise gs_target_margin value
   gs_target_margin = gs_RxDesiredMargin;
   //SMS01436600:FEATURE_DS_BisPlus_ALL_BitSwapReTx (End)
   OffsetSNRRequired(s_RxDesiredMargin , gsa_SNRRequired);
   if((gt_INFX_CMV.us_SRA_IOP_Bits & CMV_FT_ReTx_CG_Performance)
      &&(gt_ReTxConfigInfo.us_INP_min == 0 )
      &&(gt_ReTxConfigInfo.us_SHINEratio == 0)
      &&(gt_ReTxConfigInfo.us_INP_min_rein == 0)
   )
   {
      //CodingGain for R & D (R=4, D=1)   + ReTx
      s_CodingGain_in =  GetCodingGain_BIS(4, 1);
   }
   else
   {
      //CodingGain for R & D (R=0, D=1)   + ReTx
      s_CodingGain_in =  GetCodingGain_BIS(0, 1);
   }
   /// Add coding gain to SNRs ///
   AddCodingGainToSnr(gsa_MedleySnrBuf,  s_CodingGain_in, gpsa_MeasuredSnrBuf, LP1_DATA_PATH);

   ///Store coding gain in Q8.8 format///
   // Both latency paths!!
   gsa_TotalCodingGain[LP0_DATA_PATH] = s_CodingGain_in;
   gsa_TotalCodingGain[LP1_DATA_PATH] = s_CodingGain_in;
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr Begin
   gs_CodingGainForATTNDR = s_CodingGain_in;
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr End

   // don't change minbits!!
   s_TotalBitsSupported = CalcMaxBits(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxExtraBits, &gus_ncloaded, &gs_RxAvFineGain, 0x7FFF, LP1_DATA_PATH);

   gs_TotalBitsSupported = s_TotalBitsSupported;

   /////////////////////////////////////////////////////////////////////////////////////////////////////
   // (2) determine required LP0
   if(gt_ReTxConfigInfo.us_MSGmin <=61)
   { // exact:61.6
      // Framing for LP0 with overhead channel only
      us_B0 = 0;
      us_T0 = 1;
      us_R0 = 16;
      us_M0 = 16;

      if (gt_ReTxConfigInfo.us_MSGmin<=13)
      {      // exact:13.6
         us_L0   =   8;
         us_D0   =   1;
         us_SEQ  =  40;    // length of synch sequence = us_MSGc+6
         us_MSGc =  34;    // number of bytes
      }
      else if(gt_ReTxConfigInfo.us_MSGmin<=29)
      { // exact:29.6
         us_L0   =  16;
         us_D0   =   2;
         us_SEQ  =  80;
         us_MSGc =  74;
      }
      else
      {
         us_L0   =  32;
         us_D0   =   4;
         us_SEQ  = 160;
         us_MSGc = 154;
      }
   }
   else
   {
      gft_BitloadOK = FAIL;
      // TODO: Set exception code
      return;
   }

    //FEATURE_DS_BisPlus_ALL_ForceExplicitFramingForURETX (Start)
//   if(gs_Force_ReTx_Framing)
   if(gt_ReTxConfigInfo.us_Force_Explicit_Framing)
   {
      us_D0 = gt_rx_config.s_Dp[0];
      us_M0 = gt_rx_config.s_Mp[0];
      us_R0 = gt_rx_config.s_Rp[0];
      us_T0 = gt_rx_config.s_Tp[0];
      us_L0 = gt_rx_config.s_Lp[0];
      us_MSGc = gt_rx_config.s_MSGc;
      us_B0 = gt_rx_config.sa_Bpn[0][0];
   }
   //FEATURE_DS_BisPlus_ALL_ForceExplicitFramingForURETX (End)

   // Store Framing Parameters for LP0
   gt_PMSParams.s_Dp[0]      = us_D0;
   gt_PMSParams.s_Mp[0]      = us_M0;
   gt_PMSParams.s_Rp[0]      = us_R0;
   gt_PMSParams.s_Tp[0]      = us_T0;
   gt_PMSParams.s_Lp[0]      = us_L0;
   gt_PMSParams.s_IBITSlp    = 0; // ???
   gt_PMSParams.s_MSGlp      = 0;
   gt_PMSParams.s_MSGc       = us_MSGc;
   gt_PMSParams.sa_Bpn[0][0] = us_B0;
   gt_PMSParams.sa_Bpn[0][1] = 0;
   // TODO: SEQ, IBITSlp

    ////////////////////////////////////////////////////////////////////////////////////////////////
   // (3) do bitloading on upper tones for LP0 (+Trellis Overhead)

   // decide how many tones are used
   // go in physical order from left to right and keep tones till sum(bi) = Lp0
   // also take care of Trellis overhead
   ft_bitload_ok = Assign_Bits_For_LP0 (&s_TotalBitsSupported,&us_LpAvailable,&s_MinToneLp0);
   if(ft_bitload_ok == FAIL)
   {
      //gus_BitloadExceptionCode set in above fn "Assign_Bits_For_LP0"
      return;
   }

   // decide how many tones are used
   // go in physical order from left to right
   // for the time being we don't allow for 1 bit carriers in LP1
   // and number of carriers assigned to LP1 has to be even
   s_MaxToneForFast = gs_MaxToneForFast;

   Check_LP1_Available(&us_LpAvailable,s_MaxToneForFast);



   // (5) determine optimum Lp for LP1
   // calculations that can be done outside the loop
   // Available ReTx Memory

   if ((gt_ReTxConfigInfo.ft_ifx_co_flag == 1) &&
       (gt_ReTxConfigInfo.us_ReTxConfigOptionBits & CMV_BIT_INDICATE_IFX_MAX_16K_RETX)
      )
   {
      us_RTmemMax = gt_ReTxConfigInfo.us_RTmemMaxIfx;
   }
   else
   {
     if (gt_ReTxConfigInfo.ft_adsl2p_flag == 1)
     {
       us_RTmemMax = 12000;
     }
     else
     {
        us_RTmemMax = 8001;
     }
   }
   gt_ReTxConfigInfo.us_RTmemMaxIfx = us_RTmemMax;

   // us_s_COCPE = gt_ReTxConfigInfo.us_s_CO + gt_ReTxConfigInfo.us_s_CPE;
   // us_d_COCPE = gt_ReTxConfigInfo.us_d_CO + gt_ReTxConfigInfo.us_d_CPE;
   us_s_COCPE = gt_ReTxConfigInfo.us_s_CO + gt_ReTxConfigInfo.us_s_CPE + 1;
   us_d_COCPE = gt_ReTxConfigInfo.us_d_CO + gt_ReTxConfigInfo.us_d_CPE + 1;
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_Remove_xs_bits_Lp1  Begin
    /* change v12: sometimes we have to switch off tones also in LP1 */
   ft_done = FALSE;
   while(ft_done == FALSE)
   {

      ft_bitload_ok = get_framingRT(us_s_COCPE, us_d_COCPE, us_LpAvailable,
                           gt_ReTxConfigInfo.us_ETR_min, gt_ReTxConfigInfo.us_ETR_max, gt_ReTxConfigInfo.us_net_max,
                           gt_ReTxConfigInfo.us_SpMinInvers, gt_ReTxConfigInfo.us_QSmin,gt_ReTxConfigInfo.us_QSmax, us_RTmemMax,
                           gt_ReTxConfigInfo.us_delay_max,gt_ReTxConfigInfo.us_INP_min,gt_ReTxConfigInfo.us_INP_min_rein,gt_ReTxConfigInfo.ft_ia_rein_flag,
                           gt_ReTxConfigInfo.us_SHINEratio,gt_ReTxConfigInfo.us_CIP);

      if(ft_bitload_ok==0)
      {
         gft_BitloadOK = 0;
         gus_BitloadExceptionCode   = E_CODE_BITLOAD_LP1_INSUFFICIENTCAPACITY;
         return;
      }

      ft_done = Check_max_bits_to_reduce(&us_LpAvailable, s_MinToneLp0,
                  &us_nc1bit, &us_nc2bit, &us_nc3bit, (uint16 *)(void *)&us_maxbitstoreduce);
#if 0
   // (6) do bitloading on lower tones for LP1 (+Trellis Overhead)
           /* The number of bits (w/o Trellis overhead) that have to be loaded in LP1
            to get the desired NDR is gt_PMSParams.s_Lp[1].
         Currently us_LpAvailable bits have been loaded.
         */
      us_actualbitsLp1 = gt_PMSParams.s_Lp[1];
      s_bitstoreduce   = us_LpAvailable - us_actualbitsLp1;
      // gs_saveBitstoreduce = s_bitstoreduce;
      //  reduce these from the tones allocated to LP1 path

      // we need to trim bits to get the desired Lp

      if(s_bitstoreduce > 0)
      {
         /* Find out how many 1-bit and 2-bit carriers have been loaded
            and how many bits can be reduced w/o switching off tones. */
         us_maxbitstoreduce = 0;
         gus_nc1bit = 0;
         gus_nc2bit = 0;
         gus_nc3bit = 0;
         for (us_i=gs_RxBitLoadFirstChannel; us_i <s_MinToneLp0; us_i++)
         {

            if (guca_RxBat[us_i] == 1)
            {
               gus_nc1bit ++;
            }
            else if(guca_RxBat[us_i] == 2)
            {
               gus_nc2bit ++;
            }
            else if(guca_RxBat[us_i]>2)
            {
               gus_nc3bit ++;
               gus_maxbitstoreduce += guca_RxBat[us_i]-2;
            }
         }

         us_remainbitstoreduce = s_bitstoreduce;
         /* check if we can remove enough bits.
         First try to remove the 1-Bit carriers. If we remove 4 1-bit carriers we remove effectively 3 bits. */

         us_tmp = gus_nc1bit/4;
         while( (us_tmp>0) && (us_remainbitstoreduce>3) )
         {
            us_remainbitstoreduce-=3;
            us_tmp--;
         }

         us_tmp = (us_nc2bit + us_nc3bit)/2; // number of tonepairs
         while( (us_remainbitstoreduce > us_maxbitstoreduce) && (gus_remainbitstoreduce > 3) && (us_tmp>1) )
         {
            // If this is the case we have to remove tones
            // If we remove two tones we effectly remove 3 bits.
            us_remainbitstoreduce-=3;
            us_tmp--;
         }

         if(us_remainbitstoreduce > gus_maxbitstoreduce) {
            // We can't remove enough bits. We have to reduve LpBitsAvailable and redo the framing parameter generation.
            // This is a very unlike case that only can occur if there are (almost) only 1 and 2 bit carriers.
            us_LpAvailable = us_actualbitsLp1 - us_remainbitstoreduce;
            // We might also force this Lp now, but probably this part of the code will never be executed.
         }
         else
         {
            ft_done = TRUE;
         }
      }      // if(s_bitstoreduce > 0)
      else
      {
         ft_done = TRUE;
      }
#endif
   }      // while (ft_done == FALSE)

//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_Remove_xs_bits_Lp1 End
   // (6) do bitloading on lower tones for LP1 (+Trellis Overhead)
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_Remove_xs_bits_Lp1 Begin
   ft_bitload_ok =  Assign_Bits_For_LP1(&us_LpAvailable, s_MinToneLp0, &us_nc1bit, &us_nc2bit, &us_nc3bit, (uint16 *)(void *)&us_maxbitstoreduce);
//FEATURE_DS_BisPlus_ALL_ReTx_Modfication_Remove_xs_bits_Lp1 End

   if(ft_bitload_ok == FAIL)
   {
      // gus_BitloadExceptionCode set in the fn "Assign_Bits_For_LP1"
      return;
   }

   gft_BitloadOK = ft_bitload_ok;



   //Preset_DS_Fine_gain_For_tones_below_34 Begin
   if (gft_BitloadOK == SUCCEED)
   {
      CalcMarginsAndGains(gft_FineGainOn, guca_RxBat, gsa_RxFineGains,
                          &gs_RxAvMargin, &gs_RxAvFineGain, &gs_RxMinMargin);

      // save the average and min margin at the end of initializations
      gs_init_AvMargin = gs_RxAvMargin;
      gs_init_MinMargin = gs_RxMinMargin;

      /* compute RMS fine gain value */
      l_temp1 =
         (int32) ComputeRMSFineGain(guca_RxBat, gsa_RxFineGains, gs_RxNumTones,
                                    gs_CurrentCoChipset, 0, 0);

      gt_TxPMDControl.us_RMSGI_DS =
         2 * (ConvertToDB(l_temp1) - ConvertToDB(8192));

      gs_RequestedRxMaxMargin = (int16) (((int32) gt_RCMsgs1_bis.us_MAXSNRMds * 26214) >> 10);  // 26214/1024
                                                                                                // ~
                                                                                                // 256/10

      if ((!(OPTNArray[OPTN_PwrManControl] & OPTN_ExMarginRedDisable)) &&
          (gft_FineGainOn == TRUE))
      {
         /* Calculate excess margin reduction in dB (EMR = min{(Average - Requested), (Minimum -
            Desired)}. */
         gt_FineGainInfo.s_ExcessMarRedDB =
            gs_RxAvMargin - gs_RequestedRxMaxMargin;
         if (gt_FineGainInfo.s_ExcessMarRedDB >
             gs_RxMinMargin - gs_RxDesiredMargin)
            gt_FineGainInfo.s_ExcessMarRedDB =
               gs_RxMinMargin - gs_RxDesiredMargin;
         /* Limit the margin reduction to 14.5dB + min_fine_gain (= 12dB, currently) from above. */
         if (gt_FineGainInfo.s_ExcessMarRedDB > 0x0E80 + gs_min_fine_gain)
            gt_FineGainInfo.s_ExcessMarRedDB = 0x0E80 + gs_min_fine_gain;
         /* Limit the margin reduction to 0dB from below. */
         if (gt_FineGainInfo.s_ExcessMarRedDB < 0)
            gt_FineGainInfo.s_ExcessMarRedDB = 0;

         /* Calculate fine gain reduction and FDQ boost. */
         gt_FineGainInfo.s_ExcessMarFGReduction =
            DecimalGain((int16) (-gt_FineGainInfo.s_ExcessMarRedDB));
         gs_ExcessMarFDQBoost =
            (int16) (0x4000000L / gt_FineGainInfo.s_ExcessMarFGReduction);

         // Modify the RMS fine gain value
         gt_TxPMDControl.us_RMSGI_DS -= gt_FineGainInfo.s_ExcessMarRedDB;

         // Modify the average fine gain value
         gs_RxAvFineGain -= gt_FineGainInfo.s_ExcessMarRedDB;

         // Update margins based on Excess Margin Reduction
         gs_RxAvMargin -= gt_FineGainInfo.s_ExcessMarRedDB;
         gs_RxMinMargin -= gt_FineGainInfo.s_ExcessMarRedDB;

         gs_init_AvMargin -= gt_FineGainInfo.s_ExcessMarRedDB;
         gs_init_MinMargin -= gt_FineGainInfo.s_ExcessMarRedDB;

      }

      // Report DS margin as 6 when it is 5.8 or 5.9
      // FIX_REPORTING: REPORT_DS_ALL_ALL_CeilDSmarginTo6dB (Start)
      if ((gs_RxAvMargin > 0x05CC) && (gs_RxAvMargin < 0x0600))   // 0x05CC is 5.79dB in 6.6 format
         gs_RxAvMargin = 0x0600; // 0x0600 is 6dB in 8.8. format
      // FIX_REPORTING: REPORT_DS_ALL_ALL_CeilDSmarginTo6dB (End)

      // for BIS ovhd update test parameter usage
      // set the default value of "external" copy of SNRM
      gs_RxSNRM_ovhd = gs_RxAvMargin;
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr Begin
      gl_ATTNDRds_Estimate_Initial =
         (int32) CalcATTNDR(gsa_MedleySnrBuf, s_RxDesiredMargin,
                            gs_CodingGainForATTNDR);
      // XDSLRTFW-2405 (Start)
      gl_ATTNDRds_Initial = gl_ATTNDRds_Estimate_Initial;
      gl_ATTNDRds_Estimate_Updated = gl_ATTNDRds_Initial;
      // XDSLRTFW-2405 (End)
// XDSLRTFW-665 XDSLRTFW-523 BugFix_DS_BisPlus_AB_All_UpdateATTNDRds_SRA (SATRT_END)
        gs_RxDesiredMargin_original = s_RxDesiredMargin;
//SMS01527673:Fix_DS_BisPlus_ALL_ReTx_Attndr_not_correct End
//XDSLRTFW-923:Fix_DS_BisPlus_ALL_ReTx_Attndr End
   }  // if (gft_BitloadOK = SUCCEED)
   //Preset_DS_Fine_gain_For_tones_below_34 End
} // End of "DecideForRTParams"
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

/*^^^
*------------------------------------------------------------------------
*
*  Prototype: void BGMedleyBitload_bis(void)
*
*  Description: Background Medley bitloading for BIS.
*
*  Arguments: none
*
*  Return: none
*
*  Global Variables Used:
*
*------------------------------------------------------------------------
*^^^
*/
//x = [1/1.5 1/1.6 1/1.7 1/1.8 1/1.9 1/2.0]
//x_basic = [0.6667 0.6250 0.5882 0.5556 0.5263 0.5000];
//x_basic_r = (10*(x_basic))+0.60;
//INP = (0.5:0.5:8)';
//xconst =round(x_basic.*256)
//xconst_h = dec2hex(xconst)
//%xInp = INP* 10*xconst;
//%xC2 = floor((xInp+130)/256);
//%FW_xC2 = [(INP.*10) xC2]
//FW_xC2 = [(INP.*10) floor(((INP.*10*xconst)+(0.625*256))/256)] %0.6
//%FW_xC2_r = [(INP.*10) xC2_r]
//%FW_xC2_r = [(INP.*10) floor(((INP.*10*x_basic)+0.60)) ]
//FW_xC2_r = [(INP.*10) floor(((INP.*10*x_basic*256)+(0.60*256))/256) ]


//ActInp in 0.1 steps
//ActInp G1.5 G1.6 G1.7 G1.8 G1.9 G2.0
//5         3  3     3     3  3     3
//10        7  6     6     6  5     5
//15        10    10   9   8  8     8
//20        13    13   12     11 11    10
//25        17    16   15     14 13    13
//30        20    19   18     17 16    15
//35        24    22   21     20 19    18
//40        27    25   24     22 21    20
//45        30    28   27     25 24    23
//50        34    31   30     28 26    25
//55        37    35   33     31 29    28
//60        40    38   36     33 32    30
//65        44    41   38     36 34    33
//70        47    44   41     39 37    35
//75        50    47   44     42 40    38
//80        54    50   47     45 42    40

int16 gs_saveBitstoreduce;
void BgMedleyBitload_bis(void)
{
    int16 s_temp, k, m;
    int16 s_snrbuf[NSC_C_PARAMS];
    //                                       [1.0000   0.6667    0.6250    0.5882    0.5556   0.5263     0.5000];
    // in 8.8 format
    int16 s_ErasureGains[7] = {0x0100, 0x00AB, 0x00A0, 0x0097, 0x008E, 0x0087, 0x0080};
    int16 s_path,s_idx;
    int i, s_ch;
    //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (Start)
#ifndef ISDN
    int32 l_temp;
    int16 s_TARSNRMds;
#endif
    //ADSLRTFW-1393 ENH_DS_BisPlus_All_downshiftSRAInterleaved (End)
    //XDSLRTFW-422 ENH_DS_BisPlus_All_SRAInterleaved_OneOverS0min (Start_End)
#ifndef ISDN
    uint16 us_CurrentCoVendorID;
#endif
    FlagT ft_INP_SRA_profile = FALSE;
    //FlagT ft_ErasureGainForRate = FALSE;
    //BIS DS TCM Control
    gft_TcmFlag_bis_DS = !(OPTNArray[OPTN_AlgControl] & OPTN_TCM_Disable);
    //BIS US TCM Control
    gft_TcmFlag_bis_US = !(TESTArray[TEST_Control] & TEST_BISUSTCMDisable);

    gl_debug_bitloadstart = gl_RxSymbolCount;
    gs_OneOverSminADSL2 = gt_HandshakeBis.s_OneOverSminADSL2;

    // Initialize tone order table to something valid.  This table is referenced during bitloading routines
    // (which are also used for OLR BAT calculations) but before its final values are computed.

    for (i=0 ; i< RX_NUM_TONES ; i++)
    gsa_RxToneOrder[i] = i;

    // Set Max CWSize to 247 for TDP CO
    if (gs_CurrentCoChipset == AWRE_CO_CHIPSET)
    gs_max_CWSize = 247;

    // Option to set Max CW size to 255 for Infineon CO Geminax 2.1 (if required)
    if ((TESTArray[TEST_Control2] & TEST_ForceCWSize247) && (gs_CurrentCoChipset == IFTN_CO_CHIPSET))
    gs_max_CWSize = 247;
    /*****************************************************************/
    if ((CNTLArray[0] & CNTL_ExpilictRate)== 0)  /* No explicit rate control */
    {

        gt_rx_config.s_Nbc = 0;// Initialize
        for (i=0; i<NUM_DS_BEARER_CHANNELS_SUPPORTED; i++)
        gt_rx_config.s_Nbc += gt_HandshakeBis.sa_DS_BCActive[i];

        gt_rx_config.s_Nlp = gt_HandshakeBis.s_NumDSLatencyPaths;

        // check for valid number of latency paths
        if (gt_rx_config.s_Nlp > 2)
        {
            gft_BitloadOK = FAIL;
            /* Set exception code */
            gus_BitloadExceptionCode   = E_CODE_BITLOAD_INVALID_NUM_LATENCY_PATHS;
            goto Set_TonesRMSG2;
        }

        // check for valid number of bearer channels (1 or 2)
        if ((gt_rx_config.s_Nbc >2) || (gt_rx_config.s_Nbc <1))
        {
            gft_BitloadOK = FAIL;
            /* Set exception code */
            gus_BitloadExceptionCode   = E_CODE_BITLOAD_INVALID_NUM_BEARER_CHANNELS;
            goto Set_TonesRMSG2;
        }


        // for case of single or Dual Latency, assign INP parameters

        // Impulse noise protection
        // We need to translate the INP specified on a per BC basis to a per LP basis.
        // To do this, we see how many BCs are active in the DS direction, and get the gs_INP to be
        // the maximum of all the BCs, and assign that to be the INP for the LP.

        gs_INP=0;  // no INP protection
#ifndef ISDN         // Only for Annex-A
         //ADSLRTFW-1362 IOP_A_DS_Plus_ALL_TelefonicaSparnexDSCRCs (START)
         if( (gt_INFX_CMV.us_OperatorSpBits4 & CMV_TO_ENABLE_FIX_Sparnex_DS_CRC)
            //XDSLRTFW-372 PERF_A_DS_Plus_ALL_LinkHoles_Fast_Long_Loop (START)
            && (gl_SelectedMode & (MODE_G992_5)) && (gt_HandshakeBis.sa_DS_MaxLatencyBC[LP0_DATA_PATH] > 1)
            //XDSLRTFW-372 PERF_A_DS_Plus_ALL_LinkHoles_Fast_Long_Loop (END)
            )
         {                                         // Loop estimation based on sparnex simulator may be different ?
            if (gs_hsk_tone_power_dB_PCB < 4900)   //>=4500m (MINIMUM_GHS_TONE_PWR_AT_14750F(6261))
               gs_INP = 3; // force 1.5 INP in sparnex long loops
            else if (gs_hsk_tone_power_dB_PCB < 12500) // >=2300m (MINIMUM_GHS_TONE_PWR_AT_7500F (13448))
               gs_INP = 2; // force 1.0 INP in sparnex long loops
         }
         //ADSLRTFW-1362 IOP_A_DS_Plus_ALL_TelefonicaSparnexDSCRCs (END)
#endif            // Only for Annex-A
         //XDSLRTFW-1489 (start)
         //XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING (Start): Taking Erasure into account
         if ((gt_INFX_CMV.us_OperatorSpBits6 & CMV_TO_ENABLE_REIN_DETECTION_TRAINING_AND_CHANGE_FRAMING)
            && ((guc_impulse_noise_present & REIN_IMPULSE_NOISE_VALID)== REIN_IMPULSE_NOISE_VALID)
            )
         {
            //gs_INP = ((gus_max_imp_symbol >> 1)+1)<<1;
            gs_INP = (gs_INP >(gus_max_imp_symbol<<1)) ? gs_INP:(((gus_max_imp_symbol >> 1)+1)<<1);
            //XDSLRTFW-1561 (start)
            if(gft_HighREIN_NOISE == TRUE)
            {
               OPTNArray[OPTN_AlgControl3] |= CMV_TO_ENABLE_FRACTIONAL_INP_FRAMEWORK;
               // Total 1 symbol extra protection to avoid CRCs
               gs_delta_INP = 9;
               gs_delta_INP += OPTNArray[OPTN_ExtraINP]; //0.1dB increase
            }
            else gs_INP += 1; //add 0.5 symbol extra protection.
            // Default erasure gain will be used for higher data rate.
            // In this cases, Use Erasure for higher INP protection. This is require for R7 release .
            gs_DSL_EDcontrol |= ERASURE_MAX_INP;

            //XDSLRTFW-1561 (end)
         }
         //XDSLRTFW-471 Enhance_DS_ALL_ALL_REIN_IMMUNITY_TRAINING (End)
         //XDSLRTFW-1489 (end)

         //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
         //XDSLRTFW-1502 (start)
         // Use erasure to boost the DataRate
         // For IOP issues checking both the conditions.
         //observed with E67_CNXT only "ft_INP_no_erasure_not_reqd" received, that too in MS.
         if ( (gt_ErasureDecoding_Reprt.ft_Report_ED == TRUE) &&
               (gt_ErasureDecoding_Reprt.ft_INP_no_erasure_not_reqd == TRUE) &&
               ((gs_DSL_EDcontrol & ERASURE_MAX_INP) == 0)&&
               (gs_DSL_EDcontrol & ERASURE_DECODING_ENABLE == ERASURE_DECODING_ENABLE)
             )
         {
            OPTNArray[OPTN_AlgControl3] |= CMV_TO_ENABLE_FRACTIONAL_INP_FRAMEWORK;
            gft_ErasureGainForRate = TRUE;
         }
         for (i = 0; i < gt_rx_config.s_Nbc; i++)
         {
            if ((gt_HandshakeBis.sa_DS_BCActive[i] == 1) && ( gt_HandshakeBis.sa_DS_MinINPBC[i] > gs_INP))
            {
               gs_INP = gt_HandshakeBis.sa_DS_MinINPBC[i];
               ft_INP_SRA_profile = TRUE;
            }
         }
      //SMS00920128 SMS00864205 FEATURE_DS_BisPlus_ALL_EnableFractionalINP (End)

        // Assign the rates for Latency Path 1
        // If single Latency Path, then configure it as LP0
        // All bearer channels to be assigned to LP0
        CHECK_RECONFIG: // for Geminax CO
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
       //SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad (Start)
      if(gt_ReTxConfigInfo.ft_ReTxOn == 0)
      { // No Retransmission
      //SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad (End)
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
         if (gt_rx_config.s_Nlp == 1)
         {
            s_path = LP0_DATA_PATH;
            // assign both Bearer Channels to LP0
            if(gt_HandshakeBis.sa_DS_BCActive[0]) guca_rxBCnToLPp[0] = (uint8)LP0_DATA_PATH;
            else guca_rxBCnToLPp[0] = 0xF;   //Bearer channel 0 not used, 0xF indicator sent during R_PARAMS
            if(gt_HandshakeBis.sa_DS_BCActive[1]) guca_rxBCnToLPp[1] = (uint8)LP0_DATA_PATH;
            else guca_rxBCnToLPp[1] = 0xF;   //Bearer channel 1 not used, 0xF indicator sent during R_PARAMS
            gs_maxdatarate = 0;
            for(i=0; i < gt_rx_config.s_Nbc; i++)
            {
               gs_maxdatarate += gt_HandshakeBis.sa_DS_MaxNetDataRateBC[i];
            }


            //take max datarate as minimum of maxratelp or max rate from bc
            if(gs_maxdatarate >= gt_HandshakeBis.sa_DS_MaxDataRateLP[s_path])
            gs_maxdatarate = gt_HandshakeBis.sa_DS_MaxDataRateLP[s_path];

            //If CO makes an illegal configuration, i.e, handshake MaxNetRate = MinNetRate > ReservedRate
            //We change the bitloading MinRate = handshake MinNetRate. Otherwise, we will follow the spec,
            //assuming handshake MaxNetRate >= ReservedRate >= MinNetRate.
            //So the code here basically is choosing the Max(MinNetRate, ReservedRate) of handsahke
            //as the bitloading MinRate
            if (gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0] < gt_HandshakeBis.sa_DS_MinNetDataRateBC[0])
            gs_minnetdatarate = gt_HandshakeBis.sa_DS_MinNetDataRateBC[0];
            else
            gs_minnetdatarate = gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[0];

            //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved (START)
         //XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges (start)
         if ( (gt_INFX_CMV.us_OperatorSpBits2 & CMV_TO_ENABLE_ONE_STEP_SRA)
               || (gs_CurrentCoChipset == BDCM_CO_CHIPSET) )
         {

            TESTArray[TEST_OLR_SRA_DeltaLpchange] = 0x7fff;
            gft_OneStepSRA = TRUE;
         }
         //ADSLRTFW-1705 : BugFix_DS_BisPlus_All_TR105SRAChanges (start)
         if(gt_INFX_CMV.us_SRA_IOP_Bits & CMV_TO_DISABLE_SRA_FRAMING_CHECK)
         {
            gt_INFX_CMV.us_SRA_IOP_Bits &= ~CMV_TO_ENABLE_SRA_MAXLATENCY_CHECK;
            gt_INFX_CMV.us_SRA_IOP_Bits &= ~CMV_SRA_TO_ENABLE_MINOVERHEAD_GHS_CHECK;
            gt_INFX_CMV.us_SRA_IOP_Bits &= ~CMV_SRA_INP_FRAMING_CHECK ;
         }
         //ADSLRTFW-1705 : BugFix_DS_BisPlus_All_TR105SRAChanges (end)
         if((gft_AutoSRA_ErrorCondition == FALSE)&&(ft_INP_SRA_profile)
            &&(gt_INFX_CMV.us_SRA_IOP_Bits & CMV_TO_ENABLE_SRA_INP_CHECK_DELTA_LP)
            &&(gt_HandshakeBis.sa_DS_MaxLatencyBC[LP0_DATA_PATH] > 1)
           )
         {
            OPTNArray[OPTN_AlgControl3] |= CMV_TO_ENABLE_FRACTIONAL_INP_FRAMEWORK;
            gs_delta_INP += OPTNArray[OPTN_ExtraINP]; //0.1dB increase
            //disable searching delta Lp in this case.
            gt_INFX_CMV.us_SRA_IOP_Bits &= ~CMV_TO_ENABLE_SRA_SEARCHING_DELTA_LP;
            // Enable MaxLatency Framing search
            gt_INFX_CMV.us_SRA_IOP_Bits |= CMV_TO_ENABLE_SRA_MAXLATENCY_CHECK_DELTA_LP;

         }

         //SMS00920128 SMS00864205 FEATURE_DS_BisPlus_ALL_EnableFractionalINP (Start)

         if(OPTNArray[OPTN_AlgControl3] & CMV_TO_ENABLE_FRACTIONAL_INP_FRAMEWORK)
         {

            gus_Scale_FractINP = 5;

            //If fractional INP frame work is enabled,
            //  then gs_INP contains the value in 0.1 granuality;
            gs_INP =  (gus_Scale_FractINP * gs_INP);   // 10 * min INP
            gs_INP_no_erasure = gs_INP;
            if(gft_ErasureGainForRate == TRUE)
            {
               if(TESTArray[Test_ErasureGains] != 0)
               {
                  s_idx = TESTArray[Test_ErasureGains];
                  gt_INFX_CMV.s_ErasureGain   = s_ErasureGains[s_idx];
               }
               gs_INP = ((gs_INP*gt_INFX_CMV.s_ErasureGain)+160)>>8; // 160 = 0.625*256 round factor used
               gs_INP_erasure = gs_INP;
            }
            if(gs_delta_INP)
            {
               gs_delta_INP = ((gs_INP + gs_delta_INP) >160)?(160- gs_INP): gs_delta_INP;
               gs_INP = gs_INP + gs_delta_INP;
            }
            // For SRA profiles we may be limited by INP check (if upshift trigger is used first)  for doing the SRA UPShift.
            // Increase INP checky while computing the framing params
            if ( gs_INP > 160 )      // Maximum possible DS INP = 16
              gs_INP = 160;
            //SMS00920128 SMS00864205 PERF_BIS_PLUS_OVERRULE_DS_MIN_INP (End)

         }
         else
            gus_Scale_FractINP = 1;


         if(gt_INFX_CMV.us_SRA_IOP_Bits & CMV_TO_ENABLE_SRA_MAXLATENCY_CHECK_DELTA_LP)
         {
            gt_INFX_CMV.us_SRA_IOP_Bits &= ~CMV_TO_ENABLE_SRA_SEARCHING_DELTA_LP;
         }


#ifndef ISDN

         //XDSLRTFW-721 ADSLRTFW-1688 Enhance_DS_BisPlus_ALL_OptimizedSRACode (START)
         if ( (gt_INFX_CMV.us_SRA_IOP_Bits & CMV_TO_ENABLE_SRA_SEARCHING_DELTA_LP) &&
                 (gft_AutoSRA_ErrorCondition == FALSE) &&
                 (gt_HandshakeBis.sa_DS_MaxLatencyBC[LP0_DATA_PATH] > 1) )
            {
            //XDSLRTFW-930 ADSLRTFW-1517 ENH_DS_BisPlus_BDCM_SRA_EnhanceDsSyncUpRate (START)
            int16 s_Kp_MDF, s_temp1;
            int32 l_temp1;

            gs_deltaLp_max = 0;

            DecideForRParams_OneLatency(s_path);

            s_Kp_MDF = gt_PMSParams.sa_Bpn[0][0] + 1;
            MULS16(l_temp1, s_Kp_MDF, gt_PMSParams.s_Mp[0]);
            s_temp1 = (int16) l_temp1 + gt_PMSParams.s_Rp[0];

            gs_initial_datarate = (int16) ((gt_PMSParams.s_Tp[0] * s_Kp_MDF - 1) * gt_PMSParams.s_Mp[0] * ((int32) (gt_PMSParams.s_Lp[0])) / (gt_PMSParams.s_Tp[0] * s_temp1));
            //XDSLRTFW-930 ADSLRTFW-1517 ENH_DS_BisPlus_BDCM_SRA_EnhanceDsSyncUpRate (END)

            if(((gs_flag_fixedrate == 1)||(gs_flag_limitedrate == 1))
                &&(gt_INFX_CMV.us_SRA_IOP_Bits & CMV_TO_ENABLE_SEARCHING_DELTA_MarginOverINP)
               )
            {
               // By enabling this CMV, Framing params algorithm chose less D value. This will
               // enable us to trigger SRA for limited rate cases as well.
               gt_INFX_CMV.us_OperatorSpBits2 |= CMV_INFX_DFE_FAVOR_MARGIN_OVER_INP_ENABLE;
               gft_FrameCheckForSRA = FALSE;
               gs_deltaLp_max = 0;

            }

            else // if not fixed rate cases.
            {
               gft_FrameCheckForSRA = TRUE;
               //gs_sraOffset = OPTNArray[OPTN_SRA_OFFSET]; //default is 3 dB
               //XDSLRTFW-422 ENH_DS_BisPlus_All_SRAInterleaved_OneOverS0min (Start)
               us_CurrentCoVendorID = (uint16)gs_CurrentCoVendorID;
               if((gs_CurrentCoChipset == BDCM_CO_CHIPSET)&&
                     (us_CurrentCoVendorID == (0x939E) )&&
                     ((gs_OneOverSminADSL2 == 3) //|| (gs_OneOverSminADSL2 < OPTNArray[OPTN_INVSMIN_SRA_NoOptIntlvDepth])
                     )
                 )
                  gs_OneOverSminADSL2 = OPTNArray[OPTN_INVSMIN_SRA_NoOptIntlvDepth];
               //XDSLRTFW-422 ENH_DS_BisPlus_All_SRAInterleaved_OneOverS0min (end)

               l_temp = (int32) gt_RCMsgs1_bis.us_TARSNRMds << 8;
               s_TARSNRMds = (int16) (l_temp / 10);
               //Take the maximum of (target_margin - downshift_margin) and (upshift_margin - target_margin)
               if ((s_TARSNRMds-gt_RCMsgs1_bis.us_RA_DSNRMds) >= (gt_RCMsgs1_bis.us_RA_USNRMds-s_TARSNRMds))
                  gs_deltaLp_max = s_TARSNRMds-gt_RCMsgs1_bis.us_RA_DSNRMds;
               else
                  gs_deltaLp_max = gt_RCMsgs1_bis.us_RA_USNRMds-s_TARSNRMds;
               //XDSLRTFW-721 ADSLRTFW-1688 Enhance_DS_BisPlus_ALL_OptimizedSRACode (START_END)
               gs_deltaLp_max += OPTNArray[OPTN_SRA_OFFSET];
               MULS16(l_temp, gs_deltaLp_max, (gus_ncloaded /3)); // divide by 3 for more accurate Lp delta calculation. Each bit takes ~3dB SNR
               gs_deltaLp_max = l_temp>>8;
               //XDSLRTFW-721 ADSLRTFW-1688 Enhance_DS_BisPlus_ALL_OptimizedSRACode (START_END)
               //gs_deltaLp_max = guc_sra_cnt*gs_deltaLp_max;
               //2400 times of searching max_delta_Lp will take about 15384 symbols
               if (gs_deltaLp_max >= 2300)
                  gs_deltaLp_max = 2300;
               //XDSLRTFW-930 ADSLRTFW-1517 ENH_DS_BisPlus_BDCM_SRA_EnhanceDsSyncUpRate (END)
               }
            }
            else
            {
               gft_FrameCheckForSRA = FALSE;
               gs_deltaLp_max = 0;
            }

         //ADSLRTFW-1476 PERF_DS_A_BisPlus_All_TR100A2_FixedRate (END)
         //ADSLRTFW-1517 ENH_DS_BisPlus_BDCM_SRA_EnhanceDsSyncUpRate (START)
         //Reset the variables before the second call to "DecideForRParams_OneLatency".
         gs_found_valid_config = 0;
         gft_BitloadOK = FAIL;
         gs_iter_conv = 0;
         gs_flag_limitedrate = 0;
         gs_flag_fixedrate = 0;
#else    //ifndef ISDN
      // For Annex B  SRA, Capped rate,interleave profiles with min INP max margin
      if ( (gft_AutoSRA_ErrorCondition == FALSE) &&
            (gt_HandshakeBis.sa_DS_MaxLatencyBC[LP0_DATA_PATH] > 1)
          )
      {
         //below CMV is for limited rate, fixed rate cases.
         gt_INFX_CMV.us_OperatorSpBits2 |= CMV_INFX_DFE_FAVOR_MARGIN_OVER_INP_ENABLE;
      }

#endif
//ADSLRTFW-1517 ENH_DS_BisPlus_BDCM_SRA_EnhanceDsSyncUpRate (END)
         //XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges (end)

            // param selection code
            DecideForRParams_OneLatency(s_path);
        }
        else if (gt_rx_config.s_Nlp == 2)
        {
            // disable bitswap
            OPTNArray[OPTN_AlgControl] |= OPTN_DSAutoBitSwapDisable ;

            // Dual LAtency Case
            // Assume there are 2 bearer channels and assign BC0 to LP0 and BC1 to LP1

            if(gt_HandshakeBis.sa_DS_BCActive[0]) guca_rxBCnToLPp[0] = (uint8)LP0_DATA_PATH;
            else guca_rxBCnToLPp[0] = 0xF;   //Bearer channel 0 not used, 0xF indicator sent during R_PARAMS

            if(gt_HandshakeBis.sa_DS_BCActive[1]) guca_rxBCnToLPp[1] = (uint8)LP1_DATA_PATH;
            else guca_rxBCnToLPp[1] = 0xF;   //Bearer channel 1 not used, 0xF indicator sent during R_PARAMS

            // param selection code
            DecideForRParams_TwoLatency();
         }
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
      //SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad (Start)
      }
      else  //(gt_ReTxConfigInfo.ft_ReTxOn == 1)
      {
      guca_rxBCnToLPp[0] = (uint8) LP1_DATA_PATH;

      // 1 Bearer Channel; 2 Latency Paths
      // Take NetMax and SpMinInvers from ReTxInfo
      // Also take MSGmin from ReTx Info for debug purpose
      // Note: In non-ReTx code, bitswaps are disabled if gt_rx_config.s_Nlp == 2 (see above)
      //       The reason for this is unknown (?). We don't disable bitswaps here.
         if(gt_ReTxConfigInfo.us_MSGmin ==0)
         gt_ReTxConfigInfo.us_MSGmin = gt_HandshakeBis.s_MinMSGDSOverheadRate;

         // param selection code

#if 0 //This is Debug code to force the inputs for framing parameters calc.
      gt_ReTxConfigInfo.us_INP_min_rein = 0;
      gt_ReTxConfigInfo.us_SHINEratio = 30;
      gt_ReTxConfigInfo.us_s_CO = 7;
      gt_ReTxConfigInfo.us_d_CO = 0;
      gt_ReTxConfigInfo.us_SpMinInvers = 3;
      gt_ReTxConfigInfo.us_ETR_min = 10000;
      gt_ReTxConfigInfo.us_ETR_max = 16000;
      gt_ReTxConfigInfo.us_net_max = 30000;
      gt_ReTxConfigInfo.us_MSGmin = 6;
      gt_ReTxConfigInfo.us_s_CPE = 7;
      gt_ReTxConfigInfo.us_d_CPE = 0;
      gt_ReTxConfigInfo.us_QSmax = 16;
      gt_ReTxConfigInfo.us_QSmin = 2;
      gt_ReTxConfigInfo.us_RTmemMaxIfx = 16000;
      gt_ReTxConfigInfo.ft_ia_rein_flag = 1;
      gt_ReTxConfigInfo.ft_ifx_co_flag = 1;
      gt_ReTxConfigInfo.ft_adsl2p_flag = 1;
      gt_ReTxConfigInfo.ft_adsl2_flag = 0;
      gt_ReTxConfigInfo.us_delay_max = 63;
      gt_ReTxConfigInfo.us_INP_min = 44;
#endif
         //Function which calculates the framing parameters.
      DecideForRTParams();
      }

   //Enabled clock cycles check only for non UReTx
      if(gt_ReTxConfigInfo.ft_ReTxOn == 0)
      {
      //SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad (End)
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
         // check clock cycles for Geminax CO
         if ((gft_BitloadOK) && (gs_CurrentCoChipset == IFTN_CO_CHIPSET))
         {
            if (gs_NumIter_ClockCntHigh < gs_Max_NumRetrains)
            {
               gft_BitloadOK = CheckClockCycle(&gt_PMSParams);
               if (gft_BitloadOK == FAIL)
               {

                  //Change LP0  Smin requirement from 16 to 13
                  if (gs_OneOverSminADSL2 == 16) gs_OneOverSminADSL2 = 13;
                  else if (gs_OneOverSminADSL2 > 2)
                  gs_OneOverSminADSL2 -= 1; //decrement by 1

                  gs_NumIter_ClockCntHigh++;
                  // reset variables from previous iteration
                  gs_found_valid_config = 0;
                  gs_iter_conv=0;

                  goto CHECK_RECONFIG;

               }
            }
         }
      }
    } // End of  No explicit rate control
    else /* Explicit rate control */
    {
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
      //SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad (Start)
      //Explicit rate control is not tested for UReTx.
      //So explicit rate control is enabled only for non UReTx.
      if(gt_ReTxConfigInfo.ft_ReTxOn == 0)
      {
      //SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad (End)
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
        s_path = COMBINED_LP;
        gft_flag_explicitrate = 1;
        DecideForRParams_OneLatency(s_path);
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
      //SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad (Start)
      }
      else
      {  //No support for UReTx
          //Fail with exception code
         gft_BitloadOK = FAIL;
         /* Set exception code */
         gus_BitloadExceptionCode = E_CODE_BITLOAD_NOSUPPORT_EXPLICITRATE_URETX;
         goto Set_TonesRMSG2;
      }
      //SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad (End)
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
    }
    Set_TonesRMSG2:
    for(i=0; i<NSC_C_PARAMS; i++)
    {
        s_snrbuf[i] = 0;
        gusa_Tones_RMsg2[i] =0;
    }


    for(s_ch = gs_RxFirstChannel; s_ch <= gs_RxLastChannel; s_ch++)
    {

        if(gsa_MedleySnrBuf[s_ch] > s_snrbuf[0])
        {
            s_snrbuf[0] = gsa_MedleySnrBuf[s_ch];
            gusa_Tones_RMsg2[0] = s_ch;


            /* Sort the s_snrbuf[] in ascending order and adjust gusa_Tones_RMsg2[] accordingly  */
            for(i=0; i<(NSC_C_PARAMS-1); i++)
            {
                if(s_snrbuf[i]>s_snrbuf[i+1])
                {
                    s_temp = s_snrbuf[i];
                    s_snrbuf[i] = s_snrbuf[i+1];
                    s_snrbuf[i+1] = s_temp;

                    s_temp = (int16)gusa_Tones_RMsg2[i];
                    gusa_Tones_RMsg2[i] = gusa_Tones_RMsg2[i+1];
                    gusa_Tones_RMsg2[i+1] = s_temp;

                }
            }
        }  /* end of if(gsa_MedleySnrBuf[s_ch] > s_snrbuf[0]) */

    } /* end of for(s_ch = gs_RxFirstChannel; s_ch <= gs_RxLastChannel; s_ch++) */


    /* Sort the gusa_Tones_RMsg2[] in ascending order */
    m = NSC_C_PARAMS -1;
    while(m> -1)
    {
        k= m-1;
        m= -1;

        for(i=0; i<=k; i++)
        {
            if(gusa_Tones_RMsg2[i]>gusa_Tones_RMsg2[i+1])
            {
                s_temp = (int16)gusa_Tones_RMsg2[i];
                gusa_Tones_RMsg2[i]   = gusa_Tones_RMsg2[i+1];
                gusa_Tones_RMsg2[i+1] = s_temp;

                m = i;
            }
        }
    }
#ifndef TARGET_HW

    if (((CNTLArray[0] & CNTL_ExpilictRate)== 0) && (gft_BitloadOK ==SUCCEED))  /* No explicit rate control */
    {
        VerifyBitLoadingParameters();
    }
#endif

   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
   if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
   {
      //compute the required Interlever and Deinterleaver memory
      //ILV_Mem = (Nfec(cwsize)*Dp)/2 + Nfec(cwsize)*2
      gula_rxILVBaseAddr[LP0_DATA_PATH] = RETX_ZEP_DILV_LP0_BASE;
      gula_rxILVBaseAddr[LP1_DATA_PATH] = RETX_ZEP_DILV_LP1_BASE;

      //XDSLRTFW-1634 (Start)
      //Commeting out this code. Have written a new function InitReTxVars() to init ReTx related variabled.
      //InitReTxVars() is called in StartModemOperation() (file load_codeswap.c)
      #if 0
      {
         int32 i;

         memset(gta_QretxTable, 0, sizeof(QretxTableEntry_t)*QRETX_TRANS_TABLE_SIZE);
         for (i = 0; i < QRETX_TRANS_TABLE_SIZE; i++)
         {
            gta_QretxTable[i].uc_Stat = EMPTY_DTU;
         }
      }
      #endif
      //XDSLRTFW-1634 (End)
   }
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)


   //SMS00920128 SMS00864205 FEATURE_DS_BisPlus_ALL_EnableFractionalINP (Start)
   if (OPTNArray[OPTN_AlgControl3] & CMV_TO_ENABLE_FRACTIONAL_INP_FRAMEWORK)
   {
      if(gft_ErasureGainForRate == TRUE)
         gs_INP = gs_INP_no_erasure; // restore back the original value without erasure gain for data rate.

      if(gs_delta_INP)
         gs_INP -= gs_delta_INP;

       gs_INP = (gs_INP / gus_Scale_FractINP); //Restore back the INP to "0.5" granuality



   }
   //SMS00920128 SMS00864205 FEATURE_DS_BisPlus_ALL_EnableFractionalINP (End)

    gl_debug_bitloadend = gl_RxSymbolCount;
    gft_BitloadState = TRAINING_DONE;
}
/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*     FlagT Check_PMSConstr(int16 s_D, int16 s_R, int16 s_M, int16 s_T, int16 *ps_Bpn, int16 s_L, int16 s_max__latency)
*
*   Description:
*  This function checks if the PMS parameters satisfy all the constraints in terms of CWSize, Sp, latency and overhead rate
*
*
*  Input Arguments:
*     s_CWSize : CW size
*     s_L      : number of bits in a PMD frame
*     s_D      : interleave depth
*     s_R      : number of check bytes
*     s_M      : number of mux fdata frames Mp
*     s_T      : Tp
*     ps_Bpn   : number of octets in frame bearer number n
*     s_max_latency : Latency *4
*     s_p      : Latency path nyumber
*
*
*  Output Arguments:
*
*   Returns:
*     ft_BitloadOK flag = Succeed if all constraints are met, else False
*
*  Global Variables: gt_HandshakeBis
*
*-----------------------------------------------------------------------------
^^^*/
FlagT Check_PMSConstr(int16 s_D, int16 s_R, int16 s_M, int16 s_T, int16 *ps_Bpn, int16 s_L, int16 s_max_latency)
{
    int16  s_CWSize;
    int32 l_temp1, l_temp2;
    int16 ft_CWSizeOK=0, ft_MpOK=0, ft_TpOK=0;
    uint32 ul_temp1, ul_temp2;
    FlagT ft_BitloadOK;

    s_CWSize = (*ps_Bpn + *(ps_Bpn+1) +1 ) * s_M + s_R;
    ft_CWSizeOK = 0;

    /*   CWSize <= 255     (specifies max codeword size) &  CWSize <=  Lp /8(limits Sp <= 1)*/
    if ( (s_CWSize <gs_max_CWSize)&& (s_CWSize>0) &&  (s_CWSize * gs_OneOverSminADSL2 * 8 >= s_L ) && ( ((s_max_latency <=4) && ((s_CWSize << 3) <= s_L )) || (((s_CWSize <= (s_L << 3)) )  && (s_max_latency > 4) ) ))
    {
        /*  CWSize <= (4 * Lp * Latency_max) /(8* Dp)*/
        MULS16(l_temp1, s_CWSize, s_D);
        MULS16(l_temp2, s_L, s_max_latency);
        l_temp1 = (l_temp1 <<3);

        if (l_temp1 <= l_temp2)
        {
            /*Mp * Lp * 4/ (Tp * CWSize) >= Min_Ovhd_rate*/

            l_temp1 = (int32) gs_MinDSOverheadRate * (int32) (s_CWSize) * s_T;

            l_temp2 = (int32) ( (s_L * s_M ) << 2);

            if (l_temp1 <= l_temp2)
            ft_CWSizeOK = 1;
            if(ft_CWSizeOK ==1)
            {
                ft_MpOK = 0;
                ul_temp1 = (uint32) ((uint32) s_L *s_M);
                ul_temp2 = (ul_temp1 << 5);

                if ((ul_temp1 <= (uint32) (gs_OneOverSminADSL2*(s_CWSize << 3))) && (ul_temp2 >= (uint32) (s_CWSize << 3)))
                ft_MpOK =1;

                if(ft_MpOK ==1)
                {
                    ft_TpOK = 0;
                    MULU16(ul_temp1, s_L, (s_M<<2));

                    MULU16(ul_temp2, s_CWSize,  s_T);

                    ul_temp2 *= (uint32) gs_MinDSOverheadRate;

                    if (ul_temp1 >= ul_temp2)
                    {
                        ft_TpOK = 1;
                    }
                }
            }
        }
    }

    ft_BitloadOK = ft_CWSizeOK && ft_MpOK && ft_TpOK;

    return(ft_BitloadOK);
}
/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*  void CompRate(int16 *ps_Bpn, int16 s_T, int16 s_L, int16 s_mindatarate, int16 s_M, int16 s_R, int32 *pl_datarate, int32 *pl_temp_diff_datarate, int16 *ps_delta_Lp, int32 *pl_mindatarate, int32 *pl_maxdatarate)
*
*   Description:
*  This function computes datarate achieved with PMS settings, corresponding min and max rate numbers, as data rate is
*   taken to be (Tp Kp - 1 ) Mp Lp and compared against required rate * Tp * CWSize
*
*
*  Input Arguments:
*     s_CWSize : CW size
*     s_L      : number of bits in a PMD frame
*     s_D      : interleave depth
*     s_R      : number of check bytes
*     s_M      : number of mux fdata frames Mp
*     s_T      : Tp
*     ps_Bpn   : number of octets in frame bearer number n
*     s_max_latency : Latency *4
*     s_p      : Latency path nyumber
*
*
*  Output Arguments:
*     pl_datarate :  Achieved rate
*     pl_temp_diff_datarate: difference between achieved and desired, where desired is taken as min + 0.5 bit, if min = max
and max - 1  if min < max
ps_delta_Lp :  Estimate of deltaLp
pl_mindatarate : Corresponding min rate * Tp * CWSize
pl_maxdatarate : Corresponding max rate * Tp * CWSize
*   Returns:
*     Output arguments
*
*  Global Variables: uses gs_const_scale (for accuracy of computations)
*
*-----------------------------------------------------------------------------
^^^*/
void CompRate(int16 *ps_Bpn, int16 s_T, int16 s_L, int16 s_mindatarate, int16 s_M, int16 s_R, int32 *pl_datarate, int32 *pl_temp_diff_datarate, int16 *ps_delta_Lp, int32 *pl_mindatarate, int32 *pl_maxdatarate)
{
    int16 s_Kp, s_const_scale=16;
    int16 s_Temp;
    int32 l_temp1;

    // compute Kp, this would change if you have more latency paths/ bearer channels
    s_Kp = *ps_Bpn + (*(ps_Bpn+1)) + 1;

    /* data_rate = (Tp *Kp-1) * Mp * Lp/ Tp *(Kp*Mp + Rp)
    Here data rate is computed as (Tp *Kp-1) * Mp * Lp * Constant  (selected 16 to convert computations to 12.4
    min rate = required min rate * Tp * (Kp * Mp + Rp) * constant
    max rate = (required max rate + 1) * Tp * (Kp * Mp + Rp) * constant

    For min = max, we can goup by 1 bit
    */
    MULS16(l_temp1, s_T, s_Kp);

    *pl_datarate  = (int32)(((l_temp1-1)*s_M*((int32)(s_L<<4))));
    MULS16(l_temp1, s_Kp, s_M);
    s_Temp =(int16)(l_temp1) + s_R;
    MULS16(l_temp1, s_Temp, s_T);
    *pl_mindatarate = (int32)((s_mindatarate<<4))* (l_temp1);
    *pl_maxdatarate = (int32)((gs_maxdatarate+1)<<4)* (l_temp1);
    *pl_temp_diff_datarate = *pl_datarate - (int32)(s_mindatarate*s_const_scale+(s_const_scale>>1))* (l_temp1);
    *ps_delta_Lp  = (int16)((int32)(*pl_temp_diff_datarate)/(s_const_scale*(l_temp1)));
}
/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*  void load_BestSavedPMS(int16 *ps_D, int16 *ps_R, int16 *ps_M, int16 *ps_T, int16 *ps_L, int16 *ps_Bpn, int16 s_p, PMSBitload_t *pt_save_PMS)
*
*   Description:
*  This function loads the best saved PMS parameters
*
*
*  Input Arguments:
*
*     s_L      : number of bits in a PMD frame
*     s_D      : interleave depth
*     s_R      : number of check bytes
*     s_M      : number of mux fdata frames Mp
*     s_T      : Tp
*     ps_Bpn   : number of octets in frame bearer number n
*
*
*  Output Arguments:
*
*   Returns:
*
*  Global Variables:
*
*-----------------------------------------------------------------------------
^^^*/
void load_BestSavedPMS(int16 *ps_D, int16 *ps_R, int16 *ps_M, int16 *ps_T, int16 *ps_L, int16 *ps_Bpn, int16 s_p, PMSBitload_t *pt_save_PMS)
{
    *ps_D = pt_save_PMS->s_Dp[s_p];
    *ps_R = pt_save_PMS->s_Rp[s_p];
    *ps_M = pt_save_PMS->s_Mp[s_p];
    *ps_T = pt_save_PMS->s_Tp[s_p];
    *ps_L = pt_save_PMS->s_Lp[s_p];
    *ps_Bpn++ = pt_save_PMS->sa_Bpn[s_p][0];
    *ps_Bpn = pt_save_PMS->sa_Bpn[s_p][1];
}
/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*  void ComputeSumFGainLinSq(uint16 *pus_ncloaded)
*
*   Description:
Find sum fine gain linear square, assuming all the tones have minimum finegain
*
*   Returns:
*       SumFine Gain linear Square value
*
*  Global variables:
*  gs_min_fine_gain : Minimum fine gain
*
*-----------------------------------------------------------------------------
^^^*/
void ComputeSumFGainLinSq(uint16 *pus_ncloaded, int32 *pl_SumFGainLinSq, int32 *pl_SumGiSqTssiSq)
{
    int32 l_SumFineGaindB = 0, l_MaxSumFineGain =0, l_SumFGainLinSq;
    int32 l_GiSqTssiSq;
    int16   s_FGainLin,  s_GiTssi;
    int i;

    *pl_SumFGainLinSq = 0;
    // compute GiSqTssiSq
    *pl_SumGiSqTssiSq = 0;
    for (i=0; i<gs_RxNumTones; i++)
    {
        if (IS_TONEFLAGSET(p_MEDLEYset_DS,i))
        {
            // at this time all tones have fine gains = gs_min_fine_gain
            // and also there is no excess margin fgain reduction
            s_FGainLin = (DecimalGain(gsa_RxFineGains[i]) + (int16)(1<<3)) >> 4;
            l_SumFGainLinSq = (int32) s_FGainLin * s_FGainLin;
            if (guca_RxBat[i] >0)
            *pl_SumFGainLinSq = l_add(*pl_SumFGainLinSq, l_SumFGainLinSq);

            l_GiSqTssiSq = (int32) s_FGainLin * gusa_DS_Tssi_Value[i]; //3.19
            l_GiSqTssiSq = round(l_GiSqTssiSq,6);
            s_GiTssi = (int16) l_GiSqTssiSq;
            l_GiSqTssiSq = (int32) s_GiTssi * s_GiTssi;
            l_GiSqTssiSq = round(l_GiSqTssiSq, 9);
            *pl_SumGiSqTssiSq = l_add(*pl_SumGiSqTssiSq, l_GiSqTssiSq);
        }
    }

}
/*^^^
*-----------------------------------------------------------------------------
*   Prototype:
*       void DecideForRParams_TwoLatency(void);
*
*   Description:
*  This function is called following the MEDLEY based SNR
*   calculation for dual latency.  It will pick the DS PMS parameters at this time
*   based on its channel analysis result. LP1 is configured as fast path with min reserved rate.
*  Tones from left to right are allocated to LP1, ensuring Trellis overhead for LP1 is contained in tones
*  allocated to LP1
*
*  Input(s):
*
*  Output(s):
*
*     p_TonesAllocatedtoLP1_DS -- sets 1 bit per tone for tones allocated to LP1
*     gs_MaxToneForFast -- sets up last tone used in LP1 (as tones are allocated left to right)
*-----------------------------------------------------------------------------
^^^*/
void DecideForRParams_TwoLatency(void)
{
    int s_path, i;
    int16  s_Tcm_Oh = 0, s_bitstoreduce;
    int16 s_saveMinBits = 0, s_minbitsLP1, s_MaxToneLp1 = 0, s_CodingGain_in, s_Kp_LP1;
    int16 sumBi, s_actualbitsLp1, s_TotalBitsSupported;
    FlagT ft_FlagAnyToneLeft;
    int16 s_RxDesiredMargin;

    // check that LP1 has no INP requirement and is fast path, else flag failure
    if ((gt_HandshakeBis.sa_DS_MinINPBC[LP1_DATA_PATH] != 0) || ( gt_HandshakeBis.sa_DS_MaxLatencyBC[LP1_DATA_PATH] != 1))
    {
        // current support requires LP1 as fast path with no INP requirement

        gft_BitloadOK = FAIL;
        /* Set exception code */
        gus_BitloadExceptionCode = E_CODE_BITLOAD_NOTSUPPORTINPLAT_LP1;
        gus_ExceptionCode = E_CODE_BIT_LOADING_FAILURE;
        gs_InitFailCauseNearEnd = 2;
        return;

    }
    // Assign min Rate to LP1 path and rest to LP0 path
    for (s_path=1; s_path >=0; s_path--)
    {
        if(s_path == LP1_DATA_PATH)
        {
            // it is assumed that BC1 is mapped to LP1
            //If CO makes an illegal configuration, MinNetRate > ReservedRate, choose it to be
            // Max(MinNetRate, ReservedRate) of handsahke
            //as the minbitsLP1

            if (gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[1] < gt_HandshakeBis.sa_DS_MinNetDataRateBC[1])
            s_minbitsLP1 = ((gt_HandshakeBis.sa_DS_MinNetDataRateBC[1] +(1<<3) -1 )>> 3) << 3; // round up
            else
            s_minbitsLP1 = ((gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[1] +(1<<3) -1 )>> 3) << 3; // round up


            s_Kp_LP1 = (s_minbitsLP1 >> 3 ) + 1;

            // check that Kp is less than 255

            if (s_Kp_LP1 > gs_max_CWSize)
            {
                // can not configure LP1 as S=1 on LP1
                gft_BitloadOK = FAIL;
                /* Set exception code */
                gus_BitloadExceptionCode = E_CODE_BITLOAD_LP1_RATETOOHIGH;
                return;

            }

            s_minbitsLP1 = s_Kp_LP1 << 3;


            // do LP1 bitloading and mark tones used for LP1
            gft_BitloadOK = InitBitloading((int16)s_path);

            /* Compute SNR plus coding gain */
            gpsa_MeasuredSnrBuf = &gsa_RxShowtimeSnrBuf[0];


            // Adjust Constellation SNR if Trellis is on
            if ((gft_TcmFlag_bis_DS == TRUE) && (guc_Iridia_Revision_Number == IRIDIA_30))
            AdjustTcmCodingGains(0);

            s_RxDesiredMargin = gs_RxDesiredMargin - OPTNArray[OPTN_MarginDelta];
            OffsetSNRRequired(s_RxDesiredMargin , gsa_SNRRequired);


            //CodingGain for R & D (R=0, D=1)
            s_CodingGain_in =  GetCodingGain_BIS(0, 1);

            /* Add coding gain to SNRs */
            AddCodingGainToSnr(gsa_MedleySnrBuf,  s_CodingGain_in, gpsa_MeasuredSnrBuf, (int16)s_path);

            // reset the flag to add extra fine gain for forceeven1bit
            //             gft_extrafinegainallocated =0;

            /*Store coding gain in Q8.8 format*/
            gsa_TotalCodingGain[s_path] = s_CodingGain_in;

            // for latency path 1, force min bits to be 2.
            s_saveMinBits = gs_RxMinBitsPerTone_BIS_TCM;
            gs_RxMinBitsPerTone_BIS_TCM = 2;

            s_TotalBitsSupported = CalcMaxBits(gft_FineGainOn, guca_RxBat, gsa_RxFineGains, &gs_RxExtraBits, &gus_ncloaded, &gs_RxAvFineGain, 0x7FFF, (int16)s_path);

            // based on Lp1, decide how many tones would be used for LP1 path
            // go in physical order from left to right and keep tones till sum(bi) = Lp1

            if (s_minbitsLP1 > s_TotalBitsSupported)
            {
                // Fail to do LP1 min rate  allocation
                gft_BitloadOK = FAIL;
                /* Set exception code */
                gus_BitloadExceptionCode = E_CODE_BITLOAD_LP1_INSUFFICIENTCAPACITY;
                return;

            }


            sumBi = 0;
            s_actualbitsLp1 = 0;

            for (i=gs_RxBitLoadFirstChannel; i <= gs_RxNumTones ; i++)
            {


                if (guca_RxBat[i] > 0)
                {
                    SETTONEFLAG(p_TonesAllocatedtoLP1_DS, i);
                    sumBi += guca_RxBat[i] ;

                    gus_ncloaded_LP1 ++;
                }



                if (((gus_ncloaded_LP1 % 2) ==0) && (sumBi > s_minbitsLP1))
                {
                    // determine TCM overhead

                    s_Tcm_Oh = gus_ncloaded_LP1 >> 1;
                    s_actualbitsLp1 = sumBi - s_Tcm_Oh;
                }

                if (((gus_ncloaded_LP1 % 2) ==0) && (s_actualbitsLp1 >= s_minbitsLP1))
                {
                    s_MaxToneLp1 = i;
                    break;
                }
            }


            // save the TCM overhead for LP1 path, extra four bits which are allocated to LP0 only
            gs_Tcm_Oh_LP1 = s_Tcm_Oh ;


            s_bitstoreduce = s_actualbitsLp1 - s_minbitsLP1;
            gs_saveBitstoreduce = s_bitstoreduce;
            //  reduce these from the tones allocated to LP1 path

            // we need to trim bits to get the desired Lp
            ft_FlagAnyToneLeft = TRUE;
            while ((s_bitstoreduce !=0 ) && (ft_FlagAnyToneLeft))
            {
                // reset the flag
                ft_FlagAnyToneLeft = 0;


                for (i=s_MaxToneLp1; i >=gs_RxBitLoadFirstChannel; i--)
                {
                    if (guca_RxBat[i] <=2) continue;
                    // if there is any tone with more than min bits
                    ft_FlagAnyToneLeft = 1;

                    if (guca_RxBat[i] > 2)
                    {
                        guca_RxBat[i] -= 1;
                        s_bitstoreduce -=1;
                    }


                    if (s_bitstoreduce==0) break;
                }
            }

            if (s_bitstoreduce!=0)
            {
                // can't meet the rate on LP1 for S=1, fail
                gft_BitloadOK = FAIL;
                /* Set exception code */
                gus_BitloadExceptionCode  = E_CODE_BITLOAD_LP1FAIL;
                return;

            }


            gs_MaxToneForFast = s_MaxToneLp1 ;

            // Populate PMS TC structure
            gt_PMSParams.sa_Bpn[LP1_DATA_PATH][DS_AS1_BEARER_CHANNEL] = s_Kp_LP1 - 1 ;
            gt_PMSParams.s_Dp[LP1_DATA_PATH]=1;
            gt_PMSParams.s_Mp[LP1_DATA_PATH]=1;
            gt_PMSParams.s_Rp[LP1_DATA_PATH]=0;
            gt_PMSParams.s_Lp[LP1_DATA_PATH]=s_minbitsLP1 ;


        }



        // LP0 bitloading
        if (s_path ==LP0_DATA_PATH)
        {
            // reset gs_RxMinBitsPerTone_BIS_TCM back, as we allow LP0 to contain 1 bit tones
            gs_RxMinBitsPerTone_BIS_TCM = s_saveMinBits;

            // Assume BC0 is assigned to LP0
            gs_maxdatarate = gt_HandshakeBis.sa_DS_MaxNetDataRateBC[s_path];

            //take max datarate as minimum of maxratelp or max rate from bc
            if(gs_maxdatarate >= gt_HandshakeBis.sa_DS_MaxDataRateLP[s_path])
            gs_maxdatarate = gt_HandshakeBis.sa_DS_MaxDataRateLP[s_path];

            //If CO makes an illegal configuration, i.e, handshake MaxNetRate = MinNetRate > ReservedRate
            //We change the bitloading MinRate = handshake MinNetRate. Otherwise, we will follow the spec,
            //assuming handshake MaxNetRate >= ReservedRate >= MinNetRate.
            //So the code here basically is choosing the Max(MinNetRate, ReservedRate) of handsahke
            //as the bitloading MinRate
            if (gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[s_path] < gt_HandshakeBis.sa_DS_MinNetDataRateBC[s_path])
            gs_minnetdatarate = gt_HandshakeBis.sa_DS_MinNetDataRateBC[s_path];
            else
            gs_minnetdatarate = gt_HandshakeBis.sa_DS_ReservedNetDataRateBC[s_path];


            DecideForRParams_OneLatency((int16)s_path);

        }
    }
}
/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
        int16 CheckCoPrime(int16 s_D, int16 s_CWSize);
*
*   Description:
        Check if D and CW size are co_prime
        For D= 511, currently even codewords are ruled out.
*
*   Returns:
*      TRUE / FALSE
*
*
*-----------------------------------------------------------------------------
^^^*/
int16 CheckCoPrime(int16 s_D, int16 s_CWSize)
{
    int16 s_temp1, s_temp2, s_temp3, s_temp4;
    s_temp1 = s_D;
    s_temp2 = s_CWSize;
    // For D=511, though we can have even codewords, our firmware plus hardware would add extra dummy byte for even codeword,
    // ensure that for D=511 we work with odd codewords for the time being
    if ((s_D ==511) && (s_CWSize % 2 ==0)) return 0;
    while (s_temp2) // unless remainder = 0
    {
        s_temp3 = s_temp1 / s_temp2;
        s_temp4 = s_temp1 - s_temp2 * s_temp3;
        s_temp1 = s_temp2;
        s_temp2 = s_temp4;
    }

    // s_temp1 is gcd, if gcd is one return PASS, implying s_D and CW are co-prime
    if (s_temp1==1)
    return 1;
    else
    return 0;
}
/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
    void CompareFractions( FlagT ft_FindLarge, int16 s_beta_numer, int16 s_beta_denom, int16 *ps_result_numer, int16 *ps_result_denom);
*
*   Description:
        Compare two fractions : A/B and C/D
        unction can return larger or the smaller of the two.
*
*   Returns:
*      fraction which is larger or which is smaller
*
*
*-----------------------------------------------------------------------------
^^^*/
void CompareFractions(FlagT ft_FindLarge, int16 s_beta_numer, int16 s_beta_denom, int16 *ps_result_numer, int16 *ps_result_denom)
{
    // compare two fractions and return larger of the two
    uint32 ul_temp1, ul_temp2;
    int16 s_alpha_numer = *ps_result_numer;
    int16 s_alpha_denom= *ps_result_denom;
    MULS16(ul_temp1, s_alpha_numer, s_beta_denom);
    MULS16(ul_temp2, s_alpha_denom, s_beta_numer);

    if (ul_temp1 > ul_temp2)
    {
        if (ft_FindLarge ==1)
        {
            *ps_result_numer = s_beta_numer;
            *ps_result_denom =  s_beta_denom;
        }

    }
    else
    {
        if (ft_FindLarge ==0)
        {
            *ps_result_numer = s_alpha_numer;
            *ps_result_denom = s_alpha_denom;
        }
    }
    return;
}


//XDSLRTFW-1634 (Start)
//XDSLRTFW-1223 Qrx Full Fix (Start)
void InitReTxVars(void)
{
   int32 i;

   memset(gta_QretxTable, 0, sizeof(QretxTableEntry_t)*QRETX_TRANS_TABLE_SIZE);
   for (i = 0; i < QRETX_TRANS_TABLE_SIZE; i++)
   {
      gta_QretxTable[i].uc_Stat = EMPTY_DTU;
      gta_QretxTable[i].uc_DTU_idx = EMPTY_DTU;
   }

   guc_Prev_Rd_SID = 0;
   guc_Prev_Rd_DTU_idx = 0;
   guc_Prev_Rd_SID_idx = 0;

   guc_Wr_SID_idx = (QRETX_TRANS_TABLE_SIZE-1);
   guc_Rd_SID_idx = (QRETX_TRANS_TABLE_SIZE-1);
   guc_Curr_Wr_DTU_idx = 0;

   gta_QretxTable[guc_Wr_SID_idx].uc_SID = (SID_MODULO - 1);
   gta_QretxTable[guc_Rd_SID_idx].uc_SID = (SID_MODULO - 1);

   gft_Qrx_Full = FALSE;
   gus_dbg_QreTx_full_cntr = 0;
   gus_QFullCntr = 0;
   gus_DropPktCntr = 0;
   gus_BufOverWriteCntr = 0;

   #ifdef ENABLE_RETX_DS_DEBUG
   guc_ReTxDebugBufWrEnable = 1;
   gus_ReTxDebugBufIdx = 0;
   //memset(guca_ReTxDebugBuf,0,8*1024);
   #endif
}
//XDSLRTFW-1223 Qrx Full Fix (End)
//XDSLRTFW-1634 (End)
