/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   TSSI_RX.C
 *
 *   Description:   Routines used for generating the inverse DS tssi data then
 *    applying it to the DS signal for estimating the DS channel impulse response.
 *
 *------------------------------------------------------------------------
 */
#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "spectral_shape_bis.h"
#include "const.h"
#include "bitload_const.h"
#include "cmv.h"
#include "dsp_op.h"
#include "tssi_rx.h"

C_SCOPE void DefineSupportedSet(uint8 *p_SUPPORTEDset, int16 s_NumTones, int16 *psa_BreakFreq, FlagT *pfta_SupportSet, int16 s_NumBrkpts)
{
   int i,j, s_value1, s_value2, s_shift;
   int16 s_BkptToneIndex, s_NextBkptToneIndex;

   if (s_NumBrkpts > 0)
   {
      // Set SUPPORT bits for tones before first breakpoint
      for(i=0; i<=psa_BreakFreq[0]; i++)
         ORTONEFLAG(p_SUPPORTEDset, i, pfta_SupportSet[0] & 0x1);

      // Set SUPPORT bits for tones after last breakpoint
      s_value1 = s_NumBrkpts-1;
      s_shift = s_value1-((s_value1>>3)<<3);
      for(i=psa_BreakFreq[s_value1]; i< s_NumTones; i++)
         ORTONEFLAG(p_SUPPORTEDset, i, (pfta_SupportSet[s_value1>>3]>>s_shift) & 0x1);

      // Set SUPPORT bits for tones in between first and last breakpoints
      for(i=0; i < s_NumBrkpts-1; i++) {
         s_BkptToneIndex = psa_BreakFreq[i]; // This breakpoint
         s_NextBkptToneIndex = psa_BreakFreq[i+1]; // Next breakpoint
         // Set the bits for the two breakpoints
         s_shift = i-((i>>3)<<3);
         s_value1 = (pfta_SupportSet[i>>3]>>s_shift) & 0x1;
         s_shift++;
         if (s_shift == 8)
            s_shift = 0;
         s_value2 = (pfta_SupportSet[(i+1)>>3]>>s_shift) & 0x1;
         ORTONEFLAG(p_SUPPORTEDset, s_BkptToneIndex, s_value1);
         ORTONEFLAG(p_SUPPORTEDset, s_NextBkptToneIndex, s_value2);
         // Set the SUPPORT bit for all tones between the two breakpoints to the
         // logical AND of the SUPPORT bits of the two breakpoints.
         for (j=s_BkptToneIndex+1 ; j<s_NextBkptToneIndex ; j++)
            ORTONEFLAG(p_SUPPORTEDset, j, s_value1 & s_value2 & 0x1);
      }
   }
   else
   {
      // By default (if no tssi rcvd) all tones are supported
      for (i=0 ; i<s_NumTones ; i++)
         SETTONEFLAG(p_SUPPORTEDset, i);
   }

}
