/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*
*   tx_ops_bis.c
*
*
*
*-------------------------------------------------------------------------
*/
#include "common.h"
#include "const_bis.h"
#include "tx_ops2.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "typedef.h"
#include "crc16.h"
#include "dsp_op.h"



/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*  Description:
*  Generate Medley PN sequence of length s_Length (in bytes),
*  stored in puca_Buffer
*  Medley PN Sequence is defined as d[n] = d[n-18] (xor) d[n-23]
*  Return:
*     none
*
*
*-----------------------------------------------------------------------------
^^^*/
void Gen_PNMedley(uint8 *puca_Buffer, int16 s_Length, uint32 *pul_State) {

   uint32 ul_mm0, ul_mm2, ul_mm3;

   ul_mm0 = *pul_State;       /* ul_mm0 has bits y(-1) to y(-32) */
   for(; (s_Length>0); s_Length--)
   {
      ul_mm2 = ul_mm0 >> 14;  /* ul_mm2 has bits y(-11) to y(-18) in the lsb */
      ul_mm3 = ul_mm0 >> 9;      /* ul_mm3 has bits y(-16) to y(-23) in the lsb */
      ul_mm0 = ul_mm0 >> 8;      /* make room for the new state */
      ul_mm3 ^= ul_mm2;    /* y(n-18) (xor) y(n-23) */
      ul_mm3 &= 0xff;
      *puca_Buffer++ = (uint8) ul_mm3;
      ul_mm3 <<= 24;
      ul_mm0 |= ul_mm3;
   }
   *pul_State = ul_mm0;

}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : TxReverbSegueSetUp_Xcvr_Training_BIS
 *
 *  Description:
 *
 *    Fills global transmit buffer gsa_TxToneBuf with
 *    freq domain samples for sending either the R-Reverb or R-Segue signal
 *    during .
 *
 *    The precomputed freq domain samples are copied from a global array and
 *    are negated (180-degree phase shift) if a R-Segue signal is specified.
 *
 *  Prototype:
 *    void TxReverbSegueSetUp_Xcvr_Training_BIS(int16 s_ReverbOrSegue)
 *
 *  Input Arguments:
 *      int16 s_ReverbOrSegue    - ( = 0) transmit R_Reverb
 *                                 ( = 1) transmit R_Segue
 *
 *  Output Arguments:
 *    None
 *
 *  Return:
 *    None
 *
 *
 *  Global Variables Used:
 *      gsa_TxToneBuf[]   - (O) frequency domains samples
 *
 *------------------------------------------------------------------------
 *^^^
*/
void TxReverbSegueSetUp_Xcvr_Training_BIS(int16 s_ReverbOrSegue)
{
   int i;

   if (s_ReverbOrSegue == R_REVERB)
   {
      for (i=0 ; i<TX_FFT_LENGTH ; i++)
         gsa_TxToneBuf[i] = gsa_RReverbTones[i];
   }
   else
   {
      for (i=0 ; i<TX_FFT_LENGTH ; i++)
         gsa_TxToneBuf[i] = -gsa_RReverbTones[i];
   }
}









