/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   gdata_bis.c
*
*  This file contains global variable declarations for bis
*
*-------------------------------------------------------------------------
*/
// ******************************************************************
// gdata_bis.c
//
// History
//
// 22/07/2010 Nihar : Reducing Tx power by 3 dB (in DELT mode)
//               when measured PGA in C-COMB1 is above 21 dB
//               Reduction of TX power by 3dB for loops up to 3kft when DELT is used
//               Grep for IOP_DS_BisPlus_CNXT_ReduceTxPwrDELT
//
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 05/10/2011 Kannan/Vinjam : Relocated "gt_ADSL_TcMode_Reprt" structure (pointed by CMV DSL 14) from "Bis" to "Bulk Memory" data overlay section
// Grep for XDSLRTFW-340 BugFix_DS_DMT_ALL_SelectedTcModeAfterG.Hs
//
//14/03/2012 Kannan: 08/04/2009 Bhadra: Added code for uinversal ReTx C-Msg1 related changes
//                   Increased "guca_R_C_Msgs1_bis size".by 10 bytes
//                     Grep for SMS01436310 : FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod to see changes.
//
//14/03/2012 Kannan: 08/04/2009 Bhadra: Added code for uinversal ReTx R-Msg1 related changes
//                   Increased guca_RMsgs1Tab_bis   by 1 byte
//                     Grep for SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod to see changes.
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//16/07/2012 Anantha: removed unused variables  for implementation of LCD and NCD defect
// ******************************************************************
#include <stdio.h>
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "pga_set.h"
#include "ifft_fix.h"
#include "aoc.h"
#include "typedef.h"
#include "typedef_bis.h"
#include "bert.h"
#include "compiler.h"
#include "eoc.h"
#include "ib.h"
#include "const.h"
#include "const_bis.h"
#include "ovhd_bis.h"
#include "rx_ovrhd_bis.h"
#include "data_alloc.h"
#include "spectral_shape_bis.h"
#include "data_alloc.h"

#if !defined(DANUBE) && !defined(ADSL_62)
BSS_DEILV2_BIS
#endif

uint16* gpusa_CLR_USTssiIndex;
uint8* gpuca_CLR_USTssiValue;
uint8* gpfta_CLR_USTssiSi;

uint16* gpusa_CL_USTssiIndex;
uint8* gpuca_CL_USTssiValue;
uint8* gpfta_CL_USTssiSi;

#ifndef BIS_CODESWAP
uint16 gusa_CLR_USTssiIndex[MAX_NUM_US_TSSI_VALUES*(NUM_G992_3_ANNEX_SUPPORTED+NUM_G992_5_ANNEX_SUPPORTED)];
uint8 guca_CLR_USTssiValue[MAX_NUM_US_TSSI_VALUES*(NUM_G992_3_ANNEX_SUPPORTED+NUM_G992_5_ANNEX_SUPPORTED)];
uint8 gfta_CLR_USTssiSi[MAX_NUM_US_TSSI_VALUES*(NUM_G992_3_ANNEX_SUPPORTED+NUM_G992_5_ANNEX_SUPPORTED)/8];

uint16 gusa_CL_USTssiIndex[MAX_NUM_US_TSSI_VALUES*(NUM_G992_3_ANNEX_SUPPORTED+NUM_G992_5_ANNEX_SUPPORTED)];
uint8 guca_CL_USTssiValue[MAX_NUM_US_TSSI_VALUES*(NUM_G992_3_ANNEX_SUPPORTED+NUM_G992_5_ANNEX_SUPPORTED)];
uint8 gfta_CL_USTssiSi[MAX_NUM_US_TSSI_VALUES*(NUM_G992_3_ANNEX_SUPPORTED+NUM_G992_5_ANNEX_SUPPORTED)/8];
#endif

// Number of DS Tssi breakpoints sent in CL msg
int16 gsa_num_DS_Tssi_brkpt[2];
// Number of DS Tssi breakpoints kept from CL msg
int16 gsa_num_DS_Tssi_brkpt_kept[2];
// Number of US Tssi breakpoints sent in CL msg
int16 gsa_num_US_Tssi_brkpt[2];
// Number of US Tssi breakpoints kept from CL msg
int16 gsa_num_US_Tssi_brkpt_kept[2];
// Number of US Tssi breakpoints being sent in CLR msg
int16 gsa_num_USTssi_Xmitted[2];

#if defined(DANUBE) || defined(ADSL_62)
BSS_DEILV2_BIS
#endif

int16 gsa_Inspected_COMB_Subcarriers[NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2PLUS];

int16 gsa_CombToneDetCnt[NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2];
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End): memory allocation for p_QLN struct
//uint8 guca_RxBat_Before_BS[RX_NUM_TONES];


/* For R-MEDLEY */
uint8 guca_MedleyBuffer[NUM_R_MEDLEY_BYTES];  // guca_RxMedleyBuffer[NUM_R_C_MEDLEY_BYTES], guca_RxMedleyBuffer_sav[NUM_R_C_MEDLEY_BYTES];

int16 gsa_COMB_ICOMB_DetectionBins[NUM_OF_BINS_FOR_COMB_DETECTION];
int16 gsa_COMB_ICOMB_DetectionBins_BTLL[NUM_OF_BINS_FOR_COMB_DETECTION];


uint8 guca_Tones_RParams[TX_NUM_TONES-6];  // array for carriers used for R-PARAMS

FlagT gft_DisableExtendedFrame;  //Internal flag to indicate whether or not to Disable the new info of extended frame parameters
FlagT gft_GHS_S0min_Negotiated; //Flag indicate whether or not both CLR and CL contains the extended frame parameter in GHS

uint8 guca_RMsgPCBTab[LEN_R_MSGPCB_WITHOUT_CRC];

//XDSLRTFW-438 : During integration of Downstream Virtual Noise feature, build failed due to exceeding memory limit of "BSS_DEILV2_BIS"
//As temporary workaround, this buffer is moved to "Vr9_1port_debug_data.c" file (valid for single port ADSL2 mode)
//Pending: Resolve memory crunch due to increased size of guca_RCMsgPCBTab[ ].
//uint8 guca_RCMsgPCBTab[LEN_C_MSGPCB]; //size of this array increased to store virtual noise break points also - XDSLRTFW-438

BSS_MAP_END//BSS_DEILV2_BIS

DATA_MAP_BIS
// Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting (Start)
ReportErasure_t gt_ErasureDecoding_Reprt;
// Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting (End)

//XDSLRTFW-340 BugFix_DS_DMT_ALL_SelectedTcModeAfterG.Hs (Start)
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
//Report_Hsk_TCMode_t gt_ADSL_TcMode_Reprt;
//XDSLRTFW-340 BugFix_DS_DMT_ALL_SelectedTcModeAfterG.Hs (End)


//saved rates of L0 state. Will be used after L2 exist and back to L0.
int32 gla_save_DSDataRate[2];
int16 gsa_save_DSOvhdRate[2];
//saved ACTATPds of L0 state, the L2 ACTATP will be updated by gs_DS_ACTATP_L0 - PCBdiff_of_L2_L0
int16 gs_DS_ACTATP_L0;

int16 gs_total_extrabitsNeeded; //extra bits needed for showtime AZRun preprocessing

//uint32 gul_Preamble_CMSG1;

uint8 guca_RCMsgFMTTab[LEN_C_MSGFMT];

uint8 guca_RMsgFMTTab[LEN_R_MSGFMT_WITHOUT_CRC];

/* bis showtime variables */
int16 gs_TxPMDFrameCnt, gs_RxPMDFrameCnt;

/* TX */
#ifndef HERCULES_ADSL_CPE
int16 gs_maxAZRunCnt, gsa_num_preproc_frames[NUM_DATA_PATHS];
int16 gs_AZRunCnt, gs_dbgFciAaiMaxMipsTx;
#endif
int16 gs_dbgTCAMaxMipsTx=0;
// For faster Tx Data Pump processing -- AZ Run Count Mechanism
int16 gsa_TxMuxFrameSize[NUM_DATA_PATHS][2];
#ifndef HERCULES_ADSL_CPE
int16 gsa_TxMuxFrameCount[NUM_DATA_PATHS];
int16 gsa_ItSizeRegValue[MAX_AZ_RUNS];
uint16 gusa_ACfgRegValue[MAX_AZ_RUNS], gusa_ZtLineRegValue[MAX_AZ_RUNS];
#endif
uint16 gusa_PreconfigACfgTx[NUM_DATA_PATHS];
// For faster Tx Data Pump processing -- Tx Ovhd Msg Processing
#ifndef HERCULES_ADSL_CPE
uint16 gus_ZtLineRegMask;
#endif
uint16 gus_TxIbInfoL=0xFFFF, gus_TxIbInfoH=0xFFFF;
uint8 guc_tx_ovhd_byte;

/* RX */
int16 gs_ZARunTimes, gs_dbgTCAEndMips, gs_dbgTCAMaxMips=0, gs_dbgFciMaxMips=0, gs_dbgAaiMaxMips=0;
// For faster Rx Data Pump processing -- ZA Run Count Mechanism
int16 gsa_NBytes_In_RateBuffer[NUM_DATA_PATHS], gsa_RxMuxFrameCount[NUM_DATA_PATHS], gsa_RxMuxFrameSize[NUM_DATA_PATHS][2];
uint16 gus_IrSizeRegValue, gus_ZrLineRegMask, gus_ACfgRegMask;
uint16 gusa_PreconfigIRSize[NUM_DATA_PATHS], gusa_PreconfigACfg[NUM_DATA_PATHS];
FlagT gft_fdqTCDone;
// For faster Rx Data Pump processing -- Rx Ovhd Msg Processing
uint16 gusa_FramingByteBuffer[MAX_ZA_RUNS*3];
uint16 *gpusa_FramingByteBufferWPtr=gusa_FramingByteBuffer;

int16 gsa_DSOvhdRate[NUM_DATA_PATHS];
int16 gsa_USOvhdRate[NUM_DATA_PATHS];



// HDLC ovhd msg variables
int16 gsa_COReq_OvhdMsgSegIndx[3];  //CO requested segmented ovhd msg index
int16 gsa_RTXmit_OvhdMsgSegIndx[3]; //RT xmitted segmented ovhd msg index
int16 gs_OvhdMsgFirstTone;    //First tone for each ovhd msg segment
int16 gs_MaxTonePerOvhdMsg;      //Maximum # of tones that could be held in one ovhd msg
FlagT gfta_FirstOvhdMsgSeg[3];      //Flag indicate whether we are forming the first ovhd msg segment

/* bis training variables */
FlagT gft_BIS_TX_transition;
FlagT gft_goto_RReverb3_Flag;

TxToneFlags gp_BlackoutBits_US;

/* ======================================================================== */
/*  Received R_C_MSG_FMT information                                        */
/* ======================================================================== */

CMsgFmt_Bis_t gt_RCMsgFmt_bis;

/* ======================================================================== */
/*  Received R_C_MSG_PCB information                                        */
/* ======================================================================== */

CMsgPcb_Bis_t gt_RCMsgPcb_bis;

/* ======================================================================== */
/*  Structure for R_MSG_FMT                                                 */
/* ======================================================================== */

RMsgFmt_Bis_t gt_RMsgFmt_bis ;

uint8 guc_RT_FMT_R_REVERB1;
uint8 guc_RT_FMT_C_REVERB4;
uint8 guc_RT_FMT_C_TREF1_DURATION;
uint8 guc_RT_FMT_C_PILOT;

// Actual aggregate transmit power
uint8 guc_ACTATP_LSB;
uint8 guc_ACTATP_MSB;

// Loop Attenuation
uint8 guc_LoopAtten_LSB;
uint8 guc_LoopAtten_MSB;

// Signal Attenuation
uint8 guc_SigAtten_LSB;
uint8 guc_SigAtten_MSB;

/* ======================================================================== */
/*  Structure for R_MSG_PCB                                                 */
/* ======================================================================== */

RMsgPcb_Bis_t gt_RMsgPcb_bis ;      // Pilot tone

int16 gs_PCB_DS_Delta_bis;             // Used to adjust the DS PCB value.

int16 gs_COMB1_REFERENCE_POWER;
int16 gs_PGA_required_saved;
int16 gs_COMB2_REFERENCE_POWER;
int16 gs_COMB_counter, gs_ICOMB_counter;
int16 gs_NumCombSubcarriersInspected;  // Used for Quiet vs. Comb detections, not Comb vs. Icomb detections.
int16 gs_NumCombSubcarriersRequired;    // Used for Quiet vs. Comb detections, not Comb vs. Icomb detections.
int16 gs_ChanDiscDetCnt;
int16 gs_R_C_COMB1_AC_LEN_BIS;
int16 gs_LOG_R_C_COMB1_AC_LEN_BIS;



int16 gs_ChosenPilot_CD;       //the pilot tone used in RC-MSG-FMT/PCB states
int16 gs_ChosenPilot_preSNR;   //the pilot tone used in RC-COMB2 before SNR computatio
int16 gs_PllScaling_bis_CD;    // This variable is used to scale Ki Kp during channel discovery phase if tone 64 is not chosen as pilot */
int16 gs_PllScaling_bis_preSNR;

int16  gs_C_COMB_FIRSTCHAN_IDX;
int16  gs_C_COMB_LASTCHAN_IDX;

uint8 guc_NUM_OF_BINS_FOR_COMB_DETECTION;
uint8 guc_NUM_OF_BINS_FOR_COMB_DETECTION_BTLL;

int16 gs_THRESHOLD_FOR_QUALIFIED_COMBTONES;
int16 gs_hskPowerThresh4000m = 0x1D00; //Adj based on SK measurement in dtag. Was 0x1800


int16 gs_RCReverb4_rx_len_bis ;
int16 gs_RxCrcSubstateCnt;

FlagT gft_DS_Windowing = FALSE;

int16 gus_TxGainCutBackFactor_Bis;

/*Absolute nonlinear echo power threshold:
If nonlinear echo power is less than this threshold,
it assumes nonlinear distortion has no effect to normal phone operation */

int16 gs_NLEchoThresh_bis;

/*Nonlinear echo power difference threshold in percentage, represented by mantissa and exponent as:
A = (gs_NLEchoDiffThresh>>gs_NLEchoDiffThresh_rsh) (e.g., 1/8 as given in this setting)
If the percentage of decrease between previous and current
nonlinear echo power level is less than A, it indicates further TX power
cutback may not significantly reduce nonlinear echo */

int16 gs_NLEchoDiffThresh_bis;
int16 gs_NLEchoDiffThresh_rsh_bis;



/* ======================================================================== */
/*  Structure for R_MSG1 */
/* ======================================================================== */
CONSTANT uint8 guca_PreAmbleField_bis[(R_MSG1_PRFX_LEN_BIS>>3)] = {
    0x55, 0x55, 0x55, 0x55
};

RMsgs1_Bis_t gt_RMsgs1_bis ;
uint8 guc_R_C_MEDLEY_LENGTH_DIV_512; /* regular length of C_medley as a multiple of 512. */
uint8 guc_R_C_MEDLEY_LENGTH_DIV_512_DEBUG;  /* short length of C_medley as a multiple of 512. */

CMsgs1_Bis_t gt_RCMsgs1_bis;

int16 gs_RCReverb3Len_Min;


//int16 gs_ClippingIdx;

/* The histogram of Bis medley has much heavier tail compared to that of DMT Medly. Using the current clippinp threshold(5.4) */
/* at CO side, the following 23 frames will be clipped during IFFT operation. CPE should skip them to get the right medley SNR estimation */
//int16 gsa_BisMedleyClippedFrames[23] = { 658,  3046,  3185,  3496,  3906,  3946,  4280,  4322,
//                               5248,  6420,  6625,  6833, 10494, 11897, 12390, 13131,
//                            15675, 17042, 18304, 19430, 19917, 20330, 20664};


uint8 guca_R_C_PARAMS_bis[LEN_C_PARAMS_MESSAGE_BYTES+1];

int16 gs_BytePosition;
uint8 gus_BitPosition;
int16 gs_R_Params_Frame_Len;

uint8 guca_R_PARAMS_bis_sav[12];

PMSBitload_t gt_PMSParams;

int16 gs_CheckBytes;

int16 gs_MinDSOverheadRate; // MIn DS overhead, computed in bitload_bis
int16 gs_CodingGainForATTNDR; // The coding gain that gives max ATTNDR during initial bitloading.

int16 gs_max_CWSize; // Max CW Size limit to be used becasue of max interleaver limit

int16 gs_supportedDvalues[21] = {511, 480, 448, 416,384,352, 320, 288, 256, 224, 192, 160, 128,96, 64, 32, 16, 8, 4, 2, 1};
//int16 gs_supportedDvalues[21] = {64, 32, 16, 8, 4, 2, 1}; // supported D values


// Attainable Net Data Rate (ATTNDR).  Exchanged in Params message and upon request in showtime.
// gl_ATTNDRds_Initial is rate based on Medley SNRs. gl_ATTNDRds is rate based on showtime SNRs and is updated
// periodically in showtime.
int32 gl_ATTNDRds_Initial;

// These quantities are used to update the estimate pf ATTNDR during showtime.
int32 gl_ATTNDRds_Estimate_Initial;// Estimate of Total Data Rate based on Medley SNR, coding gain for actual max rate.
int32 gl_ATTNDRds_Estimate_Updated;// Estimate of Total Data Rate based on Showtime SNR, coding gain for actual max rate.

/* Received R_C_PARAMS information */

uint8 guc_CrcCalcState ;   /*  CRC computation status for received C_PARAMS messages */
int32 gul_RxDescrambleState;
int16 gs_C_PCB_Frame_Len;
int16 gs_C_Params_Frame_Len;
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//FEATURE_BisPlus_ALL_CPARAMS_INP_FLAG_Modifications (Start_End)
int16 gs_C_Params_Frame_Complte_Len;
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

FlagT gft_DecodeCParamsOK;

uint8 guc_US_lowest_latency_LP;

/* For OLR and PM */
TxOLRVars_t    gt_TxOLRVars;
RxOLRPMVars_t  gt_RxOLRPMVars;
int16       gs_TxSyncToneType;   /* Specifies the Tx sync tone type i.e. Reverb(0) or Segue(1) */

FlagT gft_debug_AbortOLR=0;  // Downstream bitswap abortcount

FlagT  gft_extrafinegainallocated; // flag to allocate extra fine gain as soon as we can to take care of
// forceeven1 changes
int16 gs_finegainadjust_bis;  // fine gain adjustment to avoid clipping

int16 gs_HLogReportDelta;     // adjustment of HLOG reporting (for calibration via CMV) in 1/10th of dB

FlagT gft_SkipCparams ;

// Array to store Tx Reverb tones.  This array is pre-stored because it may not be easy to generate it
// in one DMT frame time.  The contents of this array are initialized during the Channel Discovery phase
// once the US blackout bits are received from the CO.  The array is updated just before entering
// Channel Analysis.   If the HW Reverb generator is used during Channel Analysis and Exchange, this array
// should not be needed beyond Transceiver Training.
int16 gsa_RReverbTones[TX_FFT_LENGTH];

/* ====================================================================*/
/* SEQp holds the number of ovhd bytes transmitted in pth latency path */
/* ====================================================================*/
int16 gsa_tx_SEQp[NUM_DATA_PATHS];
int16 gsa_rx_SEQp[NUM_DATA_PATHS];

/* ===================================================*/
/* global variable declarations for Tx overhead bytes */
/* ===================================================*/
HDLCMsgStruct_t gt_TxHDLCMsg;
MessageOvhdFifo_t gt_TxHDLCMsgFifo;
//uint8 guca_TxHDLCMsgBuffer[MAX_TX_HDLC_MSG_SIZE];
uint8 *guca_TxHDLCMsgBuffer;
uint8 guca_tx_clear_eoc_buff[CLEAR_EOC_DATA_SIZE];

/* Global variables to be used in the HDLC ovhd msg transmitting*/
FlagT gft_Start_Transmit_HDLC;

/* ===================================================*/
/* global variable declarations for Rx overhead bytes */
/* ===================================================*/
MessageOvhdFifo_t gt_RxHDLCMsgFifo;
uint8 guc_HDLC_RxState ;
//uint8 guca_RxHDLCMsgBuffer[MAX_RX_HDLC_MSG_SIZE];
uint8 *guca_RxHDLCMsgBuffer;

// test parameter
// comment out temporarily because we haven't had the code ready yet

MeasurementPeriod_t gt_US_MeasurementPeriod;


int16 gs_nearend_ActualAggregateXmtPwr;

uint8 guc_param_rd_carrier_index ;

FlagT gft_TxBpnReconfigAllowed[NUM_DATA_PATHS];
FlagT gft_RxBpnReconfigAllowed[NUM_DATA_PATHS];

OvhdRegStruct_t gt_TxOvhdRegister;
OvhdRegStruct_t gt_RxOvhdRegister;

TxOvhdMsgInfoStruct_t gta_TxOvhdMessage[MAX_OVHD_PRIORITY][4] = {0}; // HDLC Tx queue

TxHdlcControl_t gta_TxHdlcControlInfo[MAX_OVHD_PRIORITY];      // HDLC tx queue control

TxOvhdMsgInfoRequest_t gt_OlrPm_TxOvhdMsgInfoInput;            // this is used to pass msg info from

// this structure is used as a general indication of when to send a new message in the queue during the special case
// of waiting for Inverted Sync Symbol for a response(L2 grant) and waiting for Segmented ACK for a segmented message.
HDLCInfo_t gt_HDLCInfo;
// OLR decision/PM to TC task.
uint16 gus_num_ovhd_timer_timeout[MAX_OVHD_PRIORITY];
TxIb_AnamolyStruct_t gt_tx_Anomaly;
RxIb_AnamolyStruct_t gt_rx_Anomaly;

// Total count for ATM anomalies/defects
uint32 gula_NE_ocd_cnt;             // total near end ocd anomaly count
uint32 gula_NE_lcd_cnt;             // total near end lcd defect count
uint32 gula_NE_ncd_cnt;             // total near end ncd anomaly count
uint32 gula_FE_ocd_cnt;             // total far end ocd anomaly count
uint32 gula_FE_lcd_cnt;             // total far end lcd defect count
uint32 gula_FE_ncd_cnt;             // total far end ncd anomaly count

int32 gl_self_test_result;

/* For TCM support */
/* In BIS we can enable TCM independently for US and DS */
FlagT gft_TcmFlag_bis_US;
FlagT gft_TcmFlag_bis_DS;

int16 gs_RxMinBitsPerTone_BIS_TCM = 1;

uint8 *guca_R_PARAMS_bis;

// global variables used for BIS ovhd update test paramter
FlagT gft_UpdateTestPar;
uint16 gus_10sec_Timer;
int16 gs_RxSNRM_ovhd;
int16* gpsa_RxSnrBuf_ovhd;

int16 gs_RxEstimatedMinMargin;  //estimated Min margin during OLR/PM

uint8 guc_PM_L3_InternalState;   //Global variable for PM L3 State Machine
uint8 guc_PM_L3_Response;     //Global variable for PM L3 State Machine
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
// US tssi values in linear format
uint16 gusa_US_Tssi_Value[TX_NUM_TONES];
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

DATA_MAP_END  //BIS Bulk Memory

// ****************************************************************
// Put the following data into interleave buffer
// ****************************************************************

DATA_MAP_deILV3_BIS

/* ======================================================================== */
/*  guca_RMsg1(2)Tab_BIS[] contains the R_MSG1(2) data */
/* ======================================================================== */
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod start
#ifdef UNV_RETX_MSGS
uint8 guca_RMsgs1Tab_bis[R_MSG1_RETX_NUM_BYTES_BIS];
#else
uint8 guca_RMsgs1Tab_bis[R_MSG1_NUM_BYTES_BIS];
#endif
//SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

uint8 guca_RMsgs2Tab_bis[R_MSG2_NUM_BYTES_PLUS];


DATA_MAP_END//DATA_MAP_deILV3_BIS

// DS tssi values in linear format, has to be in bulk
//uint16 *gusa_DS_Tssi_Value;//[RX_NUM_TONES];

DATA_BULKO1_BEGIN
uint16 gusa_DS_Tssi_Value[RX_NUM_TONES];                 // DS TSSI Array

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad (Start)
RxToneFlags p_PARRTONEset;

int16    gs_TCM_ovhd_Lp0;
int16    gs_bits_Lp0;
int16    gs_TCM_ovhd_Lp0_ReTx;
int16    gs_bits_Lp0_ReTx;
int16    gs_ncloaded_Lp0_ReTx;
uint16   gus_ncloaded_Lp1_ReTx;
int16    gs_ncloaded_Lp0;
uint16   gus_ncloaded_ReTx;
int16    gs_TCM_ovhd_Lp1_ReTx;
int16    gs_Tcm_Oh_LP1;
int16    gs_TotalBitsSupported_ReTx;
int16    gs_RxExtraBits_ReTx;
uint16   gus_Lp1Available_ReTx1;
uint16   gus_Lp1Available_ReTx2;
int16    gs_RxAvFineGain_ReTx;
int16    gs_MaxToneForFast_ReTx_ST;   /* Number of tones whose bits are allocated in ReTx Showtime */
uint16   gus_S;
//FEATURE_DS_BisPlus_ALL_ReTx_Modified_HEC_Error_Count Begin
uint16   gus_A;
//FEATURE_DS_BisPlus_ALL_ReTx_Modified_HEC_Error_Count End
FlagT    gft_change_lp0;
FlagT    gft_Bitswap_UreTX;
//SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad (End)
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

DATA_MAP_END//DATA_BULKO1_BEGIN

//Global variables that for inband notch profile of CO
FlagT gft_NotchPresent;
int16 gs_PcbDsDeltaForNotch;
FlagT gft_StrongNoisePresent;

DATA_MAP_deILV2_BIS
int16 gs_ChanDiscDetectMin;

/* ======================================================================== */
/*  Received R_C_MSGS1 and R_C_MSG2 information */
/* ======================================================================== */
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01436310 :  FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod Start
#ifdef UNV_RETX_MSGS
uint8 guca_R_C_Msgs1_bis[R_C_MSG1_RETX_NUM_BYTES_BIS];
#else
uint8 guca_R_C_Msgs1_bis[R_C_MSG1_NUM_BYTES_BIS];
#endif
//SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

uint8 guca_R_C_Msgs2_bis[R_C_MSG2_NUM_BYTES_BIS];

CONSTANT int16 gsa_C_COMB_index[C_COMB_INDEX_CNT_G992_5] = {
    11, 23, 35, 47, 59, 64, 71, 83, 95, 107,
    119, 143, 179, 203, 227, 251, 275, 299,
    323, 347, 371, 395, 419, 443,  467, 491
};

CONSTANT int16 gsa_tref1_candidates[20]= {
    48,  64,  80,  96,  112, 144, 176, 208, 224, 256,
    272, 304, 320, 352, 368, 400, 416, 448, 464, 496
};

//used for Conexant DSLAM D series workaround
CONSTANT uint16 gusa_CL_RcvdCnt[6] = {0};

int16 gs_Num_MsgBytes;  /* represents the number of message bytes */

/* Length of R_C_REVERB1_RX */
int16 gs_R_C_REVERB1_RX_LEN_BIS;

/* Length of C-TREF1 */
int16 gs_R_C_TREF1_RX_LEN_BIS;

uint32 gul_MedleyState;  // gul_RxMedleyState;

uint32 gul_RxMedleyState;

/* Changed its type bcause index of tones is less than 256 */
uint16 gusa_Tones_RMsg2[NSC_C_PARAMS];  // Carriers used for C-PARAMS

/* number of tones to use in R_PARAMS */
int16 gs_NSC_RParams;
uint8 guc_FormRParamsState  ;    /* status for BG task of packing R_PARAMS messages */

/* ===================================================*/

//int16 gsa_Comb2SignalBuf[RX_NUM_TONES]; //array to store comb2 signal
int16 *gsa_Comb2SignalBuf; //array to store comb2 signal

/* The following variables for diagnostics mode are used */
/* in R-MSG-PCB and C-MSG-PCB states. So keep them in gdata_bis.c */
uint8 guc_CO_PassFail;
uint8 guc_CO_Last_TX_State;
uint8 guc_RT_PassFail;
uint8 guc_RT_Last_TX_State;

// Pseudorandom bit sequence used for g.992.5 downstream Medley.
// Generated by the rules:
// d_n = 1,                                  for n=1 to 14
// d_n = d_{n-5} XOR d_{n-11} XOR d_{n-12} XOR d_{n-14}  for n>14
// The least significant bit (LSB) of the first 16-bit value in the array is d_0, the most significant bit (MSB) is d_15.
// The LSB of the second 16-bit value is d_16, the MSB is d_31, and so on.
//
CONSTANT uint16 gusa_14Order_PN1024Tab[64] = {
    0x3FFF, 0x12F8, 0xD584, 0x1B6F, 0x1D15, 0x7D9F, 0xFCFD, 0x3608,
    0x55D4, 0xD30C, 0x4D51, 0x91A2, 0xD84D, 0xBC8E, 0x2218, 0x59D3,
    0x24AC, 0x4240, 0x6B6E, 0x3C5B, 0x23F6, 0x8CF9, 0xCB67, 0xF18D,
    0x15C9, 0x2CC2, 0x2F7F, 0x0A96, 0xB579, 0x6534, 0x5F5B, 0x7292,
    0xCEF7, 0xCEBC, 0x7C28, 0x37E6, 0x80FE, 0x3CC7, 0xFE9C, 0xEF05,
    0xC8D4, 0xB007, 0xA477, 0x27CD, 0xB015, 0x08D2, 0x353E, 0xDDD3,
    0xE7DC, 0x45A8, 0x99B5, 0x2E28, 0x5B9C, 0x1CA9, 0x0EC6, 0xBE6A,
    0x3298, 0x41BD, 0x4451, 0x3C1B, 0x2920, 0x3356, 0x11FC, 0x744D,
};

FlagT gft_G992_5_Medley14thOrderPRBS = 0;

uint8 guca_RxMedleyBuffer[NUM_R_C_MEDLEY_BYTES], guca_RxMedleyBuffer_sav[NUM_R_C_MEDLEY_BYTES];

#if defined(DANUBE) || defined(ADSL_62)
DATA_MAP_END//DATA_MAP_deILV2_BIS
#endif

//Global variables that for inband notch profile of CO
int16 gs_tssi_DeepNotchthreshold;
int16 gs_tssi_ShallowNotchthreshold;
int16 gs_tssi_threshold;

int16 gs_avg_first_channel, gs_avg_last_channel, gs_avg_num_channels;
FlagT gft_dbgDisableTimeout;

#if !defined(DANUBE) && !defined(ADSL_62)
DATA_MAP_END//DATA_MAP_deILV2_BIS

DATA_MAP_deILV3_BIS
#endif

// Flags here for GHS to Init codeswap transition purpose
uint8 gft_enterTraining;       // Flag indicate that we have got valid BIS mode and we are ready to codeswap new pages

int16 gs_tssiMaskCeil=1;
/* Should include indexes 0 and gs_RxNumTones(512) and should be non-decreasing */
int16 gsa_DsMaskCeilLogTssiBrkptIndx[4]={0,255,376,511};
/* Positive value is relative to NOMPSD */
int16 gsa_DsMaskCeilLogTssiBrkptVal[4]={0,0,5120, 5786}; /* log tssi (0, 63.5)dB in Q7.9 format */

#if !defined(DANUBE) && !defined(ADSL_62)
DATA_MAP_END//DATA_MAP_deILV3_BIS
#endif
#ifndef ADSL_62
#ifdef HERCULES_ADSL_CPE
DATA_MAP_deILV3_BIS
int16 gsa_EngineFFTInput_Plus[2048] ;
DATA_MAP_END//DATA_MAP_deILV3_BIS
#endif
#endif

// IOP_DS_BisPlus_CNXT_ReduceTxPwrDELT (Start)
#ifndef ISDN   // Only for Anx-A
int8 gc_reduce_txpwr_for_CNXT_delt = 30;
int8 gc_CCOMB1_thrd_for_CNXT_delt = 0x15;
#endif // ifndef ISDN
// IOP_DS_BisPlus_CNXT_ReduceTxPwrDELT (End)

FlagT gft_farEndSISupport;

FlagT gft_EnableSmallerS;  //Enable Smaller S at G992.5x mode, for now it means enable S=1/4

int16 gs_BisToneOrderIntlvDepth;

