/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   gdata_bis_diag.c
*
*  This file contains global variable declarations for
*   bis diagnostics mode and short initialization.
*
*-------------------------------------------------------------------------
*/

// ******************************************************************
// gdata_bis_diag.c
//
// History
//
// 12/08/2011 Vinjam/Kannan: Changed the memory location for "gsa_RxHlogDS[]" (moved to Vr9_1port_debug_data.c file)
//            to get some free space in Bulk data memory.
//            Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
// ******************************************************************

#include <stdio.h>
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "pga_set.h"
#include "ifft_fix.h"
#include "aoc.h"
#include "typedef.h"
#include "typedef_bis.h"
#include "bert.h"
#include "compiler.h"
#include "eoc.h"
#include "ib.h"
#include "const.h"
#include "const_bis.h"
#include "ovhd_bis.h"
#include "rx_ovrhd_bis.h"
#include "data_alloc.h"
#include "spectral_shape_bis.h"
#include "diagparam_bis.h"

BSS_DEILV2_BIS
uint8 guca_RMSG1_LD[14];

BSS_MAP_END//BSS_DEILV2_BIS

DATA_MAP_deILV2_BIS
//LD data can be put into de-interleave memory since no showtime is entered
//Also, those can not be put into BSS-de-interleave, because the compiler
//by default(with current options) put small-size BSS variables into .data.
uint8 *gpuca_RMSG2_LD;
uint8 *gpuca_RMSG6_LD;
uint8 *gpuca_RMSGx_LD;
uint8 *gpuca_R_C_MSG1_LD;
uint8 *gpuca_R_C_MSG2_LD;

uint8 guc_Reverb_Counter;
uint8 guc_R_C_Ack;
uint8 guc_msg_ld_idx_us; /* Indicate which R-MSGx-LD is being transmitted from RT */
FlagT gft_RCAckLDRcvFlag;
uint8 guc_RMsgLDType;

uint8 *gpuca_R_C_MSG3_LD;
uint8 *gpuca_R_C_MSG4_LD;
uint8 *gpuca_R_C_MSG5_LD;
uint8 guc_msg_ld_idx_ds; /* Indicate which C-MSGx-LD is being received at RT */
uint16 guc_msg_seq_num;  /* Indicate the sequence number of received C-MSGx-LD message */

DATA_MAP_END//DATA_MAP_deILV2_BIS

//Leave the following to .data(non-overlay bulk), because they are used by
//both DMT and BIS(gpsa_RxHlin), and in showtime?
// For DIAGNOSTICS_MODE_PARAMS
int16 *gpsa_RxHlin;
LoopDiagParam_t gt_DS_LDParam;
LoopDiagParam_t gt_US_LDParam;

uint16 gus_Hlin_scale;        // scale for gsa_RxHlin
FlagT gft_DiagAfeRxCalibration; // Flag used to indicate that Rx calibration is being done
int16 gs_DiagRxCalibrateConstant;   //Holds constant value used to calibrate Rx AFE filter


DATA_MAP_BIS

/* Global variables for short initialization */

FlagT gft_CComb2_Detected;

DATA_MAP_END//DATA_MAP_BIS

//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
//Moved gsa_RxHlogDS[] to "Vr9_1port_debug_data.c" file to get some free space in Bulk memory
#if 0
// For DIAGNOSTICS_MODE_PARAMS
int16 gsa_RxHlogDS[RX_NUM_TONES>>1];  // 256 words for DS channel transfer function in log domain
#endif
//XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)

