/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*^^^
 *----------------------------------------------------------------------------------
 *
 *  Aware DMT Technology. Proprietary and Confidential.
 *
 *  40 Middlesex Turnpike, Bedford, MA 01730-1413
 *  Phone (781) 276 - 4000
 * Fax   (781) 276 - 4001
 *
 *  Name: spectral_shape_bis.c
 *
 * Description: This file sets initial values for frequency breakpoints and Tssi values
 *
 *----------------------------------------------------------------------------------
 *^^^
 */
// *************************************************************************
// spectral_shape_bis.c
//
// History
// 19/08/2010 AdeelJ/Palaksh/Bhadra: Fix for ADSL2+ low US rates against Intracom CNXT DSLAM.
//               Defined new TSSi US set with flat spectrum starting at tone 2 and
//               higher power in image band for US.
//               This TSSi set will be used in profiles with high target margin.
//               Grep for SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement
//
// 25/01/2012 Sriram Shastry : Upstream CRC's are seen against the Connexant E67.15.1 Co in the Mid range loops.Modified the Tssi index and value to
// reduce the US CRC's.
// Grep for : Enhancement_US_BISPlus_CNXT_USCRC_MidrangeLoops
//
//
// 23/12/2103 Bhadra : Lower US Performance against  Connexant  E67 in the short and Midrange loops. Modified  the Tssi Value such that CO TQD
// trains optimal value. Modified Tssi values . Indicate US Tssi Support in R-CLR(Full CLR) message .Apply during the Training phase [R-Reverb2]. US performance
// improved by 50-100kbps in short and Mid-range loops.
//             Grep for XDSLRTFW-1445:Enhancement_US_BISPlus_CNXT_USPerf_MidrangeLoops
//
// 15/04/2014 ChiWen/Hanyu: Fine tuned US performance against CNXT DSLAMs based on ADSLRTFW-1480 and ADSLRTFW-1591 with the following changes
//  (1) Added special flat US TSSI;
//  (2) Set tone 32 to zero(gusa_US_Tssi_Value[32] = 0);
//  (3) Enabled special flat US TSSI in C-REVERB1/R-REVERB1 (might have influence over the final PGA training);
//  (4) Enabled special flat US TSSI in C-REVERB2;
//  (5) Renamed gft_USPerf_Midloop_Gspn to gft_USPerf_Gspn for all CNXT CO's;
//  (6) Above changes are applied to all CNXT CO/DSLAMs regardless of CO FW versions and controlled by CMV bit4 (MASK 0x0010) of info 103 27
//      that is ENABLED (bit4=1) by default. This is especially recommended at CenturyLink/USA. So far no side effect has been observed.
//  Grep for XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement
//
//  07/02/18: Stefan: XDSLRTFW-2417: INFINEON not used anymore in VR9 ADSL code
//            Re-enable required code under #ifdef INFINEON
//            - KPN specific ADSL Annex-B (oISDN) Tx-spectrum
//            - Nlp = 1
//            grep for XDSLRTFW-2417 #define INFINEON not used anymore in VR9 ADSL code
//
// *************************************************************************
#include "common.h"
#include "spectral_shape_bis.h"
#include "data_alloc.h"

#if defined(DANUBE) || defined(ADSL_62)
DATA_MAP_ILV1_GHS
#else
DATA_BULKO2_BEGIN
#endif

/* ===================================================*/
/* TSSI Information                       */
/* ===================================================*/

/* =====================================================*/
/* These hold US tssi info to be encoded in the CLR      */
/* message based on preferred mode                 */
/* =====================================================*/
#ifndef ISDN
/* G992.3 A/L */
int16 gsa_US_NOMPSD_G9923A[NUM_G992_3A_PSDMASK_SUPPORTED] = {0, 16, 51};
int16 gsa_US_MAXNOMPSD_G9923A[NUM_G992_3A_PSDMASK_SUPPORTED] = {0, 16, 51};
int16 gsa_US_MAXNOMATP_G9923A[NUM_G992_3A_PSDMASK_SUPPORTED] = {0, 0, 0};
uint8 guca_US_TssiIndex_G9923A[NUM_G992_3A_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR] =
{
   {1, 3, 5, 6, 31, 33, 44, 60},
   {1, 3, 5, 6, 24, 26, 40, 58},
   {1, 3, 5, 6, 14, 16, 30, 50}
};
uint8 guca_US_TssiValue_G9923A[NUM_G992_3A_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR] =
{
   {35, 34, 32, 0, 0, 34, 54, 62},
   {35, 34, 32, 0, 0, 34, 57, 65},
   {36, 35, 33, 0, 0, 35, 59, 66}
};
FlagT  gfta_US_SprtSet_G9923A[NUM_G992_3A_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR>>3] =
{
   {0x18},//0, 0, 0, 1, 1, 0, 0, 0},
   {0x18},//0, 0, 0, 1, 1, 0, 0, 0},
   {0x18}//0, 0, 0, 1, 1, 0, 0, 0}
};
/* G992.3/5 I */
int16 gsa_US_NOMPSD_AnnexI[NUM_ANNEX_I_PSDMASK_SUPPORTED] = {0};
int16 gsa_US_MAXNOMPSD_AnnexI[NUM_ANNEX_I_PSDMASK_SUPPORTED] = {0};
int16 gsa_US_MAXNOMATP_AnnexI[NUM_ANNEX_I_PSDMASK_SUPPORTED] = {0};
uint8 guca_US_TssiIndex_AnnexI[NUM_ANNEX_I_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR] =
{
   {1, 3, 5, 6, 31, 33, 44, 60}
};
uint8 guca_US_TssiValue_AnnexI[NUM_ANNEX_I_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR] =
{
   {0, 0, 0, 0, 0, 34, 54, 62}
};
FlagT  gfta_US_SprtSet_AnnexI[NUM_ANNEX_I_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR>>3] =
{
   {0x1F}//1, 1, 1, 1, 1, 0, 0, 0}
};


#else //ISDN
/* G992.3 B */
int16 gsa_US_NOMPSD_G9923B[NUM_G992_3B_PSDMASK_SUPPORTED] = {0};
int16 gsa_US_MAXNOMPSD_G9923B[NUM_G992_3B_PSDMASK_SUPPORTED] = {0};
int16 gsa_US_MAXNOMATP_G9923B[NUM_G992_3B_PSDMASK_SUPPORTED] = {0};
uint8 guca_US_TssiIndex_G9923B[NUM_G992_3B_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR] = {1, 20, 28, 33, 60, 61, 62, 63};
uint8 guca_US_TssiValue_G9923B[NUM_G992_3B_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR] = {58, 54, 0, 0, 0, 33, 34, 35};
FlagT  gfta_US_SprtSet_G9923B[NUM_G992_3B_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR>>3] = {0x18};//0, 0, 0, 1, 1, 0, 0, 0};
// Special AnxB tssi for KPN are defined locally at LinkStart.  Under CMV control these can overwrite the defaults.
#endif//ISDN

/* G992.3/5 M */
int16 gsa_US_NOMPSD_AnnexM[NUM_ANNEX_M_PSDMASK_SUPPORTED] = {0,-5,-10,-14,-18,-21,-24,-27,-30};
int16 gsa_US_MAXNOMPSD_AnnexM[NUM_ANNEX_M_PSDMASK_SUPPORTED] = {0,-5,-10,-14,-18,-21,-24,-27,-30};
int16 gsa_US_MAXNOMATP_AnnexM[NUM_ANNEX_M_PSDMASK_SUPPORTED] = {0,0,0,0,0,0,0,0,0};
uint8 guca_US_TssiIndex_AnnexM[NUM_ANNEX_M_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR] =
{
   {1, 3, 5, 6, 31, 33, 44, 60},
   {1, 3, 5, 6, 35, 37, 44, 60},
   {1, 3, 5, 6, 39, 41, 44, 60},
   {1, 3, 5, 6, 43, 45, 47, 63},
   {1, 3, 5, 6, 47, 49, 51, 63},
   {1, 3, 5, 6, 51, 53, 55, 63},
   {1, 3, 5, 6, 55, 57, 59, 63},
   {1, 3, 5, 6, 59, 61, 62, 63},
   {1, 3, 5, 6, 60, 61, 62, 63}
};
uint8 guca_US_TssiValue_AnnexM[NUM_ANNEX_M_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR] =
{
   {35, 34, 32, 0, 0, 34, 54, 62},
   {35, 34, 32, 0, 0, 34, 54, 62},
   {35, 34, 32, 0, 0, 34, 54, 62},
   {35, 34, 32, 0, 0, 34, 54, 62},
   {35, 34, 32, 0, 0, 34, 54, 62},
   {35, 34, 32, 0, 0, 34, 54, 62},
   {35, 34, 32, 0, 0, 34, 54, 62},
   {35, 34, 32, 0, 0, 34, 54, 62},
   {35, 34, 32, 0, 0, 0, 0, 0}
};
FlagT  gfta_US_SprtSet_AnnexM[NUM_ANNEX_M_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR>>3] =
{
   {0x18},//0, 0, 0, 1, 1, 0, 0, 0},
   {0x18},//{0, 0, 0, 1, 1, 0, 0, 0},
   {0x18},//{0, 0, 0, 1, 1, 0, 0, 0},
   {0x18},//{0, 0, 0, 1, 1, 0, 0, 0},
   {0x18},//{0, 0, 0, 1, 1, 0, 0, 0},
   {0x18},//{0, 0, 0, 1, 1, 0, 0, 0},
   {0x18},//{0, 0, 0, 1, 1, 0, 0, 0},
   {0x18},//{0, 0, 0, 1, 1, 0, 0, 0},
   {0xF8},//{0, 0, 0, 1, 1, 1, 1, 1}
};

#ifndef ISDN
/* G992.5 A */
int16 gsa_US_NOMPSD_G9925A[NUM_G992_5A_PSDMASK_SUPPORTED] = {0};
int16 gsa_US_MAXNOMPSD_G9925A[NUM_G992_5A_PSDMASK_SUPPORTED] = {0};
int16 gsa_US_MAXNOMATP_G9925A[NUM_G992_5A_PSDMASK_SUPPORTED] = {0};
uint8 guca_US_TssiIndex_G9925A[NUM_G992_5A_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR] = {1, 3, 5, 6, 31, 33, 44, 60};
uint8 guca_US_TssiValue_G9925A[NUM_G992_5A_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR] = {35, 34, 32, 0, 0, 34, 54, 62};
FlagT  gfta_US_SprtSet_G9925A[NUM_G992_5A_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR>>3] = {0x18};//{0, 0, 0, 1, 1, 0, 0, 0};

#else//ISDN
/* G992.5 B */
int16 gsa_US_NOMPSD_G9925B[NUM_G992_5B_PSDMASK_SUPPORTED] = {0};
int16 gsa_US_MAXNOMPSD_G9925B[NUM_G992_5B_PSDMASK_SUPPORTED] = {0};
int16 gsa_US_MAXNOMATP_G9925B[NUM_G992_5B_PSDMASK_SUPPORTED] = {0};
uint8 guca_US_TssiIndex_G9925B[NUM_G992_5B_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR] = {1, 20, 28, 33, 60, 61, 62, 63};
uint8 guca_US_TssiValue_G9925B[NUM_G992_5B_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR] = {58, 54, 0, 0, 0, 33, 34, 35};
FlagT  gfta_US_SprtSet_G9925B[NUM_G992_5B_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR>>3] = {0x18};//{0, 0, 0, 1, 1, 0, 0, 0};
// Special AnxB tssi for KPN are defined locally at LinkStart.  Under CMV control these can overwrite the defaults.

/* G992.3/5 J */
int16 gsa_US_NOMPSD_AnnexJ[NUM_ANNEX_J_PSDMASK_SUPPORTED] = {0,-5,-10,-14,-18,-21,-24,-27,-30};
int16 gsa_US_MAXNOMPSD_AnnexJ[NUM_ANNEX_J_PSDMASK_SUPPORTED] = {0,-5,-10,-14,-18,-21,-24,-27,-30};
int16 gsa_US_MAXNOMATP_AnnexJ[NUM_ANNEX_J_PSDMASK_SUPPORTED] = {0,0,0,0,0,0,0,0,0};
uint8 guca_US_TssiIndex_AnnexJ[NUM_ANNEX_J_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR] =
{
   {1, 3, 5, 6, 31, 33, 44, 60},
   {1, 3, 5, 6, 35, 37, 44, 60},
   {1, 3, 5, 6, 39, 41, 44, 60},
   {1, 3, 5, 6, 43, 45, 47, 63},
   {1, 3, 5, 6, 47, 49, 51, 63},
   {1, 3, 5, 6, 51, 53, 55, 63},
   {1, 3, 5, 6, 55, 57, 59, 63},
   {1, 3, 5, 6, 59, 61, 62, 63},
   {1, 3, 5, 6, 60, 61, 62, 63}
};
uint8 guca_US_TssiValue_AnnexJ[NUM_ANNEX_J_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR] =
{
   {0,  0,  0,  0, 0, 34,  54,  62},
   {0,  0,  0,  0, 0, 34,  54,  62},
   {0,  0,  0,  0, 0, 34,  54,  62},
   {0,  0,  0,  0, 0, 34,  54,  62},
   {0,  0,  0,  0, 0, 34,  54,  62},
   {0,  0,  0,  0, 0, 34,  54,  62},
   {0,  0,  0,  0, 0, 34,  54,  62},
   {0,  0,  0,  0, 0, 34,  54,  62},
   {0,  0,  0,  0, 0, 34,  54,  62}
};

FlagT  gfta_US_SprtSet_AnnexJ[NUM_ANNEX_J_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR>>3] =
{
   {0x1F},//{1, 1, 1, 1, 1, 0, 0, 0},
   {0x1F},//{1, 1, 1, 1, 1, 0, 0, 0},
   {0x1F},//{1, 1, 1, 1, 1, 0, 0, 0},
   {0x1F},//{1, 1, 1, 1, 1, 0, 0, 0},
   {0x1F},//{1, 1, 1, 1, 1, 0, 0, 0},
   {0x1F},//{1, 1, 1, 1, 1, 0, 0, 0},
   {0x1F},//{1, 1, 1, 1, 1, 0, 0, 0},
   {0x1F},//{1, 1, 1, 1, 1, 0, 0, 0},
   {0xFF},//{1, 1, 1, 1, 1, 0, 0, 0}

};

#endif//ISDN

DATA_MAP_END //DATA_BULKO2_BEGIN or DATA_MAP_deILV2_BIS
// XDSLRTFW-2417 #define INFINEON not used anymore in VR9 ADSL code
// These should be moved into the same data memory region as the default US Tssi.
// Special tssi defined for KPN (Dutch Telco)
uint8 guca_US_TssiIndex_G9923B_KPN[NUM_US_TSSI_VALUES_INITIAL_CLR] = {1, 20, 29, 33, 57, 61, 62, 63};
uint8 guca_US_TssiValue_G9923B_KPN[NUM_US_TSSI_VALUES_INITIAL_CLR] = {58, 54, 0, 0, 0, 33, 34, 35};
FlagT  gfta_US_SprtSet_G9923B_KPN[NUM_US_TSSI_VALUES_INITIAL_CLR>>3] = {0x1c};//{0, 0, 1, 1, 1, 0, 0, 0};

DATA_MAP_deILV2_BIS
#ifndef ISDN
//SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (START)
// Special US tssi for GSPN Plus
// Enhancement_US_BISPlus_CNXT_USCRC_MidrangeLoops (Start)
uint8 guca_US_TssiIndex_G9925A_GSI_Intracom[NUM_US_TSSI_VALUES_INITIAL_CLR] = {1,   2,  5, 6, 31, 32, 44, 60};
uint8 guca_US_TssiValue_G9925A_GSI_Intracom[NUM_US_TSSI_VALUES_INITIAL_CLR] = {26,  0,  0, 0,  0,  0, 23, 31};
FlagT gfta_US_SprtSet_G9925A_GSI_Intracom[NUM_US_TSSI_VALUES_INITIAL_CLR >> 3] = { 0x18 }; // 0,0,0,1,1,0,0,0
// Enhancement_US_BISPlus_CNXT_USCRC_MidrangeLoops (End)
//SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (END)

//XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement (START)
//Flat US TSSI for CNXT E67
uint8 guca_US_TssiIndex_G9925A_GSI_E67[NUM_US_TSSI_VALUES_INITIAL_CLR] = {1,   2,  5, 6, 31, 33, 44, 60};
uint8 guca_US_TssiValue_G9925A_GSI_E67[NUM_US_TSSI_VALUES_INITIAL_CLR] = {0, 0, 0, 0, 0, 0, 0, 0};
//XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement (END)


// Special US tssi for GSPN Annex L
uint8 guca_US_TssiIndex_G9923L_M1_GSPN[NUM_US_TSSI_VALUES_INITIAL_CLR] = {1, 3, 5, 6, 24, 31, 40, 58};
uint8 guca_US_TssiIndex_G9923L_M2_GSPN[NUM_US_TSSI_VALUES_INITIAL_CLR] = {1, 3, 5, 6, 14, 31, 40, 58};
uint8 guca_US_TssiValue_G9923L_GSPN[NUM_US_TSSI_VALUES_INITIAL_CLR] = {35, 34, 32, 0, 0, 0, 57, 65};
FlagT  gfta_US_SprtSet_G9923L_GSPN[NUM_US_TSSI_VALUES_INITIAL_CLR>>3] = {0x18};//0, 0, 0, 1, 1, 0, 0, 0},
#else
// XDSLRTFW-1867_ADSL2P_AnxB_DONT_Exceed_13.3dBm_Us_Power (START)
// Special tssi defined to not exceed US power limit when boosting US power for XDSLRTFW-772

uint8 guca_US_TssiIndex_G9925B_XDSLRTFW1842[NUM_US_TSSI_VALUES_INITIAL_CLR] = { 1, 23, 32, 33, 51, 52, 62, 63};
uint8 guca_US_TssiValue_G9925B_XDSLRTFW1842[NUM_US_TSSI_VALUES_INITIAL_CLR] = {58, 54,  0,  0,  0, 54, 58, 58};
FlagT  gfta_US_SprtSet_G9925B_XDSLRTFW1842[NUM_US_TSSI_VALUES_INITIAL_CLR>>3] = {0x1c};//{0, 0, 1, 1, 1, 0, 0, 0};
// XDSLRTFW-1867_ADSL2P_AnxB_DONT_Exceed_13.3dBm_Us_Power (END)
#endif
/* =====================================================*/
/* These hold DS tssi info decoded from the CL message   */
/* =====================================================*/
/* G992.3 */
uint16 gusa_DS_TssiIndex_G9923[NUM_G992_3_ANNEX_SUPPORTED][MAX_NUM_DS_TSSI_VALUES];    // Subcarrier index
uint8 guca_DS_TssiValue_G9923[NUM_G992_3_ANNEX_SUPPORTED][MAX_NUM_DS_TSSI_VALUES];     // Log tssi value
FlagT  gfta_DS_SprtSet_G9923[NUM_G992_3_ANNEX_SUPPORTED][MAX_NUM_DS_TSSI_VALUES>>3];      // Indication bit (1: in SUPPORTset; 0: not in SUPPORTset)

/* G992.5 */
uint16 gusa_DS_TssiIndex_G9925[NUM_G992_5_ANNEX_SUPPORTED][MAX_NUM_DS_TSSI_VALUES];    // Subcarrier index
uint8 guca_DS_TssiValue_G9925[NUM_G992_5_ANNEX_SUPPORTED][MAX_NUM_DS_TSSI_VALUES];     // Log tssi value
FlagT  gfta_DS_SprtSet_G9925[NUM_G992_5_ANNEX_SUPPORTED][MAX_NUM_DS_TSSI_VALUES>>3];      // Indication bit (1: in SUPPORTset; 0: not in SUPPORTset)

DATA_MAP_END //DATA_MAP_deILV2_BIS
