/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*  DecodeCMsg1_bis.c
*
*   Code for doing information exchange
*
*-------------------------------------------------------------------------
*/

// ******************************************************************
// DecodeCMsg1_bis.c
//
// History
//
// 16/2/2012 Vinjam: Allow adjusting the target DS margin via CMV/message in ADSL mode.
//           Option to add additional DS margin (additional to what is requested as target margin by the CO).
//           This margin would be added on all tones (i.e. flat). The reported margin must be the real margin
//          (i.e. including the additional margin configured). The goal of the CMV is not margin cheating.
//          This CMV will also be helpful for debugging purposes and it will also allow to decrease the margin
//          (i.e. increase DS performance by sacrificing margin/stability) HERC CMV "OPTN 28" is used for setting deltaTARSNRMds.
//          grep for "XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV" to see the code changes.
//
//08/04/2009 Bhadra: Added code for uinversal ReTx C-Msg1 related changes
//                   Added variables required for DFE<->PPE and cntrs.
//                     Grep for SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod to see changes.
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// 19/06/2012 Ram: Merged "ReTx" related MGMT counters and Test Params code from
//                 ARX ADSL code base (Grep: FEATURE_DS_BisPlus_ALL_ReTx_MGMTCntrs_TestParams)
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 12/11/2013 Sriram Shastry :It  has been observed that link drops in ADSL2p ReTx Mode after 10-15 seconds of show-time.
// The reason for the link drop in short loop under white  noise condition is due to DS Framing  parameter Lp >= 6532.i.e.
// if Lp higher than 6531 we see link drop.In order  to achieve Lp< 6532, firmware  work around  is added
// OneOverSmin (us_SpMinInvers) parameter is restricted 3. By forcing  us_SpMinInvers to 3 we get similar DS rate to
// Geminax CO in ReTx mode.Against Geminax we receive OneOverSmin(us_SpMinInvers)  parameter as 3.But against Broadcom
// CO we receive  8 (us_SpMinInvers).
//          Grep for "XDSLRTFW :1251 IOP_DS_Plus_BRCM_Force_OneOverSmin3"
//
// 05/09/2014 Ram: Removed the workaround for the issue "ADSL ReTX link drop when DS NDR > 26 Mbps". Fix for the root
//                 cause (not enough memory given to LP1 section in DTB) is added in file zep_memmap_cnfg.h
//                 Grep for: XDSLRTFW-1381
//
// ******************************************************************

#include "common.h"
#include "typedef_bis.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "rinfo_bis.h"
#include "cmv.h"
#include "trail.h"

// Temp debug flag to allow us to force max SNRM to infinity.
FlagT gft_SetSnrmInfinite = 0;
/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       int16 DecodCMsg1_BIS(void);
*
*   Abstract:
*       Decode C_MSG1 message received from ATU-C
*
*   Input Parameters:
*     none
*
*  Return:
*     Error Code:
*        NO_DECODE_ERROR            -- no error
*
*  Global Variables:
*     guca_R_C_Msgs1_bis   -- (I) packed C_MSGS1 received from ATU-C
*     gt_RCMsgs1_bis    -- (O) structure containing decoded C_MSGS1 messages
*
*-----------------------------------------------------------------------------
^^^*/

int16 DecodCMsg1_BIS(void)
{
   int16 s_error_code = NO_DECODE_ERROR_BIS;
   int16 snr_margin, i;
   int32 temp;
   uint16 us_margin;


//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod Begin
#ifdef UNV_RETX_MSGS
   int16 idx;
   uint8 uc_temp;
   uint32 ul_delay_sym; //FEATURE_ALL_BisPlus_ALL_Univ_Retx_DEF_PPE_Changes (Start_End)
   uint16 us_sym_frac = 0;
#endif
//SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
   /* Decode C_MSGS1 */

   /* PMD-TC parameters */
   /* m0 to m8, Targt noise margin with 0.1dB step size */
   gt_RCMsgs1_bis.us_TARSNRMds = (((guca_R_C_Msgs1_bis[1] & 0x1) << 8) | guca_R_C_Msgs1_bis[0]);

    //XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (Start_End)
    gt_RCMsgs1_bis.us_TARSNRMds += OPTNArray[OPTN_DesiredMarginAdjust];       //in 0.1dB granularity

   temp = (int32)gt_RCMsgs1_bis.us_TARSNRMds << 8;
    snr_margin = (int16)(temp/10);

   gs_RxDesiredMargin = snr_margin; /* desired SNR margin in Q8.8 format */
    //XDSLRTFW-310 Improve_BisPlus_DS_All_AdjustTargetMarginThroughCMV (Start_End)
    //gs_RxDesiredMargin += gs_RxDesiredMargin_Delta_bis; //Moved to HERC CMV OPTN 28

   /* m16 to m24, Minimum noise margin with 0.1dB step size */
   gt_RCMsgs1_bis.us_MINSNRMds = (( ((uint16)(guca_R_C_Msgs1_bis[3] & 0x1)) << 8) | guca_R_C_Msgs1_bis[2]);
   gs_RxMinRequestedSTMargin = gt_RCMsgs1_bis.us_MINSNRMds/10 ;

   /* m32 to m40, Maximum noise margin with 0.1dB step size */
   gt_RCMsgs1_bis.us_MAXSNRMds = (( ((uint16)(guca_R_C_Msgs1_bis[5] & 0x1)) << 8) | guca_R_C_Msgs1_bis[4]);

   if ((gt_RCMsgs1_bis.us_MAXSNRMds == 511) || (gft_SetSnrmInfinite != 0))
   {
      // Special code meaning no max margin, so set to huge value(100dB).
      gt_RCMsgs1_bis.us_MAXSNRMds = 1000;
   }

   /* m48 to m49, rate adaptation mode */
   gt_RCMsgs1_bis.us_RA_MODEds = (guca_R_C_Msgs1_bis[6] & 0x3);

   /* m56 to m57, power management mode */
   gt_RCMsgs1_bis.us_PM_Mode = (guca_R_C_Msgs1_bis[7] & 0x3);

   /* m64 to m72, rate adaptation upshift noise margin */
   gt_RCMsgs1_bis.us_RA_USNRMds = (((guca_R_C_Msgs1_bis[9] & 0x1) << 8) | guca_R_C_Msgs1_bis[8]);

   /* m80 to m88, rate adaptation upshift time interval */
   gt_RCMsgs1_bis.us_RA_UTIMEds = (((guca_R_C_Msgs1_bis[11] & 0x3F) << 8) | guca_R_C_Msgs1_bis[10]);

   /* m96 to m104, rate adaptation downshift noise margin */
   gt_RCMsgs1_bis.us_RA_DSNRMds = (((guca_R_C_Msgs1_bis[13] & 0x1) << 8) | guca_R_C_Msgs1_bis[12]);

   /* m112 to m125, rate adaptation downshift time interval */
   gt_RCMsgs1_bis.us_RA_DTIMEds = (((guca_R_C_Msgs1_bis[15] & 0x3F) << 8) | guca_R_C_Msgs1_bis[14]);

   //check auto SRA condition
   //1. RA mode is 3
   //2. MaxMargin >= UpShiftMargin >= targetMargin >= DownshiftMargin >= MinMargin
   if ((gt_RCMsgs1_bis.us_RA_MODEds == 3)
      && (gt_RCMsgs1_bis.us_MAXSNRMds >= gt_RCMsgs1_bis.us_RA_USNRMds)
      && (gt_RCMsgs1_bis.us_RA_USNRMds >= gt_RCMsgs1_bis.us_TARSNRMds)
      && (gt_RCMsgs1_bis.us_TARSNRMds >= gt_RCMsgs1_bis.us_RA_DSNRMds)
      && (gt_RCMsgs1_bis.us_RA_DSNRMds >= gt_RCMsgs1_bis.us_MINSNRMds))
   {
      gft_AutoSRA_ErrorCondition = FALSE;
   }
   else
      gft_AutoSRA_ErrorCondition = TRUE;

   //Converted the upshift and downshift margins in Q8.8 formats.
   //In C-MSG1 its represented in 0.1dB resolution, as 318 for 31.8
   us_margin = gt_RCMsgs1_bis.us_RA_DSNRMds;
   gt_RCMsgs1_bis.us_RA_DSNRMds = (us_margin<<8)/10;

   us_margin = gt_RCMsgs1_bis.us_RA_USNRMds;
   gt_RCMsgs1_bis.us_RA_USNRMds = (us_margin<<8)/10;

   /* m128 to m131, max number of bits per sub carrier, >=8 and <= 15 */
   gt_RCMsgs1_bis.us_MaxBitsPerTone = (guca_R_C_Msgs1_bis[16] & 0xF);

   if((gt_RCMsgs1_bis.us_MaxBitsPerTone < 8) || (gt_RCMsgs1_bis.us_MaxBitsPerTone > 15))
      s_error_code = MAX_BITS_PER_TONE_ERROR_BIS;

   /* Set the maximum number of bits per tone allocated to DS channel */
    if(gt_RCMsgs1_bis.us_MaxBitsPerTone < (uint16)guc_Log2MaxConstSize)
      guc_MaxAllocBitsPerTone = (uint8)gt_RCMsgs1_bis.us_MaxBitsPerTone;
   else
      guc_MaxAllocBitsPerTone = guc_Log2MaxConstSize;

   /* m136 to m143, max extension of gi range supported, >=0 and <= (MAXPSDds - NOMPSDds) */
   gt_RCMsgs1_bis.us_EXTGIds = guca_R_C_Msgs1_bis[17];

   /* m144 to m149, minimum length of the R_MEDLEY state */
   gt_RCMsgs1_bis.uc_CA_MEDLEYus = (guca_R_C_Msgs1_bis[18] & 0x3F);

   /* m152 to m159: reserved( eight 0 bits) for both bis and plus */
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod Strat
#ifdef UNV_RETX_MSGS
   idx = 20;
#endif
//SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
   if ((gl_SelectedMode & (MODE_G992_5)))
   {
      if (gft_DS_Windowing == TRUE)
      {
         /* m160 to m288, ds windowing samples */
         for (i = 0; i < (gs_RxNumTones >> 6); i++)
         {
            gt_RCMsgs1_bis.sa_DSWindow[i] =
               ((guca_R_C_Msgs1_bis[21 + (2 * i)] << 8) |
                guca_R_C_Msgs1_bis[20 + 2 * i]);
            idx +=2; //SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod (Start_End) //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START_END)
         }
      }
   }

   /* m160 to m191: PMS-TC parameters */

   /* m160 to m166, RATIO_BCds0 */

    /* m168 to m174, RATIO_BCds1 */

   /* m176 to m182, RATIO_BCds2 */

    /* m184 to m190, RATIO_BCds3 */
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
// SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod Begin
#ifdef UNV_RETX_MSGS

   if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
   {
   //PMS-TC parameters
      //DTU framing type with CRC-8
      //gt_ReTxConfigInfo.uc_CMSG1_Framing = guca_R_C_Msgs1_bis[idx++] & (0x3);
   idx++;
      uc_temp = guca_R_C_Msgs1_bis[idx++];
      //half roundtrip  delay s symbols
      gt_ReTxConfigInfo.us_s_CO = uc_temp & (0xF);
      //half roundtrip  delay d DTUs
      gt_ReTxConfigInfo.us_d_CO = (uc_temp >>4) & (0x3);
      //(1/S1min)-1. (add 1 for 1/S1min )
      uc_temp = guca_R_C_Msgs1_bis[idx++];

      gt_ReTxConfigInfo.us_SpMinInvers = (uc_temp & 0xF)+1;

      //XDSLRTFW-XDSLRTFW-1381 (Start)
      // Work Around : Force 1/Smin = 3, Due to  Non Convergence of 1/Smin = 8. Lp>=6532 onwards we see the BADDtu and Link drop at Null Loop .
   // Firmware bit-load is fine, its seems that RS-Decoder is unable to handle Lp>=6532.  [Zephyr configuration above Lp>6532 ]. Impact of the
   // work around is, DS Rate lowered by apprx 2Mbps [@Null Loop].But  we see stable show-time link.
   // XDSLRTFW :1251 IOP_DS_Plus_BRCM_Force_OneOverSmin3(Start)
   //if ((gs_CurrentCoChipset == BDCM_CO_CHIPSET) && ((gl_SelectedMode == (MODE_G992_5 | ANNEX_A))) && (gt_ReTxConfigInfo.us_SpMinInvers > 3)){
         //gt_ReTxConfigInfo.us_SpMinInvers = 3;               // hardCoded to 3.
   //}
   // XDSLRTFW :1251 IOP_DS_Plus_BRCM_Force_OneOverSmin3(End)
      //XDSLRTFW-XDSLRTFW-1381 (Stop)

      if ((gl_SelectedMode & (MODE_G992_5)))
      {
         //RTmemMax is 12000(bit7 is 1)/8001(bit7 is 0); in ADSL2p cases
         gt_ReTxConfigInfo.ft_adsl2p_flag = (uc_temp >> 7) & 0x1;
      }
            //RTmemMax is 8001; in ADSL2 cases
      else   gt_ReTxConfigInfo.ft_adsl2p_flag = 0;

      //TPS-TC parameters
      // min. throughput in 8kbit/s steps
      gt_ReTxConfigInfo.us_ETR_min = guca_R_C_Msgs1_bis[idx++];
      gt_ReTxConfigInfo.us_ETR_min |= (guca_R_C_Msgs1_bis[idx++] << 8);
      // convert to kbps
      gt_ReTxConfigInfo.us_ETR_min <<= 3;
      // max. throughput in 8kbit/s steps
      gt_ReTxConfigInfo.us_ETR_max = guca_R_C_Msgs1_bis[idx++];
      gt_ReTxConfigInfo.us_ETR_max |= (guca_R_C_Msgs1_bis[idx++] << 8);
      // convert to kbps
      gt_ReTxConfigInfo.us_ETR_max <<= 3;
      // net max in 8kbit/s steps
      gt_ReTxConfigInfo.us_net_max = guca_R_C_Msgs1_bis[idx++];
      gt_ReTxConfigInfo.us_net_max |= (guca_R_C_Msgs1_bis[idx++] << 8);
      // convert to kbps
      gt_ReTxConfigInfo.us_net_max <<= 3;

      //(INP_min) expressed in DMT symbols.
      gt_ReTxConfigInfo.us_INP_min = (guca_R_C_Msgs1_bis[idx++]& 0x3F);

      //SHINEratio expressed in unit of 0.001.
      gt_ReTxConfigInfo.us_SHINEratio = guca_R_C_Msgs1_bis[idx++];

      uc_temp = guca_R_C_Msgs1_bis[idx++];
      //minimal impulse noise protection against REIN of the downstream bearer #0
      // in DMT symbols
      gt_ReTxConfigInfo.us_INP_min_rein = (uc_temp & 0x7);
      //periodicity of REIN(0, is the periodicity of REIN is 100Hz.)
      //1, the periodicity of REIN is 120Hz
      gt_ReTxConfigInfo.ft_ia_rein_flag = ((uc_temp >> 4) & 0x1);

      //maximum delay of the downstream bearer #0
      gt_ReTxConfigInfo.us_delay_max = (guca_R_C_Msgs1_bis[idx++]& 0x3F);
      //minimum delay of the downstream bearer #0
      gt_ReTxConfigInfo.us_delay_min = (guca_R_C_Msgs1_bis[idx]& 0x3F);

      // XDSLRTFW-2604
      if (gt_ReTxConfigInfo.us_delay_min > 0)
      {
         gt_ReTxConfigInfo.us_delay_min = 0;
      }
      // XDSLRTFW-2604

      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
      //SMS01443403 :FEATURE_DS_BisPlus_ALL_ReTx_MGMTCntrs_TestParams (Start)
      // Actual delay in ms as per new changes
      guc_delay_act_RETX = gt_ReTxConfigInfo.us_delay_min;
      //SMS01443403 :FEATURE_DS_BisPlus_ALL_ReTx_MGMTCntrs_TestParams (End)
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)
      //FEATURE_ALL_BisPlus_ALL_Univ_Retx_DEF_PPE_Changes Start
      //convert to symbols and copy to PPE<->DFE shared memory
      //FEATURE_DS_BisPlus_ALL_ReTxCMSG1_New (Start)
      if(gt_ReTxConfigInfo.s_CMSG1_CI_LeftrThresh == 1)
      {
         idx++;
         //Leftr threshold value for Downstream bearer #0
         //FEATURE_DS_BisPlus_ALL_ReTxCMSG1_Leftr_Thresh (Start_End)
         gt_ReTxConfigInfo.us_leftr_thresh =(guca_R_C_Msgs1_bis[idx++] & 0x7F);
         //CI policy for downstream bearer #0
         gt_ReTxConfigInfo.us_CIP =(guca_R_C_Msgs1_bis[idx]& 0x3);
         //SMS01436310:FEATURE_DS_BisPlus_ALL_ReTx_CIP_Zero_Only Start
         if(gt_ReTxConfigInfo.us_CIP != 0)
         {
            gt_ReTxConfigInfo.us_parameter2 = gt_ReTxConfigInfo.us_CIP;// Just for Debug
            gt_ReTxConfigInfo.us_CIP = 0;
         }
         //SMS01436310:FEATURE_DS_BisPlus_ALL_ReTx_CIP_Zero_Only End
      }
      //FEATURE_DS_BisPlus_ALL_ReTxCMSG1_New (End)

      //SMS01443403 :FEATURE_DS_BisPlus_ALL_ReTx_MGMTCntrs_TestParams (Start)
      ul_delay_sym = gt_ReTxConfigInfo.us_delay_max << 2;
      ul_delay_sym *= 0x40f0; //0x40f0 is 69/68 in 2.14 format;
      us_sym_frac = (ul_delay_sym & 0x3fff);
      ul_delay_sym >>= 14;
      //Ceil to integer part
      if(us_sym_frac)
         ul_delay_sym +=1;
      ul_delay_sym += gt_ReTxConfigInfo.s_delay_offset;
#if 0
      gpt_ReTxXmemConfigInfo->ul_MaxDELAYrt = ul_delay_sym;
#endif
      //convert to symbols and copy to PPE<->DFE shared memory
      ul_delay_sym = gt_ReTxConfigInfo.us_delay_min << 2;
      ul_delay_sym *= 0x40f0; //0x40f0 is 69/68 in 2.14 format;
      us_sym_frac = (ul_delay_sym & 0x3fff);
      ul_delay_sym >>= 14;
      //Ceil to integer part
      if(us_sym_frac)
         ul_delay_sym +=1;
      //ul_delay_sym += gt_ReTxConfigInfo.s_delay_offset;
#if 0
      gpt_ReTxXmemConfigInfo->ul_MinDelayrt = ul_delay_sym;
      gul_prev_RxReTxDtuUncorr = gpt_ReTxXmemConfigInfo->ul_RxReTxDtuUncorrectedCNT;
      gpt_ReTxXmemConfigInfo->ul_ReTxXmemData_Rdy = 1;
#endif
      //SMS01443403 :FEATURE_DS_BisPlus_ALL_ReTx_MGMTCntrs_TestParams (End)

   }

#endif
//SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
   return (s_error_code);
}

