/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   DecodeCMsgFmt_bis.c
*
*   Code for doing information exchange
*
*-------------------------------------------------------------------------
*/
// ******************************************************************
// DecodeCMsgFmt_bis.c
//
// History
//
//
//
// 01/09/2010 Vinjam: Enabled flag to extract the C-BLOACK out bits in
//          LDM (DELT) mode. This is required to extract the virtual noise break points in LDM mode.
//          Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
//
// 29/5/2013 Patil/Vinjam: Fixed a bug which causing lower data rates in LDM
//            Force enabling of the flag to extract the C-BLACK out bits in  LDM mode only when
//            virtual noise enabled, as this is intended only for DS virtual noise feature in LDM mode.
//       If we force it irrespecive of virtual noise feature enabled, it was causing the misbehaviour
//       resulting in less US rate.
//          Grep for XDSLRTFW-894 BugFix_US_BisPlus_ALL_LessUsRateLdm
// ******************************************************************

#include "common.h"
#include "typedef_bis.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "rinfo_bis.h"
#include "cmv.h"
#include "trail.h"

/*^^^
*-----------------------------------------------------------------------------
*
*   Prototype:
*       void DecodCMsgFmt_BIS(void);
*
*   Abstract:
*       Decode C_MSG_FMT message received from ATU-C
*
*   Input Parameters:
*     none
*
*  Return:
*     none
*
*  Global Variables:
*     guca_RCMsgFMTTab  -- (I) packed C_MSG_FMT received from ATU-C
*     gt_RCMsgFmt_bis      -- (O) structure containing decoded C_MSG_FMT messages
*
*-----------------------------------------------------------------------------
^^^*/

void DecodCMsgFmt_BIS(void)
{

   uint16 us_NumOfDsVnBreakPoints = 0;

   gt_RCMsgFmt_bis.us_FMT_R_REVERB1 = (guca_RCMsgFMTTab[0] & 0x01);
// gt_RCMsgFmt_bis.us_FMT_C_MSG1 = ((guca_RCMsgFMTTab[0] >> 1) & 0x01);
   gt_RCMsgFmt_bis.us_FMT_C_REVERB4 = ((guca_RCMsgFMTTab[0] >> 2) & 0x01);

   /* Check if extended C-REVERB4 is needed */
   if((gt_RCMsgFmt_bis.us_FMT_C_REVERB4)
   || (guc_RT_FMT_C_REVERB4 ==1)
   || (STATArray[STAT_MacroState] == STAT_LoopDiagMode))
      gs_RCReverb4_rx_len_bis = 1024;
   else
      gs_RCReverb4_rx_len_bis = 256;

   // This is a work around for DLI problem found in Socrates connectivity test with
   // Clocks on. The detail of DLI problem is that:"the DLI cannot handle it when
   // there's a large number of frames between when the US and DS cyclic prefixes
   // are turned on.  The DLI was designed with the assumption that the prefixes
   // are turned on at the same time in the US and DS paths" (from Todd). This problem
   // can cause US data not correctly extracted from DLI by CO.
// if (STATArray[STAT_MacroState] != STAT_LoopDiagMode)
//    gs_RCReverb4_rx_len_bis += 21;


    // This is a work around for DLI problem found in diagnostics mode connectivity test.
   // Adjust the length of R-Reverb4 such that the ends of C-SEGUE1 and R-SEGUE1 conincide
   // at CO side for diagnostics mode conn test. The following part is only included in Cococmo.

#ifdef WIN32
   if (STATArray[STAT_MacroState] == STAT_LoopDiagMode)
      gs_RCReverb4_rx_len_bis -= 19;
#endif


   gt_RCMsgFmt_bis.us_FMT_R_QUIET4 = ((guca_RCMsgFMTTab[0] >> 3) & 0x1F);
    gt_RCMsgFmt_bis.us_FMT_C_MSG_PCB = (guca_RCMsgFMTTab[1] & 0x01);

   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START_END)
   // XDSLRTFW-894 BugFix_US_BisPlus_ALL_LessUsRateLdm (Start)
   us_NumOfDsVnBreakPoints = gt_DS_RefVirtNoiseLevel_ADSL2.us_NumberOfTones;
   if ((STATArray[STAT_MacroState] == STAT_LoopDiagMode) && (us_NumOfDsVnBreakPoints > 0))
     gt_RCMsgFmt_bis.us_FMT_C_MSG_PCB = 1;
   // XDSLRTFW-894 BugFix_US_BisPlus_ALL_LessUsRateLdm (End)


   if (( gl_SelectedMode & (MODE_G992_5)  ))
   {
      gt_RCMsgFmt_bis.us_FMT_C_MSG1 = ((guca_RCMsgFMTTab[1] >> 1) & 0x01);

      if (gt_RCMsgFmt_bis.us_FMT_C_MSG1 == 1)
         gft_DS_Windowing = TRUE;
      else
         gft_DS_Windowing = FALSE;

   gt_RCMsgFmt_bis.uc_MedleyPRBSds  = ((guca_RCMsgFMTTab[1] >> 2) & 0x01);

   }

}

